# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.176.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from typing import Optional, Union
from pydantic import BaseModel, Field, StrictStr, confloat, conint
from empire_platform_api_public_client.models.attachment import Attachment
from empire_platform_api_public_client.models.invoice_participant_details import InvoiceParticipantDetails
from empire_platform_api_public_client.models.invoice_status import InvoiceStatus

class Invoice(BaseModel):
    """
    Invoice
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    display_id: StrictStr = Field(..., alias="displayId")
    participant: InvoiceParticipantDetails = Field(...)
    net_amount: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="netAmount", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    gross_amount: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="grossAmount", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    due_date: Optional[date] = Field(None, alias="dueDate", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    status: InvoiceStatus = Field(...)
    last_status_change: datetime = Field(..., alias="lastStatusChange", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    attachment: Optional[Attachment] = None
    __properties = ["id", "displayId", "participant", "netAmount", "grossAmount", "dueDate", "status", "lastStatusChange", "attachment"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Invoice:
        """Create an instance of Invoice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of participant
        if self.participant:
            _dict['participant'] = self.participant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of attachment
        if self.attachment:
            _dict['attachment'] = self.attachment.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Invoice:
        """Create an instance of Invoice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Invoice.parse_obj(obj)

        _obj = Invoice.parse_obj({
            "id": obj.get("id"),
            "display_id": obj.get("displayId"),
            "participant": InvoiceParticipantDetails.from_dict(obj.get("participant")) if obj.get("participant") is not None else None,
            "net_amount": obj.get("netAmount"),
            "gross_amount": obj.get("grossAmount"),
            "due_date": obj.get("dueDate"),
            "status": obj.get("status"),
            "last_status_change": obj.get("lastStatusChange"),
            "attachment": Attachment.from_dict(obj.get("attachment")) if obj.get("attachment") is not None else None
        })
        return _obj

