# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.176.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from empire_platform_api_public_client.models.bidding_configuration_secondary_market_notices import BiddingConfigurationSecondaryMarketNotices
from empire_platform_api_public_client.models.bidding_configuration_values_inner import BiddingConfigurationValuesInner

class BiddingConfiguration(BaseModel):
    """
    BiddingConfiguration
    """
    values: conlist(BiddingConfigurationValuesInner) = Field(...)
    secondary_market_notices: BiddingConfigurationSecondaryMarketNotices = Field(..., alias="secondaryMarketNotices")
    __properties = ["values", "secondaryMarketNotices"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BiddingConfiguration:
        """Create an instance of BiddingConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in values (list)
        _items = []
        if self.values:
            for _item in self.values:
                if _item:
                    _items.append(_item.to_dict())
            _dict['values'] = _items
        # override the default output from pydantic by calling `to_dict()` of secondary_market_notices
        if self.secondary_market_notices:
            _dict['secondaryMarketNotices'] = self.secondary_market_notices.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BiddingConfiguration:
        """Create an instance of BiddingConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BiddingConfiguration.parse_obj(obj)

        _obj = BiddingConfiguration.parse_obj({
            "values": [BiddingConfigurationValuesInner.from_dict(_item) for _item in obj.get("values")] if obj.get("values") is not None else None,
            "secondary_market_notices": BiddingConfigurationSecondaryMarketNotices.from_dict(obj.get("secondaryMarketNotices")) if obj.get("secondaryMarketNotices") is not None else None
        })
        return _obj

