# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.176.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Union
from pydantic import BaseModel, Field, StrictInt, confloat, conint
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.mtu_period import MtuPeriod

class AggregatedAllocatedAuction(BaseModel):
    """
    AggregatedAllocatedAuction
    """
    timescale: AuctionTimescale = Field(...)
    auction_count: conint(strict=True, ge=0) = Field(..., alias="auctionCount", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    product_type_count: conint(strict=True, ge=0) = Field(..., alias="productTypeCount", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    border_direction: BorderDirection = Field(..., alias="borderDirection")
    delivery_period: MtuPeriod = Field(..., alias="deliveryPeriod")
    participant_requested_count: conint(strict=True, ge=0) = Field(..., alias="participantRequestedCount", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    participant_allocated_count: conint(strict=True, ge=0) = Field(..., alias="participantAllocatedCount", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    offered_capacity: StrictInt = Field(..., alias="offeredCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    total_requested_capacity: StrictInt = Field(..., alias="totalRequestedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    total_allocated_capacity: StrictInt = Field(..., alias="totalAllocatedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    average_clearing_price: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="averageClearingPrice", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    __properties = ["timescale", "auctionCount", "productTypeCount", "borderDirection", "deliveryPeriod", "participantRequestedCount", "participantAllocatedCount", "offeredCapacity", "totalRequestedCapacity", "totalAllocatedCapacity", "averageClearingPrice"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AggregatedAllocatedAuction:
        """Create an instance of AggregatedAllocatedAuction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of delivery_period
        if self.delivery_period:
            _dict['deliveryPeriod'] = self.delivery_period.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AggregatedAllocatedAuction:
        """Create an instance of AggregatedAllocatedAuction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AggregatedAllocatedAuction.parse_obj(obj)

        _obj = AggregatedAllocatedAuction.parse_obj({
            "timescale": obj.get("timescale"),
            "auction_count": obj.get("auctionCount"),
            "product_type_count": obj.get("productTypeCount"),
            "border_direction": obj.get("borderDirection"),
            "delivery_period": MtuPeriod.from_dict(obj.get("deliveryPeriod")) if obj.get("deliveryPeriod") is not None else None,
            "participant_requested_count": obj.get("participantRequestedCount"),
            "participant_allocated_count": obj.get("participantAllocatedCount"),
            "offered_capacity": obj.get("offeredCapacity"),
            "total_requested_capacity": obj.get("totalRequestedCapacity"),
            "total_allocated_capacity": obj.get("totalAllocatedCapacity"),
            "average_clearing_price": obj.get("averageClearingPrice")
        })
        return _obj

