# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.176.3
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field, StrictStr, conint, conlist

from typing import List, Optional

from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.create_secondary_market_day_ahead_or_intra_day_noticeboard_entry import CreateSecondaryMarketDayAheadOrIntraDayNoticeboardEntry
from empire_platform_api_public_client.models.create_secondary_market_day_ahead_or_intra_day_noticeboard_response import CreateSecondaryMarketDayAheadOrIntraDayNoticeboardResponse
from empire_platform_api_public_client.models.create_secondary_market_day_ahead_or_intra_day_transfer_request import CreateSecondaryMarketDayAheadOrIntraDayTransferRequest
from empire_platform_api_public_client.models.create_secondary_market_long_term_noticeboard_entry import CreateSecondaryMarketLongTermNoticeboardEntry
from empire_platform_api_public_client.models.create_secondary_market_long_term_noticeboard_response import CreateSecondaryMarketLongTermNoticeboardResponse
from empire_platform_api_public_client.models.create_secondary_market_long_term_transfer_request import CreateSecondaryMarketLongTermTransferRequest
from empire_platform_api_public_client.models.create_secondary_market_return_request import CreateSecondaryMarketReturnRequest
from empire_platform_api_public_client.models.created_secondary_market_day_ahead_or_intra_day_noticeboard_entry import CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardEntry
from empire_platform_api_public_client.models.created_secondary_market_day_ahead_or_intra_day_noticeboard_response import CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardResponse
from empire_platform_api_public_client.models.created_secondary_market_day_ahead_or_intra_day_transfer_request import CreatedSecondaryMarketDayAheadOrIntraDayTransferRequest
from empire_platform_api_public_client.models.created_secondary_market_long_term_noticeboard_entry import CreatedSecondaryMarketLongTermNoticeboardEntry
from empire_platform_api_public_client.models.created_secondary_market_long_term_noticeboard_response import CreatedSecondaryMarketLongTermNoticeboardResponse
from empire_platform_api_public_client.models.created_secondary_market_long_term_transfer_request import CreatedSecondaryMarketLongTermTransferRequest
from empire_platform_api_public_client.models.created_secondary_market_return_request_identifier import CreatedSecondaryMarketReturnRequestIdentifier
from empire_platform_api_public_client.models.noticeboard_entry_type_with_both import NoticeboardEntryTypeWithBoth
from empire_platform_api_public_client.models.secondary_market_day_ahead_or_intra_day_noticeboard_entry import SecondaryMarketDayAheadOrIntraDayNoticeboardEntry
from empire_platform_api_public_client.models.secondary_market_day_ahead_or_intra_day_noticeboard_options import SecondaryMarketDayAheadOrIntraDayNoticeboardOptions
from empire_platform_api_public_client.models.secondary_market_day_ahead_or_intra_day_noticeboard_response_options import SecondaryMarketDayAheadOrIntraDayNoticeboardResponseOptions
from empire_platform_api_public_client.models.secondary_market_day_ahead_or_intra_day_transfer_request import SecondaryMarketDayAheadOrIntraDayTransferRequest
from empire_platform_api_public_client.models.secondary_market_day_ahead_or_intra_day_transfer_request_options import SecondaryMarketDayAheadOrIntraDayTransferRequestOptions
from empire_platform_api_public_client.models.secondary_market_long_term_noticeboard_entry import SecondaryMarketLongTermNoticeboardEntry
from empire_platform_api_public_client.models.secondary_market_long_term_noticeboard_options import SecondaryMarketLongTermNoticeboardOptions
from empire_platform_api_public_client.models.secondary_market_long_term_noticeboard_response_options import SecondaryMarketLongTermNoticeboardResponseOptions
from empire_platform_api_public_client.models.secondary_market_long_term_transfer_request_options import SecondaryMarketLongTermTransferRequestOptions
from empire_platform_api_public_client.models.secondary_market_noticeboard_entry_batch import SecondaryMarketNoticeboardEntryBatch
from empire_platform_api_public_client.models.secondary_market_return_request_batch import SecondaryMarketReturnRequestBatch
from empire_platform_api_public_client.models.secondary_market_transfer_request import SecondaryMarketTransferRequest
from empire_platform_api_public_client.models.secondary_market_transfer_request_batch import SecondaryMarketTransferRequestBatch
from empire_platform_api_public_client.models.secondary_market_transfer_request_type import SecondaryMarketTransferRequestType
from empire_platform_api_public_client.models.source_auction import SourceAuction

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SecondaryMarketApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def accept_secondary_market_transfer_request(self, id : Annotated[StrictStr, Field(..., description="Transfer request identifier")], **kwargs) -> None:  # noqa: E501
        """accept_secondary_market_transfer_request  # noqa: E501

        Accept a specified Transfer Request, if allowed in the current state  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `ACCEPT_SECONDARY_MARKET_TRANSFER_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.accept_secondary_market_transfer_request(id, async_req=True)
        >>> result = thread.get()

        :param id: Transfer request identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the accept_secondary_market_transfer_request_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.accept_secondary_market_transfer_request_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def accept_secondary_market_transfer_request_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Transfer request identifier")], **kwargs) -> ApiResponse:  # noqa: E501
        """accept_secondary_market_transfer_request  # noqa: E501

        Accept a specified Transfer Request, if allowed in the current state  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `ACCEPT_SECONDARY_MARKET_TRANSFER_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.accept_secondary_market_transfer_request_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Transfer request identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method accept_secondary_market_transfer_request" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/secondary-market/transfer-requests/{id}/accept', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_day_ahead_or_intra_day_secondary_market_noticeboard_entry(self, create_secondary_market_day_ahead_or_intra_day_noticeboard_entry : CreateSecondaryMarketDayAheadOrIntraDayNoticeboardEntry, **kwargs) -> CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardEntry:  # noqa: E501
        """create_day_ahead_or_intra_day_secondary_market_noticeboard_entry  # noqa: E501

        Create a new Day Ahead or Intra Day Noticeboard Entry  Feature flag:   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_DA_OR_ID_SECONDARY_MARKET_NOTICEBOARD_ENTRY`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_day_ahead_or_intra_day_secondary_market_noticeboard_entry(create_secondary_market_day_ahead_or_intra_day_noticeboard_entry, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_day_ahead_or_intra_day_noticeboard_entry: (required)
        :type create_secondary_market_day_ahead_or_intra_day_noticeboard_entry: CreateSecondaryMarketDayAheadOrIntraDayNoticeboardEntry
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardEntry
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_day_ahead_or_intra_day_secondary_market_noticeboard_entry_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_day_ahead_or_intra_day_secondary_market_noticeboard_entry_with_http_info(create_secondary_market_day_ahead_or_intra_day_noticeboard_entry, **kwargs)  # noqa: E501

    @validate_arguments
    def create_day_ahead_or_intra_day_secondary_market_noticeboard_entry_with_http_info(self, create_secondary_market_day_ahead_or_intra_day_noticeboard_entry : CreateSecondaryMarketDayAheadOrIntraDayNoticeboardEntry, **kwargs) -> ApiResponse:  # noqa: E501
        """create_day_ahead_or_intra_day_secondary_market_noticeboard_entry  # noqa: E501

        Create a new Day Ahead or Intra Day Noticeboard Entry  Feature flag:   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_DA_OR_ID_SECONDARY_MARKET_NOTICEBOARD_ENTRY`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_day_ahead_or_intra_day_secondary_market_noticeboard_entry_with_http_info(create_secondary_market_day_ahead_or_intra_day_noticeboard_entry, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_day_ahead_or_intra_day_noticeboard_entry: (required)
        :type create_secondary_market_day_ahead_or_intra_day_noticeboard_entry: CreateSecondaryMarketDayAheadOrIntraDayNoticeboardEntry
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardEntry, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_secondary_market_day_ahead_or_intra_day_noticeboard_entry'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_day_ahead_or_intra_day_secondary_market_noticeboard_entry" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_secondary_market_day_ahead_or_intra_day_noticeboard_entry'] is not None:
            _body_params = _params['create_secondary_market_day_ahead_or_intra_day_noticeboard_entry']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '201': "CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardEntry",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard/day-ahead-or-intra-day', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_day_ahead_or_intra_day_secondary_market_transfer_request(self, create_secondary_market_day_ahead_or_intra_day_transfer_request : CreateSecondaryMarketDayAheadOrIntraDayTransferRequest, **kwargs) -> CreatedSecondaryMarketDayAheadOrIntraDayTransferRequest:  # noqa: E501
        """create_day_ahead_or_intra_day_secondary_market_transfer_request  # noqa: E501

        Create a Day Ahead or Intra Day Transfer Request  Feature flag:   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_DA_OR_ID_SECONDARY_MARKET_TRANSFER_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_day_ahead_or_intra_day_secondary_market_transfer_request(create_secondary_market_day_ahead_or_intra_day_transfer_request, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_day_ahead_or_intra_day_transfer_request: (required)
        :type create_secondary_market_day_ahead_or_intra_day_transfer_request: CreateSecondaryMarketDayAheadOrIntraDayTransferRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatedSecondaryMarketDayAheadOrIntraDayTransferRequest
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_day_ahead_or_intra_day_secondary_market_transfer_request_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_day_ahead_or_intra_day_secondary_market_transfer_request_with_http_info(create_secondary_market_day_ahead_or_intra_day_transfer_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_day_ahead_or_intra_day_secondary_market_transfer_request_with_http_info(self, create_secondary_market_day_ahead_or_intra_day_transfer_request : CreateSecondaryMarketDayAheadOrIntraDayTransferRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """create_day_ahead_or_intra_day_secondary_market_transfer_request  # noqa: E501

        Create a Day Ahead or Intra Day Transfer Request  Feature flag:   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_DA_OR_ID_SECONDARY_MARKET_TRANSFER_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_day_ahead_or_intra_day_secondary_market_transfer_request_with_http_info(create_secondary_market_day_ahead_or_intra_day_transfer_request, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_day_ahead_or_intra_day_transfer_request: (required)
        :type create_secondary_market_day_ahead_or_intra_day_transfer_request: CreateSecondaryMarketDayAheadOrIntraDayTransferRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatedSecondaryMarketDayAheadOrIntraDayTransferRequest, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_secondary_market_day_ahead_or_intra_day_transfer_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_day_ahead_or_intra_day_secondary_market_transfer_request" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_secondary_market_day_ahead_or_intra_day_transfer_request'] is not None:
            _body_params = _params['create_secondary_market_day_ahead_or_intra_day_transfer_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '201': "CreatedSecondaryMarketDayAheadOrIntraDayTransferRequest",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/transfer-requests/day-ahead-or-intra-day', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_day_ahead_or_intraday_secondary_noticeboard_response(self, create_secondary_market_day_ahead_or_intra_day_noticeboard_response : CreateSecondaryMarketDayAheadOrIntraDayNoticeboardResponse, **kwargs) -> CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardResponse:  # noqa: E501
        """create_day_ahead_or_intraday_secondary_noticeboard_response  # noqa: E501

        Create a new Day Ahead or Intra Day Noticeboard Response  Feature flag:   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_DA_OR_ID_SECONDARY_MARKET_NOTICEBOARD_RESPONSE`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_day_ahead_or_intraday_secondary_noticeboard_response(create_secondary_market_day_ahead_or_intra_day_noticeboard_response, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_day_ahead_or_intra_day_noticeboard_response: (required)
        :type create_secondary_market_day_ahead_or_intra_day_noticeboard_response: CreateSecondaryMarketDayAheadOrIntraDayNoticeboardResponse
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_day_ahead_or_intraday_secondary_noticeboard_response_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_day_ahead_or_intraday_secondary_noticeboard_response_with_http_info(create_secondary_market_day_ahead_or_intra_day_noticeboard_response, **kwargs)  # noqa: E501

    @validate_arguments
    def create_day_ahead_or_intraday_secondary_noticeboard_response_with_http_info(self, create_secondary_market_day_ahead_or_intra_day_noticeboard_response : CreateSecondaryMarketDayAheadOrIntraDayNoticeboardResponse, **kwargs) -> ApiResponse:  # noqa: E501
        """create_day_ahead_or_intraday_secondary_noticeboard_response  # noqa: E501

        Create a new Day Ahead or Intra Day Noticeboard Response  Feature flag:   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_DA_OR_ID_SECONDARY_MARKET_NOTICEBOARD_RESPONSE`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_day_ahead_or_intraday_secondary_noticeboard_response_with_http_info(create_secondary_market_day_ahead_or_intra_day_noticeboard_response, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_day_ahead_or_intra_day_noticeboard_response: (required)
        :type create_secondary_market_day_ahead_or_intra_day_noticeboard_response: CreateSecondaryMarketDayAheadOrIntraDayNoticeboardResponse
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_secondary_market_day_ahead_or_intra_day_noticeboard_response'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_day_ahead_or_intraday_secondary_noticeboard_response" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_secondary_market_day_ahead_or_intra_day_noticeboard_response'] is not None:
            _body_params = _params['create_secondary_market_day_ahead_or_intra_day_noticeboard_response']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '201': "CreatedSecondaryMarketDayAheadOrIntraDayNoticeboardResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard/day-ahead-or-intra-day/response', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_long_term_secondary_market_noticeboard_entry(self, create_secondary_market_long_term_noticeboard_entry : CreateSecondaryMarketLongTermNoticeboardEntry, **kwargs) -> CreatedSecondaryMarketLongTermNoticeboardEntry:  # noqa: E501
        """create_long_term_secondary_market_noticeboard_entry  # noqa: E501

        Create a new Long Term Noticeboard Entry  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_LT_SECONDARY_MARKET_NOTICEBOARD_ENTRY`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_long_term_secondary_market_noticeboard_entry(create_secondary_market_long_term_noticeboard_entry, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_long_term_noticeboard_entry: (required)
        :type create_secondary_market_long_term_noticeboard_entry: CreateSecondaryMarketLongTermNoticeboardEntry
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatedSecondaryMarketLongTermNoticeboardEntry
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_long_term_secondary_market_noticeboard_entry_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_long_term_secondary_market_noticeboard_entry_with_http_info(create_secondary_market_long_term_noticeboard_entry, **kwargs)  # noqa: E501

    @validate_arguments
    def create_long_term_secondary_market_noticeboard_entry_with_http_info(self, create_secondary_market_long_term_noticeboard_entry : CreateSecondaryMarketLongTermNoticeboardEntry, **kwargs) -> ApiResponse:  # noqa: E501
        """create_long_term_secondary_market_noticeboard_entry  # noqa: E501

        Create a new Long Term Noticeboard Entry  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_LT_SECONDARY_MARKET_NOTICEBOARD_ENTRY`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_long_term_secondary_market_noticeboard_entry_with_http_info(create_secondary_market_long_term_noticeboard_entry, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_long_term_noticeboard_entry: (required)
        :type create_secondary_market_long_term_noticeboard_entry: CreateSecondaryMarketLongTermNoticeboardEntry
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatedSecondaryMarketLongTermNoticeboardEntry, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_secondary_market_long_term_noticeboard_entry'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_long_term_secondary_market_noticeboard_entry" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_secondary_market_long_term_noticeboard_entry'] is not None:
            _body_params = _params['create_secondary_market_long_term_noticeboard_entry']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '201': "CreatedSecondaryMarketLongTermNoticeboardEntry",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard/long-term', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_long_term_secondary_market_transfer_request(self, create_secondary_market_long_term_transfer_request : CreateSecondaryMarketLongTermTransferRequest, **kwargs) -> CreatedSecondaryMarketLongTermTransferRequest:  # noqa: E501
        """create_long_term_secondary_market_transfer_request  # noqa: E501

        Create a Long Term Transfer Request  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_LT_SECONDARY_MARKET_TRANSFER_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_long_term_secondary_market_transfer_request(create_secondary_market_long_term_transfer_request, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_long_term_transfer_request: (required)
        :type create_secondary_market_long_term_transfer_request: CreateSecondaryMarketLongTermTransferRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatedSecondaryMarketLongTermTransferRequest
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_long_term_secondary_market_transfer_request_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_long_term_secondary_market_transfer_request_with_http_info(create_secondary_market_long_term_transfer_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_long_term_secondary_market_transfer_request_with_http_info(self, create_secondary_market_long_term_transfer_request : CreateSecondaryMarketLongTermTransferRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """create_long_term_secondary_market_transfer_request  # noqa: E501

        Create a Long Term Transfer Request  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_LT_SECONDARY_MARKET_TRANSFER_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_long_term_secondary_market_transfer_request_with_http_info(create_secondary_market_long_term_transfer_request, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_long_term_transfer_request: (required)
        :type create_secondary_market_long_term_transfer_request: CreateSecondaryMarketLongTermTransferRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatedSecondaryMarketLongTermTransferRequest, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_secondary_market_long_term_transfer_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_long_term_secondary_market_transfer_request" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_secondary_market_long_term_transfer_request'] is not None:
            _body_params = _params['create_secondary_market_long_term_transfer_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '201': "CreatedSecondaryMarketLongTermTransferRequest",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/transfer-requests/long-term', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_long_term_secondary_noticeboard_response(self, create_secondary_market_long_term_noticeboard_response : CreateSecondaryMarketLongTermNoticeboardResponse, **kwargs) -> CreatedSecondaryMarketLongTermNoticeboardResponse:  # noqa: E501
        """create_long_term_secondary_noticeboard_response  # noqa: E501

        Create a new Long Term Noticeboard Resopnse  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_LT_SECONDARY_MARKET_NOTICEBOARD_RESPONSE`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_long_term_secondary_noticeboard_response(create_secondary_market_long_term_noticeboard_response, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_long_term_noticeboard_response: (required)
        :type create_secondary_market_long_term_noticeboard_response: CreateSecondaryMarketLongTermNoticeboardResponse
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatedSecondaryMarketLongTermNoticeboardResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_long_term_secondary_noticeboard_response_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_long_term_secondary_noticeboard_response_with_http_info(create_secondary_market_long_term_noticeboard_response, **kwargs)  # noqa: E501

    @validate_arguments
    def create_long_term_secondary_noticeboard_response_with_http_info(self, create_secondary_market_long_term_noticeboard_response : CreateSecondaryMarketLongTermNoticeboardResponse, **kwargs) -> ApiResponse:  # noqa: E501
        """create_long_term_secondary_noticeboard_response  # noqa: E501

        Create a new Long Term Noticeboard Resopnse  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  __Generates Audit Log Entry:__ `CREATE_LT_SECONDARY_MARKET_NOTICEBOARD_RESPONSE`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_long_term_secondary_noticeboard_response_with_http_info(create_secondary_market_long_term_noticeboard_response, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_long_term_noticeboard_response: (required)
        :type create_secondary_market_long_term_noticeboard_response: CreateSecondaryMarketLongTermNoticeboardResponse
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatedSecondaryMarketLongTermNoticeboardResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_secondary_market_long_term_noticeboard_response'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_long_term_secondary_noticeboard_response" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_secondary_market_long_term_noticeboard_response'] is not None:
            _body_params = _params['create_secondary_market_long_term_noticeboard_response']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '201': "CreatedSecondaryMarketLongTermNoticeboardResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard/long-term/response', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_secondary_market_return_request(self, create_secondary_market_return_request : CreateSecondaryMarketReturnRequest, **kwargs) -> CreatedSecondaryMarketReturnRequestIdentifier:  # noqa: E501
        """create_secondary_market_return_request  # noqa: E501

        Create a new Return Request  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_RETURNS`  __Generates Audit Log Entry:__ `CREATE_SECONDARY_MARKET_RETURN_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_secondary_market_return_request(create_secondary_market_return_request, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_return_request: (required)
        :type create_secondary_market_return_request: CreateSecondaryMarketReturnRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatedSecondaryMarketReturnRequestIdentifier
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_secondary_market_return_request_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_secondary_market_return_request_with_http_info(create_secondary_market_return_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_secondary_market_return_request_with_http_info(self, create_secondary_market_return_request : CreateSecondaryMarketReturnRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """create_secondary_market_return_request  # noqa: E501

        Create a new Return Request  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_RETURNS`  __Generates Audit Log Entry:__ `CREATE_SECONDARY_MARKET_RETURN_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_secondary_market_return_request_with_http_info(create_secondary_market_return_request, async_req=True)
        >>> result = thread.get()

        :param create_secondary_market_return_request: (required)
        :type create_secondary_market_return_request: CreateSecondaryMarketReturnRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatedSecondaryMarketReturnRequestIdentifier, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_secondary_market_return_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_secondary_market_return_request" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_secondary_market_return_request'] is not None:
            _body_params = _params['create_secondary_market_return_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '201': "CreatedSecondaryMarketReturnRequestIdentifier",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/return-requests', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_noticeboard_entry(self, id : StrictStr, **kwargs) -> None:  # noqa: E501
        """delete_noticeboard_entry  # noqa: E501

        Delete a Noticeboard Entry by its identifier  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `DELETE_SECONDARY_MARKET_NOTICEBOARD_ENTRY`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_noticeboard_entry(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_noticeboard_entry_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_noticeboard_entry_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_noticeboard_entry_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """delete_noticeboard_entry  # noqa: E501

        Delete a Noticeboard Entry by its identifier  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `DELETE_SECONDARY_MARKET_NOTICEBOARD_ENTRY`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_noticeboard_entry_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_noticeboard_entry" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard/{id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_or_intra_day_secondary_market_noticeboard_entry(self, id : Annotated[StrictStr, Field(..., description="Entry identifier")], **kwargs) -> SecondaryMarketDayAheadOrIntraDayNoticeboardEntry:  # noqa: E501
        """get_day_ahead_or_intra_day_secondary_market_noticeboard_entry  # noqa: E501

        Fetch a Day Ahead or Intra Day Noticeboard Entry by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_secondary_market_noticeboard_entry(id, async_req=True)
        >>> result = thread.get()

        :param id: Entry identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketDayAheadOrIntraDayNoticeboardEntry
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_or_intra_day_secondary_market_noticeboard_entry_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_or_intra_day_secondary_market_noticeboard_entry_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_or_intra_day_secondary_market_noticeboard_entry_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Entry identifier")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_or_intra_day_secondary_market_noticeboard_entry  # noqa: E501

        Fetch a Day Ahead or Intra Day Noticeboard Entry by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_secondary_market_noticeboard_entry_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Entry identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketDayAheadOrIntraDayNoticeboardEntry, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_or_intra_day_secondary_market_noticeboard_entry" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketDayAheadOrIntraDayNoticeboardEntry",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard/day-ahead-or-intra-day/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_or_intra_day_secondary_market_transfer_request(self, id : StrictStr, **kwargs) -> SecondaryMarketDayAheadOrIntraDayTransferRequest:  # noqa: E501
        """get_day_ahead_or_intra_day_secondary_market_transfer_request  # noqa: E501

        Fetch a Day Ahead or Intra Day Transfer Request by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_secondary_market_transfer_request(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketDayAheadOrIntraDayTransferRequest
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_or_intra_day_secondary_market_transfer_request_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_or_intra_day_secondary_market_transfer_request_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_or_intra_day_secondary_market_transfer_request_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_or_intra_day_secondary_market_transfer_request  # noqa: E501

        Fetch a Day Ahead or Intra Day Transfer Request by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_secondary_market_transfer_request_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketDayAheadOrIntraDayTransferRequest, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_or_intra_day_secondary_market_transfer_request" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketDayAheadOrIntraDayTransferRequest",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/transfer-requests/{id}/day-ahead-or-intra-day', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_or_intra_day_secondary_market_transfer_request_options(self, delivery_day : Annotated[date, Field(..., description="Transfer day")], direction : BorderDirection, timescale : Annotated[AuctionTimescale, Field(..., description="Timescale needs to be DA/ID")], **kwargs) -> SecondaryMarketDayAheadOrIntraDayTransferRequestOptions:  # noqa: E501
        """get_day_ahead_or_intra_day_secondary_market_transfer_request_options  # noqa: E501

        Fetch options for creating Day Ahead or Intra Day Transfer Requests  Returns the minimum Day Ahead or Intra Day TRs on a delivery day / MTU  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_secondary_market_transfer_request_options(delivery_day, direction, timescale, async_req=True)
        >>> result = thread.get()

        :param delivery_day: Transfer day (required)
        :type delivery_day: date
        :param direction: (required)
        :type direction: BorderDirection
        :param timescale: Timescale needs to be DA/ID (required)
        :type timescale: AuctionTimescale
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketDayAheadOrIntraDayTransferRequestOptions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_or_intra_day_secondary_market_transfer_request_options_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_or_intra_day_secondary_market_transfer_request_options_with_http_info(delivery_day, direction, timescale, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_or_intra_day_secondary_market_transfer_request_options_with_http_info(self, delivery_day : Annotated[date, Field(..., description="Transfer day")], direction : BorderDirection, timescale : Annotated[AuctionTimescale, Field(..., description="Timescale needs to be DA/ID")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_or_intra_day_secondary_market_transfer_request_options  # noqa: E501

        Fetch options for creating Day Ahead or Intra Day Transfer Requests  Returns the minimum Day Ahead or Intra Day TRs on a delivery day / MTU  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intra_day_secondary_market_transfer_request_options_with_http_info(delivery_day, direction, timescale, async_req=True)
        >>> result = thread.get()

        :param delivery_day: Transfer day (required)
        :type delivery_day: date
        :param direction: (required)
        :type direction: BorderDirection
        :param timescale: Timescale needs to be DA/ID (required)
        :type timescale: AuctionTimescale
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketDayAheadOrIntraDayTransferRequestOptions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day',
            'direction',
            'timescale'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_or_intra_day_secondary_market_transfer_request_options" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        if _params.get('direction') is not None:  # noqa: E501
            _query_params.append(('direction', _params['direction'].value))

        if _params.get('timescale') is not None:  # noqa: E501
            _query_params.append(('timescale', _params['timescale'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketDayAheadOrIntraDayTransferRequestOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/transfer-requests/day-ahead-or-intra-day/options', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_or_intraday_secondary_market_noticeboard_options(self, delivery_day : date, direction : BorderDirection, timescale : Annotated[AuctionTimescale, Field(..., description="Timescale needs to be DA/ID")], **kwargs) -> SecondaryMarketDayAheadOrIntraDayNoticeboardOptions:  # noqa: E501
        """get_day_ahead_or_intraday_secondary_market_noticeboard_options  # noqa: E501

        Fetch options for creating Day Ahead or Intra Day Noticeboard Entries  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intraday_secondary_market_noticeboard_options(delivery_day, direction, timescale, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param direction: (required)
        :type direction: BorderDirection
        :param timescale: Timescale needs to be DA/ID (required)
        :type timescale: AuctionTimescale
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketDayAheadOrIntraDayNoticeboardOptions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_or_intraday_secondary_market_noticeboard_options_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_or_intraday_secondary_market_noticeboard_options_with_http_info(delivery_day, direction, timescale, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_or_intraday_secondary_market_noticeboard_options_with_http_info(self, delivery_day : date, direction : BorderDirection, timescale : Annotated[AuctionTimescale, Field(..., description="Timescale needs to be DA/ID")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_or_intraday_secondary_market_noticeboard_options  # noqa: E501

        Fetch options for creating Day Ahead or Intra Day Noticeboard Entries  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intraday_secondary_market_noticeboard_options_with_http_info(delivery_day, direction, timescale, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param direction: (required)
        :type direction: BorderDirection
        :param timescale: Timescale needs to be DA/ID (required)
        :type timescale: AuctionTimescale
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketDayAheadOrIntraDayNoticeboardOptions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day',
            'direction',
            'timescale'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_or_intraday_secondary_market_noticeboard_options" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        if _params.get('direction') is not None:  # noqa: E501
            _query_params.append(('direction', _params['direction'].value))

        if _params.get('timescale') is not None:  # noqa: E501
            _query_params.append(('timescale', _params['timescale'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketDayAheadOrIntraDayNoticeboardOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard/day-ahead-or-intra-day/options', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_day_ahead_or_intraday_secondary_market_noticeboard_response_options(self, noticeboard_entry_id : StrictStr, **kwargs) -> SecondaryMarketDayAheadOrIntraDayNoticeboardResponseOptions:  # noqa: E501
        """get_day_ahead_or_intraday_secondary_market_noticeboard_response_options  # noqa: E501

        Fetch options for creating Day Ahead or Intra Day Noticeboard Responses  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intraday_secondary_market_noticeboard_response_options(noticeboard_entry_id, async_req=True)
        >>> result = thread.get()

        :param noticeboard_entry_id: (required)
        :type noticeboard_entry_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketDayAheadOrIntraDayNoticeboardResponseOptions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_day_ahead_or_intraday_secondary_market_noticeboard_response_options_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_day_ahead_or_intraday_secondary_market_noticeboard_response_options_with_http_info(noticeboard_entry_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_day_ahead_or_intraday_secondary_market_noticeboard_response_options_with_http_info(self, noticeboard_entry_id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_day_ahead_or_intraday_secondary_market_noticeboard_response_options  # noqa: E501

        Fetch options for creating Day Ahead or Intra Day Noticeboard Responses  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_day_ahead_or_intraday_secondary_market_noticeboard_response_options_with_http_info(noticeboard_entry_id, async_req=True)
        >>> result = thread.get()

        :param noticeboard_entry_id: (required)
        :type noticeboard_entry_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketDayAheadOrIntraDayNoticeboardResponseOptions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'noticeboard_entry_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_day_ahead_or_intraday_secondary_market_noticeboard_response_options" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('noticeboard_entry_id') is not None:  # noqa: E501
            _query_params.append(('noticeboardEntryId', _params['noticeboard_entry_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketDayAheadOrIntraDayNoticeboardResponseOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard/day-ahead-or-intra-day/response/options', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_long_term_secondary_market_noticeboard_entry(self, id : Annotated[StrictStr, Field(..., description="Entry identifier")], **kwargs) -> SecondaryMarketLongTermNoticeboardEntry:  # noqa: E501
        """get_long_term_secondary_market_noticeboard_entry  # noqa: E501

        Fetch a Long Term Noticeboard Entry by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_secondary_market_noticeboard_entry(id, async_req=True)
        >>> result = thread.get()

        :param id: Entry identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketLongTermNoticeboardEntry
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_long_term_secondary_market_noticeboard_entry_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_long_term_secondary_market_noticeboard_entry_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_long_term_secondary_market_noticeboard_entry_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Entry identifier")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_long_term_secondary_market_noticeboard_entry  # noqa: E501

        Fetch a Long Term Noticeboard Entry by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_secondary_market_noticeboard_entry_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Entry identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketLongTermNoticeboardEntry, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_long_term_secondary_market_noticeboard_entry" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketLongTermNoticeboardEntry",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard/long-term/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_long_term_secondary_market_noticeboard_options(self, first_day : Annotated[date, Field(..., description="First day of the period")], last_day : Annotated[date, Field(..., description="Last day of the period")], direction : BorderDirection, **kwargs) -> SecondaryMarketLongTermNoticeboardOptions:  # noqa: E501
        """get_long_term_secondary_market_noticeboard_options  # noqa: E501

        Fetch options for creating Long Term Noticeboard Entries  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_secondary_market_noticeboard_options(first_day, last_day, direction, async_req=True)
        >>> result = thread.get()

        :param first_day: First day of the period (required)
        :type first_day: date
        :param last_day: Last day of the period (required)
        :type last_day: date
        :param direction: (required)
        :type direction: BorderDirection
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketLongTermNoticeboardOptions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_long_term_secondary_market_noticeboard_options_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_long_term_secondary_market_noticeboard_options_with_http_info(first_day, last_day, direction, **kwargs)  # noqa: E501

    @validate_arguments
    def get_long_term_secondary_market_noticeboard_options_with_http_info(self, first_day : Annotated[date, Field(..., description="First day of the period")], last_day : Annotated[date, Field(..., description="Last day of the period")], direction : BorderDirection, **kwargs) -> ApiResponse:  # noqa: E501
        """get_long_term_secondary_market_noticeboard_options  # noqa: E501

        Fetch options for creating Long Term Noticeboard Entries  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_secondary_market_noticeboard_options_with_http_info(first_day, last_day, direction, async_req=True)
        >>> result = thread.get()

        :param first_day: First day of the period (required)
        :type first_day: date
        :param last_day: Last day of the period (required)
        :type last_day: date
        :param direction: (required)
        :type direction: BorderDirection
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketLongTermNoticeboardOptions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'first_day',
            'last_day',
            'direction'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_long_term_secondary_market_noticeboard_options" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('first_day') is not None:  # noqa: E501
            if isinstance(_params['first_day'], datetime):
                _query_params.append(('firstDay', _params['first_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('firstDay', _params['first_day']))

        if _params.get('last_day') is not None:  # noqa: E501
            if isinstance(_params['last_day'], datetime):
                _query_params.append(('lastDay', _params['last_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('lastDay', _params['last_day']))

        if _params.get('direction') is not None:  # noqa: E501
            _query_params.append(('direction', _params['direction'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketLongTermNoticeboardOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard/long-term/options', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_long_term_secondary_market_noticeboard_response_options(self, noticeboard_entry_id : StrictStr, **kwargs) -> SecondaryMarketLongTermNoticeboardResponseOptions:  # noqa: E501
        """get_long_term_secondary_market_noticeboard_response_options  # noqa: E501

        Fetch options for creating Long Term Noticeboard Responses  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_secondary_market_noticeboard_response_options(noticeboard_entry_id, async_req=True)
        >>> result = thread.get()

        :param noticeboard_entry_id: (required)
        :type noticeboard_entry_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketLongTermNoticeboardResponseOptions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_long_term_secondary_market_noticeboard_response_options_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_long_term_secondary_market_noticeboard_response_options_with_http_info(noticeboard_entry_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_long_term_secondary_market_noticeboard_response_options_with_http_info(self, noticeboard_entry_id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_long_term_secondary_market_noticeboard_response_options  # noqa: E501

        Fetch options for creating Long Term Noticeboard Responses  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_secondary_market_noticeboard_response_options_with_http_info(noticeboard_entry_id, async_req=True)
        >>> result = thread.get()

        :param noticeboard_entry_id: (required)
        :type noticeboard_entry_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketLongTermNoticeboardResponseOptions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'noticeboard_entry_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_long_term_secondary_market_noticeboard_response_options" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('noticeboard_entry_id') is not None:  # noqa: E501
            _query_params.append(('noticeboardEntryId', _params['noticeboard_entry_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketLongTermNoticeboardResponseOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard/long-term/response/options', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_long_term_secondary_market_transfer_request(self, id : StrictStr, **kwargs) -> SecondaryMarketTransferRequest:  # noqa: E501
        """get_long_term_secondary_market_transfer_request  # noqa: E501

        Fetch a Long Term Transfer Request by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_secondary_market_transfer_request(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketTransferRequest
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_long_term_secondary_market_transfer_request_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_long_term_secondary_market_transfer_request_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_long_term_secondary_market_transfer_request_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_long_term_secondary_market_transfer_request  # noqa: E501

        Fetch a Long Term Transfer Request by its identifier  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_secondary_market_transfer_request_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketTransferRequest, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_long_term_secondary_market_transfer_request" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketTransferRequest",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/transfer-requests/{id}/long-term', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_long_term_secondary_market_transfer_request_options(self, first_day : Annotated[date, Field(..., description="First day of the period")], last_day : Annotated[date, Field(..., description="Last day of the period")], direction : BorderDirection, **kwargs) -> SecondaryMarketLongTermTransferRequestOptions:  # noqa: E501
        """get_long_term_secondary_market_transfer_request_options  # noqa: E501

        Fetch options for creating Long Term Transfer Requests  Returns minimum Long Term TRs between first day and last day  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_secondary_market_transfer_request_options(first_day, last_day, direction, async_req=True)
        >>> result = thread.get()

        :param first_day: First day of the period (required)
        :type first_day: date
        :param last_day: Last day of the period (required)
        :type last_day: date
        :param direction: (required)
        :type direction: BorderDirection
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketLongTermTransferRequestOptions
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_long_term_secondary_market_transfer_request_options_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_long_term_secondary_market_transfer_request_options_with_http_info(first_day, last_day, direction, **kwargs)  # noqa: E501

    @validate_arguments
    def get_long_term_secondary_market_transfer_request_options_with_http_info(self, first_day : Annotated[date, Field(..., description="First day of the period")], last_day : Annotated[date, Field(..., description="Last day of the period")], direction : BorderDirection, **kwargs) -> ApiResponse:  # noqa: E501
        """get_long_term_secondary_market_transfer_request_options  # noqa: E501

        Fetch options for creating Long Term Transfer Requests  Returns minimum Long Term TRs between first day and last day  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_long_term_secondary_market_transfer_request_options_with_http_info(first_day, last_day, direction, async_req=True)
        >>> result = thread.get()

        :param first_day: First day of the period (required)
        :type first_day: date
        :param last_day: Last day of the period (required)
        :type last_day: date
        :param direction: (required)
        :type direction: BorderDirection
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketLongTermTransferRequestOptions, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'first_day',
            'last_day',
            'direction'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_long_term_secondary_market_transfer_request_options" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('first_day') is not None:  # noqa: E501
            if isinstance(_params['first_day'], datetime):
                _query_params.append(('firstDay', _params['first_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('firstDay', _params['first_day']))

        if _params.get('last_day') is not None:  # noqa: E501
            if isinstance(_params['last_day'], datetime):
                _query_params.append(('lastDay', _params['last_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('lastDay', _params['last_day']))

        if _params.get('direction') is not None:  # noqa: E501
            _query_params.append(('direction', _params['direction'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketLongTermTransferRequestOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/transfer-requests/long-term/options', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_secondary_market_noticeboard(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], type : NoticeboardEntryTypeWithBoth, directions : conlist(BorderDirection), timescales : conlist(AuctionTimescale), delivery_period_from : Annotated[date, Field(..., description="Filter for start delivery period")], delivery_period_to : Annotated[date, Field(..., description="Filter for end delivery period")], **kwargs) -> SecondaryMarketNoticeboardEntryBatch:  # noqa: E501
        """get_secondary_market_noticeboard  # noqa: E501

        Fetch a paginated, filterable list of Noticeboard Entries  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secondary_market_noticeboard(limit, offset, type, directions, timescales, delivery_period_from, delivery_period_to, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param type: (required)
        :type type: NoticeboardEntryTypeWithBoth
        :param directions: (required)
        :type directions: List[BorderDirection]
        :param timescales: (required)
        :type timescales: List[AuctionTimescale]
        :param delivery_period_from: Filter for start delivery period (required)
        :type delivery_period_from: date
        :param delivery_period_to: Filter for end delivery period (required)
        :type delivery_period_to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketNoticeboardEntryBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_secondary_market_noticeboard_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_secondary_market_noticeboard_with_http_info(limit, offset, type, directions, timescales, delivery_period_from, delivery_period_to, **kwargs)  # noqa: E501

    @validate_arguments
    def get_secondary_market_noticeboard_with_http_info(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], type : NoticeboardEntryTypeWithBoth, directions : conlist(BorderDirection), timescales : conlist(AuctionTimescale), delivery_period_from : Annotated[date, Field(..., description="Filter for start delivery period")], delivery_period_to : Annotated[date, Field(..., description="Filter for end delivery period")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_secondary_market_noticeboard  # noqa: E501

        Fetch a paginated, filterable list of Noticeboard Entries  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secondary_market_noticeboard_with_http_info(limit, offset, type, directions, timescales, delivery_period_from, delivery_period_to, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param type: (required)
        :type type: NoticeboardEntryTypeWithBoth
        :param directions: (required)
        :type directions: List[BorderDirection]
        :param timescales: (required)
        :type timescales: List[AuctionTimescale]
        :param delivery_period_from: Filter for start delivery period (required)
        :type delivery_period_from: date
        :param delivery_period_to: Filter for end delivery period (required)
        :type delivery_period_to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketNoticeboardEntryBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'type',
            'directions',
            'timescales',
            'delivery_period_from',
            'delivery_period_to'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_secondary_market_noticeboard" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type'].value))

        if _params.get('directions') is not None:  # noqa: E501
            _query_params.append(('directions', _params['directions']))
            _collection_formats['directions'] = 'multi'

        if _params.get('timescales') is not None:  # noqa: E501
            _query_params.append(('timescales', _params['timescales']))
            _collection_formats['timescales'] = 'multi'

        if _params.get('delivery_period_from') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_from'], datetime):
                _query_params.append(('deliveryPeriodFrom', _params['delivery_period_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodFrom', _params['delivery_period_from']))

        if _params.get('delivery_period_to') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_to'], datetime):
                _query_params.append(('deliveryPeriodTo', _params['delivery_period_to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodTo', _params['delivery_period_to']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketNoticeboardEntryBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/noticeboard', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_secondary_market_return_request_options(self, target_auction_id : StrictStr, **kwargs) -> List[SourceAuction]:  # noqa: E501
        """get_secondary_market_return_request_options  # noqa: E501

        Fetch options for creating Return Requests  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_RETURNS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secondary_market_return_request_options(target_auction_id, async_req=True)
        >>> result = thread.get()

        :param target_auction_id: (required)
        :type target_auction_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[SourceAuction]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_secondary_market_return_request_options_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_secondary_market_return_request_options_with_http_info(target_auction_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_secondary_market_return_request_options_with_http_info(self, target_auction_id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """get_secondary_market_return_request_options  # noqa: E501

        Fetch options for creating Return Requests  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_RETURNS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secondary_market_return_request_options_with_http_info(target_auction_id, async_req=True)
        >>> result = thread.get()

        :param target_auction_id: (required)
        :type target_auction_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[SourceAuction], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'target_auction_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_secondary_market_return_request_options" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('target_auction_id') is not None:  # noqa: E501
            _query_params.append(('targetAuctionId', _params['target_auction_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "List[SourceAuction]",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/return-requests/options', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_secondary_market_return_requests(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], participant_id : StrictStr, directions : conlist(BorderDirection), delivery_period_from : Annotated[date, Field(..., description="Filter for start of auction delivery period")], delivery_period_to : Annotated[date, Field(..., description="Filter for end of auction delivery period")], search_query : Annotated[Optional[StrictStr], Field(description="Searching in the Target Auction Auction ID and Auction name")] = None, **kwargs) -> SecondaryMarketReturnRequestBatch:  # noqa: E501
        """get_secondary_market_return_requests  # noqa: E501

        Fetch a filterable list of Return Requests  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_RETURNS`   * `VIEW_OWN_SECONDARY_MARKET_RETURNS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secondary_market_return_requests(limit, offset, participant_id, directions, delivery_period_from, delivery_period_to, search_query, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param participant_id: (required)
        :type participant_id: str
        :param directions: (required)
        :type directions: List[BorderDirection]
        :param delivery_period_from: Filter for start of auction delivery period (required)
        :type delivery_period_from: date
        :param delivery_period_to: Filter for end of auction delivery period (required)
        :type delivery_period_to: date
        :param search_query: Searching in the Target Auction Auction ID and Auction name
        :type search_query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketReturnRequestBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_secondary_market_return_requests_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_secondary_market_return_requests_with_http_info(limit, offset, participant_id, directions, delivery_period_from, delivery_period_to, search_query, **kwargs)  # noqa: E501

    @validate_arguments
    def get_secondary_market_return_requests_with_http_info(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], participant_id : StrictStr, directions : conlist(BorderDirection), delivery_period_from : Annotated[date, Field(..., description="Filter for start of auction delivery period")], delivery_period_to : Annotated[date, Field(..., description="Filter for end of auction delivery period")], search_query : Annotated[Optional[StrictStr], Field(description="Searching in the Target Auction Auction ID and Auction name")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_secondary_market_return_requests  # noqa: E501

        Fetch a filterable list of Return Requests  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_RETURNS`   * `VIEW_OWN_SECONDARY_MARKET_RETURNS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secondary_market_return_requests_with_http_info(limit, offset, participant_id, directions, delivery_period_from, delivery_period_to, search_query, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param participant_id: (required)
        :type participant_id: str
        :param directions: (required)
        :type directions: List[BorderDirection]
        :param delivery_period_from: Filter for start of auction delivery period (required)
        :type delivery_period_from: date
        :param delivery_period_to: Filter for end of auction delivery period (required)
        :type delivery_period_to: date
        :param search_query: Searching in the Target Auction Auction ID and Auction name
        :type search_query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketReturnRequestBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'participant_id',
            'directions',
            'delivery_period_from',
            'delivery_period_to',
            'search_query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_secondary_market_return_requests" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('participant_id') is not None:  # noqa: E501
            _query_params.append(('participantId', _params['participant_id']))

        if _params.get('directions') is not None:  # noqa: E501
            _query_params.append(('directions', _params['directions']))
            _collection_formats['directions'] = 'multi'

        if _params.get('search_query') is not None:  # noqa: E501
            _query_params.append(('searchQuery', _params['search_query']))

        if _params.get('delivery_period_from') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_from'], datetime):
                _query_params.append(('deliveryPeriodFrom', _params['delivery_period_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodFrom', _params['delivery_period_from']))

        if _params.get('delivery_period_to') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_to'], datetime):
                _query_params.append(('deliveryPeriodTo', _params['delivery_period_to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodTo', _params['delivery_period_to']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketReturnRequestBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/return-requests', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_secondary_market_transfer_requests(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], participant_id : StrictStr, directions : conlist(BorderDirection), transfer_type : SecondaryMarketTransferRequestType, delivery_period_from : Annotated[date, Field(..., description="Filter for start of auction delivery period")], delivery_period_to : Annotated[date, Field(..., description="Filter for end of auction delivery period")], **kwargs) -> SecondaryMarketTransferRequestBatch:  # noqa: E501
        """get_secondary_market_transfer_requests  # noqa: E501

        Fetch a filterable list of Transfer Requests  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secondary_market_transfer_requests(limit, offset, participant_id, directions, transfer_type, delivery_period_from, delivery_period_to, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param participant_id: (required)
        :type participant_id: str
        :param directions: (required)
        :type directions: List[BorderDirection]
        :param transfer_type: (required)
        :type transfer_type: SecondaryMarketTransferRequestType
        :param delivery_period_from: Filter for start of auction delivery period (required)
        :type delivery_period_from: date
        :param delivery_period_to: Filter for end of auction delivery period (required)
        :type delivery_period_to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SecondaryMarketTransferRequestBatch
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_secondary_market_transfer_requests_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_secondary_market_transfer_requests_with_http_info(limit, offset, participant_id, directions, transfer_type, delivery_period_from, delivery_period_to, **kwargs)  # noqa: E501

    @validate_arguments
    def get_secondary_market_transfer_requests_with_http_info(self, limit : Annotated[conint(strict=True, le=100, ge=1), Field(..., description="Number of records to return on a page")], offset : Annotated[conint(strict=True, ge=0), Field(..., description="Offset in the list of records to return")], participant_id : StrictStr, directions : conlist(BorderDirection), transfer_type : SecondaryMarketTransferRequestType, delivery_period_from : Annotated[date, Field(..., description="Filter for start of auction delivery period")], delivery_period_to : Annotated[date, Field(..., description="Filter for end of auction delivery period")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_secondary_market_transfer_requests  # noqa: E501

        Fetch a filterable list of Transfer Requests  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_SECONDARY_MARKET_TRANSFERS`   * `VIEW_OWN_SECONDARY_MARKET_TRANSFERS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_secondary_market_transfer_requests_with_http_info(limit, offset, participant_id, directions, transfer_type, delivery_period_from, delivery_period_to, async_req=True)
        >>> result = thread.get()

        :param limit: Number of records to return on a page (required)
        :type limit: int
        :param offset: Offset in the list of records to return (required)
        :type offset: int
        :param participant_id: (required)
        :type participant_id: str
        :param directions: (required)
        :type directions: List[BorderDirection]
        :param transfer_type: (required)
        :type transfer_type: SecondaryMarketTransferRequestType
        :param delivery_period_from: Filter for start of auction delivery period (required)
        :type delivery_period_from: date
        :param delivery_period_to: Filter for end of auction delivery period (required)
        :type delivery_period_to: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SecondaryMarketTransferRequestBatch, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'participant_id',
            'directions',
            'transfer_type',
            'delivery_period_from',
            'delivery_period_to'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_secondary_market_transfer_requests" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('participant_id') is not None:  # noqa: E501
            _query_params.append(('participantId', _params['participant_id']))

        if _params.get('directions') is not None:  # noqa: E501
            _query_params.append(('directions', _params['directions']))
            _collection_formats['directions'] = 'multi'

        if _params.get('transfer_type') is not None:  # noqa: E501
            _query_params.append(('transferType', _params['transfer_type'].value))

        if _params.get('delivery_period_from') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_from'], datetime):
                _query_params.append(('deliveryPeriodFrom', _params['delivery_period_from'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodFrom', _params['delivery_period_from']))

        if _params.get('delivery_period_to') is not None:  # noqa: E501
            if isinstance(_params['delivery_period_to'], datetime):
                _query_params.append(('deliveryPeriodTo', _params['delivery_period_to'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryPeriodTo', _params['delivery_period_to']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "SecondaryMarketTransferRequestBatch",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/secondary-market/transfer-requests', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def reject_secondary_market_transfer_request(self, id : Annotated[StrictStr, Field(..., description="Transfer request identifier")], **kwargs) -> None:  # noqa: E501
        """reject_secondary_market_transfer_request  # noqa: E501

        Reject a specified Transfer Request, if allowed in the current state  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `REJECT_SECONDARY_MARKET_TRANSFER_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reject_secondary_market_transfer_request(id, async_req=True)
        >>> result = thread.get()

        :param id: Transfer request identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the reject_secondary_market_transfer_request_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.reject_secondary_market_transfer_request_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def reject_secondary_market_transfer_request_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Transfer request identifier")], **kwargs) -> ApiResponse:  # noqa: E501
        """reject_secondary_market_transfer_request  # noqa: E501

        Reject a specified Transfer Request, if allowed in the current state  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `REJECT_SECONDARY_MARKET_TRANSFER_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reject_secondary_market_transfer_request_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Transfer request identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reject_secondary_market_transfer_request" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/secondary-market/transfer-requests/{id}/reject', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def withdraw_secondary_market_return_request(self, id : Annotated[StrictStr, Field(..., description="Return request identifier")], **kwargs) -> None:  # noqa: E501
        """withdraw_secondary_market_return_request  # noqa: E501

        Withdraw a specified Return Request, if allowed in the current state  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_RETURNS`  __Generates Audit Log Entry:__ `WITHDRAW_SECONDARY_MARKET_RETURN_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.withdraw_secondary_market_return_request(id, async_req=True)
        >>> result = thread.get()

        :param id: Return request identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the withdraw_secondary_market_return_request_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.withdraw_secondary_market_return_request_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def withdraw_secondary_market_return_request_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Return request identifier")], **kwargs) -> ApiResponse:  # noqa: E501
        """withdraw_secondary_market_return_request  # noqa: E501

        Withdraw a specified Return Request, if allowed in the current state  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_RETURNS`  __Generates Audit Log Entry:__ `WITHDRAW_SECONDARY_MARKET_RETURN_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.withdraw_secondary_market_return_request_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Return request identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method withdraw_secondary_market_return_request" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/secondary-market/return-requests/{id}/withdraw', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def withdraw_secondary_market_transfer_request(self, id : Annotated[StrictStr, Field(..., description="Transfer request identifier")], **kwargs) -> None:  # noqa: E501
        """withdraw_secondary_market_transfer_request  # noqa: E501

        Withdraw a specified Transfer Request, if allowed in the current state  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `WITHDRAW_SECONDARY_MARKET_TRANSFER_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.withdraw_secondary_market_transfer_request(id, async_req=True)
        >>> result = thread.get()

        :param id: Transfer request identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the withdraw_secondary_market_transfer_request_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.withdraw_secondary_market_transfer_request_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def withdraw_secondary_market_transfer_request_with_http_info(self, id : Annotated[StrictStr, Field(..., description="Transfer request identifier")], **kwargs) -> ApiResponse:  # noqa: E501
        """withdraw_secondary_market_transfer_request  # noqa: E501

        Withdraw a specified Transfer Request, if allowed in the current state  Feature flag:   * if the `DISABLE_LT_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_DA_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale   * if the `DISABLE_ID_SECONDARY_MARKET` feature flag is TRUE, this function is not available for the corresponding timescale  ---  __Requires Permission:__ (at least one)   * `MANAGE_SECONDARY_MARKET_LT_TRANSFERS`   * `MANAGE_SECONDARY_MARKET_DA_ID_TRANSFERS`  __Generates Audit Log Entry:__ `WITHDRAW_SECONDARY_MARKET_TRANSFER_REQUEST`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.withdraw_secondary_market_transfer_request_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Transfer request identifier (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method withdraw_secondary_market_transfer_request" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/secondary-market/transfer-requests/{id}/withdraw', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
