"""
scalars_to_field
================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class scalars_to_field(Operator):
    """take a double or a vector of double and transform it in a one entity
    field of location 'numeric'.

    Parameters
    ----------
    double_or_vector_double : float
        Double or vector of double
    unit : str, optional
        Unit symbole (m, hz, kg, ...)


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.scalars_to_field()

    >>> # Make input connections
    >>> my_double_or_vector_double = float()
    >>> op.inputs.double_or_vector_double.connect(my_double_or_vector_double)
    >>> my_unit = str()
    >>> op.inputs.unit.connect(my_unit)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.scalars_to_field(
    ...     double_or_vector_double=my_double_or_vector_double,
    ...     unit=my_unit,
    ... )

    >>> # Get output data
    >>> result_field = op.outputs.field()
    """

    def __init__(
        self, double_or_vector_double=None, unit=None, config=None, server=None
    ):
        super().__init__(name="fieldify", config=config, server=server)
        self._inputs = InputsScalarsToField(self)
        self._outputs = OutputsScalarsToField(self)
        if double_or_vector_double is not None:
            self.inputs.double_or_vector_double.connect(double_or_vector_double)
        if unit is not None:
            self.inputs.unit.connect(unit)

    @staticmethod
    def _spec():
        description = """take a double or a vector of double and transform it in a one entity
            field of location &quot;numeric&quot;."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="double_or_vector_double",
                    type_names=["double", "vector<double>"],
                    optional=False,
                    document="""Double or vector of double""",
                ),
                1: PinSpecification(
                    name="unit",
                    type_names=["string"],
                    optional=True,
                    document="""Unit symbole (m, hz, kg, ...)""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="field",
                    type_names=["field"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="fieldify", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsScalarsToField
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsScalarsToField
        """
        return super().outputs


class InputsScalarsToField(_Inputs):
    """Intermediate class used to connect user inputs to
    scalars_to_field operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.scalars_to_field()
    >>> my_double_or_vector_double = float()
    >>> op.inputs.double_or_vector_double.connect(my_double_or_vector_double)
    >>> my_unit = str()
    >>> op.inputs.unit.connect(my_unit)
    """

    def __init__(self, op: Operator):
        super().__init__(scalars_to_field._spec().inputs, op)
        self._double_or_vector_double = Input(
            scalars_to_field._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._double_or_vector_double)
        self._unit = Input(scalars_to_field._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._unit)

    @property
    def double_or_vector_double(self):
        """Allows to connect double_or_vector_double input to the operator.

        Double or vector of double

        Parameters
        ----------
        my_double_or_vector_double : float

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.scalars_to_field()
        >>> op.inputs.double_or_vector_double.connect(my_double_or_vector_double)
        >>> # or
        >>> op.inputs.double_or_vector_double(my_double_or_vector_double)
        """
        return self._double_or_vector_double

    @property
    def unit(self):
        """Allows to connect unit input to the operator.

        Unit symbole (m, hz, kg, ...)

        Parameters
        ----------
        my_unit : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.scalars_to_field()
        >>> op.inputs.unit.connect(my_unit)
        >>> # or
        >>> op.inputs.unit(my_unit)
        """
        return self._unit


class OutputsScalarsToField(_Outputs):
    """Intermediate class used to get outputs from
    scalars_to_field operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.scalars_to_field()
    >>> # Connect inputs : op.inputs. ...
    >>> result_field = op.outputs.field()
    """

    def __init__(self, op: Operator):
        super().__init__(scalars_to_field._spec().outputs, op)
        self._field = Output(scalars_to_field._spec().output_pin(0), 0, op)
        self._outputs.append(self._field)

    @property
    def field(self):
        """Allows to get field output of the operator

        Returns
        ----------
        my_field : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.scalars_to_field()
        >>> # Connect inputs : op.inputs. ...
        >>> result_field = op.outputs.field()
        """  # noqa: E501
        return self._field
