"""
python_script_exec
==================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class python_script_exec(Operator):
    """Execute python input script.

    Parameters
    ----------
    python_script : str
        Input python script


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.python_script_exec()

    >>> # Make input connections
    >>> my_python_script = str()
    >>> op.inputs.python_script.connect(my_python_script)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.python_script_exec(
    ...     python_script=my_python_script,
    ... )

    >>> # Get output data
    >>> result_output = op.outputs.output()
    """

    def __init__(self, python_script=None, config=None, server=None):
        super().__init__(
            name="utility::python_script_exec", config=config, server=server
        )
        self._inputs = InputsPythonScriptExec(self)
        self._outputs = OutputsPythonScriptExec(self)
        if python_script is not None:
            self.inputs.python_script.connect(python_script)

    @staticmethod
    def _spec():
        description = """Execute python input script."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="python_script",
                    type_names=["string"],
                    optional=False,
                    document="""Input python script""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="output",
                    type_names=["any"],
                    optional=False,
                    document="""The output can be of any supported type""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(
            name="utility::python_script_exec", server=server
        )

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsPythonScriptExec
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsPythonScriptExec
        """
        return super().outputs


class InputsPythonScriptExec(_Inputs):
    """Intermediate class used to connect user inputs to
    python_script_exec operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.python_script_exec()
    >>> my_python_script = str()
    >>> op.inputs.python_script.connect(my_python_script)
    """

    def __init__(self, op: Operator):
        super().__init__(python_script_exec._spec().inputs, op)
        self._python_script = Input(python_script_exec._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._python_script)

    @property
    def python_script(self):
        """Allows to connect python_script input to the operator.

        Input python script

        Parameters
        ----------
        my_python_script : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.python_script_exec()
        >>> op.inputs.python_script.connect(my_python_script)
        >>> # or
        >>> op.inputs.python_script(my_python_script)
        """
        return self._python_script


class OutputsPythonScriptExec(_Outputs):
    """Intermediate class used to get outputs from
    python_script_exec operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.python_script_exec()
    >>> # Connect inputs : op.inputs. ...
    >>> result_output = op.outputs.output()
    """

    def __init__(self, op: Operator):
        super().__init__(python_script_exec._spec().outputs, op)
        self._output = Output(python_script_exec._spec().output_pin(0), 0, op)
        self._outputs.append(self._output)

    @property
    def output(self):
        """Allows to get output output of the operator

        Returns
        ----------
        my_output : Any

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.python_script_exec()
        >>> # Connect inputs : op.inputs. ...
        >>> result_output = op.outputs.output()
        """  # noqa: E501
        return self._output
