"""
forward_meshes_container
========================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class forward_meshes_container(Operator):
    """Return the input mesh or meshes container into a meshes container.

    Parameters
    ----------
    meshes : MeshesContainer or MeshedRegion
    default_label : str, optional
        This default label is used if a new meshes
        container needs to be created
        (default is unknown)


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.forward_meshes_container()

    >>> # Make input connections
    >>> my_meshes = dpf.MeshesContainer()
    >>> op.inputs.meshes.connect(my_meshes)
    >>> my_default_label = str()
    >>> op.inputs.default_label.connect(my_default_label)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.forward_meshes_container(
    ...     meshes=my_meshes,
    ...     default_label=my_default_label,
    ... )

    >>> # Get output data
    >>> result_meshes_container = op.outputs.meshes_container()
    """

    def __init__(self, meshes=None, default_label=None, config=None, server=None):
        super().__init__(name="forward_meshes_container", config=config, server=server)
        self._inputs = InputsForwardMeshesContainer(self)
        self._outputs = OutputsForwardMeshesContainer(self)
        if meshes is not None:
            self.inputs.meshes.connect(meshes)
        if default_label is not None:
            self.inputs.default_label.connect(default_label)

    @staticmethod
    def _spec():
        description = (
            """Return the input mesh or meshes container into a meshes container."""
        )
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="meshes",
                    type_names=["meshes_container", "abstract_meshed_region"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="default_label",
                    type_names=["string"],
                    optional=True,
                    document="""This default label is used if a new meshes
        container needs to be created
        (default is unknown)""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="meshes_container",
                    type_names=["meshes_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="forward_meshes_container", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsForwardMeshesContainer
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsForwardMeshesContainer
        """
        return super().outputs


class InputsForwardMeshesContainer(_Inputs):
    """Intermediate class used to connect user inputs to
    forward_meshes_container operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.forward_meshes_container()
    >>> my_meshes = dpf.MeshesContainer()
    >>> op.inputs.meshes.connect(my_meshes)
    >>> my_default_label = str()
    >>> op.inputs.default_label.connect(my_default_label)
    """

    def __init__(self, op: Operator):
        super().__init__(forward_meshes_container._spec().inputs, op)
        self._meshes = Input(forward_meshes_container._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._meshes)
        self._default_label = Input(
            forward_meshes_container._spec().input_pin(1), 1, op, -1
        )
        self._inputs.append(self._default_label)

    @property
    def meshes(self):
        """Allows to connect meshes input to the operator.

        Parameters
        ----------
        my_meshes : MeshesContainer or MeshedRegion

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.forward_meshes_container()
        >>> op.inputs.meshes.connect(my_meshes)
        >>> # or
        >>> op.inputs.meshes(my_meshes)
        """
        return self._meshes

    @property
    def default_label(self):
        """Allows to connect default_label input to the operator.

        This default label is used if a new meshes
        container needs to be created
        (default is unknown)

        Parameters
        ----------
        my_default_label : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.forward_meshes_container()
        >>> op.inputs.default_label.connect(my_default_label)
        >>> # or
        >>> op.inputs.default_label(my_default_label)
        """
        return self._default_label


class OutputsForwardMeshesContainer(_Outputs):
    """Intermediate class used to get outputs from
    forward_meshes_container operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.forward_meshes_container()
    >>> # Connect inputs : op.inputs. ...
    >>> result_meshes_container = op.outputs.meshes_container()
    """

    def __init__(self, op: Operator):
        super().__init__(forward_meshes_container._spec().outputs, op)
        self._meshes_container = Output(
            forward_meshes_container._spec().output_pin(0), 0, op
        )
        self._outputs.append(self._meshes_container)

    @property
    def meshes_container(self):
        """Allows to get meshes_container output of the operator

        Returns
        ----------
        my_meshes_container : MeshesContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.forward_meshes_container()
        >>> # Connect inputs : op.inputs. ...
        >>> result_meshes_container = op.outputs.meshes_container()
        """  # noqa: E501
        return self._meshes_container
