"""
bind_support
============
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class bind_support(Operator):
    """Tie a support to a field.

    Parameters
    ----------
    field : Field or FieldsContainer
        Field or fields container with only one field
        is expected
    support : MeshedRegion or AbstractFieldSupport
        Meshed region or a support of the field


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.bind_support()

    >>> # Make input connections
    >>> my_field = dpf.Field()
    >>> op.inputs.field.connect(my_field)
    >>> my_support = dpf.MeshedRegion()
    >>> op.inputs.support.connect(my_support)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.bind_support(
    ...     field=my_field,
    ...     support=my_support,
    ... )

    >>> # Get output data
    >>> result_field = op.outputs.field()
    """

    def __init__(self, field=None, support=None, config=None, server=None):
        super().__init__(name="BindSupport", config=config, server=server)
        self._inputs = InputsBindSupport(self)
        self._outputs = OutputsBindSupport(self)
        if field is not None:
            self.inputs.field.connect(field)
        if support is not None:
            self.inputs.support.connect(support)

    @staticmethod
    def _spec():
        description = """Tie a support to a field."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="field",
                    type_names=["field", "fields_container"],
                    optional=False,
                    document="""Field or fields container with only one field
        is expected""",
                ),
                1: PinSpecification(
                    name="support",
                    type_names=["abstract_meshed_region", "abstract_field_support"],
                    optional=False,
                    document="""Meshed region or a support of the field""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="field",
                    type_names=["field"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="BindSupport", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsBindSupport
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsBindSupport
        """
        return super().outputs


class InputsBindSupport(_Inputs):
    """Intermediate class used to connect user inputs to
    bind_support operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.bind_support()
    >>> my_field = dpf.Field()
    >>> op.inputs.field.connect(my_field)
    >>> my_support = dpf.MeshedRegion()
    >>> op.inputs.support.connect(my_support)
    """

    def __init__(self, op: Operator):
        super().__init__(bind_support._spec().inputs, op)
        self._field = Input(bind_support._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._field)
        self._support = Input(bind_support._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._support)

    @property
    def field(self):
        """Allows to connect field input to the operator.

        Field or fields container with only one field
        is expected

        Parameters
        ----------
        my_field : Field or FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.bind_support()
        >>> op.inputs.field.connect(my_field)
        >>> # or
        >>> op.inputs.field(my_field)
        """
        return self._field

    @property
    def support(self):
        """Allows to connect support input to the operator.

        Meshed region or a support of the field

        Parameters
        ----------
        my_support : MeshedRegion or AbstractFieldSupport

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.bind_support()
        >>> op.inputs.support.connect(my_support)
        >>> # or
        >>> op.inputs.support(my_support)
        """
        return self._support


class OutputsBindSupport(_Outputs):
    """Intermediate class used to get outputs from
    bind_support operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.bind_support()
    >>> # Connect inputs : op.inputs. ...
    >>> result_field = op.outputs.field()
    """

    def __init__(self, op: Operator):
        super().__init__(bind_support._spec().outputs, op)
        self._field = Output(bind_support._spec().output_pin(0), 0, op)
        self._outputs.append(self._field)

    @property
    def field(self):
        """Allows to get field output of the operator

        Returns
        ----------
        my_field : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.bind_support()
        >>> # Connect inputs : op.inputs. ...
        >>> result_field = op.outputs.field()
        """  # noqa: E501
        return self._field
