"""
workflow_import_json
====================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class workflow_import_json(Operator):
    """Import a workflow in json format.

    Parameters
    ----------
    json_workflow : str or DataSources
        Input json data as either a data source or a
        string


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.serialization.workflow_import_json()

    >>> # Make input connections
    >>> my_json_workflow = str()
    >>> op.inputs.json_workflow.connect(my_json_workflow)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.serialization.workflow_import_json(
    ...     json_workflow=my_json_workflow,
    ... )

    >>> # Get output data
    >>> result_workflow = op.outputs.workflow()
    """

    def __init__(self, json_workflow=None, config=None, server=None):
        super().__init__(
            name="serialization::workflow_import_json", config=config, server=server
        )
        self._inputs = InputsWorkflowImportJson(self)
        self._outputs = OutputsWorkflowImportJson(self)
        if json_workflow is not None:
            self.inputs.json_workflow.connect(json_workflow)

    @staticmethod
    def _spec():
        description = """Import a workflow in json format."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="json_workflow",
                    type_names=["string", "data_sources"],
                    optional=False,
                    document="""Input json data as either a data source or a
        string""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="workflow",
                    type_names=["workflow"],
                    optional=False,
                    document="""Instantiate workflow.""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(
            name="serialization::workflow_import_json", server=server
        )

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsWorkflowImportJson
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsWorkflowImportJson
        """
        return super().outputs


class InputsWorkflowImportJson(_Inputs):
    """Intermediate class used to connect user inputs to
    workflow_import_json operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.serialization.workflow_import_json()
    >>> my_json_workflow = str()
    >>> op.inputs.json_workflow.connect(my_json_workflow)
    """

    def __init__(self, op: Operator):
        super().__init__(workflow_import_json._spec().inputs, op)
        self._json_workflow = Input(
            workflow_import_json._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._json_workflow)

    @property
    def json_workflow(self):
        """Allows to connect json_workflow input to the operator.

        Input json data as either a data source or a
        string

        Parameters
        ----------
        my_json_workflow : str or DataSources

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.serialization.workflow_import_json()
        >>> op.inputs.json_workflow.connect(my_json_workflow)
        >>> # or
        >>> op.inputs.json_workflow(my_json_workflow)
        """
        return self._json_workflow


class OutputsWorkflowImportJson(_Outputs):
    """Intermediate class used to get outputs from
    workflow_import_json operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.serialization.workflow_import_json()
    >>> # Connect inputs : op.inputs. ...
    >>> result_workflow = op.outputs.workflow()
    """

    def __init__(self, op: Operator):
        super().__init__(workflow_import_json._spec().outputs, op)
        self._workflow = Output(workflow_import_json._spec().output_pin(0), 0, op)
        self._outputs.append(self._workflow)

    @property
    def workflow(self):
        """Allows to get workflow output of the operator

        Returns
        ----------
        my_workflow : Workflow

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.serialization.workflow_import_json()
        >>> # Connect inputs : op.inputs. ...
        >>> result_workflow = op.outputs.workflow()
        """  # noqa: E501
        return self._workflow
