"""
import_symbolic_workflow
========================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class import_symbolic_workflow(Operator):
    """Reads a file or string holding a Symbolic Workflow and instantiate a
    WorkFlow with its data.

    Parameters
    ----------
    string_or_path : str or DataSources
    format : int, optional
        0 is ascii format and 1 is binary, default is
        0.


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.serialization.import_symbolic_workflow()

    >>> # Make input connections
    >>> my_string_or_path = str()
    >>> op.inputs.string_or_path.connect(my_string_or_path)
    >>> my_format = int()
    >>> op.inputs.format.connect(my_format)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.serialization.import_symbolic_workflow(
    ...     string_or_path=my_string_or_path,
    ...     format=my_format,
    ... )

    >>> # Get output data
    >>> result_workflow = op.outputs.workflow()
    """

    def __init__(self, string_or_path=None, format=None, config=None, server=None):
        super().__init__(name="import_symbolic_workflow", config=config, server=server)
        self._inputs = InputsImportSymbolicWorkflow(self)
        self._outputs = OutputsImportSymbolicWorkflow(self)
        if string_or_path is not None:
            self.inputs.string_or_path.connect(string_or_path)
        if format is not None:
            self.inputs.format.connect(format)

    @staticmethod
    def _spec():
        description = """Reads a file or string holding a Symbolic Workflow and instantiate a
            WorkFlow with its data."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="string_or_path",
                    type_names=["string", "data_sources"],
                    optional=False,
                    document="""""",
                ),
                2: PinSpecification(
                    name="format",
                    type_names=["int32"],
                    optional=True,
                    document="""0 is ascii format and 1 is binary, default is
        0.""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="workflow",
                    type_names=["workflow"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="import_symbolic_workflow", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsImportSymbolicWorkflow
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsImportSymbolicWorkflow
        """
        return super().outputs


class InputsImportSymbolicWorkflow(_Inputs):
    """Intermediate class used to connect user inputs to
    import_symbolic_workflow operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.serialization.import_symbolic_workflow()
    >>> my_string_or_path = str()
    >>> op.inputs.string_or_path.connect(my_string_or_path)
    >>> my_format = int()
    >>> op.inputs.format.connect(my_format)
    """

    def __init__(self, op: Operator):
        super().__init__(import_symbolic_workflow._spec().inputs, op)
        self._string_or_path = Input(
            import_symbolic_workflow._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._string_or_path)
        self._format = Input(import_symbolic_workflow._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._format)

    @property
    def string_or_path(self):
        """Allows to connect string_or_path input to the operator.

        Parameters
        ----------
        my_string_or_path : str or DataSources

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.serialization.import_symbolic_workflow()
        >>> op.inputs.string_or_path.connect(my_string_or_path)
        >>> # or
        >>> op.inputs.string_or_path(my_string_or_path)
        """
        return self._string_or_path

    @property
    def format(self):
        """Allows to connect format input to the operator.

        0 is ascii format and 1 is binary, default is
        0.

        Parameters
        ----------
        my_format : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.serialization.import_symbolic_workflow()
        >>> op.inputs.format.connect(my_format)
        >>> # or
        >>> op.inputs.format(my_format)
        """
        return self._format


class OutputsImportSymbolicWorkflow(_Outputs):
    """Intermediate class used to get outputs from
    import_symbolic_workflow operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.serialization.import_symbolic_workflow()
    >>> # Connect inputs : op.inputs. ...
    >>> result_workflow = op.outputs.workflow()
    """

    def __init__(self, op: Operator):
        super().__init__(import_symbolic_workflow._spec().outputs, op)
        self._workflow = Output(import_symbolic_workflow._spec().output_pin(0), 0, op)
        self._outputs.append(self._workflow)

    @property
    def workflow(self):
        """Allows to get workflow output of the operator

        Returns
        ----------
        my_workflow : Workflow

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.serialization.import_symbolic_workflow()
        >>> # Connect inputs : op.inputs. ...
        >>> result_workflow = op.outputs.workflow()
        """  # noqa: E501
        return self._workflow
