"""
meshes_provider
===============
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class meshes_provider(Operator):
    """Read meshes from result files. Meshes can be spatially or temporally
    varying.

    Parameters
    ----------
    time_scoping : Scoping or int, optional
        Time/freq set ids required in output
    streams_container : StreamsContainer, optional
        Result file container allowed to be kept open
        to cache data
    data_sources : DataSources
        Result file path container, used if no
        streams are set
    read_cyclic : int, optional
        If 1 cyclic symmetry is ignored, if 2 cyclic
        expansion is done (default is 1)


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.mesh.meshes_provider()

    >>> # Make input connections
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_streams_container = dpf.StreamsContainer()
    >>> op.inputs.streams_container.connect(my_streams_container)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    >>> my_read_cyclic = int()
    >>> op.inputs.read_cyclic.connect(my_read_cyclic)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.mesh.meshes_provider(
    ...     time_scoping=my_time_scoping,
    ...     streams_container=my_streams_container,
    ...     data_sources=my_data_sources,
    ...     read_cyclic=my_read_cyclic,
    ... )

    >>> # Get output data
    >>> result_meshes = op.outputs.meshes()
    """

    def __init__(
        self,
        time_scoping=None,
        streams_container=None,
        data_sources=None,
        read_cyclic=None,
        config=None,
        server=None,
    ):
        super().__init__(name="meshes_provider", config=config, server=server)
        self._inputs = InputsMeshesProvider(self)
        self._outputs = OutputsMeshesProvider(self)
        if time_scoping is not None:
            self.inputs.time_scoping.connect(time_scoping)
        if streams_container is not None:
            self.inputs.streams_container.connect(streams_container)
        if data_sources is not None:
            self.inputs.data_sources.connect(data_sources)
        if read_cyclic is not None:
            self.inputs.read_cyclic.connect(read_cyclic)

    @staticmethod
    def _spec():
        description = """Read meshes from result files. Meshes can be spatially or temporally
            varying."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="time_scoping",
                    type_names=["scoping", "vector<int32>", "int32"],
                    optional=True,
                    document="""Time/freq set ids required in output""",
                ),
                3: PinSpecification(
                    name="streams_container",
                    type_names=["streams_container"],
                    optional=True,
                    document="""Result file container allowed to be kept open
        to cache data""",
                ),
                4: PinSpecification(
                    name="data_sources",
                    type_names=["data_sources"],
                    optional=False,
                    document="""Result file path container, used if no
        streams are set""",
                ),
                14: PinSpecification(
                    name="read_cyclic",
                    type_names=["enum dataProcessing::ECyclicReading", "int32"],
                    optional=True,
                    document="""If 1 cyclic symmetry is ignored, if 2 cyclic
        expansion is done (default is 1)""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="meshes",
                    type_names=["meshes_container"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="meshes_provider", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsMeshesProvider
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsMeshesProvider
        """
        return super().outputs


class InputsMeshesProvider(_Inputs):
    """Intermediate class used to connect user inputs to
    meshes_provider operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.mesh.meshes_provider()
    >>> my_time_scoping = dpf.Scoping()
    >>> op.inputs.time_scoping.connect(my_time_scoping)
    >>> my_streams_container = dpf.StreamsContainer()
    >>> op.inputs.streams_container.connect(my_streams_container)
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    >>> my_read_cyclic = int()
    >>> op.inputs.read_cyclic.connect(my_read_cyclic)
    """

    def __init__(self, op: Operator):
        super().__init__(meshes_provider._spec().inputs, op)
        self._time_scoping = Input(meshes_provider._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._time_scoping)
        self._streams_container = Input(meshes_provider._spec().input_pin(3), 3, op, -1)
        self._inputs.append(self._streams_container)
        self._data_sources = Input(meshes_provider._spec().input_pin(4), 4, op, -1)
        self._inputs.append(self._data_sources)
        self._read_cyclic = Input(meshes_provider._spec().input_pin(14), 14, op, -1)
        self._inputs.append(self._read_cyclic)

    @property
    def time_scoping(self):
        """Allows to connect time_scoping input to the operator.

        Time/freq set ids required in output

        Parameters
        ----------
        my_time_scoping : Scoping or int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.mesh.meshes_provider()
        >>> op.inputs.time_scoping.connect(my_time_scoping)
        >>> # or
        >>> op.inputs.time_scoping(my_time_scoping)
        """
        return self._time_scoping

    @property
    def streams_container(self):
        """Allows to connect streams_container input to the operator.

        Result file container allowed to be kept open
        to cache data

        Parameters
        ----------
        my_streams_container : StreamsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.mesh.meshes_provider()
        >>> op.inputs.streams_container.connect(my_streams_container)
        >>> # or
        >>> op.inputs.streams_container(my_streams_container)
        """
        return self._streams_container

    @property
    def data_sources(self):
        """Allows to connect data_sources input to the operator.

        Result file path container, used if no
        streams are set

        Parameters
        ----------
        my_data_sources : DataSources

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.mesh.meshes_provider()
        >>> op.inputs.data_sources.connect(my_data_sources)
        >>> # or
        >>> op.inputs.data_sources(my_data_sources)
        """
        return self._data_sources

    @property
    def read_cyclic(self):
        """Allows to connect read_cyclic input to the operator.

        If 1 cyclic symmetry is ignored, if 2 cyclic
        expansion is done (default is 1)

        Parameters
        ----------
        my_read_cyclic : int

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.mesh.meshes_provider()
        >>> op.inputs.read_cyclic.connect(my_read_cyclic)
        >>> # or
        >>> op.inputs.read_cyclic(my_read_cyclic)
        """
        return self._read_cyclic


class OutputsMeshesProvider(_Outputs):
    """Intermediate class used to get outputs from
    meshes_provider operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.mesh.meshes_provider()
    >>> # Connect inputs : op.inputs. ...
    >>> result_meshes = op.outputs.meshes()
    """

    def __init__(self, op: Operator):
        super().__init__(meshes_provider._spec().outputs, op)
        self._meshes = Output(meshes_provider._spec().output_pin(0), 0, op)
        self._outputs.append(self._meshes)

    @property
    def meshes(self):
        """Allows to get meshes output of the operator

        Returns
        ----------
        my_meshes : MeshesContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.mesh.meshes_provider()
        >>> # Connect inputs : op.inputs. ...
        >>> result_meshes = op.outputs.meshes()
        """  # noqa: E501
        return self._meshes
