"""
enrich_materials
================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class enrich_materials(Operator):
    """Take a MaterialContainer and a stream and enrich the MaterialContainer
    using stream data.

    Parameters
    ----------
    MaterialContainer :
    streams : StreamsContainer or FieldsContainer
    streams_mapping : Class Dataprocessing::Cpropertyfieldscontainer


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.logic.enrich_materials()

    >>> # Make input connections
    >>> my_MaterialContainer = dpf.()
    >>> op.inputs.MaterialContainer.connect(my_MaterialContainer)
    >>> my_streams = dpf.StreamsContainer()
    >>> op.inputs.streams.connect(my_streams)
    >>> my_streams_mapping = dpf.Class Dataprocessing::Cpropertyfieldscontainer()
    >>> op.inputs.streams_mapping.connect(my_streams_mapping)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.logic.enrich_materials(
    ...     MaterialContainer=my_MaterialContainer,
    ...     streams=my_streams,
    ...     streams_mapping=my_streams_mapping,
    ... )

    >>> # Get output data
    >>> result_MaterialContainer = op.outputs.MaterialContainer()
    """

    def __init__(
        self,
        MaterialContainer=None,
        streams=None,
        streams_mapping=None,
        config=None,
        server=None,
    ):
        super().__init__(name="enrich_materials", config=config, server=server)
        self._inputs = InputsEnrichMaterials(self)
        self._outputs = OutputsEnrichMaterials(self)
        if MaterialContainer is not None:
            self.inputs.MaterialContainer.connect(MaterialContainer)
        if streams is not None:
            self.inputs.streams.connect(streams)
        if streams_mapping is not None:
            self.inputs.streams_mapping.connect(streams_mapping)

    @staticmethod
    def _spec():
        description = """Take a MaterialContainer and a stream and enrich the MaterialContainer
            using stream data."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="MaterialContainer",
                    type_names=["any"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="streams",
                    type_names=["streams_container", "fields_container"],
                    optional=False,
                    document="""""",
                ),
                2: PinSpecification(
                    name="streams_mapping",
                    type_names=["class dataProcessing::CPropertyFieldsContainer"],
                    optional=False,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="MaterialContainer",
                    type_names=["bool"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="enrich_materials", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsEnrichMaterials
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsEnrichMaterials
        """
        return super().outputs


class InputsEnrichMaterials(_Inputs):
    """Intermediate class used to connect user inputs to
    enrich_materials operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.logic.enrich_materials()
    >>> my_MaterialContainer = dpf.()
    >>> op.inputs.MaterialContainer.connect(my_MaterialContainer)
    >>> my_streams = dpf.StreamsContainer()
    >>> op.inputs.streams.connect(my_streams)
    >>> my_streams_mapping = dpf.Class Dataprocessing::Cpropertyfieldscontainer()
    >>> op.inputs.streams_mapping.connect(my_streams_mapping)
    """

    def __init__(self, op: Operator):
        super().__init__(enrich_materials._spec().inputs, op)
        self._MaterialContainer = Input(
            enrich_materials._spec().input_pin(0), 0, op, -1
        )
        self._inputs.append(self._MaterialContainer)
        self._streams = Input(enrich_materials._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._streams)
        self._streams_mapping = Input(enrich_materials._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._streams_mapping)

    @property
    def MaterialContainer(self):
        """Allows to connect MaterialContainer input to the operator.

        Parameters
        ----------
        my_MaterialContainer :

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.logic.enrich_materials()
        >>> op.inputs.MaterialContainer.connect(my_MaterialContainer)
        >>> # or
        >>> op.inputs.MaterialContainer(my_MaterialContainer)
        """
        return self._MaterialContainer

    @property
    def streams(self):
        """Allows to connect streams input to the operator.

        Parameters
        ----------
        my_streams : StreamsContainer or FieldsContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.logic.enrich_materials()
        >>> op.inputs.streams.connect(my_streams)
        >>> # or
        >>> op.inputs.streams(my_streams)
        """
        return self._streams

    @property
    def streams_mapping(self):
        """Allows to connect streams_mapping input to the operator.

        Parameters
        ----------
        my_streams_mapping : Class Dataprocessing::Cpropertyfieldscontainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.logic.enrich_materials()
        >>> op.inputs.streams_mapping.connect(my_streams_mapping)
        >>> # or
        >>> op.inputs.streams_mapping(my_streams_mapping)
        """
        return self._streams_mapping


class OutputsEnrichMaterials(_Outputs):
    """Intermediate class used to get outputs from
    enrich_materials operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.logic.enrich_materials()
    >>> # Connect inputs : op.inputs. ...
    >>> result_MaterialContainer = op.outputs.MaterialContainer()
    """

    def __init__(self, op: Operator):
        super().__init__(enrich_materials._spec().outputs, op)
        self._MaterialContainer = Output(enrich_materials._spec().output_pin(0), 0, op)
        self._outputs.append(self._MaterialContainer)

    @property
    def MaterialContainer(self):
        """Allows to get MaterialContainer output of the operator

        Returns
        ----------
        my_MaterialContainer : bool

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.logic.enrich_materials()
        >>> # Connect inputs : op.inputs. ...
        >>> result_MaterialContainer = op.outputs.MaterialContainer()
        """  # noqa: E501
        return self._MaterialContainer
