# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2017-04-27 21:14
from __future__ import unicode_literals

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='LastUsageLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('used_date', models.DateTimeField()),
                ('referer', models.TextField()),
                ('user_agent', models.TextField()),
                ('ip', models.GenericIPAddressField()),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UrlMapping',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('source_url', models.CharField(max_length=200, unique=True)),
                ('target_url', models.CharField(max_length=200)),
                ('expire_after', models.DurationField(default=datetime.timedelta(180), help_text='Time of inactivity after which the mapping expires. Format: "DD HH:MM:SS"')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UrlRegexpMapping',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('source_mapping', models.CharField(max_length=200, unique=True)),
                ('target_mapping', models.CharField(max_length=200)),
                ('expire_after', models.DurationField(default=datetime.timedelta(180), help_text='Time of inactivity after which the mapping expires. Format: "DD HH:MM:SS"')),
                ('mapping_duration', models.DurationField(default=datetime.timedelta(180), help_text='Time of inactivity after which the created url mapping expires. Format: "DD HH:MM:SS"')),
                ('test_source_url', models.CharField(help_text='<b><span style="color: red;">You are in the debug mode - url mapping is disabled. You can test it here only.</span></b>', max_length=200)),
                ('test_target_url', models.CharField(help_text='Provide example old/new urls you are attempting to map. Test urls will be used to test your regexp mappings.<br>For example <b>/a/(?P&lt;pk&gt;[0-9]+)/</b> mapping with <b>/b/\\g&lt;pk&gt;/</b> target mapping will change /a/1/ to /b/1/.', max_length=200)),
                ('last_usage', models.OneToOneField(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to='url_migration.LastUsageLog')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RegexpGeneratedMapping',
            fields=[
                ('urlmapping_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='url_migration.UrlMapping')),
                ('regexp', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='url_migration.UrlRegexpMapping')),
            ],
            options={
                'abstract': False,
            },
            bases=('url_migration.urlmapping',),
        ),
        migrations.AddField(
            model_name='urlmapping',
            name='last_usage',
            field=models.OneToOneField(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to='url_migration.LastUsageLog'),
        ),
    ]
