##################################################################################
# ASCII Art
##################################################################################

import os

eda_toolkit_logo = r""" 

███████╗██████╗  █████╗       ████████╗ ██████╗  ██████╗ ██╗     ██╗  ██╗██╗████████╗
██╔════╝██╔══██╗██╔══██╗      ╚══██╔══╝██╔═══██╗██╔═══██╗██║     ██║ ██╔╝██║╚══██╔══╝
█████╗  ██║  ██║███████║█████╗   ██║   ██║   ██║██║   ██║██║     █████╔╝ ██║   ██║   
██╔══╝  ██║  ██║██╔══██║╚════╝   ██║   ██║   ██║██║   ██║██║     ██╔═██╗ ██║   ██║   
███████╗██████╔╝██║  ██║         ██║   ╚██████╔╝╚██████╔╝███████╗██║  ██╗██║   ██║   
╚══════╝╚═════╝ ╚═╝  ╚═╝         ╚═╝    ╚═════╝  ╚═════╝ ╚══════╝╚═╝  ╚═╝╚═╝   ╚═╝   
                                                                                                                                                                                                                                            
"""

###################################################################################

leon_shpaner_bb = """
                             Leon Shpaner                                   
                                                           
                            ...............                                        
                        .......................                                    
                      ...........................                                  
                    ...............................                                
                  ..............:;xxxXXxx+:..........                              
                 ........::;+xxx$$$$$$$&$$Xx:.........                             
                ....:;+xxxxXXX$$$$$$$$$$$$$$x.........                             
                ...;xxXxXX$$$$$$$$$$$$$$$$$$$+.........                            
               ...:+xxxxXX$$$$$$$$$$$$$$$$$$$X;........                            
               ...;+xxxxXXX$$$$$$$$$$$$$$$$$$Xx:.......                            
               ..;;;+xxxxxXX$$$$$$$$$$$&$$$$$Xxx........                           
               ..:;+xxxxxXX$$$$$$$$$$$$$$$$$XXXx;.......                           
               ..:;+xxxXX$$$$$$$$$$$$$$$$$$$$XXx+.......                           
               ..;+xxxxxxXX$$XXX$$$$$$$$$$$$$$$Xx:....:xX                          
               ..;++xxx++xxxxxxx+::...::;+xxx$$$X:...:;;xx                         
               ..:........::xxx;:..::+xxxxxxX$$$$x.:+X$x+X                         
               ..:..:::....:xX$x;::::...;;xX$$$$$X::;X$XxX                         
               :.;::....::::x$$$xxxxxxxXX$$$$$$$XX;:xxxXxX                         
               ;.;+x+xxxxxx+x$$$$$$$$$$$$&&&&$$$Xx:x$$X$XX                         
               ::+xxXX$$$Xxxx$&$$$$$$$$&&&&&&&$$$x;xx$&$$                          
               ;;;xxX$$$XxxxX$&&$$XxxX$$$&&&&$$$Xx+;$&$$X                          
                ::xxxxxx++xX$&&&$&$xx;+xxxXXX$$$x;++&$$X                           
                .:;++x+;::::+xx;::+xXx;:;+xxxX$x+;;;x                              
                .:;;;;::::.....:.:::;;::;+xXXXxx;::;;                              
                ..;;;:...........:::::...:xXxxx;;;:;:                              
                 ..:;:.....::::;+xxx;;;:::+xx+;::::;                               
                 ..::::.::::;+xxxxXXXXXx:;;;:::::..x                               
                  .....:;;;;+xxxxxxXX$Xx;::::::...+$X&                             
                   ......;++;;;+xxXX$$x;:.::.....:x$:&&                            
                   .......;xxxxX$$$$Xx;.........:x$$x&&;::                         
                    .......:;;+;;;;;;:.........;x$$&&&&$:::                        
                     ........................:xX$$&&&&&X:::::                      
                       .....................;xXXX&&&&&x:::::::                     
                       $x;................:xxXX&&&&&&;::::::::::                   
                      $$x+:...........::;xxxX&&&&&&&::::::::::::;:;                
                     &&$Xx;.:;+++;;;++xxxxxX&&&&&&x:::::::::::::::::;;;::          
                    &&&&&X;:.;xxxxxxxxxxxx&&&&&&&;::::::::::::.:::::::::::;:::     
                  :+&$&&&$x+::xxxxXXXxxx&&&&&&&&::::::::::::...::::::::::::::::::: 
             .:::::$&$&&&&&X::xX$XX$X$&&&&&&&&X:::::..........:::::::::::::::::::::
         :::::....:$&&$&&&&&;:;X$$$$&&&&&&&&&x:::..::.::::.::::::::::::::::::::::::
    ::::::::.:.....+&&&$$&&&+;+x$$&&&$&&&&&&+::::::::..::::::::.:.:::.:.::::.::::::
  ::::::::......:..:&&&Xx$&&x+xx&&&&$$&&&&&;:::::::::::::...:::::.::....::::...::::
::::::......::.....:$&$x$$&&&XX&&&&&$$$&&$;:::::..::::::...:..::.:::..:..:....:::..
::::::::..:.:::...::;&$&&&&&&&&&&&&&&$$&X::::::::..:::....:::.::..:................
......::::.:::::.:..:$&&&&&&&&&&&&&&&&&x:::::::::::::...:...........:.:.....::...::
"""

###################################################################################

leon_shpaner_wb = """

                             Leon Shpaner

                            @@@@@@@@@@@@@@@                                        
                        @@@@@@@@@@@@@@@@@@@@@@@                                    
                      @@@@@@@@@@@@@@@@@@@@@@@@@@@                                  
                    @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                                
                  @@@@@@@@@@@@@@%#*++==++#@@@@@@@@@@@                              
                 @@@@@@@@@%%#*++==-------==+@@@@@@@@@@                             
                @@@@@##*+++========--------=*@@@@@@@@@                             
                @@@%++=+=========-----------=#@@@@@@@@@                            
               @@@%#++++==========----------==%@@@@@@@@                            
               @@@##**++=======-=-----------==+@@@@@@@@                            
               @@%###*++++=========---------==++@@@@@@@@                           
               @@%##**+++========----------====+#@@@@@@@                           
               @@%##*++=========-----------====+#@@@@@@@                           
               @@%#*+++++=============-----=====+@@@@@@+=                          
               @@%##***##**++++*#%@@@@@%##*++====%@@@%#%*+                         
               @@@@@@@@@@@@%*+*%@@@@%#++++*+=====*@@#==*#=                         
               @@@@@%%@@@@@@*==+%%@@@@@@%#+==--===@%#===*=                         
               @@%%@@@@@@%@%+=-=++***++===-----===%%+++=+=                         
               %@##*#*+++++#+=----====--------===+%*--====                         
               %@#++======+*=------------------==+#*+=-=-                          
               %%%*+=====+**=----==++===-------==*##----=                          
                @%*+++++##*==------**##*++======+###---=                           
                @@###*#%%%@@#**%@@#+=+#%%#**+==+#%##*                              
                @@%%%%%@@@@@@@@@@@@%#%%@%#+===++#%%%%                              
                @@%%%%@@@@@@@@@@@@@@@@@@@%+=++*##%@%%                              
                 @@%#%@@@@@@@%%%#*++%##%@@#+*##%%@@#                               
                 @@@@%@@@%@%##*+++=====*%%#%%%%@@@@+                               
                  @@@@@@%####*+++++====*%@@%@@@@@@#==:                             
                   @@@@@@%######*++===+#@@@@@@@@@%+=%-.                            
                   @@@@@@@%*+++=====++%@@@@@@@@@@+--+.:#%%                         
                    @@@@@@@@%%#####%%%@@@@@@@@@%+---...-%%%                        
                     @@@@@@@@@@@@@@@@@@@@@@@@@*===:....=%@%@@                      
                       @@@@@@@@@@@@@@@@@@@@@#+===.....+@@@@%%%                     
                       -*%@@@@@@@@@@@@@@@@%*+==-....:%@@@@@@@%%%                   
                      -=+#%@@@@@@@@@@@@%#*++=-.....-@@@@@@@@@%%%%%%                
                     ::-=+%@%#########*++++=......+@@@@@@@@@@%@@@%%%%%%%%          
                    ...--=#@@#***+++++++++-......%@@@@@%@@@@@@@@@@@@@%%%%%%%%%     
                  @#--..:-+#@%++++===+++-......:%@@@@@%@%@@@@@@@@@@@@@%@%%%%%%%%%% 
             @@@@@@=:--..:-=%%*=======-.......=%@@@@@@@@@@@@@@@@@@@@@@@@@@@%%%%%%%%
         @@@@@@@@@@=:--:...-%%#=------.......+%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    %%%@@@@@@@@@@@@#.:--=:..#%#+--:----....:#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@%..-=*-..+#++-------...-#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@=.-+--:..==-:..:---..-%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@#:=::--..::.:::-----=%%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@%=....:........:::-*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
"""

###################################################################################

oscar_gil_bb = """
                                  Oscar Gil

                                 .............                                     
                              ....................                                 
                         ............................                              
                       .................................                           
                     .....................................                         
                    ..................-....................                        
                    .........:==+++*****++++++===---........                       
                    .......==+++******#*###********+++-......                      
                    ......=++++****#############****+++=.....                      
                    .....-+++++***##############*****+++:....                      
                    ....-++++++**################*****++-....                      
                    ....=++++++***################***+++=.....                     
                    ...-++++++***##################***++=....:                     
                    ...==+++++***###################**+++-...:                     
                    ...===+++++++**#########*********++++=...-                     
                     ..-+==:........-=+##*+=-.....:--=+++=...                      
                     ..:==-:::-::..:.:=*##+--:.:------=++-.-=+                     
                     =--====-.::--+====*##+++==-.::-=++++=.+*#                     
                     ====+++++++++*+++++##++*++++++**#*+++++*#                     
                      ===++**#*##*#*+++*##++**#########*++***                      
                      +==++*#######*+++###*+**########*+++*+                       
                      +===++*####**++++###*****#######*++=**                       
                      +===+++*****+=..=+++=--+***####*++++**                       
                        +++=++++==---......:=-==+****++++==                        
                        =++++++-..--=+++=++++=---+***+**+=                         
                        =+++++++==::=++++**++----=**+**++                          
                         -===++++=+==+++++++++++++*++*+=-                          
                          ----==++==+++++++++++++++=+=--                           
                           ...:=++++++=====++++++===---=                           
                           ::...-=++*#######**++=----=+++                          
                            --....-=++*###***+=:----++++*+-=                       
                            -=-.....:-=====--:--:-=+*+++***=+===                   
                       :::..-===:............::-=+****+***+==------===             
                    -:-::--====+=-.........:--=*##****##*+==-------------          
               =------::--=++++++++==-:--==+***********===--------------------     
          ----------:--::-=+++++++++++++**********##*=--:-------------------------=
     ----------------::-::-=++++++++++*********#*++=--:------------------------=---
  ----------------:::::::::--=+**********##*+=-------:-----------------------------
 ---=--------------:::-::-::.:------=---------:::::-::------:----------------==----
---------------------:::-----::.:::::-:--:.::::-------------==-----------=-----=---
------=-----:---:-------:::--:::-:::--::-::---:------------------------------------                  
"""

###################################################################################

oscar_gil_wb = """
                                  Oscar Gil

                                 @@@@@@@@@@@@@                                     
                              @@@@@@@@@@@@@@@@@@@@                                 
                         @@@@@@@@@@@@@@@@@@@@@@@@@@@@                              
                       @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                           
                     @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                         
                    @@@@@@@@@@@@@@@@@@%@@@@@@@@@@@@@@@@@@@@                        
                    @@@@@@@@@@##**+++++++++++*###%%%@@@@@@@@                       
                    @@@@@@@##*++++++++=+==++++++++++++%@@@@@@                      
                    @@@@@@#**++++++=============+++++++#@@@@@                      
                    @@@@@%*+++++++==============+++++++*@@@@@                      
                    @@@@%**++++++===============++++++++%@@@@                      
                    @@@@#***++++++================++++++#@@@@@                     
                    @@@%***++++++==================+++++#@@@@@                     
                    @@@##**++++++===================+++++%@@@@                     
                    @@@###**+*+++++=========+++++++++++++#@@@%                     
                     @@%###@@@@@@@@@%#+==++#%@@@@@@%%#*++#@@@                      
                     @@@##%@@@%@@@@@@@#+==*%%@@@%%%%%%#++%@%#*                     
                     ##%%####%@@@%%*####+==***##%@@@%#*+++#@++                    
                     ####*++++**++++++*+==+++++++++++=+++**++=                     
                      ###*+++=+==+=++**+==++++========++**+++                      
                      *##*++=======++*+===++++========++**++                       
                      *###*++====++++*+===+++++=======++*#++                       
                      *###*++++++++#@@#+++#%%*+++===++++**++                       
                        ***#*++*##%%%@@@@@@@#%##*+++++++*##                        
                        #*+**++%@@%%#*+*#*+**#%%%*++++++*#                         
                        #****++*##@@#*++++++*%%%%#++++++*                          
                         %###*+++#*##*++++++**++++++++*#%                          
                          %%%%##+*##**********+++**#*#%%                           
                           @@@@#**+***#####*+++++###%%%#                           
                           @@@@@%#*++=======+++*#%%%%#*+*                          
                            %%@@@@%#*++===+++*#@%%%%*+++++%#                       
                            %#%@@@@@@%#####%%@%%@%#++++++++#*###                   
                       @@@@@%###@@@@@@@@@@@@@@@%#+++++++++*##%%%%%%###             
                    %@%@@%%####*#%@@@@@@@@@@%%#+=+++++==+*##%%%%%%%%%%%%%          
               ##%%%%%%@@%%#+****+**##%@%%##++++++++++++##%%%%%%%%%%%%%%%%%%%%%     
          %%%%%%%%%%@%%@@%#+++**++++++++++++++++++==+#%%@%%%%%%%%%%%%%%%%%%%%%%%%%#
     %%%%%%%%%%%%%%%%@@%@@%#+++++++++++++++++++=++*%%%@%%%%%%%%%%%%%%%%%%%%%%%%#%%%
  %%%%%%%%%%%%%%%%@@@@@@@@@%%#*++++++++++==++#%%%%%%%@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%#%%%%%%%%%%%%%%@@@%@@%@@@@%%%%%%#%%%%%%%%%@@@@@%@@%%%%%%@%%%%%%%%%%%%%%%%##%%%%
%%%%%%%%%%%%%%%%%%%%%@@@%%%%%@@@@@@@@%@%%@@@@@@%%%%%%%%%%%%%##%%%%%%%%%%%#%%%%%#%%%
%%%%%%#%%%%%@%%%@%%%%%%%@@@%%@@@%@@@%%@@%@@%%%@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
"""

###################################################################################
grey_alien_wb = """
                           +-:::::::::::::::-=+                                    
                     +::........:::::::::::-:::::::=#                              
                 *:...........::::::::::::-----:-:--:::=                           
               -...........:.::::::::::::::-:-----------::=                        
             -:.....::::::......::::::---------------------:=                      
            :...::...:::::::.::::::::::------------::--------:=                    
          =...:.::.....:::::::::::::::::-----------::::--:-----:=                  
         =:....:.:.::.::::::::.::::::::-----==---:::::::--:-----:-                 
        -:::.:::::::::.......::::::::::----====--:::::::--------=--#               
       =:::::::::::::..::......::::::::----====--::::::--------=====*              
      +::....::::::.:....::::::::::::::----====--:::::---------======#             
      ::.....::::::::::...:......:::::::----===----::-----=========++*             
     -:.::::.:::::::.::::.......::::::::----====--------=-========++*+#            
    +:::....::::::::.::::::.:::.:::::::::----===-=-----==========++****#           
   +::::..::.:::::::::-:::...::::::.::::::-----==-============+++++*##*#           
   =::.::::::::::::::::::.:::.:...::::::::::-----===+++==+++++++++**####%          
  +:::.:::::::::::::::...............::::::::----===+++++++++++****######          
  -::....:::::::::::::...........:::::::::::::---===++++++++**+***###%%%#@         
 *:........:::::::::::......::::::---------------===++*+*++*****####%%%%%%         
 -:........::::---::::.::::---=++**########*++++++==++******#*#***##%%%%%%         
=::::::::..::::--:::::::--=+*%@@@@@@%#***##%@@%#*++*+*###*##########%%@@%%@        
=--====--::::::---::::-=+*%@@@@%*+*#%%@@@%%#*++#%*++**#%%###%%#####%%@@@@%@        
*#%%@@%#+=--:::---::-=+*%@@@@##@@%%%%%%%@@@@@@@#*#+++*%%@%%%%%%###%%%@@@@%@        
%@***#%@@@#*+-------=*#%@@@%*@@@@@%%%%@%@@@@@@@+#==+*#@@@@@@@%%%%%%%@@@@@%@        
@%@@@@@%**%@%*=-----+#%%@@##@@@@@@@@@@@@@@@@@@*##=-+*%@@@@@@@@%%%%%@@@@@@@         
%@@@@@@%%%%*%%#=---=+#%%@%*@@@@@@@@@@@@@@@@@@#%@=-=*#%@@@@@@@@@%@@@@@@@@@@         
%@@@@@@@@@@@%*%*=--=+*####*@@@@@@@@@@@@@@@@%*%%=-=+#%@@@@@@@@@@@@@@@@@@@@          
#@@@@@@@@@@@@@**+---=++**#*@@@@@@@@@@@@@@%*@@%+-=+#%@@@@@@@@@@@@@@@@@@@@@          
*%@@@@@@@@@@@@@*=:::--=+=#*%#@@@@@@@@%**#@@%*===+*%@@@@@@@@@@@@@@@@@@@@@           
 +@@@@@@@@@@@@@+-:..:::-=+*+++++**##%@@@%%+=-==*#%@@@@@@@@@@@@@@@@@@@@@            
 @*#@@@@@%#*++*+:..::::::----=+*##%##*+-----=+*%@@@@@@@@@@@@@@@@@@@@@@             
  *@@@%%%##*=--:-:--:::::::::::::::::::---=+*#@@@@@@@@@@@@@@@@@@@@@@@              
  %==+*+=--::::-#:+@*--:::::::::::::---=+*#%@@@@@@@@@@@@@@@@@@@@@@@                
   #+-::::::::--=:==-:---:::::::-----=+*#@@@@@@@@@@@@@@@@@@@@@@@@                  
     #=--::-:--:::::::::---::--==++*#%@@@@@@@@@@@@@@@@@@@@@@@@@@                   
      @#*===----::::::-::--=--==+*%@@@@@@@@@@@@@@@@@@@@@@@@@@@@                    
          %+=--:::::::::----=====+*##%@@@@@@@@@@@@@@@@@@@@@@@@                     
          @#=--:--::---------===+****#%%@@@@@@@@@@@@@@@@@@@@@                      
           %+=====+++++=+====++=+*****##%%@@@@@@@@@@@@@@@@@                        
            %+#@@%%%%%%%@%+=+++++++++*##%@@@@@@@@@@@@@@@@                          
             *=+=+++====--=+**++++++*#%@@@@@@@@@@@@@@@@                            
             %*====----==++**+++**#%@@@@@@@@@@@@@@@@@                              
              %=::::::::-==+++**#%@@@@@@@@@@@@@@@@@@@                              
               #=-:::---=+*###%@@@@@@@@@@@@@@@@@@@@@@                              
                %*++++*#%@@@@@@@@@@@@@@@@@@@@@@@@@@@@                              
                  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                              
                     @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                              
                           @@@@@@@@@@@@@@@@@@@@@@@@@@                              
                             @@@@@@@@@@@@@@@@@@@@@@@@@                             
                             @@@@@@@@@@@@@@@@@@@@@@@@@                             
                              @@@@@@@@@@@@@@%@@@@%%%%@%                            
                              @@@@@@@@@@@@%%%@@%%%%%##%%                           
                              @@@@@@@@@@%%##%%%###%######%                         
                              @@@@@@@@@%#***%@***####*******                       
                              %#%@@@@%%#*++*%#++***##*++++++++*                    
                             ***#######*+++*#**+++*##*+==========                  
                          *==+*+*******===+**+*++++***+==-=--------=+              
                       +=--==+==***++++=-=+++***+==**++===------------=            
                    *=---===++==++++++===+++++#*+============------===---*         
                 *============-=+++++=--=++==+**==-----==========--===-====#       
               +---====---==+=-=+=====-=+==--==+==--------==-==---------:-=+*#     
             =---::------=-==--======-=++==----==------------:::::-:------::-=-*   
           +---:----::----==--=+====--====---------::::::--:---:::::-------=--:-=  
          ----::-=+=----------=====-:------------:::----====---:::-:--------=+====*
         ---:::-=====----::::-==-=-::-:::----------====+++==---::::::---::---=====+
        =--:::--=-===---::::::----::::::-------===============--::::::::----=====++
       =---:::-=-----==--::--------::::----==-------------=====--::::--------====++
      +----:-------------::----=--::::---------------------====----:::-------====++
"""


###################################################################################

grey_alien_bb = """
                           +#%%%%%%%%%%%%%%%#*+                                    
                     +%%@@@@@@@@%%%%%%%%%%%#%%%%%%%*-                              
                 =%@@@@@@@@@@@%%%%%%%%%%%%####%%#%##%%%*                           
               #@@@@@@@@@@@%@%%%%%%%%%%%%%%%%###########%%*                        
             #%@@@@@%%%%%%@@@@@@%%%%%%####%################%*                      
            %@@@%%@@@%%%%%%%@%%%%%%%%%%#%##########%%########%*                    
          *@@@%@%%@@@@@%%%%%%%%%%%%%%%%%###########%%%%%#%#####%*                  
         *%@@@@@@%@%%@%%%%%%%%@%%%%%%%%#####**###%%%%%%%##%#####%#                 
       # #%%%@%%%%%%%%%@@@@@@@%@%%%%%%%%####****##%%%%%%%#%######*##-               
       *%%@%%%%%%%%%%@@%%@@@@@@%%%%%%%%%###****##%%%%%%########*****=              
      +%%@@@@@%%%%%@%@@@@%%%%%%%%%%%%%%####****##%%%%%%########******-             
      %%@@@@@%%%%%%%%%%@@@%@@@@@@%%%%%%%####***####%%#####*********++=             
     #%@%%%%@%%%%%%%@@%%%@@@@@@@%%%%%%%%####****########*#********++=+-            
    +%%%@@@@%%%%%%%%@%%%%%%@%%%@%%%%%%%%%####***#*#####**********++====-           
   +%%%%@@%%@%%%%%%%%%%%%%@@@%%%%%%@%%%%%%#####**#*************++++=--=-           
   *%%@%%%%%%%%%%%%%%%%%%@%%%@%@@@%%%%%%%%%%#####***+++**+++++++++==----:          
  +%%%@%%%%%%%%%%%%%%%@@@@@@@@@@@@@@@%%%%%%%%####***+++++++++++====------          
  ##%%@@@@%%%%%%%%%%%%%@@@@@@@@@@@%%%%%%%%%%%%%###***++++++++==+===---:::-.         
 =%@@@@@@@@%%%%%%%%%%%@@@@@@%%%%%%###############***++=+=++=====----::::::         
 #%@@@@@@@@%%%%##%%%%%@%%%%###*++==--------=++++++**++========-===--::::::         
*%%%%%%%%@@%%%%%#%%%%%%%##*+=:......:-===--:..:-=++=+=---=----------::..::.        
*##****##%%%%%%###%%%%#*+=:....:=+=-::...::-=++-:=++==-::---::-----::....:.        
==::..:-+*##%%%###%%#*+=:....--..:::::::.......-=-+++=::.::::::---:::....:.        
:.===-:...-=+##%####*=-:...:=.....::::.:.......+-**+=-.......:::::::... .:.        
.:.....:==:.:=*#####+-::..--..................=--*#+=:........:::::...  ..         
:......::::=::-*###*+-::.:=..................-:.*#*=-:.  ......:.....   ..         
:...........:=:=*##*+=----=................:=::*#*+-:. .     .......   ..          
-.............==+###*++==-=........... ..:=..:+#*+-:..       ......    .           
=:.............=*%%%##*+*-=:-........:==-..:=***+=:..        .....                 
 +....    .....+#%@@%%%#*+=+++++==--:...::+*#**=-:..         ...                   
 .=-.....:-=++=+%@@%%%%%%####*+=-----=+#####*+=:..         ..                      
  =...:::--=*##%#%##%%%%%%%%%%%%%%%%%%%###*+=-..                                   
  -**+=+*##%%%%#-%+.=##%%%%%%%%%%%%%%##**=-:... ....                               
   -+#%%%%%%%%##*%**#%###%%%%%%%#####*+=-..........                                
     -*##%%#%##%%%%%%%%%%##%%##**++=-:............                                 
      .-=***####%%%%%%%%%##*##**+=:...............                                 
          :+*##%%%%%%%%%%%##*****+=--:.......... .... ...                          
          .-*##%##%%%########***+====-::....    ...                                
           :+*****+++++*+****++*+=====--::... ....                                 
            :+-..:::::::.:+*+++++++++=--:........    .                             
             =*+*+++****##*+==++++++=-:.. ......    .                              
             :=***#####**++==+++==-:...........  . ..                              
              :*%%%%%%%%#**+++==-:............   ....                              
               -*#%%%###*+=-=-:..............    ....                              
                :=++++=-:..................    ......                              
                   ........................    ......                              
                     .....................     ......                              
                             ............     .......                              
                               ..  ...      ... ......                             
                                     ..    ...........                             
                                .... ..  ...:....::::.:                            
                                 ....  ...:::..:::::--::                           
                              ..      ..::--:::----------:                         
                              ...   ...:-===:.===----=======                       
                              :-:....::-=++=:-++===--=++++++++=                    
                             ===-------=+++=-==+++=--=+**********                  
                          =**+=+=======***+==+=++++===+**#*########*+              
                       +*##**+**===++++##*+++===+**==++***############*            
                    =*###***++**++++++***+++++-=+************######***###=         
                 =************#*++*++*##*++**+==**#####**********##***#****-       
               +###****###**+*#*+*****#*+**##**+**########**#**#########%#*+=-     
             *###%%######*#**##******#*++**####**############%%%%%#%######%%#*#=   
           +###%####%%####**##*+****##****#########%%%%%%##%###%%%%%#######*##%#*  
          ####%%#*+*##########*****#%###########%%%%####****###%%%#%###%####******=
         ###%%%#*****####%%%%#**#*#%%#%%%%#########****+++**##%%%%%%%###%%###*****+
        *##%%%##*#***###%%%%%%####%%%%%%%######***************##%%%%%%%%####*****++
       *###%%%#*#####**##%%########%%%%####**#############*****##%%%%########****++
      +####%#############%%%###*##%%%%##########%##########*#**####%%%%######****++
"""


###################################################################################
royce_hall_bb = """
                -============+                       -============-                
                :===-+=-=====+                      --====-====-==-                
                -==-:+--+.====+                     -:===.-===:-==-                
                -==-.+.:+.====+                     ::===.====.-===                
                ===-.+:-+.====+   UCLA Royce Hall   ::===.====.===-                
                ===++++++++====                     ::==++++++++===                
                ===============                     ::=============                
                ===============                     -:=============                
                ===============     ==+==-==+==     -:=============                
                ===============+============-======+-:=============                
                ====================-+======-+=====================                
                ====================-+=::-::========-==============    :.....-     
.................==============-.::-=*-=-===-+==::.-==============:................
-----------------===-========+---..--*=-::---+--..-:-====.=========================
-----------------============+--....=*--...-=+-....--==============================
..-----..-----:.:==++========+-:....=*-:...:-+-....:-=============-.-=====..=====..
..-----..-----:.:===-========+++++++++++++++++++++++++===.========-.-=====..=====..
.:-----..-----:.-====+=======+++++++++++++++=+++++++++====-====-==-.-=====.:=====:.
-:--.:::::----:-:============++-::-=++*=---=++*=-::-++============-=-=====-----==-=
++++=++++++------============+--....=+=.....=+-....:-+============+++++++++++++++++
++++=++++++------============+-:=====+--===-=+=====:-+============+++++++++++++++++
+-.-.--.==.::.-.-====--..====+------=+------=+=----:-+====.---====-.=.-:.=+.-:.-.-+
+:.-.:-.+=....-..===-.-..====+---..-=+--..:-=+=:..-:-+====.::.-=-=:.=.-:.=+.-..-.:+
                    .......==+------=+---:--=+=-:----+==.                                                                                                                             
"""

###################################################################################

royce_hall_wb = """
                %############+                       %############%                
                @###%*#%#####*                      %%####%####%##%                
                %##%@*%%*@####*                     %@###@%###@%##%                
                %##%@+@@*@####*                     @@###@####@%###                
                ###%@+@%*@####*                     @@###@####@###%                
                ###********####   UCLA Royce Hall   @@##********###                
                ###############                     @@#############                
                ###############                     %@#############                
                ###############     ##*##%##*##     %@#############                
                ###############*############%######*%@#############                
                ####################%+######%*#####################                
                ####################%+#@@%@@########%##############    @@@@@@%     
@@@@@@@@@@@@@@@@@##############%@@@%#+%#%###%*##@@@%##############@@@@@@@@@@@@@@@@@
%%%%%%%%%%%%%%%%%###%########*%%%@@%%+#%@@%%%+%%@@%@%####@#########################
%%%%%%%%%%%%%%%%%############*%%@@@@#+%%@@@%#+%@@@@%%##############################
@@%%%%%@@%%%%%@@@##**########*%@@@@@#+%@@@@@%+%@@@@@%#############%@%#####@@#####@@
@@%%%%%@@%%%%%@@@###%########++++++++++++++++*++++++++###@########%@%#####@@#####@@
@@%%%%%@@%%%%%@@%####*#######+++++++*+++++++#+++++++*+####%###%%##%@%#####@@#####@@
%@%%@@@@@@%%%%@%@############++%@@%#*++#%%%#*++#%@@%*+############%#%#####%%%%%##%#
++++#*+**+*%%%%%%############+%%@@@@#+#@@@@@#+%@@@@@%+############*++***+*+++**++*+
+**+#*+**+*%%%%%%############+%@#####+%%###%#+#####@%*############+*+*++**+*+**+*#+
+%@%@%%@##@@@@%@%####%%@@####+%%%%%%#+%%%%%%#+#%%%%@%+####@%%%####%@#@%@@#*@%@@%@%+
+@@%@@%@*#@@@@%@@###%@%@@####+%%%@@%#+%%@@@%#+#@@@%@%+####@@@@%#%#@@#@%@@#*@%@@%@@+
                    @@@@@@@##*%%%%%%#*%%%@%%#*#%@%%%%+##@                                                                                                                           
"""

###################################################################################

ca_state_wb = """                                       
     ..                           ...                                              
   ..@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
   .:@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
     -@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
     :@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
    .#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
     #@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
  ..:%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
  ..@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
  .*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
  ..@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
  ...:@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
    ...%@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
       :@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
       -@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
      .:@@@@@@@@@@@@@@@@@@@@@@@@@@@@.                                              
      ..+@@@@@@@@@@@@@@@@@@@@@@@@@@@...                                            
      . =@@@@@@@@@@@@@@@@@@@@@@@@@@@@-.                                            
         .+@@@@@@@@@@@@@@@@@@@@@@@@@@@@-.                                          
          ..#@@@@@@@@@@@@@@@@@@@@@@@@@@@@=.                                        
            .=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+.                                      
             .%@@#-@##%%@@@@@@@@@@@@@@@@@@@@@+..                                   
             ..-%#+@@@@@@@@@@@@@@@@@@@@@@@@@@@@*...                                
                .*+*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*..                               
                .+@%+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#. .                            
                 .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*..                           
                 .-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*..                         
                   ...%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+..                       
                     .=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+..                     
                     =@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+..                   
                     .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=..                 
                      .:@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-.                
                       ..%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-.              
                       ...#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@.             
                         ...%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:.          
                           ..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%:         
                           ....#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..      
                              .%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@...    
                              .*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:     
                              ..#%#%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@..   
                                ........:@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#.  
                                .:...-....-#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#...  
                                .... ...   . ..:@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.     
                                               .:.-@@@@@@@@@@@@@@@@@@@@@@@@@%.     
                                            . =:.  ..%@@@@@@@@@@@@@@@@@@@@@@.      
                                      .=.      ..    ..@@@@@@@@@@@@@@@@@@@@*.      
                                        .   . :.      ..%@@@@@@@@@@@@@@@@@@%=.     
                                              .+.      .#@@@@@@@@@@@@@@@@@@@@.     
                                               .        .*@@@@@@%*+=-:::.......    
                                                        .. .  ..                   
                                                                                   
"""

###################################################################################

ca_state_bb = """
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@...............................@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@%.                             .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@#                             .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@%                             .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@-                             .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@-                             .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@%:                             .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@.                              .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@-                               .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@.                              .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@%.                            .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@:                           .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@%                           .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@#                           .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@%                           .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@+ .                        .@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@*                           .#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@+                          ..#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@-                           .*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@*.                          ..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@:. -#.--::.                  ..+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@#:-+.  .                        =@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@=+=                             -@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@+.:+                              -@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@.                                 .-@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@%.                                  .=@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@:                                 .+@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@*                                   .+@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@*                                      .+@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@.                                        *@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@%.                                       .#@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@:                                        .#@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@-.                                        .@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@:.                                       ..%@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+                                         .:%@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-                                          :@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@:                                           .@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=                                            .%@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-:-:                                         .@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%..                                   .-@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%@@@#@@@@#-....                             -@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%.                           :@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%@#.                        :@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*%@@@@@:                     .@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*@@@@@@@@@@@@@@@.                   =@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%@@@@@@@@@:                  :*@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+@@@@@@@@-                   .@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-.   ..:-+*#%%%@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
"""


###################################################################################
# Dictionary of ASCII art
ascii_art = {
    "eda_toolkit_logo": eda_toolkit_logo,
    "leon_shpaner_bb": leon_shpaner_bb,
    "leon_shpaner_wb": leon_shpaner_wb,
    "grey_alien_wb": grey_alien_wb,
    "grey_alien_bb": grey_alien_bb,
    "oscar_gil_bb": oscar_gil_bb,
    "oscar_gil_wb": oscar_gil_wb,
    "royce_hall_bb": royce_hall_bb,
    "royce_hall_wb": royce_hall_wb,
    "ca_state_bb": ca_state_bb,
    "ca_state_wb": ca_state_wb,
}

###################################################################################
###################################################################################
###################################################################################


def print_art(
    *art_names,
    all=False,
    suffix=None,
    output_file=None,
    output_path=None,
):
    """
    Print ASCII art based on user input and optionally save output to a
    specified path.

    This function retrieves and displays ASCII art from a predefined dictionary.
    Users can specify individual artwork names, request all artwork to be
    displayed, filter by suffix, or view available options if no valid input is
    provided. Optionally, the output can be saved to a file at a user-specified path.

    Parameters:
    -----------
    *art_names : str
        Names of the ASCII art to print. Each name should match a key in the
        `ascii_art` dictionary. If no names are provided, and `all` is `False`,
        a list of available options will be displayed.

    all : bool, optional
        If `True`, all available ASCII art will be printed. Defaults to `False`.

    suffix : str, optional
        If provided, filters ASCII art keys that end with the given suffix.

    output_file : str, optional
        If provided, the ASCII art will be saved to the specified file. If no
        file extension is specified, `.txt` will be used by default.

    output_path : str, optional
        Directory where the output file should be saved. If not specified,
        the current working directory will be used. If the directory does not
        exist, it will be created. Defaults to `None`.

    Raises:
    -------
    ValueError
        If both `all=True` and specific `art_names` are specified simultaneously.
    """

    # Raise an exception if both arguments are entered
    if all and art_names:
        raise ValueError(
            "You cannot specify both `all=True` and specific `art_names` "
            "simultaneously."
        )

    # Handle the output file and extension
    if output_file:
        if "." not in output_file:
            output_file += ".txt"  # Default to .txt if no extension is provided

    # Handle the output directory
    if output_file and output_path:
        output_path = os.path.abspath(output_path)
        os.makedirs(output_path, exist_ok=True)
        output_file = os.path.join(output_path, output_file)

    # Collect output to a list if saving to a file
    output = []

    # Check for suffix filtering
    if suffix:
        filtered_keys = [key for key in ascii_art.keys() if key.endswith(suffix)]
        if not filtered_keys:
            print(f"No keys found with suffix '{suffix}'.")
            return
        art_names = filtered_keys

    if all:
        # Print all ASCII art, ignoring art_names
        for name, art in ascii_art.items():
            section = f"--- {name} ---\n{art}\n\n"
            print(section)
            if output_file:
                output.append(section)
    elif art_names:
        # Print specified ASCII art
        for art_name in art_names:
            art = ascii_art.get(art_name)
            if art:
                section = f"--- {art_name} ---\n{art}\n\n"
                print(section)
                if output_file:
                    output.append(section)
            else:
                error_msg = (
                    f"'{art_name}' not found. Available options are: "
                    f"{', '.join(ascii_art.keys())}\n"
                )
                print(error_msg)
                if output_file:
                    output.append(error_msg)
    else:
        # No input provided and all=False
        options_msg = "No input provided. Available options are:\n" + ", ".join(
            ascii_art.keys()
        )
        print(options_msg)
        if output_file:
            output.append(options_msg)

    # Save to output file if specified
    if output_file and output:
        with open(output_file, "w") as file:
            file.writelines(output)
