# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, you can obtain one at http://mozilla.org/MPL/2.0/.
import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

ROOT_URLCONF = "tests.urls"

SECRET_KEY = (
    "e4ac21f475d9d1c4b426f82640e7772d7f09fd8caa78919abbfcc4949bd74aa1b48302a3d2162cdd"
)

CACHES = {
    "default": {
        "BACKEND": "django_redis.cache.RedisCache",
        "LOCATION": "redis://127.0.0.1:6379/0",
        "OPTIONS": {"REDIS_CLIENT_CLASS": "fakeredis.FakeStrictRedis"},
    }
}

MIDDLEWARE = ["dockerflow.django.middleware.DockerflowMiddleware"]

INSTALLED_APPS = [
    "django.contrib.contenttypes",
    "django.contrib.auth",
    "dockerflow.django",
]

DATABASES = {"default": {"ENGINE": "django.db.backends.sqlite3", "NAME": ":memory:"}}

SILENCED_SYSTEM_CHECKS = [
    "security.W001",
    "security.W002",
    "security.W003",
    "security.W009",
    "security.W016",
    "security.W017",
]

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "OPTIONS": {
            "loaders": [
                "django.template.loaders.filesystem.Loader",
                "django.template.loaders.app_directories.Loader",
            ]
        },
    }
]


LOGGING = {
    "version": 1,
    "formatters": {
        "json": {"()": "dockerflow.logging.JsonLogFormatter", "logger_name": "tests"}
    },
    "handlers": {
        "console": {
            "level": "DEBUG",
            "class": "logging.StreamHandler",
            "formatter": "json",
        }
    },
    "loggers": {"request.summary": {"handlers": ["console"], "level": "DEBUG"}},
}
