# foxclient

Warning: Please add a custom user agent header to your requests.
This would help us fighting against DDoS attacks in future, while keeping your application's access to the API.
In future, this may be a mandatory requirement.

To reduce the system load, the API endpoints are rate limited.
The default limit is 30 requests per minute. Contact admin@orangefox.tech if you need a higher limit.

The requests may be logged for analytics and development purposes.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 5.2.3
- Package version: 5.2.3
- Generator version: 7.13.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import foxclient
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import foxclient
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import foxclient
from foxclient.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.orangefox.download
# See configuration.py for a list of all supported configuration parameters.
configuration = foxclient.Configuration(
    host = "https://api.orangefox.download"
)



# Enter a context with an instance of the API client
async with foxclient.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = foxclient.DeviceApi(api_client)
    device_id = 'device_id_example' # str |  (optional)
    id = 'id_example' # str | Filter by Device ID (deprecated) (optional)
    codename = 'codename_example' # str | Not recommended to use when you can (optional)

    try:
        # Get Device
        api_response = await api_instance.get_device(device_id=device_id, id=id, codename=codename)
        print("The response of DeviceApi->get_device:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DeviceApi->get_device: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.orangefox.download*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DeviceApi* | [**get_device**](docs/DeviceApi.md#get_device) | **GET** /devices/get | Get Device
*DeviceApi* | [**get_device_deprecated**](docs/DeviceApi.md#get_device_deprecated) | **GET** /devices/{device_id} | Get Device Short
*DeviceApi* | [**get_devices**](docs/DeviceApi.md#get_devices) | **GET** /devices/ | Get Devices
*DeviceApi* | [**get_oems**](docs/DeviceApi.md#get_oems) | **GET** /oems/ | Get Oems
*ReleaseApi* | [**get_release**](docs/ReleaseApi.md#get_release) | **GET** /releases/get | Get Release
*ReleaseApi* | [**get_release_deprecated**](docs/ReleaseApi.md#get_release_deprecated) | **GET** /releases/{release_id} | Get Release Short
*ReleaseApi* | [**get_releases**](docs/ReleaseApi.md#get_releases) | **GET** /releases/ | Get Releases
*ReleaseApi* | [**get_updates_deprecated**](docs/ReleaseApi.md#get_updates_deprecated) | **GET** /updates/{last_known_id} | Get Updates
*StatsApi* | [**get_public_stats**](docs/StatsApi.md#get_public_stats) | **GET** /stats/ | Public Stats


## Documentation For Models

 - [DeviceResponse](docs/DeviceResponse.md)
 - [GlobalStatsAggregationModel](docs/GlobalStatsAggregationModel.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [ListResponseReleaseResponse](docs/ListResponseReleaseResponse.md)
 - [ListResponseShortDeviceResponse](docs/ListResponseShortDeviceResponse.md)
 - [ListResponseShortReleaseResponse](docs/ListResponseShortReleaseResponse.md)
 - [ListResponseStr](docs/ListResponseStr.md)
 - [MaintainerShortModel](docs/MaintainerShortModel.md)
 - [RecoveryImgResponse](docs/RecoveryImgResponse.md)
 - [ReleaseGroupsResponse](docs/ReleaseGroupsResponse.md)
 - [ReleaseResponse](docs/ReleaseResponse.md)
 - [ReleaseType](docs/ReleaseType.md)
 - [ReleasesSort](docs/ReleasesSort.md)
 - [ResponseGetReleases](docs/ResponseGetReleases.md)
 - [ShortDeviceResponse](docs/ShortDeviceResponse.md)
 - [ShortReleaseResponse](docs/ShortReleaseResponse.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearer_auth"></a>
### bearer_auth

- **Type**: Bearer authentication (JWT)

<a id="oauth2_password"></a>
### oauth2_password

- **Type**: OAuth
- **Flow**: password
- **Authorization URL**: 
- **Scopes**: N/A


## Author

admin@orangefox.tech


