module.exports =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = __webpack_require__(1);
// default session
const codePipeline = new aws_sdk_1.CodePipeline();
const sts = new aws_sdk_1.STS();
const handler = async (event) => {
    const { id: jobId, data: jobData } = event['CodePipeline.job'];
    try {
        const { repositoryName, sourceCommitSpecifier, destinationCommitSpecifier } = getUserParams(jobData);
        const codeCommitRoleArn = process.env.CODE_COMMIT_ROLE_ARN;
        const codeCommit = await (async () => {
            if (!codeCommitRoleArn) {
                return new aws_sdk_1.CodeCommit();
            }
            const { Credentials: credentials } = await sts
                .assumeRole({
                RoleArn: codeCommitRoleArn,
                RoleSessionName: `Merge-${repositoryName}-${sourceCommitSpecifier}-${destinationCommitSpecifier}`,
            })
                .promise();
            if (!credentials) {
                throw new Error('Crossaccount role could not be assumed');
            }
            return new aws_sdk_1.CodeCommit({
                accessKeyId: credentials.AccessKeyId,
                secretAccessKey: credentials.SecretAccessKey,
                sessionToken: credentials.SessionToken,
            });
        })();
        const { commitId } = await codeCommit
            .mergeBranchesByFastForward({
            repositoryName,
            sourceCommitSpecifier,
            destinationCommitSpecifier,
        })
            .promise();
        await putJobSuccess(jobId, commitId);
    }
    catch (error) {
        console.log(error);
        await putJobFailure(jobId, `Function exception: ${error.message}`);
    }
    console.log('Function complete.');
    return 'Complete.';
};
exports.handler = handler;
/**
 * Decodes the JSON user parameters and validates the required properties
 *
 * @param jobData The job data structure containing the UserParameters string which should be a valid JSON structure
 */
const getUserParams = (jobData) => {
    const { UserParameters: userParameters } = jobData.actionConfiguration.configuration;
    const { repositoryName, sourceCommitSpecifier, destinationCommitSpecifier } = JSON.parse(userParameters);
    if (!repositoryName) {
        throw new Error('Your UserParameters JSON must include the repository name');
    }
    if (!sourceCommitSpecifier) {
        throw new Error('Your UserParameters JSON must include the sourceCommitSpecifier');
    }
    if (!destinationCommitSpecifier) {
        throw new Error('Your UserParameters JSON must include the destinationCommitSpecifier');
    }
    return {
        repositoryName,
        sourceCommitSpecifier,
        destinationCommitSpecifier,
    };
};
/**
 * Notify CodePipeline of a successful job
 *
 * @param jobId The CodePipeline job ID
 * @param message A message to be logged relating to the job status
 */
const putJobSuccess = async (jobId, message) => {
    console.log('Putting job success');
    if (message) {
        console.log(message);
    }
    await codePipeline
        .putJobSuccessResult({
        jobId,
    })
        .promise();
};
/**
 * Notify CodePipeline of a failed job
 *
 * @param jobId The CodePipeline job ID
 * @param message A message to be logged relating to the job status
 */
const putJobFailure = async (jobId, message) => {
    console.log('Putting job failure');
    console.log(message);
    await codePipeline
        .putJobFailureResult({
        jobId,
        failureDetails: {
            message,
            type: 'JobFailed',
        },
    })
        .promise();
};


/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = require("aws-sdk");

/***/ })
/******/ ]);
//# sourceMappingURL=index.js.map