"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudfrontWebAcl = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * This construct creates a WAFv2 Web ACL for cloudfront in the us-east-1 region (required for cloudfront) no matter the
 * region of the parent cdk stack.
 */
class CloudfrontWebAcl extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const onEventHandler = new aws_lambda_nodejs_1.NodejsFunction(this, "CloudfrontWebAclOnEventHandler", {
            entry: path.join(__dirname, "../custom_resources/webacl_event_handler/index.ts"),
            functionName: "CloudfrontWebAclCustomResource",
            handler: "onEvent",
            runtime: aws_lambda_1.Runtime.NODEJS_16_X,
            timeout: aws_cdk_lib_1.Duration.seconds(300),
            bundling: {
                externalModules: ["aws-sdk"],
            },
        });
        onEventHandler.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: [
                "wafv2:CreateWebACL",
                "wafv2:DeleteWebACL",
                "wafv2:UpdateWebACL",
                "wafv2:GetWebACL",
                "wafv2:CreateIPSet",
                "wafv2:DeleteIPSet",
                "wafv2:UpdateIPSet",
                "wafv2:GetIPSet",
            ],
            resources: ["*"],
        }));
        const provider = new custom_resources_1.Provider(this, "CloudfrontWebAclProvider", {
            onEventHandler,
        });
        const customResource = new aws_cdk_lib_1.CustomResource(this, "CFWebAclCustomResource", {
            serviceToken: provider.serviceToken,
            properties: {
                ID: id,
                MANAGED_RULES: (_b = props === null || props === void 0 ? void 0 : props.managedRules) !== null && _b !== void 0 ? _b : [
                    { vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" },
                ],
                CIDR_ALLOW_LIST: props === null || props === void 0 ? void 0 : props.cidrAllowList,
            },
        });
        this.webAclId = customResource.getAttString("WebAclId");
        this.webAclArn = customResource.getAttString("WebAclArn");
    }
}
exports.CloudfrontWebAcl = CloudfrontWebAcl;
_a = JSII_RTTI_SYMBOL_1;
CloudfrontWebAcl[_a] = { fqn: "@aws-prototyping-sdk/static-website.CloudfrontWebAcl", version: "0.0.84" };
//# sourceMappingURL=data:application/json;base64,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