# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs-dev/0_00_core.ipynb.

# %% ../nbs-dev/0_00_core.ipynb 2
from __future__ import annotations
from pathlib import Path
from typing import Any, List, Optional

import configparser
import numpy as np

# %% auto 0
__all__ = ['validate_type', 'validate_path', 'get_config_value', 'files_in_tree']

# %% ../nbs-dev/0_00_core.ipynb 6
def validate_type(
    obj:Any,                 # object whose type to validate
    obj_type:type,                # expected type for `obj`
    raise_error:bool=False,  # when True, raise a ValueError is `obj` is not of the right type
)-> bool:                    # True when `obj` is of the right type, False otherwise 
    """Validate that `obj` is of type `obj_type`. Raise error in the negative when `raise_error` is `True`"""
    if not isinstance(obj_type, type): raise ValueError(f"{obj_type} is not a type")
    if isinstance(obj, obj_type): return True
    else:
        if raise_error: raise ValueError(f"passed object is not of type {obj_type}")
        else: return False

# %% ../nbs-dev/0_00_core.ipynb 10
def validate_path(
    path:str|Path,           # path to validate
    path_type:str='file',    # type of the target path: `'file'` or `'dir'`
    raise_error:bool=False,  # when True, raise a ValueError is path does not a file
)-> bool:                    # True when path is a valid path, False otherwise 
    """Validate that path is a Path or str and points to a real file"""
    if isinstance(path, str): 
        path = Path(path)
    if (path_type=='file' and path.is_file()) or (path_type=='dir' and path.is_dir()) :
        return True
    else:
        if raise_error: raise ValueError(f"No file at {path.absolute()}. Check the path")
        else: return False

# %% ../nbs-dev/0_00_core.ipynb 17
def get_config_value(section:str,                        # section in the configparser cfg file
                     key:str,                            # key in the selected section
                     path_to_config_file:Path|str=None   # path to the cfg file
                    )-> Any :                            # the value corresponding to section>key>value 
    """Returns the value corresponding to the key-value pair in the configuration file (configparser format)"""
    # validate path_to_config_file
    if path_to_config_file is None:
        path_to_config_file = Path('/content/gdrive/MyDrive/private-across-accounts/config-api-keys.cfg')
    validate_path(path_to_config_file)

    configuration = configparser.ConfigParser()
    configuration.read(path_to_config_file)
    return configuration[section][key]

# %% ../nbs-dev/0_00_core.ipynb 27
def files_in_tree(
    path: str|Path,               # path to the directory to scan  
    pattern: str|None = None      # pattern (glob style) to match in file name to filter the content
):
    """List files in directory and its subdiretories, print tree starting from parent directory"""
    validate_path(path, path_type='dir', raise_error=True)

    pattern = '*' if pattern is None else f"*{pattern}*"
    parents = [p.name for p in path.parents]
    paths = []
    pad = ' ' * 2
    idx = 0
    print(f"{parents[0]}")
    print(f"{pad}|--{path.name}")
    for f in [p for p in path.glob(pattern) if p.is_file()]:
        paths.append(f)
        print(f"{pad}|{pad*2}|--{f.name} ({idx})")
        idx += 1
    for d in [p for p in path.iterdir() if p.is_dir()]:
        print(f"{pad}|{pad*2}|--{d.name}")
        for f in [p for p in d.glob(pattern) if p.is_file()]:
            paths.append(f)
            print(f"{pad}|{pad*2}|{pad*2}|--{f.name} ({idx})")
            idx += 1
    return paths
