# Generated by Django 4.2.10 on 2024-05-13 04:25

from django.db import migrations, models
import django.db.models.deletion
import ipam.fields
import slurpit_netbox.models.prefix
import taggit.managers
import utilities.json


class Migration(migrations.Migration):

    dependencies = [
        ('slurpit_netbox', '0011_alter_slurpitinterface_device'),
    ]

    operations = [
        migrations.CreateModel(
            name='SlurpitPrefix',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('comments', models.TextField(blank=True)),
                ('prefix', ipam.fields.IPNetworkField(blank=True, null=True)),
                ('enable_reconcile', models.BooleanField(default=False)),
                ('status', models.CharField(default='active', max_length=50)),
                ('is_pool', models.BooleanField(default=False)),
                ('mark_utilized', models.BooleanField(default=False)),
                ('_depth', models.PositiveSmallIntegerField(default=0, editable=False)),
                ('_children', models.PositiveBigIntegerField(default=0, editable=False)),
                ('role', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='slurpit_prefixes', to='ipam.role')),
                ('site', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_prefixes', to='dcim.site')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('tenant', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_prefixes', to='tenancy.tenant')),
                ('vlan', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_prefixes', to='ipam.vlan')),
                ('vrf', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='slurpit_prefixes', to='ipam.vrf')),
            ],
            options={
                'verbose_name': 'Slurpit Prefix',
                'verbose_name_plural': 'Prefixes',
                'ordering': (models.OrderBy(models.F('vrf'), nulls_first=True), 'prefix', 'pk'),
            },
            bases=(slurpit_netbox.models.prefix.GetAvailablePrefixesMixin, models.Model),
        ),
    ]
