# Generated by Django 4.2.8 on 2024-01-25 15:51

from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import utilities.json


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('extras', '0105_customfield_min_max_values'),
        ('dcim', '0185_gfk_indexes'),
    ]

    operations = [
        migrations.CreateModel(
            name='SlurpitLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('log_time', models.DateTimeField(auto_now=True)),
                ('level', models.CharField(default='default', editable=False, max_length=100)),
                ('category', models.CharField(default='init', editable=False, max_length=50)),
                ('message', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='SlurpitStagedDevice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('slurpit_id', models.BigIntegerField(unique=True)),
                ('disabled', models.BooleanField(default=False)),
                ('hostname', models.CharField(max_length=255, unique=True)),
                ('fqdn', models.CharField(max_length=128)),
                ('ipv4', models.CharField(max_length=23)),
                ('device_os', models.CharField(max_length=128)),
                ('device_type', models.CharField(max_length=255)),
                ('brand', models.CharField(max_length=255)),
                ('createddate', models.DateTimeField()),
                ('changeddate', models.DateTimeField()),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SlurpitSnapshot',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('comments', models.TextField(blank=True)),
                ('hostname', models.CharField(max_length=255)),
                ('planning_id', models.BigIntegerField()),
                ('content', models.JSONField()),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SlurpitSetting',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('comments', models.TextField(blank=True)),
                ('server_url', models.CharField(max_length=200)),
                ('api_key', models.CharField(editable=False, max_length=50)),
                ('last_synced', models.DateTimeField(auto_now=True, null=True)),
                ('connection_status', models.CharField(default='', editable=False, max_length=50, null=True)),
                ('push_api_key', models.CharField(editable=False, max_length=200, null=True)),
                ('appliance_type', models.CharField(blank=True, max_length=50)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'verbose_name': 'setting',
                'verbose_name_plural': 'setting',
            },
        ),
        migrations.CreateModel(
            name='SlurpitPlanning',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('comments', models.TextField(blank=True)),
                ('name', models.CharField(max_length=255)),
                ('planning_id', models.BigIntegerField()),
                ('selected', models.BooleanField(default=False)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SlurpitImportedDevice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('slurpit_id', models.BigIntegerField(unique=True)),
                ('disabled', models.BooleanField(default=False)),
                ('hostname', models.CharField(max_length=255, unique=True)),
                ('fqdn', models.CharField(max_length=128)),
                ('ipv4', models.CharField(max_length=23)),
                ('device_os', models.CharField(max_length=128)),
                ('device_type', models.CharField(max_length=255)),
                ('brand', models.CharField(max_length=255)),
                ('createddate', models.DateTimeField()),
                ('changeddate', models.DateTimeField()),
                ('mapped_device', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to='dcim.device')),
                ('mapped_devicetype', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='dcim.devicetype')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
