#
# SPDX-FileCopyrightText: 2024 Alex Turbov <i.zaufi@gmail.com>
# SPDX-License-Identifier: GPL-3.0-or-later
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/stable/config

# Standard imports
import pathlib
from importlib.metadata import metadata as _get_metadata

# Third party packages
import packaging.version

# -- Path setup --------------------------------------------------------------

_this_dir = pathlib.Path(__file__).parent

# -- Project information -----------------------------------------------------
_this_package = _get_metadata('pytest-matcher')
project = 'Pytest Matcher Plugin'
copyright = '2017-now by Alex Turbov & contributors'
author = _this_package['Author-email']

# The full version, including alpha/beta/rc tags
release = _this_package['Version']
# The short X.Y version
version = packaging.version.parse(release).public

# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
needs_sphinx = '7.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.extlinks'
  , 'sphinx.ext.todo'
]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = ['.rst']

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path .
exclude_patterns = ['include_*.rst']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# The default language to highlight source code in.
highlight_language = 'none'

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'sphinx_rtd_theme'

html_show_sourcelink = True
html_short_title = f'{project} {version} documentation'

# -- Extension configuration -------------------------------------------------

# -- Options for extlinks extension ------------------------------------------
# TODO Any way to get and use project's metadata URL?
extlinks = {
    'issue': ('https://github.com/zaufi/pytest-matcher/issues/%s', 'issue #%s')
  , 'pr': ('https://github.com/zaufi/pytest-matcher/pull/%s', 'PR #%s')
  }
extlinks_detect_hardcoded_links = True

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True
