# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['QosPolicy']


class QosPolicy(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 shared: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V2 Neutron QoS policy resource within OpenStack.

        ## Example Usage
        ### Create a QoS Policy

        ```python
        import pulumi
        import pulumi_openstack as openstack

        qos_policy1 = openstack.networking.QosPolicy("qosPolicy1", description="bw_limit")
        ```

        ## Import

        QoS Policies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import openstack:networking/qosPolicy:QosPolicy qos_policy_1 d6ae28ce-fcb5-4180-aa62-d260a27e09ae
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The human-readable description for the QoS policy.
               Changing this updates the description of the existing QoS policy.
        :param pulumi.Input[bool] is_default: Indicates whether the QoS policy is default
               QoS policy or not. Changing this updates the default status of the existing
               QoS policy.
        :param pulumi.Input[str] name: The name of the QoS policy. Changing this updates the name of
               the existing QoS policy.
        :param pulumi.Input[str] project_id: The owner of the QoS policy. Required if admin wants to
               create a QoS policy for another project. Changing this creates a new QoS policy.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron Qos policy. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               QoS policy.
        :param pulumi.Input[bool] shared: Indicates whether this QoS policy is shared across
               all projects. Changing this updates the shared status of the existing
               QoS policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the QoS policy.
        :param pulumi.Input[Mapping[str, Any]] value_specs: Map of additional options.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['is_default'] = is_default
            __props__['name'] = name
            __props__['project_id'] = project_id
            __props__['region'] = region
            __props__['shared'] = shared
            __props__['tags'] = tags
            __props__['value_specs'] = value_specs
            __props__['all_tags'] = None
            __props__['created_at'] = None
            __props__['revision_number'] = None
            __props__['updated_at'] = None
        super(QosPolicy, __self__).__init__(
            'openstack:networking/qosPolicy:QosPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            is_default: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            revision_number: Optional[pulumi.Input[int]] = None,
            shared: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            value_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None) -> 'QosPolicy':
        """
        Get an existing QosPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_tags: The collection of tags assigned on the QoS policy, which have been
               explicitly and implicitly added.
        :param pulumi.Input[str] created_at: The time at which QoS policy was created.
        :param pulumi.Input[str] description: The human-readable description for the QoS policy.
               Changing this updates the description of the existing QoS policy.
        :param pulumi.Input[bool] is_default: Indicates whether the QoS policy is default
               QoS policy or not. Changing this updates the default status of the existing
               QoS policy.
        :param pulumi.Input[str] name: The name of the QoS policy. Changing this updates the name of
               the existing QoS policy.
        :param pulumi.Input[str] project_id: The owner of the QoS policy. Required if admin wants to
               create a QoS policy for another project. Changing this creates a new QoS policy.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron Qos policy. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               QoS policy.
        :param pulumi.Input[int] revision_number: The revision number of the QoS policy.
        :param pulumi.Input[bool] shared: Indicates whether this QoS policy is shared across
               all projects. Changing this updates the shared status of the existing
               QoS policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the QoS policy.
        :param pulumi.Input[str] updated_at: The time at which QoS policy was created.
        :param pulumi.Input[Mapping[str, Any]] value_specs: Map of additional options.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["all_tags"] = all_tags
        __props__["created_at"] = created_at
        __props__["description"] = description
        __props__["is_default"] = is_default
        __props__["name"] = name
        __props__["project_id"] = project_id
        __props__["region"] = region
        __props__["revision_number"] = revision_number
        __props__["shared"] = shared
        __props__["tags"] = tags
        __props__["updated_at"] = updated_at
        __props__["value_specs"] = value_specs
        return QosPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        The collection of tags assigned on the QoS policy, which have been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_tags")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The time at which QoS policy was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The human-readable description for the QoS policy.
        Changing this updates the description of the existing QoS policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the QoS policy is default
        QoS policy or not. Changing this updates the default status of the existing
        QoS policy.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the QoS policy. Changing this updates the name of
        the existing QoS policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The owner of the QoS policy. Required if admin wants to
        create a QoS policy for another project. Changing this creates a new QoS policy.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron Qos policy. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        QoS policy.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="revisionNumber")
    def revision_number(self) -> pulumi.Output[int]:
        """
        The revision number of the QoS policy.
        """
        return pulumi.get(self, "revision_number")

    @property
    @pulumi.getter
    def shared(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether this QoS policy is shared across
        all projects. Changing this updates the shared status of the existing
        QoS policy.
        """
        return pulumi.get(self, "shared")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of string tags for the QoS policy.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The time at which QoS policy was created.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Map of additional options.
        """
        return pulumi.get(self, "value_specs")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

