# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['Quota']


class Quota(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 health_monitor: Optional[pulumi.Input[int]] = None,
                 l7_policy: Optional[pulumi.Input[int]] = None,
                 l7_rule: Optional[pulumi.Input[int]] = None,
                 listener: Optional[pulumi.Input[int]] = None,
                 loadbalancer: Optional[pulumi.Input[int]] = None,
                 member: Optional[pulumi.Input[int]] = None,
                 pool: Optional[pulumi.Input[int]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V2 load balancer quota resource within OpenStack.

        > **Note:** This usually requires admin privileges.

        > **Note:** This resource is only available for Octavia.

        > **Note:** This resource has a no-op deletion so no actual actions will be done against the OpenStack
           API in case of delete call.

        > **Note:** This resource has all-in creation so all optional quota arguments that were not specified are
           created with zero value.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        project1 = openstack.identity.Project("project1")
        quota1 = openstack.loadbalancer.Quota("quota1",
            health_monitor=10,
            l7_policy=11,
            l7_rule=12,
            listener=7,
            loadbalancer=6,
            member=8,
            pool=9,
            project_id=project1.id)
        ```

        ## Import

        Quotas can be imported using the `project_id/region_name`, where region_name is the one defined is the Openstack credentials that are in use. E.g.

        ```sh
         $ pulumi import openstack:loadbalancer/quota:Quota quota_1 2a0f2240-c5e6-41de-896d-e80d97428d6b/region_1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] health_monitor: Quota value for health_monitors. Changing
               this updates the existing quota. Omitting it sets it to 0.
        :param pulumi.Input[int] l7_policy: Quota value for l7_policies. Changing this
               updates the existing quota. Omitting it sets it to 0. Available in
               Octavia 2.19.
        :param pulumi.Input[int] l7_rule: Quota value for l7_rules. Changing this
               updates the existing quota. Omitting it sets it to 0. Available in
               Octavia 2.19.
        :param pulumi.Input[int] listener: Quota value for listeners. Changing this updates
               the existing quota. Omitting it sets it to 0.
        :param pulumi.Input[int] loadbalancer: Quota value for loadbalancers. Changing this
               updates the existing quota. Omitting it sets it to 0.
        :param pulumi.Input[int] member: Quota value for members. Changing this updates
               the existing quota. Omitting it sets it to 0.
        :param pulumi.Input[int] pool: Quota value for pools. Changing this updates the
               the existing quota. Omitting it sets it to 0.
        :param pulumi.Input[str] project_id: ID of the project to manage quotas. Changing this
               creates a new quota.
        :param pulumi.Input[str] region: Region in which to manage quotas. Changing this
               creates a new quota. If ommited, the region of the credentials is used.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['health_monitor'] = health_monitor
            __props__['l7_policy'] = l7_policy
            __props__['l7_rule'] = l7_rule
            __props__['listener'] = listener
            __props__['loadbalancer'] = loadbalancer
            __props__['member'] = member
            __props__['pool'] = pool
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            __props__['region'] = region
        super(Quota, __self__).__init__(
            'openstack:loadbalancer/quota:Quota',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            health_monitor: Optional[pulumi.Input[int]] = None,
            l7_policy: Optional[pulumi.Input[int]] = None,
            l7_rule: Optional[pulumi.Input[int]] = None,
            listener: Optional[pulumi.Input[int]] = None,
            loadbalancer: Optional[pulumi.Input[int]] = None,
            member: Optional[pulumi.Input[int]] = None,
            pool: Optional[pulumi.Input[int]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'Quota':
        """
        Get an existing Quota resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] health_monitor: Quota value for health_monitors. Changing
               this updates the existing quota. Omitting it sets it to 0.
        :param pulumi.Input[int] l7_policy: Quota value for l7_policies. Changing this
               updates the existing quota. Omitting it sets it to 0. Available in
               Octavia 2.19.
        :param pulumi.Input[int] l7_rule: Quota value for l7_rules. Changing this
               updates the existing quota. Omitting it sets it to 0. Available in
               Octavia 2.19.
        :param pulumi.Input[int] listener: Quota value for listeners. Changing this updates
               the existing quota. Omitting it sets it to 0.
        :param pulumi.Input[int] loadbalancer: Quota value for loadbalancers. Changing this
               updates the existing quota. Omitting it sets it to 0.
        :param pulumi.Input[int] member: Quota value for members. Changing this updates
               the existing quota. Omitting it sets it to 0.
        :param pulumi.Input[int] pool: Quota value for pools. Changing this updates the
               the existing quota. Omitting it sets it to 0.
        :param pulumi.Input[str] project_id: ID of the project to manage quotas. Changing this
               creates a new quota.
        :param pulumi.Input[str] region: Region in which to manage quotas. Changing this
               creates a new quota. If ommited, the region of the credentials is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["health_monitor"] = health_monitor
        __props__["l7_policy"] = l7_policy
        __props__["l7_rule"] = l7_rule
        __props__["listener"] = listener
        __props__["loadbalancer"] = loadbalancer
        __props__["member"] = member
        __props__["pool"] = pool
        __props__["project_id"] = project_id
        __props__["region"] = region
        return Quota(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="healthMonitor")
    def health_monitor(self) -> pulumi.Output[int]:
        """
        Quota value for health_monitors. Changing
        this updates the existing quota. Omitting it sets it to 0.
        """
        return pulumi.get(self, "health_monitor")

    @property
    @pulumi.getter(name="l7Policy")
    def l7_policy(self) -> pulumi.Output[int]:
        """
        Quota value for l7_policies. Changing this
        updates the existing quota. Omitting it sets it to 0. Available in
        Octavia 2.19.
        """
        return pulumi.get(self, "l7_policy")

    @property
    @pulumi.getter(name="l7Rule")
    def l7_rule(self) -> pulumi.Output[int]:
        """
        Quota value for l7_rules. Changing this
        updates the existing quota. Omitting it sets it to 0. Available in
        Octavia 2.19.
        """
        return pulumi.get(self, "l7_rule")

    @property
    @pulumi.getter
    def listener(self) -> pulumi.Output[int]:
        """
        Quota value for listeners. Changing this updates
        the existing quota. Omitting it sets it to 0.
        """
        return pulumi.get(self, "listener")

    @property
    @pulumi.getter
    def loadbalancer(self) -> pulumi.Output[int]:
        """
        Quota value for loadbalancers. Changing this
        updates the existing quota. Omitting it sets it to 0.
        """
        return pulumi.get(self, "loadbalancer")

    @property
    @pulumi.getter
    def member(self) -> pulumi.Output[int]:
        """
        Quota value for members. Changing this updates
        the existing quota. Omitting it sets it to 0.
        """
        return pulumi.get(self, "member")

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Output[int]:
        """
        Quota value for pools. Changing this updates the
        the existing quota. Omitting it sets it to 0.
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        ID of the project to manage quotas. Changing this
        creates a new quota.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region in which to manage quotas. Changing this
        creates a new quota. If ommited, the region of the credentials is used.
        """
        return pulumi.get(self, "region")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

