# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['AggregateV2']


class AggregateV2(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a Host Aggregate within Openstack Nova.

        ## Example Usage
        ### Full example

        ```python
        import pulumi
        import pulumi_openstack as openstack

        dell_servers = openstack.compute.AggregateV2("dellServers",
            hosts=[
                "myhost01.example.com",
                "myhost02.example.com",
            ],
            metadata={
                "cpus": "56",
            },
            zone="nova")
        ```
        ### Minimum required example

        ```python
        import pulumi
        import pulumi_openstack as openstack

        test = openstack.compute.AggregateV2("test")
        ```

        ## Import

        You can import an existing Host Aggregate by their ID.

        ```sh
         $ pulumi import openstack:compute/aggregateV2:AggregateV2 myaggregate 24
        ```

         The ID can be obtained with an openstack command$ openstack aggregate list +----+------+-------------------+ | ID | Name | Availability Zone | +----+------+-------------------+ | 59 | test | None

        | +----+------+-------------------+

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: The list of hosts contained in the Host Aggregate. The hosts must be added
               to Openstack and visible in the web interface, or the provider will fail to add them to the host
               aggregate.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: The metadata of the Host Aggregate. Can be useful to indicate scheduler hints.
        :param pulumi.Input[str] name: The name of the Host Aggregate
        :param pulumi.Input[str] zone: The name of the Availability Zone to use. If ommited, it will take the default
               availability zone.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['hosts'] = hosts
            __props__['metadata'] = metadata
            __props__['name'] = name
            __props__['zone'] = zone
        super(AggregateV2, __self__).__init__(
            'openstack:compute/aggregateV2:AggregateV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'AggregateV2':
        """
        Get an existing AggregateV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: The list of hosts contained in the Host Aggregate. The hosts must be added
               to Openstack and visible in the web interface, or the provider will fail to add them to the host
               aggregate.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: The metadata of the Host Aggregate. Can be useful to indicate scheduler hints.
        :param pulumi.Input[str] name: The name of the Host Aggregate
        :param pulumi.Input[str] zone: The name of the Availability Zone to use. If ommited, it will take the default
               availability zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["hosts"] = hosts
        __props__["metadata"] = metadata
        __props__["name"] = name
        __props__["zone"] = zone
        return AggregateV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of hosts contained in the Host Aggregate. The hosts must be added
        to Openstack and visible in the web interface, or the provider will fail to add them to the host
        aggregate.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The metadata of the Host Aggregate. Can be useful to indicate scheduler hints.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Host Aggregate
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Availability Zone to use. If ommited, it will take the default
        availability zone.
        """
        return pulumi.get(self, "zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

