/*
 * Define Global values in WMStats Application
 * TODO: This will contain configuration result for Tier0, Tier1, 
 * PromptScheme specific config
 */
WMStats.namespace("Globals");

WMStats.Globals = function($){
    var _dbVariants = {'wmstats': 'tier1', 'tier0_wmstats': 'tier0'};

	var reqPropertyMap = {
		   "_id": "_id",
		   "InputDataset": "inputdataset",
		   "PrepID": "prep_id",
		   "Group": "group",
		   "RequestDate": "request_date",
		   "Campaign": "campaign",
		   "RequestName": "workflow",
		   "RequestorDN": "user_dn",
		   "RequestPriority": "priority",
		   "Requestor": "requestor",
		   "RequestType": "request_type",
		   "DbsUrl": "dbs_url",
		   "CMSSWVersion": "cmssw",
		   "OutputDatasets": "outputdatasets",
		   "RequestTransition": "request_status", // Status: status,  UpdateTime: update_time
		   "SiteWhitelist": "site_white_list",
		   "Team": "team",
		   "TotalEstimatedJobs": "total_jobs",
		   "TotalInputEvents": "input_events",
		   "TotalInputLumis": "input_lumis",
		   "TotalInputFiles": "input_num_files",
		   "Run": "run",
		   "AgentJobInfo": "AgentJobInfo"
		};

    function convertRequestDocToWMStatsFormat(doc) {
    	// check document type whether it is reqmgr doc
    	// this is hacky way to check  - need better checking 
    	if (doc.RequestName == undefined) {
    		return doc;
    	};
    	
    	// this is temporary hack to identify missing RequestTransition property
    	// all the workflows which has missing info need to be manually updated
    	if (doc.RequestTransition == undefined || doc.RequestTransition.length == 0) {
    		doc.RequestTransition = [{"Status": "N/A", "UpdateTime": 0}];
    	}
    	var wmstatsReq = {};
    	for (var key in doc) {
    		if (reqPropertyMap[key]) {
    			if (key == "RequestTransition") {
    				wmstatsReq[reqPropertyMap[key]] = [];
    				for (var index = 0; index < doc[key].length; index++) {
    					wmstatsReq[reqPropertyMap[key]][index] = {"status": doc[key][index]["Status"], 
    															  "update_time": doc[key][index]["UpdateTime"]};
    				}
    			} else {
    				wmstatsReq[reqPropertyMap[key]] = doc[key];
    			}	
    		} else {
    			// use original key
    			wmstatsReq[key] = doc[key];
    		}
    			
    	}
    	return wmstatsReq;
    };
    
    function getReqDetailPrefix () {
        if (_dbVariants[dbname] == "tier1") {
            return "/reqmgr2/fetch?rid=";
        } else {
            return null;
        }
        
    };

    function getAlertCollectorLink() {
        return "/couchdb/alertscollector/_design/AlertsCollector/index.html";
    };
    
    function getWorkloadSummaryPrefix () {
        return "/couchdb/" + getWorkloadSummaryDB() + "/_design/WorkloadSummary/_show/histogramByWorkflow/";
    };
    
    function getGQLink(request) {
    	var gqLink = "/couchdb/workqueue/_design/WorkQueue/_rewrite/elementsInfo?request=" + request;
    	return "<a href='" + gqLink + "' target='_blank'>GQ</a>";
    };
    
    function getLQLink(agentURLs, request){
    	if (agentURLs.constructor.name === "String"){
            agentURL = agentURLs;
        } else if (agentURLs.length && (agentURLs[0].constructor.name === "String")){
            //TODO: need to handle properly multiple agent
            agentURL = agentURLs[0];
        };
    	var lqLink = "http://" + agentURL.split(':')[0] + 
    	             ":5984/workqueue/_design/WorkQueue/_rewrite/elementsInfo?request=" + request;
    	return "<a href='" + lqLink + "' target='_blank'>LQ</a>";
    };
    
    function getWorkloadSummaryDB() {
        if (_dbVariants[dbname] == "tier1") {
            return "workloadsummary";
        } else if (_dbVariants[dbname] == "tier0") {
            return "t0_workloadsummary";
        }
    };
    
    function getAgentUrlForJobs(agentURL, workflow, status) {
    	return "http://" + agentURL.split(':')[0] + ":5984/wmagent_jobdump%2Fjobs/_design/JobDump/_list/" + 
                status + "Jobs/statusByWorkflowName?startkey=[%22" +
                workflow + "%22]&endkey=[%22" + workflow + "%22%2C{}]&reduce=false&stale=ok";
    }
    
    function formatJobLink(jobNumber, agentURLs, workflow, status) {
            if (jobNumber !== 0) {
                if (agentURLs.constructor.name === "String"){
                    agentURL = agentURLs;
                } else if (agentURLs.length && (agentURLs[0].constructor.name === "String")){
                    //TODO: need to handle properly multiple agent
                    agentURL = agentURLs[0];
                } else {
                    return jobNumber;
                }
                return "<a href='" + getAgentUrlForJobs(agentURL, workflow, status) +
                        "' target='_blank'>" + jobNumber + "</a>";
            } else {
                return jobNumber;
            };
    };

    return {
        REQ_DETAIL_URL_PREFIX: getReqDetailPrefix(),
        WORKLOAD_SUMMARY_URL_PREFIX: getWorkloadSummaryPrefix(),
        AJAX_LOADING_STATUS: {beforeSend: function(){$('#loading_page').addClass('front').show();}, 
                              complete: function(){$('#loading_page').hide();}},
        COUCHDB_NAME: dbname,
        WORKLOAD_SUMMARY_COUCHDB_NAME:  getWorkloadSummaryDB(), 
        REQMGR_COUCHDB_NAME: "reqmgr_workload_cache", //TODO: need to be configurable"reqmgrdb"
        VARIANT: _dbVariants[dbname],
        COUCHAPP_DESIGN: "WMStats",
        WORKLOAD_SUMMARY_COUCHAPP_DESIGN: "WorkloadSummary",
		REQMGR_COUCHAPP_DESIGN: "ReqMgr",
        ALERT_COLLECTOR_LINK: getAlertCollectorLink(),
        T0_COUCHAPP_DESIGN: "T0Request",
        T0_COUCHDB_NAME: "t0_request",
        LOGDB_DESIGN: "LogDB",
        LOGDB_NAME: "wmstats_logdb",
        T0_LOGDB_NAME: "t0_logdb",
        CONFIG: null, //this will be set when WMStats.Couch.loadConfig is called. just place holder or have default config
        loadScript: function (url, success) {
                        $.ajax({async: false, url: url, dataType: 'script', success: success});
            },
        importScripts: function (scripts) {
                        for (var i=0; i < scripts.length; i++) {
                                document.write('<script src="'+scripts[i]+'"><\/script>');
                                 }
              },
        Event: {}, // name space for Global Custom event
        formatJobLink: formatJobLink,
        getGQLink: getGQLink,
        getLQLink: getLQLink,
        convertRequestDocToWMStatsFormat: convertRequestDocToWMStatsFormat
       };
}(jQuery);

WMStats.namespace("CustomEvents");

WMStats.CustomEvents.REQUESTS_LOADED = "C_1";
WMStats.CustomEvents.AGENTS_LOADED = "C_2";
//logDB list page event
WMStats.CustomEvents.LOG_LOADED = "L_1";
WMStats.CustomEvents.ERROR_LOG_LOADED = "L_2";

WMStats.CustomEvents.REQUEST_SUMMARY_READY = "C_3";
WMStats.CustomEvents.CATEGORY_SUMMARY_READY = "C_4";

WMStats.CustomEvents.REQUEST_DETAIL_READY = "C_5";
WMStats.CustomEvents.CATEGORY_DETAIL_READY = "C_6";

WMStats.CustomEvents.JOB_SUMMARY_READY = "C_7";
WMStats.CustomEvents.JOB_DETAIL_READY = "C_8";

WMStats.CustomEvents.LOADING_DIV_START = "C_9";
WMStats.CustomEvents.LOADING_DIV_END = "C_10";

WMStats.CustomEvents.HISTORY_LOADED = "C_11";
WMStats.CustomEvents.AJAX_LOADING_START = "C_12";
WMStats.CustomEvents.RESUBMISSION_SUMMARY_READY = "C_13";
WMStats.CustomEvents.RESUBMISSION_SUCCESS = "C_14";

//workload summary page event
WMStats.CustomEvents.WORKLOAD_SUMMARY_READY = "W_1";

//view model (need to move to proper location)
WMStats.namespace("ViewModel");
WMStats.ViewModel.Resubmission = {};
WMStats.namespace("Utils");

    /* simple function to clone obj only works with no prototype */
WMStats.Utils.cloneObj = function(sourceObj) {
        if (typeof sourceObj === "object"){
            var newObj = sourceObj.constructor();
            for (var prop in sourceObj) {
                newObj[prop] = WMStats.Utils.cloneObj(sourceObj[prop]);
            }
            return newObj;
        } else {
            return sourceObj;
        }
    };
    
WMStats.Utils.updateObj = function (baseObj, additionObj, createFlag, updateFunc) {
   /*
    * update baseObj using additonObj.
    * baseObj will be updated but additonObj will the same.
    * updateFuct is the function pointer defines how the object wiil be updated
    * updateFunction takes 3 parameters, baseObj, additonObj, field
    * if udateFunc is not define use addition.
    * createFlag is set to true by default
    */
   
   for (var field in additionObj) {
        if (!baseObj[field]) {
            if (createFlag === undefined || createFlag) {
                baseObj[field] = WMStats.Utils.cloneObj(additionObj[field]);
            }
        } else {
            if (typeof(baseObj[field]) == "object"){
                WMStats.Utils.updateObj(baseObj[field], additionObj[field], createFlag, updateFunc);
            } else {
                if (updateFunc instanceof Function){
                    updateFunc(baseObj, additionObj, field);
                } else {
                    //default is adding
                    baseObj[field] += additionObj[field];
                }
            }
        }
    } 
};

WMStats.Utils.getOrDefault= function (baseObj, objList, val) {
    
    if (baseObj[objList[0]]) { 
        if (objList.length == 1) {
            return baseObj[objList[0]];
        } else {
            return WMStats.Utils.getOrDefault(baseObj[objList[0]], 
                                                         objList.slice(1), val);
        }
    } else {
        return val;
    } 
};

WMStats.Utils.get = function (baseObj, objStr, val) {
    if (baseObj === undefined) {
        return val;
    }
    objList = objStr.split('.');
    return WMStats.Utils.getOrDefault(baseObj, objList, val); 
};

WMStats.Utils.formatReqDetailUrl = function (request) {
	urlLink = WMStats.Globals.REQ_DETAIL_URL_PREFIX;
	return '<a href="' + urlLink + 
            encodeURIComponent(request) + '" target="requestDetailFrame">' + request + '</a>';
};

WMStats.Utils.formatWorkloadSummarylUrl = function (request, status) {
    if (status === undefined) {
        return '<a href="' + WMStats.Globals.WORKLOAD_SUMMARY_URL_PREFIX + 
                encodeURIComponent(request) + '" target="workloadSummaryFrame">' + request + '</a>';
    } else if (status == "completed" || status == "announced" ||
        status == "closed-out" || status.indexOf("archived") !== -1) {
        return '<a href="' + WMStats.Globals.WORKLOAD_SUMMARY_URL_PREFIX + 
                encodeURIComponent(request) + '" target="workloadSummaryFrame">' + status + '</a>';
    } else {
        return status;
    }
};

WMStats.Utils.formatDate = function (timestamp) {
    var date = new Date(timestamp * 1000);
    return (date.getFullYear() + "-" + date.getMonth() + "-" + date.getDate() + 
           " " + date.getHours() + ":" + date.getMinutes());
};

WMStats.Utils.formatDuration = function (timestamp) {
    if (timestamp < 0) return "N/A";
    var totalMin = Math.floor(timestamp / 60);
    var hours = Math.floor(totalMin / 60);
    var min = totalMin % 60;
    return (hours + " h " + min + " m");
};

WMStats.Utils.createInputFilter = function (selector) {
    // collects the data from input tag  and 
    // create the object which key value
    var a=$(selector).serializeArray(), filter={};
    $.each(a, function(i, obj){
    		if (isNaN(obj.value)) {
    			filter[obj.name] = obj.value;
    		} else{
    			filter[obj.name] = parseInt(obj.value);
    		}
            filter[obj.name] = obj.value;
        });
    return filter;
};

WMStats.Utils.formatDetailButton = function (name, warning) {
	var cssClass = "detailButtonNormal";
	
	if (warning) {
		cssClass = "detailButtonWarning";
	} 	
    return '<div class="detailButton ' + cssClass + '" name="'+ name + '"></div>';
};


WMStats.Utils.utcClock = function(date) {
    
    function appendZero(num) {
        if (num < 10) {
            return "0" + num;
        }
        return num
    }
    var day = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
    var now;
    if (date === undefined) {
        now = new Date(); 
    }else {
        now = date;
    }
    var month =  now.getUTCMonth() + 1;
    var utcString = now.getUTCFullYear() + "/" + month + "/" + 
                    now.getUTCDate() + " (" + day[now.getUTCDay()] + ") " +
                    appendZero(now.getUTCHours())  + ":" + appendZero(now.getUTCMinutes()) + ":" +
                    appendZero(now.getUTCSeconds()) + " UTC";
    return utcString;
};

WMStats.Utils.expandFormat = function(dataArray, summaryStr, formatFunc) {
    var htmlstr = "";
    if (dataArray == undefined || typeof (dataArray) !== "object" || dataArray.length == 0) {
        htmlstr +=  "<strong>" +  summaryStr + ":</strong>";
     } else {
        htmlstr += "<details> <summary><strong>" + summaryStr +"</strong></summary><ul>";
        if (formatFunc === undefined) {
            formatFunc = function(x) {return x};
        }
        for (var i in dataArray) {
            htmlstr += "<li>" + formatFunc(dataArray[i], i) + "</li>";
        }
        htmlstr += "</ul></details>";
    }
    return htmlstr;
};


WMStats.Utils.largeNumberFormat = function(number) {
    var mega = 1000000;
    var giga = 1000000000;
    if (number < mega) {
        return number;
    } else if (number < giga) {
        return (number/mega).toFixed(1) + " M";
    } else {
        return (number/giga).toFixed(1) + " G";
    }
};

WMStats.Utils.splitCouchServiceURL = function(url) {
    var urlArray = url.split('/');
    return {'couchUrl': urlArray.slice(0, -1).join('/'), 'couchdb': urlArray[urlArray.length - 1]};
};


WMStats.Utils.acdcRequestSting = function(originalRequest, requestor) {
	// also stript strings if it contains '@'
    var stripRequestor = originalRequest.replace(new RegExp('^'+ requestor.split('@')[0]), "ACDC");
    return stripRequestor.replace(/_\d+_\d+_\d+$/, "");
};

WMStats.Utils.contains = function(value, container) {
    //container is object or array
    if (container.constructor.name === "Array") {
        for (var index in container) {
            if (value == container[index]) {
                return index;
            }
        }
        return -1;
    }
    
    if (container.constructor.name === "Object") {
        for (var index in container) {
            if (value == index) {
                return index;
            }
        }
        return -1;
    }
};

WMStats.Utils.addToSet = function(array, value) {
    if (WMStats.Utils.contains(value, array) === -1) {
        array.push(value);
        return true;
    } else {
        return false;
    }
};

WMStats.Utils.delay =  (function(){
    // only need to be used in one place.
    // since timer is singlton, if it is used multiple places
    // unintented clearTimeout could happen.
    // currently only used only used in filter function.
  	var timer = 0;
  	return function(callback, ms){
    	var ms = ms || 1000;     	// default 1 sec delay 
    	clearTimeout (timer);
    	timer = setTimeout(callback, ms);
  	};
})();

WMStats.Utils.getInputDatasets = function(reqDoc) {
    if (reqDoc.inputdataset && reqDoc.inputdataset !== "None"){
        return [reqDoc.inputdataset];
    }
    if (reqDoc.TaskChain) {
        var inputDatasets = [];
        for (var i = 0; i < reqDoc.TaskChain; i++) {
            if (reqDoc["Task" + (i+1)].InputDataset && reqDoc["Task" + (i+1)].InputDataset !== "None") {
                inputDatasets.push(reqDoc["Task" + (i+1)].InputDataset);
            }
        }
        return inputDatasets;
    }
    if (reqDoc.StepChain) {
        var inputDatasets = [];
        for (var i = 0; i < reqDoc.StepChain; i++) {
            if (reqDoc["Step" + (i+1)].InputDataset && reqDoc["Step" + (i+1)].InputDataset !== "None") {
                inputDatasets.push(reqDoc["Step" + (i+1)].InputDataset);
            }
        }
    return inputDatasets;
    }
};

WMStats.Utils.formatStateTransition = function(stateTransition) {
	
	var transFunc = function(item, i) {
		return "<b>" + item.status + "</b>: " + WMStats.Utils.utcClock(new Date(item.update_time * 1000));
	};
	
  	return WMStats.Utils.expandFormat(stateTransition, "detail", transFunc);
  	
};

WMStats.Utils.entityMap = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#39;',
    '/': '&#x2F;',
    '`': '&#x60;',
    '=': '&#x3D;'
};

WMStats.Utils.escapeHtml = function(string) {
    return String(string).replace(/[&<>"'`=\/]/g, function (s) {
        return WMStats.Utils.entityMap[s];
    });
};
/*
 * Define Global values for couch db and couch db function
 * this has dependency on jquery.js and jquery.couch.js
 */
WMStats.namespace("CouchBase");
WMStats.namespace("Couch");
WMStats.namespace("WorkloadSummaryCouch");
WMStats.namespace("ReqMgrCouch");

WMStats.CouchBase = function(dbName, designName){
    // couchapp name
    var _Design = designName;
    var _couchDB = $.couch.db(dbName);
    var _config;

    function _combineOption(options, callback, ajaxOptions) {
        //combine options and callbacks for jquery.couch.js
        // ajaxOptions are object which contains jquery ajax options
        // {'beforeSend': .., 'complete': ...}
        var options = options || {};
        options.success = callback;
        //var ajaxOptions = ajaxOptions || WMStats.Globals.AJAX_LOADING_STATUS
        //var ajaxOptions = ajaxOptions
        if (ajaxOptions) {
            for (var opt in ajaxOptions) {
                options[opt] = ajaxOptions[opt];
            }
        }
        return options;
    };

    function loadConfig(func) {
        function callback(data) {
            //fist set the global config value
            var config;
            if (!data.rows && (data.rows.length != 1)) {
                //use default config
                config = null;
            } else {
                config = data.rows[0].doc;
            }
            WMStats.Globals.CONFIG = config;
            // then call the function
            func();
        }
        _couchDB.view(_Design +"/config", 
                      _combineOption({"include_docs": true}, callback));
        
    }

    function view(name, options, callback, ajaxOptions){
        //make all the view stale options update_after
        var options = options || {};
        if (options.stale === undefined) {
            options.stale = "update_after";
        }
        return _couchDB.view(_Design +"/" + name, 
                             _combineOption(options, callback, ajaxOptions));
    }
    
    function allDocs(options, callback, ajaxOptions){
        return _couchDB.allDocs(_combineOption(options, callback, ajaxOptions));
    }
    
    function openDoc(docId, callback){
        return _couchDB.openDoc(docId, _combineOption({}, callback)); 
    }

    return {'loadConfig': loadConfig, 'view': view, "allDocs": allDocs,
            'openDoc': openDoc};
};

WMStats.Couch = WMStats.CouchBase(WMStats.Globals.COUCHDB_NAME, WMStats.Globals.COUCHAPP_DESIGN);
WMStats.WorkloadSummaryCouch = WMStats.CouchBase(WMStats.Globals.WORKLOAD_SUMMARY_COUCHDB_NAME,
                                                 WMStats.Globals.WORKLOAD_SUMMARY_COUCHAPP_DESIGN);
WMStats.ReqMgrCouch = WMStats.CouchBase(WMStats.Globals.REQMGR_COUCHDB_NAME,
                                                 WMStats.Globals.REQMGR_COUCHAPP_DESIGN);
WMStats.T0Couch = WMStats.CouchBase(WMStats.Globals.T0_COUCHDB_NAME,
                                                 WMStats.Globals.T0_COUCHAPP_DESIGN);
WMStats.LogDBCouch = WMStats.CouchBase(WMStats.Globals.LOGDB_NAME,
                                                 WMStats.Globals.LOGDB_DESIGN);
WMStats.T0LogDBCouch = WMStats.CouchBase(WMStats.Globals.T0_LOGDB_NAME,
                                                 WMStats.Globals.LOGDB_DESIGN);// handles ajax call other than couchdb
WMStats.namespace("Ajax");

WMStats.Ajax = (function($){
    var reqMgrFuncs = {
        putRequest: function(requestArgs) {
        	var uri = "/reqmgr2/data/request";
        	var verb = "POST"; 
            $.ajax(uri, 
                   {type: verb,
                    //accept: {json: "application/json"},
                    //contentType: "application/json",
                    headers: {"Accept": "application/json",
                              "Content-Type": "application/json"},
                    data: JSON.stringify(requestArgs),
                    processData: false,
                    success: function(data, textStatus, jqXHR) {
                    	 	var reqInfo = {};
                    	 	reqInfo.name = data.result[0].request;
                            reqInfo.reqmgr2Only = true;
                            $(WMStats.Globals.Event).triggerHandler(WMStats.CustomEvents.RESUBMISSION_SUCCESS, reqInfo);
                            },
                    error: function(jqXHR, textStatus, errorThrown){
                            console.log("call fails, response: " + jqXHR.responseText);
                        }
                    });
              },
   };
    
    var phedexFuncs = {
        getPFN: function(location, lfn) {
            $.ajax("/phedex/datasvc/json/prod/lfn2pfn", 
                   {type: 'GET',
                    //accept: {json: "application/json"},
                    //contentType: "application/json",
                    headers: {"Accept": "application/json"},
                    data: {node: location,
                           protocol: "srmv2",
                           lfn: lfn},
                    processData: false,
                    success: function(data, textStatus, jqXHR) {
                                /*
                                 * returned data format
                                 * 
                                 * {"phedex":{"mapping":[{"protocol":"srmv2",
                                 *                       "custodial":null,"destination":null,"space_token":null,
                                 *                       "node":"T2_US_MIT",
                                 *                       "lfn":"/store/unmerged/logs/prod/2013/4/4/jen_a_ACDC234Pro_Winter532012DMETParked_FNALPrio4_537p6_130403_042115_5913/DataProcessing/DataProcessingMergeRECOoutput/skim_2012D_METParked/0001/1/00710a8c-9c5e-11e2-9408-003048f02d38-1-1-logArchive.tar.gz",
                                 *                       "pfn":"srm://se01.cmsaf.mit.edu:8443/srm/v2/server?SFN=/mnt/hadoop/cms/store/unmerged/logs/prod/2013/4/4/jen_a_ACDC234Pro_Winter532012DMETParked_FNALPrio4_537p6_130403_042115_5913/DataProcessing/DataProcessingMergeRECOoutput/skim_2012D_METParked/0001/1/00710a8c-9c5e-11e2-9408-003048f02d38-1-1-logArchive.tar.gz"
                                 *                      }],
                                 *            "request_timestamp":1366230636.06684,"instance":"prod",
                                 *            "request_url":"http://cmsweb.cern.ch:7001/phedex/datasvc/json/prod/lfn2pfn",
                                 *            "request_version":"2.3.15-comp","request_call":"lfn2pfn","call_time":0.02142,
                                 *            "request_date":"2013-04-17 20:30:36 UTC"}}
                                 */
                                var mappedData = data.phedex.mapping;
                                var pfns = [];
                                for (var i in mappedData) {
                                    pfns.push(mappedData[i].pfn);
                                }
                                $(WMStats.Globals.Event).triggerHandler(WMStats.CustomEvents.PHEDEX_PFN_SUCCESS, pfns);
                            },
                    error: function(jqXHR, textStatus, errorThrown){
                            console.log("call fails, response: " + jqXHR.responseText);
                        }
                    });
        }
    };
    
    return {
        requestMgr: reqMgrFuncs,
        phedex: phedexFuncs
        };
})(jQuery);
