# MODESpy

**MODESpy** implements generic methods for constructing and using
parameterised linear multi-step methods to solve Ordinary Differential
Equation Initial Value Problems (ODE IVPs). It is a Python implementation
based on the MODES toolbox (Version 1.0.0) written in MATLAB from Lund
University (refer to **[documentation](https://modespy.readthedocs.io/en/latest/)**
 for details). 

The current version is **0.9.0**.

## Installation

MODESpy relies on the installation of SciPy and NumPy, 
**[see this link](https://docs.scipy.org/doc/numpy/user/install.html)**.

Install MODESpy using the typical pip installation methods, for example:
- Using a shell with pip directly and root access:
```console
$ pip install modespy
```
- Using a windows prompt as a user only: 
```console
C:\> py -m pip install --user modespy
```

## Documentation [![Documentation Status](https://readthedocs.org/projects/modespy/badge/?version=latest)](https://modespy.readthedocs.io/en/latest/?badge=latest)

Documentation can be found at
 **[ReadTheDocs](https://modespy.readthedocs.io/en/latest/)**.
 
## Source Code 

The source code is available in the
**[Github repository](https://github.com/ericjwhitney/modespy)**.

## License [![License](http://img.shields.io/:license-mit-blue.svg?style=flat-square)](http://badges.mit-license.org)

MODESPy is provided free of charge for use under the conditions of the 
**[MIT license](http://opensource.org/licenses/mit-license.php)**.

See the 
**[license file](https://github.com/ericjwhitney/modespy/blob/master/LICENSE)**
for more details.


**Copyright 2020 © Eric J. Whitney**