"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
const render_options_1 = require("projen/lib/javascript/render-options");
const synth_1 = require("projen/lib/util/synth");
const src_1 = require("../src");
describe("PDK Pipeline Py Unit Tests", () => {
    it("Defaults", () => {
        const project = new src_1.PDKPipelinePyProject({
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "defaults",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "Defaults",
        });
        expect(sanitizeOutput(synth_1.synthSnapshot(project))).toMatchSnapshot();
    });
    it("projenrc synth correctly", () => {
        const project = new src_1.PDKPipelinePyProject(render_options_1.renderProjenInitOptions("@aws-prototyping-sdk/pipeline.PDKPipelinePyProject", {
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "defaults",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "ProjenRc",
        }));
        expect(synth_1.synthSnapshot(project)[".projenrc.py"]).toMatchSnapshot();
    });
    it("With Context", () => {
        const project = new src_1.PDKPipelinePyProject({
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "with_context",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "WithContext",
            context: {
                sonarqubeScannerConfig: {
                    sonarqubeEndpoint: "https://my.endpoint",
                    sonarqubeAuthorizedGroup: "group",
                    sonarqubeDefaultProfileOrGateName: "default",
                    sonarqubeSpecificProfileOrGateName: "specific",
                    sonarqubeProjectName: "WithContext",
                    sonarqubeTags: ["sample"],
                    preArchiveCommands: ["echo here"],
                },
            },
        });
        expect(sanitizeOutput(synth_1.synthSnapshot(project))).toMatchSnapshot();
    });
    it("Custom AppEntrypoint", () => {
        const project = new src_1.PDKPipelinePyProject({
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "custom_app_entrypoint",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "CustomAppEntrypoint",
            appEntrypoint: "updated.py",
        });
        expect(sanitizeOutput(synth_1.synthSnapshot(project))).toMatchSnapshot();
    });
});
function sanitizeOutput(output) {
    Object.keys(output)
        .filter((k) => k.includes("__pycache__"))
        .forEach((k) => delete output[k]);
    return output;
}
//# sourceMappingURL=data:application/json;base64,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