"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const application_stage_1 = require("./application-stage");
const pipeline_stack_1 = require("./pipeline-stack");
const app = new aws_cdk_lib_1.App();
const pipelineStack = new pipeline_stack_1.PipelineStack(app, 'PipelineStack', {
    env: {
        account: process.env.CDK_DEFAULT_ACCOUNT,
        region: process.env.CDK_DEFAULT_REGION,
    },
});
const devStage = new application_stage_1.ApplicationStage(app, 'Dev', {
    env: {
        account: process.env.CDK_DEFAULT_ACCOUNT,
        region: process.env.CDK_DEFAULT_REGION, // Replace with Dev region
    },
});
pipelineStack.pipeline.addStage(devStage);
// Add additional stages here i.e. Prod
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlwZWxpbmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcGlwZWxpbmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHFFQUFxRTtBQUNyRSxzQ0FBc0M7O0FBRXRDLDZDQUFrQztBQUNsQywyREFBdUQ7QUFDdkQscURBQWlEO0FBRWpELE1BQU0sR0FBRyxHQUFHLElBQUksaUJBQUcsRUFBRSxDQUFDO0FBRXRCLE1BQU0sYUFBYSxHQUFHLElBQUksOEJBQWEsQ0FBQyxHQUFHLEVBQUUsZUFBZSxFQUFFO0lBQzVELEdBQUcsRUFBRTtRQUNILE9BQU8sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLG1CQUFvQjtRQUN6QyxNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBbUI7S0FDeEM7Q0FDRixDQUFDLENBQUM7QUFFSCxNQUFNLFFBQVEsR0FBRyxJQUFJLG9DQUFnQixDQUFDLEdBQUcsRUFBRSxLQUFLLEVBQUU7SUFDaEQsR0FBRyxFQUFFO1FBQ0gsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW9CO1FBQ3pDLE1BQU0sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGtCQUFtQixFQUFFLDBCQUEwQjtLQUNwRTtDQUNGLENBQUMsQ0FBQztBQUVILGFBQWEsQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0FBRTFDLHVDQUF1QztBQUV2QyxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbi8vIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG5cbmltcG9ydCB7IEFwcCB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IEFwcGxpY2F0aW9uU3RhZ2UgfSBmcm9tICcuL2FwcGxpY2F0aW9uLXN0YWdlJztcbmltcG9ydCB7IFBpcGVsaW5lU3RhY2sgfSBmcm9tICcuL3BpcGVsaW5lLXN0YWNrJztcblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuXG5jb25zdCBwaXBlbGluZVN0YWNrID0gbmV3IFBpcGVsaW5lU3RhY2soYXBwLCAnUGlwZWxpbmVTdGFjaycsIHtcbiAgZW52OiB7XG4gICAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCEsXG4gICAgcmVnaW9uOiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9SRUdJT04hLFxuICB9LFxufSk7XG5cbmNvbnN0IGRldlN0YWdlID0gbmV3IEFwcGxpY2F0aW9uU3RhZ2UoYXBwLCAnRGV2Jywge1xuICBlbnY6IHtcbiAgICBhY2NvdW50OiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9BQ0NPVU5UISwgLy8gUmVwbGFjZSB3aXRoIERldiBhY2NvdW50XG4gICAgcmVnaW9uOiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9SRUdJT04hLCAvLyBSZXBsYWNlIHdpdGggRGV2IHJlZ2lvblxuICB9LFxufSk7XG5cbnBpcGVsaW5lU3RhY2sucGlwZWxpbmUuYWRkU3RhZ2UoZGV2U3RhZ2UpO1xuXG4vLyBBZGQgYWRkaXRpb25hbCBzdGFnZXMgaGVyZSBpLmUuIFByb2RcblxuYXBwLnN5bnRoKCk7XG4iXX0=