# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_template_id: pulumi.Input[str],
                 create_timeout: Optional[pulumi.Input[int]] = None,
                 discovery_url: Optional[pulumi.Input[str]] = None,
                 docker_volume_size: Optional[pulumi.Input[int]] = None,
                 fixed_network: Optional[pulumi.Input[str]] = None,
                 fixed_subnet: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 floating_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 keypair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_count: Optional[pulumi.Input[int]] = None,
                 master_flavor: Optional[pulumi.Input[str]] = None,
                 merge_labels: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] cluster_template_id: The UUID of the V1 Container Infra cluster
               template. Changing this creates a new cluster.
        :param pulumi.Input[int] create_timeout: The timeout (in minutes) for creating the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] discovery_url: The URL used for cluster node discovery.
               Changing this creates a new cluster.
        :param pulumi.Input[int] docker_volume_size: The size (in GB) of the Docker volume.
               Changing this creates a new cluster.
        :param pulumi.Input[str] fixed_network: The fixed network that will be attached to the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] fixed_subnet: The fixed subnet that will be attached to the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] flavor: The flavor for the nodes of the cluster. Can be set via
               the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
               cluster.
        :param pulumi.Input[bool] floating_ip_enabled: Indicates whether floating IP should be
               created for every cluster node. Changing this creates a new cluster.
        :param pulumi.Input[str] keypair: The name of the Compute service SSH keypair. Changing
               this creates a new cluster.
        :param pulumi.Input[Mapping[str, Any]] labels: The list of key value pairs representing additional
               properties of the cluster. Changing this creates a new cluster.
        :param pulumi.Input[int] master_count: The number of master nodes for the cluster.
               Changing this creates a new cluster.
        :param pulumi.Input[str] master_flavor: The flavor for the master nodes. Can be set via
               the `OS_MAGNUM_MASTER_FLAVOR` environment variable. Changing this creates a
               new cluster.
        :param pulumi.Input[bool] merge_labels: Indicates whether the provided labels should be
               merged with cluster template labels. Changing this creates a new cluster.
        :param pulumi.Input[str] name: The name of the cluster. Changing this updates the name
               of the existing cluster template.
        :param pulumi.Input[int] node_count: The number of nodes for the cluster. Changing this
               creates a new cluster.
        :param pulumi.Input[str] region: The region in which to obtain the V1 Container Infra
               client. A Container Infra client is needed to create a cluster. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               cluster.
        """
        pulumi.set(__self__, "cluster_template_id", cluster_template_id)
        if create_timeout is not None:
            pulumi.set(__self__, "create_timeout", create_timeout)
        if discovery_url is not None:
            pulumi.set(__self__, "discovery_url", discovery_url)
        if docker_volume_size is not None:
            pulumi.set(__self__, "docker_volume_size", docker_volume_size)
        if fixed_network is not None:
            pulumi.set(__self__, "fixed_network", fixed_network)
        if fixed_subnet is not None:
            pulumi.set(__self__, "fixed_subnet", fixed_subnet)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if floating_ip_enabled is not None:
            pulumi.set(__self__, "floating_ip_enabled", floating_ip_enabled)
        if keypair is not None:
            pulumi.set(__self__, "keypair", keypair)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if master_count is not None:
            pulumi.set(__self__, "master_count", master_count)
        if master_flavor is not None:
            pulumi.set(__self__, "master_flavor", master_flavor)
        if merge_labels is not None:
            pulumi.set(__self__, "merge_labels", merge_labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="clusterTemplateId")
    def cluster_template_id(self) -> pulumi.Input[str]:
        """
        The UUID of the V1 Container Infra cluster
        template. Changing this creates a new cluster.
        """
        return pulumi.get(self, "cluster_template_id")

    @cluster_template_id.setter
    def cluster_template_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_template_id", value)

    @property
    @pulumi.getter(name="createTimeout")
    def create_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout (in minutes) for creating the
        cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "create_timeout")

    @create_timeout.setter
    def create_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "create_timeout", value)

    @property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL used for cluster node discovery.
        Changing this creates a new cluster.
        """
        return pulumi.get(self, "discovery_url")

    @discovery_url.setter
    def discovery_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_url", value)

    @property
    @pulumi.getter(name="dockerVolumeSize")
    def docker_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size (in GB) of the Docker volume.
        Changing this creates a new cluster.
        """
        return pulumi.get(self, "docker_volume_size")

    @docker_volume_size.setter
    def docker_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "docker_volume_size", value)

    @property
    @pulumi.getter(name="fixedNetwork")
    def fixed_network(self) -> Optional[pulumi.Input[str]]:
        """
        The fixed network that will be attached to the
        cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "fixed_network")

    @fixed_network.setter
    def fixed_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_network", value)

    @property
    @pulumi.getter(name="fixedSubnet")
    def fixed_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The fixed subnet that will be attached to the
        cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "fixed_subnet")

    @fixed_subnet.setter
    def fixed_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_subnet", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        The flavor for the nodes of the cluster. Can be set via
        the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
        cluster.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="floatingIpEnabled")
    def floating_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether floating IP should be
        created for every cluster node. Changing this creates a new cluster.
        """
        return pulumi.get(self, "floating_ip_enabled")

    @floating_ip_enabled.setter
    def floating_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "floating_ip_enabled", value)

    @property
    @pulumi.getter
    def keypair(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Compute service SSH keypair. Changing
        this creates a new cluster.
        """
        return pulumi.get(self, "keypair")

    @keypair.setter
    def keypair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keypair", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of key value pairs representing additional
        properties of the cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="masterCount")
    def master_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of master nodes for the cluster.
        Changing this creates a new cluster.
        """
        return pulumi.get(self, "master_count")

    @master_count.setter
    def master_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_count", value)

    @property
    @pulumi.getter(name="masterFlavor")
    def master_flavor(self) -> Optional[pulumi.Input[str]]:
        """
        The flavor for the master nodes. Can be set via
        the `OS_MAGNUM_MASTER_FLAVOR` environment variable. Changing this creates a
        new cluster.
        """
        return pulumi.get(self, "master_flavor")

    @master_flavor.setter
    def master_flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_flavor", value)

    @property
    @pulumi.getter(name="mergeLabels")
    def merge_labels(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the provided labels should be
        merged with cluster template labels. Changing this creates a new cluster.
        """
        return pulumi.get(self, "merge_labels")

    @merge_labels.setter
    def merge_labels(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster. Changing this updates the name
        of the existing cluster template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes for the cluster. Changing this
        creates a new cluster.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V1 Container Infra
        client. A Container Infra client is needed to create a cluster. If omitted,
        the `region` argument of the provider is used. Changing this creates a new
        cluster.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 api_address: Optional[pulumi.Input[str]] = None,
                 cluster_template_id: Optional[pulumi.Input[str]] = None,
                 coe_version: Optional[pulumi.Input[str]] = None,
                 container_version: Optional[pulumi.Input[str]] = None,
                 create_timeout: Optional[pulumi.Input[int]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 discovery_url: Optional[pulumi.Input[str]] = None,
                 docker_volume_size: Optional[pulumi.Input[int]] = None,
                 fixed_network: Optional[pulumi.Input[str]] = None,
                 fixed_subnet: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 floating_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 keypair: Optional[pulumi.Input[str]] = None,
                 kubeconfig: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 master_count: Optional[pulumi.Input[int]] = None,
                 master_flavor: Optional[pulumi.Input[str]] = None,
                 merge_labels: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[str] cluster_template_id: The UUID of the V1 Container Infra cluster
               template. Changing this creates a new cluster.
        :param pulumi.Input[int] create_timeout: The timeout (in minutes) for creating the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] discovery_url: The URL used for cluster node discovery.
               Changing this creates a new cluster.
        :param pulumi.Input[int] docker_volume_size: The size (in GB) of the Docker volume.
               Changing this creates a new cluster.
        :param pulumi.Input[str] fixed_network: The fixed network that will be attached to the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] fixed_subnet: The fixed subnet that will be attached to the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] flavor: The flavor for the nodes of the cluster. Can be set via
               the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
               cluster.
        :param pulumi.Input[bool] floating_ip_enabled: Indicates whether floating IP should be
               created for every cluster node. Changing this creates a new cluster.
        :param pulumi.Input[str] keypair: The name of the Compute service SSH keypair. Changing
               this creates a new cluster.
        :param pulumi.Input[Mapping[str, Any]] labels: The list of key value pairs representing additional
               properties of the cluster. Changing this creates a new cluster.
        :param pulumi.Input[int] master_count: The number of master nodes for the cluster.
               Changing this creates a new cluster.
        :param pulumi.Input[str] master_flavor: The flavor for the master nodes. Can be set via
               the `OS_MAGNUM_MASTER_FLAVOR` environment variable. Changing this creates a
               new cluster.
        :param pulumi.Input[bool] merge_labels: Indicates whether the provided labels should be
               merged with cluster template labels. Changing this creates a new cluster.
        :param pulumi.Input[str] name: The name of the cluster. Changing this updates the name
               of the existing cluster template.
        :param pulumi.Input[int] node_count: The number of nodes for the cluster. Changing this
               creates a new cluster.
        :param pulumi.Input[str] project_id: The project of the cluster. Required if admin wants
               to create a cluster in another project. Changing this creates a new
               cluster.
        :param pulumi.Input[str] region: The region in which to obtain the V1 Container Infra
               client. A Container Infra client is needed to create a cluster. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               cluster.
        :param pulumi.Input[str] user_id: The user of the cluster. Required if admin wants to
               create a cluster template for another user. Changing this creates a new
               cluster.
        """
        if api_address is not None:
            pulumi.set(__self__, "api_address", api_address)
        if cluster_template_id is not None:
            pulumi.set(__self__, "cluster_template_id", cluster_template_id)
        if coe_version is not None:
            pulumi.set(__self__, "coe_version", coe_version)
        if container_version is not None:
            pulumi.set(__self__, "container_version", container_version)
        if create_timeout is not None:
            pulumi.set(__self__, "create_timeout", create_timeout)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if discovery_url is not None:
            pulumi.set(__self__, "discovery_url", discovery_url)
        if docker_volume_size is not None:
            pulumi.set(__self__, "docker_volume_size", docker_volume_size)
        if fixed_network is not None:
            pulumi.set(__self__, "fixed_network", fixed_network)
        if fixed_subnet is not None:
            pulumi.set(__self__, "fixed_subnet", fixed_subnet)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if floating_ip_enabled is not None:
            pulumi.set(__self__, "floating_ip_enabled", floating_ip_enabled)
        if keypair is not None:
            pulumi.set(__self__, "keypair", keypair)
        if kubeconfig is not None:
            pulumi.set(__self__, "kubeconfig", kubeconfig)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if master_addresses is not None:
            pulumi.set(__self__, "master_addresses", master_addresses)
        if master_count is not None:
            pulumi.set(__self__, "master_count", master_count)
        if master_flavor is not None:
            pulumi.set(__self__, "master_flavor", master_flavor)
        if merge_labels is not None:
            pulumi.set(__self__, "merge_labels", merge_labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_addresses is not None:
            pulumi.set(__self__, "node_addresses", node_addresses)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="apiAddress")
    def api_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "api_address")

    @api_address.setter
    def api_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_address", value)

    @property
    @pulumi.getter(name="clusterTemplateId")
    def cluster_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the V1 Container Infra cluster
        template. Changing this creates a new cluster.
        """
        return pulumi.get(self, "cluster_template_id")

    @cluster_template_id.setter
    def cluster_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_template_id", value)

    @property
    @pulumi.getter(name="coeVersion")
    def coe_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "coe_version")

    @coe_version.setter
    def coe_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "coe_version", value)

    @property
    @pulumi.getter(name="containerVersion")
    def container_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "container_version")

    @container_version.setter
    def container_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_version", value)

    @property
    @pulumi.getter(name="createTimeout")
    def create_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout (in minutes) for creating the
        cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "create_timeout")

    @create_timeout.setter
    def create_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "create_timeout", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL used for cluster node discovery.
        Changing this creates a new cluster.
        """
        return pulumi.get(self, "discovery_url")

    @discovery_url.setter
    def discovery_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_url", value)

    @property
    @pulumi.getter(name="dockerVolumeSize")
    def docker_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size (in GB) of the Docker volume.
        Changing this creates a new cluster.
        """
        return pulumi.get(self, "docker_volume_size")

    @docker_volume_size.setter
    def docker_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "docker_volume_size", value)

    @property
    @pulumi.getter(name="fixedNetwork")
    def fixed_network(self) -> Optional[pulumi.Input[str]]:
        """
        The fixed network that will be attached to the
        cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "fixed_network")

    @fixed_network.setter
    def fixed_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_network", value)

    @property
    @pulumi.getter(name="fixedSubnet")
    def fixed_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The fixed subnet that will be attached to the
        cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "fixed_subnet")

    @fixed_subnet.setter
    def fixed_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_subnet", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        The flavor for the nodes of the cluster. Can be set via
        the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
        cluster.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="floatingIpEnabled")
    def floating_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether floating IP should be
        created for every cluster node. Changing this creates a new cluster.
        """
        return pulumi.get(self, "floating_ip_enabled")

    @floating_ip_enabled.setter
    def floating_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "floating_ip_enabled", value)

    @property
    @pulumi.getter
    def keypair(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Compute service SSH keypair. Changing
        this creates a new cluster.
        """
        return pulumi.get(self, "keypair")

    @keypair.setter
    def keypair(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keypair", value)

    @property
    @pulumi.getter
    def kubeconfig(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "kubeconfig")

    @kubeconfig.setter
    def kubeconfig(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "kubeconfig", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of key value pairs representing additional
        properties of the cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="masterAddresses")
    def master_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "master_addresses")

    @master_addresses.setter
    def master_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "master_addresses", value)

    @property
    @pulumi.getter(name="masterCount")
    def master_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of master nodes for the cluster.
        Changing this creates a new cluster.
        """
        return pulumi.get(self, "master_count")

    @master_count.setter
    def master_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_count", value)

    @property
    @pulumi.getter(name="masterFlavor")
    def master_flavor(self) -> Optional[pulumi.Input[str]]:
        """
        The flavor for the master nodes. Can be set via
        the `OS_MAGNUM_MASTER_FLAVOR` environment variable. Changing this creates a
        new cluster.
        """
        return pulumi.get(self, "master_flavor")

    @master_flavor.setter
    def master_flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_flavor", value)

    @property
    @pulumi.getter(name="mergeLabels")
    def merge_labels(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the provided labels should be
        merged with cluster template labels. Changing this creates a new cluster.
        """
        return pulumi.get(self, "merge_labels")

    @merge_labels.setter
    def merge_labels(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster. Changing this updates the name
        of the existing cluster template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeAddresses")
    def node_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "node_addresses")

    @node_addresses.setter
    def node_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_addresses", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes for the cluster. Changing this
        creates a new cluster.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The project of the cluster. Required if admin wants
        to create a cluster in another project. Changing this creates a new
        cluster.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V1 Container Infra
        client. A Container Infra client is needed to create a cluster. If omitted,
        the `region` argument of the provider is used. Changing this creates a new
        cluster.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_id", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The user of the cluster. Required if admin wants to
        create a cluster template for another user. Changing this creates a new
        cluster.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_template_id: Optional[pulumi.Input[str]] = None,
                 create_timeout: Optional[pulumi.Input[int]] = None,
                 discovery_url: Optional[pulumi.Input[str]] = None,
                 docker_volume_size: Optional[pulumi.Input[int]] = None,
                 fixed_network: Optional[pulumi.Input[str]] = None,
                 fixed_subnet: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 floating_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 keypair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_count: Optional[pulumi.Input[int]] = None,
                 master_flavor: Optional[pulumi.Input[str]] = None,
                 merge_labels: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Create a Cluster

        ```python
        import pulumi
        import pulumi_openstack as openstack

        cluster1 = openstack.containerinfra.Cluster("cluster1",
            cluster_template_id="b9a45c5c-cd03-4958-82aa-b80bf93cb922",
            keypair="ssh_keypair",
            master_count=3,
            node_count=5)
        ```
        ## Attributes reference

        The following attributes are exported:

        * `region` - See Argument Reference above.
        * `name` - See Argument Reference above.
        * `project_id` - See Argument Reference above.
        * `created_at` - The time at which cluster was created.
        * `updated_at` - The time at which cluster was created.
        * `api_address` - COE API address.
        * `coe_version` - COE software version.
        * `cluster_template_id` - See Argument Reference above.
        * `container_version` - Container software version.
        * `create_timeout` - See Argument Reference above.
        * `discovery_url` - See Argument Reference above.
        * `docker_volume_size` - See Argument Reference above.
        * `flavor` - See Argument Reference above.
        * `master_flavor` - See Argument Reference above.
        * `keypair` - See Argument Reference above.
        * `labels` - See Argument Reference above.
        * `merge_labels` - See Argument Reference above.
        * `master_count` - See Argument Reference above.
        * `node_count` - See Argument Reference above.
        * `fixed_network` - See Argument Reference above.
        * `fixed_subnet` - See Argument Reference above.
        * `floating_ip_enabled` - See Argument Reference above.
        * `master_addresses` - IP addresses of the master node of the cluster.
        * `node_addresses` - IP addresses of the node of the cluster.
        * `stack_id` - UUID of the Orchestration service stack.
        * `kubeconfig` - The Kubernetes cluster's credentials
          * `raw_config` - The raw kubeconfig file
          * `host` - The cluster's API server URL
          * `cluster_ca_certificate` - The cluster's CA certificate
          * `client_key` - The client's RSA key
          * `client_certificate` - The client's certificate

        ## Import

        Clusters can be imported using the `id`, e.g.

        ```sh
         $ pulumi import openstack:containerinfra/cluster:Cluster cluster_1 ce0f9463-dd25-474b-9fe8-94de63e5e42b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_template_id: The UUID of the V1 Container Infra cluster
               template. Changing this creates a new cluster.
        :param pulumi.Input[int] create_timeout: The timeout (in minutes) for creating the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] discovery_url: The URL used for cluster node discovery.
               Changing this creates a new cluster.
        :param pulumi.Input[int] docker_volume_size: The size (in GB) of the Docker volume.
               Changing this creates a new cluster.
        :param pulumi.Input[str] fixed_network: The fixed network that will be attached to the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] fixed_subnet: The fixed subnet that will be attached to the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] flavor: The flavor for the nodes of the cluster. Can be set via
               the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
               cluster.
        :param pulumi.Input[bool] floating_ip_enabled: Indicates whether floating IP should be
               created for every cluster node. Changing this creates a new cluster.
        :param pulumi.Input[str] keypair: The name of the Compute service SSH keypair. Changing
               this creates a new cluster.
        :param pulumi.Input[Mapping[str, Any]] labels: The list of key value pairs representing additional
               properties of the cluster. Changing this creates a new cluster.
        :param pulumi.Input[int] master_count: The number of master nodes for the cluster.
               Changing this creates a new cluster.
        :param pulumi.Input[str] master_flavor: The flavor for the master nodes. Can be set via
               the `OS_MAGNUM_MASTER_FLAVOR` environment variable. Changing this creates a
               new cluster.
        :param pulumi.Input[bool] merge_labels: Indicates whether the provided labels should be
               merged with cluster template labels. Changing this creates a new cluster.
        :param pulumi.Input[str] name: The name of the cluster. Changing this updates the name
               of the existing cluster template.
        :param pulumi.Input[int] node_count: The number of nodes for the cluster. Changing this
               creates a new cluster.
        :param pulumi.Input[str] region: The region in which to obtain the V1 Container Infra
               client. A Container Infra client is needed to create a cluster. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Create a Cluster

        ```python
        import pulumi
        import pulumi_openstack as openstack

        cluster1 = openstack.containerinfra.Cluster("cluster1",
            cluster_template_id="b9a45c5c-cd03-4958-82aa-b80bf93cb922",
            keypair="ssh_keypair",
            master_count=3,
            node_count=5)
        ```
        ## Attributes reference

        The following attributes are exported:

        * `region` - See Argument Reference above.
        * `name` - See Argument Reference above.
        * `project_id` - See Argument Reference above.
        * `created_at` - The time at which cluster was created.
        * `updated_at` - The time at which cluster was created.
        * `api_address` - COE API address.
        * `coe_version` - COE software version.
        * `cluster_template_id` - See Argument Reference above.
        * `container_version` - Container software version.
        * `create_timeout` - See Argument Reference above.
        * `discovery_url` - See Argument Reference above.
        * `docker_volume_size` - See Argument Reference above.
        * `flavor` - See Argument Reference above.
        * `master_flavor` - See Argument Reference above.
        * `keypair` - See Argument Reference above.
        * `labels` - See Argument Reference above.
        * `merge_labels` - See Argument Reference above.
        * `master_count` - See Argument Reference above.
        * `node_count` - See Argument Reference above.
        * `fixed_network` - See Argument Reference above.
        * `fixed_subnet` - See Argument Reference above.
        * `floating_ip_enabled` - See Argument Reference above.
        * `master_addresses` - IP addresses of the master node of the cluster.
        * `node_addresses` - IP addresses of the node of the cluster.
        * `stack_id` - UUID of the Orchestration service stack.
        * `kubeconfig` - The Kubernetes cluster's credentials
          * `raw_config` - The raw kubeconfig file
          * `host` - The cluster's API server URL
          * `cluster_ca_certificate` - The cluster's CA certificate
          * `client_key` - The client's RSA key
          * `client_certificate` - The client's certificate

        ## Import

        Clusters can be imported using the `id`, e.g.

        ```sh
         $ pulumi import openstack:containerinfra/cluster:Cluster cluster_1 ce0f9463-dd25-474b-9fe8-94de63e5e42b
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_template_id: Optional[pulumi.Input[str]] = None,
                 create_timeout: Optional[pulumi.Input[int]] = None,
                 discovery_url: Optional[pulumi.Input[str]] = None,
                 docker_volume_size: Optional[pulumi.Input[int]] = None,
                 fixed_network: Optional[pulumi.Input[str]] = None,
                 fixed_subnet: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 floating_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 keypair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_count: Optional[pulumi.Input[int]] = None,
                 master_flavor: Optional[pulumi.Input[str]] = None,
                 merge_labels: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if cluster_template_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_template_id'")
            __props__.__dict__["cluster_template_id"] = cluster_template_id
            __props__.__dict__["create_timeout"] = create_timeout
            __props__.__dict__["discovery_url"] = discovery_url
            __props__.__dict__["docker_volume_size"] = docker_volume_size
            __props__.__dict__["fixed_network"] = fixed_network
            __props__.__dict__["fixed_subnet"] = fixed_subnet
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["floating_ip_enabled"] = floating_ip_enabled
            __props__.__dict__["keypair"] = keypair
            __props__.__dict__["labels"] = labels
            __props__.__dict__["master_count"] = master_count
            __props__.__dict__["master_flavor"] = master_flavor
            __props__.__dict__["merge_labels"] = merge_labels
            __props__.__dict__["name"] = name
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["region"] = region
            __props__.__dict__["api_address"] = None
            __props__.__dict__["coe_version"] = None
            __props__.__dict__["container_version"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["kubeconfig"] = None
            __props__.__dict__["master_addresses"] = None
            __props__.__dict__["node_addresses"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["stack_id"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["user_id"] = None
        super(Cluster, __self__).__init__(
            'openstack:containerinfra/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_address: Optional[pulumi.Input[str]] = None,
            cluster_template_id: Optional[pulumi.Input[str]] = None,
            coe_version: Optional[pulumi.Input[str]] = None,
            container_version: Optional[pulumi.Input[str]] = None,
            create_timeout: Optional[pulumi.Input[int]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            discovery_url: Optional[pulumi.Input[str]] = None,
            docker_volume_size: Optional[pulumi.Input[int]] = None,
            fixed_network: Optional[pulumi.Input[str]] = None,
            fixed_subnet: Optional[pulumi.Input[str]] = None,
            flavor: Optional[pulumi.Input[str]] = None,
            floating_ip_enabled: Optional[pulumi.Input[bool]] = None,
            keypair: Optional[pulumi.Input[str]] = None,
            kubeconfig: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            master_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            master_count: Optional[pulumi.Input[int]] = None,
            master_flavor: Optional[pulumi.Input[str]] = None,
            merge_labels: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            stack_id: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_template_id: The UUID of the V1 Container Infra cluster
               template. Changing this creates a new cluster.
        :param pulumi.Input[int] create_timeout: The timeout (in minutes) for creating the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] discovery_url: The URL used for cluster node discovery.
               Changing this creates a new cluster.
        :param pulumi.Input[int] docker_volume_size: The size (in GB) of the Docker volume.
               Changing this creates a new cluster.
        :param pulumi.Input[str] fixed_network: The fixed network that will be attached to the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] fixed_subnet: The fixed subnet that will be attached to the
               cluster. Changing this creates a new cluster.
        :param pulumi.Input[str] flavor: The flavor for the nodes of the cluster. Can be set via
               the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
               cluster.
        :param pulumi.Input[bool] floating_ip_enabled: Indicates whether floating IP should be
               created for every cluster node. Changing this creates a new cluster.
        :param pulumi.Input[str] keypair: The name of the Compute service SSH keypair. Changing
               this creates a new cluster.
        :param pulumi.Input[Mapping[str, Any]] labels: The list of key value pairs representing additional
               properties of the cluster. Changing this creates a new cluster.
        :param pulumi.Input[int] master_count: The number of master nodes for the cluster.
               Changing this creates a new cluster.
        :param pulumi.Input[str] master_flavor: The flavor for the master nodes. Can be set via
               the `OS_MAGNUM_MASTER_FLAVOR` environment variable. Changing this creates a
               new cluster.
        :param pulumi.Input[bool] merge_labels: Indicates whether the provided labels should be
               merged with cluster template labels. Changing this creates a new cluster.
        :param pulumi.Input[str] name: The name of the cluster. Changing this updates the name
               of the existing cluster template.
        :param pulumi.Input[int] node_count: The number of nodes for the cluster. Changing this
               creates a new cluster.
        :param pulumi.Input[str] project_id: The project of the cluster. Required if admin wants
               to create a cluster in another project. Changing this creates a new
               cluster.
        :param pulumi.Input[str] region: The region in which to obtain the V1 Container Infra
               client. A Container Infra client is needed to create a cluster. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               cluster.
        :param pulumi.Input[str] user_id: The user of the cluster. Required if admin wants to
               create a cluster template for another user. Changing this creates a new
               cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["api_address"] = api_address
        __props__.__dict__["cluster_template_id"] = cluster_template_id
        __props__.__dict__["coe_version"] = coe_version
        __props__.__dict__["container_version"] = container_version
        __props__.__dict__["create_timeout"] = create_timeout
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["discovery_url"] = discovery_url
        __props__.__dict__["docker_volume_size"] = docker_volume_size
        __props__.__dict__["fixed_network"] = fixed_network
        __props__.__dict__["fixed_subnet"] = fixed_subnet
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["floating_ip_enabled"] = floating_ip_enabled
        __props__.__dict__["keypair"] = keypair
        __props__.__dict__["kubeconfig"] = kubeconfig
        __props__.__dict__["labels"] = labels
        __props__.__dict__["master_addresses"] = master_addresses
        __props__.__dict__["master_count"] = master_count
        __props__.__dict__["master_flavor"] = master_flavor
        __props__.__dict__["merge_labels"] = merge_labels
        __props__.__dict__["name"] = name
        __props__.__dict__["node_addresses"] = node_addresses
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["stack_id"] = stack_id
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_id"] = user_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiAddress")
    def api_address(self) -> pulumi.Output[str]:
        return pulumi.get(self, "api_address")

    @property
    @pulumi.getter(name="clusterTemplateId")
    def cluster_template_id(self) -> pulumi.Output[str]:
        """
        The UUID of the V1 Container Infra cluster
        template. Changing this creates a new cluster.
        """
        return pulumi.get(self, "cluster_template_id")

    @property
    @pulumi.getter(name="coeVersion")
    def coe_version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "coe_version")

    @property
    @pulumi.getter(name="containerVersion")
    def container_version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "container_version")

    @property
    @pulumi.getter(name="createTimeout")
    def create_timeout(self) -> pulumi.Output[int]:
        """
        The timeout (in minutes) for creating the
        cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "create_timeout")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> pulumi.Output[str]:
        """
        The URL used for cluster node discovery.
        Changing this creates a new cluster.
        """
        return pulumi.get(self, "discovery_url")

    @property
    @pulumi.getter(name="dockerVolumeSize")
    def docker_volume_size(self) -> pulumi.Output[int]:
        """
        The size (in GB) of the Docker volume.
        Changing this creates a new cluster.
        """
        return pulumi.get(self, "docker_volume_size")

    @property
    @pulumi.getter(name="fixedNetwork")
    def fixed_network(self) -> pulumi.Output[str]:
        """
        The fixed network that will be attached to the
        cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "fixed_network")

    @property
    @pulumi.getter(name="fixedSubnet")
    def fixed_subnet(self) -> pulumi.Output[str]:
        """
        The fixed subnet that will be attached to the
        cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "fixed_subnet")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[str]:
        """
        The flavor for the nodes of the cluster. Can be set via
        the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
        cluster.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="floatingIpEnabled")
    def floating_ip_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether floating IP should be
        created for every cluster node. Changing this creates a new cluster.
        """
        return pulumi.get(self, "floating_ip_enabled")

    @property
    @pulumi.getter
    def keypair(self) -> pulumi.Output[str]:
        """
        The name of the Compute service SSH keypair. Changing
        this creates a new cluster.
        """
        return pulumi.get(self, "keypair")

    @property
    @pulumi.getter
    def kubeconfig(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "kubeconfig")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The list of key value pairs representing additional
        properties of the cluster. Changing this creates a new cluster.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="masterAddresses")
    def master_addresses(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "master_addresses")

    @property
    @pulumi.getter(name="masterCount")
    def master_count(self) -> pulumi.Output[int]:
        """
        The number of master nodes for the cluster.
        Changing this creates a new cluster.
        """
        return pulumi.get(self, "master_count")

    @property
    @pulumi.getter(name="masterFlavor")
    def master_flavor(self) -> pulumi.Output[str]:
        """
        The flavor for the master nodes. Can be set via
        the `OS_MAGNUM_MASTER_FLAVOR` environment variable. Changing this creates a
        new cluster.
        """
        return pulumi.get(self, "master_flavor")

    @property
    @pulumi.getter(name="mergeLabels")
    def merge_labels(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the provided labels should be
        merged with cluster template labels. Changing this creates a new cluster.
        """
        return pulumi.get(self, "merge_labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the cluster. Changing this updates the name
        of the existing cluster template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeAddresses")
    def node_addresses(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "node_addresses")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[Optional[int]]:
        """
        The number of nodes for the cluster. Changing this
        creates a new cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The project of the cluster. Required if admin wants
        to create a cluster in another project. Changing this creates a new
        cluster.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V1 Container Infra
        client. A Container Infra client is needed to create a cluster. If omitted,
        the `region` argument of the provider is used. Changing this creates a new
        cluster.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "stack_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The user of the cluster. Required if admin wants to
        create a cluster template for another user. Changing this creates a new
        cluster.
        """
        return pulumi.get(self, "user_id")

