// Preprocessor directives can be added at the beginning (Can't store them in AST)

/****************************************************************************
===========================================================================
   Core eC Library
===========================================================================
****************************************************************************/
#if !defined(__ECRT_HPP__)
#define __ECRT_HPP__

#define ECPRFX eC_

#include "ecrt.h"

#include <initializer_list>
#include <tuple>
#include <array>
#include <string_view>
#include <type_traits>
#include <cstdio>

// Syntactic Sugar (NOT GENERATED)

#define UNPACK(...) __VA_ARGS__

// INSTANCEL, INSTANCE: get the C++ instance out of supplied eC instance
//            x: pointer to eC instance
//            c: eC 'Class' object representing the C++ class
#define INSTANCEL(x, c) (*(void **)((char *)(x) + (c)->offset))   // For when an l-value is needed
#define INSTANCE(x, c)  ({ void * xx = x; xx ? INSTANCEL(xx, c) : 0; }) // New extension version avoiding to evaluate x twice

#define BINDINGS_CLASS(eo) (eo && eo->_class && eo->_class->bindingsClass)

#undef   newi
#define  newi(c) Instance_newEx(c, true)

#define _REGISTER_CLASS(n, ns, bs, a) \
   (XClass *)eC_registerClass( \
         ClassType_normalClass, \
         ns, bs, \
         sizeof(Instance *), 0, \
         (C(bool) (*)(void *)) n::constructor, \
         (void(*)(void *)) n::destructor, \
         (a).impl, \
         AccessMode_privateAccess, AccessMode_publicAccess)
// For defining _class and registereing together (single translation unit)
#define REGISTER_CLASS_DEF(n, b, a)    TCPPClass<n> n::_cpp_class(_REGISTER_CLASS(n,     #n, b::_cpp_class.impl->name, a));

// For defining _class and registering separately (multiple translation units)
#define CLASS_DEF(n)                   TCPPClass<n> n::_cpp_class;

#define REGISTER_CLASS(n, b, a)        n::_cpp_class.setup(_REGISTER_CLASS(n,       #n, b::_cpp_class.impl->name, a));

// For C++ classes proxying eC classes:
#define REGISTER_CPP_CLASS(n, a)       n::_cpp_class.setup(_REGISTER_CLASS(n, "CPP" #n, #n, a));

#define EVOLVE_APP(ac, a) \
   Instance_evolve(&(a).impl, ac::_cpp_class.impl); \
   INSTANCEL((a).impl, (a).impl->_class) = &(a); \
   __thisModule = (a).impl; \
   (a).vTbl = _cpp_class.vTbl;

#define REGISTER_APP_CLASS(ac, b, a) \
   REGISTER_CLASS(ac, b, a); \
   EVOLVE_APP(ac, a)

#define _CONSTRUCT(c, b) \
   INSTANCE_VIRTUAL_METHODS_PROTO(c) \
   static TCPPClass<c> _cpp_class; \
   static C(bool) constructor(C(Instance) i, C(bool) alloc) \
   { \
      if(alloc && !INSTANCEL(i, i->_class)) \
      { \
         c * inst = new c(i, _cpp_class); \
         if(inst) \
         { \
            /* printf("Must free!\n");*/ \
            inst->mustFree = true; \
         } \
         return inst != null; \
      } \
      return true; \
   } \
   static void destructor(C(Instance) i) \
   { \
      c * inst = (c *)INSTANCEL(i, i->_class); \
      if(inst) \
      { \
         if(_cpp_class.destructor) \
            ((void (*)(c & self))_cpp_class.destructor)(*inst); \
         if(inst->mustFree) \
            delete inst; \
      } \
   } \
   explicit inline c(C(Instance) _impl, CPPClass & cl = _cpp_class) : b(_impl, cl)

// NOTE: For some reason not having the move constructors and assignment operator repeated in derived classes causes strange errors
//       e.g. with DisplaySystem::pixelFormat and DisplaySystem::flags properties
#define MOVE_CONSTRUCTORS(c) \
   inline c(c && i) \
   { \
      Instance * self = (Instance *)this; \
      self->impl = i.impl; \
      self->vTbl = i.vTbl; \
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */ \
      i.impl = null; \
      i.vTbl = null; \
   } \
   inline c & operator= (c && i) \
   { \
      Instance * self = (Instance *)this; \
      if(self->impl) \
      { \
         C(Instance) impl = self->impl; \
         int refCount = impl->_refCount; \
         Instance_decRef(impl); \
         if(refCount > 1) \
         { \
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class); \
            if(inst && *inst == self) \
               *inst = null; \
         } \
      } \
      self->impl = i.impl; \
      self->vTbl = i.vTbl; \
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */ \
      i.impl = null; \
      i.vTbl = null; \
      return *this; \
   }

// NOTE: For some reason not having the move constructors and assignment operator repeated in derived classes causes strange errors
//       e.g. with DisplaySystem::pixelFormat and DisplaySystem::flags properties
#define TMOVE_CONSTRUCTORS(c, t) \
   inline c UNPACK t(c UNPACK t && i) \
   { \
      Instance * self = (Instance *)this; \
      self->impl = i.impl; \
      self->vTbl = i.vTbl; \
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */ \
      i.impl = null; \
      i.vTbl = null; \
   } \
   inline c UNPACK t & operator= (c UNPACK t && i) \
   { \
      Instance * self = (Instance *)this; \
      if(self->impl) \
      { \
         C(Instance) impl = self->impl; \
         int refCount = impl->_refCount; \
         Instance_decRef(impl); \
         if(refCount > 1) \
         { \
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class); \
            if(inst && *inst == self) \
               *inst = null; \
         } \
      } \
      self->impl = i.impl; \
      self->vTbl = i.vTbl; \
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */ \
      i.impl = null; \
      i.vTbl = null; \
      return *this; \
   }

#define CONSTRUCT(c, b) \
   MOVE_CONSTRUCTORS(c) \
   c() : c((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { } \
   _CONSTRUCT(c, b)

#define TCONSTRUCT(c, b, t) \
   TMOVE_CONSTRUCTORS(T ## c,  (UNPACK t)) \
   T ## c() : T ## c((C(Instance))Instance_newEx(ensureTemplatized  UNPACK t (_cpp_class, #c).impl, false), ensureTemplatized  UNPACK t (_cpp_class, #c)) { } \
   INSTANCE_VIRTUAL_METHODS_PROTO(T ## c) \
   static TCPPClass<T ## c> _cpp_class; \
   static C(bool) constructor(C(Instance) i, C(bool) alloc) \
   { \
      if(alloc && !INSTANCEL(i, i->_class)) \
      { \
         T ## c  UNPACK t  * inst = new T ## c  UNPACK t (i, _cpp_class); \
         if(inst) \
         { \
            /*printf("Must free!\n");*/ \
            inst->mustFree = true; \
         } \
         return inst != null; \
      } \
      return true; \
   } \
   static void destructor(C(Instance) i) \
   { \
      T ## c  UNPACK t * inst = (T ## c  UNPACK t *)INSTANCEL(i, i->_class); \
      if(inst) \
      { \
         if(_cpp_class.destructor) ((void (*)(T ## c  UNPACK t  & self))_cpp_class.destructor)(*inst); \
         if(inst->mustFree) delete inst; \
      } \
   } \
   explicit inline T ## c  UNPACK t (C(Instance) _impl, CPPClass & cl = _cpp_class) : b(_impl, cl)

#define DESTRUCT(c) \
   ((TCPPClass<c> &)_cpp_class).destructor

#define REGISTER() \
   static void class_registration(CPPClass & _cpp_class)
#define REGISTER_PROTO() \
   static void class_registration(CPPClass & _cpp_class);
#define REGISTER_IMPL(c) \
   void c::class_registration(CPPClass & _cpp_class)
#define TREGISTER_PROTO(t) \
   static void class_registration(CPPClass & _cpp_class);
#define TREGISTER_IMPL(c, t) \
   t void T ## ca::class_registration(CPPClass & _cpp_class)
#if !defined(__LINK_ECERE__)
#define __LINK_ECERE__ 1
#endif

#define APP_CONSTRUCT(c, b) \
   inline c() : c(ecrt_init_CALL(__LINK_ECERE__)) { } \
   _CONSTRUCT(c, b)

#if !defined(__WIN32__) || defined(__CONSOLE_APP__)
   #define APP_SET_ARGS(a) eC_setArgs(a.impl, argc, argv);
#else
   #define APP_SET_ARGS(a)
#endif

#define MAIN_DEFINITION \
   extern "C" MAIN_DECLARATION \
   { \
      APP_SET_ARGS(app); \
      app.main(); \
      unloadTranslatedStrings(MODULE_NAME); \
      return app.exitCode; \
   }

// SELF: get C++ class instance pointer from within hackish member of the class
#define CONTAINER_OF(ptr, type, member) ((type *)(((char *)ptr) + 0x10 - (char *)&((type *)0x10)->member))
#define TCONTAINER_OF(ptr, type, t, member) ((T ## type UNPACK t *)(((char *)ptr) + 0x10 - (char *)&((T ## type UNPACK t *)0x10)->member))
#define SELF(c, member)  __attribute__((unused)) c * self = CONTAINER_OF(this, c, member);
#define TSELF(c, t, member)  __attribute__((unused)) T ## c UNPACK t * self = TCONTAINER_OF(this, c, (UNPACK t), member);
#define getimpli(i)  ((Instance)i).impl

#define VIRTUAL_METHOD_PROTO(n, ncpp, c, b, r, p0, ep, p) \
   struct c ## _ ## n ## _Functor \
   { \
      [[no_unique_address]] int _[0]; \
      typedef r (* FunctionType)(p0 p); \
      inline FunctionType operator= (FunctionType func); \
      inline r operator()(ep p); \
   } ncpp;
   // inline static void register_ ## n(CPPClass & cl, c::c ## _ ## n ## _Functor::FunctionType func)

#define VIRTUAL_METHOD(n, ncpp, c, b, r, p0, ep, p, d) \
   inline c::c ## _ ## n ## _Functor::FunctionType c::c ## _ ## n ## _Functor::operator= (FunctionType func) \
   { \
      SELF(c, ncpp); \
      if(self->vTbl == c::_cpp_class.vTbl) \
      { \
         uint size = c::_cpp_class.impl->vTblSize; \
         self->vTbl = (void (**)())newt(c::c ## _ ## n ## _Functor::FunctionType, size); \
         memcpy(self->vTbl, c::_cpp_class.vTbl, sizeof(c::c ## _ ## n ## _Functor::FunctionType) * size); \
      } \
      ((c::c ## _ ## n ## _Functor::FunctionType *)self->vTbl)[M_VTBLID(b, n)] = func; \
      return func; \
   } \
   inline r c::c ## _ ## n ## _Functor::operator()(ep p) \
   { \
      SELF(c, ncpp); \
      d \
   }
   // inline void c::register_ ## n(CPPClass & cl, c::c ## _ ## n ## _Functor::FunctionType func)
   // {
   //    ((c::c ## _ ## n ## _Functor::FunctionType *)cl.vTbl)[M_VTBLID(b, n)] = func;
   // }

#define TVIRTUAL_METHOD_PROTO(n, ncpp, c, b, r, p0, ep, p) \
   struct c ## _ ## n ## _Functor \
   { \
      [[no_unique_address]] int _[0]; \
      typedef r (* FunctionType)(p0 p); \
      inline FunctionType operator= (FunctionType func); \
      inline r operator()(ep p); \
   } ncpp;
   // inline static void register_ ## n(CPPClass & cl, c::c ## _ ## n ## _Functor::FunctionType func)

#define TVIRTUAL_METHOD(n, ncpp, c, t, t2, b, r, p0, ep, p, d) \
   t2 \
   inline typename T ## c UNPACK t::c ## _ ## n ## _Functor::FunctionType T ## c UNPACK t::c ## _ ## n ## _Functor::operator= (FunctionType func) \
   { \
      TSELF(c, (t), ncpp); \
      if(self->vTbl == T ## c UNPACK t::_cpp_class.vTbl) \
      { \
         uint size = T ## c UNPACK t::_cpp_class.impl->vTblSize; \
         self->vTbl = (void (**)())eC_new(sizeof(T ## c UNPACK t::c ## _ ## n ## _Functor::FunctionType) * size); \
         memcpy(self->vTbl, T ## c UNPACK t::_cpp_class.vTbl, sizeof(T ## c UNPACK t::c ## _ ## n ## _Functor::FunctionType) * size); \
      } \
      ((T ## c UNPACK t::c ## _ ## n ## _Functor::FunctionType *)self->vTbl)[M_VTBLID(b, n)] = func; \
      return func; \
   } \
   t2 \
   inline r T ## c UNPACK t::c ## _ ## n ## _Functor::operator()(ep p) \
   { \
      TSELF(c, (t), ncpp); \
      d \
   }
   // inline void c::register_ ## n(CPPClass & cl, c::c ## _ ## n ## _Functor::FunctionType func)
   // {
   //    ((c::c ## _ ## n ## _Functor::FunctionType *)cl.vTbl)[M_VTBLID(b, n)] = func;
   // }

#define _REGISTER_METHOD(cp1, cp2, ns, n, bc, c, r, p, ocl, oi, code, ea, rv) \
   addMethod(_cpp_class.impl, ns, (void *) +[]p \
   { \
      XClass * cl = (ocl) ? (XClass *)(ocl)->_class : null; \
cp1 \
      c * i = (oi) ? (c *)INSTANCEL(oi, cl) : null; \
      int vid = M_VTBLID(bc, n); \
      bc ## _ ## n ## _Functor::FunctionType fn; \
      if(i && i->vTbl && i->vTbl[vid]) \
      { \
         fn = (bc ## _ ## n ## _Functor::FunctionType) i->vTbl[vid]; \
         code; \
      } \
cp2 \
      else \
      { \
         auto method = ((r (*) p)(CO( ## c)->_vTbl)[M_VTBLID(bc, n)]); \
         if(method) return method ea; \
      } \
      return rv; \
   })

#define REGISTER_METHOD(ns, n, bc, c, r, p, ocl, oi, code, ea, rv) \
   _REGISTER_METHOD(, , ns, n, bc, c, r, p, ocl, oi, code, ea, rv)

#define REGISTER_TYPED_METHOD(ns, n, bc, c, r, p, ocl, oi, code, ea, rv) \
   _REGISTER_METHOD(      CPPClass * cppcl = _class ? (CPPClass *)_class->bindingsClass : null;,       else if(cppcl && cppcl->vTbl && cppcl->vTbl[vid]) \
      { \
         fn = (bc ## _ ## n ## _Functor::FunctionType) cppcl->vTbl[vid]; \
code; \
      }, ns, n, bc, c, r, p, ocl, oi, code, ea, rv)

#define _TREGISTER_METHOD(cp1, cp2, ns, n, bc, c, t, r, p, ocl, oi, code, ea, rv) \
   addMethod(_cpp_class.impl, ns, (void *) +[]p \
   { \
      XClass * cl = (ocl) ? (XClass *)(ocl)->_class : null; \
cp1 \
      T ## c t * i = (oi) ? (T ## c t *)INSTANCEL(oi, cl) : null; \
      int vid = M_VTBLID(bc, n); \
      typename bc ## _ ## n ## _Functor::FunctionType fn; \
      if(i && i->vTbl && i->vTbl[vid]) \
      { \
         fn = (typename bc ## _ ## n ## _Functor::FunctionType) i->vTbl[vid]; \
         code; \
      } \
cp2 \
      else \
      { \
         auto method = ((r (*) p)(CO( ## c)->_vTbl)[M_VTBLID(bc, n)]); \
         if(method) return method ea; \
      } \
      return rv; \
   })

#define TREGISTER_METHOD(ns, n, bc, c, t, r, p, ocl, oi, code, ea, rv) \
   _TREGISTER_METHOD(, , ns, n, bc, c, (UNPACK t), r, p, ocl, oi, code, ea, rv)

#define TREGISTER_TYPED_METHOD(ns, n, bc, c, t, r, p, ocl, oi, code, ea, rv) \
   _TREGISTER_METHOD(      CPPClass * cppcl = _class ? (CPPClass *)_class->bindingsClass : null;,       else if(cppcl && cppcl->vTbl && cppcl->vTbl[vid]) \
      { \
         fn = (bc ## _ ## n ## _Functor::FunctionType) cppcl->vTbl[vid]; \
code; \
      }, ns, n, bc, c, (UNPACK t), r, p, ocl, oi, code, ea, rv)

template<typename T, typename U> struct is_same       { static const bool value = false; };
template<typename T>             struct is_same<T, T> { static const bool value = true; };
template<typename T, typename U> bool eqTypes()       { return is_same<T, U>::value; }

template <std::string_view const&... Strs>
struct join
{
    // Helper to get a string literal from a std::array
    template <std::size_t N, std::array<char, N> const& S, typename>
    struct to_char_array;
    template <std::size_t N, std::array<char, N> const& S, std::size_t... I>
    struct to_char_array<N, S, std::index_sequence<I...>>
    {
        static constexpr const char value[]{S[I]..., 0};
    };
    // Join all strings into a single std::array of chars
    static constexpr auto impl() noexcept
    {
        constexpr std::size_t len = (Strs.size() + ... + ((sizeof...(Strs) - 1) * 2));
        std::array<char, len + 1> arr{};
        auto append = [i = 0, first = true, &arr](auto const& s) mutable {
            if (!first) {
                arr[i++] = ',';
                arr[i++] = ' ';
            }
            first = false;
            for (auto c : s) arr[i++] = c;
        };
        (append(Strs), ...);
        arr[len] = 0;
        return arr;
    }
    // Give the joined string static storage
    static constexpr auto arr = impl();
    // Convert to a string literal, then view as a std::string_view
    static constexpr std::string_view value =
        to_char_array<arr.size(), arr, std::make_index_sequence<arr.size()>>::value;
};

template <std::string_view const&... Strs>
struct join_nocomma
{
    // Helper to get a string literal from a std::array
    template <std::size_t N, std::array<char, N> const& S, typename>
    struct to_char_array;
    template <std::size_t N, std::array<char, N> const& S, std::size_t... I>
    struct to_char_array<N, S, std::index_sequence<I...>>
    {
        static constexpr const char value[]{S[I]..., 0};
    };
    // Join all strings into a single std::array of chars
    static constexpr auto impl() noexcept
    {
        constexpr std::size_t len = (Strs.size() + ...);
        std::array<char, len + 1> arr{};
        auto append = [i = 0, &arr](auto const& s) mutable {
            for (auto c : s) arr[i++] = c;
        };
        (append(Strs), ...);
        arr[len] = 0;
        return arr;
    }
    // Give the joined string static storage
    static constexpr auto arr = impl();
    // Convert to a string literal, then view as a std::string_view
    static constexpr std::string_view value =
        to_char_array<arr.size(), arr, std::make_index_sequence<arr.size()>>::value;
};

template<typename T> struct is_const            { static const bool value = false; };
template<typename T> struct is_const<const T>   { static const bool value = true; };
template<typename T> constexpr std::string_view isConst()   { return is_const<T>::value ? "const " : ""; }

template <typename T> struct TypeName  { static constexpr const char* get() { return "int";    } };
template <> struct TypeName<int>       { static constexpr const char* get() { return "int";    } };
template <> struct TypeName<double>    { static constexpr const char* get() { return "double"; } };
template <> struct TypeName<const char *>    { static constexpr const char* get() { return "const char *"; } };

template <typename T> static constexpr std::string_view stringifyConst = isConst<T>();
template <typename T> static constexpr std::string_view stringifyTypeName = TypeName<T>::get();
template <typename T> static constexpr std::string_view stringifyType = join_nocomma<stringifyConst<T>, stringifyTypeName<T>>::value;
template <typename... T> static constexpr const char * getTemplateArgsString = join<stringifyType<T>...>::value.data();

#define REGVMETHOD(b, n, m, p, t, a) \
    if(!eqTypes<decltype(&m), decltype(&b::n)>()) \
       ((b::b ## _ ## n ## _Functor::FunctionType *)_cpp_class.vTbl)[M_VTBLID(b, n)] = +[]p { return ((t &)self).m a; };

#define TREGVMETHOD(tl, b, n, m, p, t, a) \
    if(!eqTypes<decltype(&m), decltype(&tl::n)>()) \
       ((tl::b ## _ ## n ## _Functor::FunctionType *)_cpp_class.vTbl)[M_VTBLID(b, n)] = +[]p { return ((t &)self).m a; };

#define propertyProto(n, sg) \
struct n ## _Prop \
   { \
      constexpr n ## _Prop() :_() { }; \
      [[no_unique_address]] int _[0]; \
      sg \
   } n;

#define _setProto(t, t2, n, c) \
   /*nstSet*/inline t ## t2 operator= (ttAmp vt2);

#define setProto(t, t2, n, c) \
   _setProto(t, t2, n, c/*l5 c:c te:False tp:tp tp2:tp2 */)   /*regSet*/inline c::n ## _Prop & operator= (c::n ## _Prop & prop);

#define getProto(r, t, t2, n, c) \
   /*regGet*/inline r operator t () const;

#define propertyImpl(n, sg) \
   sg \

#define _setImpl(t, t2, n, c, d) \
   /*nstSet*/inline t ## t2 c::n ## _Prop::operator= (ttAmp v ## t2) \
   { \
      SELF(c, n); \
      d \
      return v; \
   }

#define setImpl(t, t2, n, c, d) \
   _setImpl(t, t2, n, c/*l6 c:c te:False tp:tp tp2:tp2 */, d)   /*regSet*/inline c::n ## _Prop & c::n ## _Prop::operator= (c::n ## _Prop & prop) \
   { \
      SELF(c, n); \
      t ## t2 v = prop; \
      d \
      return prop; \
   }

#define getImpl(r, t, t2, n, c, d) \
   /*regGet*/inline r c::n ## _Prop::operator t () const \
   { \
      SELF(c, n); \
      d \
   }

#define TCTCO  <TC, TCO>

#define _nhsetImpl(t, t2, n, c, d) \
   /*nstSet*/template <class TC, C(Class) ** TCO> inline t ## t2 T ## c<TC, TCO>::n ## _Prop::operator= (ttAmp v ## t2) \
   { \
      SELF(c, n); \
      d \
      return v; \
   }

#define nhsetImpl(t, t2, n, c, d) \
   _nhsetImpl(t, t2, n, c/*l6 c:c te:False tp:tp tp2:tp2 */, d)   /*regSet*/template <class TC, C(Class) ** TCO> inline typename T ## c<TC, TCO>::n ## _Prop & T ## c<TC, TCO>::n ## _Prop::operator= (typename T ## c<TC, TCO>::n ## _Prop & prop) \
   { \
      SELF(c, n); \
      t ## t2 v = prop; \
      d \
      return prop; \
   }

#define nhgetImpl(r, t, t2, n, c, d) \
   /*regGet*/template <class TC, C(Class) ** TCO> inline r T ## c<TC, TCO>::n ## _Prop::operator t () const \
   { \
      __attribute__((unused)) T ## c TCTCO * self = CONTAINER_OF(this, T ## c TCTCO, n); \
      d \
   }

#define _tsetProto(t, t2, n, c, tp) \
   /*nstSet*/inline t ## t2 operator= (ttAmp vt2);

#define tsetProto(t, t2, n, c, tp) \
   _setProto(t, t2, n, c/*l5 c:c te:False tp:tp tp2:tp2 */)   /*regSet*/inline T ## c UNPACK tp ::n ## _Prop & operator= (T ## c UNPACK tp ::n ## _Prop & prop);

#define tgetProto(r, t, t2, n, c, tp) \
   /*regGet*/inline r operator t () const;

#define _tsetImpl(t, t2, n, c, tp, tp2, d) \
   /*nstSet*/tp2 inline t ## t2 T ## c UNPACK tp ::n ## _Prop::operator= (ttAmp v ## t2) \
   { \
      TSELF(c,  (UNPACK tp), n); \
      d \
      return v; \
   }

#define tsetImpl(t, t2, n, c, tp, tp2, d) \
   _tsetImpl(t, t2, n, c/*l6 c:c te:True tp:tp tp2:tp2 */, (tp), (tp2), d)   /*regSet*/tp2 inline typename T ## c UNPACK tp ::n ## _Prop & T ## c UNPACK tp ::n ## _Prop::operator= (T ## c UNPACK tp ::n ## _Prop & prop) \
   { \
      TSELF(c,  (UNPACK tp), n); \
      t ## t2 v = prop; \
      d \
      return prop; \
   }

#define tgetImpl(r, t, t2, n, c, tp, tp2, d) \
   /*regGet*/tp2 inline r T ## c UNPACK tp ::n ## _Prop::operator t () const \
   { \
      TSELF(c,  (UNPACK tp), n); \
      d \
   }

#undef Seconds
#undef TimeStamp
#undef Centimeters
#undef Degrees
#undef Feet
#undef Meters
#undef Radians

class XClass : public C(Class) { };

static int cppClassCount;

class CPPClass
{
public:
   void * operator new   (uintsize count) { return eC_new(count); }
   void * operator new [](uintsize count) { return eC_new(count); }
   void operator delete   (void * ptr) { eC_delete(ptr); }
   void operator delete [](void * ptr) { eC_delete(ptr); }

   typedef void (* Function)(void);
   XClass * impl;
   Function * vTbl;
   char * name;
   inline CPPClass() { cppClassCount++; };
   inline CPPClass(const CPPClass & c) = delete;
   inline CPPClass(CPPClass && c)
   {
      name = c.name;
      impl = c.impl;
      vTbl = c.vTbl;
      c.name = null;
      c.impl = null;
      c.vTbl = null;
   }
   ~CPPClass()
   {
      if(!--cppClassCount)
      {
         //printf("No more classes\n");
         F(checkMemory)();
      }
   }
};

template <class TC>
class TCPPClass : public CPPClass
{
public:
   TCPPClass() { }
   TCPPClass(XClass * _impl)
   {
      setup(_impl);
   }
   void (*destructor)(TC &);
   void setup(XClass * _impl)
   {
      eC_delete(name);
      impl = _impl;
      if(impl)
      {
         name = F(copyString)(impl->name);
         _impl->bindingsClass = this;
         if(vTbl)
            eC_delete(vTbl);
         vTbl = newt(Function, impl->vTblSize);
         memset(vTbl, 0, sizeof(Function) * impl->vTblSize);
         TC::class_registration(*this);
      }
   }
   ~TCPPClass()
   {
      if(impl)
         eC_delete(vTbl);
      eC_delete(name);
   }
};

template<typename ... TPs> inline CPPClass & ensureTemplatized(CPPClass & _class, const char * name)
{
   if(!_class.impl || !_class.impl->templateClass)
   {
      char type[1024];
      strcpy(type, "CPP");
      strcat(type, name);
      strcat(type, "<");
      strcat(type, getTemplateArgsString<TPs...>);
      strcat(type, ">");
      _class.impl = (XClass *)eC_findClass(__thisModule, type);
      if(_class.impl) _class.impl->bindingsClass = &_class;
   }
   return _class;
}

template <class TC>
class TIH
{
public:
   void * operator new   (uintsize count) { return eC_new(count); }
   void * operator new [](uintsize count) { return eC_new(count); }
   void operator delete   (void * ptr) { eC_delete(ptr); }
   void operator delete [](void * ptr) { eC_delete(ptr); }
   TC * object;

   bool ownRef = false;

   TIH(C(Instance) eo) : TIH(*(BINDINGS_CLASS(eo) ? (TC *)INSTANCE(eo, eo->_class) : new TC(eo)))
   {
      if(!BINDINGS_CLASS(eo) || !INSTANCE(eo, eo->_class))
      {
         ownRef = true;
      }
      else
      {
         INSTANCEL(eo, eo->_class) = object;
         eo->_refCount++;
         ownRef = false;
      }
   }
   TIH(TC & o) : object(&o)
   {
      if(o.impl)
         o.impl->_refCount++;
   }

   TIH(const TIH & h) : object(h.object)
   {
      if(object && object->impl)
         object->impl->_refCount++;
      ownRef = true;
   }

   TIH & operator= (const TIH & h)
   {
      if(object && object->impl)
         deletei(object->impl);

      ownRef = h.ownRef;
      object = h.object;
      if(object && object->impl)
         object->impl->_refCount++;
      return *this;
   }

   ~TIH()
   {
      if(object)
      {
         if(object->impl)
            object->impl->_refCount--;
         if(ownRef)
            delete object;
      }
   }

   TC& operator*() const { return *object; }
   TC* operator->() const { return object; }
};

class Application;
class Instance;
class Module;
enum class FieldType : int;
class FieldTypeEx;
struct FieldValue;
enum class FieldValueFormat : int;
template <class TC, C(Class) ** TCO> class TAVLNode;
typedef TAVLNode<C(AVLNode), &CO(AVLNode)> AVLNode;
class AVLTree;
template <typename TP_AT> class TAVLTree;
class Array;
template <typename TP_T, typename TP_I, typename TP_D> class TArray;
template <class TC, C(Class) ** TCO> class TBTNode;
typedef TBTNode<C(BTNode), &CO(BTNode)> BTNode;
struct BinaryTree;
struct BuiltInContainer;
class Container;
template <typename TP_T, typename TP_I, typename TP_D> class TContainer;
class CustomAVLTree;
template <typename TP_BT, typename TP_KT> class TCustomAVLTree;
class HashMap;
template <typename TP_KT, typename TP_VT> class THashMap;
struct HashMapIterator;
template <typename TP_KT, typename TP_VT> class THashMapIterator;
class HashTable;
template <typename TP_KT> class THashTable;
template <class TC, C(Class) ** TCO> class TItem;
typedef TItem<C(Item), &CO(Item)> Item;
struct Iterator;
template <typename TP_T, typename TP_IT> class TIterator;
template <class TC, C(Class) ** TCO> class TIteratorPointer;
typedef TIteratorPointer<C(IteratorPointer), &CO(IteratorPointer)> IteratorPointer;
template <class TC, C(Class) ** TCO> class TLink;
typedef TLink<C(Link), &CO(Link)> Link;
struct LinkElement;
template <typename TP_T> class TLinkElement;
class LinkList;
template <typename TP_LT> class TLinkList;
class List;
template <typename TP_LLT> class TList;
template <class TC, C(Class) ** TCO> class TListItem;
typedef TListItem<C(ListItem), &CO(ListItem)> ListItem;
class Map;
template <typename TP_MT, typename TP_V> class TMap;
struct MapIterator;
template <typename TP_KT, typename TP_V> class TMapIterator;
template <class TC, C(Class) ** TCO> class TMapNode;
typedef TMapNode<C(MapNode), &CO(MapNode)> MapNode;
template <class TC, C(Class) ** TCO> class TNamedItem;
typedef TNamedItem<C(NamedItem), &CO(NamedItem)> NamedItem;
template <class TC, C(Class) ** TCO> class TNamedLink;
typedef TNamedLink<C(NamedLink), &CO(NamedLink)> NamedLink;
template <class TC, C(Class) ** TCO> class TNamedLink64;
typedef TNamedLink64<C(NamedLink64), &CO(NamedLink64)> NamedLink64;
template <class TC, C(Class) ** TCO> class TOldLink;
typedef TOldLink<C(OldLink), &CO(OldLink)> OldLink;
struct OldList;
template <class TC, C(Class) ** TCO> class TStringBTNode;
typedef TStringBTNode<C(StringBTNode), &CO(StringBTNode)> StringBTNode;
struct StringBinaryTree;
enum class TreePrintStyle : int;
class Archive;
enum class ArchiveAddMode : int;
class ArchiveDir;
class ArchiveOpenFlags;
class BufferedFile;
class ConsoleFile;
class DualPipe;
class ErrorCode;
enum class ErrorLevel : int;
class File;
class FileAttribs;
class FileChange;
struct FileListing;
enum class FileLock : int;
class FileMonitor;
enum class FileOpenMode : int;
enum class FileSeekMode : int;
class FileSize;
class FileSize64;
struct FileStats;
enum class GuiErrorCode : uint;
enum class LoggingMode : int;
class MoveFileOptions;
class PipeOpenMode;
enum class SysErrorCode : uint;
class TempFile;
class CharCategories;
enum class CharCategory : int;
enum class PredefinedCharCategories : uint;
class UnicodeDecomposition;
class ECONGlobalSettings;
class ECONParser;
class GlobalAppSettings;
enum class GlobalSettingType : int;
class GlobalSettings;
class GlobalSettingsData;
class GlobalSettingsDriver;
enum class JSONFirstLetterCapitalization : int;
class JSONGlobalSettings;
class JSONParser;
enum class JSONResult : int;
class JSONTypeOptions;
class OptionsMap;
enum class SetBool : uint;
enum class SettingsIOResult : int;
template <class TC, C(Class) ** TCO> class TCondition;
typedef TCondition<C(Condition), &CO(Condition)> Condition;
template <class TC, C(Class) ** TCO> class TMutex;
typedef TMutex<C(Mutex), &CO(Mutex)> Mutex;
template <class TC, C(Class) ** TCO> class TSemaphore;
typedef TSemaphore<C(Semaphore), &CO(Semaphore)> Semaphore;
class Thread;
enum class ThreadPriority : int;
struct Date;
struct DateTime;
enum class DayOfTheWeek : int;
enum class Month : int;
class SecSince1970;
class Seconds;
class Time;
class TimeStamp;
class TimeStamp32;
enum class Access_Mode : int;
class Angle;
template <class TC, C(Class) ** TCO> class TBTNamedLink;
typedef TBTNamedLink<C(BTNamedLink), &CO(BTNamedLink)> BTNamedLink;
enum class BackSlashEscaping : uint;
template <class TC, C(Class) ** TCO> class TBitMember;
typedef TBitMember<C(BitMember), &CO(BitMember)> BitMember;
struct Box;
class Centimeters;
template <class TC, C(Class) ** TCO> class TClass;
typedef TClass<C(Class), &CO(Class)> Class;
template <class TC, C(Class) ** TCO> class TClassProperty;
typedef TClassProperty<C(ClassProperty), &CO(ClassProperty)> ClassProperty;
struct ClassTemplateArgument;
template <class TC, C(Class) ** TCO> class TClassTemplateParameter;
typedef TClassTemplateParameter<C(ClassTemplateParameter), &CO(ClassTemplateParameter)> ClassTemplateParameter;
enum class ClassType : int;
template <class TC, C(Class) ** TCO> class TDataMember;
typedef TDataMember<C(DataMember), &CO(DataMember)> DataMember;
enum class DataMemberType : int;
struct DataValue;
template <class TC, C(Class) ** TCO> class TDefinedExpression;
typedef TDefinedExpression<C(DefinedExpression), &CO(DefinedExpression)> DefinedExpression;
class Degrees;
class Distance;
template <class TC, C(Class) ** TCO> class TEnumClassData;
typedef TEnumClassData<C(EnumClassData), &CO(EnumClassData)> EnumClassData;
class EscapeCStringOptions;
class Feet;
template <class TC, C(Class) ** TCO> class TGlobalFunction;
typedef TGlobalFunction<C(GlobalFunction), &CO(GlobalFunction)> GlobalFunction;
class IOChannel;
enum class ImportType : int;
class Meters;
template <class TC, C(Class) ** TCO> class TMethod;
typedef TMethod<C(Method), &CO(Method)> Method;
enum class MethodType : int;
class MinMaxValue;
struct NameSpace;
template <class TC, C(Class) ** TCO> class TObjectInfo;
typedef TObjectInfo<C(ObjectInfo), &CO(ObjectInfo)> ObjectInfo;
enum class ObjectNotationType : uint;
enum class Platform : int;
struct Point;
struct Pointd;
struct Pointf;
template <class TC, C(Class) ** TCO> class TProperty;
typedef TProperty<C(Property), &CO(Property)> Property;
class Radians;
class SerialBuffer;
struct Size;
struct StaticString;
enum class StringAllocType : int;
template <class TC, C(Class) ** TCO> class TSubModule;
typedef TSubModule<C(SubModule), &CO(SubModule)> SubModule;
enum class TemplateMemberType : int;
enum class TemplateParameterType : int;
class ZString;

int ecrt_cpp_init(const Module & module);


enum class Alignment : int;

class DataDisplayFlags
{
public:
   C(DataDisplayFlags) impl;
   constexpr DataDisplayFlags() : impl(0) { }
   constexpr DataDisplayFlags(C(DataDisplayFlags) impl) : impl(impl) { }
   operator C(DataDisplayFlags)() { return impl; }
   DataDisplayFlags & operator =(C(DataDisplayFlags) impl) { impl = impl; return *this; }
   bool operator ==(const DataDisplayFlags & value) const { return impl == value.impl; }
   bool operator !=(const DataDisplayFlags & value) const { return impl != value.impl; }

   struct selected_Prop
   {
      constexpr selected_Prop() :_() { };
      [[no_unique_address]] int _[0];
      inline bool operator= (bool v);
      inline DataDisplayFlags::selected_Prop & operator= (DataDisplayFlags::selected_Prop & prop);
      inline operator bool () const;
   } selected;
   struct fullRow_Prop
   {
      constexpr fullRow_Prop() :_() { };
      [[no_unique_address]] int _[0];
      inline bool operator= (bool v);
      inline DataDisplayFlags::fullRow_Prop & operator= (DataDisplayFlags::fullRow_Prop & prop);
      inline operator bool () const;
   } fullRow;
   struct current_Prop
   {
      constexpr current_Prop() :_() { };
      [[no_unique_address]] int _[0];
      inline bool operator= (bool v);
      inline DataDisplayFlags::current_Prop & operator= (DataDisplayFlags::current_Prop & prop);
      inline operator bool () const;
   } current;
   struct active_Prop
   {
      constexpr active_Prop() :_() { };
      [[no_unique_address]] int _[0];
      inline bool operator= (bool v);
      inline DataDisplayFlags::active_Prop & operator= (DataDisplayFlags::active_Prop & prop);
      inline operator bool () const;
   } active;
   struct dropBox_Prop
   {
      constexpr dropBox_Prop() :_() { };
      [[no_unique_address]] int _[0];
      inline bool operator= (bool v);
      inline DataDisplayFlags::dropBox_Prop & operator= (DataDisplayFlags::dropBox_Prop & prop);
      inline operator bool () const;
   } dropBox;
   struct header_Prop
   {
      constexpr header_Prop() :_() { };
      [[no_unique_address]] int _[0];
      inline bool operator= (bool v);
      inline DataDisplayFlags::header_Prop & operator= (DataDisplayFlags::header_Prop & prop);
      inline operator bool () const;
   } header;
   struct firstField_Prop
   {
      constexpr firstField_Prop() :_() { };
      [[no_unique_address]] int _[0];
      inline bool operator= (bool v);
      inline DataDisplayFlags::firstField_Prop & operator= (DataDisplayFlags::firstField_Prop & prop);
      inline operator bool () const;
   } firstField;
};

struct Struct
{
   [[no_unique_address]] int _[0];
   void * operator new   (uintsize count) { return eC_new(count); }
   void * operator new [](uintsize count) { return eC_new(count); }
   void operator delete   (void * ptr) { eC_delete(ptr); }
   void operator delete [](void * ptr) { eC_delete(ptr); }
};

template <typename TSC>
struct TStruct : public Struct
{
   static C(Class) * _class;
   struct Struct_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      inline int operator()( /*6Bj*/Instance & object);
   } onCompare;

   struct Struct_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      inline void operator()( /*6Bj*/Instance & newData);
   } onCopy;

   struct Struct_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      inline void operator()( /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;

   struct Struct_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      inline Instance & operator()( /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;

   struct Struct_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      inline void operator()( );
   } onFree;

   struct Struct_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      inline bool operator()( /*6Fj*/const char * string);
   } onGetDataFromString;

   struct Struct_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      inline const char * operator()( /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;

   struct Struct_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      inline bool operator()( /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;

   struct Struct_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      inline void operator()( /*6Fj*/IOChannel & channel);
   } onSerialize;

   struct Struct_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      inline void operator()( /*6Fj*/IOChannel & channel);
   } onUnserialize;

};

template<typename TSC> C(Class) * TStruct<TSC>::_class;


#define Instance_onCompare_vTblID           class_onCompare_vTblID
#define Instance_onCopy_vTblID              class_onCopy_vTblID
#define Instance_onDisplay_vTblID           class_onDisplay_vTblID
#define Instance_onEdit_vTblID              class_onEdit_vTblID
#define Instance_onFree_vTblID              class_onFree_vTblID
#define Instance_onGetDataFromString_vTblID class_onGetDataFromString_vTblID
#define Instance_onGetString_vTblID         class_onGetString_vTblID
#define Instance_onSaveEdit_vTblID          class_onSaveEdit_vTblID
#define Instance_onSerialize_vTblID         class_onSerialize_vTblID
#define Instance_onUnserialize_vTblID       class_onUnserialize_vTblID

#define REG_Instance_onCompare(m, c)           REGVMETHOD(Instance, onCompare,           c::m, (XClass * _class, /*1Ab*/C(Instance) self, /*1Ab*/C(Instance) object),                                                                                                                        c, (/*4Am*/*self_l, /*4Am*/*object_l))
#define REG_Instance_onCopy(m, c)              REGVMETHOD(Instance, onCopy,              c::m, (XClass * _class, /*1Ab*/C(Instance) * self, /*1Ab*/C(Instance) newData),                                                                                                                     c, (/*4Am*/*self_l, /*4Am*/*newData_l))
#define REG_Instance_onDisplay(m, c)           REGVMETHOD(Instance, onDisplay,           c::m, (XClass * _class, /*1Ab*/C(Instance) self, /*1Ab*/Instance & surface, /*1Ab*/int x, /*1Ab*/int y, /*1Ab*/int width, /*1Ab*/void * fieldData, /*1Ab*/int alignment, /*1Ab*/uint displayFlags), c, (/*4Am*/*self_l, /*4Im*/surface, /*4Im*/x, /*4Im*/y, /*4Im*/width, /*4Im*/fieldData, /*4Im*/alignment, /*4Im*/displayFlags))
#define REG_Instance_onEdit(m, c)              REGVMETHOD(Instance, onEdit,              c::m, (XClass * _class, /*1Ab*/C(Instance) self, /*1Ab*/Instance & dataBox, /*1Ab*/Instance & obsolete, /*1Ab*/int x, /*1Ab*/int y, /*1Ab*/int w, /*1Ab*/int h, /*1Ab*/void * userData),            c, (/*4Am*/*self_l, /*4Im*/dataBox, /*4Im*/obsolete, /*4Im*/x, /*4Im*/y, /*4Im*/w, /*4Im*/h, /*4Im*/userData))
#define REG_Instance_onFree(m, c)              REGVMETHOD(Instance, onFree,              c::m, (XClass * _class, /*1Ab*/C(Instance) self),                                                                                                                                                   c, (/*4Am*/*self_l))
#define REG_Instance_onGetDataFromString(m, c) REGVMETHOD(Instance, onGetDataFromString, c::m, (XClass * _class, /*1Ab*/C(Instance) * self, /*1Ab*/const char * string),                                                                                                                     c, (/*4Am*/*self_l, /*4Im*/string))
#define REG_Instance_onGetString(m, c)         REGVMETHOD(Instance, onGetString,         c::m, (XClass * _class, /*1Ab*/C(Instance) self, /*1Ab*/char * tempString, /*1Ab*/void * reserved, /*1Ab*/ObjectNotationType * onType),                                                             c, (/*4Am*/*self_l, /*4Im*/tempString, /*4Im*/reserved, /*4Hm*/(ObjectNotationType *)onType))
#define REG_Instance_onSaveEdit(m, c)          REGVMETHOD(Instance, onSaveEdit,          c::m, (XClass * _class, /*1Ab*/C(Instance) * self, /*1Ab*/Instance & window, /*1Ab*/void * object),                                                                                                 c, (/*4Am*/*self_l, /*4Im*/window, /*4Im*/object))
#define REG_Instance_onSerialize(m, c)         REGVMETHOD(Instance, onSerialize,         c::m, (XClass * _class, /*1Ab*/C(Instance) self, /*1Ab*/IOChannel & channel),                                                                                                                       c, (/*4Am*/*self_l, /*4Im*/channel))
#define REG_Instance_onUnserialize(m, c)       REGVMETHOD(Instance, onUnserialize,       c::m, (XClass * _class, /*1Ab*/C(Instance) * self, /*1Ab*/IOChannel & channel),                                                                                                                     c, (/*4Am*/*self_l, /*4Im*/channel))

#define REG_Instance(c) \
      Instance::class_registration(_cpp_class);

#define INSTANCE_VIRTUAL_METHODS_PROTO(c) \
   VIRTUAL_METHOD_PROTO(onCompare, onCompare, c, Instance, \
      int, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Bj*/c & object); \
   VIRTUAL_METHOD_PROTO(onCopy, onCopy, c, Instance, \
      void, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Bj*/c & newData); \
   VIRTUAL_METHOD_PROTO(onDisplay, onDisplay, c, Instance, \
      void, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/Instance & surface _ARG /*6Fj*/int x _ARG /*6Fj*/int y _ARG /*6Fj*/int width _ARG /*6Fj*/void * fieldData _ARG /*6Fj*/int alignment _ARG /*6Fj*/uint displayFlags); \
   VIRTUAL_METHOD_PROTO(onEdit, onEdit, c, Instance, \
      Instance &, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/Instance & dataBox _ARG /*6Fj*/Instance & obsolete _ARG /*6Fj*/int x _ARG /*6Fj*/int y _ARG /*6Fj*/int w _ARG /*6Fj*/int h _ARG /*6Fj*/void * userData); \
   VIRTUAL_METHOD_PROTO(onFree, onFree, c, Instance, \
      void, c &, /*6Bk*/c & o_, ); \
   VIRTUAL_METHOD_PROTO(onGetDataFromString, onGetDataFromString, c, Instance, \
      bool, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/const char * string); \
   VIRTUAL_METHOD_PROTO(onGetString, onGetString, c, Instance, \
      const char *, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/char * tempString _ARG /*6Fj*/void * reserved _ARG /*6Fj*/ObjectNotationType * onType); \
   VIRTUAL_METHOD_PROTO(onSaveEdit, onSaveEdit, c, Instance, \
      bool, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/Instance & window _ARG /*6Fj*/void * object); \
   VIRTUAL_METHOD_PROTO(onSerialize, onSerialize, c, Instance, \
      void, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/IOChannel & channel); \
   VIRTUAL_METHOD_PROTO(onUnserialize, onUnserialize, c, Instance, \
      void, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/IOChannel & channel);

#define INSTANCE_VIRTUAL_METHODS(c) \
VIRTUAL_METHOD(onCompare, onCompare, c, Instance, \
   int, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Bj*/c & object, \
   return Instance_onCompare(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/object.impl);); \
VIRTUAL_METHOD(onCopy, onCopy, c, Instance, \
   void, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Bj*/c & newData, \
   Instance_onCopy(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/newData.impl);); \
VIRTUAL_METHOD(onDisplay, onDisplay, c, Instance, \
   void, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/Instance & surface _ARG /*6Fj*/int x _ARG /*6Fj*/int y _ARG /*6Fj*/int width _ARG /*6Fj*/void * fieldData _ARG /*6Fj*/int alignment _ARG /*6Fj*/uint displayFlags, \
   Instance_onDisplay(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/surface.impl, /*7Al*/x, /*7Al*/y, /*7Al*/width, /*7Al*/fieldData, /*7Al*/alignment, /*7Al*/displayFlags);); \
VIRTUAL_METHOD(onEdit, onEdit, c, Instance, \
   Instance &, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/Instance & dataBox _ARG /*6Fj*/Instance & obsolete _ARG /*6Fj*/int x _ARG /*6Fj*/int y _ARG /*6Fj*/int w _ARG /*6Fj*/int h _ARG /*6Fj*/void * userData, \
   C(Instance) retInstance = Instance_onEdit(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/dataBox.impl, /*7Al*/obsolete.impl, /*7Al*/x, /*7Al*/y, /*7Al*/w, /*7Al*/h, /*7Al*/userData); \
      return *(Instance *)INSTANCEL(retInstance, retInstance->_class);); \
VIRTUAL_METHOD(onFree, onFree, c, Instance, \
   void, c &, /*6Bk*/c & o_, , \
   Instance_onFree(_cpp_class.impl, self ? self->impl : (C(Instance))null);); \
VIRTUAL_METHOD(onGetDataFromString, onGetDataFromString, c, Instance, \
   bool, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/const char * string, \
   return (bool)Instance_onGetDataFromString(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/string);); \
VIRTUAL_METHOD(onGetString, onGetString, c, Instance, \
   const char *, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/char * tempString _ARG /*6Fj*/void * reserved _ARG /*6Fj*/ObjectNotationType * onType, \
   return Instance_onGetString(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/tempString, /*7Al*/reserved, /*7Al*/(C(ObjectNotationType) *)onType);); \
VIRTUAL_METHOD(onSaveEdit, onSaveEdit, c, Instance, \
   bool, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/Instance & window _ARG /*6Fj*/void * object, \
   return (bool)Instance_onSaveEdit(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/window.impl, /*7Al*/object);); \
VIRTUAL_METHOD(onSerialize, onSerialize, c, Instance, \
   void, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/IOChannel & channel, \
   Instance_onSerialize(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/channel.impl);); \
VIRTUAL_METHOD(onUnserialize, onUnserialize, c, Instance, \
   void, c & _ARG, /*6Bk*/c & o_ _ARG, /*6Fj*/IOChannel & channel, \
   Instance_onUnserialize(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/channel.impl););

class Instance
{
public:
   // hardcoded content start
   static TCPPClass<Instance> _cpp_class;
   C(Instance) impl;
   void (**vTbl)(void);
   bool mustFree = 0;

   void * operator new   (uintsize count) { return eC_new(count); }
   void * operator new [](uintsize count) { return eC_new(count); }
   void operator delete   (void * ptr) { eC_delete(ptr); }
   void operator delete [](void * ptr) { eC_delete(ptr); }

   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         Instance * inst = new Instance(i, _cpp_class);
         if(inst)
            inst->mustFree = true;
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      Instance * inst = (Instance *)INSTANCEL(i, _cpp_class.impl);
      if(inst && inst->mustFree)
         delete inst;
   }
   static void class_registration(CPPClass & _class);

   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   explicit inline Instance(C(Instance) _impl, CPPClass & cl = _cpp_class)
   {
      XClass * c = cl.impl;
      impl = _impl;
      vTbl = cl.vTbl;
      if(impl)
      {
         if(c && BINDINGS_CLASS(impl) && !INSTANCEL(impl, c))
            INSTANCEL(impl, c) = this;
         impl->_refCount++;
      }
   }
   inline Instance()
   {
      impl = null;
      vTbl = null;
   }
   inline ~Instance()
   {
#ifdef _DEBUG
      bool isApp = false;
#endif
      if(impl && impl->_class)
      {
#ifdef _DEBUG
         isApp = Class_isDerived(impl->_class, eC_findClass(__thisModule, "Application"));
#endif
         int refCount = impl->_refCount;
         if(impl->_class->bindingsClass)
         {
            Instance ** i = (Instance **)&INSTANCEL(impl, impl->_class);
            if(i && *i == this && vTbl)
            {
               CPPClass * cl = (CPPClass *)impl->_class->bindingsClass;
               if(cl && vTbl != cl->vTbl)
                  eC_delete(vTbl);
            }
         }
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** i = (Instance **)&INSTANCEL(impl, impl->_class);
            if(i && *i == this)
               *i = null;
         }
#ifdef _DEBUG
         if(isApp)
         {
            // printf("Is app\n");
            // F(checkMemory)();
         }
#endif
      }
   }
   Instance(const Instance & i) = delete;
   Instance operator= (const Instance & i) = delete;

   inline Instance(Instance && i)
   {
      impl = i.impl;
      vTbl = i.vTbl;
      i.impl = null;
      i.vTbl = null;
   }

   inline Instance & operator= (Instance && i)
   {
      impl = i.impl;
      vTbl = i.vTbl;
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   // end of hardcoded content
};

template <class TC, C(Class) ** TCO>
class TNHInstance
{
public:
   void * operator new   (uintsize count) { return eC_new(count); }
   void * operator new [](uintsize count) { return eC_new(count); }
   void operator delete   (void * ptr) { eC_delete(ptr); }
   void operator delete [](void * ptr) { eC_delete(ptr); }
   struct NHInstance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      inline int operator()( /*6Bj*/Instance & object);
   } onCompare;

   struct NHInstance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      inline void operator()( /*6Bj*/Instance & newData);
   } onCopy;

   struct NHInstance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      inline void operator()( /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;

   struct NHInstance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      inline Instance & operator()( /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;

   struct NHInstance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      inline void operator()( );
   } onFree;

   struct NHInstance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      inline bool operator()( /*6Fj*/const char * string);
   } onGetDataFromString;

   struct NHInstance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      inline const char * operator()( /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;

   struct NHInstance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      inline bool operator()( /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;

   struct NHInstance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      inline void operator()( /*6Fj*/IOChannel & channel);
   } onSerialize;

   struct NHInstance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      inline void operator()( /*6Fj*/IOChannel & channel);
   } onUnserialize;

   TC * impl;
   TNHInstance() { impl = (TC*)Instance_new(*TCO); }
   TNHInstance(TC * _impl) { impl = _impl; }
   ~TNHInstance()
   {
      eC_delete(impl);
   }
};

template<typename TTT> inline typename std::enable_if<std::is_base_of<Instance, TTT>::value, uint64>::type
  toTA(TTT & x) { C(DataValue) p = { }; p.p = x.impl; return p.ui64; }

template<typename TTT> inline typename std::enable_if<std::is_base_of<Instance, TTT>::value, uint64>::type
  toTA(TTT * x) { C(DataValue) p = { }; p.p = x ? x->impl : null; return p.ui64; }

template<typename TTT> inline typename std::enable_if<std::is_base_of<Struct, TTT>::value, uint64>::type
  toTA(TTT x) { C(DataValue) p = { }; p.p = (void *)&x; return p.ui64; }

template<typename TTT> inline typename std::enable_if<!std::is_base_of<Instance, TTT>::value && !std::is_base_of<Struct, TTT>::value, uint64>::type
  toTA(TTT x) { C(DataValue) p = { }; p.p = (void *)x; return p.ui64; }

template<> inline uint64 toTA(double x) { C(DataValue) p = { }; p.d = x; return p.ui64; }
template<> inline uint64 toTA(float x)  { C(DataValue) p = { }; p.f = x; return p.ui64; }
template<> inline uint64 toTA(int x)    { C(DataValue) p = { }; p.i = x; return p.ui64; }

template<typename TTT> inline typename
   std::enable_if<std::is_pointer<TTT>::value &&
      std::is_base_of<Instance, typename std::remove_pointer<TTT>::type>::value, TTT>::type
   fromTA(uint64 x)
   {
      C(DataValue) p = { };
      p.ui64 = x;
      C(Instance) i = (C(Instance))p.p;
      return BINDINGS_CLASS(i) ? (TTT)INSTANCEL(i, i->_class) : (TTT)0;
   }

template<typename TTT> inline typename std::enable_if<!std::is_pointer<TTT>::value &&
      std::is_base_of<Instance, TTT>::value, TTT>::type
   fromTA(uint64 x)
   {
      C(DataValue) p = { };
      p.ui64 = x;
      return TTT((C(Instance))p.p);
   }

template<typename TTT> inline typename std::enable_if<!std::is_pointer<TTT>::value &&
      std::is_base_of<Struct, TTT>::value, TTT>::type
   fromTA(uint64 x)
   {
      C(DataValue) p = { };
      p.ui64 = x;
      return *(TTT *)p.p;
   }

template<typename TTT> inline typename std::enable_if<std::is_pointer<TTT>::value &&
      std::is_base_of<Struct, typename std::remove_pointer<TTT>::type>::value, TTT>::type
   fromTA(uint64 x)
   {
      C(DataValue) p = { };
      p.ui64 = x;
      return (TTT *)p.p;
   }

template<typename TTT> inline
   typename std::enable_if<
      !std::is_base_of<Instance, typename std::remove_pointer<TTT>::type>::value &&
      !std::is_base_of<Struct,   typename std::remove_pointer<TTT>::type>::value,
      TTT>::type
   fromTA(uint64 x) { C(DataValue) p = { }; p.ui64 = x; return (TTT)p.p; }

template<> inline double fromTA<double>(uint64 x) { C(DataValue) p = { }; p.ui64 = x; return p.d; }
template<> inline float  fromTA<float>(uint64 x) { C(DataValue) p = { }; p.ui64 = x; return p.f; }
template<> inline int    fromTA<int>(uint64 x) { C(DataValue) p = { }; p.ui64 = x; return p.i; }


#define REG_Module_onLoad(m, c)   REGVMETHOD(Module, onLoad,   c::m, (/*1Ab*/Module & self), c, ())
#define REG_Module_onUnload(m, c) REGVMETHOD(Module, onUnload, c::m, (/*1Ab*/Module & self), c, ())

#define REG_Module(c) \
      Module::class_registration(_cpp_class); \
      REG_Module_onLoad(onLoad, c); \
      REG_Module_onUnload(onUnload, c);

#define MODULE_VIRTUAL_METHODS_PROTO(c) \
   VIRTUAL_METHOD_PROTO(onLoad, onLoad, c, Module, \
      bool, c &, , ); \
   VIRTUAL_METHOD_PROTO(onUnload, onUnload, c, Module, \
      void, c &, , );

#define MODULE_VIRTUAL_METHODS(c) \
VIRTUAL_METHOD(onLoad, onLoad, c, Module, \
   bool, c &, , , \
   return (bool)Module_onLoad(self ? self->impl : (C(Module))null);); \
VIRTUAL_METHOD(onUnload, onUnload, c, Module, \
   void, c &, , , \
   Module_onUnload(self ? self->impl : (C(Module))null););

class Module : public Instance
{
public:
   inline Module(Module && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline Module & operator= (Module && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   Module() : Module((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<Module> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         Module * inst = new Module(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      Module * inst = (Module *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(Module & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline Module(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl) { }

   struct Module_onLoad_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Module &);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( );
   } onLoad;
   // inline static void register_onLoad(CPPClass & cl, Module::Module_onLoad_Functor::FunctionType func)

   struct Module_onUnload_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Module &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( );
   } onUnload;
   // inline static void register_onUnload(CPPClass & cl, Module::Module_onUnload_Functor::FunctionType func)

};

#define REG_Application_main(m, c) REGVMETHOD(Application, main, c::m, (/*1Ab*/Application & self), c, ())

#define REG_Application(c) \
      Application::class_registration(_cpp_class); \
      REG_Module_onLoad(onLoad, c); \
      REG_Module_onUnload(onUnload, c); \
      REG_Application_main(main, c);

#define APPLICATION_VIRTUAL_METHODS_PROTO(c) \
   VIRTUAL_METHOD_PROTO(main, main, c, Application, \
      void, c &, , );

#define APPLICATION_VIRTUAL_METHODS(c) \
VIRTUAL_METHOD(main, main, c, Application, \
   void, c &, , , \
   Application_main(self ? self->impl : (C(Application))null););

int ecrt_cpp_init(const Module & module);

class Application : public Module
{
public:
   inline Application(Application && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline Application & operator= (Application && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   inline Application() : Application(ecrt_init_CALL(__LINK_ECERE__)) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<Application> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         Application * inst = new Application(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      Application * inst = (Application *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(Application & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline Application(C(Instance) _impl, CPPClass & cl = _cpp_class) : Module(_impl, cl)
   {
      ecrt_cpp_init(*this);
      INSTANCEL(impl, impl->_class) = this;
      incref(impl);
      vTbl = _cpp_class.vTbl;
      __thisModule = impl;
   }
   ~Application()
   {
      Instance_decRef(impl);
   }

   struct Application_main_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Application &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( );
   } main;
   // inline static void register_main(CPPClass & cl, Application::Application_main_Functor::FunctionType func)

   static void class_registration(CPPClass & _cpp_class);

   inline Application(int argc, const char ** argv, int exitCode, bool isGUIApp, OldList allModules, char * parsedCommand, NameSpace systemNameSpace);

   struct argc_Prop
   {
      constexpr argc_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Application::argc_Prop & operator= (Application::argc_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } argc;
   struct argv_Prop
   {
      constexpr argv_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char ** operator= (/*0H*/const char ** v);
      /*regSet*/inline Application::argv_Prop & operator= (Application::argv_Prop & prop);
      /*regGet*/inline operator /*0I*/const char ** () const;
   } argv;
   struct exitCode_Prop
   {
      constexpr exitCode_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Application::exitCode_Prop & operator= (Application::exitCode_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } exitCode;
   struct isGUIApp_Prop
   {
      constexpr isGUIApp_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline Application::isGUIApp_Prop & operator= (Application::isGUIApp_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isGUIApp;
   struct allModules_Prop
   {
      constexpr allModules_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldList operator= (/*0H*/OldList v);
      /*regSet*/inline Application::allModules_Prop & operator= (Application::allModules_Prop & prop);
      /*regGet*/inline operator /*0I*/OldList () const;
   } allModules;
   struct parsedCommand_Prop
   {
      constexpr parsedCommand_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/char * operator= (/*0H*/char * v);
      /*regSet*/inline Application::parsedCommand_Prop & operator= (Application::parsedCommand_Prop & prop);
      /*regGet*/inline operator /*0I*/char * () const;
   } parsedCommand;
   struct systemNameSpace_Prop
   {
      constexpr systemNameSpace_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/NameSpace operator= (/*0H*/NameSpace v);
      /*regSet*/inline Application::systemNameSpace_Prop & operator= (Application::systemNameSpace_Prop & prop);
      /*regGet*/inline operator /*0I*/NameSpace () const;
   } systemNameSpace;
};

enum class FieldType : int
{
   integer = FieldType_integer,
   real = FieldType_real,
   text = FieldType_text,
   blob = FieldType_blob,
   nil = FieldType_nil,
   array = FieldType_array,
   map = FieldType_map
};

class FieldTypeEx
{
public:
   C(FieldTypeEx) impl;
   constexpr FieldTypeEx() : impl(0) { }
   constexpr FieldTypeEx(C(FieldTypeEx) impl) : impl(impl) { }
   FieldTypeEx(FieldType type, bool mustFree, FieldValueFormat format, bool isUnsigned, bool isDateTime);
   operator C(FieldTypeEx)() { return impl; }
   FieldTypeEx & operator =(C(FieldTypeEx) impl) { impl = impl; return *this; }
   bool operator ==(const FieldTypeEx & value) const { return impl == value.impl; }
   bool operator !=(const FieldTypeEx & value) const { return impl != value.impl; }

   struct type_Prop
   {
      constexpr type_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/FieldType operator= (/*0H*/FieldType v);
      /*regSet*/inline FieldTypeEx::type_Prop & operator= (FieldTypeEx::type_Prop & prop);
      /*regGet*/inline operator /*0I*/FieldType () const;
   } type;
   struct mustFree_Prop
   {
      constexpr mustFree_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FieldTypeEx::mustFree_Prop & operator= (FieldTypeEx::mustFree_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } mustFree;
   struct format_Prop
   {
      constexpr format_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/FieldValueFormat operator= (/*0H*/FieldValueFormat v);
      /*regSet*/inline FieldTypeEx::format_Prop & operator= (FieldTypeEx::format_Prop & prop);
      /*regGet*/inline operator /*0I*/FieldValueFormat () const;
   } format;
   struct isUnsigned_Prop
   {
      constexpr isUnsigned_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FieldTypeEx::isUnsigned_Prop & operator= (FieldTypeEx::isUnsigned_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isUnsigned;
   struct isDateTime_Prop
   {
      constexpr isDateTime_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FieldTypeEx::isDateTime_Prop & operator= (FieldTypeEx::isDateTime_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isDateTime;
};

struct FieldValue : public TStruct<FieldValue>
{
public:
   C(FieldValue) impl;
   constexpr FieldValue() : impl({}) { }
   constexpr FieldValue(const C(FieldValue) impl) : impl(impl) { }

   inline int compareInt(/*1Ab*/FieldValue & other); // FieldValue_compareInt
   inline int compareInt(/*1Ac*/FieldValue * other); // FieldValue_compareInt
   inline int compareReal(/*1Ab*/FieldValue & other); // FieldValue_compareReal
   inline int compareReal(/*1Ac*/FieldValue * other); // FieldValue_compareReal
   inline int compareText(/*1Ab*/FieldValue & other); // FieldValue_compareText
   inline int compareText(/*1Ac*/FieldValue * other); // FieldValue_compareText
   inline C(String) formatArray(/*1Ab*/char * tempString, /*1Ab*/void * fieldData, /*1Ab*/ObjectNotationType * onType); // FieldValue_formatArray
   inline C(String) formatFloat(/*1Ab*/char * stringOutput, /*1Ab*/bool fixDot); // FieldValue_formatFloat
   inline C(String) formatInteger(/*1Ab*/char * stringOutput); // FieldValue_formatInteger
   inline C(String) formatMap(/*1Ab*/char * tempString, /*1Ab*/void * fieldData, /*1Ab*/ObjectNotationType * onType); // FieldValue_formatMap
   static inline C(bool) getArrayOrMap(/*1Ab*/const char * string, /*1Ab*/Class destClass, /*1Ab*/void ** destination); // FieldValue_getArrayOrMap
   inline C(String) stringify(); // FieldValue_stringify

   inline FieldValue(FieldTypeEx type, int64 i, double r, char * s, void * b);

   struct type_Prop
   {
      constexpr type_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/FieldTypeEx operator= (/*0H*/FieldTypeEx v);
      /*regSet*/inline FieldValue::type_Prop & operator= (FieldValue::type_Prop & prop);
      /*regGet*/inline operator /*0I*/FieldTypeEx () const;
   } type;
   struct i_Prop
   {
      constexpr i_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int64 operator= (/*0H*/int64 v);
      /*regSet*/inline FieldValue::i_Prop & operator= (FieldValue::i_Prop & prop);
      /*regGet*/inline operator /*0I*/int64 () const;
   } i;
   struct r_Prop
   {
      constexpr r_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/double operator= (/*0H*/double v);
      /*regSet*/inline FieldValue::r_Prop & operator= (FieldValue::r_Prop & prop);
      /*regGet*/inline operator /*0I*/double () const;
   } r;
   struct s_Prop
   {
      constexpr s_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/char * operator= (/*0H*/char * v);
      /*regSet*/inline FieldValue::s_Prop & operator= (FieldValue::s_Prop & prop);
      /*regGet*/inline operator /*0I*/char * () const;
   } s;
   struct b_Prop
   {
      constexpr b_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline FieldValue::b_Prop & operator= (FieldValue::b_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } b;
   struct a_Prop
   {
      constexpr a_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/TArray<FieldValue _ARG int _ARG FieldValue> operator= (/*0H*/TArray<FieldValue _ARG int _ARG FieldValue> v);
      /*regSet*/inline FieldValue::a_Prop & operator= (FieldValue::a_Prop & prop);
      /*regGet*/inline operator /*0I*/TArray<FieldValue _ARG int _ARG FieldValue> () const;
   } a;
   struct m_Prop
   {
      constexpr m_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/TMap<C(String) _ARG FieldValue> operator= (/*0H*/TMap<C(String) _ARG FieldValue> v);
      /*regSet*/inline FieldValue::m_Prop & operator= (FieldValue::m_Prop & prop);
      /*regGet*/inline operator /*0I*/TMap<C(String) _ARG FieldValue> () const;
   } m;
};

enum class FieldValueFormat : int
{
   decimal = FieldValueFormat_decimal,
   unset = FieldValueFormat_unset,
   hex = FieldValueFormat_hex,
   octal = FieldValueFormat_octal,
   binary = FieldValueFormat_binary,
   exponential = FieldValueFormat_exponential,
   boolean = FieldValueFormat_boolean,
   textObj = FieldValueFormat_textObj,
   color = FieldValueFormat_color
};

class Angle
{
public:
   C(Angle) impl;
   constexpr Angle() : impl(0) { }
   constexpr Angle(C(Angle) value) : impl(value) { }
   operator C(Angle)() const { return impl; }
   constexpr Angle(const Angle & value) : impl(value.impl) { }
   Angle & operator =(double value) { impl = value; return *this; }
   Angle & operator +=(Angle value) { impl += value.impl; return *this; }
   Angle & operator -=(Angle value) { impl -= value.impl; return *this; }
   Angle operator +(const Angle & b) const { return Angle(impl + b.impl); }
   Angle operator -(const Angle & b) const { return Angle(impl - b.impl); }
   bool operator ==(const Angle & value) const { return impl == value.impl; }
   bool operator !=(const Angle & value) const { return impl != value.impl; }
   bool operator <(const Angle & value) const { return impl < value.impl; }
   bool operator >(const Angle & value) const { return impl > value.impl; }
   bool operator <=(const Angle & value) const { return impl <= value.impl; }
   bool operator >=(const Angle & value) const { return impl >= value.impl; }
   bool operator ==(double value) const { return impl == Angle(value).impl; }
   bool operator !=(double value) const { return impl != Angle(value).impl; }
   bool operator <(double value) const { return impl < Angle(value).impl; }
   bool operator >(double value) const { return impl > Angle(value).impl; }
   bool operator <=(double value) const { return impl <= Angle(value).impl; }
   bool operator >=(double value) const { return impl >= Angle(value).impl; }
   bool operator ==(int value) const { return impl == Angle(value).impl; }
   bool operator !=(int value) const { return impl != Angle(value).impl; }
   bool operator <(int value) const { return impl < Angle(value).impl; }
   bool operator >(int value) const { return impl > Angle(value).impl; }
   bool operator <=(int value) const { return impl <= Angle(value).impl; }
   bool operator >=(int value) const { return impl >= Angle(value).impl; }
};

class Distance
{
public:
   C(Distance) impl;
   constexpr Distance() : impl(0) { }
   constexpr Distance(C(Distance) value) : impl(value) { }
   operator C(Distance)() const { return impl; }
   constexpr Distance(const Distance & value) : impl(value.impl) { }
   Distance & operator =(double value) { impl = value; return *this; }
   Distance & operator +=(Distance value) { impl += value.impl; return *this; }
   Distance & operator -=(Distance value) { impl -= value.impl; return *this; }
   Distance operator +(const Distance & b) const { return Distance(impl + b.impl); }
   Distance operator -(const Distance & b) const { return Distance(impl - b.impl); }
   bool operator ==(const Distance & value) const { return impl == value.impl; }
   bool operator !=(const Distance & value) const { return impl != value.impl; }
   bool operator <(const Distance & value) const { return impl < value.impl; }
   bool operator >(const Distance & value) const { return impl > value.impl; }
   bool operator <=(const Distance & value) const { return impl <= value.impl; }
   bool operator >=(const Distance & value) const { return impl >= value.impl; }
   bool operator ==(double value) const { return impl == Distance(value).impl; }
   bool operator !=(double value) const { return impl != Distance(value).impl; }
   bool operator <(double value) const { return impl < Distance(value).impl; }
   bool operator >(double value) const { return impl > Distance(value).impl; }
   bool operator <=(double value) const { return impl <= Distance(value).impl; }
   bool operator >=(double value) const { return impl >= Distance(value).impl; }
   bool operator ==(int value) const { return impl == Distance(value).impl; }
   bool operator !=(int value) const { return impl != Distance(value).impl; }
   bool operator <(int value) const { return impl < Distance(value).impl; }
   bool operator >(int value) const { return impl > Distance(value).impl; }
   bool operator <=(int value) const { return impl <= Distance(value).impl; }
   bool operator >=(int value) const { return impl >= Distance(value).impl; }
};

#define REG_IOChannel_readData(m, c)  REGVMETHOD(IOChannel, readData,  c::m, (/*1Ab*/IOChannel & self, /*1Ab*/void * data, /*1Ab*/uintsize numBytes),       c, (/*4Im*/data, /*4Im*/numBytes))
#define REG_IOChannel_writeData(m, c) REGVMETHOD(IOChannel, writeData, c::m, (/*1Ab*/IOChannel & self, /*1Ab*/const void * data, /*1Ab*/uintsize numBytes), c, (/*4Im*/data, /*4Im*/numBytes))

#define REG_IOChannel(c) \
      IOChannel::class_registration(_cpp_class); \
      REG_IOChannel_readData(readData, c); \
      REG_IOChannel_writeData(writeData, c);

#define IOCHANNEL_VIRTUAL_METHODS_PROTO(c) \
   VIRTUAL_METHOD_PROTO(readData, readData, c, IOChannel, \
      uintsize, c & _ARG, , /*6Fj*/void * data _ARG /*6Fj*/uintsize numBytes); \
   VIRTUAL_METHOD_PROTO(writeData, writeData, c, IOChannel, \
      uintsize, c & _ARG, , /*6Fj*/const void * data _ARG /*6Fj*/uintsize numBytes);

#define IOCHANNEL_VIRTUAL_METHODS(c) \
VIRTUAL_METHOD(readData, readData, c, IOChannel, \
   uintsize, c & _ARG, , /*6Fj*/void * data _ARG /*6Fj*/uintsize numBytes, \
   return IOChannel_readData(self ? self->impl : (C(IOChannel))null, /*7Al*/data, /*7Al*/numBytes);); \
VIRTUAL_METHOD(writeData, writeData, c, IOChannel, \
   uintsize, c & _ARG, , /*6Fj*/const void * data _ARG /*6Fj*/uintsize numBytes, \
   return IOChannel_writeData(self ? self->impl : (C(IOChannel))null, /*7Al*/data, /*7Al*/numBytes););

class IOChannel : public Instance
{
public:
   inline IOChannel(IOChannel && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline IOChannel & operator= (IOChannel && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   IOChannel() : IOChannel((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<IOChannel> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         IOChannel * inst = new IOChannel(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      IOChannel * inst = (IOChannel *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(IOChannel & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline IOChannel(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl) { }

   inline void get(/*1Bb*/typed_object_class_ptr class_data, void * data); // IOChannel_get
   inline void put(/*1Bb*/typed_object_class_ptr class_data, void * data); // IOChannel_put
   inline void serialize(/*1Bb*/typed_object_class_ptr class_data, void * data); // IOChannel_serialize
   inline void unserialize(/*1Bb*/typed_object_class_ptr class_data, void * data); // IOChannel_unserialize

   struct IOChannel_readData_Functor
   {
      [[no_unique_address]] int _[0];
      typedef uintsize (* FunctionType)(IOChannel & , /*6Fj*/void * data, /*6Fj*/uintsize numBytes);
      inline FunctionType operator= (FunctionType func);
      inline uintsize operator()( /*6Fj*/void * data, /*6Fj*/uintsize numBytes);
   } readData;
   // inline static void register_readData(CPPClass & cl, IOChannel::IOChannel_readData_Functor::FunctionType func)

   struct IOChannel_writeData_Functor
   {
      [[no_unique_address]] int _[0];
      typedef uintsize (* FunctionType)(IOChannel & , /*6Fj*/const void * data, /*6Fj*/uintsize numBytes);
      inline FunctionType operator= (FunctionType func);
      inline uintsize operator()( /*6Fj*/const void * data, /*6Fj*/uintsize numBytes);
   } writeData;
   // inline static void register_writeData(CPPClass & cl, IOChannel::IOChannel_writeData_Functor::FunctionType func)

   static void class_registration(CPPClass & _cpp_class);
};

enum class Access_Mode : int
{
   defaultAccess = AccessMode_defaultAccess,
   publicAccess = AccessMode_publicAccess,
   privateAccess = AccessMode_privateAccess,
   staticAccess = AccessMode_staticAccess,
   baseSystemAccess = AccessMode_baseSystemAccess
};

template <class TC, C(Class) ** TCO>
class TBTNamedLink : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TBTNamedLink<TC, TCO>::name_Prop & operator= (typename TBTNamedLink<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct parent_Prop
   {
      constexpr parent_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BTNamedLink operator= (/*0H*/BTNamedLink & v);
      /*regSet*/inline typename TBTNamedLink<TC, TCO>::parent_Prop & operator= (typename TBTNamedLink<TC, TCO>::parent_Prop & prop);
      /*regGet*/inline operator /*0I*/BTNamedLink () const;
   } parent;
   struct left_Prop
   {
      constexpr left_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BTNamedLink operator= (/*0H*/BTNamedLink & v);
      /*regSet*/inline typename TBTNamedLink<TC, TCO>::left_Prop & operator= (typename TBTNamedLink<TC, TCO>::left_Prop & prop);
      /*regGet*/inline operator /*0I*/BTNamedLink () const;
   } left;
   struct right_Prop
   {
      constexpr right_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BTNamedLink operator= (/*0H*/BTNamedLink & v);
      /*regSet*/inline typename TBTNamedLink<TC, TCO>::right_Prop & operator= (typename TBTNamedLink<TC, TCO>::right_Prop & prop);
      /*regGet*/inline operator /*0I*/BTNamedLink () const;
   } right;
   struct depth_Prop
   {
      constexpr depth_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TBTNamedLink<TC, TCO>::depth_Prop & operator= (typename TBTNamedLink<TC, TCO>::depth_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } depth;
   struct data_Prop
   {
      constexpr data_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TBTNamedLink<TC, TCO>::data_Prop & operator= (typename TBTNamedLink<TC, TCO>::data_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } data;
   ~TBTNamedLink()
   {
      this->impl = null; // How to know not to delete?
   }
};

template <class TC, C(Class) ** TCO>
class TBitMember : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BitMember operator= (/*0H*/BitMember & v);
      /*regSet*/inline typename TBitMember<TC, TCO>::prev_Prop & operator= (typename TBitMember<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/BitMember () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BitMember operator= (/*0H*/BitMember & v);
      /*regSet*/inline typename TBitMember<TC, TCO>::next_Prop & operator= (typename TBitMember<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/BitMember () const;
   } next;
   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TBitMember<TC, TCO>::name_Prop & operator= (typename TBitMember<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct isProperty_Prop
   {
      constexpr isProperty_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TBitMember<TC, TCO>::isProperty_Prop & operator= (typename TBitMember<TC, TCO>::isProperty_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isProperty;
   struct memberAccess_Prop
   {
      constexpr memberAccess_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Access_Mode operator= (/*0H*/Access_Mode v);
      /*regSet*/inline typename TBitMember<TC, TCO>::memberAccess_Prop & operator= (typename TBitMember<TC, TCO>::memberAccess_Prop & prop);
      /*regGet*/inline operator /*0I*/Access_Mode () const;
   } memberAccess;
   struct id_Prop
   {
      constexpr id_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TBitMember<TC, TCO>::id_Prop & operator= (typename TBitMember<TC, TCO>::id_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } id;
   struct _class_Prop
   {
      constexpr _class_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline typename TBitMember<TC, TCO>::_class_Prop & operator= (typename TBitMember<TC, TCO>::_class_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } _class;
   struct dataTypeString_Prop
   {
      constexpr dataTypeString_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TBitMember<TC, TCO>::dataTypeString_Prop & operator= (typename TBitMember<TC, TCO>::dataTypeString_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } dataTypeString;
   struct dataTypeClass_Prop
   {
      constexpr dataTypeClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline typename TBitMember<TC, TCO>::dataTypeClass_Prop & operator= (typename TBitMember<TC, TCO>::dataTypeClass_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } dataTypeClass;
   struct type_Prop
   {
      constexpr type_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/DataMemberType operator= (/*0H*/DataMemberType v);
      /*regSet*/inline typename TBitMember<TC, TCO>::type_Prop & operator= (typename TBitMember<TC, TCO>::type_Prop & prop);
      /*regGet*/inline operator /*0I*/DataMemberType () const;
   } type;
   struct size_Prop
   {
      constexpr size_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TBitMember<TC, TCO>::size_Prop & operator= (typename TBitMember<TC, TCO>::size_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } size;
   struct pos_Prop
   {
      constexpr pos_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TBitMember<TC, TCO>::pos_Prop & operator= (typename TBitMember<TC, TCO>::pos_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } pos;
   struct mask_Prop
   {
      constexpr mask_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint64 operator= (/*0H*/uint64 v);
      /*regSet*/inline typename TBitMember<TC, TCO>::mask_Prop & operator= (typename TBitMember<TC, TCO>::mask_Prop & prop);
      /*regGet*/inline operator /*0I*/uint64 () const;
   } mask;
   ~TBitMember()
   {
      this->impl = null; // How to know not to delete?
   }
};

struct Box : public TStruct<Box>
{
public:
   C(Box) impl;
   constexpr Box() : impl({}) { }
   constexpr Box(const C(Box) impl) : impl(impl) { }

   inline void clip(/*1Ab*/Box & against); // Box_clip
   inline void clip(/*1Ac*/Box * against); // Box_clip
   inline void clipOffset(/*1Ab*/Box & against, /*1Ab*/int x, /*1Ab*/int y); // Box_clipOffset
   inline void clipOffset(/*1Ac*/Box * against, /*1Ac*/int x, /*1Ac*/int y); // Box_clipOffset
   inline C(bool) isPointInside(/*1Ab*/Point & point); // Box_isPointInside
   inline C(bool) isPointInside(/*1Ac*/Point * point); // Box_isPointInside
   inline C(bool) overlap(/*1Ab*/Box & box); // Box_overlap
   inline C(bool) overlap(/*1Ac*/Box * box); // Box_overlap

   inline Box(int left, int top, int right, int bottom);

   struct width_Prop
   {
      constexpr width_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Box::width_Prop & operator= (Box::width_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } width;
   struct height_Prop
   {
      constexpr height_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Box::height_Prop & operator= (Box::height_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } height;

   struct left_Prop
   {
      constexpr left_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Box::left_Prop & operator= (Box::left_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } left;
   struct top_Prop
   {
      constexpr top_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Box::top_Prop & operator= (Box::top_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } top;
   struct right_Prop
   {
      constexpr right_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Box::right_Prop & operator= (Box::right_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } right;
   struct bottom_Prop
   {
      constexpr bottom_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Box::bottom_Prop & operator= (Box::bottom_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } bottom;
};

class Centimeters : public Distance
{
public:
   constexpr Centimeters() : Distance() { }
   constexpr Centimeters(const Distance value) : Distance(value) { }
   constexpr Centimeters(double value) : Distance(CENTIMETERS(value)) { }
   constexpr operator double() const { return Distance_in_Centimeters(impl); }
   constexpr Centimeters & operator =(double value) { impl = CENTIMETERS(value); return *this; }
   bool operator ==(const Centimeters & value) const { return impl == value.impl; }
   bool operator !=(const Centimeters & value) const { return impl != value.impl; }
   bool operator <(const Centimeters & value) const { return impl < value.impl; }
   bool operator >(const Centimeters & value) const { return impl > value.impl; }
   bool operator <=(const Centimeters & value) const { return impl <= value.impl; }
   bool operator >=(const Centimeters & value) const { return impl >= value.impl; }
   bool operator ==(double value) const { return impl == Centimeters(value).impl; }
   bool operator !=(double value) const { return impl != Centimeters(value).impl; }
   bool operator <(double value) const { return impl < Centimeters(value).impl; }
   bool operator >(double value) const { return impl > Centimeters(value).impl; }
   bool operator <=(double value) const { return impl <= Centimeters(value).impl; }
   bool operator >=(double value) const { return impl >= Centimeters(value).impl; }
   bool operator ==(int value) const { return impl == Centimeters(value).impl; }
   bool operator !=(int value) const { return impl != Centimeters(value).impl; }
   bool operator <(int value) const { return impl < Centimeters(value).impl; }
   bool operator >(int value) const { return impl > Centimeters(value).impl; }
   bool operator <=(int value) const { return impl <= Centimeters(value).impl; }
   bool operator >=(int value) const { return impl >= Centimeters(value).impl; }
   inline constexpr operator Meters() const;
   inline constexpr Centimeters(const Meters & m);
   inline constexpr Centimeters & operator =(const Meters & m);
};

template <class TC, C(Class) ** TCO>
class TClass : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline typename TClass<TC, TCO>::prev_Prop & operator= (typename TClass<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline typename TClass<TC, TCO>::next_Prop & operator= (typename TClass<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } next;
   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TClass<TC, TCO>::name_Prop & operator= (typename TClass<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct offset_Prop
   {
      constexpr offset_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::offset_Prop & operator= (typename TClass<TC, TCO>::offset_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } offset;
   struct structSize_Prop
   {
      constexpr structSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::structSize_Prop & operator= (typename TClass<TC, TCO>::structSize_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } structSize;
   struct _vTbl_Prop
   {
      constexpr _vTbl_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void ** operator= (/*0H*/void ** v);
      /*regSet*/inline typename TClass<TC, TCO>::_vTbl_Prop & operator= (typename TClass<TC, TCO>::_vTbl_Prop & prop);
      /*regGet*/inline operator /*0I*/void ** () const;
   } _vTbl;
   struct vTblSize_Prop
   {
      constexpr vTblSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::vTblSize_Prop & operator= (typename TClass<TC, TCO>::vTblSize_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } vTblSize;
   struct offsetClass_Prop
   {
      constexpr offsetClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::offsetClass_Prop & operator= (typename TClass<TC, TCO>::offsetClass_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } offsetClass;
   struct sizeClass_Prop
   {
      constexpr sizeClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::sizeClass_Prop & operator= (typename TClass<TC, TCO>::sizeClass_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } sizeClass;
   struct base_Prop
   {
      constexpr base_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline typename TClass<TC, TCO>::base_Prop & operator= (typename TClass<TC, TCO>::base_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } base;
   struct methods_Prop
   {
      constexpr methods_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BinaryTree operator= (/*0H*/BinaryTree v);
      /*regSet*/inline typename TClass<TC, TCO>::methods_Prop & operator= (typename TClass<TC, TCO>::methods_Prop & prop);
      /*regGet*/inline operator /*0I*/BinaryTree () const;
   } methods;
   struct members_Prop
   {
      constexpr members_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BinaryTree operator= (/*0H*/BinaryTree v);
      /*regSet*/inline typename TClass<TC, TCO>::members_Prop & operator= (typename TClass<TC, TCO>::members_Prop & prop);
      /*regGet*/inline operator /*0I*/BinaryTree () const;
   } members;
   struct prop_Prop
   {
      constexpr prop_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BinaryTree operator= (/*0H*/BinaryTree v);
      /*regSet*/inline typename TClass<TC, TCO>::prop_Prop & operator= (typename TClass<TC, TCO>::prop_Prop & prop);
      /*regGet*/inline operator /*0I*/BinaryTree () const;
   } prop;
   struct membersAndProperties_Prop
   {
      constexpr membersAndProperties_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldList operator= (/*0H*/OldList v);
      /*regSet*/inline typename TClass<TC, TCO>::membersAndProperties_Prop & operator= (typename TClass<TC, TCO>::membersAndProperties_Prop & prop);
      /*regGet*/inline operator /*0I*/OldList () const;
   } membersAndProperties;
   struct classProperties_Prop
   {
      constexpr classProperties_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BinaryTree operator= (/*0H*/BinaryTree v);
      /*regSet*/inline typename TClass<TC, TCO>::classProperties_Prop & operator= (typename TClass<TC, TCO>::classProperties_Prop & prop);
      /*regGet*/inline operator /*0I*/BinaryTree () const;
   } classProperties;
   struct derivatives_Prop
   {
      constexpr derivatives_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldList operator= (/*0H*/OldList v);
      /*regSet*/inline typename TClass<TC, TCO>::derivatives_Prop & operator= (typename TClass<TC, TCO>::derivatives_Prop & prop);
      /*regGet*/inline operator /*0I*/OldList () const;
   } derivatives;
   struct memberID_Prop
   {
      constexpr memberID_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::memberID_Prop & operator= (typename TClass<TC, TCO>::memberID_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } memberID;
   struct startMemberID_Prop
   {
      constexpr startMemberID_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::startMemberID_Prop & operator= (typename TClass<TC, TCO>::startMemberID_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } startMemberID;
   struct type_Prop
   {
      constexpr type_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/ClassType operator= (/*0H*/ClassType v);
      /*regSet*/inline typename TClass<TC, TCO>::type_Prop & operator= (typename TClass<TC, TCO>::type_Prop & prop);
      /*regGet*/inline operator /*0I*/ClassType () const;
   } type;
   struct module_Prop
   {
      constexpr module_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Module operator= (/*0H*/Module v);
      /*regSet*/inline typename TClass<TC, TCO>::module_Prop & operator= (typename TClass<TC, TCO>::module_Prop & prop);
      /*regGet*/inline operator /*0I*/Module () const;
   } module;
   struct dataTypeString_Prop
   {
      constexpr dataTypeString_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TClass<TC, TCO>::dataTypeString_Prop & operator= (typename TClass<TC, TCO>::dataTypeString_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } dataTypeString;
   struct typeSize_Prop
   {
      constexpr typeSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::typeSize_Prop & operator= (typename TClass<TC, TCO>::typeSize_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } typeSize;
   struct defaultAlignment_Prop
   {
      constexpr defaultAlignment_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::defaultAlignment_Prop & operator= (typename TClass<TC, TCO>::defaultAlignment_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } defaultAlignment;
   struct memberOffset_Prop
   {
      constexpr memberOffset_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::memberOffset_Prop & operator= (typename TClass<TC, TCO>::memberOffset_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } memberOffset;
   struct selfWatchers_Prop
   {
      constexpr selfWatchers_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldList operator= (/*0H*/OldList v);
      /*regSet*/inline typename TClass<TC, TCO>::selfWatchers_Prop & operator= (typename TClass<TC, TCO>::selfWatchers_Prop & prop);
      /*regGet*/inline operator /*0I*/OldList () const;
   } selfWatchers;
   struct designerClass_Prop
   {
      constexpr designerClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TClass<TC, TCO>::designerClass_Prop & operator= (typename TClass<TC, TCO>::designerClass_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } designerClass;
   struct noExpansion_Prop
   {
      constexpr noExpansion_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TClass<TC, TCO>::noExpansion_Prop & operator= (typename TClass<TC, TCO>::noExpansion_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } noExpansion;
   struct defaultProperty_Prop
   {
      constexpr defaultProperty_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TClass<TC, TCO>::defaultProperty_Prop & operator= (typename TClass<TC, TCO>::defaultProperty_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } defaultProperty;
   struct comRedefinition_Prop
   {
      constexpr comRedefinition_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TClass<TC, TCO>::comRedefinition_Prop & operator= (typename TClass<TC, TCO>::comRedefinition_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } comRedefinition;
   struct count_Prop
   {
      constexpr count_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::count_Prop & operator= (typename TClass<TC, TCO>::count_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } count;
   struct isRemote_Prop
   {
      constexpr isRemote_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::isRemote_Prop & operator= (typename TClass<TC, TCO>::isRemote_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } isRemote;
   struct internalDecl_Prop
   {
      constexpr internalDecl_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TClass<TC, TCO>::internalDecl_Prop & operator= (typename TClass<TC, TCO>::internalDecl_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } internalDecl;
   struct data_Prop
   {
      constexpr data_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TClass<TC, TCO>::data_Prop & operator= (typename TClass<TC, TCO>::data_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } data;
   struct computeSize_Prop
   {
      constexpr computeSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TClass<TC, TCO>::computeSize_Prop & operator= (typename TClass<TC, TCO>::computeSize_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } computeSize;
   struct structAlignment_Prop
   {
      constexpr structAlignment_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/short operator= (/*0H*/short v);
      /*regSet*/inline typename TClass<TC, TCO>::structAlignment_Prop & operator= (typename TClass<TC, TCO>::structAlignment_Prop & prop);
      /*regGet*/inline operator /*0I*/short () const;
   } structAlignment;
   struct pointerAlignment_Prop
   {
      constexpr pointerAlignment_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/short operator= (/*0H*/short v);
      /*regSet*/inline typename TClass<TC, TCO>::pointerAlignment_Prop & operator= (typename TClass<TC, TCO>::pointerAlignment_Prop & prop);
      /*regGet*/inline operator /*0I*/short () const;
   } pointerAlignment;
   struct destructionWatchOffset_Prop
   {
      constexpr destructionWatchOffset_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::destructionWatchOffset_Prop & operator= (typename TClass<TC, TCO>::destructionWatchOffset_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } destructionWatchOffset;
   struct fixed_Prop
   {
      constexpr fixed_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TClass<TC, TCO>::fixed_Prop & operator= (typename TClass<TC, TCO>::fixed_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } fixed;
   struct delayedCPValues_Prop
   {
      constexpr delayedCPValues_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldList operator= (/*0H*/OldList v);
      /*regSet*/inline typename TClass<TC, TCO>::delayedCPValues_Prop & operator= (typename TClass<TC, TCO>::delayedCPValues_Prop & prop);
      /*regGet*/inline operator /*0I*/OldList () const;
   } delayedCPValues;
   struct inheritanceAccess_Prop
   {
      constexpr inheritanceAccess_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Access_Mode operator= (/*0H*/Access_Mode v);
      /*regSet*/inline typename TClass<TC, TCO>::inheritanceAccess_Prop & operator= (typename TClass<TC, TCO>::inheritanceAccess_Prop & prop);
      /*regGet*/inline operator /*0I*/Access_Mode () const;
   } inheritanceAccess;
   struct fullName_Prop
   {
      constexpr fullName_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TClass<TC, TCO>::fullName_Prop & operator= (typename TClass<TC, TCO>::fullName_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } fullName;
   struct symbol_Prop
   {
      constexpr symbol_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TClass<TC, TCO>::symbol_Prop & operator= (typename TClass<TC, TCO>::symbol_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } symbol;
   struct conversions_Prop
   {
      constexpr conversions_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldList operator= (/*0H*/OldList v);
      /*regSet*/inline typename TClass<TC, TCO>::conversions_Prop & operator= (typename TClass<TC, TCO>::conversions_Prop & prop);
      /*regGet*/inline operator /*0I*/OldList () const;
   } conversions;
   struct templateParams_Prop
   {
      constexpr templateParams_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldList operator= (/*0H*/OldList v);
      /*regSet*/inline typename TClass<TC, TCO>::templateParams_Prop & operator= (typename TClass<TC, TCO>::templateParams_Prop & prop);
      /*regGet*/inline operator /*0I*/OldList () const;
   } templateParams;
   struct templateClass_Prop
   {
      constexpr templateClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline typename TClass<TC, TCO>::templateClass_Prop & operator= (typename TClass<TC, TCO>::templateClass_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } templateClass;
   struct templatized_Prop
   {
      constexpr templatized_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldList operator= (/*0H*/OldList v);
      /*regSet*/inline typename TClass<TC, TCO>::templatized_Prop & operator= (typename TClass<TC, TCO>::templatized_Prop & prop);
      /*regGet*/inline operator /*0I*/OldList () const;
   } templatized;
   struct numParams_Prop
   {
      constexpr numParams_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClass<TC, TCO>::numParams_Prop & operator= (typename TClass<TC, TCO>::numParams_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } numParams;
   struct isInstanceClass_Prop
   {
      constexpr isInstanceClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TClass<TC, TCO>::isInstanceClass_Prop & operator= (typename TClass<TC, TCO>::isInstanceClass_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isInstanceClass;
   struct byValueSystemClass_Prop
   {
      constexpr byValueSystemClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TClass<TC, TCO>::byValueSystemClass_Prop & operator= (typename TClass<TC, TCO>::byValueSystemClass_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } byValueSystemClass;
   struct bindingsClass_Prop
   {
      constexpr bindingsClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TClass<TC, TCO>::bindingsClass_Prop & operator= (typename TClass<TC, TCO>::bindingsClass_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } bindingsClass;
   ~TClass()
   {
      this->impl = null; // How to know not to delete?
   }
};

template <class TC, C(Class) ** TCO>
class TClassProperty : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TClassProperty<TC, TCO>::name_Prop & operator= (typename TClassProperty<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct parent_Prop
   {
      constexpr parent_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/ClassProperty operator= (/*0H*/ClassProperty & v);
      /*regSet*/inline typename TClassProperty<TC, TCO>::parent_Prop & operator= (typename TClassProperty<TC, TCO>::parent_Prop & prop);
      /*regGet*/inline operator /*0I*/ClassProperty () const;
   } parent;
   struct left_Prop
   {
      constexpr left_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/ClassProperty operator= (/*0H*/ClassProperty & v);
      /*regSet*/inline typename TClassProperty<TC, TCO>::left_Prop & operator= (typename TClassProperty<TC, TCO>::left_Prop & prop);
      /*regGet*/inline operator /*0I*/ClassProperty () const;
   } left;
   struct right_Prop
   {
      constexpr right_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/ClassProperty operator= (/*0H*/ClassProperty & v);
      /*regSet*/inline typename TClassProperty<TC, TCO>::right_Prop & operator= (typename TClassProperty<TC, TCO>::right_Prop & prop);
      /*regGet*/inline operator /*0I*/ClassProperty () const;
   } right;
   struct depth_Prop
   {
      constexpr depth_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TClassProperty<TC, TCO>::depth_Prop & operator= (typename TClassProperty<TC, TCO>::depth_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } depth;
   struct dataTypeString_Prop
   {
      constexpr dataTypeString_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TClassProperty<TC, TCO>::dataTypeString_Prop & operator= (typename TClassProperty<TC, TCO>::dataTypeString_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } dataTypeString;
   struct constant_Prop
   {
      constexpr constant_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TClassProperty<TC, TCO>::constant_Prop & operator= (typename TClassProperty<TC, TCO>::constant_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } constant;
   ~TClassProperty()
   {
      this->impl = null; // How to know not to delete?
   }
};

struct ClassTemplateArgument : public TStruct<ClassTemplateArgument>
{
public:
   C(ClassTemplateArgument) impl;
   constexpr ClassTemplateArgument() : impl({}) { }
   constexpr ClassTemplateArgument(const C(ClassTemplateArgument) impl) : impl(impl) { }

   inline ClassTemplateArgument(const char * dataTypeString);

   struct dataTypeString_Prop
   {
      constexpr dataTypeString_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline ClassTemplateArgument::dataTypeString_Prop & operator= (ClassTemplateArgument::dataTypeString_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } dataTypeString;
   struct dataTypeClass_Prop
   {
      constexpr dataTypeClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline ClassTemplateArgument::dataTypeClass_Prop & operator= (ClassTemplateArgument::dataTypeClass_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } dataTypeClass;
   struct expression_Prop
   {
      constexpr expression_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/DataValue operator= (/*0H*/DataValue v);
      /*regSet*/inline ClassTemplateArgument::expression_Prop & operator= (ClassTemplateArgument::expression_Prop & prop);
      /*regGet*/inline operator /*0I*/DataValue () const;
   } expression;
   struct memberString_Prop
   {
      constexpr memberString_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline ClassTemplateArgument::memberString_Prop & operator= (ClassTemplateArgument::memberString_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } memberString;
   struct member_Prop
   {
      constexpr member_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/DataMember operator= (/*0H*/DataMember & v);
      /*regSet*/inline ClassTemplateArgument::member_Prop & operator= (ClassTemplateArgument::member_Prop & prop);
      /*regGet*/inline operator /*0I*/DataMember () const;
   } member;
   struct prop_Prop
   {
      constexpr prop_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Property operator= (/*0H*/Property & v);
      /*regSet*/inline ClassTemplateArgument::prop_Prop & operator= (ClassTemplateArgument::prop_Prop & prop);
      /*regGet*/inline operator /*0I*/Property () const;
   } prop;
   struct method_Prop
   {
      constexpr method_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Method operator= (/*0H*/Method & v);
      /*regSet*/inline ClassTemplateArgument::method_Prop & operator= (ClassTemplateArgument::method_Prop & prop);
      /*regGet*/inline operator /*0I*/Method () const;
   } method;
};

template <class TC, C(Class) ** TCO>
class TClassTemplateParameter : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/ClassTemplateParameter operator= (/*0H*/ClassTemplateParameter & v);
      /*regSet*/inline typename TClassTemplateParameter<TC, TCO>::prev_Prop & operator= (typename TClassTemplateParameter<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/ClassTemplateParameter () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/ClassTemplateParameter operator= (/*0H*/ClassTemplateParameter & v);
      /*regSet*/inline typename TClassTemplateParameter<TC, TCO>::next_Prop & operator= (typename TClassTemplateParameter<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/ClassTemplateParameter () const;
   } next;
   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TClassTemplateParameter<TC, TCO>::name_Prop & operator= (typename TClassTemplateParameter<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct type_Prop
   {
      constexpr type_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/TemplateParameterType operator= (/*0H*/TemplateParameterType v);
      /*regSet*/inline typename TClassTemplateParameter<TC, TCO>::type_Prop & operator= (typename TClassTemplateParameter<TC, TCO>::type_Prop & prop);
      /*regGet*/inline operator /*0I*/TemplateParameterType () const;
   } type;
   struct dataTypeString_Prop
   {
      constexpr dataTypeString_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TClassTemplateParameter<TC, TCO>::dataTypeString_Prop & operator= (typename TClassTemplateParameter<TC, TCO>::dataTypeString_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } dataTypeString;
   struct memberType_Prop
   {
      constexpr memberType_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/TemplateMemberType operator= (/*0H*/TemplateMemberType v);
      /*regSet*/inline typename TClassTemplateParameter<TC, TCO>::memberType_Prop & operator= (typename TClassTemplateParameter<TC, TCO>::memberType_Prop & prop);
      /*regGet*/inline operator /*0I*/TemplateMemberType () const;
   } memberType;
   struct defaultArg_Prop
   {
      constexpr defaultArg_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/ClassTemplateArgument operator= (/*0H*/ClassTemplateArgument v);
      /*regSet*/inline typename TClassTemplateParameter<TC, TCO>::defaultArg_Prop & operator= (typename TClassTemplateParameter<TC, TCO>::defaultArg_Prop & prop);
      /*regGet*/inline operator /*0I*/ClassTemplateArgument () const;
   } defaultArg;
   struct param_Prop
   {
      constexpr param_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TClassTemplateParameter<TC, TCO>::param_Prop & operator= (typename TClassTemplateParameter<TC, TCO>::param_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } param;
   ~TClassTemplateParameter()
   {
      this->impl = null; // How to know not to delete?
   }
};

enum class ClassType : int
{
   normalClass = ClassType_normalClass,
   structClass = ClassType_structClass,
   bitClass = ClassType_bitClass,
   unitClass = ClassType_unitClass,
   enumClass = ClassType_enumClass,
   noHeadClass = ClassType_noHeadClass,
   unionClass = ClassType_unionClass,
   systemClass = ClassType_systemClass
};

template <class TC, C(Class) ** TCO>
class TDataMember : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/DataMember operator= (/*0H*/DataMember & v);
      /*regSet*/inline typename TDataMember<TC, TCO>::prev_Prop & operator= (typename TDataMember<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/DataMember () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/DataMember operator= (/*0H*/DataMember & v);
      /*regSet*/inline typename TDataMember<TC, TCO>::next_Prop & operator= (typename TDataMember<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/DataMember () const;
   } next;
   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TDataMember<TC, TCO>::name_Prop & operator= (typename TDataMember<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct isProperty_Prop
   {
      constexpr isProperty_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TDataMember<TC, TCO>::isProperty_Prop & operator= (typename TDataMember<TC, TCO>::isProperty_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isProperty;
   struct memberAccess_Prop
   {
      constexpr memberAccess_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Access_Mode operator= (/*0H*/Access_Mode v);
      /*regSet*/inline typename TDataMember<TC, TCO>::memberAccess_Prop & operator= (typename TDataMember<TC, TCO>::memberAccess_Prop & prop);
      /*regGet*/inline operator /*0I*/Access_Mode () const;
   } memberAccess;
   struct id_Prop
   {
      constexpr id_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TDataMember<TC, TCO>::id_Prop & operator= (typename TDataMember<TC, TCO>::id_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } id;
   struct _class_Prop
   {
      constexpr _class_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline typename TDataMember<TC, TCO>::_class_Prop & operator= (typename TDataMember<TC, TCO>::_class_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } _class;
   struct dataTypeString_Prop
   {
      constexpr dataTypeString_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TDataMember<TC, TCO>::dataTypeString_Prop & operator= (typename TDataMember<TC, TCO>::dataTypeString_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } dataTypeString;
   struct dataTypeClass_Prop
   {
      constexpr dataTypeClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline typename TDataMember<TC, TCO>::dataTypeClass_Prop & operator= (typename TDataMember<TC, TCO>::dataTypeClass_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } dataTypeClass;
   struct type_Prop
   {
      constexpr type_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/DataMemberType operator= (/*0H*/DataMemberType v);
      /*regSet*/inline typename TDataMember<TC, TCO>::type_Prop & operator= (typename TDataMember<TC, TCO>::type_Prop & prop);
      /*regGet*/inline operator /*0I*/DataMemberType () const;
   } type;
   struct offset_Prop
   {
      constexpr offset_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TDataMember<TC, TCO>::offset_Prop & operator= (typename TDataMember<TC, TCO>::offset_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } offset;
   struct memberID_Prop
   {
      constexpr memberID_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TDataMember<TC, TCO>::memberID_Prop & operator= (typename TDataMember<TC, TCO>::memberID_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } memberID;
   struct members_Prop
   {
      constexpr members_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldList operator= (/*0H*/OldList v);
      /*regSet*/inline typename TDataMember<TC, TCO>::members_Prop & operator= (typename TDataMember<TC, TCO>::members_Prop & prop);
      /*regGet*/inline operator /*0I*/OldList () const;
   } members;
   struct membersAlpha_Prop
   {
      constexpr membersAlpha_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BinaryTree operator= (/*0H*/BinaryTree v);
      /*regSet*/inline typename TDataMember<TC, TCO>::membersAlpha_Prop & operator= (typename TDataMember<TC, TCO>::membersAlpha_Prop & prop);
      /*regGet*/inline operator /*0I*/BinaryTree () const;
   } membersAlpha;
   struct memberOffset_Prop
   {
      constexpr memberOffset_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TDataMember<TC, TCO>::memberOffset_Prop & operator= (typename TDataMember<TC, TCO>::memberOffset_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } memberOffset;
   struct structAlignment_Prop
   {
      constexpr structAlignment_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/short operator= (/*0H*/short v);
      /*regSet*/inline typename TDataMember<TC, TCO>::structAlignment_Prop & operator= (typename TDataMember<TC, TCO>::structAlignment_Prop & prop);
      /*regGet*/inline operator /*0I*/short () const;
   } structAlignment;
   struct pointerAlignment_Prop
   {
      constexpr pointerAlignment_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/short operator= (/*0H*/short v);
      /*regSet*/inline typename TDataMember<TC, TCO>::pointerAlignment_Prop & operator= (typename TDataMember<TC, TCO>::pointerAlignment_Prop & prop);
      /*regGet*/inline operator /*0I*/short () const;
   } pointerAlignment;
   ~TDataMember()
   {
      this->impl = null; // How to know not to delete?
   }
};

enum class DataMemberType : int
{
   normalMember = DataMemberType_normalMember,
   unionMember = DataMemberType_unionMember,
   structMember = DataMemberType_structMember
};

struct DataValue : public TStruct<DataValue>
{
public:
   C(DataValue) impl;
   constexpr DataValue() : impl({}) { }
   constexpr DataValue(const C(DataValue) impl) : impl(impl) { }

   inline DataValue(char c, unsigned char uc, short s, uint16 us, int i, uint ui, void * p, float f, double d, int64 i64, uint64 ui64);

   struct c_Prop
   {
      constexpr c_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/char operator= (/*0H*/char v);
      /*regSet*/inline DataValue::c_Prop & operator= (DataValue::c_Prop & prop);
      /*regGet*/inline operator /*0I*/char () const;
   } c;
   struct uc_Prop
   {
      constexpr uc_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/unsigned char operator= (/*0H*/unsigned char v);
      /*regSet*/inline DataValue::uc_Prop & operator= (DataValue::uc_Prop & prop);
      /*regGet*/inline operator /*0I*/unsigned char () const;
   } uc;
   struct s_Prop
   {
      constexpr s_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/short operator= (/*0H*/short v);
      /*regSet*/inline DataValue::s_Prop & operator= (DataValue::s_Prop & prop);
      /*regGet*/inline operator /*0I*/short () const;
   } s;
   struct us_Prop
   {
      constexpr us_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint16 operator= (/*0H*/uint16 v);
      /*regSet*/inline DataValue::us_Prop & operator= (DataValue::us_Prop & prop);
      /*regGet*/inline operator /*0I*/uint16 () const;
   } us;
   struct i_Prop
   {
      constexpr i_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline DataValue::i_Prop & operator= (DataValue::i_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } i;
   struct ui_Prop
   {
      constexpr ui_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint operator= (/*0H*/uint v);
      /*regSet*/inline DataValue::ui_Prop & operator= (DataValue::ui_Prop & prop);
      /*regGet*/inline operator /*0I*/uint () const;
   } ui;
   struct p_Prop
   {
      constexpr p_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline DataValue::p_Prop & operator= (DataValue::p_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } p;
   struct f_Prop
   {
      constexpr f_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/float operator= (/*0H*/float v);
      /*regSet*/inline DataValue::f_Prop & operator= (DataValue::f_Prop & prop);
      /*regGet*/inline operator /*0I*/float () const;
   } f;
   struct d_Prop
   {
      constexpr d_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/double operator= (/*0H*/double v);
      /*regSet*/inline DataValue::d_Prop & operator= (DataValue::d_Prop & prop);
      /*regGet*/inline operator /*0I*/double () const;
   } d;
   struct i64_Prop
   {
      constexpr i64_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int64 operator= (/*0H*/int64 v);
      /*regSet*/inline DataValue::i64_Prop & operator= (DataValue::i64_Prop & prop);
      /*regGet*/inline operator /*0I*/int64 () const;
   } i64;
   struct ui64_Prop
   {
      constexpr ui64_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint64 operator= (/*0H*/uint64 v);
      /*regSet*/inline DataValue::ui64_Prop & operator= (DataValue::ui64_Prop & prop);
      /*regGet*/inline operator /*0I*/uint64 () const;
   } ui64;
};

template <class TC, C(Class) ** TCO>
class TDefinedExpression : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/DefinedExpression operator= (/*0H*/DefinedExpression & v);
      /*regSet*/inline typename TDefinedExpression<TC, TCO>::prev_Prop & operator= (typename TDefinedExpression<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/DefinedExpression () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/DefinedExpression operator= (/*0H*/DefinedExpression & v);
      /*regSet*/inline typename TDefinedExpression<TC, TCO>::next_Prop & operator= (typename TDefinedExpression<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/DefinedExpression () const;
   } next;
   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TDefinedExpression<TC, TCO>::name_Prop & operator= (typename TDefinedExpression<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct value_Prop
   {
      constexpr value_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TDefinedExpression<TC, TCO>::value_Prop & operator= (typename TDefinedExpression<TC, TCO>::value_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } value;
   ~TDefinedExpression()
   {
      this->impl = null; // How to know not to delete?
   }
};

class Degrees : public Angle
{
public:
   constexpr Degrees() : Angle() { }
   constexpr Degrees(const Angle value) : Angle(value) { }
   constexpr Degrees(double value) : Angle(DEGREES(value)) { }
   constexpr operator double() const { return Angle_in_Degrees(impl); }
   constexpr Degrees & operator =(double value) { impl = DEGREES(value); return *this; }
   bool operator ==(const Degrees & value) const { return impl == value.impl; }
   bool operator !=(const Degrees & value) const { return impl != value.impl; }
   bool operator <(const Degrees & value) const { return impl < value.impl; }
   bool operator >(const Degrees & value) const { return impl > value.impl; }
   bool operator <=(const Degrees & value) const { return impl <= value.impl; }
   bool operator >=(const Degrees & value) const { return impl >= value.impl; }
   bool operator ==(double value) const { return impl == Degrees(value).impl; }
   bool operator !=(double value) const { return impl != Degrees(value).impl; }
   bool operator <(double value) const { return impl < Degrees(value).impl; }
   bool operator >(double value) const { return impl > Degrees(value).impl; }
   bool operator <=(double value) const { return impl <= Degrees(value).impl; }
   bool operator >=(double value) const { return impl >= Degrees(value).impl; }
   bool operator ==(int value) const { return impl == Degrees(value).impl; }
   bool operator !=(int value) const { return impl != Degrees(value).impl; }
   bool operator <(int value) const { return impl < Degrees(value).impl; }
   bool operator >(int value) const { return impl > Degrees(value).impl; }
   bool operator <=(int value) const { return impl <= Degrees(value).impl; }
   bool operator >=(int value) const { return impl >= Degrees(value).impl; }
   inline constexpr operator Radians() const;
   inline constexpr Degrees(const Radians & r);
   inline constexpr Degrees & operator =(const Radians & r);
};

template <class TC, C(Class) ** TCO>
class TEnumClassData : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct values_Prop
   {
      constexpr values_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldList operator= (/*0H*/OldList v);
      /*regSet*/inline typename TEnumClassData<TC, TCO>::values_Prop & operator= (typename TEnumClassData<TC, TCO>::values_Prop & prop);
      /*regGet*/inline operator /*0I*/OldList () const;
   } values;
   struct largest_Prop
   {
      constexpr largest_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int64 operator= (/*0H*/int64 v);
      /*regSet*/inline typename TEnumClassData<TC, TCO>::largest_Prop & operator= (typename TEnumClassData<TC, TCO>::largest_Prop & prop);
      /*regGet*/inline operator /*0I*/int64 () const;
   } largest;
   ~TEnumClassData()
   {
      this->impl = null; // How to know not to delete?
   }
};

class EscapeCStringOptions
{
public:
   C(EscapeCStringOptions) impl;
   constexpr EscapeCStringOptions() : impl(0) { }
   constexpr EscapeCStringOptions(C(EscapeCStringOptions) impl) : impl(impl) { }
   EscapeCStringOptions(bool escapeSingleQuote, bool escapeDoubleQuotes, bool writeQuotes, bool multiLine, int indent);
   operator C(EscapeCStringOptions)() { return impl; }
   EscapeCStringOptions & operator =(C(EscapeCStringOptions) impl) { impl = impl; return *this; }
   bool operator ==(const EscapeCStringOptions & value) const { return impl == value.impl; }
   bool operator !=(const EscapeCStringOptions & value) const { return impl != value.impl; }

   struct escapeSingleQuote_Prop
   {
      constexpr escapeSingleQuote_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline EscapeCStringOptions::escapeSingleQuote_Prop & operator= (EscapeCStringOptions::escapeSingleQuote_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } escapeSingleQuote;
   struct escapeDoubleQuotes_Prop
   {
      constexpr escapeDoubleQuotes_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline EscapeCStringOptions::escapeDoubleQuotes_Prop & operator= (EscapeCStringOptions::escapeDoubleQuotes_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } escapeDoubleQuotes;
   struct writeQuotes_Prop
   {
      constexpr writeQuotes_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline EscapeCStringOptions::writeQuotes_Prop & operator= (EscapeCStringOptions::writeQuotes_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } writeQuotes;
   struct multiLine_Prop
   {
      constexpr multiLine_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline EscapeCStringOptions::multiLine_Prop & operator= (EscapeCStringOptions::multiLine_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } multiLine;
   struct indent_Prop
   {
      constexpr indent_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline EscapeCStringOptions::indent_Prop & operator= (EscapeCStringOptions::indent_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } indent;
};

class Feet : public Distance
{
public:
   constexpr Feet() : Distance() { }
   constexpr Feet(const Distance value) : Distance(value) { }
   constexpr Feet(double value) : Distance(FEET(value)) { }
   constexpr operator double() const { return Distance_in_Feet(impl); }
   constexpr Feet & operator =(double value) { impl = FEET(value); return *this; }
   bool operator ==(const Feet & value) const { return impl == value.impl; }
   bool operator !=(const Feet & value) const { return impl != value.impl; }
   bool operator <(const Feet & value) const { return impl < value.impl; }
   bool operator >(const Feet & value) const { return impl > value.impl; }
   bool operator <=(const Feet & value) const { return impl <= value.impl; }
   bool operator >=(const Feet & value) const { return impl >= value.impl; }
   bool operator ==(double value) const { return impl == Feet(value).impl; }
   bool operator !=(double value) const { return impl != Feet(value).impl; }
   bool operator <(double value) const { return impl < Feet(value).impl; }
   bool operator >(double value) const { return impl > Feet(value).impl; }
   bool operator <=(double value) const { return impl <= Feet(value).impl; }
   bool operator >=(double value) const { return impl >= Feet(value).impl; }
   bool operator ==(int value) const { return impl == Feet(value).impl; }
   bool operator !=(int value) const { return impl != Feet(value).impl; }
   bool operator <(int value) const { return impl < Feet(value).impl; }
   bool operator >(int value) const { return impl > Feet(value).impl; }
   bool operator <=(int value) const { return impl <= Feet(value).impl; }
   bool operator >=(int value) const { return impl >= Feet(value).impl; }
   inline constexpr operator Meters() const;
   inline constexpr Feet(const Meters & m);
   inline constexpr Feet & operator =(const Meters & m);
};

template <class TC, C(Class) ** TCO>
class TGlobalFunction : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/GlobalFunction operator= (/*0H*/GlobalFunction & v);
      /*regSet*/inline typename TGlobalFunction<TC, TCO>::prev_Prop & operator= (typename TGlobalFunction<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/GlobalFunction () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/GlobalFunction operator= (/*0H*/GlobalFunction & v);
      /*regSet*/inline typename TGlobalFunction<TC, TCO>::next_Prop & operator= (typename TGlobalFunction<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/GlobalFunction () const;
   } next;
   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TGlobalFunction<TC, TCO>::name_Prop & operator= (typename TGlobalFunction<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct module_Prop
   {
      constexpr module_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Module operator= (/*0H*/Module v);
      /*regSet*/inline typename TGlobalFunction<TC, TCO>::module_Prop & operator= (typename TGlobalFunction<TC, TCO>::module_Prop & prop);
      /*regGet*/inline operator /*0I*/Module () const;
   } module;
   struct dataTypeString_Prop
   {
      constexpr dataTypeString_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TGlobalFunction<TC, TCO>::dataTypeString_Prop & operator= (typename TGlobalFunction<TC, TCO>::dataTypeString_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } dataTypeString;
   struct symbol_Prop
   {
      constexpr symbol_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TGlobalFunction<TC, TCO>::symbol_Prop & operator= (typename TGlobalFunction<TC, TCO>::symbol_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } symbol;
   ~TGlobalFunction()
   {
      this->impl = null; // How to know not to delete?
   }
};

enum class ImportType : int
{
   normalImport = ImportType_normalImport,
   staticImport = ImportType_staticImport,
   remoteImport = ImportType_remoteImport,
   preDeclImport = ImportType_preDeclImport,
   comCheckImport = ImportType_comCheckImport
};

class Meters : public Distance
{
public:
   constexpr Meters() : Distance() { }
   constexpr Meters(const Distance value) : Distance(value) { }
   constexpr Meters(double value) : Distance(METERS(value)) { }
   constexpr operator double() const { return Distance_in_Meters(impl); }
   constexpr Meters & operator =(double value) { impl = METERS(value); return *this; }
   bool operator ==(const Meters & value) const { return impl == value.impl; }
   bool operator !=(const Meters & value) const { return impl != value.impl; }
   bool operator <(const Meters & value) const { return impl < value.impl; }
   bool operator >(const Meters & value) const { return impl > value.impl; }
   bool operator <=(const Meters & value) const { return impl <= value.impl; }
   bool operator >=(const Meters & value) const { return impl >= value.impl; }
   bool operator ==(double value) const { return impl == Meters(value).impl; }
   bool operator !=(double value) const { return impl != Meters(value).impl; }
   bool operator <(double value) const { return impl < Meters(value).impl; }
   bool operator >(double value) const { return impl > Meters(value).impl; }
   bool operator <=(double value) const { return impl <= Meters(value).impl; }
   bool operator >=(double value) const { return impl >= Meters(value).impl; }
   bool operator ==(int value) const { return impl == Meters(value).impl; }
   bool operator !=(int value) const { return impl != Meters(value).impl; }
   bool operator <(int value) const { return impl < Meters(value).impl; }
   bool operator >(int value) const { return impl > Meters(value).impl; }
   bool operator <=(int value) const { return impl <= Meters(value).impl; }
   bool operator >=(int value) const { return impl >= Meters(value).impl; }
   inline Meters operator= (Centimeters value);
   inline Meters(Centimeters value);
   inline operator Centimeters() const;
   inline Meters operator= (Feet value);
   inline Meters(Feet value);
   inline operator Feet() const;
};

template <class TC, C(Class) ** TCO>
class TMethod : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TMethod<TC, TCO>::name_Prop & operator= (typename TMethod<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct parent_Prop
   {
      constexpr parent_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Method operator= (/*0H*/Method & v);
      /*regSet*/inline typename TMethod<TC, TCO>::parent_Prop & operator= (typename TMethod<TC, TCO>::parent_Prop & prop);
      /*regGet*/inline operator /*0I*/Method () const;
   } parent;
   struct left_Prop
   {
      constexpr left_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Method operator= (/*0H*/Method & v);
      /*regSet*/inline typename TMethod<TC, TCO>::left_Prop & operator= (typename TMethod<TC, TCO>::left_Prop & prop);
      /*regGet*/inline operator /*0I*/Method () const;
   } left;
   struct right_Prop
   {
      constexpr right_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Method operator= (/*0H*/Method & v);
      /*regSet*/inline typename TMethod<TC, TCO>::right_Prop & operator= (typename TMethod<TC, TCO>::right_Prop & prop);
      /*regGet*/inline operator /*0I*/Method () const;
   } right;
   struct depth_Prop
   {
      constexpr depth_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TMethod<TC, TCO>::depth_Prop & operator= (typename TMethod<TC, TCO>::depth_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } depth;
   struct vid_Prop
   {
      constexpr vid_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TMethod<TC, TCO>::vid_Prop & operator= (typename TMethod<TC, TCO>::vid_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } vid;
   struct type_Prop
   {
      constexpr type_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/MethodType operator= (/*0H*/MethodType v);
      /*regSet*/inline typename TMethod<TC, TCO>::type_Prop & operator= (typename TMethod<TC, TCO>::type_Prop & prop);
      /*regGet*/inline operator /*0I*/MethodType () const;
   } type;
   struct _class_Prop
   {
      constexpr _class_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline typename TMethod<TC, TCO>::_class_Prop & operator= (typename TMethod<TC, TCO>::_class_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } _class;
   struct symbol_Prop
   {
      constexpr symbol_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TMethod<TC, TCO>::symbol_Prop & operator= (typename TMethod<TC, TCO>::symbol_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } symbol;
   struct dataTypeString_Prop
   {
      constexpr dataTypeString_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TMethod<TC, TCO>::dataTypeString_Prop & operator= (typename TMethod<TC, TCO>::dataTypeString_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } dataTypeString;
   struct memberAccess_Prop
   {
      constexpr memberAccess_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Access_Mode operator= (/*0H*/Access_Mode v);
      /*regSet*/inline typename TMethod<TC, TCO>::memberAccess_Prop & operator= (typename TMethod<TC, TCO>::memberAccess_Prop & prop);
      /*regGet*/inline operator /*0I*/Access_Mode () const;
   } memberAccess;
   ~TMethod()
   {
      this->impl = null; // How to know not to delete?
   }
};

enum class MethodType : int
{
   normalMethod = MethodType_normalMethod,
   virtualMethod = MethodType_virtualMethod
};

class MinMaxValue
{
public:
   C(MinMaxValue) impl;
   constexpr MinMaxValue() : impl(0) { }
   constexpr MinMaxValue(C(MinMaxValue) value) : impl(value) { }
   operator C(MinMaxValue)() const { return impl; }
   constexpr MinMaxValue(const MinMaxValue & value) : impl(value.impl) { }
   MinMaxValue & operator =(int value) { impl = value; return *this; }
   MinMaxValue & operator +=(MinMaxValue value) { impl += value.impl; return *this; }
   MinMaxValue & operator -=(MinMaxValue value) { impl -= value.impl; return *this; }
   MinMaxValue operator +(const MinMaxValue & b) const { return MinMaxValue(impl + b.impl); }
   MinMaxValue operator -(const MinMaxValue & b) const { return MinMaxValue(impl - b.impl); }
   bool operator ==(const MinMaxValue & value) const { return impl == value.impl; }
   bool operator !=(const MinMaxValue & value) const { return impl != value.impl; }
   bool operator <(const MinMaxValue & value) const { return impl < value.impl; }
   bool operator >(const MinMaxValue & value) const { return impl > value.impl; }
   bool operator <=(const MinMaxValue & value) const { return impl <= value.impl; }
   bool operator >=(const MinMaxValue & value) const { return impl >= value.impl; }
   bool operator ==(int value) const { return impl == MinMaxValue(value).impl; }
   bool operator !=(int value) const { return impl != MinMaxValue(value).impl; }
   bool operator <(int value) const { return impl < MinMaxValue(value).impl; }
   bool operator >(int value) const { return impl > MinMaxValue(value).impl; }
   bool operator <=(int value) const { return impl <= MinMaxValue(value).impl; }
   bool operator >=(int value) const { return impl >= MinMaxValue(value).impl; }
};

struct NameSpace : public TStruct<NameSpace>
{
public:
   C(NameSpace) impl;
   constexpr NameSpace() : impl({}) { }
   constexpr NameSpace(const C(NameSpace) impl) : impl(impl) { }

   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline NameSpace::name_Prop & operator= (NameSpace::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct depth_Prop
   {
      constexpr depth_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline NameSpace::depth_Prop & operator= (NameSpace::depth_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } depth;
   struct nameSpaces_Prop
   {
      constexpr nameSpaces_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BinaryTree operator= (/*0H*/BinaryTree v);
      /*regSet*/inline NameSpace::nameSpaces_Prop & operator= (NameSpace::nameSpaces_Prop & prop);
      /*regGet*/inline operator /*0I*/BinaryTree () const;
   } nameSpaces;
   struct classes_Prop
   {
      constexpr classes_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BinaryTree operator= (/*0H*/BinaryTree v);
      /*regSet*/inline NameSpace::classes_Prop & operator= (NameSpace::classes_Prop & prop);
      /*regGet*/inline operator /*0I*/BinaryTree () const;
   } classes;
   struct defines_Prop
   {
      constexpr defines_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BinaryTree operator= (/*0H*/BinaryTree v);
      /*regSet*/inline NameSpace::defines_Prop & operator= (NameSpace::defines_Prop & prop);
      /*regGet*/inline operator /*0I*/BinaryTree () const;
   } defines;
   struct functions_Prop
   {
      constexpr functions_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BinaryTree operator= (/*0H*/BinaryTree v);
      /*regSet*/inline NameSpace::functions_Prop & operator= (NameSpace::functions_Prop & prop);
      /*regGet*/inline operator /*0I*/BinaryTree () const;
   } functions;
};

template <class TC, C(Class) ** TCO>
class TObjectInfo : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/ObjectInfo operator= (/*0H*/ObjectInfo & v);
      /*regSet*/inline typename TObjectInfo<TC, TCO>::prev_Prop & operator= (typename TObjectInfo<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/ObjectInfo () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/ObjectInfo operator= (/*0H*/ObjectInfo & v);
      /*regSet*/inline typename TObjectInfo<TC, TCO>::next_Prop & operator= (typename TObjectInfo<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/ObjectInfo () const;
   } next;
   struct instance_Prop
   {
      constexpr instance_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Instance operator= (/*0H*/Instance v);
      /*regSet*/inline typename TObjectInfo<TC, TCO>::instance_Prop & operator= (typename TObjectInfo<TC, TCO>::instance_Prop & prop);
      /*regGet*/inline operator /*0I*/Instance () const;
   } instance;
   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/char * operator= (/*0H*/char * v);
      /*regSet*/inline typename TObjectInfo<TC, TCO>::name_Prop & operator= (typename TObjectInfo<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/char * () const;
   } name;
   struct deleted_Prop
   {
      constexpr deleted_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TObjectInfo<TC, TCO>::deleted_Prop & operator= (typename TObjectInfo<TC, TCO>::deleted_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } deleted;
   struct oClass_Prop
   {
      constexpr oClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/ObjectInfo operator= (/*0H*/ObjectInfo & v);
      /*regSet*/inline typename TObjectInfo<TC, TCO>::oClass_Prop & operator= (typename TObjectInfo<TC, TCO>::oClass_Prop & prop);
      /*regGet*/inline operator /*0I*/ObjectInfo () const;
   } oClass;
   struct instances_Prop
   {
      constexpr instances_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldList operator= (/*0H*/OldList v);
      /*regSet*/inline typename TObjectInfo<TC, TCO>::instances_Prop & operator= (typename TObjectInfo<TC, TCO>::instances_Prop & prop);
      /*regGet*/inline operator /*0I*/OldList () const;
   } instances;
   struct modified_Prop
   {
      constexpr modified_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TObjectInfo<TC, TCO>::modified_Prop & operator= (typename TObjectInfo<TC, TCO>::modified_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } modified;
   struct i18nStrings_Prop
   {
      constexpr i18nStrings_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TObjectInfo<TC, TCO>::i18nStrings_Prop & operator= (typename TObjectInfo<TC, TCO>::i18nStrings_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } i18nStrings;
   ~TObjectInfo()
   {
      this->impl = null; // How to know not to delete?
   }
};

enum class Platform : int
{
   unknown = Platform_unknown,
   win32 = Platform_win32,
   tux = Platform_tux,
   apple = Platform_apple
};

struct Point : public TStruct<Point>
{
public:
   C(Point) impl;
   constexpr Point() : impl({}) { }
   constexpr Point(const C(Point) impl) : impl(impl) { }

   inline Point(int x, int y);

   struct x_Prop
   {
      constexpr x_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Point::x_Prop & operator= (Point::x_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } x;
   struct y_Prop
   {
      constexpr y_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Point::y_Prop & operator= (Point::y_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } y;
};

struct Pointd : public TStruct<Pointd>
{
public:
   C(Pointd) impl;
   constexpr Pointd() : impl({}) { }
   constexpr Pointd(const C(Pointd) impl) : impl(impl) { }

   inline Pointd(double x, double y);

   struct x_Prop
   {
      constexpr x_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/double operator= (/*0H*/double v);
      /*regSet*/inline Pointd::x_Prop & operator= (Pointd::x_Prop & prop);
      /*regGet*/inline operator /*0I*/double () const;
   } x;
   struct y_Prop
   {
      constexpr y_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/double operator= (/*0H*/double v);
      /*regSet*/inline Pointd::y_Prop & operator= (Pointd::y_Prop & prop);
      /*regGet*/inline operator /*0I*/double () const;
   } y;
};

struct Pointf : public TStruct<Pointf>
{
public:
   C(Pointf) impl;
   constexpr Pointf() : impl({}) { }
   constexpr Pointf(const C(Pointf) impl) : impl(impl) { }

   inline Pointf(float x, float y);

   struct x_Prop
   {
      constexpr x_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/float operator= (/*0H*/float v);
      /*regSet*/inline Pointf::x_Prop & operator= (Pointf::x_Prop & prop);
      /*regGet*/inline operator /*0I*/float () const;
   } x;
   struct y_Prop
   {
      constexpr y_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/float operator= (/*0H*/float v);
      /*regSet*/inline Pointf::y_Prop & operator= (Pointf::y_Prop & prop);
      /*regGet*/inline operator /*0I*/float () const;
   } y;
};

template <class TC, C(Class) ** TCO>
class TProperty : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Property operator= (/*0H*/Property & v);
      /*regSet*/inline typename TProperty<TC, TCO>::prev_Prop & operator= (typename TProperty<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/Property () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Property operator= (/*0H*/Property & v);
      /*regSet*/inline typename TProperty<TC, TCO>::next_Prop & operator= (typename TProperty<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/Property () const;
   } next;
   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TProperty<TC, TCO>::name_Prop & operator= (typename TProperty<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct isProperty_Prop
   {
      constexpr isProperty_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TProperty<TC, TCO>::isProperty_Prop & operator= (typename TProperty<TC, TCO>::isProperty_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isProperty;
   struct memberAccess_Prop
   {
      constexpr memberAccess_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Access_Mode operator= (/*0H*/Access_Mode v);
      /*regSet*/inline typename TProperty<TC, TCO>::memberAccess_Prop & operator= (typename TProperty<TC, TCO>::memberAccess_Prop & prop);
      /*regGet*/inline operator /*0I*/Access_Mode () const;
   } memberAccess;
   struct id_Prop
   {
      constexpr id_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TProperty<TC, TCO>::id_Prop & operator= (typename TProperty<TC, TCO>::id_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } id;
   struct _class_Prop
   {
      constexpr _class_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline typename TProperty<TC, TCO>::_class_Prop & operator= (typename TProperty<TC, TCO>::_class_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } _class;
   struct dataTypeString_Prop
   {
      constexpr dataTypeString_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TProperty<TC, TCO>::dataTypeString_Prop & operator= (typename TProperty<TC, TCO>::dataTypeString_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } dataTypeString;
   struct dataTypeClass_Prop
   {
      constexpr dataTypeClass_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline typename TProperty<TC, TCO>::dataTypeClass_Prop & operator= (typename TProperty<TC, TCO>::dataTypeClass_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } dataTypeClass;
   struct data_Prop
   {
      constexpr data_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TProperty<TC, TCO>::data_Prop & operator= (typename TProperty<TC, TCO>::data_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } data;
   struct symbol_Prop
   {
      constexpr symbol_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TProperty<TC, TCO>::symbol_Prop & operator= (typename TProperty<TC, TCO>::symbol_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } symbol;
   struct vid_Prop
   {
      constexpr vid_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TProperty<TC, TCO>::vid_Prop & operator= (typename TProperty<TC, TCO>::vid_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } vid;
   struct conversion_Prop
   {
      constexpr conversion_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TProperty<TC, TCO>::conversion_Prop & operator= (typename TProperty<TC, TCO>::conversion_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } conversion;
   struct watcherOffset_Prop
   {
      constexpr watcherOffset_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint operator= (/*0H*/uint v);
      /*regSet*/inline typename TProperty<TC, TCO>::watcherOffset_Prop & operator= (typename TProperty<TC, TCO>::watcherOffset_Prop & prop);
      /*regGet*/inline operator /*0I*/uint () const;
   } watcherOffset;
   struct category_Prop
   {
      constexpr category_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TProperty<TC, TCO>::category_Prop & operator= (typename TProperty<TC, TCO>::category_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } category;
   struct compiled_Prop
   {
      constexpr compiled_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TProperty<TC, TCO>::compiled_Prop & operator= (typename TProperty<TC, TCO>::compiled_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } compiled;
   struct selfWatchable_Prop
   {
      constexpr selfWatchable_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TProperty<TC, TCO>::selfWatchable_Prop & operator= (typename TProperty<TC, TCO>::selfWatchable_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } selfWatchable;
   struct isWatchable_Prop
   {
      constexpr isWatchable_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline typename TProperty<TC, TCO>::isWatchable_Prop & operator= (typename TProperty<TC, TCO>::isWatchable_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isWatchable;
   ~TProperty()
   {
      this->impl = null; // How to know not to delete?
   }
};

class Radians : public Angle
{
public:
   constexpr Radians() : Angle() { }
   constexpr Radians(const Angle value) : Angle(value) { }
   constexpr Radians(double value) : Angle(RADIANS(value)) { }
   constexpr operator double() const { return Angle_in_Radians(impl); }
   constexpr Radians & operator =(double value) { impl = RADIANS(value); return *this; }
   bool operator ==(const Radians & value) const { return impl == value.impl; }
   bool operator !=(const Radians & value) const { return impl != value.impl; }
   bool operator <(const Radians & value) const { return impl < value.impl; }
   bool operator >(const Radians & value) const { return impl > value.impl; }
   bool operator <=(const Radians & value) const { return impl <= value.impl; }
   bool operator >=(const Radians & value) const { return impl >= value.impl; }
   bool operator ==(double value) const { return impl == Radians(value).impl; }
   bool operator !=(double value) const { return impl != Radians(value).impl; }
   bool operator <(double value) const { return impl < Radians(value).impl; }
   bool operator >(double value) const { return impl > Radians(value).impl; }
   bool operator <=(double value) const { return impl <= Radians(value).impl; }
   bool operator >=(double value) const { return impl >= Radians(value).impl; }
   bool operator ==(int value) const { return impl == Radians(value).impl; }
   bool operator !=(int value) const { return impl != Radians(value).impl; }
   bool operator <(int value) const { return impl < Radians(value).impl; }
   bool operator >(int value) const { return impl > Radians(value).impl; }
   bool operator <=(int value) const { return impl <= Radians(value).impl; }
   bool operator >=(int value) const { return impl >= Radians(value).impl; }
   inline Radians operator= (Degrees value);
   inline Radians(Degrees value);
   inline operator Degrees() const;
};


#define REG_SerialBuffer(c) \
      SerialBuffer::class_registration(_cpp_class); \
      REG_IOChannel_readData(readData, c); \
      REG_IOChannel_writeData(writeData, c);

#define SERIALBUFFER_VIRTUAL_METHODS_PROTO(c) \

#define SERIALBUFFER_VIRTUAL_METHODS(c) \

class SerialBuffer : public IOChannel
{
public:
   inline SerialBuffer(SerialBuffer && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline SerialBuffer & operator= (SerialBuffer && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   SerialBuffer() : SerialBuffer((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<SerialBuffer> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         SerialBuffer * inst = new SerialBuffer(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      SerialBuffer * inst = (SerialBuffer *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(SerialBuffer & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline SerialBuffer(C(Instance) _impl, CPPClass & cl = _cpp_class) : IOChannel(_impl, cl) { }

   inline void free(); // SerialBuffer_free

   static void class_registration(CPPClass & _cpp_class);

   inline SerialBuffer(unsigned char * _buffer, uintsize count, uintsize _size, uintsize pos, unsigned char * buffer, uint size);

   struct buffer_Prop
   {
      constexpr buffer_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/unsigned char * operator= (/*0H*/unsigned char * v);
      /*regSet*/inline SerialBuffer::buffer_Prop & operator= (SerialBuffer::buffer_Prop & prop);
      /*regGet*/inline operator /*0I*/unsigned char * () const;
   } buffer;
   struct size_Prop
   {
      constexpr size_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint operator= (/*0H*/uint v);
      /*regSet*/inline SerialBuffer::size_Prop & operator= (SerialBuffer::size_Prop & prop);
      /*regGet*/inline operator /*0I*/uint () const;
   } size;

   struct _buffer_Prop
   {
      constexpr _buffer_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/unsigned char * operator= (/*0H*/unsigned char * v);
      /*regSet*/inline SerialBuffer::_buffer_Prop & operator= (SerialBuffer::_buffer_Prop & prop);
      /*regGet*/inline operator /*0I*/unsigned char * () const;
   } _buffer;
   struct count_Prop
   {
      constexpr count_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uintsize operator= (/*0H*/uintsize v);
      /*regSet*/inline SerialBuffer::count_Prop & operator= (SerialBuffer::count_Prop & prop);
      /*regGet*/inline operator /*0I*/uintsize () const;
   } count;
   struct _size_Prop
   {
      constexpr _size_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uintsize operator= (/*0H*/uintsize v);
      /*regSet*/inline SerialBuffer::_size_Prop & operator= (SerialBuffer::_size_Prop & prop);
      /*regGet*/inline operator /*0I*/uintsize () const;
   } _size;
   struct pos_Prop
   {
      constexpr pos_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uintsize operator= (/*0H*/uintsize v);
      /*regSet*/inline SerialBuffer::pos_Prop & operator= (SerialBuffer::pos_Prop & prop);
      /*regGet*/inline operator /*0I*/uintsize () const;
   } pos;
};

struct Size : public TStruct<Size>
{
public:
   C(Size) impl;
   constexpr Size() : impl({}) { }
   constexpr Size(const C(Size) impl) : impl(impl) { }

   inline Size(MinMaxValue w, MinMaxValue h);

   struct w_Prop
   {
      constexpr w_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/MinMaxValue operator= (/*0H*/MinMaxValue v);
      /*regSet*/inline Size::w_Prop & operator= (Size::w_Prop & prop);
      /*regGet*/inline operator /*0I*/MinMaxValue () const;
      /*regGet*/inline operator /*0J*/C(MinMaxValue) () const;
   } w;
   struct h_Prop
   {
      constexpr h_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/MinMaxValue operator= (/*0H*/MinMaxValue v);
      /*regSet*/inline Size::h_Prop & operator= (Size::h_Prop & prop);
      /*regGet*/inline operator /*0I*/MinMaxValue () const;
      /*regGet*/inline operator /*0J*/C(MinMaxValue) () const;
   } h;
};

struct StaticString : public TStruct<StaticString>
{
public:
   C(StaticString) impl;
   constexpr StaticString() : impl({}) { }
   constexpr StaticString(const C(StaticString) impl) : impl(impl) { }
};

enum class StringAllocType : int
{
   pointer = StringAllocType_pointer,
   stack = StringAllocType_stack,
   heap = StringAllocType_heap
};

template <class TC, C(Class) ** TCO>
class TSubModule : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/SubModule operator= (/*0H*/SubModule & v);
      /*regSet*/inline typename TSubModule<TC, TCO>::prev_Prop & operator= (typename TSubModule<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/SubModule () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/SubModule operator= (/*0H*/SubModule & v);
      /*regSet*/inline typename TSubModule<TC, TCO>::next_Prop & operator= (typename TSubModule<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/SubModule () const;
   } next;
   struct module_Prop
   {
      constexpr module_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Module operator= (/*0H*/Module v);
      /*regSet*/inline typename TSubModule<TC, TCO>::module_Prop & operator= (typename TSubModule<TC, TCO>::module_Prop & prop);
      /*regGet*/inline operator /*0I*/Module () const;
   } module;
   struct importMode_Prop
   {
      constexpr importMode_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Access_Mode operator= (/*0H*/Access_Mode v);
      /*regSet*/inline typename TSubModule<TC, TCO>::importMode_Prop & operator= (typename TSubModule<TC, TCO>::importMode_Prop & prop);
      /*regGet*/inline operator /*0I*/Access_Mode () const;
   } importMode;
   ~TSubModule()
   {
      this->impl = null; // How to know not to delete?
   }
};

enum class TemplateMemberType : int
{
   dataMember = TemplateMemberType_dataMember,
   method = TemplateMemberType_method,
   prop = TemplateMemberType_prop
};

enum class TemplateParameterType : int
{
   type = TemplateParameterType_type,
   identifier = TemplateParameterType_identifier,
   expression = TemplateParameterType_expression
};


#define REG_ZString(c) \
      ZString::class_registration(_cpp_class);

#define ZSTRING_VIRTUAL_METHODS_PROTO(c) \

#define ZSTRING_VIRTUAL_METHODS(c) \

class ZString : public Instance
{
public:
   inline operator constString() const;
   inline ZString(const char * s);
   inline ZString & operator =(constString s);
   inline ZString(ZString && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline ZString & operator= (ZString && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   ZString() : ZString((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<ZString> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         ZString * inst = new ZString(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      ZString * inst = (ZString *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(ZString & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline ZString(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl) { }

   inline void concat(/*1Ab*/ZString & s); // ZString_concat
   template<typename... Args> inline void concatf(/*1Ab*/const char * format, /*1Ab*/Args... args); // ZString_concatf
   inline void concatn(/*1Ab*/ZString & s, /*1Ab*/int l); // ZString_concatn
   template <typename ...Ts> inline void concatx(/*1Ab*/const Ts&... ts); // ZString_concatx
   inline void copy(/*1Ab*/ZString & s); // ZString_copy
   inline void copyString(/*1Ab*/const char * value, /*1Ab*/int newLen); // ZString_copyString

   static void class_registration(CPPClass & _cpp_class);

   inline ZString(char * _string, int len, StringAllocType allocType, int size, int minSize, int maxSize, const char * string);

   struct string_Prop
   {
      constexpr string_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline ZString::string_Prop & operator= (ZString::string_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } string;

   struct _string_Prop
   {
      constexpr _string_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/char * operator= (/*0H*/char * v);
      /*regSet*/inline ZString::_string_Prop & operator= (ZString::_string_Prop & prop);
      /*regGet*/inline operator /*0I*/char * () const;
   } _string;
   struct len_Prop
   {
      constexpr len_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline ZString::len_Prop & operator= (ZString::len_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } len;
   struct allocType_Prop
   {
      constexpr allocType_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/StringAllocType operator= (/*0H*/StringAllocType v);
      /*regSet*/inline ZString::allocType_Prop & operator= (ZString::allocType_Prop & prop);
      /*regGet*/inline operator /*0I*/StringAllocType () const;
   } allocType;
   struct size_Prop
   {
      constexpr size_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline ZString::size_Prop & operator= (ZString::size_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } size;
   struct minSize_Prop
   {
      constexpr minSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline ZString::minSize_Prop & operator= (ZString::minSize_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } minSize;
   struct maxSize_Prop
   {
      constexpr maxSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline ZString::maxSize_Prop & operator= (ZString::maxSize_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } maxSize;
};

struct BinaryTree : public TStruct<BinaryTree>
{
public:
   C(BinaryTree) impl;
   constexpr BinaryTree() : impl({}) { }
   constexpr BinaryTree(const C(BinaryTree) impl) : impl(impl) { }

   inline C(bool) add(/*1Ab*/BTNode node); // BinaryTree_add
   inline C(bool) check(); // BinaryTree_check
   inline int compareInt(/*1Ab*/uintptr a, /*1Ab*/uintptr b); // BinaryTree_compareInt
   inline int compareString(/*1Ab*/const char * a, /*1Ab*/const char * b); // BinaryTree_compareString
   inline void _delete(/*1Ab*/BTNode node); // BinaryTree_delete
   inline C(BTNode) * find(/*1Ab*/uintptr key); // BinaryTree_find
   inline C(BTNode) * findAll(/*1Ab*/uintptr key); // BinaryTree_findAll
   inline C(BTNode) * findPrefix(/*1Ab*/const char * key); // BinaryTree_findPrefix
   inline C(BTNode) * findString(/*1Ab*/const char * key); // BinaryTree_findString
   inline void free(); // BinaryTree_free
   static inline void freeString(/*1Ab*/char * string); // BinaryTree_freeString
   inline char * print(/*1Ab*/char * output, /*1Ab*/TreePrintStyle tps); // BinaryTree_print
   inline void remove(/*1Ab*/BTNode node); // BinaryTree_remove

   struct first_Prop
   {
      constexpr first_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/BTNode () const;
   } first;
   struct last_Prop
   {
      constexpr last_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/BTNode () const;
   } last;

   struct root_Prop
   {
      constexpr root_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BTNode operator= (/*0H*/BTNode & v);
      /*regSet*/inline BinaryTree::root_Prop & operator= (BinaryTree::root_Prop & prop);
      /*regGet*/inline operator /*0I*/BTNode () const;
   } root;
   struct count_Prop
   {
      constexpr count_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline BinaryTree::count_Prop & operator= (BinaryTree::count_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } count;
};

template <class TC, C(Class) ** TCO>
class TIteratorPointer : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;
   ~TIteratorPointer()
   {
      this->impl = null; // How to know not to delete?
   }
};

class Container
{
public:
   static TCPPClass<Container> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};

#define REG_Container_copy(m, c, TP_T, TP_I, TP_D)         TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, copy,         c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self, /*1Ab*/Container & source),                               c, (/*4Im*/(c &)source))
#define REG_Container_delete(m, c, TP_T, TP_I, TP_D)       TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, delete,       c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self, /*1Ab*/IteratorPointer it),                               c, (/*4Im*/it))
#define REG_Container_free(m, c, TP_T, TP_I, TP_D)         TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, free,         c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self),                                                          c, ())
#define REG_Container_freeIterator(m, c, TP_T, TP_I, TP_D) TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, freeIterator, c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self, /*1Ab*/IteratorPointer it),                               c, (/*4Im*/it))
#define REG_Container_getCount(m, c, TP_T, TP_I, TP_D)     TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, getCount,     c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self),                                                          c, ())
#define REG_Container_getData(m, c, TP_T, TP_I, TP_D)      TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, getData,      c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self, /*1Ab*/IteratorPointer pointer),                          c, (/*4Im*/pointer))
#define REG_Container_getFirst(m, c, TP_T, TP_I, TP_D)     TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, getFirst,     c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self),                                                          c, ())
#define REG_Container_getLast(m, c, TP_T, TP_I, TP_D)      TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, getLast,      c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self),                                                          c, ())
#define REG_Container_getNext(m, c, TP_T, TP_I, TP_D)      TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, getNext,      c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self, /*1Ab*/IteratorPointer pointer),                          c, (/*4Im*/pointer))
#define REG_Container_getPrev(m, c, TP_T, TP_I, TP_D)      TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, getPrev,      c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self, /*1Ab*/IteratorPointer pointer),                          c, (/*4Im*/pointer))
#define REG_Container_move(m, c, TP_T, TP_I, TP_D)         TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, move,         c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self, /*1Ab*/IteratorPointer it, /*1Ab*/IteratorPointer after), c, (/*4Im*/it, /*4Im*/after))
#define REG_Container_remove(m, c, TP_T, TP_I, TP_D)       TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, remove,       c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self, /*1Ab*/IteratorPointer it),                               c, (/*4Im*/it))
#define REG_Container_removeAll(m, c, TP_T, TP_I, TP_D)    TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, removeAll,    c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self),                                                          c, ())
#define REG_Container_sort(m, c, TP_T, TP_I, TP_D)         TREGVMETHOD(TContainer<TP_T, TP_I, TP_D>, Container, sort,         c::m, (/*1Ab*/TContainer<TP_T, TP_I, TP_D> & self, /*1Ab*/bool ascending),                                   c, (/*4Hm*/(bool)ascending))

#define TREG_Container(c, TP_T, TP_I, TP_D) \
      TContainer::class_registration(_cpp_class); \
      REG_Container_copy(copy, c, TP_T, TP_I, TP_D); \
      REG_Container_delete(delete, c, TP_T, TP_I, TP_D); \
      REG_Container_free(free, c, TP_T, TP_I, TP_D); \
      REG_Container_freeIterator(freeIterator, c, TP_T, TP_I, TP_D); \
      REG_Container_getCount(getCount, c, TP_T, TP_I, TP_D); \
      REG_Container_getData(getData, c, TP_T, TP_I, TP_D); \
      REG_Container_getFirst(getFirst, c, TP_T, TP_I, TP_D); \
      REG_Container_getLast(getLast, c, TP_T, TP_I, TP_D); \
      REG_Container_getNext(getNext, c, TP_T, TP_I, TP_D); \
      REG_Container_getPrev(getPrev, c, TP_T, TP_I, TP_D); \
      REG_Container_move(move, c, TP_T, TP_I, TP_D); \
      REG_Container_remove(remove, c, TP_T, TP_I, TP_D); \
      REG_Container_removeAll(removeAll, c, TP_T, TP_I, TP_D); \
      REG_Container_sort(sort, c, TP_T, TP_I, TP_D);

#define CONTAINER_VIRTUAL_METHODS_PROTO(c) \
   TVIRTUAL_METHOD_PROTO(add, add, Container, TContainer, \
      IteratorPointer, c & _ARG, , /*6Ej*/TP_T value); \
   TVIRTUAL_METHOD_PROTO(copy, copy, Container, TContainer, \
      void, c & _ARG, , /*6Fj*/TContainer & source); \
   TVIRTUAL_METHOD_PROTO(delete, delete_, Container, TContainer, \
      void, c & _ARG, , /*6Fj*/IteratorPointer it); \
   TVIRTUAL_METHOD_PROTO(find, find, Container, TContainer, \
      IteratorPointer, c & _ARG, , /*6Ej*/TP_D value); \
   TVIRTUAL_METHOD_PROTO(free, free, Container, TContainer, \
      void, c &, , ); \
   TVIRTUAL_METHOD_PROTO(freeIterator, freeIterator, Container, TContainer, \
      void, c & _ARG, , /*6Fj*/IteratorPointer it); \
   TVIRTUAL_METHOD_PROTO(getAtPosition, getAtPosition, Container, TContainer, \
      IteratorPointer, c & _ARG, , /*6Ej*/TP_I pos _ARG /*6Fj*/bool create _ARG /*6Cj*/C(bool) * justAdded); \
   TVIRTUAL_METHOD_PROTO(getCount, getCount, Container, TContainer, \
      int, c &, , ); \
   TVIRTUAL_METHOD_PROTO(getData, getData, Container, TContainer, \
      TP_D, c & _ARG, , /*6Fj*/IteratorPointer pointer); \
   TVIRTUAL_METHOD_PROTO(getFirst, getFirst, Container, TContainer, \
      IteratorPointer, c &, , ); \
   TVIRTUAL_METHOD_PROTO(getLast, getLast, Container, TContainer, \
      IteratorPointer, c &, , ); \
   TVIRTUAL_METHOD_PROTO(getNext, getNext, Container, TContainer, \
      IteratorPointer, c & _ARG, , /*6Fj*/IteratorPointer pointer); \
   TVIRTUAL_METHOD_PROTO(getPrev, getPrev, Container, TContainer, \
      IteratorPointer, c & _ARG, , /*6Fj*/IteratorPointer pointer); \
   TVIRTUAL_METHOD_PROTO(insert, insert, Container, TContainer, \
      IteratorPointer, c & _ARG, , /*6Fj*/IteratorPointer after _ARG /*6Ej*/TP_T value); \
   TVIRTUAL_METHOD_PROTO(move, move, Container, TContainer, \
      void, c & _ARG, , /*6Fj*/IteratorPointer it _ARG /*6Fj*/IteratorPointer after); \
   TVIRTUAL_METHOD_PROTO(remove, remove, Container, TContainer, \
      void, c & _ARG, , /*6Fj*/IteratorPointer it); \
   TVIRTUAL_METHOD_PROTO(removeAll, removeAll, Container, TContainer, \
      void, c &, , ); \
   TVIRTUAL_METHOD_PROTO(setData, setData, Container, TContainer, \
      bool, c & _ARG, , /*6Fj*/IteratorPointer pointer _ARG /*6Ej*/TP_D data); \
   TVIRTUAL_METHOD_PROTO(sort, sort, Container, TContainer, \
      void, c & _ARG, , /*6Fj*/bool ascending);

#define CONTAINER_VIRTUAL_METHODS(c) \
TVIRTUAL_METHOD(add, add, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   IteratorPointer, c & _ARG, , /*6Ej*/TP_T value, \
   C(IteratorPointer) * retIteratorPointer = Container_add(self ? self->impl : (C(Container))null, /*7Al*/toTA<TP_T>(value)); \
      return retIteratorPointer;); \
TVIRTUAL_METHOD(copy, copy, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   void, c & _ARG, , /*6Fj*/TContainer & source, \
   Container_copy(self ? self->impl : (C(Container))null, /*7Al*/((Instance&)source).impl);); \
TVIRTUAL_METHOD(delete, delete_, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   void, c & _ARG, , /*6Fj*/IteratorPointer it, \
   Container_delete(self ? self->impl : (C(Container))null, /*7Al*/it.impl);); \
TVIRTUAL_METHOD(find, find, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   IteratorPointer, c & _ARG, , /*6Ej*/TP_D value, \
   C(IteratorPointer) * retIteratorPointer = Container_find(self ? self->impl : (C(Container))null, /*7Al*/toTA<TP_D>(value)); \
      return retIteratorPointer;); \
TVIRTUAL_METHOD(free, free, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   void, c &, , , \
   Container_free(self ? self->impl : (C(Container))null);); \
TVIRTUAL_METHOD(freeIterator, freeIterator, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   void, c & _ARG, , /*6Fj*/IteratorPointer it, \
   Container_freeIterator(self ? self->impl : (C(Container))null, /*7Al*/it.impl);); \
TVIRTUAL_METHOD(getAtPosition, getAtPosition, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   IteratorPointer, c & _ARG, , /*6Ej*/TP_I pos _ARG /*6Fj*/bool create _ARG /*6Cj*/C(bool) * justAdded, \
   C(IteratorPointer) * retIteratorPointer = Container_getAtPosition(self ? self->impl : (C(Container))null, /*7Al*/toTA<TP_I>(pos), /*7Al*/(C(bool))create, /*7Al*/justAdded); \
      return retIteratorPointer;); \
TVIRTUAL_METHOD(getCount, getCount, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   int, c &, , , \
   return Container_getCount(self ? self->impl : (C(Container))null);); \
TVIRTUAL_METHOD(getData, getData, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   TP_D, c & _ARG, , /*6Fj*/IteratorPointer pointer, \
   return fromTA<TP_D>(Container_getData(self ? self->impl : (C(Container))null, /*7Al*/pointer.impl));); \
TVIRTUAL_METHOD(getFirst, getFirst, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   IteratorPointer, c &, , , \
   C(IteratorPointer) * retIteratorPointer = Container_getFirst(self ? self->impl : (C(Container))null); \
      return retIteratorPointer;); \
TVIRTUAL_METHOD(getLast, getLast, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   IteratorPointer, c &, , , \
   C(IteratorPointer) * retIteratorPointer = Container_getLast(self ? self->impl : (C(Container))null); \
      return retIteratorPointer;); \
TVIRTUAL_METHOD(getNext, getNext, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   IteratorPointer, c & _ARG, , /*6Fj*/IteratorPointer pointer, \
   C(IteratorPointer) * retIteratorPointer = Container_getNext(self ? self->impl : (C(Container))null, /*7Al*/pointer.impl); \
      return retIteratorPointer;); \
TVIRTUAL_METHOD(getPrev, getPrev, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   IteratorPointer, c & _ARG, , /*6Fj*/IteratorPointer pointer, \
   C(IteratorPointer) * retIteratorPointer = Container_getPrev(self ? self->impl : (C(Container))null, /*7Al*/pointer.impl); \
      return retIteratorPointer;); \
TVIRTUAL_METHOD(insert, insert, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   IteratorPointer, c & _ARG, , /*6Fj*/IteratorPointer after _ARG /*6Ej*/TP_T value, \
   C(IteratorPointer) * retIteratorPointer = Container_insert(self ? self->impl : (C(Container))null, /*7Al*/after.impl, /*7Al*/toTA<TP_T>(value)); \
      return retIteratorPointer;); \
TVIRTUAL_METHOD(move, move, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   void, c & _ARG, , /*6Fj*/IteratorPointer it _ARG /*6Fj*/IteratorPointer after, \
   Container_move(self ? self->impl : (C(Container))null, /*7Al*/it.impl, /*7Al*/after.impl);); \
TVIRTUAL_METHOD(remove, remove, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   void, c & _ARG, , /*6Fj*/IteratorPointer it, \
   Container_remove(self ? self->impl : (C(Container))null, /*7Al*/it.impl);); \
TVIRTUAL_METHOD(removeAll, removeAll, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   void, c &, , , \
   Container_removeAll(self ? self->impl : (C(Container))null);); \
TVIRTUAL_METHOD(setData, setData, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   bool, c & _ARG, , /*6Fj*/IteratorPointer pointer _ARG /*6Ej*/TP_D data, \
   return (bool)Container_setData(self ? self->impl : (C(Container))null, /*7Al*/pointer.impl, /*7Al*/toTA<TP_D>(data));); \
TVIRTUAL_METHOD(sort, sort, Container, <TP_T _ARG TP_I _ARG TP_D>, template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>, Container, \
   void, c & _ARG, , /*6Fj*/bool ascending, \
   Container_sort(self ? self->impl : (C(Container))null, /*7Al*/(C(bool))ascending););

template <typename TP_T, typename TP_I = int, typename TP_D = TP_T>
class TContainer : public Instance, public Container
{
public:
   inline TContainer(TContainer<TP_T, TP_I, TP_D> && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline TContainer<TP_T, TP_I, TP_D> & operator= (TContainer<TP_T, TP_I, TP_D> && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   TContainer() : TContainer((C(Instance))Instance_newEx(ensureTemplatized <TP_T, TP_I, TP_D>(_cpp_class, "Container").impl, false), ensureTemplatized <TP_T, TP_I, TP_D>(_cpp_class, "Container")) { }
   INSTANCE_VIRTUAL_METHODS_PROTO(TContainer)
   static TCPPClass<TContainer> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         TContainer <TP_T, TP_I, TP_D> * inst = new TContainer <TP_T, TP_I, TP_D>(i, _cpp_class);
         if(inst)
         {
            /*printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      TContainer <TP_T, TP_I, TP_D>* inst = (TContainer <TP_T, TP_I, TP_D>*)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor) ((void (*)(TContainer <TP_T, TP_I, TP_D> & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree) delete inst;
      }
   }
   explicit inline TContainer(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl)
 { }

   TContainer(std::initializer_list<TP_D> list) : TContainer()
   {
      typename std::initializer_list<TP_D>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         add(*it);
   }

   TContainer & operator =(std::initializer_list<TP_D> list)
   {
      typename std::initializer_list<TP_D>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         add(*it);
      return *this;
   }

   inline TP_D operator [](TP_I index)
   {
      IteratorPointer ptr = getAtPosition(index, false, null);
      return getData(ptr);
   }

   inline C(bool) takeOut(TP_D d);


   struct Container_add_Functor
   {
      [[no_unique_address]] int _[0];
      typedef IteratorPointer (* FunctionType)(TContainer & , /*6Ej*/TP_T value);
      inline FunctionType operator= (FunctionType func);
      inline IteratorPointer operator()( /*6Ej*/TP_T value);
   } add;
   // inline static void register_add(CPPClass & cl, Container::Container_add_Functor::FunctionType func)

   struct Container_copy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(TContainer & , /*6Fj*/TContainer & source);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( /*6Fj*/TContainer & source);
   } copy;
   // inline static void register_copy(CPPClass & cl, Container::Container_copy_Functor::FunctionType func)

   struct Container_delete_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(TContainer & , /*6Fj*/IteratorPointer it);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( /*6Fj*/IteratorPointer it);
   } delete_;
   // inline static void register_delete(CPPClass & cl, Container::Container_delete_Functor::FunctionType func)

   struct Container_find_Functor
   {
      [[no_unique_address]] int _[0];
      typedef IteratorPointer (* FunctionType)(TContainer & , /*6Ej*/TP_D value);
      inline FunctionType operator= (FunctionType func);
      inline IteratorPointer operator()( /*6Ej*/TP_D value);
   } find;
   // inline static void register_find(CPPClass & cl, Container::Container_find_Functor::FunctionType func)

   struct Container_free_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(TContainer &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( );
   } free;
   // inline static void register_free(CPPClass & cl, Container::Container_free_Functor::FunctionType func)

   struct Container_freeIterator_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(TContainer & , /*6Fj*/IteratorPointer it);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( /*6Fj*/IteratorPointer it);
   } freeIterator;
   // inline static void register_freeIterator(CPPClass & cl, Container::Container_freeIterator_Functor::FunctionType func)

   struct Container_getAtPosition_Functor
   {
      [[no_unique_address]] int _[0];
      typedef IteratorPointer (* FunctionType)(TContainer & , /*6Ej*/TP_I pos, /*6Fj*/bool create, /*6Cj*/C(bool) * justAdded);
      inline FunctionType operator= (FunctionType func);
      inline IteratorPointer operator()( /*6Ej*/TP_I pos, /*6Fj*/bool create, /*6Cj*/C(bool) * justAdded);
   } getAtPosition;
   // inline static void register_getAtPosition(CPPClass & cl, Container::Container_getAtPosition_Functor::FunctionType func)

   struct Container_getCount_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(TContainer &);
      inline FunctionType operator= (FunctionType func);
      inline int operator()( );
   } getCount;
   // inline static void register_getCount(CPPClass & cl, Container::Container_getCount_Functor::FunctionType func)

   struct Container_getData_Functor
   {
      [[no_unique_address]] int _[0];
      typedef TP_D (* FunctionType)(TContainer & , /*6Fj*/IteratorPointer pointer);
      inline FunctionType operator= (FunctionType func);
      inline TP_D operator()( /*6Fj*/IteratorPointer pointer);
   } getData;
   // inline static void register_getData(CPPClass & cl, Container::Container_getData_Functor::FunctionType func)

   struct Container_getFirst_Functor
   {
      [[no_unique_address]] int _[0];
      typedef IteratorPointer (* FunctionType)(TContainer &);
      inline FunctionType operator= (FunctionType func);
      inline IteratorPointer operator()( );
   } getFirst;
   // inline static void register_getFirst(CPPClass & cl, Container::Container_getFirst_Functor::FunctionType func)

   struct Container_getLast_Functor
   {
      [[no_unique_address]] int _[0];
      typedef IteratorPointer (* FunctionType)(TContainer &);
      inline FunctionType operator= (FunctionType func);
      inline IteratorPointer operator()( );
   } getLast;
   // inline static void register_getLast(CPPClass & cl, Container::Container_getLast_Functor::FunctionType func)

   struct Container_getNext_Functor
   {
      [[no_unique_address]] int _[0];
      typedef IteratorPointer (* FunctionType)(TContainer & , /*6Fj*/IteratorPointer pointer);
      inline FunctionType operator= (FunctionType func);
      inline IteratorPointer operator()( /*6Fj*/IteratorPointer pointer);
   } getNext;
   // inline static void register_getNext(CPPClass & cl, Container::Container_getNext_Functor::FunctionType func)

   struct Container_getPrev_Functor
   {
      [[no_unique_address]] int _[0];
      typedef IteratorPointer (* FunctionType)(TContainer & , /*6Fj*/IteratorPointer pointer);
      inline FunctionType operator= (FunctionType func);
      inline IteratorPointer operator()( /*6Fj*/IteratorPointer pointer);
   } getPrev;
   // inline static void register_getPrev(CPPClass & cl, Container::Container_getPrev_Functor::FunctionType func)

   struct Container_insert_Functor
   {
      [[no_unique_address]] int _[0];
      typedef IteratorPointer (* FunctionType)(TContainer & , /*6Fj*/IteratorPointer after, /*6Ej*/TP_T value);
      inline FunctionType operator= (FunctionType func);
      inline IteratorPointer operator()( /*6Fj*/IteratorPointer after, /*6Ej*/TP_T value);
   } insert;
   // inline static void register_insert(CPPClass & cl, Container::Container_insert_Functor::FunctionType func)

   struct Container_move_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(TContainer & , /*6Fj*/IteratorPointer it, /*6Fj*/IteratorPointer after);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( /*6Fj*/IteratorPointer it, /*6Fj*/IteratorPointer after);
   } move;
   // inline static void register_move(CPPClass & cl, Container::Container_move_Functor::FunctionType func)

   struct Container_remove_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(TContainer & , /*6Fj*/IteratorPointer it);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( /*6Fj*/IteratorPointer it);
   } remove;
   // inline static void register_remove(CPPClass & cl, Container::Container_remove_Functor::FunctionType func)

   struct Container_removeAll_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(TContainer &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( );
   } removeAll;
   // inline static void register_removeAll(CPPClass & cl, Container::Container_removeAll_Functor::FunctionType func)

   struct Container_setData_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(TContainer & , /*6Fj*/IteratorPointer pointer, /*6Ej*/TP_D data);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/IteratorPointer pointer, /*6Ej*/TP_D data);
   } setData;
   // inline static void register_setData(CPPClass & cl, Container::Container_setData_Functor::FunctionType func)

   struct Container_sort_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(TContainer & , /*6Fj*/bool ascending);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( /*6Fj*/bool ascending);
   } sort;
   // inline static void register_sort(CPPClass & cl, Container::Container_sort_Functor::FunctionType func)

   static void class_registration(CPPClass & _cpp_class);

   struct copySrc_Prop
   {
      constexpr copySrc_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0A*/const TContainer<TP_T, TP_I, TP_D> & operator= (/*0A*/const TContainer<TP_T, TP_I, TP_D> & v);
      /*nstSet*/inline /*0C*/const TContainer<TP_T, TP_I, TP_D> * operator= (/*0C*/const TContainer<TP_T, TP_I, TP_D> * v);
   } copySrc;
   struct firstIterator_Prop
   {
      constexpr firstIterator_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/TIterator<TP_T, TP_D> () const;
   } firstIterator;
   struct lastIterator_Prop
   {
      constexpr lastIterator_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/TIterator<TP_T, TP_D> () const;
   } lastIterator;
};

class CustomAVLTree
{
public:
   static TCPPClass<CustomAVLTree> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};


#define TREG_CustomAVLTree(c, TP_BT, TP_KT) \
      TCustomAVLTree::class_registration(_cpp_class);

#define CUSTOMAVLTREE_VIRTUAL_METHODS_PROTO(c) \

#define CUSTOMAVLTREE_VIRTUAL_METHODS(c) \

template <typename TP_BT, typename TP_KT = uint64>
class TCustomAVLTree : public TContainer<TP_BT, TP_KT>, public CustomAVLTree
{
public:
   inline TCustomAVLTree(TCustomAVLTree<TP_BT, TP_KT> && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline TCustomAVLTree<TP_BT, TP_KT> & operator= (TCustomAVLTree<TP_BT, TP_KT> && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   TCustomAVLTree() : TCustomAVLTree((C(Instance))Instance_newEx(ensureTemplatized <TP_BT, TP_KT>(_cpp_class, "CustomAVLTree").impl, false), ensureTemplatized <TP_BT, TP_KT>(_cpp_class, "CustomAVLTree")) { }
   INSTANCE_VIRTUAL_METHODS_PROTO(TCustomAVLTree)
   static TCPPClass<TCustomAVLTree> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         TCustomAVLTree <TP_BT, TP_KT> * inst = new TCustomAVLTree <TP_BT, TP_KT>(i, _cpp_class);
         if(inst)
         {
            /*printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      TCustomAVLTree <TP_BT, TP_KT>* inst = (TCustomAVLTree <TP_BT, TP_KT>*)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor) ((void (*)(TCustomAVLTree <TP_BT, TP_KT> & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree) delete inst;
      }
   }
   explicit inline TCustomAVLTree(C(Instance) _impl, CPPClass & cl = _cpp_class) : TContainer<TP_BT, TP_KT>(_impl, cl)
 { }

   static void class_registration(CPPClass & _cpp_class);

   TCustomAVLTree (std::initializer_list<TP_BT> list) : TCustomAVLTree<TP_BT, TP_KT> ()
   {
      typename std::initializer_list<TP_BT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
   }

   TCustomAVLTree<TP_BT, TP_KT> & operator =(std::initializer_list<TP_BT> list)
   {
      typename std::initializer_list<TP_BT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
      return *this;
   }

   struct root_Prop
   {
      constexpr root_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/TP_BT operator= (/*0H*/TP_BT v);
      /*regSet*/inline TCustomAVLTree<TP_BT _ARG TP_KT>::root_Prop & operator= (TCustomAVLTree<TP_BT _ARG TP_KT>::root_Prop & prop);
      /*regGet*/inline operator /*0I*/TP_BT () const;
   } root;
   struct count_Prop
   {
      constexpr count_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline TCustomAVLTree<TP_BT _ARG TP_KT>::count_Prop & operator= (TCustomAVLTree<TP_BT _ARG TP_KT>::count_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } count;
};

struct Iterator : Struct
{
public:
   static TCPPClass<Iterator> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};

template <typename TP_T, typename TP_IT = int>
class TIterator : Iterator
{
public:
   C(Iterator) impl;
   constexpr TIterator() : impl({}) { }
   constexpr TIterator(const C(Iterator) impl) : impl(impl) { }

   inline void free(); // Iterator_free
   inline TP_T getData(); // Iterator_getData
   inline C(bool) next(); // Iterator_next
   inline C(bool) prev(); // Iterator_prev
   inline void remove(); // Iterator_remove

   // FIXME: index() not generated?
   inline C(bool) index(TP_IT index, C(bool) create); // Iterator_index

   struct data_Prop
   {
      constexpr data_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0A*/const TP_T & operator= (/*0A*/const TP_T & v);
      /*regSet*/inline TIterator<TP_T _ARG TP_IT>::data_Prop & operator= (TIterator<TP_T _ARG TP_IT>::data_Prop & prop);
      /*nstSet*/inline /*0C*/const TP_T * operator= (/*0C*/const TP_T * v);
      /*regGet*/inline operator /*0B*/TIH<TP_T> () const;
      /*regGet*/inline TIH<TP_T> operator /*0D*/-> () const;
      /*regGet*/inline operator /*0E*/TP_T () const;
      /*regGet*/inline operator /*0F*/TP_T* () const;
   } data;

   struct container_Prop
   {
      constexpr container_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/TContainer<TP_T, TP_IT> operator= (/*0H*/TContainer<TP_T, TP_IT> v);
      /*regSet*/inline TIterator<TP_T _ARG TP_IT>::container_Prop & operator= (TIterator<TP_T _ARG TP_IT>::container_Prop & prop);
      /*regGet*/inline operator /*0I*/TContainer<TP_T, TP_IT> () const;
   } container;
   struct pointer_Prop
   {
      constexpr pointer_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/IteratorPointer operator= (/*0H*/IteratorPointer & v);
      /*regSet*/inline TIterator<TP_T _ARG TP_IT>::pointer_Prop & operator= (TIterator<TP_T _ARG TP_IT>::pointer_Prop & prop);
      /*regGet*/inline operator /*0I*/IteratorPointer () const;
   } pointer;
};

class LinkList
{
public:
   static TCPPClass<LinkList> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};


#define TREG_LinkList(c, TP_LT) \
      TLinkList::class_registration(_cpp_class);

#define LINKLIST_VIRTUAL_METHODS_PROTO(c) \

#define LINKLIST_VIRTUAL_METHODS(c) \

template <typename TP_LT = ListItem>
class TLinkList : public TContainer<TP_LT>, public LinkList
{
public:
   inline TLinkList(TLinkList<TP_LT> && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline TLinkList<TP_LT> & operator= (TLinkList<TP_LT> && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   TLinkList() : TLinkList((C(Instance))Instance_newEx(ensureTemplatized <TP_LT>(_cpp_class, "LinkList").impl, false), ensureTemplatized <TP_LT>(_cpp_class, "LinkList")) { }
   INSTANCE_VIRTUAL_METHODS_PROTO(TLinkList)
   static TCPPClass<TLinkList> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         TLinkList <TP_LT> * inst = new TLinkList <TP_LT>(i, _cpp_class);
         if(inst)
         {
            /*printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      TLinkList <TP_LT>* inst = (TLinkList <TP_LT>*)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor) ((void (*)(TLinkList <TP_LT> & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree) delete inst;
      }
   }
   explicit inline TLinkList(C(Instance) _impl, CPPClass & cl = _cpp_class) : TContainer<TP_LT>(_impl, cl)
 { }

   static void class_registration(CPPClass & _cpp_class);

   TLinkList (std::initializer_list<TP_LT> list) : TLinkList<TP_LT> ()
   {
      typename std::initializer_list<TP_LT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
   }

   TLinkList<TP_LT> & operator =(std::initializer_list<TP_LT> list)
   {
      typename std::initializer_list<TP_LT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
      return *this;
   }

   struct first_Prop
   {
      constexpr first_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/TP_LT operator= (/*0H*/TP_LT v);
      /*regSet*/inline TLinkList<TP_LT>::first_Prop & operator= (TLinkList<TP_LT>::first_Prop & prop);
      /*regGet*/inline operator /*0I*/TP_LT () const;
   } first;
   struct last_Prop
   {
      constexpr last_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/TP_LT operator= (/*0H*/TP_LT v);
      /*regSet*/inline TLinkList<TP_LT>::last_Prop & operator= (TLinkList<TP_LT>::last_Prop & prop);
      /*regGet*/inline operator /*0I*/TP_LT () const;
   } last;
   struct count_Prop
   {
      constexpr count_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline TLinkList<TP_LT>::count_Prop & operator= (TLinkList<TP_LT>::count_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } count;
};

template <class TC, C(Class) ** TCO>
class TListItem : public TIteratorPointer<TC, TCO>
{
public:
   using TIteratorPointer<TC, TCO>::TIteratorPointer;
   inline operator IteratorPointer& () const { return *(IteratorPointer *)this; }

   struct link_Prop
   {
      constexpr link_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0Z*/const LinkElement & operator= (/*0Z*/const LinkElement & v);
      /*regSet*/inline typename TListItem<TC, TCO>::link_Prop & operator= (typename TListItem<TC, TCO>::link_Prop & prop);
      /*regGet*/inline operator /*0I*/LinkElement & () const;
   } link;
   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/C(Class) * operator= (/*0H*/C(Class) * v);
      /*regSet*/inline typename TListItem<TC, TCO>::prev_Prop & operator= (typename TListItem<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/C(Class) * () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/C(Class) * operator= (/*0H*/C(Class) * v);
      /*regSet*/inline typename TListItem<TC, TCO>::next_Prop & operator= (typename TListItem<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/C(Class) * () const;
   } next;
   ~TListItem()
   {
      this->impl = null; // How to know not to delete?
   }
};

class AVLTree
{
public:
   static TCPPClass<AVLTree> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};


#define TREG_AVLTree(c, TP_AT) \
      TAVLTree::class_registration(_cpp_class);

#define AVLTREE_VIRTUAL_METHODS_PROTO(c) \

#define AVLTREE_VIRTUAL_METHODS(c) \

template <typename TP_AT>
class TAVLTree : public TCustomAVLTree<TP_AT>, public AVLTree
{
public:
   inline TAVLTree(TAVLTree<TP_AT> && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline TAVLTree<TP_AT> & operator= (TAVLTree<TP_AT> && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   TAVLTree() : TAVLTree((C(Instance))Instance_newEx(ensureTemplatized <TP_AT>(_cpp_class, "AVLTree").impl, false), ensureTemplatized <TP_AT>(_cpp_class, "AVLTree")) { }
   INSTANCE_VIRTUAL_METHODS_PROTO(TAVLTree)
   static TCPPClass<TAVLTree> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         TAVLTree <TP_AT> * inst = new TAVLTree <TP_AT>(i, _cpp_class);
         if(inst)
         {
            /*printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      TAVLTree <TP_AT>* inst = (TAVLTree <TP_AT>*)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor) ((void (*)(TAVLTree <TP_AT> & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree) delete inst;
      }
   }
   explicit inline TAVLTree(C(Instance) _impl, CPPClass & cl = _cpp_class) : TCustomAVLTree<TP_AT>(_impl, cl)
 { }

   static void class_registration(CPPClass & _cpp_class);

   TAVLTree (std::initializer_list<TP_AT> list) : TAVLTree<TP_AT> ()
   {
      typename std::initializer_list<TP_AT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
   }

   TAVLTree<TP_AT> & operator =(std::initializer_list<TP_AT> list)
   {
      typename std::initializer_list<TP_AT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
      return *this;
   }
};

class Array
{
public:
   static TCPPClass<Array> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};


#define TREG_Array(c, TP_T, TP_I, TP_D) \
      TArray::class_registration(_cpp_class); \
      REG_Container_copy(copy, c, TP_T, TP_I, TP_D); \
      REG_Container_delete(delete, c, TP_T, TP_I, TP_D); \
      REG_Container_free(free, c, TP_T, TP_I, TP_D); \
      REG_Container_freeIterator(freeIterator, c, TP_T, TP_I, TP_D); \
      REG_Container_getCount(getCount, c, TP_T, TP_I, TP_D); \
      REG_Container_getData(getData, c, TP_T, TP_I, TP_D); \
      REG_Container_getFirst(getFirst, c, TP_T, TP_I, TP_D); \
      REG_Container_getLast(getLast, c, TP_T, TP_I, TP_D); \
      REG_Container_getNext(getNext, c, TP_T, TP_I, TP_D); \
      REG_Container_getPrev(getPrev, c, TP_T, TP_I, TP_D); \
      REG_Container_move(move, c, TP_T, TP_I, TP_D); \
      REG_Container_remove(remove, c, TP_T, TP_I, TP_D); \
      REG_Container_removeAll(removeAll, c, TP_T, TP_I, TP_D); \
      REG_Container_sort(sort, c, TP_T, TP_I, TP_D);

#define ARRAY_VIRTUAL_METHODS_PROTO(c) \

#define ARRAY_VIRTUAL_METHODS(c) \

template <typename TP_T, typename TP_I = int, typename TP_D = TP_T>
class TArray : public TContainer<TP_T, TP_I, TP_D>, public Array
{
public:
   inline TArray(TArray<TP_T, TP_I, TP_D> && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline TArray<TP_T, TP_I, TP_D> & operator= (TArray<TP_T, TP_I, TP_D> && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   TArray() : TArray((C(Instance))Instance_newEx(ensureTemplatized <TP_T, TP_I, TP_D>(_cpp_class, "Array").impl, false), ensureTemplatized <TP_T, TP_I, TP_D>(_cpp_class, "Array")) { }
   INSTANCE_VIRTUAL_METHODS_PROTO(TArray)
   static TCPPClass<TArray> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         TArray <TP_T, TP_I, TP_D> * inst = new TArray <TP_T, TP_I, TP_D>(i, _cpp_class);
         if(inst)
         {
            /*printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      TArray <TP_T, TP_I, TP_D>* inst = (TArray <TP_T, TP_I, TP_D>*)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor) ((void (*)(TArray <TP_T, TP_I, TP_D> & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree) delete inst;
      }
   }
   explicit inline TArray(C(Instance) _impl, CPPClass & cl = _cpp_class) : TContainer<TP_T, TP_I, TP_D>(_impl, cl)
 { }

   static void class_registration(CPPClass & _cpp_class);

   TArray (std::initializer_list<TP_T> list) : TArray<TP_T, TP_I, TP_D> ()
   {
      typename std::initializer_list<TP_T>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
   }

   TArray<TP_T, TP_I, TP_D> & operator =(std::initializer_list<TP_T> list)
   {
      typename std::initializer_list<TP_T>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
      return *this;
   }

   inline TArray(TP(Container, T) * array, uint count, uint minAllocSize, uint size);

   struct size_Prop
   {
      constexpr size_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint operator= (/*0H*/uint v);
      /*regSet*/inline TArray<TP_T _ARG TP_I _ARG TP_D>::size_Prop & operator= (TArray<TP_T _ARG TP_I _ARG TP_D>::size_Prop & prop);
      /*regGet*/inline operator /*0I*/uint () const;
   } size;
   struct minAllocSize_Prop
   {
      constexpr minAllocSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint operator= (/*0H*/uint v);
      /*regSet*/inline TArray<TP_T _ARG TP_I _ARG TP_D>::minAllocSize_Prop & operator= (TArray<TP_T _ARG TP_I _ARG TP_D>::minAllocSize_Prop & prop);
      /*regGet*/inline operator /*0I*/uint () const;
   } minAllocSize;

   struct array_Prop
   {
      constexpr array_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/TP(Container, T) * operator= (/*0H*/TP(Container, T) * v);
      /*regSet*/inline TArray<TP_T _ARG TP_I _ARG TP_D>::array_Prop & operator= (TArray<TP_T _ARG TP_I _ARG TP_D>::array_Prop & prop);
      /*regGet*/inline operator /*0I*/TP(Container, T) * () const;
   } array;
   struct count_Prop
   {
      constexpr count_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint operator= (/*0H*/uint v);
      /*regSet*/inline TArray<TP_T _ARG TP_I _ARG TP_D>::count_Prop & operator= (TArray<TP_T _ARG TP_I _ARG TP_D>::count_Prop & prop);
      /*regGet*/inline operator /*0I*/uint () const;
   } count;
};

template <class TC, C(Class) ** TCO>
class TBTNode : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   inline C(BTNode) * findPrefix(/*1Ab*/const char * key); // BTNode_findPrefix
   inline C(BTNode) * findString(/*1Ab*/const char * key); // BTNode_findString

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/BTNode () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/BTNode () const;
   } next;
   struct minimum_Prop
   {
      constexpr minimum_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/BTNode () const;
   } minimum;
   struct maximum_Prop
   {
      constexpr maximum_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/BTNode () const;
   } maximum;
   struct count_Prop
   {
      constexpr count_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/int () const;
   } count;
   struct depthProp_Prop
   {
      constexpr depthProp_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/int () const;
   } depthProp;

   struct key_Prop
   {
      constexpr key_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uintptr operator= (/*0H*/uintptr v);
      /*regSet*/inline typename TBTNode<TC, TCO>::key_Prop & operator= (typename TBTNode<TC, TCO>::key_Prop & prop);
      /*regGet*/inline operator /*0I*/uintptr () const;
   } key;
   struct parent_Prop
   {
      constexpr parent_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BTNode operator= (/*0H*/BTNode & v);
      /*regSet*/inline typename TBTNode<TC, TCO>::parent_Prop & operator= (typename TBTNode<TC, TCO>::parent_Prop & prop);
      /*regGet*/inline operator /*0I*/BTNode () const;
   } parent;
   struct left_Prop
   {
      constexpr left_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BTNode operator= (/*0H*/BTNode & v);
      /*regSet*/inline typename TBTNode<TC, TCO>::left_Prop & operator= (typename TBTNode<TC, TCO>::left_Prop & prop);
      /*regGet*/inline operator /*0I*/BTNode () const;
   } left;
   struct right_Prop
   {
      constexpr right_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BTNode operator= (/*0H*/BTNode & v);
      /*regSet*/inline typename TBTNode<TC, TCO>::right_Prop & operator= (typename TBTNode<TC, TCO>::right_Prop & prop);
      /*regGet*/inline operator /*0I*/BTNode () const;
   } right;
   struct depth_Prop
   {
      constexpr depth_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TBTNode<TC, TCO>::depth_Prop & operator= (typename TBTNode<TC, TCO>::depth_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } depth;
   ~TBTNode()
   {
      this->impl = null; // How to know not to delete?
   }
};

struct BuiltInContainer : public TStruct<BuiltInContainer>
{
public:
   C(BuiltInContainer) impl;
   constexpr BuiltInContainer() : impl({}) { }
   constexpr BuiltInContainer(const C(BuiltInContainer) impl) : impl(impl) { }

   inline BuiltInContainer(void ** _vTbl);

   struct _vTbl_Prop
   {
      constexpr _vTbl_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void ** operator= (/*0H*/void ** v);
      /*regSet*/inline BuiltInContainer::_vTbl_Prop & operator= (BuiltInContainer::_vTbl_Prop & prop);
      /*regGet*/inline operator /*0I*/void ** () const;
   } _vTbl;
   struct _class_Prop
   {
      constexpr _class_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline BuiltInContainer::_class_Prop & operator= (BuiltInContainer::_class_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } _class;
   struct _refCount_Prop
   {
      constexpr _refCount_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline BuiltInContainer::_refCount_Prop & operator= (BuiltInContainer::_refCount_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } _refCount;
   struct data_Prop
   {
      constexpr data_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline BuiltInContainer::data_Prop & operator= (BuiltInContainer::data_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } data;
   struct count_Prop
   {
      constexpr count_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline BuiltInContainer::count_Prop & operator= (BuiltInContainer::count_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } count;
   struct type_Prop
   {
      constexpr type_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Class operator= (/*0H*/Class & v);
      /*regSet*/inline BuiltInContainer::type_Prop & operator= (BuiltInContainer::type_Prop & prop);
      /*regGet*/inline operator /*0I*/Class () const;
   } type;
};

class HashMap
{
public:
   static TCPPClass<HashMap> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};


#define TREG_HashMap(c, TP_KT, TP_VT) \
      THashMap::class_registration(_cpp_class);

#define HASHMAP_VIRTUAL_METHODS_PROTO(c) \

#define HASHMAP_VIRTUAL_METHODS(c) \

template <typename TP_KT = int64, typename TP_VT = uintptr>
class THashMap : public TContainer<TP_KT, TP_VT>, public HashMap
{
public:
   inline THashMap(THashMap<TP_KT, TP_VT> && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline THashMap<TP_KT, TP_VT> & operator= (THashMap<TP_KT, TP_VT> && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   THashMap() : THashMap((C(Instance))Instance_newEx(ensureTemplatized <TP_KT, TP_VT>(_cpp_class, "HashMap").impl, false), ensureTemplatized <TP_KT, TP_VT>(_cpp_class, "HashMap")) { }
   INSTANCE_VIRTUAL_METHODS_PROTO(THashMap)
   static TCPPClass<THashMap> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         THashMap <TP_KT, TP_VT> * inst = new THashMap <TP_KT, TP_VT>(i, _cpp_class);
         if(inst)
         {
            /*printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      THashMap <TP_KT, TP_VT>* inst = (THashMap <TP_KT, TP_VT>*)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor) ((void (*)(THashMap <TP_KT, TP_VT> & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree) delete inst;
      }
   }
   explicit inline THashMap(C(Instance) _impl, CPPClass & cl = _cpp_class) : TContainer<TP_KT, TP_VT>(_impl, cl)
 { }

   static void class_registration(CPPClass & _cpp_class);

   THashMap (std::initializer_list<TP_KT> list) : THashMap<TP_KT, TP_VT> ()
   {
      typename std::initializer_list<TP_KT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
   }

   THashMap<TP_KT, TP_VT> & operator =(std::initializer_list<TP_KT> list)
   {
      typename std::initializer_list<TP_KT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
      return *this;
   }

   struct count_Prop
   {
      constexpr count_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/int () const;
   } count;
   struct initSize_Prop
   {
      constexpr initSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0G*/int operator= (/*0G*/int v);
   } initSize;

   struct noRemResize_Prop
   {
      constexpr noRemResize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline THashMap<TP_KT _ARG TP_VT>::noRemResize_Prop & operator= (THashMap<TP_KT _ARG TP_VT>::noRemResize_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } noRemResize;
};

struct HashMapIterator : Struct
{
public:
   static TCPPClass<HashMapIterator> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};

template <typename TP_KT, typename TP_VT>
class THashMapIterator : HashMapIterator
{
public:
   C(HashMapIterator) impl;
   constexpr THashMapIterator() : impl({}) { }
   constexpr THashMapIterator(const C(HashMapIterator) impl) : impl(impl) { }

   struct map_Prop
   {
      constexpr map_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0A*/const THashMap<TP_KT, TP_VT> & operator= (/*0A*/const THashMap<TP_KT, TP_VT> & v);
      /*regSet*/inline THashMapIterator<TP_KT _ARG TP_VT>::map_Prop & operator= (THashMapIterator<TP_KT _ARG TP_VT>::map_Prop & prop);
      /*nstSet*/inline /*0C*/const THashMap<TP_KT, TP_VT> * operator= (/*0C*/const THashMap<TP_KT, TP_VT> * v);
      /*regGet*/inline operator /*0B*/TIH<THashMap<TP_KT, TP_VT>> () const;
      /*regGet*/inline TIH<THashMap<TP_KT, TP_VT>> operator /*0D*/-> () const;
      /*regGet*/inline operator /*0E*/THashMap<TP_KT, TP_VT> () const;
      /*regGet*/inline operator /*0F*/THashMap<TP_KT, TP_VT>* () const;
   } map;
   struct key_Prop
   {
      constexpr key_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0B*/TIH<TP_KT> () const;
      /*regGet*/inline TIH<TP_KT> operator /*0D*/-> () const;
      /*regGet*/inline operator /*0E*/TP_KT () const;
      /*regGet*/inline operator /*0F*/TP_KT* () const;
   } key;
   struct value_Prop
   {
      constexpr value_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0A*/const TP_VT & operator= (/*0A*/const TP_VT & v);
      /*regSet*/inline THashMapIterator<TP_KT _ARG TP_VT>::value_Prop & operator= (THashMapIterator<TP_KT _ARG TP_VT>::value_Prop & prop);
      /*nstSet*/inline /*0C*/const TP_VT * operator= (/*0C*/const TP_VT * v);
      /*regGet*/inline operator /*0B*/TIH<TP_VT> () const;
      /*regGet*/inline TIH<TP_VT> operator /*0D*/-> () const;
      /*regGet*/inline operator /*0E*/TP_VT () const;
      /*regGet*/inline operator /*0F*/TP_VT* () const;
   } value;
};

class HashTable
{
public:
   static TCPPClass<HashTable> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};


#define TREG_HashTable(c, TP_KT) \
      THashTable::class_registration(_cpp_class);

#define HASHTABLE_VIRTUAL_METHODS_PROTO(c) \

#define HASHTABLE_VIRTUAL_METHODS(c) \

template <typename TP_KT = int64>
class THashTable : public TContainer<TP_KT>, public HashTable
{
public:
   inline THashTable(THashTable<TP_KT> && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline THashTable<TP_KT> & operator= (THashTable<TP_KT> && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   THashTable() : THashTable((C(Instance))Instance_newEx(ensureTemplatized <TP_KT>(_cpp_class, "HashTable").impl, false), ensureTemplatized <TP_KT>(_cpp_class, "HashTable")) { }
   INSTANCE_VIRTUAL_METHODS_PROTO(THashTable)
   static TCPPClass<THashTable> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         THashTable <TP_KT> * inst = new THashTable <TP_KT>(i, _cpp_class);
         if(inst)
         {
            /*printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      THashTable <TP_KT>* inst = (THashTable <TP_KT>*)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor) ((void (*)(THashTable <TP_KT> & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree) delete inst;
      }
   }
   explicit inline THashTable(C(Instance) _impl, CPPClass & cl = _cpp_class) : TContainer<TP_KT>(_impl, cl)
 { }

   static void class_registration(CPPClass & _cpp_class);

   THashTable (std::initializer_list<TP_KT> list) : THashTable<TP_KT> ()
   {
      typename std::initializer_list<TP_KT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
   }

   THashTable<TP_KT> & operator =(std::initializer_list<TP_KT> list)
   {
      typename std::initializer_list<TP_KT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
      return *this;
   }

   struct initSize_Prop
   {
      constexpr initSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0G*/int operator= (/*0G*/int v);
   } initSize;
};

template <class TC, C(Class) ** TCO>
class TItem : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   inline void copy(/*1Ab*/TItem<TC, TCO> src, /*1Ab*/int size); // Item_copy

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Item operator= (/*0H*/Item & v);
      /*regSet*/inline typename TItem<TC, TCO>::prev_Prop & operator= (typename TItem<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/Item () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Item operator= (/*0H*/Item & v);
      /*regSet*/inline typename TItem<TC, TCO>::next_Prop & operator= (typename TItem<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/Item () const;
   } next;
   ~TItem()
   {
      this->impl = null; // How to know not to delete?
   }
};

template <class TC, C(Class) ** TCO>
class TLink : public TListItem<TC, TCO>
{
public:
   using TListItem<TC, TCO>::TListItem;
   inline operator ListItem& () const { return *(ListItem *)this; }

   struct data_Prop
   {
      constexpr data_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint64 operator= (/*0H*/uint64 v);
      /*regSet*/inline typename TLink<TC, TCO>::data_Prop & operator= (typename TLink<TC, TCO>::data_Prop & prop);
      /*regGet*/inline operator /*0I*/uint64 () const;
   } data;
   ~TLink()
   {
      this->impl = null; // How to know not to delete?
   }
};

struct LinkElement : Struct
{
public:
   static TCPPClass<LinkElement> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};

template <typename TP_T>
class TLinkElement : LinkElement
{
public:
   C(LinkElement) impl;
   constexpr TLinkElement() : impl({}) { }
   constexpr TLinkElement(const C(LinkElement) impl) : impl(impl) { }

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/TP_T operator= (/*0H*/TP_T v);
      /*regSet*/inline TLinkElement<TP_T>::prev_Prop & operator= (TLinkElement<TP_T>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/TP_T () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/TP_T operator= (/*0H*/TP_T v);
      /*regSet*/inline TLinkElement<TP_T>::next_Prop & operator= (TLinkElement<TP_T>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/TP_T () const;
   } next;
};

class List
{
public:
   static TCPPClass<List> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};


#define TREG_List(c, TP_LLT) \
      TList::class_registration(_cpp_class);

#define LIST_VIRTUAL_METHODS_PROTO(c) \

#define LIST_VIRTUAL_METHODS(c) \

template <typename TP_LLT>
class TList : public TLinkList<TP_LLT>, public List
{
public:
   inline TList(TList<TP_LLT> && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline TList<TP_LLT> & operator= (TList<TP_LLT> && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   TList() : TList((C(Instance))Instance_newEx(ensureTemplatized <TP_LLT>(_cpp_class, "List").impl, false), ensureTemplatized <TP_LLT>(_cpp_class, "List")) { }
   INSTANCE_VIRTUAL_METHODS_PROTO(TList)
   static TCPPClass<TList> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         TList <TP_LLT> * inst = new TList <TP_LLT>(i, _cpp_class);
         if(inst)
         {
            /*printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      TList <TP_LLT>* inst = (TList <TP_LLT>*)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor) ((void (*)(TList <TP_LLT> & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree) delete inst;
      }
   }
   explicit inline TList(C(Instance) _impl, CPPClass & cl = _cpp_class) : TLinkList<TP_LLT>(_impl, cl)
 { }

   static void class_registration(CPPClass & _cpp_class);

   TList (std::initializer_list<TP_LLT> list) : TList<TP_LLT> ()
   {
      typename std::initializer_list<TP_LLT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
   }

   TList<TP_LLT> & operator =(std::initializer_list<TP_LLT> list)
   {
      typename std::initializer_list<TP_LLT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
      return *this;
   }
};

class Map
{
public:
   static TCPPClass<Map> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};


#define TREG_Map(c, TP_MT, TP_V) \
      TMap::class_registration(_cpp_class);

#define MAP_VIRTUAL_METHODS_PROTO(c) \

#define MAP_VIRTUAL_METHODS(c) \

template <typename TP_MT, typename TP_V>
class TMap : public TCustomAVLTree<TP_MT, TP_V>, public Map
{
public:
   inline TMap(TMap<TP_MT, TP_V> && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline TMap<TP_MT, TP_V> & operator= (TMap<TP_MT, TP_V> && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   TMap() : TMap((C(Instance))Instance_newEx(ensureTemplatized <TP_MT, TP_V>(_cpp_class, "Map").impl, false), ensureTemplatized <TP_MT, TP_V>(_cpp_class, "Map")) { }
   INSTANCE_VIRTUAL_METHODS_PROTO(TMap)
   static TCPPClass<TMap> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         TMap <TP_MT, TP_V> * inst = new TMap <TP_MT, TP_V>(i, _cpp_class);
         if(inst)
         {
            /*printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      TMap <TP_MT, TP_V>* inst = (TMap <TP_MT, TP_V>*)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor) ((void (*)(TMap <TP_MT, TP_V> & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree) delete inst;
      }
   }
   explicit inline TMap(C(Instance) _impl, CPPClass & cl = _cpp_class) : TCustomAVLTree<TP_MT, TP_V>(_impl, cl)
 { }

   static void class_registration(CPPClass & _cpp_class);

   TMap (std::initializer_list<TP_MT> list) : TMap<TP_MT, TP_V> ()
   {
      typename std::initializer_list<TP_MT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
   }

   TMap<TP_MT, TP_V> & operator =(std::initializer_list<TP_MT> list)
   {
      typename std::initializer_list<TP_MT>::iterator it;
      for(it = list.begin(); it != list.end(); ++it)
         this->add(*it);
      return *this;
   }

   struct mapSrc_Prop
   {
      constexpr mapSrc_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0A*/const Map & operator= (/*0A*/const Map & v);
      /*nstSet*/inline /*0C*/const Map * operator= (/*0C*/const Map * v);
   } mapSrc;
};

struct MapIterator : Struct
{
public:
   static TCPPClass<MapIterator> _cpp_class;
   static void class_registration(CPPClass & _cpp_class);
};

template <typename TP_KT, typename TP_V>
class TMapIterator : MapIterator
{
public:
   C(MapIterator) impl;
   constexpr TMapIterator() : impl({}) { }
   constexpr TMapIterator(const C(MapIterator) impl) : impl(impl) { }

   // REVIEW: How to generate this here since MapIterator inherits from Iterator?
   inline C(bool) index(TP_KT index, C(bool) create);

   struct map_Prop
   {
      constexpr map_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0A*/const TMap<TP_KT, TP_V> & operator= (/*0A*/const TMap<TP_KT, TP_V> & v);
      /*regSet*/inline TMapIterator<TP_KT _ARG TP_V>::map_Prop & operator= (TMapIterator<TP_KT _ARG TP_V>::map_Prop & prop);
      /*nstSet*/inline /*0C*/const TMap<TP_KT, TP_V> * operator= (/*0C*/const TMap<TP_KT, TP_V> * v);
      /*regGet*/inline operator /*0B*/TIH<TMap<TP_KT, TP_V>> () const;
      /*regGet*/inline TIH<TMap<TP_KT, TP_V>> operator /*0D*/-> () const;
      /*regGet*/inline operator /*0E*/TMap<TP_KT, TP_V> () const;
      /*regGet*/inline operator /*0F*/TMap<TP_KT, TP_V>* () const;
   } map;
   struct key_Prop
   {
      constexpr key_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0B*/TIH<TP_KT> () const;
      /*regGet*/inline TIH<TP_KT> operator /*0D*/-> () const;
      /*regGet*/inline operator /*0E*/TP_KT () const;
      /*regGet*/inline operator /*0F*/TP_KT* () const;
   } key;
   struct value_Prop
   {
      constexpr value_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0A*/const TP_V & operator= (/*0A*/const TP_V & v);
      /*regSet*/inline TMapIterator<TP_KT _ARG TP_V>::value_Prop & operator= (TMapIterator<TP_KT _ARG TP_V>::value_Prop & prop);
      /*nstSet*/inline /*0C*/const TP_V * operator= (/*0C*/const TP_V * v);
      /*regGet*/inline operator /*0B*/TIH<TP_V> () const;
      /*regGet*/inline TIH<TP_V> operator /*0D*/-> () const;
      /*regGet*/inline operator /*0E*/TP_V () const;
      /*regGet*/inline operator /*0F*/TP_V* () const;
   } value;
};

template <class TC, C(Class) ** TCO>
class TNamedItem : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/NamedItem operator= (/*0H*/NamedItem & v);
      /*regSet*/inline typename TNamedItem<TC, TCO>::prev_Prop & operator= (typename TNamedItem<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/NamedItem () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/NamedItem operator= (/*0H*/NamedItem & v);
      /*regSet*/inline typename TNamedItem<TC, TCO>::next_Prop & operator= (typename TNamedItem<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/NamedItem () const;
   } next;
   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/char * operator= (/*0H*/char * v);
      /*regSet*/inline typename TNamedItem<TC, TCO>::name_Prop & operator= (typename TNamedItem<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/char * () const;
   } name;
   ~TNamedItem()
   {
      this->impl = null; // How to know not to delete?
   }
};

template <class TC, C(Class) ** TCO>
class TNamedLink : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/NamedLink operator= (/*0H*/NamedLink & v);
      /*regSet*/inline typename TNamedLink<TC, TCO>::prev_Prop & operator= (typename TNamedLink<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/NamedLink () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/NamedLink operator= (/*0H*/NamedLink & v);
      /*regSet*/inline typename TNamedLink<TC, TCO>::next_Prop & operator= (typename TNamedLink<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/NamedLink () const;
   } next;
   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/char * operator= (/*0H*/char * v);
      /*regSet*/inline typename TNamedLink<TC, TCO>::name_Prop & operator= (typename TNamedLink<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/char * () const;
   } name;
   struct data_Prop
   {
      constexpr data_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TNamedLink<TC, TCO>::data_Prop & operator= (typename TNamedLink<TC, TCO>::data_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } data;
   ~TNamedLink()
   {
      this->impl = null; // How to know not to delete?
   }
};

template <class TC, C(Class) ** TCO>
class TNamedLink64 : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/NamedLink64 operator= (/*0H*/NamedLink64 & v);
      /*regSet*/inline typename TNamedLink64<TC, TCO>::prev_Prop & operator= (typename TNamedLink64<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/NamedLink64 () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/NamedLink64 operator= (/*0H*/NamedLink64 & v);
      /*regSet*/inline typename TNamedLink64<TC, TCO>::next_Prop & operator= (typename TNamedLink64<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/NamedLink64 () const;
   } next;
   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/char * operator= (/*0H*/char * v);
      /*regSet*/inline typename TNamedLink64<TC, TCO>::name_Prop & operator= (typename TNamedLink64<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/char * () const;
   } name;
   struct data_Prop
   {
      constexpr data_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int64 operator= (/*0H*/int64 v);
      /*regSet*/inline typename TNamedLink64<TC, TCO>::data_Prop & operator= (typename TNamedLink64<TC, TCO>::data_Prop & prop);
      /*regGet*/inline operator /*0I*/int64 () const;
   } data;
   ~TNamedLink64()
   {
      this->impl = null; // How to know not to delete?
   }
};

template <class TC, C(Class) ** TCO>
class TOldLink : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   inline void free(); // OldLink_free

   struct prev_Prop
   {
      constexpr prev_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldLink operator= (/*0H*/OldLink & v);
      /*regSet*/inline typename TOldLink<TC, TCO>::prev_Prop & operator= (typename TOldLink<TC, TCO>::prev_Prop & prop);
      /*regGet*/inline operator /*0I*/OldLink () const;
   } prev;
   struct next_Prop
   {
      constexpr next_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/OldLink operator= (/*0H*/OldLink & v);
      /*regSet*/inline typename TOldLink<TC, TCO>::next_Prop & operator= (typename TOldLink<TC, TCO>::next_Prop & prop);
      /*regGet*/inline operator /*0I*/OldLink () const;
   } next;
   struct data_Prop
   {
      constexpr data_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline typename TOldLink<TC, TCO>::data_Prop & operator= (typename TOldLink<TC, TCO>::data_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } data;
   ~TOldLink()
   {
      this->impl = null; // How to know not to delete?
   }
};

struct OldList : public TStruct<OldList>
{
public:
   C(OldList) impl;
   constexpr OldList() : impl({}) { }
   constexpr OldList(const C(OldList) impl) : impl(impl) { }

   inline void add(/*1Ab*/void * item); // OldList_add
   inline C(bool) addName(/*1Ab*/void * item); // OldList_addName
   inline void clear(); // OldList_clear
   inline void copy(/*1Ab*/OldList & src, /*1Ab*/int size, void (* copy)(void * dest, void * src)); // OldList_copy
   inline void copy(/*1Ac*/OldList * src, /*1Ac*/int size, void (* copy)(void * dest, void * src)); // OldList_copy
   inline void _delete(/*1Ab*/void * item); // OldList_delete
   inline C(OldLink) * findLink(/*1Ab*/void * data); // OldList_findLink
   inline void * findName(/*1Ab*/const char * name, /*1Ab*/bool warn); // OldList_findName
   inline void * findNamedLink(/*1Ab*/const char * name, /*1Ab*/bool warn); // OldList_findNamedLink
   inline void free(void (* freeFn)(void *)); // OldList_free
   inline C(bool) insert(/*1Ab*/void * prevItem, /*1Ab*/void * item); // OldList_insert
   inline void move(/*1Ab*/void * item, /*1Ab*/void * prevItem); // OldList_move
   inline C(bool) placeName(/*1Ab*/const char * name, /*1Ab*/void ** place); // OldList_placeName
   inline void remove(/*1Ab*/void * item); // OldList_remove
   inline void removeAll(void (* freeFn)(void *)); // OldList_removeAll
   inline void sort(int (* compare)(void *, void *, void *), /*1Ab*/void * data); // OldList_sort
   inline void swap(/*1Ab*/void * item1, /*1Ab*/void * item2); // OldList_swap

   inline OldList(void * first, void * last, int count, uint offset, bool circ);

   struct first_Prop
   {
      constexpr first_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline OldList::first_Prop & operator= (OldList::first_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } first;
   struct last_Prop
   {
      constexpr last_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline OldList::last_Prop & operator= (OldList::last_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } last;
   struct count_Prop
   {
      constexpr count_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline OldList::count_Prop & operator= (OldList::count_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } count;
   struct offset_Prop
   {
      constexpr offset_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint operator= (/*0H*/uint v);
      /*regSet*/inline OldList::offset_Prop & operator= (OldList::offset_Prop & prop);
      /*regGet*/inline operator /*0I*/uint () const;
   } offset;
   struct circ_Prop
   {
      constexpr circ_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline OldList::circ_Prop & operator= (OldList::circ_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } circ;
};

template <class TC, C(Class) ** TCO>
class TStringBTNode : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   struct key_Prop
   {
      constexpr key_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/char * operator= (/*0H*/char * v);
      /*regSet*/inline typename TStringBTNode<TC, TCO>::key_Prop & operator= (typename TStringBTNode<TC, TCO>::key_Prop & prop);
      /*regGet*/inline operator /*0I*/char * () const;
   } key;
   struct parent_Prop
   {
      constexpr parent_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/StringBTNode operator= (/*0H*/StringBTNode & v);
      /*regSet*/inline typename TStringBTNode<TC, TCO>::parent_Prop & operator= (typename TStringBTNode<TC, TCO>::parent_Prop & prop);
      /*regGet*/inline operator /*0I*/StringBTNode () const;
   } parent;
   struct left_Prop
   {
      constexpr left_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/StringBTNode operator= (/*0H*/StringBTNode & v);
      /*regSet*/inline typename TStringBTNode<TC, TCO>::left_Prop & operator= (typename TStringBTNode<TC, TCO>::left_Prop & prop);
      /*regGet*/inline operator /*0I*/StringBTNode () const;
   } left;
   struct right_Prop
   {
      constexpr right_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/StringBTNode operator= (/*0H*/StringBTNode & v);
      /*regSet*/inline typename TStringBTNode<TC, TCO>::right_Prop & operator= (typename TStringBTNode<TC, TCO>::right_Prop & prop);
      /*regGet*/inline operator /*0I*/StringBTNode () const;
   } right;
   struct depth_Prop
   {
      constexpr depth_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TStringBTNode<TC, TCO>::depth_Prop & operator= (typename TStringBTNode<TC, TCO>::depth_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } depth;
   ~TStringBTNode()
   {
      this->impl = null; // How to know not to delete?
   }
};

struct StringBinaryTree : public TStruct<StringBinaryTree>
{
public:
   C(StringBinaryTree) impl;
   constexpr StringBinaryTree() : impl({}) { }
   constexpr StringBinaryTree(const C(StringBinaryTree) impl) : impl(impl) { }

   inline C(bool) add(/*1Ab*/BTNode node); // BinaryTree_add
   inline C(bool) check(); // BinaryTree_check
   inline int compareInt(/*1Ab*/uintptr a, /*1Ab*/uintptr b); // BinaryTree_compareInt
   inline int compareString(/*1Ab*/const char * a, /*1Ab*/const char * b); // BinaryTree_compareString
   inline void _delete(/*1Ab*/BTNode node); // BinaryTree_delete
   inline C(BTNode) * find(/*1Ab*/uintptr key); // BinaryTree_find
   inline C(BTNode) * findAll(/*1Ab*/uintptr key); // BinaryTree_findAll
   inline C(BTNode) * findPrefix(/*1Ab*/const char * key); // BinaryTree_findPrefix
   inline C(BTNode) * findString(/*1Ab*/const char * key); // BinaryTree_findString
   inline void free(); // BinaryTree_free
   static inline void freeString(/*1Ab*/char * string); // BinaryTree_freeString
   inline char * print(/*1Ab*/char * output, /*1Ab*/TreePrintStyle tps); // BinaryTree_print
   inline void remove(/*1Ab*/BTNode node); // BinaryTree_remove

   struct first_Prop
   {
      constexpr first_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/BTNode () const;
   } first;
   struct last_Prop
   {
      constexpr last_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/BTNode () const;
   } last;

   struct root_Prop
   {
      constexpr root_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/BTNode operator= (/*0H*/BTNode & v);
      /*regSet*/inline StringBinaryTree::root_Prop & operator= (StringBinaryTree::root_Prop & prop);
      /*regGet*/inline operator /*0I*/BTNode () const;
   } root;
   struct count_Prop
   {
      constexpr count_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline StringBinaryTree::count_Prop & operator= (StringBinaryTree::count_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } count;
};

enum class TreePrintStyle : int
{
   inOrder = TreePrintStyle_inOrder,
   postOrder = TreePrintStyle_postOrder,
   preOrder = TreePrintStyle_preOrder,
   depthOrder = TreePrintStyle_depthOrder
};

#define REG_File_close(m, c)       REGVMETHOD(File, close,       c::m, (/*1Ab*/File & self),                                                                                    c, ())
#define REG_File_closeInput(m, c)  REGVMETHOD(File, closeInput,  c::m, (/*1Ab*/File & self),                                                                                    c, ())
#define REG_File_closeOutput(m, c) REGVMETHOD(File, closeOutput, c::m, (/*1Ab*/File & self),                                                                                    c, ())
#define REG_File_eof(m, c)         REGVMETHOD(File, eof,         c::m, (/*1Ab*/File & self),                                                                                    c, ())
#define REG_File_getSize(m, c)     REGVMETHOD(File, getSize,     c::m, (/*1Ab*/File & self),                                                                                    c, ())
#define REG_File_getc(m, c)        REGVMETHOD(File, getc,        c::m, (/*1Ab*/File & self, /*1Ab*/char * ch),                                                                  c, (/*4Im*/ch))
#define REG_File_lock(m, c)        REGVMETHOD(File, lock,        c::m, (/*1Ab*/File & self, /*1Ab*/FileLock type, /*1Ab*/uint64 start, /*1Ab*/uint64 length, /*1Ab*/bool wait), c, (/*4Hm*/(FileLock)type, /*4Im*/start, /*4Im*/length, /*4Hm*/(bool)wait))
#define REG_File_putc(m, c)        REGVMETHOD(File, putc,        c::m, (/*1Ab*/File & self, /*1Ab*/char ch),                                                                    c, (/*4Im*/ch))
#define REG_File_puts(m, c)        REGVMETHOD(File, puts,        c::m, (/*1Ab*/File & self, /*1Ab*/const char * string),                                                        c, (/*4Im*/string))
#define REG_File_read(m, c)        REGVMETHOD(File, read,        c::m, (/*1Ab*/File & self, /*1Ab*/void * buffer, /*1Ab*/uintsize size, /*1Ab*/uintsize count),                 c, (/*4Im*/buffer, /*4Im*/size, /*4Im*/count))
#define REG_File_seek(m, c)        REGVMETHOD(File, seek,        c::m, (/*1Ab*/File & self, /*1Ab*/int64 pos, /*1Ab*/FileSeekMode mode),                                        c, (/*4Im*/pos, /*4Hm*/(FileSeekMode)mode))
#define REG_File_tell(m, c)        REGVMETHOD(File, tell,        c::m, (/*1Ab*/File & self),                                                                                    c, ())
#define REG_File_truncate(m, c)    REGVMETHOD(File, truncate,    c::m, (/*1Ab*/File & self, /*1Ab*/uint64 size),                                                                c, (/*4Im*/size))
#define REG_File_unlock(m, c)      REGVMETHOD(File, unlock,      c::m, (/*1Ab*/File & self, /*1Ab*/uint64 start, /*1Ab*/uint64 length, /*1Ab*/bool wait),                       c, (/*4Im*/start, /*4Im*/length, /*4Hm*/(bool)wait))
#define REG_File_write(m, c)       REGVMETHOD(File, write,       c::m, (/*1Ab*/File & self, /*1Ab*/const void * buffer, /*1Ab*/uintsize size, /*1Ab*/uintsize count),           c, (/*4Im*/buffer, /*4Im*/size, /*4Im*/count))

#define REG_File(c) \
      File::class_registration(_cpp_class); \
      REG_IOChannel_readData(readData, c); \
      REG_IOChannel_writeData(writeData, c); \
      REG_File_close(close, c); \
      REG_File_closeInput(closeInput, c); \
      REG_File_closeOutput(closeOutput, c); \
      REG_File_eof(eof, c); \
      REG_File_getSize(getSize, c); \
      REG_File_getc(getc, c); \
      REG_File_lock(lock, c); \
      REG_File_putc(putc, c); \
      REG_File_puts(puts, c); \
      REG_File_read(read, c); \
      REG_File_seek(seek, c); \
      REG_File_tell(tell, c); \
      REG_File_truncate(truncate, c); \
      REG_File_unlock(unlock, c); \
      REG_File_write(write, c);

#define FILE_VIRTUAL_METHODS_PROTO(c) \
   VIRTUAL_METHOD_PROTO(close, close, c, File, \
      void, c &, , ); \
   VIRTUAL_METHOD_PROTO(closeInput, closeInput, c, File, \
      void, c &, , ); \
   VIRTUAL_METHOD_PROTO(closeOutput, closeOutput, c, File, \
      void, c &, , ); \
   VIRTUAL_METHOD_PROTO(eof, eof_, c, File, \
      bool, c &, , ); \
   VIRTUAL_METHOD_PROTO(getSize, getSize, c, File, \
      uint64, c &, , ); \
   VIRTUAL_METHOD_PROTO(getc, getc, c, File, \
      bool, c & _ARG, , /*6Fj*/char * ch); \
   VIRTUAL_METHOD_PROTO(lock, lock, c, File, \
      bool, c & _ARG, , /*6Fj*/FileLock type _ARG /*6Fj*/uint64 start _ARG /*6Fj*/uint64 length _ARG /*6Fj*/bool wait); \
   VIRTUAL_METHOD_PROTO(putc, putc, c, File, \
      bool, c & _ARG, , /*6Fj*/char ch); \
   VIRTUAL_METHOD_PROTO(puts, puts, c, File, \
      bool, c & _ARG, , /*6Fj*/const char * string); \
   VIRTUAL_METHOD_PROTO(read, read, c, File, \
      uintsize, c & _ARG, , /*6Fj*/void * buffer _ARG /*6Fj*/uintsize size _ARG /*6Fj*/uintsize count); \
   VIRTUAL_METHOD_PROTO(seek, seek, c, File, \
      bool, c & _ARG, , /*6Fj*/int64 pos _ARG /*6Fj*/FileSeekMode mode); \
   VIRTUAL_METHOD_PROTO(tell, tell, c, File, \
      uint64, c &, , ); \
   VIRTUAL_METHOD_PROTO(truncate, truncate, c, File, \
      bool, c & _ARG, , /*6Fj*/uint64 size); \
   VIRTUAL_METHOD_PROTO(unlock, unlock, c, File, \
      bool, c & _ARG, , /*6Fj*/uint64 start _ARG /*6Fj*/uint64 length _ARG /*6Fj*/bool wait); \
   VIRTUAL_METHOD_PROTO(write, write, c, File, \
      uintsize, c & _ARG, , /*6Fj*/const void * buffer _ARG /*6Fj*/uintsize size _ARG /*6Fj*/uintsize count);

#define FILE_VIRTUAL_METHODS(c) \
VIRTUAL_METHOD(close, close, c, File, \
   void, c &, , , \
   File_close(self ? self->impl : (C(File))null);); \
VIRTUAL_METHOD(closeInput, closeInput, c, File, \
   void, c &, , , \
   File_closeInput(self ? self->impl : (C(File))null);); \
VIRTUAL_METHOD(closeOutput, closeOutput, c, File, \
   void, c &, , , \
   File_closeOutput(self ? self->impl : (C(File))null);); \
VIRTUAL_METHOD(eof, eof_, c, File, \
   bool, c &, , , \
   return (bool)File_eof(self ? self->impl : (C(File))null);); \
VIRTUAL_METHOD(getSize, getSize, c, File, \
   uint64, c &, , , \
   return File_getSize(self ? self->impl : (C(File))null);); \
VIRTUAL_METHOD(getc, getc, c, File, \
   bool, c & _ARG, , /*6Fj*/char * ch, \
   return (bool)File_getc(self ? self->impl : (C(File))null, /*7Al*/ch);); \
VIRTUAL_METHOD(lock, lock, c, File, \
   bool, c & _ARG, , /*6Fj*/FileLock type _ARG /*6Fj*/uint64 start _ARG /*6Fj*/uint64 length _ARG /*6Fj*/bool wait, \
   return (bool)File_lock(self ? self->impl : (C(File))null, /*7Al*/(C(FileLock))type, /*7Al*/start, /*7Al*/length, /*7Al*/(C(bool))wait);); \
VIRTUAL_METHOD(putc, putc, c, File, \
   bool, c & _ARG, , /*6Fj*/char ch, \
   return (bool)File_putc(self ? self->impl : (C(File))null, /*7Al*/ch);); \
VIRTUAL_METHOD(puts, puts, c, File, \
   bool, c & _ARG, , /*6Fj*/const char * string, \
   return (bool)File_puts(self ? self->impl : (C(File))null, /*7Al*/string);); \
VIRTUAL_METHOD(read, read, c, File, \
   uintsize, c & _ARG, , /*6Fj*/void * buffer _ARG /*6Fj*/uintsize size _ARG /*6Fj*/uintsize count, \
   return File_read(self ? self->impl : (C(File))null, /*7Al*/buffer, /*7Al*/size, /*7Al*/count);); \
VIRTUAL_METHOD(seek, seek, c, File, \
   bool, c & _ARG, , /*6Fj*/int64 pos _ARG /*6Fj*/FileSeekMode mode, \
   return (bool)File_seek(self ? self->impl : (C(File))null, /*7Al*/pos, /*7Al*/(C(FileSeekMode))mode);); \
VIRTUAL_METHOD(tell, tell, c, File, \
   uint64, c &, , , \
   return File_tell(self ? self->impl : (C(File))null);); \
VIRTUAL_METHOD(truncate, truncate, c, File, \
   bool, c & _ARG, , /*6Fj*/uint64 size, \
   return (bool)File_truncate(self ? self->impl : (C(File))null, /*7Al*/size);); \
VIRTUAL_METHOD(unlock, unlock, c, File, \
   bool, c & _ARG, , /*6Fj*/uint64 start _ARG /*6Fj*/uint64 length _ARG /*6Fj*/bool wait, \
   return (bool)File_unlock(self ? self->impl : (C(File))null, /*7Al*/start, /*7Al*/length, /*7Al*/(C(bool))wait);); \
VIRTUAL_METHOD(write, write, c, File, \
   uintsize, c & _ARG, , /*6Fj*/const void * buffer _ARG /*6Fj*/uintsize size _ARG /*6Fj*/uintsize count, \
   return File_write(self ? self->impl : (C(File))null, /*7Al*/buffer, /*7Al*/size, /*7Al*/count););

class File : public IOChannel
{
public:
   inline File(File && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline File & operator= (File && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   File() : File((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<File> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         File * inst = new File(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      File * inst = (File *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(File & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline File(C(Instance) _impl, CPPClass & cl = _cpp_class) : IOChannel(_impl, cl) { }

   inline C(bool) copyTo(/*1Ab*/const char * outputFileName); // File_copyTo
   inline C(bool) copyToFile(/*1Ab*/File & f); // File_copyToFile
   inline C(bool) flush(); // File_flush
   inline double getDouble(); // File_getDouble
   inline float getFloat(); // File_getFloat
   inline uint getHexValue(); // File_getHexValue
   inline C(bool) getLine(/*1Ab*/char * s, /*1Ab*/int max); // File_getLine
   inline int getLineEx(/*1Ab*/char * s, /*1Ab*/int max, /*1Ab*/C(bool) * hasNewLineChar); // File_getLineEx
   inline C(bool) getString(/*1Ab*/char * string, /*1Ab*/int max); // File_getString
   inline int getValue(); // File_getValue
   template <typename ...Ts> inline void print(/*1Ab*/const Ts&... ts); // File_print
   template <typename ...Ts> inline void printLn(/*1Ab*/const Ts&... ts); // File_printLn
   template<typename... Args> inline int _printf(/*1Ab*/const char * format, /*1Ab*/Args... args); // File_printf

   struct File_close_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(File &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( );
   } close;
   // inline static void register_close(CPPClass & cl, File::File_close_Functor::FunctionType func)

   struct File_closeInput_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(File &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( );
   } closeInput;
   // inline static void register_closeInput(CPPClass & cl, File::File_closeInput_Functor::FunctionType func)

   struct File_closeOutput_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(File &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( );
   } closeOutput;
   // inline static void register_closeOutput(CPPClass & cl, File::File_closeOutput_Functor::FunctionType func)

   struct File_eof_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(File &);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( );
   } eof_;
   // inline static void register_eof(CPPClass & cl, File::File_eof_Functor::FunctionType func)

   struct File_getSize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef uint64 (* FunctionType)(File &);
      inline FunctionType operator= (FunctionType func);
      inline uint64 operator()( );
   } getSize;
   // inline static void register_getSize(CPPClass & cl, File::File_getSize_Functor::FunctionType func)

   struct File_getc_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(File & , /*6Fj*/char * ch);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/char * ch);
   } getc;
   // inline static void register_getc(CPPClass & cl, File::File_getc_Functor::FunctionType func)

   struct File_lock_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(File & , /*6Fj*/FileLock type, /*6Fj*/uint64 start, /*6Fj*/uint64 length, /*6Fj*/bool wait);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/FileLock type, /*6Fj*/uint64 start, /*6Fj*/uint64 length, /*6Fj*/bool wait);
   } lock;
   // inline static void register_lock(CPPClass & cl, File::File_lock_Functor::FunctionType func)

   struct File_putc_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(File & , /*6Fj*/char ch);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/char ch);
   } putc;
   // inline static void register_putc(CPPClass & cl, File::File_putc_Functor::FunctionType func)

   struct File_puts_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(File & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/const char * string);
   } puts;
   // inline static void register_puts(CPPClass & cl, File::File_puts_Functor::FunctionType func)

   struct File_read_Functor
   {
      [[no_unique_address]] int _[0];
      typedef uintsize (* FunctionType)(File & , /*6Fj*/void * buffer, /*6Fj*/uintsize size, /*6Fj*/uintsize count);
      inline FunctionType operator= (FunctionType func);
      inline uintsize operator()( /*6Fj*/void * buffer, /*6Fj*/uintsize size, /*6Fj*/uintsize count);
   } read;
   // inline static void register_read(CPPClass & cl, File::File_read_Functor::FunctionType func)

   struct File_seek_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(File & , /*6Fj*/int64 pos, /*6Fj*/FileSeekMode mode);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/int64 pos, /*6Fj*/FileSeekMode mode);
   } seek;
   // inline static void register_seek(CPPClass & cl, File::File_seek_Functor::FunctionType func)

   struct File_tell_Functor
   {
      [[no_unique_address]] int _[0];
      typedef uint64 (* FunctionType)(File &);
      inline FunctionType operator= (FunctionType func);
      inline uint64 operator()( );
   } tell;
   // inline static void register_tell(CPPClass & cl, File::File_tell_Functor::FunctionType func)

   struct File_truncate_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(File & , /*6Fj*/uint64 size);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/uint64 size);
   } truncate;
   // inline static void register_truncate(CPPClass & cl, File::File_truncate_Functor::FunctionType func)

   struct File_unlock_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(File & , /*6Fj*/uint64 start, /*6Fj*/uint64 length, /*6Fj*/bool wait);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/uint64 start, /*6Fj*/uint64 length, /*6Fj*/bool wait);
   } unlock;
   // inline static void register_unlock(CPPClass & cl, File::File_unlock_Functor::FunctionType func)

   struct File_write_Functor
   {
      [[no_unique_address]] int _[0];
      typedef uintsize (* FunctionType)(File & , /*6Fj*/const void * buffer, /*6Fj*/uintsize size, /*6Fj*/uintsize count);
      inline FunctionType operator= (FunctionType func);
      inline uintsize operator()( /*6Fj*/const void * buffer, /*6Fj*/uintsize size, /*6Fj*/uintsize count);
   } write;
   // inline static void register_write(CPPClass & cl, File::File_write_Functor::FunctionType func)

   static void class_registration(CPPClass & _cpp_class);

   inline File(void * input, void * output, bool buffered);

   struct input_Prop
   {
      constexpr input_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline File::input_Prop & operator= (File::input_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } input;
   struct output_Prop
   {
      constexpr output_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/void * operator= (/*0H*/void * v);
      /*regSet*/inline File::output_Prop & operator= (File::output_Prop & prop);
      /*regGet*/inline operator /*0I*/void * () const;
   } output;
   struct buffered_Prop
   {
      constexpr buffered_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0G*/bool operator= (/*0G*/bool v);
   } buffered;
   struct eof_Prop
   {
      constexpr eof_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/bool () const;
   } eof;
};

class FileAttribs
{
public:
   C(FileAttribs) impl;
   constexpr FileAttribs() : impl(0) { }
   constexpr FileAttribs(C(FileAttribs) impl) : impl(impl) { }
   operator C(FileAttribs)() { return impl; }
   FileAttribs & operator =(C(FileAttribs) impl) { impl = impl; return *this; }
   bool operator ==(const FileAttribs & value) const { return impl == value.impl; }
   bool operator !=(const FileAttribs & value) const { return impl != value.impl; }

   struct isFile_Prop
   {
      constexpr isFile_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isFile_Prop & operator= (FileAttribs::isFile_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isFile;
   struct isArchive_Prop
   {
      constexpr isArchive_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isArchive_Prop & operator= (FileAttribs::isArchive_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isArchive;
   struct isHidden_Prop
   {
      constexpr isHidden_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isHidden_Prop & operator= (FileAttribs::isHidden_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isHidden;
   struct isReadOnly_Prop
   {
      constexpr isReadOnly_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isReadOnly_Prop & operator= (FileAttribs::isReadOnly_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isReadOnly;
   struct isSystem_Prop
   {
      constexpr isSystem_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isSystem_Prop & operator= (FileAttribs::isSystem_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isSystem;
   struct isTemporary_Prop
   {
      constexpr isTemporary_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isTemporary_Prop & operator= (FileAttribs::isTemporary_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isTemporary;
   struct isDirectory_Prop
   {
      constexpr isDirectory_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isDirectory_Prop & operator= (FileAttribs::isDirectory_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isDirectory;
   struct isDrive_Prop
   {
      constexpr isDrive_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isDrive_Prop & operator= (FileAttribs::isDrive_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isDrive;
   struct isCDROM_Prop
   {
      constexpr isCDROM_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isCDROM_Prop & operator= (FileAttribs::isCDROM_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isCDROM;
   struct isRemote_Prop
   {
      constexpr isRemote_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isRemote_Prop & operator= (FileAttribs::isRemote_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isRemote;
   struct isRemovable_Prop
   {
      constexpr isRemovable_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isRemovable_Prop & operator= (FileAttribs::isRemovable_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isRemovable;
   struct isServer_Prop
   {
      constexpr isServer_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isServer_Prop & operator= (FileAttribs::isServer_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isServer;
   struct isShare_Prop
   {
      constexpr isShare_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileAttribs::isShare_Prop & operator= (FileAttribs::isShare_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isShare;
};

#define REG_ArchiveDir_addFromFile(m, c)           REGVMETHOD(ArchiveDir, addFromFile,           c::m, (/*1Ab*/ArchiveDir & self, /*1Ab*/const char * name, /*1Ab*/File & input, /*1Ab*/FileStats & stats, /*1Ab*/ArchiveAddMode addMode, /*1Ab*/int compression, /*1Ab*/int * ratio, /*1Ab*/uint * newPosition),                       c, (/*4Im*/name, /*4Im*/input, /*4Im*/stats, /*4Hm*/(ArchiveAddMode)addMode, /*4Im*/compression, /*4Im*/ratio, /*4Im*/newPosition))
#define REG_ArchiveDir_addFromFileAtPosition(m, c) REGVMETHOD(ArchiveDir, addFromFileAtPosition, c::m, (/*1Ab*/ArchiveDir & self, /*1Ab*/uint position, /*1Ab*/const char * name, /*1Ab*/File & input, /*1Ab*/FileStats & stats, /*1Ab*/ArchiveAddMode addMode, /*1Ab*/int compression, /*1Ab*/int * ratio, /*1Ab*/uint * newPosition), c, (/*4Im*/position, /*4Im*/name, /*4Im*/input, /*4Im*/stats, /*4Hm*/(ArchiveAddMode)addMode, /*4Im*/compression, /*4Im*/ratio, /*4Im*/newPosition))
#define REG_ArchiveDir_delete(m, c)                REGVMETHOD(ArchiveDir, delete,                c::m, (/*1Ab*/ArchiveDir & self, /*1Ab*/const char * fileName),                                                                                                                                                                        c, (/*4Im*/fileName))
#define REG_ArchiveDir_fileExists(m, c)            REGVMETHOD(ArchiveDir, fileExists,            c::m, (/*1Ab*/ArchiveDir & self, /*1Ab*/const char * fileName),                                                                                                                                                                        c, (/*4Im*/fileName))
#define REG_ArchiveDir_fileOpen(m, c)              REGVMETHOD(ArchiveDir, fileOpen,              c::m, (/*1Ab*/ArchiveDir & self, /*1Ab*/const char * fileName),                                                                                                                                                                        c, (/*4Im*/fileName))
#define REG_ArchiveDir_move(m, c)                  REGVMETHOD(ArchiveDir, move,                  c::m, (/*1Ab*/ArchiveDir & self, /*1Ab*/const char * name, /*1Ab*/ArchiveDir & to),                                                                                                                                                    c, (/*4Im*/name, /*4Im*/to))
#define REG_ArchiveDir_openDirectory(m, c)         REGVMETHOD(ArchiveDir, openDirectory,         c::m, (/*1Ab*/ArchiveDir & self, /*1Ab*/const char * name, /*1Ab*/FileStats & stats, /*1Ab*/ArchiveAddMode addMode),                                                                                                                   c, (/*4Im*/name, /*4Im*/stats, /*4Hm*/(ArchiveAddMode)addMode))
#define REG_ArchiveDir_rename(m, c)                REGVMETHOD(ArchiveDir, rename,                c::m, (/*1Ab*/ArchiveDir & self, /*1Ab*/const char * name, /*1Ab*/const char * newName),                                                                                                                                               c, (/*4Im*/name, /*4Im*/newName))

#define REG_ArchiveDir(c) \
      ArchiveDir::class_registration(_cpp_class); \
      REG_ArchiveDir_addFromFile(addFromFile, c); \
      REG_ArchiveDir_addFromFileAtPosition(addFromFileAtPosition, c); \
      REG_ArchiveDir_delete(delete, c); \
      REG_ArchiveDir_fileExists(fileExists, c); \
      REG_ArchiveDir_fileOpen(fileOpen, c); \
      REG_ArchiveDir_move(move, c); \
      REG_ArchiveDir_openDirectory(openDirectory, c); \
      REG_ArchiveDir_rename(rename, c);

#define ARCHIVEDIR_VIRTUAL_METHODS_PROTO(c) \
   VIRTUAL_METHOD_PROTO(addFromFile, addFromFile, c, ArchiveDir, \
      bool, c & _ARG, , /*6Fj*/const char * name _ARG /*6Fj*/File & input _ARG /*6Fj*/FileStats & stats _ARG /*6Fj*/ArchiveAddMode addMode _ARG /*6Fj*/int compression _ARG /*6Fj*/int * ratio _ARG /*6Fj*/uint * newPosition); \
   VIRTUAL_METHOD_PROTO(addFromFileAtPosition, addFromFileAtPosition, c, ArchiveDir, \
      bool, c & _ARG, , /*6Fj*/uint position _ARG /*6Fj*/const char * name _ARG /*6Fj*/File & input _ARG /*6Fj*/FileStats & stats _ARG /*6Fj*/ArchiveAddMode addMode _ARG /*6Fj*/int compression _ARG /*6Fj*/int * ratio _ARG /*6Fj*/uint * newPosition); \
   VIRTUAL_METHOD_PROTO(delete, delete_, c, ArchiveDir, \
      bool, c & _ARG, , /*6Fj*/const char * fileName); \
   VIRTUAL_METHOD_PROTO(fileExists, fileExists, c, ArchiveDir, \
      FileAttribs, c & _ARG, , /*6Fj*/const char * fileName); \
   VIRTUAL_METHOD_PROTO(fileOpen, fileOpen, c, ArchiveDir, \
      File *, c & _ARG, , /*6Fj*/const char * fileName); \
   VIRTUAL_METHOD_PROTO(move, move, c, ArchiveDir, \
      bool, c & _ARG, , /*6Fj*/const char * name _ARG /*6Fj*/ArchiveDir & to); \
   VIRTUAL_METHOD_PROTO(openDirectory, openDirectory, c, ArchiveDir, \
      ArchiveDir *, c & _ARG, , /*6Fj*/const char * name _ARG /*6Fj*/FileStats & stats _ARG /*6Fj*/ArchiveAddMode addMode); \
   VIRTUAL_METHOD_PROTO(rename, rename, c, ArchiveDir, \
      bool, c & _ARG, , /*6Fj*/const char * name _ARG /*6Fj*/const char * newName);

#define ARCHIVEDIR_VIRTUAL_METHODS(c) \
VIRTUAL_METHOD(addFromFile, addFromFile, c, ArchiveDir, \
   bool, c & _ARG, , /*6Fj*/const char * name _ARG /*6Fj*/File & input _ARG /*6Fj*/FileStats & stats _ARG /*6Fj*/ArchiveAddMode addMode _ARG /*6Fj*/int compression _ARG /*6Fj*/int * ratio _ARG /*6Fj*/uint * newPosition, \
   return (bool)ArchiveDir_addFromFile(self ? self->impl : (C(ArchiveDir))null, /*7Al*/name, /*7Al*/input.impl, /*7Al*/&stats.impl, /*7Al*/(C(ArchiveAddMode))addMode, /*7Al*/compression, /*7Al*/ratio, /*7Al*/newPosition);); \
VIRTUAL_METHOD(addFromFileAtPosition, addFromFileAtPosition, c, ArchiveDir, \
   bool, c & _ARG, , /*6Fj*/uint position _ARG /*6Fj*/const char * name _ARG /*6Fj*/File & input _ARG /*6Fj*/FileStats & stats _ARG /*6Fj*/ArchiveAddMode addMode _ARG /*6Fj*/int compression _ARG /*6Fj*/int * ratio _ARG /*6Fj*/uint * newPosition, \
   return (bool)ArchiveDir_addFromFileAtPosition(self ? self->impl : (C(ArchiveDir))null, /*7Al*/position, /*7Al*/name, /*7Al*/input.impl, /*7Al*/&stats.impl, /*7Al*/(C(ArchiveAddMode))addMode, /*7Al*/compression, /*7Al*/ratio, /*7Al*/newPosition);); \
VIRTUAL_METHOD(delete, delete_, c, ArchiveDir, \
   bool, c & _ARG, , /*6Fj*/const char * fileName, \
   return (bool)ArchiveDir_delete(self ? self->impl : (C(ArchiveDir))null, /*7Al*/fileName);); \
VIRTUAL_METHOD(fileExists, fileExists, c, ArchiveDir, \
   FileAttribs, c & _ARG, , /*6Fj*/const char * fileName, \
   return ArchiveDir_fileExists(self ? self->impl : (C(ArchiveDir))null, /*7Al*/fileName);); \
VIRTUAL_METHOD(fileOpen, fileOpen, c, ArchiveDir, \
   File *, c & _ARG, , /*6Fj*/const char * fileName, \
   C(File) retFile = ArchiveDir_fileOpen(self ? self->impl : (C(ArchiveDir))null, /*7Al*/fileName); \
      return BINDINGS_CLASS(retFile) ? (File *)INSTANCEL(retFile, retFile->_class) : (File *)0;); \
VIRTUAL_METHOD(move, move, c, ArchiveDir, \
   bool, c & _ARG, , /*6Fj*/const char * name _ARG /*6Fj*/ArchiveDir & to, \
   return (bool)ArchiveDir_move(self ? self->impl : (C(ArchiveDir))null, /*7Al*/name, /*7Al*/to.impl);); \
VIRTUAL_METHOD(openDirectory, openDirectory, c, ArchiveDir, \
   ArchiveDir *, c & _ARG, , /*6Fj*/const char * name _ARG /*6Fj*/FileStats & stats _ARG /*6Fj*/ArchiveAddMode addMode, \
   C(ArchiveDir) retArchiveDir = ArchiveDir_openDirectory(self ? self->impl : (C(ArchiveDir))null, /*7Al*/name, /*7Al*/&stats.impl, /*7Al*/(C(ArchiveAddMode))addMode); \
      return BINDINGS_CLASS(retArchiveDir) ? (ArchiveDir *)INSTANCEL(retArchiveDir, retArchiveDir->_class) : (ArchiveDir *)0;); \
VIRTUAL_METHOD(rename, rename, c, ArchiveDir, \
   bool, c & _ARG, , /*6Fj*/const char * name _ARG /*6Fj*/const char * newName, \
   return (bool)ArchiveDir_rename(self ? self->impl : (C(ArchiveDir))null, /*7Al*/name, /*7Al*/newName););

class ArchiveDir : public Instance
{
public:
   inline ArchiveDir(ArchiveDir && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline ArchiveDir & operator= (ArchiveDir && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   ArchiveDir() : ArchiveDir((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<ArchiveDir> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         ArchiveDir * inst = new ArchiveDir(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      ArchiveDir * inst = (ArchiveDir *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(ArchiveDir & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline ArchiveDir(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl) { }

   inline C(bool) add(/*1Ab*/const char * name, /*1Ab*/const char * path, /*1Ab*/ArchiveAddMode addMode, /*1Ab*/int compression, /*1Ab*/int * ratio, /*1Ab*/uint * newPosition); // ArchiveDir_add

   struct ArchiveDir_addFromFile_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(ArchiveDir & , /*6Fj*/const char * name, /*6Fj*/File & input, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode, /*6Fj*/int compression, /*6Fj*/int * ratio, /*6Fj*/uint * newPosition);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/const char * name, /*6Fj*/File & input, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode, /*6Fj*/int compression, /*6Fj*/int * ratio, /*6Fj*/uint * newPosition);
   } addFromFile;
   // inline static void register_addFromFile(CPPClass & cl, ArchiveDir::ArchiveDir_addFromFile_Functor::FunctionType func)

   struct ArchiveDir_addFromFileAtPosition_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(ArchiveDir & , /*6Fj*/uint position, /*6Fj*/const char * name, /*6Fj*/File & input, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode, /*6Fj*/int compression, /*6Fj*/int * ratio, /*6Fj*/uint * newPosition);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/uint position, /*6Fj*/const char * name, /*6Fj*/File & input, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode, /*6Fj*/int compression, /*6Fj*/int * ratio, /*6Fj*/uint * newPosition);
   } addFromFileAtPosition;
   // inline static void register_addFromFileAtPosition(CPPClass & cl, ArchiveDir::ArchiveDir_addFromFileAtPosition_Functor::FunctionType func)

   struct ArchiveDir_delete_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(ArchiveDir & , /*6Fj*/const char * fileName);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/const char * fileName);
   } delete_;
   // inline static void register_delete(CPPClass & cl, ArchiveDir::ArchiveDir_delete_Functor::FunctionType func)

   struct ArchiveDir_fileExists_Functor
   {
      [[no_unique_address]] int _[0];
      typedef FileAttribs (* FunctionType)(ArchiveDir & , /*6Fj*/const char * fileName);
      inline FunctionType operator= (FunctionType func);
      inline FileAttribs operator()( /*6Fj*/const char * fileName);
   } fileExists;
   // inline static void register_fileExists(CPPClass & cl, ArchiveDir::ArchiveDir_fileExists_Functor::FunctionType func)

   struct ArchiveDir_fileOpen_Functor
   {
      [[no_unique_address]] int _[0];
      typedef File * (* FunctionType)(ArchiveDir & , /*6Fj*/const char * fileName);
      inline FunctionType operator= (FunctionType func);
      inline File * operator()( /*6Fj*/const char * fileName);
   } fileOpen;
   // inline static void register_fileOpen(CPPClass & cl, ArchiveDir::ArchiveDir_fileOpen_Functor::FunctionType func)

   struct ArchiveDir_move_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(ArchiveDir & , /*6Fj*/const char * name, /*6Fj*/ArchiveDir & to);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/const char * name, /*6Fj*/ArchiveDir & to);
   } move;
   // inline static void register_move(CPPClass & cl, ArchiveDir::ArchiveDir_move_Functor::FunctionType func)

   struct ArchiveDir_openDirectory_Functor
   {
      [[no_unique_address]] int _[0];
      typedef ArchiveDir * (* FunctionType)(ArchiveDir & , /*6Fj*/const char * name, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode);
      inline FunctionType operator= (FunctionType func);
      inline ArchiveDir * operator()( /*6Fj*/const char * name, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode);
   } openDirectory;
   // inline static void register_openDirectory(CPPClass & cl, ArchiveDir::ArchiveDir_openDirectory_Functor::FunctionType func)

   struct ArchiveDir_rename_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(ArchiveDir & , /*6Fj*/const char * name, /*6Fj*/const char * newName);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( /*6Fj*/const char * name, /*6Fj*/const char * newName);
   } rename;
   // inline static void register_rename(CPPClass & cl, ArchiveDir::ArchiveDir_rename_Functor::FunctionType func)

   static void class_registration(CPPClass & _cpp_class);
};

class ErrorCode
{
public:
   C(ErrorCode) impl;
   constexpr ErrorCode() : impl(0) { }

   ErrorCode(GuiErrorCode impl) : impl((C(ErrorCode))impl) { }
   ErrorCode & operator =(GuiErrorCode impl) { this->impl = (C(ErrorCode))impl; return *this; }
   ErrorCode(SysErrorCode impl) : impl((C(ErrorCode))impl) { }
   ErrorCode & operator =(SysErrorCode impl) { this->impl = (C(ErrorCode))impl; return *this; }

   constexpr ErrorCode(C(ErrorCode) impl) : impl(impl) { }
   ErrorCode(ErrorLevel level, uint code);
   operator C(ErrorCode)() { return impl; }
   ErrorCode & operator =(C(ErrorCode) impl) { impl = impl; return *this; }
   bool operator ==(const ErrorCode & value) const { return impl == value.impl; }
   bool operator !=(const ErrorCode & value) const { return impl != value.impl; }

   struct level_Prop
   {
      constexpr level_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/ErrorLevel operator= (/*0H*/ErrorLevel v);
      /*regSet*/inline ErrorCode::level_Prop & operator= (ErrorCode::level_Prop & prop);
      /*regGet*/inline operator /*0I*/ErrorLevel () const;
   } level;
   struct code_Prop
   {
      constexpr code_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint operator= (/*0H*/uint v);
      /*regSet*/inline ErrorCode::code_Prop & operator= (ErrorCode::code_Prop & prop);
      /*regGet*/inline operator /*0I*/uint () const;
   } code;
};

#define REG_Archive_clear(m, c)              REGVMETHOD(Archive, clear,              c::m, (/*1Ab*/Archive & self),                                                                                      c, ())
#define REG_Archive_fileExists(m, c)         REGVMETHOD(Archive, fileExists,         c::m, (/*1Ab*/Archive & self, /*1Ab*/const char * fileName),                                                        c, (/*4Im*/fileName))
#define REG_Archive_fileOpen(m, c)           REGVMETHOD(Archive, fileOpen,           c::m, (/*1Ab*/Archive & self, /*1Ab*/const char * fileName),                                                        c, (/*4Im*/fileName))
#define REG_Archive_fileOpenAtPosition(m, c) REGVMETHOD(Archive, fileOpenAtPosition, c::m, (/*1Ab*/Archive & self, /*1Ab*/uint position),                                                                c, (/*4Im*/position))
#define REG_Archive_fileOpenCompressed(m, c) REGVMETHOD(Archive, fileOpenCompressed, c::m, (/*1Ab*/Archive & self, /*1Ab*/const char * fileName, /*1Ab*/C(bool) * isCompressed, /*1Ab*/uint64 * ucSize), c, (/*4Im*/fileName, /*4Hm*/(C(bool) *)isCompressed, /*4Im*/ucSize))
#define REG_Archive_openDirectory(m, c)      REGVMETHOD(Archive, openDirectory,      c::m, (/*1Ab*/Archive & self, /*1Ab*/const char * name, /*1Ab*/FileStats & stats, /*1Ab*/ArchiveAddMode addMode),   c, (/*4Im*/name, /*4Im*/stats, /*4Hm*/(ArchiveAddMode)addMode))
#define REG_Archive_setBufferRead(m, c)      REGVMETHOD(Archive, setBufferRead,      c::m, (/*1Ab*/Archive & self, /*1Ab*/uint bufferRead),                                                              c, (/*4Im*/bufferRead))
#define REG_Archive_setBufferSize(m, c)      REGVMETHOD(Archive, setBufferSize,      c::m, (/*1Ab*/Archive & self, /*1Ab*/uint bufferSize),                                                              c, (/*4Im*/bufferSize))

#define REG_Archive(c) \
      Archive::class_registration(_cpp_class); \
      REG_Archive_clear(clear, c); \
      REG_Archive_fileExists(fileExists, c); \
      REG_Archive_fileOpen(fileOpen, c); \
      REG_Archive_fileOpenAtPosition(fileOpenAtPosition, c); \
      REG_Archive_fileOpenCompressed(fileOpenCompressed, c); \
      REG_Archive_openDirectory(openDirectory, c); \
      REG_Archive_setBufferRead(setBufferRead, c); \
      REG_Archive_setBufferSize(setBufferSize, c);

#define ARCHIVE_VIRTUAL_METHODS_PROTO(c) \
   VIRTUAL_METHOD_PROTO(clear, clear, c, Archive, \
      bool, c &, , ); \
   VIRTUAL_METHOD_PROTO(fileExists, fileExists, c, Archive, \
      FileAttribs, c & _ARG, , /*6Fj*/const char * fileName); \
   VIRTUAL_METHOD_PROTO(fileOpen, fileOpen, c, Archive, \
      File *, c & _ARG, , /*6Fj*/const char * fileName); \
   VIRTUAL_METHOD_PROTO(fileOpenAtPosition, fileOpenAtPosition, c, Archive, \
      File *, c & _ARG, , /*6Fj*/uint position); \
   VIRTUAL_METHOD_PROTO(fileOpenCompressed, fileOpenCompressed, c, Archive, \
      File *, c & _ARG, , /*6Fj*/const char * fileName _ARG /*6Cj*/C(bool) * isCompressed _ARG /*6Fj*/uint64 * ucSize); \
   VIRTUAL_METHOD_PROTO(openDirectory, openDirectory, c, Archive, \
      ArchiveDir *, c & _ARG, , /*6Fj*/const char * name _ARG /*6Fj*/FileStats & stats _ARG /*6Fj*/ArchiveAddMode addMode); \
   VIRTUAL_METHOD_PROTO(setBufferRead, setBufferRead, c, Archive, \
      void, c & _ARG, , /*6Fj*/uint bufferRead); \
   VIRTUAL_METHOD_PROTO(setBufferSize, setBufferSize, c, Archive, \
      void, c & _ARG, , /*6Fj*/uint bufferSize);

#define ARCHIVE_VIRTUAL_METHODS(c) \
VIRTUAL_METHOD(clear, clear, c, Archive, \
   bool, c &, , , \
   return (bool)Archive_clear(self ? self->impl : (C(Archive))null);); \
VIRTUAL_METHOD(fileExists, fileExists, c, Archive, \
   FileAttribs, c & _ARG, , /*6Fj*/const char * fileName, \
   return Archive_fileExists(self ? self->impl : (C(Archive))null, /*7Al*/fileName);); \
VIRTUAL_METHOD(fileOpen, fileOpen, c, Archive, \
   File *, c & _ARG, , /*6Fj*/const char * fileName, \
   C(File) retFile = Archive_fileOpen(self ? self->impl : (C(Archive))null, /*7Al*/fileName); \
      return BINDINGS_CLASS(retFile) ? (File *)INSTANCEL(retFile, retFile->_class) : (File *)0;); \
VIRTUAL_METHOD(fileOpenAtPosition, fileOpenAtPosition, c, Archive, \
   File *, c & _ARG, , /*6Fj*/uint position, \
   C(File) retFile = Archive_fileOpenAtPosition(self ? self->impl : (C(Archive))null, /*7Al*/position); \
      return BINDINGS_CLASS(retFile) ? (File *)INSTANCEL(retFile, retFile->_class) : (File *)0;); \
VIRTUAL_METHOD(fileOpenCompressed, fileOpenCompressed, c, Archive, \
   File *, c & _ARG, , /*6Fj*/const char * fileName _ARG /*6Cj*/C(bool) * isCompressed _ARG /*6Fj*/uint64 * ucSize, \
   C(File) retFile = Archive_fileOpenCompressed(self ? self->impl : (C(Archive))null, /*7Al*/fileName, /*7Al*/isCompressed, /*7Al*/ucSize); \
      return BINDINGS_CLASS(retFile) ? (File *)INSTANCEL(retFile, retFile->_class) : (File *)0;); \
VIRTUAL_METHOD(openDirectory, openDirectory, c, Archive, \
   ArchiveDir *, c & _ARG, , /*6Fj*/const char * name _ARG /*6Fj*/FileStats & stats _ARG /*6Fj*/ArchiveAddMode addMode, \
   C(ArchiveDir) retArchiveDir = Archive_openDirectory(self ? self->impl : (C(Archive))null, /*7Al*/name, /*7Al*/&stats.impl, /*7Al*/(C(ArchiveAddMode))addMode); \
      return BINDINGS_CLASS(retArchiveDir) ? (ArchiveDir *)INSTANCEL(retArchiveDir, retArchiveDir->_class) : (ArchiveDir *)0;); \
VIRTUAL_METHOD(setBufferRead, setBufferRead, c, Archive, \
   void, c & _ARG, , /*6Fj*/uint bufferRead, \
   Archive_setBufferRead(self ? self->impl : (C(Archive))null, /*7Al*/bufferRead);); \
VIRTUAL_METHOD(setBufferSize, setBufferSize, c, Archive, \
   void, c & _ARG, , /*6Fj*/uint bufferSize, \
   Archive_setBufferSize(self ? self->impl : (C(Archive))null, /*7Al*/bufferSize););

class Archive : public Instance
{
public:
   inline Archive(Archive && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline Archive & operator= (Archive && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   Archive() : Archive((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<Archive> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         Archive * inst = new Archive(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      Archive * inst = (Archive *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(Archive & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline Archive(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl) { }

   struct Archive_clear_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Archive &);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()( );
   } clear;
   // inline static void register_clear(CPPClass & cl, Archive::Archive_clear_Functor::FunctionType func)

   struct Archive_fileExists_Functor
   {
      [[no_unique_address]] int _[0];
      typedef FileAttribs (* FunctionType)(Archive & , /*6Fj*/const char * fileName);
      inline FunctionType operator= (FunctionType func);
      inline FileAttribs operator()( /*6Fj*/const char * fileName);
   } fileExists;
   // inline static void register_fileExists(CPPClass & cl, Archive::Archive_fileExists_Functor::FunctionType func)

   struct Archive_fileOpen_Functor
   {
      [[no_unique_address]] int _[0];
      typedef File * (* FunctionType)(Archive & , /*6Fj*/const char * fileName);
      inline FunctionType operator= (FunctionType func);
      inline File * operator()( /*6Fj*/const char * fileName);
   } fileOpen;
   // inline static void register_fileOpen(CPPClass & cl, Archive::Archive_fileOpen_Functor::FunctionType func)

   struct Archive_fileOpenAtPosition_Functor
   {
      [[no_unique_address]] int _[0];
      typedef File * (* FunctionType)(Archive & , /*6Fj*/uint position);
      inline FunctionType operator= (FunctionType func);
      inline File * operator()( /*6Fj*/uint position);
   } fileOpenAtPosition;
   // inline static void register_fileOpenAtPosition(CPPClass & cl, Archive::Archive_fileOpenAtPosition_Functor::FunctionType func)

   struct Archive_fileOpenCompressed_Functor
   {
      [[no_unique_address]] int _[0];
      typedef File * (* FunctionType)(Archive & , /*6Fj*/const char * fileName, /*6Cj*/C(bool) * isCompressed, /*6Fj*/uint64 * ucSize);
      inline FunctionType operator= (FunctionType func);
      inline File * operator()( /*6Fj*/const char * fileName, /*6Cj*/C(bool) * isCompressed, /*6Fj*/uint64 * ucSize);
   } fileOpenCompressed;
   // inline static void register_fileOpenCompressed(CPPClass & cl, Archive::Archive_fileOpenCompressed_Functor::FunctionType func)

   struct Archive_openDirectory_Functor
   {
      [[no_unique_address]] int _[0];
      typedef ArchiveDir * (* FunctionType)(Archive & , /*6Fj*/const char * name, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode);
      inline FunctionType operator= (FunctionType func);
      inline ArchiveDir * operator()( /*6Fj*/const char * name, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode);
   } openDirectory;
   // inline static void register_openDirectory(CPPClass & cl, Archive::Archive_openDirectory_Functor::FunctionType func)

   struct Archive_setBufferRead_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Archive & , /*6Fj*/uint bufferRead);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( /*6Fj*/uint bufferRead);
   } setBufferRead;
   // inline static void register_setBufferRead(CPPClass & cl, Archive::Archive_setBufferRead_Functor::FunctionType func)

   struct Archive_setBufferSize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Archive & , /*6Fj*/uint bufferSize);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( /*6Fj*/uint bufferSize);
   } setBufferSize;
   // inline static void register_setBufferSize(CPPClass & cl, Archive::Archive_setBufferSize_Functor::FunctionType func)

   static void class_registration(CPPClass & _cpp_class);

   inline Archive(FileSize totalSize, uint bufferSize, uint bufferRead);

   struct totalSize_Prop
   {
      constexpr totalSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/FileSize operator= (/*0H*/FileSize v);
      /*regSet*/inline Archive::totalSize_Prop & operator= (Archive::totalSize_Prop & prop);
      /*regGet*/inline operator /*0I*/FileSize () const;
      /*regGet*/inline operator /*0J*/C(FileSize) () const;
   } totalSize;
   struct bufferSize_Prop
   {
      constexpr bufferSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0G*/uint operator= (/*0G*/uint v);
   } bufferSize;
   struct bufferRead_Prop
   {
      constexpr bufferRead_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0G*/uint operator= (/*0G*/uint v);
   } bufferRead;
};

enum class ArchiveAddMode : int
{
   replace = ArchiveAddMode_replace,
   refresh = ArchiveAddMode_refresh,
   update = ArchiveAddMode_update,
   readOnlyDir = ArchiveAddMode_readOnlyDir
};

class ArchiveOpenFlags
{
public:
   C(ArchiveOpenFlags) impl;
   constexpr ArchiveOpenFlags() : impl(0) { }
   constexpr ArchiveOpenFlags(C(ArchiveOpenFlags) impl) : impl(impl) { }
   ArchiveOpenFlags(bool writeAccess, bool buffered, bool exclusive, bool waitLock);
   operator C(ArchiveOpenFlags)() { return impl; }
   ArchiveOpenFlags & operator =(C(ArchiveOpenFlags) impl) { impl = impl; return *this; }
   bool operator ==(const ArchiveOpenFlags & value) const { return impl == value.impl; }
   bool operator !=(const ArchiveOpenFlags & value) const { return impl != value.impl; }

   struct writeAccess_Prop
   {
      constexpr writeAccess_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline ArchiveOpenFlags::writeAccess_Prop & operator= (ArchiveOpenFlags::writeAccess_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } writeAccess;
   struct buffered_Prop
   {
      constexpr buffered_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline ArchiveOpenFlags::buffered_Prop & operator= (ArchiveOpenFlags::buffered_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } buffered;
   struct exclusive_Prop
   {
      constexpr exclusive_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline ArchiveOpenFlags::exclusive_Prop & operator= (ArchiveOpenFlags::exclusive_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } exclusive;
   struct waitLock_Prop
   {
      constexpr waitLock_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline ArchiveOpenFlags::waitLock_Prop & operator= (ArchiveOpenFlags::waitLock_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } waitLock;
};


#define REG_BufferedFile(c) \
      BufferedFile::class_registration(_cpp_class); \
      REG_IOChannel_readData(readData, c); \
      REG_IOChannel_writeData(writeData, c); \
      REG_File_close(close, c); \
      REG_File_closeInput(closeInput, c); \
      REG_File_closeOutput(closeOutput, c); \
      REG_File_eof(eof, c); \
      REG_File_getSize(getSize, c); \
      REG_File_getc(getc, c); \
      REG_File_lock(lock, c); \
      REG_File_putc(putc, c); \
      REG_File_puts(puts, c); \
      REG_File_read(read, c); \
      REG_File_seek(seek, c); \
      REG_File_tell(tell, c); \
      REG_File_truncate(truncate, c); \
      REG_File_unlock(unlock, c); \
      REG_File_write(write, c);

#define BUFFEREDFILE_VIRTUAL_METHODS_PROTO(c) \

#define BUFFEREDFILE_VIRTUAL_METHODS(c) \

class BufferedFile : public File
{
public:
   inline BufferedFile(BufferedFile && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline BufferedFile & operator= (BufferedFile && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   BufferedFile() : BufferedFile((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<BufferedFile> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         BufferedFile * inst = new BufferedFile(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      BufferedFile * inst = (BufferedFile *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(BufferedFile & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline BufferedFile(C(Instance) _impl, CPPClass & cl = _cpp_class) : File(_impl, cl) { }

   static void class_registration(CPPClass & _cpp_class);

   struct handle_Prop
   {
      constexpr handle_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0A*/const File & operator= (/*0A*/const File & v);
      /*regSet*/inline BufferedFile::handle_Prop & operator= (BufferedFile::handle_Prop & prop);
      /*nstSet*/inline /*0C*/const File * operator= (/*0C*/const File * v);
      /*regGet*/inline operator /*0B*/TIH<File> () const;
      /*regGet*/inline TIH<File> operator /*0D*/-> () const;
      /*regGet*/inline operator /*0E*/File () const;
      /*regGet*/inline operator /*0F*/File* () const;
   } handle;
   struct bufferSize_Prop
   {
      constexpr bufferSize_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uintsize operator= (/*0H*/uintsize v);
      /*regSet*/inline BufferedFile::bufferSize_Prop & operator= (BufferedFile::bufferSize_Prop & prop);
      /*regGet*/inline operator /*0I*/uintsize () const;
   } bufferSize;
   struct bufferRead_Prop
   {
      constexpr bufferRead_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uintsize operator= (/*0H*/uintsize v);
      /*regSet*/inline BufferedFile::bufferRead_Prop & operator= (BufferedFile::bufferRead_Prop & prop);
      /*regGet*/inline operator /*0I*/uintsize () const;
   } bufferRead;
};


#define REG_ConsoleFile(c) \
      ConsoleFile::class_registration(_cpp_class); \
      REG_IOChannel_readData(readData, c); \
      REG_IOChannel_writeData(writeData, c); \
      REG_File_close(close, c); \
      REG_File_closeInput(closeInput, c); \
      REG_File_closeOutput(closeOutput, c); \
      REG_File_eof(eof, c); \
      REG_File_getSize(getSize, c); \
      REG_File_getc(getc, c); \
      REG_File_lock(lock, c); \
      REG_File_putc(putc, c); \
      REG_File_puts(puts, c); \
      REG_File_read(read, c); \
      REG_File_seek(seek, c); \
      REG_File_tell(tell, c); \
      REG_File_truncate(truncate, c); \
      REG_File_unlock(unlock, c); \
      REG_File_write(write, c);

#define CONSOLEFILE_VIRTUAL_METHODS_PROTO(c) \

#define CONSOLEFILE_VIRTUAL_METHODS(c) \

class ConsoleFile : public File
{
public:
   inline ConsoleFile(ConsoleFile && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline ConsoleFile & operator= (ConsoleFile && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   ConsoleFile() : ConsoleFile((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<ConsoleFile> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         ConsoleFile * inst = new ConsoleFile(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      ConsoleFile * inst = (ConsoleFile *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(ConsoleFile & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline ConsoleFile(C(Instance) _impl, CPPClass & cl = _cpp_class) : File(_impl, cl) { }

   static void class_registration(CPPClass & _cpp_class);
};


#define REG_DualPipe(c) \
      DualPipe::class_registration(_cpp_class); \
      REG_IOChannel_readData(readData, c); \
      REG_IOChannel_writeData(writeData, c); \
      REG_File_close(close, c); \
      REG_File_closeInput(closeInput, c); \
      REG_File_closeOutput(closeOutput, c); \
      REG_File_eof(eof, c); \
      REG_File_getSize(getSize, c); \
      REG_File_getc(getc, c); \
      REG_File_lock(lock, c); \
      REG_File_putc(putc, c); \
      REG_File_puts(puts, c); \
      REG_File_read(read, c); \
      REG_File_seek(seek, c); \
      REG_File_tell(tell, c); \
      REG_File_truncate(truncate, c); \
      REG_File_unlock(unlock, c); \
      REG_File_write(write, c);

#define DUALPIPE_VIRTUAL_METHODS_PROTO(c) \

#define DUALPIPE_VIRTUAL_METHODS(c) \

class DualPipe : public File
{
public:
   inline DualPipe(DualPipe && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline DualPipe & operator= (DualPipe && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   DualPipe() : DualPipe((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<DualPipe> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         DualPipe * inst = new DualPipe(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      DualPipe * inst = (DualPipe *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(DualPipe & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline DualPipe(C(Instance) _impl, CPPClass & cl = _cpp_class) : File(_impl, cl) { }

   inline int getExitCode(); // DualPipe_getExitCode
   inline C(bool) getLinePeek(/*1Ab*/char * s, /*1Ab*/int max, /*1Ab*/int * charsRead); // DualPipe_getLinePeek
   inline int getProcessID(); // DualPipe_getProcessID
   inline C(bool) peek(); // DualPipe_peek
   inline void terminate(); // DualPipe_terminate
   inline void wait(); // DualPipe_wait

   static void class_registration(CPPClass & _cpp_class);
};

enum class ErrorLevel : int
{
   veryFatal = ErrorLevel_veryFatal,
   fatal = ErrorLevel_fatal,
   major = ErrorLevel_major,
   minor = ErrorLevel_minor
};

class FileChange
{
public:
   C(FileChange) impl;
   constexpr FileChange() : impl(0) { }
   constexpr FileChange(C(FileChange) impl) : impl(impl) { }
   FileChange(bool created, bool renamed, bool modified, bool deleted, bool attribs);
   operator C(FileChange)() { return impl; }
   FileChange & operator =(C(FileChange) impl) { impl = impl; return *this; }
   bool operator ==(const FileChange & value) const { return impl == value.impl; }
   bool operator !=(const FileChange & value) const { return impl != value.impl; }

   struct created_Prop
   {
      constexpr created_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileChange::created_Prop & operator= (FileChange::created_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } created;
   struct renamed_Prop
   {
      constexpr renamed_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileChange::renamed_Prop & operator= (FileChange::renamed_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } renamed;
   struct modified_Prop
   {
      constexpr modified_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileChange::modified_Prop & operator= (FileChange::modified_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } modified;
   struct deleted_Prop
   {
      constexpr deleted_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileChange::deleted_Prop & operator= (FileChange::deleted_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } deleted;
   struct attribs_Prop
   {
      constexpr attribs_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline FileChange::attribs_Prop & operator= (FileChange::attribs_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } attribs;
};

struct FileListing : public TStruct<FileListing>
{
public:
   C(FileListing) impl;
   constexpr FileListing() : impl({}) { }
   constexpr FileListing(const C(FileListing) impl) : impl(impl) { }

   inline C(bool) find(); // FileListing_find
   inline void stop(); // FileListing_stop

   inline FileListing(const char * directory, const char * extensions);

   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   struct path_Prop
   {
      constexpr path_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/const char * () const;
   } path;
   struct stats_Prop
   {
      constexpr stats_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/FileStats () const;
   } stats;

   struct directory_Prop
   {
      constexpr directory_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline FileListing::directory_Prop & operator= (FileListing::directory_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } directory;
   struct extensions_Prop
   {
      constexpr extensions_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline FileListing::extensions_Prop & operator= (FileListing::extensions_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } extensions;
};

enum class FileLock : int
{
   unlocked = FileLock_unlocked,
   shared = FileLock_shared,
   exclusive = FileLock_exclusive
};

#define REG_FileMonitor_onDirNotify(m, c)  REGVMETHOD(FileMonitor, onDirNotify,  c::m, (/*1Ab*/any_object self, /*1Ab*/FileChange action, /*1Ab*/const char * fileName, /*1Ab*/const char * param), c, (/*4Im*/self, /*4Hm*/(FileChange)action, /*4Im*/fileName, /*4Im*/param))
#define REG_FileMonitor_onFileNotify(m, c) REGVMETHOD(FileMonitor, onFileNotify, c::m, (/*1Ab*/any_object self, /*1Ab*/FileChange action, /*1Ab*/const char * param),                               c, (/*4Im*/self, /*4Hm*/(FileChange)action, /*4Im*/param))

#define REG_FileMonitor(c) \
      FileMonitor::class_registration(_cpp_class); \
      REG_FileMonitor_onDirNotify(onDirNotify, c); \
      REG_FileMonitor_onFileNotify(onFileNotify, c);

#define FILEMONITOR_VIRTUAL_METHODS_PROTO(c) \
   VIRTUAL_METHOD_PROTO(onDirNotify, onDirNotify, c, FileMonitor, \
      bool, any_object _ARG, /*6Fk*/any_object o_ _ARG, /*6Fj*/FileChange action _ARG /*6Fj*/const char * fileName _ARG /*6Fj*/const char * param); \
   VIRTUAL_METHOD_PROTO(onFileNotify, onFileNotify, c, FileMonitor, \
      bool, any_object _ARG, /*6Fk*/any_object o_ _ARG, /*6Fj*/FileChange action _ARG /*6Fj*/const char * param);

#define FILEMONITOR_VIRTUAL_METHODS(c) \
VIRTUAL_METHOD(onDirNotify, onDirNotify, c, FileMonitor, \
   bool, any_object _ARG, /*6Fk*/any_object o_ _ARG, /*6Fj*/FileChange action _ARG /*6Fj*/const char * fileName _ARG /*6Fj*/const char * param, \
   return (bool)FileMonitor_onDirNotify(self ? self->impl : (C(FileMonitor))null, o_, /*7Al*/(C(FileChange))action, /*7Al*/fileName, /*7Al*/param);); \
VIRTUAL_METHOD(onFileNotify, onFileNotify, c, FileMonitor, \
   bool, any_object _ARG, /*6Fk*/any_object o_ _ARG, /*6Fj*/FileChange action _ARG /*6Fj*/const char * param, \
   return (bool)FileMonitor_onFileNotify(self ? self->impl : (C(FileMonitor))null, o_, /*7Al*/(C(FileChange))action, /*7Al*/param););

class FileMonitor : public Instance
{
public:
   inline FileMonitor(FileMonitor && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline FileMonitor & operator= (FileMonitor && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   FileMonitor() : FileMonitor((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { FileMonitor_set_userData(this->impl, this); }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<FileMonitor> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         FileMonitor * inst = new FileMonitor(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      FileMonitor * inst = (FileMonitor *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(FileMonitor & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline FileMonitor(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl) { }

   inline void startMonitoring(); // FileMonitor_startMonitoring
   inline void stopMonitoring(); // FileMonitor_stopMonitoring

   struct FileMonitor_onDirNotify_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(any_object , /*6Fj*/FileChange action, /*6Fj*/const char * fileName, /*6Fj*/const char * param);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Fk*/any_object o_ , /*6Fj*/FileChange action, /*6Fj*/const char * fileName, /*6Fj*/const char * param);
   } onDirNotify;
   // inline static void register_onDirNotify(CPPClass & cl, FileMonitor::FileMonitor_onDirNotify_Functor::FunctionType func)

   struct FileMonitor_onFileNotify_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(any_object , /*6Fj*/FileChange action, /*6Fj*/const char * param);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Fk*/any_object o_ , /*6Fj*/FileChange action, /*6Fj*/const char * param);
   } onFileNotify;
   // inline static void register_onFileNotify(CPPClass & cl, FileMonitor::FileMonitor_onFileNotify_Functor::FunctionType func)

   static void class_registration(CPPClass & _cpp_class);

   inline FileMonitor(void * userData, FileChange fileChange, const char * fileName, const char * directoryName);

private:
   void * _userData;
public:

   struct userData_Prop
   {
      constexpr userData_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0G*/void * operator= (/*0G*/void * v);
   } userData;
   struct fileChange_Prop
   {
      constexpr fileChange_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0G*/FileChange operator= (/*0G*/FileChange v);
   } fileChange;
   struct fileName_Prop
   {
      constexpr fileName_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline FileMonitor::fileName_Prop & operator= (FileMonitor::fileName_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } fileName;
   struct directoryName_Prop
   {
      constexpr directoryName_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline FileMonitor::directoryName_Prop & operator= (FileMonitor::directoryName_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } directoryName;
};

enum class FileOpenMode : int
{
   read = FileOpenMode_read,
   write = FileOpenMode_write,
   append = FileOpenMode_append,
   readWrite = FileOpenMode_readWrite,
   writeRead = FileOpenMode_writeRead,
   appendRead = FileOpenMode_appendRead
};

enum class FileSeekMode : int
{
   start = FileSeekMode_start,
   current = FileSeekMode_current,
   end = FileSeekMode_end
};

class FileSize
{
public:
   C(FileSize) impl;
   constexpr FileSize() : impl(0) { }
   constexpr FileSize(C(FileSize) value) : impl(value) { }
   operator C(FileSize)() const { return impl; }
   constexpr FileSize(const FileSize & value) : impl(value.impl) { }
   FileSize & operator =(uint value) { impl = value; return *this; }
   FileSize & operator +=(FileSize value) { impl += value.impl; return *this; }
   FileSize & operator -=(FileSize value) { impl -= value.impl; return *this; }
   FileSize operator +(const FileSize & b) const { return FileSize(impl + b.impl); }
   FileSize operator -(const FileSize & b) const { return FileSize(impl - b.impl); }
   bool operator ==(const FileSize & value) const { return impl == value.impl; }
   bool operator !=(const FileSize & value) const { return impl != value.impl; }
   bool operator <(const FileSize & value) const { return impl < value.impl; }
   bool operator >(const FileSize & value) const { return impl > value.impl; }
   bool operator <=(const FileSize & value) const { return impl <= value.impl; }
   bool operator >=(const FileSize & value) const { return impl >= value.impl; }
   bool operator ==(uint value) const { return impl == FileSize(value).impl; }
   bool operator !=(uint value) const { return impl != FileSize(value).impl; }
   bool operator <(uint value) const { return impl < FileSize(value).impl; }
   bool operator >(uint value) const { return impl > FileSize(value).impl; }
   bool operator <=(uint value) const { return impl <= FileSize(value).impl; }
   bool operator >=(uint value) const { return impl >= FileSize(value).impl; }
};

class FileSize64
{
public:
   C(FileSize64) impl;
   constexpr FileSize64() : impl(0) { }
   constexpr FileSize64(C(FileSize64) value) : impl(value) { }
   operator C(FileSize64)() const { return impl; }
   constexpr FileSize64(const FileSize64 & value) : impl(value.impl) { }
   FileSize64 & operator =(uint64 value) { impl = value; return *this; }
   FileSize64 & operator +=(FileSize64 value) { impl += value.impl; return *this; }
   FileSize64 & operator -=(FileSize64 value) { impl -= value.impl; return *this; }
   FileSize64 operator +(const FileSize64 & b) const { return FileSize64(impl + b.impl); }
   FileSize64 operator -(const FileSize64 & b) const { return FileSize64(impl - b.impl); }
   bool operator ==(const FileSize64 & value) const { return impl == value.impl; }
   bool operator !=(const FileSize64 & value) const { return impl != value.impl; }
   bool operator <(const FileSize64 & value) const { return impl < value.impl; }
   bool operator >(const FileSize64 & value) const { return impl > value.impl; }
   bool operator <=(const FileSize64 & value) const { return impl <= value.impl; }
   bool operator >=(const FileSize64 & value) const { return impl >= value.impl; }
   bool operator ==(uint64 value) const { return impl == FileSize64(value).impl; }
   bool operator !=(uint64 value) const { return impl != FileSize64(value).impl; }
   bool operator <(uint64 value) const { return impl < FileSize64(value).impl; }
   bool operator >(uint64 value) const { return impl > FileSize64(value).impl; }
   bool operator <=(uint64 value) const { return impl <= FileSize64(value).impl; }
   bool operator >=(uint64 value) const { return impl >= FileSize64(value).impl; }
};

struct FileStats : public TStruct<FileStats>
{
public:
   C(FileStats) impl;
   constexpr FileStats() : impl({}) { }
   constexpr FileStats(const C(FileStats) impl) : impl(impl) { }

   inline FileStats(FileAttribs attribs, uint64 size, SecSince1970 accessed, SecSince1970 modified, SecSince1970 created);

   struct attribs_Prop
   {
      constexpr attribs_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/FileAttribs operator= (/*0H*/FileAttribs v);
      /*regSet*/inline FileStats::attribs_Prop & operator= (FileStats::attribs_Prop & prop);
      /*regGet*/inline operator /*0I*/FileAttribs () const;
   } attribs;
   struct size_Prop
   {
      constexpr size_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uint64 operator= (/*0H*/uint64 v);
      /*regSet*/inline FileStats::size_Prop & operator= (FileStats::size_Prop & prop);
      /*regGet*/inline operator /*0I*/uint64 () const;
   } size;
   struct accessed_Prop
   {
      constexpr accessed_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/SecSince1970 operator= (/*0H*/SecSince1970 v);
      /*regSet*/inline FileStats::accessed_Prop & operator= (FileStats::accessed_Prop & prop);
      /*regGet*/inline operator /*0I*/SecSince1970 () const;
      /*regGet*/inline operator /*0J*/C(SecSince1970) () const;
   } accessed;
   struct modified_Prop
   {
      constexpr modified_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/SecSince1970 operator= (/*0H*/SecSince1970 v);
      /*regSet*/inline FileStats::modified_Prop & operator= (FileStats::modified_Prop & prop);
      /*regGet*/inline operator /*0I*/SecSince1970 () const;
      /*regGet*/inline operator /*0J*/C(SecSince1970) () const;
   } modified;
   struct created_Prop
   {
      constexpr created_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/SecSince1970 operator= (/*0H*/SecSince1970 v);
      /*regSet*/inline FileStats::created_Prop & operator= (FileStats::created_Prop & prop);
      /*regGet*/inline operator /*0I*/SecSince1970 () const;
      /*regGet*/inline operator /*0J*/C(SecSince1970) () const;
   } created;
};

enum class GuiErrorCode : uint
{
   driverNotSupported = GuiErrorCode_driverNotSupported,
   windowCreationFailed = GuiErrorCode_windowCreationFailed,
   graphicsLoadingFailed = GuiErrorCode_graphicsLoadingFailed,
   modeSwitchFailed = GuiErrorCode_modeSwitchFailed
};

enum class LoggingMode : int
{
   noLogging = LoggingMode_noLogging,
   stdOut = LoggingMode_stdOut,
   stdErr = LoggingMode_stdErr,
   debug = LoggingMode_debug,
   logFile = LoggingMode_logFile,
   msgBox = LoggingMode_msgBox,
   buffer = LoggingMode_buffer
};

class MoveFileOptions
{
public:
   C(MoveFileOptions) impl;
   constexpr MoveFileOptions() : impl(0) { }
   constexpr MoveFileOptions(C(MoveFileOptions) impl) : impl(impl) { }
   MoveFileOptions(bool overwrite, bool sync);
   operator C(MoveFileOptions)() { return impl; }
   MoveFileOptions & operator =(C(MoveFileOptions) impl) { impl = impl; return *this; }
   bool operator ==(const MoveFileOptions & value) const { return impl == value.impl; }
   bool operator !=(const MoveFileOptions & value) const { return impl != value.impl; }

   struct overwrite_Prop
   {
      constexpr overwrite_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline MoveFileOptions::overwrite_Prop & operator= (MoveFileOptions::overwrite_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } overwrite;
   struct sync_Prop
   {
      constexpr sync_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline MoveFileOptions::sync_Prop & operator= (MoveFileOptions::sync_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } sync;
};

class PipeOpenMode
{
public:
   C(PipeOpenMode) impl;
   constexpr PipeOpenMode() : impl(0) { }
   constexpr PipeOpenMode(C(PipeOpenMode) impl) : impl(impl) { }
   PipeOpenMode(bool output, bool error, bool input, bool showWindow);
   operator C(PipeOpenMode)() { return impl; }
   PipeOpenMode & operator =(C(PipeOpenMode) impl) { impl = impl; return *this; }
   bool operator ==(const PipeOpenMode & value) const { return impl == value.impl; }
   bool operator !=(const PipeOpenMode & value) const { return impl != value.impl; }

   struct output_Prop
   {
      constexpr output_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline PipeOpenMode::output_Prop & operator= (PipeOpenMode::output_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } output;
   struct error_Prop
   {
      constexpr error_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline PipeOpenMode::error_Prop & operator= (PipeOpenMode::error_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } error;
   struct input_Prop
   {
      constexpr input_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline PipeOpenMode::input_Prop & operator= (PipeOpenMode::input_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } input;
   struct showWindow_Prop
   {
      constexpr showWindow_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline PipeOpenMode::showWindow_Prop & operator= (PipeOpenMode::showWindow_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } showWindow;
};

enum class SysErrorCode : uint
{
   allocationFailed = SysErrorCode_allocationFailed,
   nameInexistant = SysErrorCode_nameInexistant,
   nameExists = SysErrorCode_nameExists,
   missingLibrary = SysErrorCode_missingLibrary,
   fileNotFound = SysErrorCode_fileNotFound,
   writeFailed = SysErrorCode_writeFailed
};


#define REG_TempFile(c) \
      TempFile::class_registration(_cpp_class); \
      REG_IOChannel_readData(readData, c); \
      REG_IOChannel_writeData(writeData, c); \
      REG_File_close(close, c); \
      REG_File_closeInput(closeInput, c); \
      REG_File_closeOutput(closeOutput, c); \
      REG_File_eof(eof, c); \
      REG_File_getSize(getSize, c); \
      REG_File_getc(getc, c); \
      REG_File_lock(lock, c); \
      REG_File_putc(putc, c); \
      REG_File_puts(puts, c); \
      REG_File_read(read, c); \
      REG_File_seek(seek, c); \
      REG_File_tell(tell, c); \
      REG_File_truncate(truncate, c); \
      REG_File_unlock(unlock, c); \
      REG_File_write(write, c);

#define TEMPFILE_VIRTUAL_METHODS_PROTO(c) \

#define TEMPFILE_VIRTUAL_METHODS(c) \

class TempFile : public File
{
public:
   inline TempFile(TempFile && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline TempFile & operator= (TempFile && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   TempFile() : TempFile((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<TempFile> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         TempFile * inst = new TempFile(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      TempFile * inst = (TempFile *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(TempFile & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline TempFile(C(Instance) _impl, CPPClass & cl = _cpp_class) : File(_impl, cl) { }

   inline byte * stealBuffer(); // TempFile_stealBuffer

   static void class_registration(CPPClass & _cpp_class);

   inline TempFile(FileOpenMode openMode, unsigned char * buffer, uintsize size, uintsize allocated);

   struct openMode_Prop
   {
      constexpr openMode_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/FileOpenMode operator= (/*0H*/FileOpenMode v);
      /*regSet*/inline TempFile::openMode_Prop & operator= (TempFile::openMode_Prop & prop);
      /*regGet*/inline operator /*0I*/FileOpenMode () const;
   } openMode;
   struct buffer_Prop
   {
      constexpr buffer_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/unsigned char * operator= (/*0H*/unsigned char * v);
      /*regSet*/inline TempFile::buffer_Prop & operator= (TempFile::buffer_Prop & prop);
      /*regGet*/inline operator /*0I*/unsigned char * () const;
   } buffer;
   struct size_Prop
   {
      constexpr size_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uintsize operator= (/*0H*/uintsize v);
      /*regSet*/inline TempFile::size_Prop & operator= (TempFile::size_Prop & prop);
      /*regGet*/inline operator /*0I*/uintsize () const;
   } size;
   struct allocated_Prop
   {
      constexpr allocated_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/uintsize operator= (/*0H*/uintsize v);
      /*regSet*/inline TempFile::allocated_Prop & operator= (TempFile::allocated_Prop & prop);
      /*regGet*/inline operator /*0I*/uintsize () const;
   } allocated;
};

class CharCategories
{
public:
   C(CharCategories) impl;
   constexpr CharCategories() : impl(0) { }

   CharCategories(PredefinedCharCategories impl) : impl((C(CharCategories))impl) { }
   CharCategories & operator =(PredefinedCharCategories impl) { this->impl = (C(CharCategories))impl; return *this; }

   constexpr CharCategories(C(CharCategories) impl) : impl(impl) { }
   operator C(CharCategories)() { return impl; }
   CharCategories & operator =(C(CharCategories) impl) { impl = impl; return *this; }
   bool operator ==(const CharCategories & value) const { return impl == value.impl; }
   bool operator !=(const CharCategories & value) const { return impl != value.impl; }

   struct none_Prop
   {
      constexpr none_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::none_Prop & operator= (CharCategories::none_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } none;
   struct markNonSpacing_Prop
   {
      constexpr markNonSpacing_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::markNonSpacing_Prop & operator= (CharCategories::markNonSpacing_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } markNonSpacing;
   struct markSpacing_Prop
   {
      constexpr markSpacing_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::markSpacing_Prop & operator= (CharCategories::markSpacing_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } markSpacing;
   struct markEnclosing_Prop
   {
      constexpr markEnclosing_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::markEnclosing_Prop & operator= (CharCategories::markEnclosing_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } markEnclosing;
   struct numberDecimalDigit_Prop
   {
      constexpr numberDecimalDigit_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::numberDecimalDigit_Prop & operator= (CharCategories::numberDecimalDigit_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } numberDecimalDigit;
   struct numberLetter_Prop
   {
      constexpr numberLetter_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::numberLetter_Prop & operator= (CharCategories::numberLetter_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } numberLetter;
   struct numberOther_Prop
   {
      constexpr numberOther_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::numberOther_Prop & operator= (CharCategories::numberOther_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } numberOther;
   struct separatorSpace_Prop
   {
      constexpr separatorSpace_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::separatorSpace_Prop & operator= (CharCategories::separatorSpace_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } separatorSpace;
   struct separatorLine_Prop
   {
      constexpr separatorLine_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::separatorLine_Prop & operator= (CharCategories::separatorLine_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } separatorLine;
   struct separatorParagraph_Prop
   {
      constexpr separatorParagraph_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::separatorParagraph_Prop & operator= (CharCategories::separatorParagraph_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } separatorParagraph;
   struct otherControl_Prop
   {
      constexpr otherControl_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::otherControl_Prop & operator= (CharCategories::otherControl_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } otherControl;
   struct otherFormat_Prop
   {
      constexpr otherFormat_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::otherFormat_Prop & operator= (CharCategories::otherFormat_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } otherFormat;
   struct otherSurrogate_Prop
   {
      constexpr otherSurrogate_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::otherSurrogate_Prop & operator= (CharCategories::otherSurrogate_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } otherSurrogate;
   struct otherPrivateUse_Prop
   {
      constexpr otherPrivateUse_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::otherPrivateUse_Prop & operator= (CharCategories::otherPrivateUse_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } otherPrivateUse;
   struct otherNotAssigned_Prop
   {
      constexpr otherNotAssigned_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::otherNotAssigned_Prop & operator= (CharCategories::otherNotAssigned_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } otherNotAssigned;
   struct letterUpperCase_Prop
   {
      constexpr letterUpperCase_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::letterUpperCase_Prop & operator= (CharCategories::letterUpperCase_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } letterUpperCase;
   struct letterLowerCase_Prop
   {
      constexpr letterLowerCase_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::letterLowerCase_Prop & operator= (CharCategories::letterLowerCase_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } letterLowerCase;
   struct letterTitleCase_Prop
   {
      constexpr letterTitleCase_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::letterTitleCase_Prop & operator= (CharCategories::letterTitleCase_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } letterTitleCase;
   struct letterModifier_Prop
   {
      constexpr letterModifier_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::letterModifier_Prop & operator= (CharCategories::letterModifier_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } letterModifier;
   struct letterOther_Prop
   {
      constexpr letterOther_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::letterOther_Prop & operator= (CharCategories::letterOther_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } letterOther;
   struct punctuationConnector_Prop
   {
      constexpr punctuationConnector_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::punctuationConnector_Prop & operator= (CharCategories::punctuationConnector_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } punctuationConnector;
   struct punctuationDash_Prop
   {
      constexpr punctuationDash_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::punctuationDash_Prop & operator= (CharCategories::punctuationDash_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } punctuationDash;
   struct punctuationOpen_Prop
   {
      constexpr punctuationOpen_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::punctuationOpen_Prop & operator= (CharCategories::punctuationOpen_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } punctuationOpen;
   struct punctuationClose_Prop
   {
      constexpr punctuationClose_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::punctuationClose_Prop & operator= (CharCategories::punctuationClose_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } punctuationClose;
   struct punctuationInitial_Prop
   {
      constexpr punctuationInitial_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::punctuationInitial_Prop & operator= (CharCategories::punctuationInitial_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } punctuationInitial;
   struct punctuationFinal_Prop
   {
      constexpr punctuationFinal_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::punctuationFinal_Prop & operator= (CharCategories::punctuationFinal_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } punctuationFinal;
   struct punctuationOther_Prop
   {
      constexpr punctuationOther_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::punctuationOther_Prop & operator= (CharCategories::punctuationOther_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } punctuationOther;
   struct symbolMath_Prop
   {
      constexpr symbolMath_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::symbolMath_Prop & operator= (CharCategories::symbolMath_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } symbolMath;
   struct symbolCurrency_Prop
   {
      constexpr symbolCurrency_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::symbolCurrency_Prop & operator= (CharCategories::symbolCurrency_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } symbolCurrency;
   struct symbolModifier_Prop
   {
      constexpr symbolModifier_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::symbolModifier_Prop & operator= (CharCategories::symbolModifier_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } symbolModifier;
   struct symbolOther_Prop
   {
      constexpr symbolOther_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline CharCategories::symbolOther_Prop & operator= (CharCategories::symbolOther_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } symbolOther;
};

enum class CharCategory : int
{
   none = CharCategory_none,
   Mn = CharCategory_Mn,
   markNonSpacing = CharCategory_markNonSpacing,
   Mc = CharCategory_Mc,
   markSpacing = CharCategory_markSpacing,
   Me = CharCategory_Me,
   markEnclosing = CharCategory_markEnclosing,
   Nd = CharCategory_Nd,
   numberDecimalDigit = CharCategory_numberDecimalDigit,
   Nl = CharCategory_Nl,
   numberLetter = CharCategory_numberLetter,
   No = CharCategory_No,
   numberOther = CharCategory_numberOther,
   Zs = CharCategory_Zs,
   separatorSpace = CharCategory_separatorSpace,
   Zl = CharCategory_Zl,
   separatorLine = CharCategory_separatorLine,
   Zp = CharCategory_Zp,
   separatorParagraph = CharCategory_separatorParagraph,
   Cc = CharCategory_Cc,
   otherControl = CharCategory_otherControl,
   Cf = CharCategory_Cf,
   otherFormat = CharCategory_otherFormat,
   Cs = CharCategory_Cs,
   otherSurrogate = CharCategory_otherSurrogate,
   Co = CharCategory_Co,
   otherPrivateUse = CharCategory_otherPrivateUse,
   Cn = CharCategory_Cn,
   otherNotAssigned = CharCategory_otherNotAssigned,
   Lu = CharCategory_Lu,
   letterUpperCase = CharCategory_letterUpperCase,
   Ll = CharCategory_Ll,
   letterLowerCase = CharCategory_letterLowerCase,
   Lt = CharCategory_Lt,
   letterTitleCase = CharCategory_letterTitleCase,
   Lm = CharCategory_Lm,
   letterModifier = CharCategory_letterModifier,
   Lo = CharCategory_Lo,
   letterOther = CharCategory_letterOther,
   Pc = CharCategory_Pc,
   punctuationConnector = CharCategory_punctuationConnector,
   Pd = CharCategory_Pd,
   punctuationDash = CharCategory_punctuationDash,
   Ps = CharCategory_Ps,
   punctuationOpen = CharCategory_punctuationOpen,
   Pe = CharCategory_Pe,
   punctuationClose = CharCategory_punctuationClose,
   Pi_ = CharCategory_Pi,
   punctuationInitial = CharCategory_punctuationInitial,
   Pf = CharCategory_Pf,
   punctuationFinal = CharCategory_punctuationFinal,
   Po = CharCategory_Po,
   punctuationOther = CharCategory_punctuationOther,
   Sm = CharCategory_Sm,
   symbolMath = CharCategory_symbolMath,
   Sc = CharCategory_Sc,
   symbolCurrency = CharCategory_symbolCurrency,
   Sk = CharCategory_Sk,
   symbolModifier = CharCategory_symbolModifier,
   So = CharCategory_So,
   symbolOther = CharCategory_symbolOther
};

enum class PredefinedCharCategories : uint
{
   none = PredefinedCharCategories_none,
   marks = PredefinedCharCategories_marks,
   numbers = PredefinedCharCategories_numbers,
   separators = PredefinedCharCategories_separators,
   others = PredefinedCharCategories_others,
   letters = PredefinedCharCategories_letters,
   punctuation = PredefinedCharCategories_punctuation,
   symbols = PredefinedCharCategories_symbols,
   connector = PredefinedCharCategories_connector
};

class UnicodeDecomposition
{
public:
   C(UnicodeDecomposition) impl;
   constexpr UnicodeDecomposition() : impl(0) { }
   constexpr UnicodeDecomposition(C(UnicodeDecomposition) impl) : impl(impl) { }
   operator C(UnicodeDecomposition)() { return impl; }
   UnicodeDecomposition & operator =(C(UnicodeDecomposition) impl) { impl = impl; return *this; }
   bool operator ==(const UnicodeDecomposition & value) const { return impl == value.impl; }
   bool operator !=(const UnicodeDecomposition & value) const { return impl != value.impl; }

   struct canonical_Prop
   {
      constexpr canonical_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::canonical_Prop & operator= (UnicodeDecomposition::canonical_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } canonical;
   struct compat_Prop
   {
      constexpr compat_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::compat_Prop & operator= (UnicodeDecomposition::compat_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } compat;
   struct fraction_Prop
   {
      constexpr fraction_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::fraction_Prop & operator= (UnicodeDecomposition::fraction_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } fraction;
   struct font_Prop
   {
      constexpr font_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::font_Prop & operator= (UnicodeDecomposition::font_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } font;
   struct noBreak_Prop
   {
      constexpr noBreak_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::noBreak_Prop & operator= (UnicodeDecomposition::noBreak_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } noBreak;
   struct initial_Prop
   {
      constexpr initial_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::initial_Prop & operator= (UnicodeDecomposition::initial_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } initial;
   struct final_Prop
   {
      constexpr final_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::final_Prop & operator= (UnicodeDecomposition::final_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } final;
   struct medial_Prop
   {
      constexpr medial_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::medial_Prop & operator= (UnicodeDecomposition::medial_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } medial;
   struct isolated_Prop
   {
      constexpr isolated_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::isolated_Prop & operator= (UnicodeDecomposition::isolated_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } isolated;
   struct circle_Prop
   {
      constexpr circle_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::circle_Prop & operator= (UnicodeDecomposition::circle_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } circle;
   struct square_Prop
   {
      constexpr square_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::square_Prop & operator= (UnicodeDecomposition::square_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } square;
   struct sub_Prop
   {
      constexpr sub_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::sub_Prop & operator= (UnicodeDecomposition::sub_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } sub;
   struct super_Prop
   {
      constexpr super_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::super_Prop & operator= (UnicodeDecomposition::super_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } super;
   struct small_Prop
   {
      constexpr small_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::small_Prop & operator= (UnicodeDecomposition::small_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } small;
   struct vertical_Prop
   {
      constexpr vertical_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::vertical_Prop & operator= (UnicodeDecomposition::vertical_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } vertical;
   struct wide_Prop
   {
      constexpr wide_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::wide_Prop & operator= (UnicodeDecomposition::wide_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } wide;
   struct narrow_Prop
   {
      constexpr narrow_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline UnicodeDecomposition::narrow_Prop & operator= (UnicodeDecomposition::narrow_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } narrow;
};

enum class SettingsIOResult : int
{
   error = SettingsIOResult_error,
   success = SettingsIOResult_success,
   fileNotFound = SettingsIOResult_fileNotFound,
   fileNotCompatibleWithDriver = SettingsIOResult_fileNotCompatibleWithDriver
};

#define REG_GlobalSettings_load(m, c)                REGVMETHOD(GlobalSettings, load,                c::m, (/*1Ab*/GlobalSettings & self), c, ())
#define REG_GlobalSettings_onAskReloadSettings(m, c) REGVMETHOD(GlobalSettings, onAskReloadSettings, c::m, (/*1Ab*/GlobalSettings & self), c, ())
#define REG_GlobalSettings_save(m, c)                REGVMETHOD(GlobalSettings, save,                c::m, (/*1Ab*/GlobalSettings & self), c, ())

#define REG_GlobalSettings(c) \
      GlobalSettings::class_registration(_cpp_class); \
      REG_GlobalSettings_load(load, c); \
      REG_GlobalSettings_onAskReloadSettings(onAskReloadSettings, c); \
      REG_GlobalSettings_save(save, c);

#define GLOBALSETTINGS_VIRTUAL_METHODS_PROTO(c) \
   VIRTUAL_METHOD_PROTO(load, load, c, GlobalSettings, \
      SettingsIOResult, c &, , ); \
   VIRTUAL_METHOD_PROTO(onAskReloadSettings, onAskReloadSettings, c, GlobalSettings, \
      void, c &, , ); \
   VIRTUAL_METHOD_PROTO(save, save, c, GlobalSettings, \
      SettingsIOResult, c &, , );

#define GLOBALSETTINGS_VIRTUAL_METHODS(c) \
VIRTUAL_METHOD(load, load, c, GlobalSettings, \
   SettingsIOResult, c &, , , \
   return (SettingsIOResult)GlobalSettings_load(self ? self->impl : (C(GlobalSettings))null);); \
VIRTUAL_METHOD(onAskReloadSettings, onAskReloadSettings, c, GlobalSettings, \
   void, c &, , , \
   GlobalSettings_onAskReloadSettings(self ? self->impl : (C(GlobalSettings))null);); \
VIRTUAL_METHOD(save, save, c, GlobalSettings, \
   SettingsIOResult, c &, , , \
   return (SettingsIOResult)GlobalSettings_save(self ? self->impl : (C(GlobalSettings))null););

class GlobalSettings : public Instance
{
public:
   inline GlobalSettings(GlobalSettings && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline GlobalSettings & operator= (GlobalSettings && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   GlobalSettings() : GlobalSettings((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<GlobalSettings> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         GlobalSettings * inst = new GlobalSettings(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      GlobalSettings * inst = (GlobalSettings *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(GlobalSettings & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline GlobalSettings(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl) { }

   inline void close(); // GlobalSettings_close
   inline void closeAndMonitor(); // GlobalSettings_closeAndMonitor
   inline C(bool) openAndLock(/*1Ab*/FileSize * fileSize); // GlobalSettings_openAndLock

   struct GlobalSettings_load_Functor
   {
      [[no_unique_address]] int _[0];
      typedef SettingsIOResult (* FunctionType)(GlobalSettings &);
      inline FunctionType operator= (FunctionType func);
      inline SettingsIOResult operator()( );
   } load;
   // inline static void register_load(CPPClass & cl, GlobalSettings::GlobalSettings_load_Functor::FunctionType func)

   struct GlobalSettings_onAskReloadSettings_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(GlobalSettings &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()( );
   } onAskReloadSettings;
   // inline static void register_onAskReloadSettings(CPPClass & cl, GlobalSettings::GlobalSettings_onAskReloadSettings_Functor::FunctionType func)

   struct GlobalSettings_save_Functor
   {
      [[no_unique_address]] int _[0];
      typedef SettingsIOResult (* FunctionType)(GlobalSettings &);
      inline FunctionType operator= (FunctionType func);
      inline SettingsIOResult operator()( );
   } save;
   // inline static void register_save(CPPClass & cl, GlobalSettings::GlobalSettings_save_Functor::FunctionType func)

   static void class_registration(CPPClass & _cpp_class);

   inline GlobalSettings(const char * settingsName, const char * settingsExtension, const char * settingsDirectory, const char * settingsLocation, const char * settingsFilePath, bool allowDefaultLocations, bool allUsers, bool portable, /*CT-D*/constString driver);

   struct settingsName_Prop
   {
      constexpr settingsName_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline GlobalSettings::settingsName_Prop & operator= (GlobalSettings::settingsName_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } settingsName;
   struct settingsExtension_Prop
   {
      constexpr settingsExtension_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline GlobalSettings::settingsExtension_Prop & operator= (GlobalSettings::settingsExtension_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } settingsExtension;
   struct settingsDirectory_Prop
   {
      constexpr settingsDirectory_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline GlobalSettings::settingsDirectory_Prop & operator= (GlobalSettings::settingsDirectory_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } settingsDirectory;
   struct settingsLocation_Prop
   {
      constexpr settingsLocation_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline GlobalSettings::settingsLocation_Prop & operator= (GlobalSettings::settingsLocation_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } settingsLocation;
   struct settingsFilePath_Prop
   {
      constexpr settingsFilePath_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline GlobalSettings::settingsFilePath_Prop & operator= (GlobalSettings::settingsFilePath_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } settingsFilePath;
   struct allowDefaultLocations_Prop
   {
      constexpr allowDefaultLocations_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline GlobalSettings::allowDefaultLocations_Prop & operator= (GlobalSettings::allowDefaultLocations_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } allowDefaultLocations;
   struct allUsers_Prop
   {
      constexpr allUsers_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline GlobalSettings::allUsers_Prop & operator= (GlobalSettings::allUsers_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } allUsers;
   struct portable_Prop
   {
      constexpr portable_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline GlobalSettings::portable_Prop & operator= (GlobalSettings::portable_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } portable;
   struct driver_Prop
   {
      constexpr driver_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*//*CT-D*/constString operator= (/*0H*//*CT-D*/constString v);
      /*regSet*/inline GlobalSettings::driver_Prop & operator= (GlobalSettings::driver_Prop & prop);
      /*regGet*/inline operator /*0I*//*CT-D*/constString () const;
   } driver;
   struct isGlobalPath_Prop
   {
      constexpr isGlobalPath_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/bool () const;
   } isGlobalPath;

   struct data_Prop
   {
      constexpr data_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/GlobalSettingsData operator= (/*0H*/GlobalSettingsData v);
      /*regSet*/inline GlobalSettings::data_Prop & operator= (GlobalSettings::data_Prop & prop);
      /*regGet*/inline operator /*0I*/GlobalSettingsData () const;
   } data;
   struct dataOwner_Prop
   {
      constexpr dataOwner_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/C(GlobalSettingsData)* operator= (/*0H*/C(GlobalSettingsData)* v);
      /*regSet*/inline GlobalSettings::dataOwner_Prop & operator= (GlobalSettings::dataOwner_Prop & prop);
      /*regGet*/inline operator /*0I*/C(GlobalSettingsData)* () const;
   } dataOwner;
};

#define REG_GlobalSettingsDriver_load(m, c) REGVMETHOD(GlobalSettingsDriver, load, c::m, (/*1Ab*/File & f, /*1Ab*/GlobalSettings & globalSettings), c, (/*4Im*/f, /*4Im*/globalSettings))
#define REG_GlobalSettingsDriver_save(m, c) REGVMETHOD(GlobalSettingsDriver, save, c::m, (/*1Ab*/File & f, /*1Ab*/GlobalSettings & globalSettings), c, (/*4Im*/f, /*4Im*/globalSettings))

#define REG_GlobalSettingsDriver(c) \
      GlobalSettingsDriver::class_registration(_cpp_class); \
      REG_GlobalSettingsDriver_load(load, c); \
      REG_GlobalSettingsDriver_save(save, c);

#define GLOBALSETTINGSDRIVER_VIRTUAL_METHODS_PROTO(c) \
   VIRTUAL_METHOD_PROTO(load, load, c, GlobalSettingsDriver, \
      SettingsIOResult, c & _ARG, , /*6Fj*/File & f _ARG /*6Fj*/GlobalSettings & globalSettings); \
   VIRTUAL_METHOD_PROTO(save, save, c, GlobalSettingsDriver, \
      SettingsIOResult, c & _ARG, , /*6Fj*/File & f _ARG /*6Fj*/GlobalSettings & globalSettings);

#define GLOBALSETTINGSDRIVER_VIRTUAL_METHODS(c) \
VIRTUAL_METHOD(load, load, c, GlobalSettingsDriver, \
   SettingsIOResult, c & _ARG, , /*6Fj*/File & f _ARG /*6Fj*/GlobalSettings & globalSettings, \
   return (SettingsIOResult)GlobalSettingsDriver_load(self ? self->impl : (C(GlobalSettingsDriver))null, /*7Al*/f.impl, /*7Al*/globalSettings.impl);); \
VIRTUAL_METHOD(save, save, c, GlobalSettingsDriver, \
   SettingsIOResult, c & _ARG, , /*6Fj*/File & f _ARG /*6Fj*/GlobalSettings & globalSettings, \
   return (SettingsIOResult)GlobalSettingsDriver_save(self ? self->impl : (C(GlobalSettingsDriver))null, /*7Al*/f.impl, /*7Al*/globalSettings.impl););

class GlobalSettingsDriver : public Instance
{
public:
   inline GlobalSettingsDriver(GlobalSettingsDriver && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline GlobalSettingsDriver & operator= (GlobalSettingsDriver && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   GlobalSettingsDriver() : GlobalSettingsDriver((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<GlobalSettingsDriver> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         GlobalSettingsDriver * inst = new GlobalSettingsDriver(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      GlobalSettingsDriver * inst = (GlobalSettingsDriver *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(GlobalSettingsDriver & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline GlobalSettingsDriver(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl) { }

   struct GlobalSettingsDriver_load_Functor
   {
      [[no_unique_address]] int _[0];
      typedef SettingsIOResult (* FunctionType)(GlobalSettingsDriver & , /*6Fj*/File & f, /*6Fj*/GlobalSettings & globalSettings);
      inline FunctionType operator= (FunctionType func);
      inline SettingsIOResult operator()( /*6Fj*/File & f, /*6Fj*/GlobalSettings & globalSettings);
   } load;
   // inline static void register_load(CPPClass & cl, GlobalSettingsDriver::GlobalSettingsDriver_load_Functor::FunctionType func)

   struct GlobalSettingsDriver_save_Functor
   {
      [[no_unique_address]] int _[0];
      typedef SettingsIOResult (* FunctionType)(GlobalSettingsDriver & , /*6Fj*/File & f, /*6Fj*/GlobalSettings & globalSettings);
      inline FunctionType operator= (FunctionType func);
      inline SettingsIOResult operator()( /*6Fj*/File & f, /*6Fj*/GlobalSettings & globalSettings);
   } save;
   // inline static void register_save(CPPClass & cl, GlobalSettingsDriver::GlobalSettingsDriver_save_Functor::FunctionType func)

   static void class_registration(CPPClass & _cpp_class);
};


#define REG_JSONParser(c) \
      JSONParser::class_registration(_cpp_class);

#define JSONPARSER_VIRTUAL_METHODS_PROTO(c) \

#define JSONPARSER_VIRTUAL_METHODS(c) \

class JSONParser : public Instance
{
public:
   inline JSONParser(JSONParser && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline JSONParser & operator= (JSONParser && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   JSONParser() : JSONParser((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<JSONParser> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         JSONParser * inst = new JSONParser(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      JSONParser * inst = (JSONParser *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(JSONParser & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline JSONParser(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl) { }

   inline C(JSONResult) getObject(/*1Ab*/Class objectType, /*1Ab*/void ** object); // JSONParser_getObject

   static void class_registration(CPPClass & _cpp_class);

   struct debug_Prop
   {
      constexpr debug_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline JSONParser::debug_Prop & operator= (JSONParser::debug_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } debug;
   struct warnings_Prop
   {
      constexpr warnings_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline JSONParser::warnings_Prop & operator= (JSONParser::warnings_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } warnings;

   struct f_Prop
   {
      constexpr f_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/File operator= (/*0H*/File v);
      /*regSet*/inline JSONParser::f_Prop & operator= (JSONParser::f_Prop & prop);
      /*regGet*/inline operator /*0I*/File () const;
   } f;
   struct customJsonOptions_Prop
   {
      constexpr customJsonOptions_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0Z*/const OptionsMap & operator= (/*0Z*/const OptionsMap & v);
      /*regSet*/inline JSONParser::customJsonOptions_Prop & operator= (JSONParser::customJsonOptions_Prop & prop);
      /*regGet*/inline operator /*0I*/OptionsMap * () const;
   } customJsonOptions;
};


#define REG_ECONGlobalSettings(c) \
      ECONGlobalSettings::class_registration(_cpp_class); \
      REG_GlobalSettingsDriver_load(load, c); \
      REG_GlobalSettingsDriver_save(save, c);

#define ECONGLOBALSETTINGS_VIRTUAL_METHODS_PROTO(c) \

#define ECONGLOBALSETTINGS_VIRTUAL_METHODS(c) \

class ECONGlobalSettings : public GlobalSettingsDriver
{
public:
   inline ECONGlobalSettings(ECONGlobalSettings && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline ECONGlobalSettings & operator= (ECONGlobalSettings && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   ECONGlobalSettings() : ECONGlobalSettings((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<ECONGlobalSettings> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         ECONGlobalSettings * inst = new ECONGlobalSettings(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      ECONGlobalSettings * inst = (ECONGlobalSettings *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(ECONGlobalSettings & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline ECONGlobalSettings(C(Instance) _impl, CPPClass & cl = _cpp_class) : GlobalSettingsDriver(_impl, cl) { }

   static void class_registration(CPPClass & _cpp_class);
};


#define REG_ECONParser(c) \
      ECONParser::class_registration(_cpp_class);

#define ECONPARSER_VIRTUAL_METHODS_PROTO(c) \

#define ECONPARSER_VIRTUAL_METHODS(c) \

class ECONParser : public JSONParser
{
public:
   inline ECONParser(ECONParser && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline ECONParser & operator= (ECONParser && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   ECONParser() : ECONParser((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<ECONParser> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         ECONParser * inst = new ECONParser(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      ECONParser * inst = (ECONParser *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(ECONParser & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline ECONParser(C(Instance) _impl, CPPClass & cl = _cpp_class) : JSONParser(_impl, cl) { }

   static void class_registration(CPPClass & _cpp_class);
};


#define REG_GlobalAppSettings(c) \
      GlobalAppSettings::class_registration(_cpp_class); \
      REG_GlobalSettings_load(load, c); \
      REG_GlobalSettings_onAskReloadSettings(onAskReloadSettings, c); \
      REG_GlobalSettings_save(save, c);

#define GLOBALAPPSETTINGS_VIRTUAL_METHODS_PROTO(c) \

#define GLOBALAPPSETTINGS_VIRTUAL_METHODS(c) \

class GlobalAppSettings : public GlobalSettings
{
public:
   inline GlobalAppSettings(GlobalAppSettings && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline GlobalAppSettings & operator= (GlobalAppSettings && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   GlobalAppSettings() : GlobalAppSettings((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<GlobalAppSettings> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         GlobalAppSettings * inst = new GlobalAppSettings(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      GlobalAppSettings * inst = (GlobalAppSettings *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(GlobalAppSettings & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline GlobalAppSettings(C(Instance) _impl, CPPClass & cl = _cpp_class) : GlobalSettings(_impl, cl) { }

   inline C(bool) getGlobalValue(/*1Ab*/const char * section, /*1Ab*/const char * name, /*1Ab*/GlobalSettingType type, /*1Ab*/void * value); // GlobalAppSettings_getGlobalValue
   inline C(bool) putGlobalValue(/*1Ab*/const char * section, /*1Ab*/const char * name, /*1Ab*/GlobalSettingType type, /*1Ab*/const void * value); // GlobalAppSettings_putGlobalValue

   static void class_registration(CPPClass & _cpp_class);
};

enum class GlobalSettingType : int
{
   integer = GlobalSettingType_integer,
   singleString = GlobalSettingType_singleString,
   stringList = GlobalSettingType_stringList
};


#define REG_GlobalSettingsData(c) \
      GlobalSettingsData::class_registration(_cpp_class);

#define GLOBALSETTINGSDATA_VIRTUAL_METHODS_PROTO(c) \

#define GLOBALSETTINGSDATA_VIRTUAL_METHODS(c) \

class GlobalSettingsData : public Instance
{
public:
   inline GlobalSettingsData(GlobalSettingsData && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline GlobalSettingsData & operator= (GlobalSettingsData && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   GlobalSettingsData() : GlobalSettingsData((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<GlobalSettingsData> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         GlobalSettingsData * inst = new GlobalSettingsData(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      GlobalSettingsData * inst = (GlobalSettingsData *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(GlobalSettingsData & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline GlobalSettingsData(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl) { }

   static void class_registration(CPPClass & _cpp_class);
};

enum class JSONFirstLetterCapitalization : int
{
   keepCase = JSONFirstLetterCapitalization_keepCase,
   upperCase = JSONFirstLetterCapitalization_upperCase,
   lowerCase = JSONFirstLetterCapitalization_lowerCase
};


#define REG_JSONGlobalSettings(c) \
      JSONGlobalSettings::class_registration(_cpp_class); \
      REG_GlobalSettingsDriver_load(load, c); \
      REG_GlobalSettingsDriver_save(save, c);

#define JSONGLOBALSETTINGS_VIRTUAL_METHODS_PROTO(c) \

#define JSONGLOBALSETTINGS_VIRTUAL_METHODS(c) \

class JSONGlobalSettings : public GlobalSettingsDriver
{
public:
   inline JSONGlobalSettings(JSONGlobalSettings && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline JSONGlobalSettings & operator= (JSONGlobalSettings && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   JSONGlobalSettings() : JSONGlobalSettings((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<JSONGlobalSettings> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         JSONGlobalSettings * inst = new JSONGlobalSettings(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      JSONGlobalSettings * inst = (JSONGlobalSettings *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(JSONGlobalSettings & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline JSONGlobalSettings(C(Instance) _impl, CPPClass & cl = _cpp_class) : GlobalSettingsDriver(_impl, cl) { }

   static void class_registration(CPPClass & _cpp_class);
};

enum class JSONResult : int
{
   syntaxError = JSONResult_syntaxError,
   success = JSONResult_success,
   typeMismatch = JSONResult_typeMismatch,
   noItem = JSONResult_noItem
};

class JSONTypeOptions
{
public:
   C(JSONTypeOptions) impl;
   constexpr JSONTypeOptions() : impl(0) { }
   constexpr JSONTypeOptions(C(JSONTypeOptions) impl) : impl(impl) { }
   operator C(JSONTypeOptions)() { return impl; }
   JSONTypeOptions & operator =(C(JSONTypeOptions) impl) { impl = impl; return *this; }
   bool operator ==(const JSONTypeOptions & value) const { return impl == value.impl; }
   bool operator !=(const JSONTypeOptions & value) const { return impl != value.impl; }

   struct numbersUseOGDFS_Prop
   {
      constexpr numbersUseOGDFS_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline JSONTypeOptions::numbersUseOGDFS_Prop & operator= (JSONTypeOptions::numbersUseOGDFS_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } numbersUseOGDFS;
   struct boolUseOGDFS_Prop
   {
      constexpr boolUseOGDFS_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline JSONTypeOptions::boolUseOGDFS_Prop & operator= (JSONTypeOptions::boolUseOGDFS_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } boolUseOGDFS;
   struct nullUseOGDFS_Prop
   {
      constexpr nullUseOGDFS_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline JSONTypeOptions::nullUseOGDFS_Prop & operator= (JSONTypeOptions::nullUseOGDFS_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } nullUseOGDFS;
   struct stringUseOGDFS_Prop
   {
      constexpr stringUseOGDFS_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline JSONTypeOptions::stringUseOGDFS_Prop & operator= (JSONTypeOptions::stringUseOGDFS_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } stringUseOGDFS;
   struct arrayUseOGDFS_Prop
   {
      constexpr arrayUseOGDFS_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline JSONTypeOptions::arrayUseOGDFS_Prop & operator= (JSONTypeOptions::arrayUseOGDFS_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } arrayUseOGDFS;
   struct objectUseOGDFS_Prop
   {
      constexpr objectUseOGDFS_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline JSONTypeOptions::objectUseOGDFS_Prop & operator= (JSONTypeOptions::objectUseOGDFS_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } objectUseOGDFS;
   struct stripQuotesForOGDFS_Prop
   {
      constexpr stripQuotesForOGDFS_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline JSONTypeOptions::stripQuotesForOGDFS_Prop & operator= (JSONTypeOptions::stripQuotesForOGDFS_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } stripQuotesForOGDFS;
   struct strictOGDFS_Prop
   {
      constexpr strictOGDFS_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/bool operator= (/*0H*/bool v);
      /*regSet*/inline JSONTypeOptions::strictOGDFS_Prop & operator= (JSONTypeOptions::strictOGDFS_Prop & prop);
      /*regGet*/inline operator /*0I*/bool () const;
   } strictOGDFS;
};


#define REG_OptionsMap(c) \
      OptionsMap::class_registration(_cpp_class);

#define OPTIONSMAP_VIRTUAL_METHODS_PROTO(c) \

#define OPTIONSMAP_VIRTUAL_METHODS(c) \

class OptionsMap : public TMap<MapNode, C(String)>
{
public:
   inline OptionsMap(OptionsMap && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline OptionsMap & operator= (OptionsMap && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   OptionsMap() : OptionsMap((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<OptionsMap> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         OptionsMap * inst = new OptionsMap(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      OptionsMap * inst = (OptionsMap *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(OptionsMap & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline OptionsMap(C(Instance) _impl, CPPClass & cl = _cpp_class) : TMap<MapNode, C(String)>(_impl, cl) { }

   static void class_registration(CPPClass & _cpp_class);
};

enum class SetBool : uint
{
   unset = SetBool_unset,
   false_ = SetBool_false,
   true_ = SetBool_true
};

template <class TC, C(Class) ** TCO>
class TCondition : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   inline void signal(); // Condition_signal
   inline void wait(/*1Ab*/Mutex mutex); // Condition_wait

   struct name_Prop
   {
      constexpr name_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/const char * operator= (/*0H*/const char * v);
      /*regSet*/inline typename TCondition<TC, TCO>::name_Prop & operator= (typename TCondition<TC, TCO>::name_Prop & prop);
      /*regGet*/inline operator /*0I*/const char * () const;
   } name;
   ~TCondition()
   {
      this->impl = null; // How to know not to delete?
   }
};

template <class TC, C(Class) ** TCO>
class TMutex : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   inline void release(); // Mutex_release
   inline void wait(); // Mutex_wait

   struct lockCount_Prop
   {
      constexpr lockCount_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/int () const;
   } lockCount;
   struct owningThread_Prop
   {
      constexpr owningThread_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/int64 () const;
   } owningThread;
   ~TMutex()
   {
      this->impl = null; // How to know not to delete?
   }
};

template <class TC, C(Class) ** TCO>
class TSemaphore : public TNHInstance<TC, TCO>
{
public:
   using TNHInstance<TC, TCO>::TNHInstance;

   inline void release(); // Semaphore_release
   inline C(bool) tryWait(); // Semaphore_tryWait
   inline void wait(); // Semaphore_wait

   struct initCount_Prop
   {
      constexpr initCount_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TSemaphore<TC, TCO>::initCount_Prop & operator= (typename TSemaphore<TC, TCO>::initCount_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } initCount;
   struct maxCount_Prop
   {
      constexpr maxCount_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline typename TSemaphore<TC, TCO>::maxCount_Prop & operator= (typename TSemaphore<TC, TCO>::maxCount_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } maxCount;
   ~TSemaphore()
   {
      this->impl = null; // How to know not to delete?
   }
};

#define REG_Thread_main(m, c) REGVMETHOD(Thread, main, c::m, (/*1Ab*/Thread & self), c, ())

#define REG_Thread(c) \
      Thread::class_registration(_cpp_class); \
      REG_Thread_main(main, c);

#define THREAD_VIRTUAL_METHODS_PROTO(c) \
   VIRTUAL_METHOD_PROTO(main, main, c, Thread, \
      uint, c &, , );

#define THREAD_VIRTUAL_METHODS(c) \
VIRTUAL_METHOD(main, main, c, Thread, \
   uint, c &, , , \
   return Thread_main(self ? self->impl : (C(Thread))null););

class Thread : public Instance
{
public:
   inline Thread(Thread && i)
   {
      Instance * self = (Instance *)this;
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
   }
   inline Thread & operator= (Thread && i)
   {
      Instance * self = (Instance *)this;
      if(self->impl)
      {
         C(Instance) impl = self->impl;
         int refCount = impl->_refCount;
         Instance_decRef(impl);
         if(refCount > 1)
         {
            Instance ** inst = (Instance **)&INSTANCEL(impl, impl->_class);
            if(inst && *inst == self)
               *inst = null;
         }
      }
      self->impl = i.impl;
      self->vTbl = i.vTbl;
      self->mustFree = i.mustFree; /* checking: should this be in all these instances? */
      i.impl = null;
      i.vTbl = null;
      return *this;
   }
   Thread() : Thread((C(Instance))Instance_newEx(_cpp_class.impl, false), _cpp_class) { }
   struct Instance_onCompare_Functor
   {
      [[no_unique_address]] int _[0];
      typedef int (* FunctionType)(Instance & , /*6Bj*/Instance & object);
      inline FunctionType operator= (FunctionType func);
      inline int operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object);
   } onCompare;
   // inline static void register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)

   struct Instance_onCopy_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Bj*/Instance & newData);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData);
   } onCopy;
   // inline static void register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)

   struct Instance_onDisplay_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags);
   } onDisplay;
   // inline static void register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)

   struct Instance_onEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef Instance & (* FunctionType)(Instance & , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
      inline FunctionType operator= (FunctionType func);
      inline Instance & operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData);
   } onEdit;
   // inline static void register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)

   struct Instance_onFree_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance &);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ );
   } onFree;
   // inline static void register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)

   struct Instance_onGetDataFromString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/const char * string);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string);
   } onGetDataFromString;
   // inline static void register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)

   struct Instance_onGetString_Functor
   {
      [[no_unique_address]] int _[0];
      typedef const char * (* FunctionType)(Instance & , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
      inline FunctionType operator= (FunctionType func);
      inline const char * operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType);
   } onGetString;
   // inline static void register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)

   struct Instance_onSaveEdit_Functor
   {
      [[no_unique_address]] int _[0];
      typedef bool (* FunctionType)(Instance & , /*6Fj*/Instance & window, /*6Fj*/void * object);
      inline FunctionType operator= (FunctionType func);
      inline bool operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object);
   } onSaveEdit;
   // inline static void register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)

   struct Instance_onSerialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onSerialize;
   // inline static void register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)

   struct Instance_onUnserialize_Functor
   {
      [[no_unique_address]] int _[0];
      typedef void (* FunctionType)(Instance & , /*6Fj*/IOChannel & channel);
      inline FunctionType operator= (FunctionType func);
      inline void operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel);
   } onUnserialize;
   // inline static void register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)

   static TCPPClass<Thread> _cpp_class;
   static C(bool) constructor(C(Instance) i, C(bool) alloc)
   {
      if(alloc && !INSTANCEL(i, i->_class))
      {
         Thread * inst = new Thread(i, _cpp_class);
         if(inst)
         {
            /* printf("Must free!\n");*/
            inst->mustFree = true;
         }
         return inst != null;
      }
      return true;
   }
   static void destructor(C(Instance) i)
   {
      Thread * inst = (Thread *)INSTANCEL(i, i->_class);
      if(inst)
      {
         if(_cpp_class.destructor)
            ((void (*)(Thread & self))_cpp_class.destructor)(*inst);
         if(inst->mustFree)
            delete inst;
      }
   }
   explicit inline Thread(C(Instance) _impl, CPPClass & cl = _cpp_class) : Instance(_impl, cl) { }

   inline void create(); // Thread_create
   inline void kill(); // Thread_kill
   inline void setPriority(/*1Ab*/ThreadPriority priority); // Thread_setPriority
   inline void wait(); // Thread_wait

   struct Thread_main_Functor
   {
      [[no_unique_address]] int _[0];
      typedef uint (* FunctionType)(Thread &);
      inline FunctionType operator= (FunctionType func);
      inline uint operator()( );
   } main;
   // inline static void register_main(CPPClass & cl, Thread::Thread_main_Functor::FunctionType func)

   static void class_registration(CPPClass & _cpp_class);

   struct created_Prop
   {
      constexpr created_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/bool () const;
   } created;
};

enum class ThreadPriority : int
{
   normal = ThreadPriority_normal,
   aboveNormal = ThreadPriority_aboveNormal,
   belowNormal = ThreadPriority_belowNormal,
   highest = ThreadPriority_highest,
   lowest = ThreadPriority_lowest,
   idle = ThreadPriority_idle,
   timeCritical = ThreadPriority_timeCritical
};

class SecSince1970
{
public:
   C(SecSince1970) impl;
   constexpr SecSince1970() : impl(0) { }
   constexpr SecSince1970(C(SecSince1970) value) : impl(value) { }
   operator C(SecSince1970)() const { return impl; }
   constexpr SecSince1970(const SecSince1970 & value) : impl(value.impl) { }
   SecSince1970 & operator =(int64 value) { impl = value; return *this; }
   SecSince1970 & operator +=(SecSince1970 value) { impl += value.impl; return *this; }
   SecSince1970 & operator -=(SecSince1970 value) { impl -= value.impl; return *this; }
   SecSince1970 operator +(const SecSince1970 & b) const { return SecSince1970(impl + b.impl); }
   SecSince1970 operator -(const SecSince1970 & b) const { return SecSince1970(impl - b.impl); }
   bool operator ==(const SecSince1970 & value) const { return impl == value.impl; }
   bool operator !=(const SecSince1970 & value) const { return impl != value.impl; }
   bool operator <(const SecSince1970 & value) const { return impl < value.impl; }
   bool operator >(const SecSince1970 & value) const { return impl > value.impl; }
   bool operator <=(const SecSince1970 & value) const { return impl <= value.impl; }
   bool operator >=(const SecSince1970 & value) const { return impl >= value.impl; }
   bool operator ==(int64 value) const { return impl == SecSince1970(value).impl; }
   bool operator !=(int64 value) const { return impl != SecSince1970(value).impl; }
   bool operator <(int64 value) const { return impl < SecSince1970(value).impl; }
   bool operator >(int64 value) const { return impl > SecSince1970(value).impl; }
   bool operator <=(int64 value) const { return impl <= SecSince1970(value).impl; }
   bool operator >=(int64 value) const { return impl >= SecSince1970(value).impl; }

   struct global_Prop
   {
      constexpr global_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/SecSince1970 () const;
      /*regGet*/inline operator /*0J*/C(SecSince1970) () const;
   } global;
   struct local_Prop
   {
      constexpr local_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/SecSince1970 () const;
      /*regGet*/inline operator /*0J*/C(SecSince1970) () const;
   } local;
};

class Time
{
public:
   C(Time) impl;
   constexpr Time() : impl(0) { }
   constexpr Time(C(Time) value) : impl(value) { }
   operator C(Time)() const { return impl; }
   constexpr Time(const Time & value) : impl(value.impl) { }
   Time & operator =(double value) { impl = value; return *this; }
   Time & operator +=(Time value) { impl += value.impl; return *this; }
   Time & operator -=(Time value) { impl -= value.impl; return *this; }
   Time operator +(const Time & b) const { return Time(impl + b.impl); }
   Time operator -(const Time & b) const { return Time(impl - b.impl); }
   bool operator ==(const Time & value) const { return impl == value.impl; }
   bool operator !=(const Time & value) const { return impl != value.impl; }
   bool operator <(const Time & value) const { return impl < value.impl; }
   bool operator >(const Time & value) const { return impl > value.impl; }
   bool operator <=(const Time & value) const { return impl <= value.impl; }
   bool operator >=(const Time & value) const { return impl >= value.impl; }
   bool operator ==(double value) const { return impl == Time(value).impl; }
   bool operator !=(double value) const { return impl != Time(value).impl; }
   bool operator <(double value) const { return impl < Time(value).impl; }
   bool operator >(double value) const { return impl > Time(value).impl; }
   bool operator <=(double value) const { return impl <= Time(value).impl; }
   bool operator >=(double value) const { return impl >= Time(value).impl; }
   bool operator ==(int value) const { return impl == Time(value).impl; }
   bool operator !=(int value) const { return impl != Time(value).impl; }
   bool operator <(int value) const { return impl < Time(value).impl; }
   bool operator >(int value) const { return impl > Time(value).impl; }
   bool operator <=(int value) const { return impl <= Time(value).impl; }
   bool operator >=(int value) const { return impl >= Time(value).impl; }
};

struct Date : public TStruct<Date>
{
public:
   C(Date) impl;
   constexpr Date() : impl({}) { }
   constexpr Date(const C(Date) impl) : impl(impl) { }

   inline const char * onGetStringEn(/*1Ab*/char * stringOutput, /*1Ab*/void * fieldData, /*1Ab*/ObjectNotationType * onType); // Date_onGetStringEn

   inline Date(int year, Month month, int day);

   struct dayOfTheWeek_Prop
   {
      constexpr dayOfTheWeek_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/DayOfTheWeek () const;
   } dayOfTheWeek;

   struct year_Prop
   {
      constexpr year_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Date::year_Prop & operator= (Date::year_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } year;
   struct month_Prop
   {
      constexpr month_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Month operator= (/*0H*/Month v);
      /*regSet*/inline Date::month_Prop & operator= (Date::month_Prop & prop);
      /*regGet*/inline operator /*0I*/Month () const;
   } month;
   struct day_Prop
   {
      constexpr day_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline Date::day_Prop & operator= (Date::day_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } day;
};

struct DateTime : public TStruct<DateTime>
{
public:
   C(DateTime) impl;
   constexpr DateTime() : impl({}) { }
   constexpr DateTime(const C(DateTime) impl) : impl(impl) { }
   inline operator SecSince1970() const;
   inline DateTime(const SecSince1970 & s);
   inline DateTime & operator =(const SecSince1970 & s);
   inline operator Date() const;
   inline DateTime(const Date & d);
   inline DateTime & operator =(const Date & d);

   inline C(bool) fixDayOfYear(); // DateTime_fixDayOfYear
   inline C(bool) getLocalTime(); // DateTime_getLocalTime

   inline DateTime(int year, Month month, int day, int hour, int minute, int second, DayOfTheWeek dayOfTheWeek, int dayInTheYear);

   struct global_Prop
   {
      constexpr global_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/DateTime operator= (/*0H*/DateTime v);
      /*regSet*/inline DateTime::global_Prop & operator= (DateTime::global_Prop & prop);
      /*regGet*/inline operator /*0I*/DateTime () const;
   } global;
   struct local_Prop
   {
      constexpr local_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/DateTime operator= (/*0H*/DateTime v);
      /*regSet*/inline DateTime::local_Prop & operator= (DateTime::local_Prop & prop);
      /*regGet*/inline operator /*0I*/DateTime () const;
   } local;
   struct daysSince1970_Prop
   {
      constexpr daysSince1970_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*regGet*/inline operator /*0I*/int64 () const;
   } daysSince1970;

   struct year_Prop
   {
      constexpr year_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline DateTime::year_Prop & operator= (DateTime::year_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } year;
   struct month_Prop
   {
      constexpr month_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/Month operator= (/*0H*/Month v);
      /*regSet*/inline DateTime::month_Prop & operator= (DateTime::month_Prop & prop);
      /*regGet*/inline operator /*0I*/Month () const;
   } month;
   struct day_Prop
   {
      constexpr day_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline DateTime::day_Prop & operator= (DateTime::day_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } day;
   struct hour_Prop
   {
      constexpr hour_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline DateTime::hour_Prop & operator= (DateTime::hour_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } hour;
   struct minute_Prop
   {
      constexpr minute_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline DateTime::minute_Prop & operator= (DateTime::minute_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } minute;
   struct second_Prop
   {
      constexpr second_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline DateTime::second_Prop & operator= (DateTime::second_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } second;
   struct dayOfTheWeek_Prop
   {
      constexpr dayOfTheWeek_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/DayOfTheWeek operator= (/*0H*/DayOfTheWeek v);
      /*regSet*/inline DateTime::dayOfTheWeek_Prop & operator= (DateTime::dayOfTheWeek_Prop & prop);
      /*regGet*/inline operator /*0I*/DayOfTheWeek () const;
   } dayOfTheWeek;
   struct dayInTheYear_Prop
   {
      constexpr dayInTheYear_Prop() :_() { };
      [[no_unique_address]] int _[0];
      /*nstSet*/inline /*0H*/int operator= (/*0H*/int v);
      /*regSet*/inline DateTime::dayInTheYear_Prop & operator= (DateTime::dayInTheYear_Prop & prop);
      /*regGet*/inline operator /*0I*/int () const;
   } dayInTheYear;
};

enum class DayOfTheWeek : int
{
   sunday = DayOfTheWeek_sunday,
   monday = DayOfTheWeek_monday,
   tuesday = DayOfTheWeek_tuesday,
   wednesday = DayOfTheWeek_wednesday,
   thursday = DayOfTheWeek_thursday,
   friday = DayOfTheWeek_friday,
   saturday = DayOfTheWeek_saturday
};

enum class Month : int
{
   january = Month_january,
   february = Month_february,
   march = Month_march,
   april = Month_april,
   may = Month_may,
   june = Month_june,
   july = Month_july,
   august = Month_august,
   september = Month_september,
   october = Month_october,
   november = Month_november,
   december = Month_december
};

class Seconds : public Time
{
public:
   constexpr Seconds() : Time() { }
   constexpr Seconds(const Time value) : Time(value) { }
   constexpr Seconds(double value) : Time(SECONDS(value)) { }
   constexpr operator double() const { return Time_in_Seconds(impl); }
   constexpr Seconds & operator =(double value) { impl = SECONDS(value); return *this; }
   bool operator ==(const Seconds & value) const { return impl == value.impl; }
   bool operator !=(const Seconds & value) const { return impl != value.impl; }
   bool operator <(const Seconds & value) const { return impl < value.impl; }
   bool operator >(const Seconds & value) const { return impl > value.impl; }
   bool operator <=(const Seconds & value) const { return impl <= value.impl; }
   bool operator >=(const Seconds & value) const { return impl >= value.impl; }
   bool operator ==(double value) const { return impl == Seconds(value).impl; }
   bool operator !=(double value) const { return impl != Seconds(value).impl; }
   bool operator <(double value) const { return impl < Seconds(value).impl; }
   bool operator >(double value) const { return impl > Seconds(value).impl; }
   bool operator <=(double value) const { return impl <= Seconds(value).impl; }
   bool operator >=(double value) const { return impl >= Seconds(value).impl; }
   bool operator ==(int value) const { return impl == Seconds(value).impl; }
   bool operator !=(int value) const { return impl != Seconds(value).impl; }
   bool operator <(int value) const { return impl < Seconds(value).impl; }
   bool operator >(int value) const { return impl > Seconds(value).impl; }
   bool operator <=(int value) const { return impl <= Seconds(value).impl; }
   bool operator >=(int value) const { return impl >= Seconds(value).impl; }
};

class TimeStamp : public SecSince1970
{
public:
   constexpr TimeStamp() : SecSince1970() { }
   constexpr TimeStamp(const SecSince1970 value) : SecSince1970(value) { }
   constexpr TimeStamp(int64 value) : SecSince1970(TIMESTAMP(value)) { }
   constexpr operator int64() const { return SecSince1970_in_TimeStamp(impl); }
   constexpr TimeStamp & operator =(int64 value) { impl = TIMESTAMP(value); return *this; }
   bool operator ==(const TimeStamp & value) const { return impl == value.impl; }
   bool operator !=(const TimeStamp & value) const { return impl != value.impl; }
   bool operator <(const TimeStamp & value) const { return impl < value.impl; }
   bool operator >(const TimeStamp & value) const { return impl > value.impl; }
   bool operator <=(const TimeStamp & value) const { return impl <= value.impl; }
   bool operator >=(const TimeStamp & value) const { return impl >= value.impl; }
   bool operator ==(int64 value) const { return impl == TimeStamp(value).impl; }
   bool operator !=(int64 value) const { return impl != TimeStamp(value).impl; }
   bool operator <(int64 value) const { return impl < TimeStamp(value).impl; }
   bool operator >(int64 value) const { return impl > TimeStamp(value).impl; }
   bool operator <=(int64 value) const { return impl <= TimeStamp(value).impl; }
   bool operator >=(int64 value) const { return impl >= TimeStamp(value).impl; }
};

class TimeStamp32
{
public:
   C(TimeStamp32) impl;
   constexpr TimeStamp32() : impl(0) { }
   constexpr TimeStamp32(C(TimeStamp32) value) : impl(value) { }
   operator C(TimeStamp32)() const { return impl; }
   constexpr TimeStamp32(const TimeStamp32 & value) : impl(value.impl) { }
   TimeStamp32 & operator =(uint value) { impl = value; return *this; }
   TimeStamp32 & operator +=(TimeStamp32 value) { impl += value.impl; return *this; }
   TimeStamp32 & operator -=(TimeStamp32 value) { impl -= value.impl; return *this; }
   TimeStamp32 operator +(const TimeStamp32 & b) const { return TimeStamp32(impl + b.impl); }
   TimeStamp32 operator -(const TimeStamp32 & b) const { return TimeStamp32(impl - b.impl); }
   bool operator ==(const TimeStamp32 & value) const { return impl == value.impl; }
   bool operator !=(const TimeStamp32 & value) const { return impl != value.impl; }
   bool operator <(const TimeStamp32 & value) const { return impl < value.impl; }
   bool operator >(const TimeStamp32 & value) const { return impl > value.impl; }
   bool operator <=(const TimeStamp32 & value) const { return impl <= value.impl; }
   bool operator >=(const TimeStamp32 & value) const { return impl >= value.impl; }
   bool operator ==(uint value) const { return impl == TimeStamp32(value).impl; }
   bool operator !=(uint value) const { return impl != TimeStamp32(value).impl; }
   bool operator <(uint value) const { return impl < TimeStamp32(value).impl; }
   bool operator >(uint value) const { return impl > TimeStamp32(value).impl; }
   bool operator <=(uint value) const { return impl <= TimeStamp32(value).impl; }
   bool operator >=(uint value) const { return impl >= TimeStamp32(value).impl; }
};

template<typename TTT> C(Class) * class_of(char v) { return CO(char); };
template<typename TTT> C(Class) * class_of(short v) { return CO(short); };
template<typename TTT> C(Class) * class_of(int v) { return CO(int); };
template<typename TTT> C(Class) * class_of(int64 v) { return CO(int64); };
template<typename TTT> C(Class) * class_of(uint v) { return CO(uint); };
template<typename TTT> C(Class) * class_of(uint64 v) { return CO(uint64); };
template<typename TTT> C(Class) * class_of(float v) { return CO(float); };
template<typename TTT> C(Class) * class_of(double v) { return CO(double); };
template<typename TTT> C(Class) * class_of(const char * v) { return CO(String); };
template<typename TTT> C(Class) * class_of(char * v) { return CO(String); };
template<typename TTT> C(Class) * class_of(const Instance & v) { return v.impl ? v.impl->_class : v._cpp_class.impl; };

template<typename TTT> inline typename std::enable_if<
   std::is_base_of<Struct, typename std::remove_reference<TTT>::type>::value, C(Class) *>::type
   class_of(const TTT & v)
{
    return std::remove_reference_t<TTT>::_class;
};

#define classof(x) class_of<decltype(x)>((x))

template <typename TTT, C(Class) ** TCO> inline const void * vapass(TNHInstance<TTT, TCO> & f) { return f.impl; }

inline const void * vapass(const char * f) { return f; }
inline const void * vapass(const short & f) { return &f; }
inline const void * vapass(const int & f) { return &f; }
inline const void * vapass(const int64 & f) { return &f; }
inline const void * vapass(const uint & f) { return &f; }
inline const void * vapass(const uint64 & f) { return &f; }
inline const void * vapass(const float & f) { return &f; }
inline const void * vapass(const double & f) { return &f; }
inline const void * vapass(const Instance & f) { return f.impl; }
inline const void * vapass(const Struct & f) { return &f; }


template <typename TSC>
inline int TStruct<TSC>::Struct_onCompare_Functor::operator()( /*6Bj*/Instance & object)
{
   return Instance_onCompare(_class, this, /*7Al*/object.impl);
}

template <typename TSC>
inline void TStruct<TSC>::Struct_onCopy_Functor::operator()( /*6Bj*/Instance & newData)
{
   _onCopy(_class, this, /*7Al*/newData.impl);
}

template <typename TSC>
inline void TStruct<TSC>::Struct_onDisplay_Functor::operator()( /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags)
{
   _onDisplay(_class, this, /*7Al*/surface.impl, /*7Al*/x, /*7Al*/y, /*7Al*/width, /*7Al*/fieldData, /*7Al*/alignment, /*7Al*/displayFlags);
}

template <typename TSC>
inline Instance & TStruct<TSC>::Struct_onEdit_Functor::operator()( /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData)
{
   C(Instance) retInstance = Instance_onEdit(_class, this, /*7Al*/dataBox.impl, /*7Al*/obsolete.impl, /*7Al*/x, /*7Al*/y, /*7Al*/w, /*7Al*/h, /*7Al*/userData);
         return *(Instance *)INSTANCEL(retInstance, retInstance->_class);
}

template <typename TSC>
inline void TStruct<TSC>::Struct_onFree_Functor::operator()( )
{
   _onFree(_class, this);
}

template <typename TSC>
inline bool TStruct<TSC>::Struct_onGetDataFromString_Functor::operator()( /*6Fj*/const char * string)
{
   return (bool)Instance_onGetDataFromString(_class, this, /*7Al*/string);
}

template <typename TSC>
inline const char * TStruct<TSC>::Struct_onGetString_Functor::operator()( /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType)
{
   return Instance_onGetString(_class, this, /*7Al*/tempString, /*7Al*/reserved, /*7Al*/(C(ObjectNotationType) *)onType);
}

template <typename TSC>
inline bool TStruct<TSC>::Struct_onSaveEdit_Functor::operator()( /*6Fj*/Instance & window, /*6Fj*/void * object)
{
   return (bool)Instance_onSaveEdit(_class, this, /*7Al*/window.impl, /*7Al*/object);
}

template <typename TSC>
inline void TStruct<TSC>::Struct_onSerialize_Functor::operator()( /*6Fj*/IOChannel & channel)
{
   _onSerialize(_class, this, /*7Al*/channel.impl);
}

template <typename TSC>
inline void TStruct<TSC>::Struct_onUnserialize_Functor::operator()( /*6Fj*/IOChannel & channel)
{
   _onUnserialize(_class, this, /*7Al*/channel.impl);
}

//////////////////////////////////////////////////////////////////////////////// ////////////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////////////
////                                                                        //// ////////////////////////
////    split implementations                                               //// ////////////////////////
////                                                                        //// ////////////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////////////


/////////////////////////////////////////////////////////////// [ecrt]/ //////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////


///////////////////////////////////////////////////////////// [ecrt]/eC //////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////


////////////////////////////////////////////////////// [ecrt]/eC::types //////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////


inline Application::Application(int argc, const char ** argv = null, int exitCode = 0, bool isGUIApp = (bool)0, OldList allModules = OldList(), char * parsedCommand = null, NameSpace systemNameSpace = NameSpace()) : Application()
{
   this->argc = argc;
   this->argv = argv;
   this->exitCode = exitCode;
   this->isGUIApp = isGUIApp;
   this->allModules = allModules.impl;
   this->parsedCommand = parsedCommand;
   this->systemNameSpace = systemNameSpace.impl;
}

inline Application::Application_main_Functor::FunctionType Application::Application_main_Functor::operator= (FunctionType func)
{
   SELF(Application, main);
   if(self->vTbl == Application::_cpp_class.vTbl)
   {
      uint size = Application::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Application::Application_main_Functor::FunctionType, size);
      memcpy(self->vTbl, Application::_cpp_class.vTbl, sizeof(Application::Application_main_Functor::FunctionType) * size);
   }
   ((Application::Application_main_Functor::FunctionType *)self->vTbl)[M_VTBLID(Application, main)] = func;
   return func;
}
inline void Application::Application_main_Functor::operator()( )
{
   SELF(Application, main);
   Application_main(self ? self->impl : (C(Application))null);
}
// inline void Application::register_main(CPPClass & cl, Application::Application_main_Functor::FunctionType func)
// {
//    ((Application::Application_main_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Application, main)] = func;
// }



// member accessors: Application::argc
// (normal::int)

/*nstSet*/inline /*0H*/int Application::argc_Prop::operator= (/*0H*/int v)
{
   SELF(Application, argc);
   IPTR(self->impl, Application)->argc = v;
   return v;
}

/*regSet*/inline Application::argc_Prop & Application::argc_Prop::operator= (Application::argc_Prop & prop)
{
   SELF(Application, argc);
   /*0H*/int v = prop;
   IPTR(self->impl, Application)->argc = v;
   return prop;
}
/*regGet*/inline Application::argc_Prop::operator /*0I*/int () const
{
   SELF(Application, argc);
   return self ? IPTR(self->impl, Application)->argc : 0;
}

// member accessors: Application::argv
// (normal::const char **)

/*nstSet*/inline /*0H*/const char ** Application::argv_Prop::operator= (/*0H*/const char ** v)
{
   SELF(Application, argv);
   IPTR(self->impl, Application)->argv = v;
   return v;
}

/*regSet*/inline Application::argv_Prop & Application::argv_Prop::operator= (Application::argv_Prop & prop)
{
   SELF(Application, argv);
   /*0H*/const char ** v = prop;
   IPTR(self->impl, Application)->argv = v;
   return prop;
}
/*regGet*/inline Application::argv_Prop::operator /*0I*/const char ** () const
{
   SELF(Application, argv);
   return self ? IPTR(self->impl, Application)->argv : null;
}

// member accessors: Application::exitCode
// (normal::int)

/*nstSet*/inline /*0H*/int Application::exitCode_Prop::operator= (/*0H*/int v)
{
   SELF(Application, exitCode);
   IPTR(self->impl, Application)->exitCode = v;
   return v;
}

/*regSet*/inline Application::exitCode_Prop & Application::exitCode_Prop::operator= (Application::exitCode_Prop & prop)
{
   SELF(Application, exitCode);
   /*0H*/int v = prop;
   IPTR(self->impl, Application)->exitCode = v;
   return prop;
}
/*regGet*/inline Application::exitCode_Prop::operator /*0I*/int () const
{
   SELF(Application, exitCode);
   return self ? IPTR(self->impl, Application)->exitCode : 0;
}

// member accessors: Application::isGUIApp
// (normal::enum|uint)

/*nstSet*/inline /*0H*/bool Application::isGUIApp_Prop::operator= (/*0H*/bool v)
{
   SELF(Application, isGUIApp);
   IPTR(self->impl, Application)->isGUIApp = (C(bool))v;
   return v;
}

/*regSet*/inline Application::isGUIApp_Prop & Application::isGUIApp_Prop::operator= (Application::isGUIApp_Prop & prop)
{
   SELF(Application, isGUIApp);
   /*0H*/bool v = prop;
   IPTR(self->impl, Application)->isGUIApp = (C(bool))v;
   return prop;
}
/*regGet*/inline Application::isGUIApp_Prop::operator /*0I*/bool () const
{
   SELF(Application, isGUIApp);
   return self ? (bool)IPTR(self->impl, Application)->isGUIApp : (bool)0;
}

// member accessors: Application::allModules
// (normal::struct)

/*nstSet*/inline /*0H*/OldList Application::allModules_Prop::operator= (/*0H*/OldList v)
{
   SELF(Application, allModules);
   IPTR(self->impl, Application)->allModules = v.impl;
   return v;
}

/*regSet*/inline Application::allModules_Prop & Application::allModules_Prop::operator= (Application::allModules_Prop & prop)
{
   SELF(Application, allModules);
   /*0H*/OldList v = prop;
   IPTR(self->impl, Application)->allModules = v.impl;
   return prop;
}
/*regGet*/inline Application::allModules_Prop::operator /*0I*/OldList () const
{
   SELF(Application, allModules);
   OldList value(IPTR(self->impl, Application)->allModules);
   return value;
}

// member accessors: Application::parsedCommand
// (normal::char *)

/*nstSet*/inline /*0H*/char * Application::parsedCommand_Prop::operator= (/*0H*/char * v)
{
   SELF(Application, parsedCommand);
   IPTR(self->impl, Application)->parsedCommand = v;
   return v;
}

/*regSet*/inline Application::parsedCommand_Prop & Application::parsedCommand_Prop::operator= (Application::parsedCommand_Prop & prop)
{
   SELF(Application, parsedCommand);
   /*0H*/char * v = prop;
   IPTR(self->impl, Application)->parsedCommand = v;
   return prop;
}
/*regGet*/inline Application::parsedCommand_Prop::operator /*0I*/char * () const
{
   SELF(Application, parsedCommand);
   return self ? IPTR(self->impl, Application)->parsedCommand : null;
}

// member accessors: Application::systemNameSpace
// (normal::struct)

/*nstSet*/inline /*0H*/NameSpace Application::systemNameSpace_Prop::operator= (/*0H*/NameSpace v)
{
   SELF(Application, systemNameSpace);
   IPTR(self->impl, Application)->systemNameSpace = v.impl;
   return v;
}

/*regSet*/inline Application::systemNameSpace_Prop & Application::systemNameSpace_Prop::operator= (Application::systemNameSpace_Prop & prop)
{
   SELF(Application, systemNameSpace);
   /*0H*/NameSpace v = prop;
   IPTR(self->impl, Application)->systemNameSpace = v.impl;
   return prop;
}
/*regGet*/inline Application::systemNameSpace_Prop::operator /*0I*/NameSpace () const
{
   SELF(Application, systemNameSpace);
   NameSpace value(IPTR(self->impl, Application)->systemNameSpace);
   return value;
}
inline Instance::Instance_onCompare_Functor::FunctionType Instance::Instance_onCompare_Functor::operator= (FunctionType func)
{
   SELF(Instance, onCompare);
   if(self->vTbl == Instance::_cpp_class.vTbl)
   {
      uint size = Instance::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Instance::Instance_onCompare_Functor::FunctionType, size);
      memcpy(self->vTbl, Instance::_cpp_class.vTbl, sizeof(Instance::Instance_onCompare_Functor::FunctionType) * size);
   }
   ((Instance::Instance_onCompare_Functor::FunctionType *)self->vTbl)[M_VTBLID(Instance, onCompare)] = func;
   return func;
}
inline int Instance::Instance_onCompare_Functor::operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & object)
{
   SELF(Instance, onCompare);
   return Instance_onCompare(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/object.impl);
}
// inline void Instance::register_onCompare(CPPClass & cl, Instance::Instance_onCompare_Functor::FunctionType func)
// {
//    ((Instance::Instance_onCompare_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Instance, onCompare)] = func;
// }

inline Instance::Instance_onCopy_Functor::FunctionType Instance::Instance_onCopy_Functor::operator= (FunctionType func)
{
   SELF(Instance, onCopy);
   if(self->vTbl == Instance::_cpp_class.vTbl)
   {
      uint size = Instance::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Instance::Instance_onCopy_Functor::FunctionType, size);
      memcpy(self->vTbl, Instance::_cpp_class.vTbl, sizeof(Instance::Instance_onCopy_Functor::FunctionType) * size);
   }
   ((Instance::Instance_onCopy_Functor::FunctionType *)self->vTbl)[M_VTBLID(Instance, onCopy)] = func;
   return func;
}
inline void Instance::Instance_onCopy_Functor::operator()(/*6Bk*/Instance & o_ , /*6Bj*/Instance & newData)
{
   SELF(Instance, onCopy);
   Instance_onCopy(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/newData.impl);
}
// inline void Instance::register_onCopy(CPPClass & cl, Instance::Instance_onCopy_Functor::FunctionType func)
// {
//    ((Instance::Instance_onCopy_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Instance, onCopy)] = func;
// }

inline Instance::Instance_onDisplay_Functor::FunctionType Instance::Instance_onDisplay_Functor::operator= (FunctionType func)
{
   SELF(Instance, onDisplay);
   if(self->vTbl == Instance::_cpp_class.vTbl)
   {
      uint size = Instance::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Instance::Instance_onDisplay_Functor::FunctionType, size);
      memcpy(self->vTbl, Instance::_cpp_class.vTbl, sizeof(Instance::Instance_onDisplay_Functor::FunctionType) * size);
   }
   ((Instance::Instance_onDisplay_Functor::FunctionType *)self->vTbl)[M_VTBLID(Instance, onDisplay)] = func;
   return func;
}
inline void Instance::Instance_onDisplay_Functor::operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & surface, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int width, /*6Fj*/void * fieldData, /*6Fj*/int alignment, /*6Fj*/uint displayFlags)
{
   SELF(Instance, onDisplay);
   Instance_onDisplay(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/surface.impl, /*7Al*/x, /*7Al*/y, /*7Al*/width, /*7Al*/fieldData, /*7Al*/alignment, /*7Al*/displayFlags);
}
// inline void Instance::register_onDisplay(CPPClass & cl, Instance::Instance_onDisplay_Functor::FunctionType func)
// {
//    ((Instance::Instance_onDisplay_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Instance, onDisplay)] = func;
// }

inline Instance::Instance_onEdit_Functor::FunctionType Instance::Instance_onEdit_Functor::operator= (FunctionType func)
{
   SELF(Instance, onEdit);
   if(self->vTbl == Instance::_cpp_class.vTbl)
   {
      uint size = Instance::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Instance::Instance_onEdit_Functor::FunctionType, size);
      memcpy(self->vTbl, Instance::_cpp_class.vTbl, sizeof(Instance::Instance_onEdit_Functor::FunctionType) * size);
   }
   ((Instance::Instance_onEdit_Functor::FunctionType *)self->vTbl)[M_VTBLID(Instance, onEdit)] = func;
   return func;
}
inline Instance & Instance::Instance_onEdit_Functor::operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & dataBox, /*6Fj*/Instance & obsolete, /*6Fj*/int x, /*6Fj*/int y, /*6Fj*/int w, /*6Fj*/int h, /*6Fj*/void * userData)
{
   SELF(Instance, onEdit);
   C(Instance) retInstance = Instance_onEdit(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/dataBox.impl, /*7Al*/obsolete.impl, /*7Al*/x, /*7Al*/y, /*7Al*/w, /*7Al*/h, /*7Al*/userData);
      return *(Instance *)INSTANCEL(retInstance, retInstance->_class);
}
// inline void Instance::register_onEdit(CPPClass & cl, Instance::Instance_onEdit_Functor::FunctionType func)
// {
//    ((Instance::Instance_onEdit_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Instance, onEdit)] = func;
// }

inline Instance::Instance_onFree_Functor::FunctionType Instance::Instance_onFree_Functor::operator= (FunctionType func)
{
   SELF(Instance, onFree);
   if(self->vTbl == Instance::_cpp_class.vTbl)
   {
      uint size = Instance::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Instance::Instance_onFree_Functor::FunctionType, size);
      memcpy(self->vTbl, Instance::_cpp_class.vTbl, sizeof(Instance::Instance_onFree_Functor::FunctionType) * size);
   }
   ((Instance::Instance_onFree_Functor::FunctionType *)self->vTbl)[M_VTBLID(Instance, onFree)] = func;
   return func;
}
inline void Instance::Instance_onFree_Functor::operator()(/*6Bk*/Instance & o_ )
{
   SELF(Instance, onFree);
   Instance_onFree(_cpp_class.impl, self ? self->impl : (C(Instance))null);
}
// inline void Instance::register_onFree(CPPClass & cl, Instance::Instance_onFree_Functor::FunctionType func)
// {
//    ((Instance::Instance_onFree_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Instance, onFree)] = func;
// }

inline Instance::Instance_onGetDataFromString_Functor::FunctionType Instance::Instance_onGetDataFromString_Functor::operator= (FunctionType func)
{
   SELF(Instance, onGetDataFromString);
   if(self->vTbl == Instance::_cpp_class.vTbl)
   {
      uint size = Instance::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Instance::Instance_onGetDataFromString_Functor::FunctionType, size);
      memcpy(self->vTbl, Instance::_cpp_class.vTbl, sizeof(Instance::Instance_onGetDataFromString_Functor::FunctionType) * size);
   }
   ((Instance::Instance_onGetDataFromString_Functor::FunctionType *)self->vTbl)[M_VTBLID(Instance, onGetDataFromString)] = func;
   return func;
}
inline bool Instance::Instance_onGetDataFromString_Functor::operator()(/*6Bk*/Instance & o_ , /*6Fj*/const char * string)
{
   SELF(Instance, onGetDataFromString);
   return (bool)Instance_onGetDataFromString(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/string);
}
// inline void Instance::register_onGetDataFromString(CPPClass & cl, Instance::Instance_onGetDataFromString_Functor::FunctionType func)
// {
//    ((Instance::Instance_onGetDataFromString_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Instance, onGetDataFromString)] = func;
// }

inline Instance::Instance_onGetString_Functor::FunctionType Instance::Instance_onGetString_Functor::operator= (FunctionType func)
{
   SELF(Instance, onGetString);
   if(self->vTbl == Instance::_cpp_class.vTbl)
   {
      uint size = Instance::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Instance::Instance_onGetString_Functor::FunctionType, size);
      memcpy(self->vTbl, Instance::_cpp_class.vTbl, sizeof(Instance::Instance_onGetString_Functor::FunctionType) * size);
   }
   ((Instance::Instance_onGetString_Functor::FunctionType *)self->vTbl)[M_VTBLID(Instance, onGetString)] = func;
   return func;
}
inline const char * Instance::Instance_onGetString_Functor::operator()(/*6Bk*/Instance & o_ , /*6Fj*/char * tempString, /*6Fj*/void * reserved, /*6Fj*/ObjectNotationType * onType)
{
   SELF(Instance, onGetString);
   return Instance_onGetString(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/tempString, /*7Al*/reserved, /*7Al*/(C(ObjectNotationType) *)onType);
}
// inline void Instance::register_onGetString(CPPClass & cl, Instance::Instance_onGetString_Functor::FunctionType func)
// {
//    ((Instance::Instance_onGetString_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Instance, onGetString)] = func;
// }

inline Instance::Instance_onSaveEdit_Functor::FunctionType Instance::Instance_onSaveEdit_Functor::operator= (FunctionType func)
{
   SELF(Instance, onSaveEdit);
   if(self->vTbl == Instance::_cpp_class.vTbl)
   {
      uint size = Instance::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Instance::Instance_onSaveEdit_Functor::FunctionType, size);
      memcpy(self->vTbl, Instance::_cpp_class.vTbl, sizeof(Instance::Instance_onSaveEdit_Functor::FunctionType) * size);
   }
   ((Instance::Instance_onSaveEdit_Functor::FunctionType *)self->vTbl)[M_VTBLID(Instance, onSaveEdit)] = func;
   return func;
}
inline bool Instance::Instance_onSaveEdit_Functor::operator()(/*6Bk*/Instance & o_ , /*6Fj*/Instance & window, /*6Fj*/void * object)
{
   SELF(Instance, onSaveEdit);
   return (bool)Instance_onSaveEdit(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/window.impl, /*7Al*/object);
}
// inline void Instance::register_onSaveEdit(CPPClass & cl, Instance::Instance_onSaveEdit_Functor::FunctionType func)
// {
//    ((Instance::Instance_onSaveEdit_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Instance, onSaveEdit)] = func;
// }

inline Instance::Instance_onSerialize_Functor::FunctionType Instance::Instance_onSerialize_Functor::operator= (FunctionType func)
{
   SELF(Instance, onSerialize);
   if(self->vTbl == Instance::_cpp_class.vTbl)
   {
      uint size = Instance::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Instance::Instance_onSerialize_Functor::FunctionType, size);
      memcpy(self->vTbl, Instance::_cpp_class.vTbl, sizeof(Instance::Instance_onSerialize_Functor::FunctionType) * size);
   }
   ((Instance::Instance_onSerialize_Functor::FunctionType *)self->vTbl)[M_VTBLID(Instance, onSerialize)] = func;
   return func;
}
inline void Instance::Instance_onSerialize_Functor::operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel)
{
   SELF(Instance, onSerialize);
   Instance_onSerialize(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/channel.impl);
}
// inline void Instance::register_onSerialize(CPPClass & cl, Instance::Instance_onSerialize_Functor::FunctionType func)
// {
//    ((Instance::Instance_onSerialize_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Instance, onSerialize)] = func;
// }

inline Instance::Instance_onUnserialize_Functor::FunctionType Instance::Instance_onUnserialize_Functor::operator= (FunctionType func)
{
   SELF(Instance, onUnserialize);
   if(self->vTbl == Instance::_cpp_class.vTbl)
   {
      uint size = Instance::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Instance::Instance_onUnserialize_Functor::FunctionType, size);
      memcpy(self->vTbl, Instance::_cpp_class.vTbl, sizeof(Instance::Instance_onUnserialize_Functor::FunctionType) * size);
   }
   ((Instance::Instance_onUnserialize_Functor::FunctionType *)self->vTbl)[M_VTBLID(Instance, onUnserialize)] = func;
   return func;
}
inline void Instance::Instance_onUnserialize_Functor::operator()(/*6Bk*/Instance & o_ , /*6Fj*/IOChannel & channel)
{
   SELF(Instance, onUnserialize);
   Instance_onUnserialize(_cpp_class.impl, self ? self->impl : (C(Instance))null, /*7Al*/channel.impl);
}
// inline void Instance::register_onUnserialize(CPPClass & cl, Instance::Instance_onUnserialize_Functor::FunctionType func)
// {
//    ((Instance::Instance_onUnserialize_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Instance, onUnserialize)] = func;
// }


inline Module::Module_onLoad_Functor::FunctionType Module::Module_onLoad_Functor::operator= (FunctionType func)
{
   SELF(Module, onLoad);
   if(self->vTbl == Module::_cpp_class.vTbl)
   {
      uint size = Module::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Module::Module_onLoad_Functor::FunctionType, size);
      memcpy(self->vTbl, Module::_cpp_class.vTbl, sizeof(Module::Module_onLoad_Functor::FunctionType) * size);
   }
   ((Module::Module_onLoad_Functor::FunctionType *)self->vTbl)[M_VTBLID(Module, onLoad)] = func;
   return func;
}
inline bool Module::Module_onLoad_Functor::operator()( )
{
   SELF(Module, onLoad);
   return (bool)Module_onLoad(self ? self->impl : (C(Module))null);
}
// inline void Module::register_onLoad(CPPClass & cl, Module::Module_onLoad_Functor::FunctionType func)
// {
//    ((Module::Module_onLoad_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Module, onLoad)] = func;
// }

inline Module::Module_onUnload_Functor::FunctionType Module::Module_onUnload_Functor::operator= (FunctionType func)
{
   SELF(Module, onUnload);
   if(self->vTbl == Module::_cpp_class.vTbl)
   {
      uint size = Module::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Module::Module_onUnload_Functor::FunctionType, size);
      memcpy(self->vTbl, Module::_cpp_class.vTbl, sizeof(Module::Module_onUnload_Functor::FunctionType) * size);
   }
   ((Module::Module_onUnload_Functor::FunctionType *)self->vTbl)[M_VTBLID(Module, onUnload)] = func;
   return func;
}
inline void Module::Module_onUnload_Functor::operator()( )
{
   SELF(Module, onUnload);
   Module_onUnload(self ? self->impl : (C(Module))null);
}
// inline void Module::register_onUnload(CPPClass & cl, Module::Module_onUnload_Functor::FunctionType func)
// {
//    ((Module::Module_onUnload_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Module, onUnload)] = func;
// }


/////////////////////////////////////////////////////////////// [ecrt]/ //////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////


///////////////////////////////////////////////////////////// [ecrt]/eC //////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////




// member accessors: FieldTypeEx::type
// (bits::enum|int)

/*nstSet*/inline /*0H*/FieldType FieldTypeEx::type_Prop::operator= (/*0H*/FieldType v)
{
   SELF(FieldTypeEx, type);
   FIELDTYPEEX_SET_type(self->impl, v);
   return v;
}

/*regSet*/inline FieldTypeEx::type_Prop & FieldTypeEx::type_Prop::operator= (FieldTypeEx::type_Prop & prop)
{
   SELF(FieldTypeEx, type);
   /*0H*/FieldType v = prop;
   FIELDTYPEEX_SET_type(self->impl, v);
   return prop;
}
/*regGet*/inline FieldTypeEx::type_Prop::operator /*0I*/FieldType () const
{
   SELF(FieldTypeEx, type);
   return (FieldType)FIELDTYPEEX_type(self->impl);
}

// member accessors: FieldTypeEx::mustFree
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FieldTypeEx::mustFree_Prop::operator= (/*0H*/bool v)
{
   SELF(FieldTypeEx, mustFree);
   FIELDTYPEEX_SET_mustFree(self->impl, v);
   return v;
}

/*regSet*/inline FieldTypeEx::mustFree_Prop & FieldTypeEx::mustFree_Prop::operator= (FieldTypeEx::mustFree_Prop & prop)
{
   SELF(FieldTypeEx, mustFree);
   /*0H*/bool v = prop;
   FIELDTYPEEX_SET_mustFree(self->impl, v);
   return prop;
}
/*regGet*/inline FieldTypeEx::mustFree_Prop::operator /*0I*/bool () const
{
   SELF(FieldTypeEx, mustFree);
   return (bool)FIELDTYPEEX_mustFree(self->impl);
}

// member accessors: FieldTypeEx::format
// (bits::enum|int)

/*nstSet*/inline /*0H*/FieldValueFormat FieldTypeEx::format_Prop::operator= (/*0H*/FieldValueFormat v)
{
   SELF(FieldTypeEx, format);
   FIELDTYPEEX_SET_format(self->impl, v);
   return v;
}

/*regSet*/inline FieldTypeEx::format_Prop & FieldTypeEx::format_Prop::operator= (FieldTypeEx::format_Prop & prop)
{
   SELF(FieldTypeEx, format);
   /*0H*/FieldValueFormat v = prop;
   FIELDTYPEEX_SET_format(self->impl, v);
   return prop;
}
/*regGet*/inline FieldTypeEx::format_Prop::operator /*0I*/FieldValueFormat () const
{
   SELF(FieldTypeEx, format);
   return (FieldValueFormat)FIELDTYPEEX_format(self->impl);
}

// member accessors: FieldTypeEx::isUnsigned
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FieldTypeEx::isUnsigned_Prop::operator= (/*0H*/bool v)
{
   SELF(FieldTypeEx, isUnsigned);
   FIELDTYPEEX_SET_isUnsigned(self->impl, v);
   return v;
}

/*regSet*/inline FieldTypeEx::isUnsigned_Prop & FieldTypeEx::isUnsigned_Prop::operator= (FieldTypeEx::isUnsigned_Prop & prop)
{
   SELF(FieldTypeEx, isUnsigned);
   /*0H*/bool v = prop;
   FIELDTYPEEX_SET_isUnsigned(self->impl, v);
   return prop;
}
/*regGet*/inline FieldTypeEx::isUnsigned_Prop::operator /*0I*/bool () const
{
   SELF(FieldTypeEx, isUnsigned);
   return (bool)FIELDTYPEEX_isUnsigned(self->impl);
}

// member accessors: FieldTypeEx::isDateTime
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FieldTypeEx::isDateTime_Prop::operator= (/*0H*/bool v)
{
   SELF(FieldTypeEx, isDateTime);
   FIELDTYPEEX_SET_isDateTime(self->impl, v);
   return v;
}

/*regSet*/inline FieldTypeEx::isDateTime_Prop & FieldTypeEx::isDateTime_Prop::operator= (FieldTypeEx::isDateTime_Prop & prop)
{
   SELF(FieldTypeEx, isDateTime);
   /*0H*/bool v = prop;
   FIELDTYPEEX_SET_isDateTime(self->impl, v);
   return prop;
}
/*regGet*/inline FieldTypeEx::isDateTime_Prop::operator /*0I*/bool () const
{
   SELF(FieldTypeEx, isDateTime);
   return (bool)FIELDTYPEEX_isDateTime(self->impl);
}

inline FieldValue::FieldValue(FieldTypeEx type, int64 i = 0, double r = 0, char * s = 0, void * b = null)
{
   impl.type = type;
   impl.i = i;
   impl.r = r;
   impl.s = s;
   impl.b = b;
}


inline int FieldValue::compareInt(/*1Ab*/FieldValue & other)
{
   return FieldValue_compareInt(&impl, /*5De*/&other.impl);
}
inline int FieldValue::compareInt(/*1Ac*/FieldValue * other)
{
   return FieldValue_compareInt(&impl, /*5Cf*/(C(FieldValue) *)other);
}
inline int FieldValue::compareReal(/*1Ab*/FieldValue & other)
{
   return FieldValue_compareReal(&impl, /*5De*/&other.impl);
}
inline int FieldValue::compareReal(/*1Ac*/FieldValue * other)
{
   return FieldValue_compareReal(&impl, /*5Cf*/(C(FieldValue) *)other);
}
inline int FieldValue::compareText(/*1Ab*/FieldValue & other)
{
   return FieldValue_compareText(&impl, /*5De*/&other.impl);
}
inline int FieldValue::compareText(/*1Ac*/FieldValue * other)
{
   return FieldValue_compareText(&impl, /*5Cf*/(C(FieldValue) *)other);
}
inline C(String) FieldValue::formatArray(/*1Ab*/char * tempString, /*1Ab*/void * fieldData, /*1Ab*/ObjectNotationType * onType)
{
   return FieldValue_formatArray(&impl, /*5Ge*/tempString, /*5Ge*/fieldData, /*5Ee*/(C(ObjectNotationType) *)onType);
}
inline C(String) FieldValue::formatFloat(/*1Ab*/char * stringOutput, /*1Ab*/bool fixDot)
{
   return FieldValue_formatFloat(&impl, /*5Ge*/stringOutput, /*5Ee*/(C(bool))fixDot);
}
inline C(String) FieldValue::formatInteger(/*1Ab*/char * stringOutput)
{
   return FieldValue_formatInteger(&impl, /*5Ge*/stringOutput);
}
inline C(String) FieldValue::formatMap(/*1Ab*/char * tempString, /*1Ab*/void * fieldData, /*1Ab*/ObjectNotationType * onType)
{
   return FieldValue_formatMap(&impl, /*5Ge*/tempString, /*5Ge*/fieldData, /*5Ee*/(C(ObjectNotationType) *)onType);
}
inline C(bool) FieldValue::getArrayOrMap(/*1Ab*/const char * string, /*1Ab*/Class destClass, /*1Ab*/void ** destination)
{
   return FieldValue_getArrayOrMap(/*5Ge*/string, /*5De*/destClass.impl, /*5Ge*/destination);
}
inline C(String) FieldValue::stringify()
{
   return FieldValue_stringify(&impl);
}


// member accessors: FieldValue::type
// (struct::bits|int)

/*nstSet*/inline /*0H*/FieldTypeEx FieldValue::type_Prop::operator= (/*0H*/FieldTypeEx v)
{
   SELF(FieldValue, type);
   self->impl.type = v;
   return v;
}

/*regSet*/inline FieldValue::type_Prop & FieldValue::type_Prop::operator= (FieldValue::type_Prop & prop)
{
   SELF(FieldValue, type);
   /*0H*/FieldTypeEx v = prop;
   self->impl.type = v;
   return prop;
}
/*regGet*/inline FieldValue::type_Prop::operator /*0I*/FieldTypeEx () const
{
   SELF(FieldValue, type);
   return self ? FieldTypeEx(((C(FieldValue) *)&self->impl)->type) : FieldTypeEx();
}

// member accessors: FieldValue::i
// (struct::int64)

/*nstSet*/inline /*0H*/int64 FieldValue::i_Prop::operator= (/*0H*/int64 v)
{
   SELF(FieldValue, i);
   self->impl.i = v;
   return v;
}

/*regSet*/inline FieldValue::i_Prop & FieldValue::i_Prop::operator= (FieldValue::i_Prop & prop)
{
   SELF(FieldValue, i);
   /*0H*/int64 v = prop;
   self->impl.i = v;
   return prop;
}
/*regGet*/inline FieldValue::i_Prop::operator /*0I*/int64 () const
{
   SELF(FieldValue, i);
   return self ? ((C(FieldValue) *)&self->impl)->i : 0;
}

// member accessors: FieldValue::r
// (struct::double)

/*nstSet*/inline /*0H*/double FieldValue::r_Prop::operator= (/*0H*/double v)
{
   SELF(FieldValue, r);
   self->impl.r = v;
   return v;
}

/*regSet*/inline FieldValue::r_Prop & FieldValue::r_Prop::operator= (FieldValue::r_Prop & prop)
{
   SELF(FieldValue, r);
   /*0H*/double v = prop;
   self->impl.r = v;
   return prop;
}
/*regGet*/inline FieldValue::r_Prop::operator /*0I*/double () const
{
   SELF(FieldValue, r);
   return self ? ((C(FieldValue) *)&self->impl)->r : 0;
}

// member accessors: FieldValue::s
// (struct::string)

/*nstSet*/inline /*0H*/char * FieldValue::s_Prop::operator= (/*0H*/char * v)
{
   SELF(FieldValue, s);
   self->impl.s = v;
   return v;
}

/*regSet*/inline FieldValue::s_Prop & FieldValue::s_Prop::operator= (FieldValue::s_Prop & prop)
{
   SELF(FieldValue, s);
   /*0H*/char * v = prop;
   self->impl.s = v;
   return prop;
}
/*regGet*/inline FieldValue::s_Prop::operator /*0I*/char * () const
{
   SELF(FieldValue, s);
   return self ? ((C(FieldValue) *)&self->impl)->s : 0;
}

// member accessors: FieldValue::b
// (struct::void *)

/*nstSet*/inline /*0H*/void * FieldValue::b_Prop::operator= (/*0H*/void * v)
{
   SELF(FieldValue, b);
   self->impl.b = v;
   return v;
}

/*regSet*/inline FieldValue::b_Prop & FieldValue::b_Prop::operator= (FieldValue::b_Prop & prop)
{
   SELF(FieldValue, b);
   /*0H*/void * v = prop;
   self->impl.b = v;
   return prop;
}
/*regGet*/inline FieldValue::b_Prop::operator /*0I*/void * () const
{
   SELF(FieldValue, b);
   return self ? ((C(FieldValue) *)&self->impl)->b : null;
}

// member accessors: FieldValue::a
// (struct::normal)

/*nstSet*/inline /*0H*/TArray<FieldValue _ARG int _ARG FieldValue> FieldValue::a_Prop::operator= (/*0H*/TArray<FieldValue _ARG int _ARG FieldValue> v)
{
   SELF(FieldValue, a);
   self->impl.a = ((Instance *)&v)->impl;
   return v;
}

/*regSet*/inline FieldValue::a_Prop & FieldValue::a_Prop::operator= (FieldValue::a_Prop & prop)
{
   SELF(FieldValue, a);
   /*0H*/TArray<FieldValue _ARG int _ARG FieldValue> v = prop;
   self->impl.a = ((Instance *)&v)->impl;
   return prop;
}
/*regGet*/inline FieldValue::a_Prop::operator /*0I*/TArray<FieldValue _ARG int _ARG FieldValue> () const
{
   SELF(FieldValue, a);
   TArray<FieldValue _ARG int _ARG FieldValue> value(((C(FieldValue) *)&self->impl)->a);
   return value;
}

// member accessors: FieldValue::m
// (struct::normal)

/*nstSet*/inline /*0H*/TMap<C(String) _ARG FieldValue> FieldValue::m_Prop::operator= (/*0H*/TMap<C(String) _ARG FieldValue> v)
{
   SELF(FieldValue, m);
   self->impl.m = ((Instance *)&v)->impl;
   return v;
}

/*regSet*/inline FieldValue::m_Prop & FieldValue::m_Prop::operator= (FieldValue::m_Prop & prop)
{
   SELF(FieldValue, m);
   /*0H*/TMap<C(String) _ARG FieldValue> v = prop;
   self->impl.m = ((Instance *)&v)->impl;
   return prop;
}
/*regGet*/inline FieldValue::m_Prop::operator /*0I*/TMap<C(String) _ARG FieldValue> () const
{
   SELF(FieldValue, m);
   TMap<C(String) _ARG FieldValue> value(((C(FieldValue) *)&self->impl)->m);
   return value;
}

////////////////////////////////////////////////////// [ecrt]/eC::types //////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////


#undef Pi
static constexpr Radians Pi { 3.1415926535897932384626433832795028841971 };
// B (unit:unit)



// member accessors: BTNamedLink::name
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TBTNamedLink<TC, TCO>::name_Prop::operator= (/*0H*/const char * v)
{
   SELF(BTNamedLink, name);
   ((C(BTNamedLink) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBTNamedLink<TC, TCO>::name_Prop & TBTNamedLink<TC, TCO>::name_Prop::operator= (typename TBTNamedLink<TC, TCO>::name_Prop & prop)
{
   SELF(BTNamedLink, name);
   /*0H*/const char * v = prop;
   ((C(BTNamedLink) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNamedLink<TC, TCO>::name_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TBTNamedLink TCTCO * self = CONTAINER_OF(this, TBTNamedLink TCTCO, name);
   return self ? ((C(BTNamedLink) *)self->impl)->name : null;
}

// member accessors: BTNamedLink::parent
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BTNamedLink TBTNamedLink<TC, TCO>::parent_Prop::operator= (/*0H*/BTNamedLink & v)
{
   SELF(BTNamedLink, parent);
   ((C(BTNamedLink) *)self->impl)->parent = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBTNamedLink<TC, TCO>::parent_Prop & TBTNamedLink<TC, TCO>::parent_Prop::operator= (typename TBTNamedLink<TC, TCO>::parent_Prop & prop)
{
   SELF(BTNamedLink, parent);
   /*0H*/BTNamedLink v = prop;
   ((C(BTNamedLink) *)self->impl)->parent = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNamedLink<TC, TCO>::parent_Prop::operator /*0I*/BTNamedLink () const
{
   __attribute__((unused)) TBTNamedLink TCTCO * self = CONTAINER_OF(this, TBTNamedLink TCTCO, parent);
   BTNamedLink value(((C(BTNamedLink) *)self->impl)->parent);
   return value;
}

// member accessors: BTNamedLink::left
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BTNamedLink TBTNamedLink<TC, TCO>::left_Prop::operator= (/*0H*/BTNamedLink & v)
{
   SELF(BTNamedLink, left);
   ((C(BTNamedLink) *)self->impl)->left = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBTNamedLink<TC, TCO>::left_Prop & TBTNamedLink<TC, TCO>::left_Prop::operator= (typename TBTNamedLink<TC, TCO>::left_Prop & prop)
{
   SELF(BTNamedLink, left);
   /*0H*/BTNamedLink v = prop;
   ((C(BTNamedLink) *)self->impl)->left = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNamedLink<TC, TCO>::left_Prop::operator /*0I*/BTNamedLink () const
{
   __attribute__((unused)) TBTNamedLink TCTCO * self = CONTAINER_OF(this, TBTNamedLink TCTCO, left);
   BTNamedLink value(((C(BTNamedLink) *)self->impl)->left);
   return value;
}

// member accessors: BTNamedLink::right
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BTNamedLink TBTNamedLink<TC, TCO>::right_Prop::operator= (/*0H*/BTNamedLink & v)
{
   SELF(BTNamedLink, right);
   ((C(BTNamedLink) *)self->impl)->right = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBTNamedLink<TC, TCO>::right_Prop & TBTNamedLink<TC, TCO>::right_Prop::operator= (typename TBTNamedLink<TC, TCO>::right_Prop & prop)
{
   SELF(BTNamedLink, right);
   /*0H*/BTNamedLink v = prop;
   ((C(BTNamedLink) *)self->impl)->right = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNamedLink<TC, TCO>::right_Prop::operator /*0I*/BTNamedLink () const
{
   __attribute__((unused)) TBTNamedLink TCTCO * self = CONTAINER_OF(this, TBTNamedLink TCTCO, right);
   BTNamedLink value(((C(BTNamedLink) *)self->impl)->right);
   return value;
}

// member accessors: BTNamedLink::depth
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TBTNamedLink<TC, TCO>::depth_Prop::operator= (/*0H*/int v)
{
   SELF(BTNamedLink, depth);
   ((C(BTNamedLink) *)self->impl)->depth = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBTNamedLink<TC, TCO>::depth_Prop & TBTNamedLink<TC, TCO>::depth_Prop::operator= (typename TBTNamedLink<TC, TCO>::depth_Prop & prop)
{
   SELF(BTNamedLink, depth);
   /*0H*/int v = prop;
   ((C(BTNamedLink) *)self->impl)->depth = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNamedLink<TC, TCO>::depth_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TBTNamedLink TCTCO * self = CONTAINER_OF(this, TBTNamedLink TCTCO, depth);
   return self ? ((C(BTNamedLink) *)self->impl)->depth : 0;
}

// member accessors: BTNamedLink::data
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TBTNamedLink<TC, TCO>::data_Prop::operator= (/*0H*/void * v)
{
   SELF(BTNamedLink, data);
   ((C(BTNamedLink) *)self->impl)->data = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBTNamedLink<TC, TCO>::data_Prop & TBTNamedLink<TC, TCO>::data_Prop::operator= (typename TBTNamedLink<TC, TCO>::data_Prop & prop)
{
   SELF(BTNamedLink, data);
   /*0H*/void * v = prop;
   ((C(BTNamedLink) *)self->impl)->data = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNamedLink<TC, TCO>::data_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TBTNamedLink TCTCO * self = CONTAINER_OF(this, TBTNamedLink TCTCO, data);
   return self ? ((C(BTNamedLink) *)self->impl)->data : null;
}



// member accessors: BitMember::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BitMember TBitMember<TC, TCO>::prev_Prop::operator= (/*0H*/BitMember & v)
{
   SELF(BitMember, prev);
   ((C(BitMember) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::prev_Prop & TBitMember<TC, TCO>::prev_Prop::operator= (typename TBitMember<TC, TCO>::prev_Prop & prop)
{
   SELF(BitMember, prev);
   /*0H*/BitMember v = prop;
   ((C(BitMember) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::prev_Prop::operator /*0I*/BitMember () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, prev);
   BitMember value(((C(BitMember) *)self->impl)->prev);
   return value;
}

// member accessors: BitMember::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BitMember TBitMember<TC, TCO>::next_Prop::operator= (/*0H*/BitMember & v)
{
   SELF(BitMember, next);
   ((C(BitMember) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::next_Prop & TBitMember<TC, TCO>::next_Prop::operator= (typename TBitMember<TC, TCO>::next_Prop & prop)
{
   SELF(BitMember, next);
   /*0H*/BitMember v = prop;
   ((C(BitMember) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::next_Prop::operator /*0I*/BitMember () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, next);
   BitMember value(((C(BitMember) *)self->impl)->next);
   return value;
}

// member accessors: BitMember::name
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TBitMember<TC, TCO>::name_Prop::operator= (/*0H*/const char * v)
{
   SELF(BitMember, name);
   ((C(BitMember) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::name_Prop & TBitMember<TC, TCO>::name_Prop::operator= (typename TBitMember<TC, TCO>::name_Prop & prop)
{
   SELF(BitMember, name);
   /*0H*/const char * v = prop;
   ((C(BitMember) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::name_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, name);
   return self ? ((C(BitMember) *)self->impl)->name : null;
}

// member accessors: BitMember::isProperty
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TBitMember<TC, TCO>::isProperty_Prop::operator= (/*0H*/bool v)
{
   SELF(BitMember, isProperty);
   ((C(BitMember) *)self->impl)->isProperty = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::isProperty_Prop & TBitMember<TC, TCO>::isProperty_Prop::operator= (typename TBitMember<TC, TCO>::isProperty_Prop & prop)
{
   SELF(BitMember, isProperty);
   /*0H*/bool v = prop;
   ((C(BitMember) *)self->impl)->isProperty = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::isProperty_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, isProperty);
   return self ? ((C(BitMember) *)self->impl)->isProperty : (bool)0;
}

// member accessors: BitMember::memberAccess
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Access_Mode TBitMember<TC, TCO>::memberAccess_Prop::operator= (/*0H*/Access_Mode v)
{
   SELF(BitMember, memberAccess);
   ((C(BitMember) *)self->impl)->memberAccess = (C(AccessMode))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::memberAccess_Prop & TBitMember<TC, TCO>::memberAccess_Prop::operator= (typename TBitMember<TC, TCO>::memberAccess_Prop & prop)
{
   SELF(BitMember, memberAccess);
   /*0H*/Access_Mode v = prop;
   ((C(BitMember) *)self->impl)->memberAccess = (C(AccessMode))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::memberAccess_Prop::operator /*0I*/Access_Mode () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, memberAccess);
   return self ? ((C(BitMember) *)self->impl)->memberAccess : (Access_Mode)0;
}

// member accessors: BitMember::id
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TBitMember<TC, TCO>::id_Prop::operator= (/*0H*/int v)
{
   SELF(BitMember, id);
   ((C(BitMember) *)self->impl)->id = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::id_Prop & TBitMember<TC, TCO>::id_Prop::operator= (typename TBitMember<TC, TCO>::id_Prop & prop)
{
   SELF(BitMember, id);
   /*0H*/int v = prop;
   ((C(BitMember) *)self->impl)->id = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::id_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, id);
   return self ? ((C(BitMember) *)self->impl)->id : 0;
}

// member accessors: BitMember::_class
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Class TBitMember<TC, TCO>::_class_Prop::operator= (/*0H*/Class & v)
{
   SELF(BitMember, _class);
   ((C(BitMember) *)self->impl)->_class = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::_class_Prop & TBitMember<TC, TCO>::_class_Prop::operator= (typename TBitMember<TC, TCO>::_class_Prop & prop)
{
   SELF(BitMember, _class);
   /*0H*/Class v = prop;
   ((C(BitMember) *)self->impl)->_class = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::_class_Prop::operator /*0I*/Class () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, _class);
   Class value(((C(BitMember) *)self->impl)->_class);
   return value;
}

// member accessors: BitMember::dataTypeString
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TBitMember<TC, TCO>::dataTypeString_Prop::operator= (/*0H*/const char * v)
{
   SELF(BitMember, dataTypeString);
   ((C(BitMember) *)self->impl)->dataTypeString = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::dataTypeString_Prop & TBitMember<TC, TCO>::dataTypeString_Prop::operator= (typename TBitMember<TC, TCO>::dataTypeString_Prop & prop)
{
   SELF(BitMember, dataTypeString);
   /*0H*/const char * v = prop;
   ((C(BitMember) *)self->impl)->dataTypeString = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::dataTypeString_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, dataTypeString);
   return self ? ((C(BitMember) *)self->impl)->dataTypeString : null;
}

// member accessors: BitMember::dataTypeClass
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Class TBitMember<TC, TCO>::dataTypeClass_Prop::operator= (/*0H*/Class & v)
{
   SELF(BitMember, dataTypeClass);
   ((C(BitMember) *)self->impl)->dataTypeClass = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::dataTypeClass_Prop & TBitMember<TC, TCO>::dataTypeClass_Prop::operator= (typename TBitMember<TC, TCO>::dataTypeClass_Prop & prop)
{
   SELF(BitMember, dataTypeClass);
   /*0H*/Class v = prop;
   ((C(BitMember) *)self->impl)->dataTypeClass = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::dataTypeClass_Prop::operator /*0I*/Class () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, dataTypeClass);
   Class value(((C(BitMember) *)self->impl)->dataTypeClass);
   return value;
}

// member accessors: BitMember::type
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/DataMemberType TBitMember<TC, TCO>::type_Prop::operator= (/*0H*/DataMemberType v)
{
   SELF(BitMember, type);
   ((C(BitMember) *)self->impl)->type = (C(DataMemberType))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::type_Prop & TBitMember<TC, TCO>::type_Prop::operator= (typename TBitMember<TC, TCO>::type_Prop & prop)
{
   SELF(BitMember, type);
   /*0H*/DataMemberType v = prop;
   ((C(BitMember) *)self->impl)->type = (C(DataMemberType))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::type_Prop::operator /*0I*/DataMemberType () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, type);
   return self ? ((C(BitMember) *)self->impl)->type : (DataMemberType)0;
}

// member accessors: BitMember::size
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TBitMember<TC, TCO>::size_Prop::operator= (/*0H*/int v)
{
   SELF(BitMember, size);
   ((C(BitMember) *)self->impl)->size = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::size_Prop & TBitMember<TC, TCO>::size_Prop::operator= (typename TBitMember<TC, TCO>::size_Prop & prop)
{
   SELF(BitMember, size);
   /*0H*/int v = prop;
   ((C(BitMember) *)self->impl)->size = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::size_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, size);
   return self ? ((C(BitMember) *)self->impl)->size : 0;
}

// member accessors: BitMember::pos
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TBitMember<TC, TCO>::pos_Prop::operator= (/*0H*/int v)
{
   SELF(BitMember, pos);
   ((C(BitMember) *)self->impl)->pos = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::pos_Prop & TBitMember<TC, TCO>::pos_Prop::operator= (typename TBitMember<TC, TCO>::pos_Prop & prop)
{
   SELF(BitMember, pos);
   /*0H*/int v = prop;
   ((C(BitMember) *)self->impl)->pos = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::pos_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, pos);
   return self ? ((C(BitMember) *)self->impl)->pos : 0;
}

// member accessors: BitMember::mask
// (nohead::uint64)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/uint64 TBitMember<TC, TCO>::mask_Prop::operator= (/*0H*/uint64 v)
{
   SELF(BitMember, mask);
   ((C(BitMember) *)self->impl)->mask = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBitMember<TC, TCO>::mask_Prop & TBitMember<TC, TCO>::mask_Prop::operator= (typename TBitMember<TC, TCO>::mask_Prop & prop)
{
   SELF(BitMember, mask);
   /*0H*/uint64 v = prop;
   ((C(BitMember) *)self->impl)->mask = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBitMember<TC, TCO>::mask_Prop::operator /*0I*/uint64 () const
{
   __attribute__((unused)) TBitMember TCTCO * self = CONTAINER_OF(this, TBitMember TCTCO, mask);
   return self ? ((C(BitMember) *)self->impl)->mask : 0;
}

inline Box::Box(int left, int top = 0, int right = 0, int bottom = 0)
{
   impl.left = left;
   impl.top = top;
   impl.right = right;
   impl.bottom = bottom;
}


inline void Box::clip(/*1Ab*/Box & against)
{
   Box_clip(&impl, /*5De*/&against.impl);
}
inline void Box::clip(/*1Ac*/Box * against)
{
   Box_clip(&impl, /*5Cf*/(C(Box) *)against);
}
inline void Box::clipOffset(/*1Ab*/Box & against, /*1Ab*/int x, /*1Ab*/int y)
{
   Box_clipOffset(&impl, /*5De*/&against.impl, /*5Ge*/x, /*5Ge*/y);
}
inline void Box::clipOffset(/*1Ac*/Box * against, /*1Ac*/int x, /*1Ac*/int y)
{
   Box_clipOffset(&impl, /*5Cf*/(C(Box) *)against, /*5Gf*/x, /*5Gf*/y);
}
inline C(bool) Box::isPointInside(/*1Ab*/Point & point)
{
   return Box_isPointInside(&impl, /*5De*/&point.impl);
}
inline C(bool) Box::isPointInside(/*1Ac*/Point * point)
{
   return Box_isPointInside(&impl, /*5Cf*/(C(Point) *)point);
}
inline C(bool) Box::overlap(/*1Ab*/Box & box)
{
   return Box_overlap(&impl, /*5De*/&box.impl);
}
inline C(bool) Box::overlap(/*1Ac*/Box * box)
{
   return Box_overlap(&impl, /*5Cf*/(C(Box) *)box);
}


// property callers: Box::width
// (struct::int)

/*nstSet*/inline /*0H*/int Box::width_Prop::operator= (/*0H*/int v)
{
   SELF(Box, width);
   Box_set_width(self ? &self->impl : null, v);
   return v;
}

/*regSet*/inline Box::width_Prop & Box::width_Prop::operator= (Box::width_Prop & prop)
{
   SELF(Box, width);
   /*0H*/int v = prop;
   Box_set_width(self ? &self->impl : null, v);
   return prop;
}
/*regGet*/inline Box::width_Prop::operator /*0I*/int () const
{
   SELF(Box, width);
   return Box_get_width(self ? &self->impl : null);
}

// property callers: Box::height
// (struct::int)

/*nstSet*/inline /*0H*/int Box::height_Prop::operator= (/*0H*/int v)
{
   SELF(Box, height);
   Box_set_height(self ? &self->impl : null, v);
   return v;
}

/*regSet*/inline Box::height_Prop & Box::height_Prop::operator= (Box::height_Prop & prop)
{
   SELF(Box, height);
   /*0H*/int v = prop;
   Box_set_height(self ? &self->impl : null, v);
   return prop;
}
/*regGet*/inline Box::height_Prop::operator /*0I*/int () const
{
   SELF(Box, height);
   return Box_get_height(self ? &self->impl : null);
}


// member accessors: Box::left
// (struct::int)

/*nstSet*/inline /*0H*/int Box::left_Prop::operator= (/*0H*/int v)
{
   SELF(Box, left);
   self->impl.left = v;
   return v;
}

/*regSet*/inline Box::left_Prop & Box::left_Prop::operator= (Box::left_Prop & prop)
{
   SELF(Box, left);
   /*0H*/int v = prop;
   self->impl.left = v;
   return prop;
}
/*regGet*/inline Box::left_Prop::operator /*0I*/int () const
{
   SELF(Box, left);
   return self ? ((C(Box) *)&self->impl)->left : 0;
}

// member accessors: Box::top
// (struct::int)

/*nstSet*/inline /*0H*/int Box::top_Prop::operator= (/*0H*/int v)
{
   SELF(Box, top);
   self->impl.top = v;
   return v;
}

/*regSet*/inline Box::top_Prop & Box::top_Prop::operator= (Box::top_Prop & prop)
{
   SELF(Box, top);
   /*0H*/int v = prop;
   self->impl.top = v;
   return prop;
}
/*regGet*/inline Box::top_Prop::operator /*0I*/int () const
{
   SELF(Box, top);
   return self ? ((C(Box) *)&self->impl)->top : 0;
}

// member accessors: Box::right
// (struct::int)

/*nstSet*/inline /*0H*/int Box::right_Prop::operator= (/*0H*/int v)
{
   SELF(Box, right);
   self->impl.right = v;
   return v;
}

/*regSet*/inline Box::right_Prop & Box::right_Prop::operator= (Box::right_Prop & prop)
{
   SELF(Box, right);
   /*0H*/int v = prop;
   self->impl.right = v;
   return prop;
}
/*regGet*/inline Box::right_Prop::operator /*0I*/int () const
{
   SELF(Box, right);
   return self ? ((C(Box) *)&self->impl)->right : 0;
}

// member accessors: Box::bottom
// (struct::int)

/*nstSet*/inline /*0H*/int Box::bottom_Prop::operator= (/*0H*/int v)
{
   SELF(Box, bottom);
   self->impl.bottom = v;
   return v;
}

/*regSet*/inline Box::bottom_Prop & Box::bottom_Prop::operator= (Box::bottom_Prop & prop)
{
   SELF(Box, bottom);
   /*0H*/int v = prop;
   self->impl.bottom = v;
   return prop;
}
/*regGet*/inline Box::bottom_Prop::operator /*0I*/int () const
{
   SELF(Box, bottom);
   return self ? ((C(Box) *)&self->impl)->bottom : 0;
}
// A (unit:unit)
inline constexpr Centimeters::operator Meters() const { return Meters(impl); }
inline constexpr Centimeters::Centimeters(const Meters & m) : Distance(m.impl) { }
inline constexpr Centimeters & Centimeters::operator =(const Meters & m) { impl = m.impl; return *this; }



// member accessors: Class::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Class TClass<TC, TCO>::prev_Prop::operator= (/*0H*/Class & v)
{
   SELF(Class, prev);
   ((C(Class) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::prev_Prop & TClass<TC, TCO>::prev_Prop::operator= (typename TClass<TC, TCO>::prev_Prop & prop)
{
   SELF(Class, prev);
   /*0H*/Class v = prop;
   ((C(Class) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::prev_Prop::operator /*0I*/Class () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, prev);
   Class value(((C(Class) *)self->impl)->prev);
   return value;
}

// member accessors: Class::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Class TClass<TC, TCO>::next_Prop::operator= (/*0H*/Class & v)
{
   SELF(Class, next);
   ((C(Class) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::next_Prop & TClass<TC, TCO>::next_Prop::operator= (typename TClass<TC, TCO>::next_Prop & prop)
{
   SELF(Class, next);
   /*0H*/Class v = prop;
   ((C(Class) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::next_Prop::operator /*0I*/Class () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, next);
   Class value(((C(Class) *)self->impl)->next);
   return value;
}

// member accessors: Class::name
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TClass<TC, TCO>::name_Prop::operator= (/*0H*/const char * v)
{
   SELF(Class, name);
   ((C(Class) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::name_Prop & TClass<TC, TCO>::name_Prop::operator= (typename TClass<TC, TCO>::name_Prop & prop)
{
   SELF(Class, name);
   /*0H*/const char * v = prop;
   ((C(Class) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::name_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, name);
   return self ? ((C(Class) *)self->impl)->name : null;
}

// member accessors: Class::offset
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::offset_Prop::operator= (/*0H*/int v)
{
   SELF(Class, offset);
   ((C(Class) *)self->impl)->offset = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::offset_Prop & TClass<TC, TCO>::offset_Prop::operator= (typename TClass<TC, TCO>::offset_Prop & prop)
{
   SELF(Class, offset);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->offset = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::offset_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, offset);
   return self ? ((C(Class) *)self->impl)->offset : 0;
}

// member accessors: Class::structSize
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::structSize_Prop::operator= (/*0H*/int v)
{
   SELF(Class, structSize);
   ((C(Class) *)self->impl)->structSize = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::structSize_Prop & TClass<TC, TCO>::structSize_Prop::operator= (typename TClass<TC, TCO>::structSize_Prop & prop)
{
   SELF(Class, structSize);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->structSize = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::structSize_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, structSize);
   return self ? ((C(Class) *)self->impl)->structSize : 0;
}

// member accessors: Class::_vTbl
// (nohead::void * *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void ** TClass<TC, TCO>::_vTbl_Prop::operator= (/*0H*/void ** v)
{
   SELF(Class, _vTbl);
   ((C(Class) *)self->impl)->_vTbl = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::_vTbl_Prop & TClass<TC, TCO>::_vTbl_Prop::operator= (typename TClass<TC, TCO>::_vTbl_Prop & prop)
{
   SELF(Class, _vTbl);
   /*0H*/void ** v = prop;
   ((C(Class) *)self->impl)->_vTbl = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::_vTbl_Prop::operator /*0I*/void ** () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, _vTbl);
   return self ? ((C(Class) *)self->impl)->_vTbl : null;
}

// member accessors: Class::vTblSize
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::vTblSize_Prop::operator= (/*0H*/int v)
{
   SELF(Class, vTblSize);
   ((C(Class) *)self->impl)->vTblSize = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::vTblSize_Prop & TClass<TC, TCO>::vTblSize_Prop::operator= (typename TClass<TC, TCO>::vTblSize_Prop & prop)
{
   SELF(Class, vTblSize);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->vTblSize = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::vTblSize_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, vTblSize);
   return self ? ((C(Class) *)self->impl)->vTblSize : 0;
}

// member accessors: Class::offsetClass
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::offsetClass_Prop::operator= (/*0H*/int v)
{
   SELF(Class, offsetClass);
   ((C(Class) *)self->impl)->offsetClass = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::offsetClass_Prop & TClass<TC, TCO>::offsetClass_Prop::operator= (typename TClass<TC, TCO>::offsetClass_Prop & prop)
{
   SELF(Class, offsetClass);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->offsetClass = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::offsetClass_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, offsetClass);
   return self ? ((C(Class) *)self->impl)->offsetClass : 0;
}

// member accessors: Class::sizeClass
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::sizeClass_Prop::operator= (/*0H*/int v)
{
   SELF(Class, sizeClass);
   ((C(Class) *)self->impl)->sizeClass = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::sizeClass_Prop & TClass<TC, TCO>::sizeClass_Prop::operator= (typename TClass<TC, TCO>::sizeClass_Prop & prop)
{
   SELF(Class, sizeClass);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->sizeClass = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::sizeClass_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, sizeClass);
   return self ? ((C(Class) *)self->impl)->sizeClass : 0;
}

// member accessors: Class::base
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Class TClass<TC, TCO>::base_Prop::operator= (/*0H*/Class & v)
{
   SELF(Class, base);
   ((C(Class) *)self->impl)->base = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::base_Prop & TClass<TC, TCO>::base_Prop::operator= (typename TClass<TC, TCO>::base_Prop & prop)
{
   SELF(Class, base);
   /*0H*/Class v = prop;
   ((C(Class) *)self->impl)->base = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::base_Prop::operator /*0I*/Class () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, base);
   Class value(((C(Class) *)self->impl)->base);
   return value;
}

// member accessors: Class::methods
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BinaryTree TClass<TC, TCO>::methods_Prop::operator= (/*0H*/BinaryTree v)
{
   SELF(Class, methods);
   ((C(Class) *)self->impl)->methods = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::methods_Prop & TClass<TC, TCO>::methods_Prop::operator= (typename TClass<TC, TCO>::methods_Prop & prop)
{
   SELF(Class, methods);
   /*0H*/BinaryTree v = prop;
   ((C(Class) *)self->impl)->methods = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::methods_Prop::operator /*0I*/BinaryTree () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, methods);
   BinaryTree value(((C(Class) *)self->impl)->methods);
   return value;
}

// member accessors: Class::members
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BinaryTree TClass<TC, TCO>::members_Prop::operator= (/*0H*/BinaryTree v)
{
   SELF(Class, members);
   ((C(Class) *)self->impl)->members = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::members_Prop & TClass<TC, TCO>::members_Prop::operator= (typename TClass<TC, TCO>::members_Prop & prop)
{
   SELF(Class, members);
   /*0H*/BinaryTree v = prop;
   ((C(Class) *)self->impl)->members = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::members_Prop::operator /*0I*/BinaryTree () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, members);
   BinaryTree value(((C(Class) *)self->impl)->members);
   return value;
}

// member accessors: Class::prop
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BinaryTree TClass<TC, TCO>::prop_Prop::operator= (/*0H*/BinaryTree v)
{
   SELF(Class, prop);
   ((C(Class) *)self->impl)->prop = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::prop_Prop & TClass<TC, TCO>::prop_Prop::operator= (typename TClass<TC, TCO>::prop_Prop & prop)
{
   SELF(Class, prop);
   /*0H*/BinaryTree v = prop;
   ((C(Class) *)self->impl)->prop = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::prop_Prop::operator /*0I*/BinaryTree () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, prop);
   BinaryTree value(((C(Class) *)self->impl)->prop);
   return value;
}

// member accessors: Class::membersAndProperties
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldList TClass<TC, TCO>::membersAndProperties_Prop::operator= (/*0H*/OldList v)
{
   SELF(Class, membersAndProperties);
   ((C(Class) *)self->impl)->membersAndProperties = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::membersAndProperties_Prop & TClass<TC, TCO>::membersAndProperties_Prop::operator= (typename TClass<TC, TCO>::membersAndProperties_Prop & prop)
{
   SELF(Class, membersAndProperties);
   /*0H*/OldList v = prop;
   ((C(Class) *)self->impl)->membersAndProperties = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::membersAndProperties_Prop::operator /*0I*/OldList () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, membersAndProperties);
   OldList value(((C(Class) *)self->impl)->membersAndProperties);
   return value;
}

// member accessors: Class::classProperties
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BinaryTree TClass<TC, TCO>::classProperties_Prop::operator= (/*0H*/BinaryTree v)
{
   SELF(Class, classProperties);
   ((C(Class) *)self->impl)->classProperties = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::classProperties_Prop & TClass<TC, TCO>::classProperties_Prop::operator= (typename TClass<TC, TCO>::classProperties_Prop & prop)
{
   SELF(Class, classProperties);
   /*0H*/BinaryTree v = prop;
   ((C(Class) *)self->impl)->classProperties = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::classProperties_Prop::operator /*0I*/BinaryTree () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, classProperties);
   BinaryTree value(((C(Class) *)self->impl)->classProperties);
   return value;
}

// member accessors: Class::derivatives
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldList TClass<TC, TCO>::derivatives_Prop::operator= (/*0H*/OldList v)
{
   SELF(Class, derivatives);
   ((C(Class) *)self->impl)->derivatives = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::derivatives_Prop & TClass<TC, TCO>::derivatives_Prop::operator= (typename TClass<TC, TCO>::derivatives_Prop & prop)
{
   SELF(Class, derivatives);
   /*0H*/OldList v = prop;
   ((C(Class) *)self->impl)->derivatives = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::derivatives_Prop::operator /*0I*/OldList () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, derivatives);
   OldList value(((C(Class) *)self->impl)->derivatives);
   return value;
}

// member accessors: Class::memberID
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::memberID_Prop::operator= (/*0H*/int v)
{
   SELF(Class, memberID);
   ((C(Class) *)self->impl)->memberID = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::memberID_Prop & TClass<TC, TCO>::memberID_Prop::operator= (typename TClass<TC, TCO>::memberID_Prop & prop)
{
   SELF(Class, memberID);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->memberID = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::memberID_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, memberID);
   return self ? ((C(Class) *)self->impl)->memberID : 0;
}

// member accessors: Class::startMemberID
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::startMemberID_Prop::operator= (/*0H*/int v)
{
   SELF(Class, startMemberID);
   ((C(Class) *)self->impl)->startMemberID = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::startMemberID_Prop & TClass<TC, TCO>::startMemberID_Prop::operator= (typename TClass<TC, TCO>::startMemberID_Prop & prop)
{
   SELF(Class, startMemberID);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->startMemberID = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::startMemberID_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, startMemberID);
   return self ? ((C(Class) *)self->impl)->startMemberID : 0;
}

// member accessors: Class::type
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/ClassType TClass<TC, TCO>::type_Prop::operator= (/*0H*/ClassType v)
{
   SELF(Class, type);
   ((C(Class) *)self->impl)->type = (C(ClassType))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::type_Prop & TClass<TC, TCO>::type_Prop::operator= (typename TClass<TC, TCO>::type_Prop & prop)
{
   SELF(Class, type);
   /*0H*/ClassType v = prop;
   ((C(Class) *)self->impl)->type = (C(ClassType))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::type_Prop::operator /*0I*/ClassType () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, type);
   return self ? ((C(Class) *)self->impl)->type : (ClassType)0;
}

// member accessors: Class::module
// (nohead::normal)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Module TClass<TC, TCO>::module_Prop::operator= (/*0H*/Module v)
{
   SELF(Class, module);
   ((C(Class) *)self->impl)->module = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::module_Prop & TClass<TC, TCO>::module_Prop::operator= (typename TClass<TC, TCO>::module_Prop & prop)
{
   SELF(Class, module);
   /*0H*/Module v = prop;
   ((C(Class) *)self->impl)->module = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::module_Prop::operator /*0I*/Module () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, module);
   Module value(((C(Class) *)self->impl)->module);
   return value;
}

// member accessors: Class::dataTypeString
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TClass<TC, TCO>::dataTypeString_Prop::operator= (/*0H*/const char * v)
{
   SELF(Class, dataTypeString);
   ((C(Class) *)self->impl)->dataTypeString = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::dataTypeString_Prop & TClass<TC, TCO>::dataTypeString_Prop::operator= (typename TClass<TC, TCO>::dataTypeString_Prop & prop)
{
   SELF(Class, dataTypeString);
   /*0H*/const char * v = prop;
   ((C(Class) *)self->impl)->dataTypeString = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::dataTypeString_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, dataTypeString);
   return self ? ((C(Class) *)self->impl)->dataTypeString : null;
}

// member accessors: Class::typeSize
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::typeSize_Prop::operator= (/*0H*/int v)
{
   SELF(Class, typeSize);
   ((C(Class) *)self->impl)->typeSize = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::typeSize_Prop & TClass<TC, TCO>::typeSize_Prop::operator= (typename TClass<TC, TCO>::typeSize_Prop & prop)
{
   SELF(Class, typeSize);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->typeSize = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::typeSize_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, typeSize);
   return self ? ((C(Class) *)self->impl)->typeSize : 0;
}

// member accessors: Class::defaultAlignment
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::defaultAlignment_Prop::operator= (/*0H*/int v)
{
   SELF(Class, defaultAlignment);
   ((C(Class) *)self->impl)->defaultAlignment = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::defaultAlignment_Prop & TClass<TC, TCO>::defaultAlignment_Prop::operator= (typename TClass<TC, TCO>::defaultAlignment_Prop & prop)
{
   SELF(Class, defaultAlignment);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->defaultAlignment = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::defaultAlignment_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, defaultAlignment);
   return self ? ((C(Class) *)self->impl)->defaultAlignment : 0;
}

// member accessors: Class::memberOffset
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::memberOffset_Prop::operator= (/*0H*/int v)
{
   SELF(Class, memberOffset);
   ((C(Class) *)self->impl)->memberOffset = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::memberOffset_Prop & TClass<TC, TCO>::memberOffset_Prop::operator= (typename TClass<TC, TCO>::memberOffset_Prop & prop)
{
   SELF(Class, memberOffset);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->memberOffset = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::memberOffset_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, memberOffset);
   return self ? ((C(Class) *)self->impl)->memberOffset : 0;
}

// member accessors: Class::selfWatchers
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldList TClass<TC, TCO>::selfWatchers_Prop::operator= (/*0H*/OldList v)
{
   SELF(Class, selfWatchers);
   ((C(Class) *)self->impl)->selfWatchers = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::selfWatchers_Prop & TClass<TC, TCO>::selfWatchers_Prop::operator= (typename TClass<TC, TCO>::selfWatchers_Prop & prop)
{
   SELF(Class, selfWatchers);
   /*0H*/OldList v = prop;
   ((C(Class) *)self->impl)->selfWatchers = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::selfWatchers_Prop::operator /*0I*/OldList () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, selfWatchers);
   OldList value(((C(Class) *)self->impl)->selfWatchers);
   return value;
}

// member accessors: Class::designerClass
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TClass<TC, TCO>::designerClass_Prop::operator= (/*0H*/const char * v)
{
   SELF(Class, designerClass);
   ((C(Class) *)self->impl)->designerClass = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::designerClass_Prop & TClass<TC, TCO>::designerClass_Prop::operator= (typename TClass<TC, TCO>::designerClass_Prop & prop)
{
   SELF(Class, designerClass);
   /*0H*/const char * v = prop;
   ((C(Class) *)self->impl)->designerClass = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::designerClass_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, designerClass);
   return self ? ((C(Class) *)self->impl)->designerClass : null;
}

// member accessors: Class::noExpansion
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TClass<TC, TCO>::noExpansion_Prop::operator= (/*0H*/bool v)
{
   SELF(Class, noExpansion);
   ((C(Class) *)self->impl)->noExpansion = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::noExpansion_Prop & TClass<TC, TCO>::noExpansion_Prop::operator= (typename TClass<TC, TCO>::noExpansion_Prop & prop)
{
   SELF(Class, noExpansion);
   /*0H*/bool v = prop;
   ((C(Class) *)self->impl)->noExpansion = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::noExpansion_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, noExpansion);
   return self ? ((C(Class) *)self->impl)->noExpansion : (bool)0;
}

// member accessors: Class::defaultProperty
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TClass<TC, TCO>::defaultProperty_Prop::operator= (/*0H*/const char * v)
{
   SELF(Class, defaultProperty);
   ((C(Class) *)self->impl)->defaultProperty = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::defaultProperty_Prop & TClass<TC, TCO>::defaultProperty_Prop::operator= (typename TClass<TC, TCO>::defaultProperty_Prop & prop)
{
   SELF(Class, defaultProperty);
   /*0H*/const char * v = prop;
   ((C(Class) *)self->impl)->defaultProperty = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::defaultProperty_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, defaultProperty);
   return self ? ((C(Class) *)self->impl)->defaultProperty : null;
}

// member accessors: Class::comRedefinition
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TClass<TC, TCO>::comRedefinition_Prop::operator= (/*0H*/bool v)
{
   SELF(Class, comRedefinition);
   ((C(Class) *)self->impl)->comRedefinition = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::comRedefinition_Prop & TClass<TC, TCO>::comRedefinition_Prop::operator= (typename TClass<TC, TCO>::comRedefinition_Prop & prop)
{
   SELF(Class, comRedefinition);
   /*0H*/bool v = prop;
   ((C(Class) *)self->impl)->comRedefinition = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::comRedefinition_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, comRedefinition);
   return self ? ((C(Class) *)self->impl)->comRedefinition : (bool)0;
}

// member accessors: Class::count
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::count_Prop::operator= (/*0H*/int v)
{
   SELF(Class, count);
   ((C(Class) *)self->impl)->count = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::count_Prop & TClass<TC, TCO>::count_Prop::operator= (typename TClass<TC, TCO>::count_Prop & prop)
{
   SELF(Class, count);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->count = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::count_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, count);
   return self ? ((C(Class) *)self->impl)->count : 0;
}

// member accessors: Class::isRemote
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::isRemote_Prop::operator= (/*0H*/int v)
{
   SELF(Class, isRemote);
   ((C(Class) *)self->impl)->isRemote = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::isRemote_Prop & TClass<TC, TCO>::isRemote_Prop::operator= (typename TClass<TC, TCO>::isRemote_Prop & prop)
{
   SELF(Class, isRemote);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->isRemote = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::isRemote_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, isRemote);
   return self ? ((C(Class) *)self->impl)->isRemote : 0;
}

// member accessors: Class::internalDecl
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TClass<TC, TCO>::internalDecl_Prop::operator= (/*0H*/bool v)
{
   SELF(Class, internalDecl);
   ((C(Class) *)self->impl)->internalDecl = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::internalDecl_Prop & TClass<TC, TCO>::internalDecl_Prop::operator= (typename TClass<TC, TCO>::internalDecl_Prop & prop)
{
   SELF(Class, internalDecl);
   /*0H*/bool v = prop;
   ((C(Class) *)self->impl)->internalDecl = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::internalDecl_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, internalDecl);
   return self ? ((C(Class) *)self->impl)->internalDecl : (bool)0;
}

// member accessors: Class::data
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TClass<TC, TCO>::data_Prop::operator= (/*0H*/void * v)
{
   SELF(Class, data);
   ((C(Class) *)self->impl)->data = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::data_Prop & TClass<TC, TCO>::data_Prop::operator= (typename TClass<TC, TCO>::data_Prop & prop)
{
   SELF(Class, data);
   /*0H*/void * v = prop;
   ((C(Class) *)self->impl)->data = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::data_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, data);
   return self ? ((C(Class) *)self->impl)->data : null;
}

// member accessors: Class::computeSize
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TClass<TC, TCO>::computeSize_Prop::operator= (/*0H*/bool v)
{
   SELF(Class, computeSize);
   ((C(Class) *)self->impl)->computeSize = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::computeSize_Prop & TClass<TC, TCO>::computeSize_Prop::operator= (typename TClass<TC, TCO>::computeSize_Prop & prop)
{
   SELF(Class, computeSize);
   /*0H*/bool v = prop;
   ((C(Class) *)self->impl)->computeSize = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::computeSize_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, computeSize);
   return self ? ((C(Class) *)self->impl)->computeSize : (bool)0;
}

// member accessors: Class::structAlignment
// (nohead::short)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/short TClass<TC, TCO>::structAlignment_Prop::operator= (/*0H*/short v)
{
   SELF(Class, structAlignment);
   ((C(Class) *)self->impl)->structAlignment = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::structAlignment_Prop & TClass<TC, TCO>::structAlignment_Prop::operator= (typename TClass<TC, TCO>::structAlignment_Prop & prop)
{
   SELF(Class, structAlignment);
   /*0H*/short v = prop;
   ((C(Class) *)self->impl)->structAlignment = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::structAlignment_Prop::operator /*0I*/short () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, structAlignment);
   return self ? ((C(Class) *)self->impl)->structAlignment : 0;
}

// member accessors: Class::pointerAlignment
// (nohead::short)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/short TClass<TC, TCO>::pointerAlignment_Prop::operator= (/*0H*/short v)
{
   SELF(Class, pointerAlignment);
   ((C(Class) *)self->impl)->pointerAlignment = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::pointerAlignment_Prop & TClass<TC, TCO>::pointerAlignment_Prop::operator= (typename TClass<TC, TCO>::pointerAlignment_Prop & prop)
{
   SELF(Class, pointerAlignment);
   /*0H*/short v = prop;
   ((C(Class) *)self->impl)->pointerAlignment = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::pointerAlignment_Prop::operator /*0I*/short () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, pointerAlignment);
   return self ? ((C(Class) *)self->impl)->pointerAlignment : 0;
}

// member accessors: Class::destructionWatchOffset
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::destructionWatchOffset_Prop::operator= (/*0H*/int v)
{
   SELF(Class, destructionWatchOffset);
   ((C(Class) *)self->impl)->destructionWatchOffset = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::destructionWatchOffset_Prop & TClass<TC, TCO>::destructionWatchOffset_Prop::operator= (typename TClass<TC, TCO>::destructionWatchOffset_Prop & prop)
{
   SELF(Class, destructionWatchOffset);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->destructionWatchOffset = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::destructionWatchOffset_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, destructionWatchOffset);
   return self ? ((C(Class) *)self->impl)->destructionWatchOffset : 0;
}

// member accessors: Class::fixed
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TClass<TC, TCO>::fixed_Prop::operator= (/*0H*/bool v)
{
   SELF(Class, fixed);
   ((C(Class) *)self->impl)->fixed = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::fixed_Prop & TClass<TC, TCO>::fixed_Prop::operator= (typename TClass<TC, TCO>::fixed_Prop & prop)
{
   SELF(Class, fixed);
   /*0H*/bool v = prop;
   ((C(Class) *)self->impl)->fixed = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::fixed_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, fixed);
   return self ? ((C(Class) *)self->impl)->fixed : (bool)0;
}

// member accessors: Class::delayedCPValues
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldList TClass<TC, TCO>::delayedCPValues_Prop::operator= (/*0H*/OldList v)
{
   SELF(Class, delayedCPValues);
   ((C(Class) *)self->impl)->delayedCPValues = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::delayedCPValues_Prop & TClass<TC, TCO>::delayedCPValues_Prop::operator= (typename TClass<TC, TCO>::delayedCPValues_Prop & prop)
{
   SELF(Class, delayedCPValues);
   /*0H*/OldList v = prop;
   ((C(Class) *)self->impl)->delayedCPValues = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::delayedCPValues_Prop::operator /*0I*/OldList () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, delayedCPValues);
   OldList value(((C(Class) *)self->impl)->delayedCPValues);
   return value;
}

// member accessors: Class::inheritanceAccess
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Access_Mode TClass<TC, TCO>::inheritanceAccess_Prop::operator= (/*0H*/Access_Mode v)
{
   SELF(Class, inheritanceAccess);
   ((C(Class) *)self->impl)->inheritanceAccess = (C(AccessMode))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::inheritanceAccess_Prop & TClass<TC, TCO>::inheritanceAccess_Prop::operator= (typename TClass<TC, TCO>::inheritanceAccess_Prop & prop)
{
   SELF(Class, inheritanceAccess);
   /*0H*/Access_Mode v = prop;
   ((C(Class) *)self->impl)->inheritanceAccess = (C(AccessMode))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::inheritanceAccess_Prop::operator /*0I*/Access_Mode () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, inheritanceAccess);
   return self ? ((C(Class) *)self->impl)->inheritanceAccess : (Access_Mode)0;
}

// member accessors: Class::fullName
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TClass<TC, TCO>::fullName_Prop::operator= (/*0H*/const char * v)
{
   SELF(Class, fullName);
   ((C(Class) *)self->impl)->fullName = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::fullName_Prop & TClass<TC, TCO>::fullName_Prop::operator= (typename TClass<TC, TCO>::fullName_Prop & prop)
{
   SELF(Class, fullName);
   /*0H*/const char * v = prop;
   ((C(Class) *)self->impl)->fullName = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::fullName_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, fullName);
   return self ? ((C(Class) *)self->impl)->fullName : null;
}

// member accessors: Class::symbol
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TClass<TC, TCO>::symbol_Prop::operator= (/*0H*/void * v)
{
   SELF(Class, symbol);
   ((C(Class) *)self->impl)->symbol = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::symbol_Prop & TClass<TC, TCO>::symbol_Prop::operator= (typename TClass<TC, TCO>::symbol_Prop & prop)
{
   SELF(Class, symbol);
   /*0H*/void * v = prop;
   ((C(Class) *)self->impl)->symbol = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::symbol_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, symbol);
   return self ? ((C(Class) *)self->impl)->symbol : null;
}

// member accessors: Class::conversions
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldList TClass<TC, TCO>::conversions_Prop::operator= (/*0H*/OldList v)
{
   SELF(Class, conversions);
   ((C(Class) *)self->impl)->conversions = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::conversions_Prop & TClass<TC, TCO>::conversions_Prop::operator= (typename TClass<TC, TCO>::conversions_Prop & prop)
{
   SELF(Class, conversions);
   /*0H*/OldList v = prop;
   ((C(Class) *)self->impl)->conversions = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::conversions_Prop::operator /*0I*/OldList () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, conversions);
   OldList value(((C(Class) *)self->impl)->conversions);
   return value;
}

// member accessors: Class::templateParams
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldList TClass<TC, TCO>::templateParams_Prop::operator= (/*0H*/OldList v)
{
   SELF(Class, templateParams);
   ((C(Class) *)self->impl)->templateParams = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::templateParams_Prop & TClass<TC, TCO>::templateParams_Prop::operator= (typename TClass<TC, TCO>::templateParams_Prop & prop)
{
   SELF(Class, templateParams);
   /*0H*/OldList v = prop;
   ((C(Class) *)self->impl)->templateParams = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::templateParams_Prop::operator /*0I*/OldList () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, templateParams);
   OldList value(((C(Class) *)self->impl)->templateParams);
   return value;
}

// member accessors: Class::templateClass
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Class TClass<TC, TCO>::templateClass_Prop::operator= (/*0H*/Class & v)
{
   SELF(Class, templateClass);
   ((C(Class) *)self->impl)->templateClass = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::templateClass_Prop & TClass<TC, TCO>::templateClass_Prop::operator= (typename TClass<TC, TCO>::templateClass_Prop & prop)
{
   SELF(Class, templateClass);
   /*0H*/Class v = prop;
   ((C(Class) *)self->impl)->templateClass = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::templateClass_Prop::operator /*0I*/Class () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, templateClass);
   Class value(((C(Class) *)self->impl)->templateClass);
   return value;
}

// member accessors: Class::templatized
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldList TClass<TC, TCO>::templatized_Prop::operator= (/*0H*/OldList v)
{
   SELF(Class, templatized);
   ((C(Class) *)self->impl)->templatized = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::templatized_Prop & TClass<TC, TCO>::templatized_Prop::operator= (typename TClass<TC, TCO>::templatized_Prop & prop)
{
   SELF(Class, templatized);
   /*0H*/OldList v = prop;
   ((C(Class) *)self->impl)->templatized = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::templatized_Prop::operator /*0I*/OldList () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, templatized);
   OldList value(((C(Class) *)self->impl)->templatized);
   return value;
}

// member accessors: Class::numParams
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClass<TC, TCO>::numParams_Prop::operator= (/*0H*/int v)
{
   SELF(Class, numParams);
   ((C(Class) *)self->impl)->numParams = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::numParams_Prop & TClass<TC, TCO>::numParams_Prop::operator= (typename TClass<TC, TCO>::numParams_Prop & prop)
{
   SELF(Class, numParams);
   /*0H*/int v = prop;
   ((C(Class) *)self->impl)->numParams = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::numParams_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, numParams);
   return self ? ((C(Class) *)self->impl)->numParams : 0;
}

// member accessors: Class::isInstanceClass
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TClass<TC, TCO>::isInstanceClass_Prop::operator= (/*0H*/bool v)
{
   SELF(Class, isInstanceClass);
   ((C(Class) *)self->impl)->isInstanceClass = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::isInstanceClass_Prop & TClass<TC, TCO>::isInstanceClass_Prop::operator= (typename TClass<TC, TCO>::isInstanceClass_Prop & prop)
{
   SELF(Class, isInstanceClass);
   /*0H*/bool v = prop;
   ((C(Class) *)self->impl)->isInstanceClass = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::isInstanceClass_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, isInstanceClass);
   return self ? ((C(Class) *)self->impl)->isInstanceClass : (bool)0;
}

// member accessors: Class::byValueSystemClass
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TClass<TC, TCO>::byValueSystemClass_Prop::operator= (/*0H*/bool v)
{
   SELF(Class, byValueSystemClass);
   ((C(Class) *)self->impl)->byValueSystemClass = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::byValueSystemClass_Prop & TClass<TC, TCO>::byValueSystemClass_Prop::operator= (typename TClass<TC, TCO>::byValueSystemClass_Prop & prop)
{
   SELF(Class, byValueSystemClass);
   /*0H*/bool v = prop;
   ((C(Class) *)self->impl)->byValueSystemClass = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::byValueSystemClass_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, byValueSystemClass);
   return self ? ((C(Class) *)self->impl)->byValueSystemClass : (bool)0;
}

// member accessors: Class::bindingsClass
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TClass<TC, TCO>::bindingsClass_Prop::operator= (/*0H*/void * v)
{
   SELF(Class, bindingsClass);
   ((C(Class) *)self->impl)->bindingsClass = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClass<TC, TCO>::bindingsClass_Prop & TClass<TC, TCO>::bindingsClass_Prop::operator= (typename TClass<TC, TCO>::bindingsClass_Prop & prop)
{
   SELF(Class, bindingsClass);
   /*0H*/void * v = prop;
   ((C(Class) *)self->impl)->bindingsClass = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClass<TC, TCO>::bindingsClass_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TClass TCTCO * self = CONTAINER_OF(this, TClass TCTCO, bindingsClass);
   return self ? ((C(Class) *)self->impl)->bindingsClass : null;
}



// member accessors: ClassProperty::name
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TClassProperty<TC, TCO>::name_Prop::operator= (/*0H*/const char * v)
{
   SELF(ClassProperty, name);
   ((C(ClassProperty) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassProperty<TC, TCO>::name_Prop & TClassProperty<TC, TCO>::name_Prop::operator= (typename TClassProperty<TC, TCO>::name_Prop & prop)
{
   SELF(ClassProperty, name);
   /*0H*/const char * v = prop;
   ((C(ClassProperty) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassProperty<TC, TCO>::name_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TClassProperty TCTCO * self = CONTAINER_OF(this, TClassProperty TCTCO, name);
   return self ? ((C(ClassProperty) *)self->impl)->name : null;
}

// member accessors: ClassProperty::parent
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/ClassProperty TClassProperty<TC, TCO>::parent_Prop::operator= (/*0H*/ClassProperty & v)
{
   SELF(ClassProperty, parent);
   ((C(ClassProperty) *)self->impl)->parent = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassProperty<TC, TCO>::parent_Prop & TClassProperty<TC, TCO>::parent_Prop::operator= (typename TClassProperty<TC, TCO>::parent_Prop & prop)
{
   SELF(ClassProperty, parent);
   /*0H*/ClassProperty v = prop;
   ((C(ClassProperty) *)self->impl)->parent = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassProperty<TC, TCO>::parent_Prop::operator /*0I*/ClassProperty () const
{
   __attribute__((unused)) TClassProperty TCTCO * self = CONTAINER_OF(this, TClassProperty TCTCO, parent);
   ClassProperty value(((C(ClassProperty) *)self->impl)->parent);
   return value;
}

// member accessors: ClassProperty::left
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/ClassProperty TClassProperty<TC, TCO>::left_Prop::operator= (/*0H*/ClassProperty & v)
{
   SELF(ClassProperty, left);
   ((C(ClassProperty) *)self->impl)->left = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassProperty<TC, TCO>::left_Prop & TClassProperty<TC, TCO>::left_Prop::operator= (typename TClassProperty<TC, TCO>::left_Prop & prop)
{
   SELF(ClassProperty, left);
   /*0H*/ClassProperty v = prop;
   ((C(ClassProperty) *)self->impl)->left = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassProperty<TC, TCO>::left_Prop::operator /*0I*/ClassProperty () const
{
   __attribute__((unused)) TClassProperty TCTCO * self = CONTAINER_OF(this, TClassProperty TCTCO, left);
   ClassProperty value(((C(ClassProperty) *)self->impl)->left);
   return value;
}

// member accessors: ClassProperty::right
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/ClassProperty TClassProperty<TC, TCO>::right_Prop::operator= (/*0H*/ClassProperty & v)
{
   SELF(ClassProperty, right);
   ((C(ClassProperty) *)self->impl)->right = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassProperty<TC, TCO>::right_Prop & TClassProperty<TC, TCO>::right_Prop::operator= (typename TClassProperty<TC, TCO>::right_Prop & prop)
{
   SELF(ClassProperty, right);
   /*0H*/ClassProperty v = prop;
   ((C(ClassProperty) *)self->impl)->right = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassProperty<TC, TCO>::right_Prop::operator /*0I*/ClassProperty () const
{
   __attribute__((unused)) TClassProperty TCTCO * self = CONTAINER_OF(this, TClassProperty TCTCO, right);
   ClassProperty value(((C(ClassProperty) *)self->impl)->right);
   return value;
}

// member accessors: ClassProperty::depth
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TClassProperty<TC, TCO>::depth_Prop::operator= (/*0H*/int v)
{
   SELF(ClassProperty, depth);
   ((C(ClassProperty) *)self->impl)->depth = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassProperty<TC, TCO>::depth_Prop & TClassProperty<TC, TCO>::depth_Prop::operator= (typename TClassProperty<TC, TCO>::depth_Prop & prop)
{
   SELF(ClassProperty, depth);
   /*0H*/int v = prop;
   ((C(ClassProperty) *)self->impl)->depth = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassProperty<TC, TCO>::depth_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TClassProperty TCTCO * self = CONTAINER_OF(this, TClassProperty TCTCO, depth);
   return self ? ((C(ClassProperty) *)self->impl)->depth : 0;
}

// member accessors: ClassProperty::dataTypeString
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TClassProperty<TC, TCO>::dataTypeString_Prop::operator= (/*0H*/const char * v)
{
   SELF(ClassProperty, dataTypeString);
   ((C(ClassProperty) *)self->impl)->dataTypeString = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassProperty<TC, TCO>::dataTypeString_Prop & TClassProperty<TC, TCO>::dataTypeString_Prop::operator= (typename TClassProperty<TC, TCO>::dataTypeString_Prop & prop)
{
   SELF(ClassProperty, dataTypeString);
   /*0H*/const char * v = prop;
   ((C(ClassProperty) *)self->impl)->dataTypeString = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassProperty<TC, TCO>::dataTypeString_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TClassProperty TCTCO * self = CONTAINER_OF(this, TClassProperty TCTCO, dataTypeString);
   return self ? ((C(ClassProperty) *)self->impl)->dataTypeString : null;
}

// member accessors: ClassProperty::constant
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TClassProperty<TC, TCO>::constant_Prop::operator= (/*0H*/bool v)
{
   SELF(ClassProperty, constant);
   ((C(ClassProperty) *)self->impl)->constant = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassProperty<TC, TCO>::constant_Prop & TClassProperty<TC, TCO>::constant_Prop::operator= (typename TClassProperty<TC, TCO>::constant_Prop & prop)
{
   SELF(ClassProperty, constant);
   /*0H*/bool v = prop;
   ((C(ClassProperty) *)self->impl)->constant = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassProperty<TC, TCO>::constant_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TClassProperty TCTCO * self = CONTAINER_OF(this, TClassProperty TCTCO, constant);
   return self ? ((C(ClassProperty) *)self->impl)->constant : (bool)0;
}

inline ClassTemplateArgument::ClassTemplateArgument(const char * dataTypeString)
{
   impl.dataTypeString = dataTypeString;
}



// member accessors: ClassTemplateArgument::dataTypeString
// (struct::const char *)

/*nstSet*/inline /*0H*/const char * ClassTemplateArgument::dataTypeString_Prop::operator= (/*0H*/const char * v)
{
   SELF(ClassTemplateArgument, dataTypeString);
   self->impl.dataTypeString = v;
   return v;
}

/*regSet*/inline ClassTemplateArgument::dataTypeString_Prop & ClassTemplateArgument::dataTypeString_Prop::operator= (ClassTemplateArgument::dataTypeString_Prop & prop)
{
   SELF(ClassTemplateArgument, dataTypeString);
   /*0H*/const char * v = prop;
   self->impl.dataTypeString = v;
   return prop;
}
/*regGet*/inline ClassTemplateArgument::dataTypeString_Prop::operator /*0I*/const char * () const
{
   SELF(ClassTemplateArgument, dataTypeString);
   return self ? ((C(ClassTemplateArgument) *)&self->impl)->dataTypeString : null;
}

// member accessors: ClassTemplateArgument::dataTypeClass
// (struct::nohead)

/*nstSet*/inline /*0H*/Class ClassTemplateArgument::dataTypeClass_Prop::operator= (/*0H*/Class & v)
{
   SELF(ClassTemplateArgument, dataTypeClass);
   self->impl.dataTypeClass = v.impl;
   return v;
}

/*regSet*/inline ClassTemplateArgument::dataTypeClass_Prop & ClassTemplateArgument::dataTypeClass_Prop::operator= (ClassTemplateArgument::dataTypeClass_Prop & prop)
{
   SELF(ClassTemplateArgument, dataTypeClass);
   /*0H*/Class v = prop;
   self->impl.dataTypeClass = v.impl;
   return prop;
}
/*regGet*/inline ClassTemplateArgument::dataTypeClass_Prop::operator /*0I*/Class () const
{
   SELF(ClassTemplateArgument, dataTypeClass);
   Class value(((C(ClassTemplateArgument) *)&self->impl)->dataTypeClass);
   return value;
}

// member accessors: ClassTemplateArgument::expression
// (struct::struct)

/*nstSet*/inline /*0H*/DataValue ClassTemplateArgument::expression_Prop::operator= (/*0H*/DataValue v)
{
   SELF(ClassTemplateArgument, expression);
   self->impl.expression = v.impl;
   return v;
}

/*regSet*/inline ClassTemplateArgument::expression_Prop & ClassTemplateArgument::expression_Prop::operator= (ClassTemplateArgument::expression_Prop & prop)
{
   SELF(ClassTemplateArgument, expression);
   /*0H*/DataValue v = prop;
   self->impl.expression = v.impl;
   return prop;
}
/*regGet*/inline ClassTemplateArgument::expression_Prop::operator /*0I*/DataValue () const
{
   SELF(ClassTemplateArgument, expression);
   DataValue value(((C(ClassTemplateArgument) *)&self->impl)->expression);
   return value;
}

// member accessors: ClassTemplateArgument::memberString
// (struct::const char *)

/*nstSet*/inline /*0H*/const char * ClassTemplateArgument::memberString_Prop::operator= (/*0H*/const char * v)
{
   SELF(ClassTemplateArgument, memberString);
   self->impl.memberString = v;
   return v;
}

/*regSet*/inline ClassTemplateArgument::memberString_Prop & ClassTemplateArgument::memberString_Prop::operator= (ClassTemplateArgument::memberString_Prop & prop)
{
   SELF(ClassTemplateArgument, memberString);
   /*0H*/const char * v = prop;
   self->impl.memberString = v;
   return prop;
}
/*regGet*/inline ClassTemplateArgument::memberString_Prop::operator /*0I*/const char * () const
{
   SELF(ClassTemplateArgument, memberString);
   return self ? ((C(ClassTemplateArgument) *)&self->impl)->memberString : null;
}

// member accessors: ClassTemplateArgument::member
// (struct::nohead)

/*nstSet*/inline /*0H*/DataMember ClassTemplateArgument::member_Prop::operator= (/*0H*/DataMember & v)
{
   SELF(ClassTemplateArgument, member);
   self->impl.member = v.impl;
   return v;
}

/*regSet*/inline ClassTemplateArgument::member_Prop & ClassTemplateArgument::member_Prop::operator= (ClassTemplateArgument::member_Prop & prop)
{
   SELF(ClassTemplateArgument, member);
   /*0H*/DataMember v = prop;
   self->impl.member = v.impl;
   return prop;
}
/*regGet*/inline ClassTemplateArgument::member_Prop::operator /*0I*/DataMember () const
{
   SELF(ClassTemplateArgument, member);
   DataMember value(((C(ClassTemplateArgument) *)&self->impl)->member);
   return value;
}

// member accessors: ClassTemplateArgument::prop
// (struct::nohead)

/*nstSet*/inline /*0H*/Property ClassTemplateArgument::prop_Prop::operator= (/*0H*/Property & v)
{
   SELF(ClassTemplateArgument, prop);
   self->impl.prop = v.impl;
   return v;
}

/*regSet*/inline ClassTemplateArgument::prop_Prop & ClassTemplateArgument::prop_Prop::operator= (ClassTemplateArgument::prop_Prop & prop)
{
   SELF(ClassTemplateArgument, prop);
   /*0H*/Property v = prop;
   self->impl.prop = v.impl;
   return prop;
}
/*regGet*/inline ClassTemplateArgument::prop_Prop::operator /*0I*/Property () const
{
   SELF(ClassTemplateArgument, prop);
   Property value(((C(ClassTemplateArgument) *)&self->impl)->prop);
   return value;
}

// member accessors: ClassTemplateArgument::method
// (struct::nohead)

/*nstSet*/inline /*0H*/Method ClassTemplateArgument::method_Prop::operator= (/*0H*/Method & v)
{
   SELF(ClassTemplateArgument, method);
   self->impl.method = v.impl;
   return v;
}

/*regSet*/inline ClassTemplateArgument::method_Prop & ClassTemplateArgument::method_Prop::operator= (ClassTemplateArgument::method_Prop & prop)
{
   SELF(ClassTemplateArgument, method);
   /*0H*/Method v = prop;
   self->impl.method = v.impl;
   return prop;
}
/*regGet*/inline ClassTemplateArgument::method_Prop::operator /*0I*/Method () const
{
   SELF(ClassTemplateArgument, method);
   Method value(((C(ClassTemplateArgument) *)&self->impl)->method);
   return value;
}



// member accessors: ClassTemplateParameter::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/ClassTemplateParameter TClassTemplateParameter<TC, TCO>::prev_Prop::operator= (/*0H*/ClassTemplateParameter & v)
{
   SELF(ClassTemplateParameter, prev);
   ((C(ClassTemplateParameter) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassTemplateParameter<TC, TCO>::prev_Prop & TClassTemplateParameter<TC, TCO>::prev_Prop::operator= (typename TClassTemplateParameter<TC, TCO>::prev_Prop & prop)
{
   SELF(ClassTemplateParameter, prev);
   /*0H*/ClassTemplateParameter v = prop;
   ((C(ClassTemplateParameter) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassTemplateParameter<TC, TCO>::prev_Prop::operator /*0I*/ClassTemplateParameter () const
{
   __attribute__((unused)) TClassTemplateParameter TCTCO * self = CONTAINER_OF(this, TClassTemplateParameter TCTCO, prev);
   ClassTemplateParameter value(((C(ClassTemplateParameter) *)self->impl)->prev);
   return value;
}

// member accessors: ClassTemplateParameter::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/ClassTemplateParameter TClassTemplateParameter<TC, TCO>::next_Prop::operator= (/*0H*/ClassTemplateParameter & v)
{
   SELF(ClassTemplateParameter, next);
   ((C(ClassTemplateParameter) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassTemplateParameter<TC, TCO>::next_Prop & TClassTemplateParameter<TC, TCO>::next_Prop::operator= (typename TClassTemplateParameter<TC, TCO>::next_Prop & prop)
{
   SELF(ClassTemplateParameter, next);
   /*0H*/ClassTemplateParameter v = prop;
   ((C(ClassTemplateParameter) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassTemplateParameter<TC, TCO>::next_Prop::operator /*0I*/ClassTemplateParameter () const
{
   __attribute__((unused)) TClassTemplateParameter TCTCO * self = CONTAINER_OF(this, TClassTemplateParameter TCTCO, next);
   ClassTemplateParameter value(((C(ClassTemplateParameter) *)self->impl)->next);
   return value;
}

// member accessors: ClassTemplateParameter::name
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TClassTemplateParameter<TC, TCO>::name_Prop::operator= (/*0H*/const char * v)
{
   SELF(ClassTemplateParameter, name);
   ((C(ClassTemplateParameter) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassTemplateParameter<TC, TCO>::name_Prop & TClassTemplateParameter<TC, TCO>::name_Prop::operator= (typename TClassTemplateParameter<TC, TCO>::name_Prop & prop)
{
   SELF(ClassTemplateParameter, name);
   /*0H*/const char * v = prop;
   ((C(ClassTemplateParameter) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassTemplateParameter<TC, TCO>::name_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TClassTemplateParameter TCTCO * self = CONTAINER_OF(this, TClassTemplateParameter TCTCO, name);
   return self ? ((C(ClassTemplateParameter) *)self->impl)->name : null;
}

// member accessors: ClassTemplateParameter::type
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/TemplateParameterType TClassTemplateParameter<TC, TCO>::type_Prop::operator= (/*0H*/TemplateParameterType v)
{
   SELF(ClassTemplateParameter, type);
   ((C(ClassTemplateParameter) *)self->impl)->type = (C(TemplateParameterType))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassTemplateParameter<TC, TCO>::type_Prop & TClassTemplateParameter<TC, TCO>::type_Prop::operator= (typename TClassTemplateParameter<TC, TCO>::type_Prop & prop)
{
   SELF(ClassTemplateParameter, type);
   /*0H*/TemplateParameterType v = prop;
   ((C(ClassTemplateParameter) *)self->impl)->type = (C(TemplateParameterType))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassTemplateParameter<TC, TCO>::type_Prop::operator /*0I*/TemplateParameterType () const
{
   __attribute__((unused)) TClassTemplateParameter TCTCO * self = CONTAINER_OF(this, TClassTemplateParameter TCTCO, type);
   return self ? ((C(ClassTemplateParameter) *)self->impl)->type : (TemplateParameterType)0;
}

// member accessors: ClassTemplateParameter::dataTypeString
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TClassTemplateParameter<TC, TCO>::dataTypeString_Prop::operator= (/*0H*/const char * v)
{
   SELF(ClassTemplateParameter, dataTypeString);
   ((C(ClassTemplateParameter) *)self->impl)->dataTypeString = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassTemplateParameter<TC, TCO>::dataTypeString_Prop & TClassTemplateParameter<TC, TCO>::dataTypeString_Prop::operator= (typename TClassTemplateParameter<TC, TCO>::dataTypeString_Prop & prop)
{
   SELF(ClassTemplateParameter, dataTypeString);
   /*0H*/const char * v = prop;
   ((C(ClassTemplateParameter) *)self->impl)->dataTypeString = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassTemplateParameter<TC, TCO>::dataTypeString_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TClassTemplateParameter TCTCO * self = CONTAINER_OF(this, TClassTemplateParameter TCTCO, dataTypeString);
   return self ? ((C(ClassTemplateParameter) *)self->impl)->dataTypeString : null;
}

// member accessors: ClassTemplateParameter::memberType
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/TemplateMemberType TClassTemplateParameter<TC, TCO>::memberType_Prop::operator= (/*0H*/TemplateMemberType v)
{
   SELF(ClassTemplateParameter, memberType);
   ((C(ClassTemplateParameter) *)self->impl)->memberType = (C(TemplateMemberType))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassTemplateParameter<TC, TCO>::memberType_Prop & TClassTemplateParameter<TC, TCO>::memberType_Prop::operator= (typename TClassTemplateParameter<TC, TCO>::memberType_Prop & prop)
{
   SELF(ClassTemplateParameter, memberType);
   /*0H*/TemplateMemberType v = prop;
   ((C(ClassTemplateParameter) *)self->impl)->memberType = (C(TemplateMemberType))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassTemplateParameter<TC, TCO>::memberType_Prop::operator /*0I*/TemplateMemberType () const
{
   __attribute__((unused)) TClassTemplateParameter TCTCO * self = CONTAINER_OF(this, TClassTemplateParameter TCTCO, memberType);
   return self ? ((C(ClassTemplateParameter) *)self->impl)->memberType : (TemplateMemberType)0;
}

// member accessors: ClassTemplateParameter::defaultArg
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/ClassTemplateArgument TClassTemplateParameter<TC, TCO>::defaultArg_Prop::operator= (/*0H*/ClassTemplateArgument v)
{
   SELF(ClassTemplateParameter, defaultArg);
   ((C(ClassTemplateParameter) *)self->impl)->defaultArg = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassTemplateParameter<TC, TCO>::defaultArg_Prop & TClassTemplateParameter<TC, TCO>::defaultArg_Prop::operator= (typename TClassTemplateParameter<TC, TCO>::defaultArg_Prop & prop)
{
   SELF(ClassTemplateParameter, defaultArg);
   /*0H*/ClassTemplateArgument v = prop;
   ((C(ClassTemplateParameter) *)self->impl)->defaultArg = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassTemplateParameter<TC, TCO>::defaultArg_Prop::operator /*0I*/ClassTemplateArgument () const
{
   __attribute__((unused)) TClassTemplateParameter TCTCO * self = CONTAINER_OF(this, TClassTemplateParameter TCTCO, defaultArg);
   ClassTemplateArgument value(((C(ClassTemplateParameter) *)self->impl)->defaultArg);
   return value;
}

// member accessors: ClassTemplateParameter::param
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TClassTemplateParameter<TC, TCO>::param_Prop::operator= (/*0H*/void * v)
{
   SELF(ClassTemplateParameter, param);
   ((C(ClassTemplateParameter) *)self->impl)->param = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TClassTemplateParameter<TC, TCO>::param_Prop & TClassTemplateParameter<TC, TCO>::param_Prop::operator= (typename TClassTemplateParameter<TC, TCO>::param_Prop & prop)
{
   SELF(ClassTemplateParameter, param);
   /*0H*/void * v = prop;
   ((C(ClassTemplateParameter) *)self->impl)->param = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TClassTemplateParameter<TC, TCO>::param_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TClassTemplateParameter TCTCO * self = CONTAINER_OF(this, TClassTemplateParameter TCTCO, param);
   return self ? ((C(ClassTemplateParameter) *)self->impl)->param : null;
}



// member accessors: DataMember::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/DataMember TDataMember<TC, TCO>::prev_Prop::operator= (/*0H*/DataMember & v)
{
   SELF(DataMember, prev);
   ((C(DataMember) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::prev_Prop & TDataMember<TC, TCO>::prev_Prop::operator= (typename TDataMember<TC, TCO>::prev_Prop & prop)
{
   SELF(DataMember, prev);
   /*0H*/DataMember v = prop;
   ((C(DataMember) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::prev_Prop::operator /*0I*/DataMember () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, prev);
   DataMember value(((C(DataMember) *)self->impl)->prev);
   return value;
}

// member accessors: DataMember::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/DataMember TDataMember<TC, TCO>::next_Prop::operator= (/*0H*/DataMember & v)
{
   SELF(DataMember, next);
   ((C(DataMember) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::next_Prop & TDataMember<TC, TCO>::next_Prop::operator= (typename TDataMember<TC, TCO>::next_Prop & prop)
{
   SELF(DataMember, next);
   /*0H*/DataMember v = prop;
   ((C(DataMember) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::next_Prop::operator /*0I*/DataMember () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, next);
   DataMember value(((C(DataMember) *)self->impl)->next);
   return value;
}

// member accessors: DataMember::name
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TDataMember<TC, TCO>::name_Prop::operator= (/*0H*/const char * v)
{
   SELF(DataMember, name);
   ((C(DataMember) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::name_Prop & TDataMember<TC, TCO>::name_Prop::operator= (typename TDataMember<TC, TCO>::name_Prop & prop)
{
   SELF(DataMember, name);
   /*0H*/const char * v = prop;
   ((C(DataMember) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::name_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, name);
   return self ? ((C(DataMember) *)self->impl)->name : null;
}

// member accessors: DataMember::isProperty
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TDataMember<TC, TCO>::isProperty_Prop::operator= (/*0H*/bool v)
{
   SELF(DataMember, isProperty);
   ((C(DataMember) *)self->impl)->isProperty = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::isProperty_Prop & TDataMember<TC, TCO>::isProperty_Prop::operator= (typename TDataMember<TC, TCO>::isProperty_Prop & prop)
{
   SELF(DataMember, isProperty);
   /*0H*/bool v = prop;
   ((C(DataMember) *)self->impl)->isProperty = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::isProperty_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, isProperty);
   return self ? ((C(DataMember) *)self->impl)->isProperty : (bool)0;
}

// member accessors: DataMember::memberAccess
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Access_Mode TDataMember<TC, TCO>::memberAccess_Prop::operator= (/*0H*/Access_Mode v)
{
   SELF(DataMember, memberAccess);
   ((C(DataMember) *)self->impl)->memberAccess = (C(AccessMode))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::memberAccess_Prop & TDataMember<TC, TCO>::memberAccess_Prop::operator= (typename TDataMember<TC, TCO>::memberAccess_Prop & prop)
{
   SELF(DataMember, memberAccess);
   /*0H*/Access_Mode v = prop;
   ((C(DataMember) *)self->impl)->memberAccess = (C(AccessMode))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::memberAccess_Prop::operator /*0I*/Access_Mode () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, memberAccess);
   return self ? ((C(DataMember) *)self->impl)->memberAccess : (Access_Mode)0;
}

// member accessors: DataMember::id
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TDataMember<TC, TCO>::id_Prop::operator= (/*0H*/int v)
{
   SELF(DataMember, id);
   ((C(DataMember) *)self->impl)->id = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::id_Prop & TDataMember<TC, TCO>::id_Prop::operator= (typename TDataMember<TC, TCO>::id_Prop & prop)
{
   SELF(DataMember, id);
   /*0H*/int v = prop;
   ((C(DataMember) *)self->impl)->id = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::id_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, id);
   return self ? ((C(DataMember) *)self->impl)->id : 0;
}

// member accessors: DataMember::_class
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Class TDataMember<TC, TCO>::_class_Prop::operator= (/*0H*/Class & v)
{
   SELF(DataMember, _class);
   ((C(DataMember) *)self->impl)->_class = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::_class_Prop & TDataMember<TC, TCO>::_class_Prop::operator= (typename TDataMember<TC, TCO>::_class_Prop & prop)
{
   SELF(DataMember, _class);
   /*0H*/Class v = prop;
   ((C(DataMember) *)self->impl)->_class = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::_class_Prop::operator /*0I*/Class () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, _class);
   Class value(((C(DataMember) *)self->impl)->_class);
   return value;
}

// member accessors: DataMember::dataTypeString
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TDataMember<TC, TCO>::dataTypeString_Prop::operator= (/*0H*/const char * v)
{
   SELF(DataMember, dataTypeString);
   ((C(DataMember) *)self->impl)->dataTypeString = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::dataTypeString_Prop & TDataMember<TC, TCO>::dataTypeString_Prop::operator= (typename TDataMember<TC, TCO>::dataTypeString_Prop & prop)
{
   SELF(DataMember, dataTypeString);
   /*0H*/const char * v = prop;
   ((C(DataMember) *)self->impl)->dataTypeString = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::dataTypeString_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, dataTypeString);
   return self ? ((C(DataMember) *)self->impl)->dataTypeString : null;
}

// member accessors: DataMember::dataTypeClass
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Class TDataMember<TC, TCO>::dataTypeClass_Prop::operator= (/*0H*/Class & v)
{
   SELF(DataMember, dataTypeClass);
   ((C(DataMember) *)self->impl)->dataTypeClass = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::dataTypeClass_Prop & TDataMember<TC, TCO>::dataTypeClass_Prop::operator= (typename TDataMember<TC, TCO>::dataTypeClass_Prop & prop)
{
   SELF(DataMember, dataTypeClass);
   /*0H*/Class v = prop;
   ((C(DataMember) *)self->impl)->dataTypeClass = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::dataTypeClass_Prop::operator /*0I*/Class () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, dataTypeClass);
   Class value(((C(DataMember) *)self->impl)->dataTypeClass);
   return value;
}

// member accessors: DataMember::type
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/DataMemberType TDataMember<TC, TCO>::type_Prop::operator= (/*0H*/DataMemberType v)
{
   SELF(DataMember, type);
   ((C(DataMember) *)self->impl)->type = (C(DataMemberType))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::type_Prop & TDataMember<TC, TCO>::type_Prop::operator= (typename TDataMember<TC, TCO>::type_Prop & prop)
{
   SELF(DataMember, type);
   /*0H*/DataMemberType v = prop;
   ((C(DataMember) *)self->impl)->type = (C(DataMemberType))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::type_Prop::operator /*0I*/DataMemberType () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, type);
   return self ? ((C(DataMember) *)self->impl)->type : (DataMemberType)0;
}

// member accessors: DataMember::offset
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TDataMember<TC, TCO>::offset_Prop::operator= (/*0H*/int v)
{
   SELF(DataMember, offset);
   ((C(DataMember) *)self->impl)->offset = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::offset_Prop & TDataMember<TC, TCO>::offset_Prop::operator= (typename TDataMember<TC, TCO>::offset_Prop & prop)
{
   SELF(DataMember, offset);
   /*0H*/int v = prop;
   ((C(DataMember) *)self->impl)->offset = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::offset_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, offset);
   return self ? ((C(DataMember) *)self->impl)->offset : 0;
}

// member accessors: DataMember::memberID
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TDataMember<TC, TCO>::memberID_Prop::operator= (/*0H*/int v)
{
   SELF(DataMember, memberID);
   ((C(DataMember) *)self->impl)->memberID = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::memberID_Prop & TDataMember<TC, TCO>::memberID_Prop::operator= (typename TDataMember<TC, TCO>::memberID_Prop & prop)
{
   SELF(DataMember, memberID);
   /*0H*/int v = prop;
   ((C(DataMember) *)self->impl)->memberID = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::memberID_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, memberID);
   return self ? ((C(DataMember) *)self->impl)->memberID : 0;
}

// member accessors: DataMember::members
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldList TDataMember<TC, TCO>::members_Prop::operator= (/*0H*/OldList v)
{
   SELF(DataMember, members);
   ((C(DataMember) *)self->impl)->members = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::members_Prop & TDataMember<TC, TCO>::members_Prop::operator= (typename TDataMember<TC, TCO>::members_Prop & prop)
{
   SELF(DataMember, members);
   /*0H*/OldList v = prop;
   ((C(DataMember) *)self->impl)->members = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::members_Prop::operator /*0I*/OldList () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, members);
   OldList value(((C(DataMember) *)self->impl)->members);
   return value;
}

// member accessors: DataMember::membersAlpha
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BinaryTree TDataMember<TC, TCO>::membersAlpha_Prop::operator= (/*0H*/BinaryTree v)
{
   SELF(DataMember, membersAlpha);
   ((C(DataMember) *)self->impl)->membersAlpha = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::membersAlpha_Prop & TDataMember<TC, TCO>::membersAlpha_Prop::operator= (typename TDataMember<TC, TCO>::membersAlpha_Prop & prop)
{
   SELF(DataMember, membersAlpha);
   /*0H*/BinaryTree v = prop;
   ((C(DataMember) *)self->impl)->membersAlpha = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::membersAlpha_Prop::operator /*0I*/BinaryTree () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, membersAlpha);
   BinaryTree value(((C(DataMember) *)self->impl)->membersAlpha);
   return value;
}

// member accessors: DataMember::memberOffset
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TDataMember<TC, TCO>::memberOffset_Prop::operator= (/*0H*/int v)
{
   SELF(DataMember, memberOffset);
   ((C(DataMember) *)self->impl)->memberOffset = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::memberOffset_Prop & TDataMember<TC, TCO>::memberOffset_Prop::operator= (typename TDataMember<TC, TCO>::memberOffset_Prop & prop)
{
   SELF(DataMember, memberOffset);
   /*0H*/int v = prop;
   ((C(DataMember) *)self->impl)->memberOffset = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::memberOffset_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, memberOffset);
   return self ? ((C(DataMember) *)self->impl)->memberOffset : 0;
}

// member accessors: DataMember::structAlignment
// (nohead::short)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/short TDataMember<TC, TCO>::structAlignment_Prop::operator= (/*0H*/short v)
{
   SELF(DataMember, structAlignment);
   ((C(DataMember) *)self->impl)->structAlignment = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::structAlignment_Prop & TDataMember<TC, TCO>::structAlignment_Prop::operator= (typename TDataMember<TC, TCO>::structAlignment_Prop & prop)
{
   SELF(DataMember, structAlignment);
   /*0H*/short v = prop;
   ((C(DataMember) *)self->impl)->structAlignment = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::structAlignment_Prop::operator /*0I*/short () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, structAlignment);
   return self ? ((C(DataMember) *)self->impl)->structAlignment : 0;
}

// member accessors: DataMember::pointerAlignment
// (nohead::short)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/short TDataMember<TC, TCO>::pointerAlignment_Prop::operator= (/*0H*/short v)
{
   SELF(DataMember, pointerAlignment);
   ((C(DataMember) *)self->impl)->pointerAlignment = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDataMember<TC, TCO>::pointerAlignment_Prop & TDataMember<TC, TCO>::pointerAlignment_Prop::operator= (typename TDataMember<TC, TCO>::pointerAlignment_Prop & prop)
{
   SELF(DataMember, pointerAlignment);
   /*0H*/short v = prop;
   ((C(DataMember) *)self->impl)->pointerAlignment = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDataMember<TC, TCO>::pointerAlignment_Prop::operator /*0I*/short () const
{
   __attribute__((unused)) TDataMember TCTCO * self = CONTAINER_OF(this, TDataMember TCTCO, pointerAlignment);
   return self ? ((C(DataMember) *)self->impl)->pointerAlignment : 0;
}

inline DataValue::DataValue(char c, unsigned char uc = 0, short s = 0, uint16 us = 0, int i = 0, uint ui = 0, void * p = null, float f = 0, double d = 0, int64 i64 = 0, uint64 ui64 = 0)
{
   impl.c = c;
   impl.uc = uc;
   impl.s = s;
   impl.us = us;
   impl.i = i;
   impl.ui = ui;
   impl.p = p;
   impl.f = f;
   impl.d = d;
   impl.i64 = i64;
   impl.ui64 = ui64;
}



// member accessors: DataValue::c
// (struct::char)

/*nstSet*/inline /*0H*/char DataValue::c_Prop::operator= (/*0H*/char v)
{
   SELF(DataValue, c);
   self->impl.c = v;
   return v;
}

/*regSet*/inline DataValue::c_Prop & DataValue::c_Prop::operator= (DataValue::c_Prop & prop)
{
   SELF(DataValue, c);
   /*0H*/char v = prop;
   self->impl.c = v;
   return prop;
}
/*regGet*/inline DataValue::c_Prop::operator /*0I*/char () const
{
   SELF(DataValue, c);
   return self ? ((C(DataValue) *)&self->impl)->c : 0;
}

// member accessors: DataValue::uc
// (struct::byte)

/*nstSet*/inline /*0H*/unsigned char DataValue::uc_Prop::operator= (/*0H*/unsigned char v)
{
   SELF(DataValue, uc);
   self->impl.uc = v;
   return v;
}

/*regSet*/inline DataValue::uc_Prop & DataValue::uc_Prop::operator= (DataValue::uc_Prop & prop)
{
   SELF(DataValue, uc);
   /*0H*/unsigned char v = prop;
   self->impl.uc = v;
   return prop;
}
/*regGet*/inline DataValue::uc_Prop::operator /*0I*/unsigned char () const
{
   SELF(DataValue, uc);
   return self ? ((C(DataValue) *)&self->impl)->uc : 0;
}

// member accessors: DataValue::s
// (struct::short)

/*nstSet*/inline /*0H*/short DataValue::s_Prop::operator= (/*0H*/short v)
{
   SELF(DataValue, s);
   self->impl.s = v;
   return v;
}

/*regSet*/inline DataValue::s_Prop & DataValue::s_Prop::operator= (DataValue::s_Prop & prop)
{
   SELF(DataValue, s);
   /*0H*/short v = prop;
   self->impl.s = v;
   return prop;
}
/*regGet*/inline DataValue::s_Prop::operator /*0I*/short () const
{
   SELF(DataValue, s);
   return self ? ((C(DataValue) *)&self->impl)->s : 0;
}

// member accessors: DataValue::us
// (struct::uint16)

/*nstSet*/inline /*0H*/uint16 DataValue::us_Prop::operator= (/*0H*/uint16 v)
{
   SELF(DataValue, us);
   self->impl.us = v;
   return v;
}

/*regSet*/inline DataValue::us_Prop & DataValue::us_Prop::operator= (DataValue::us_Prop & prop)
{
   SELF(DataValue, us);
   /*0H*/uint16 v = prop;
   self->impl.us = v;
   return prop;
}
/*regGet*/inline DataValue::us_Prop::operator /*0I*/uint16 () const
{
   SELF(DataValue, us);
   return self ? ((C(DataValue) *)&self->impl)->us : 0;
}

// member accessors: DataValue::i
// (struct::int)

/*nstSet*/inline /*0H*/int DataValue::i_Prop::operator= (/*0H*/int v)
{
   SELF(DataValue, i);
   self->impl.i = v;
   return v;
}

/*regSet*/inline DataValue::i_Prop & DataValue::i_Prop::operator= (DataValue::i_Prop & prop)
{
   SELF(DataValue, i);
   /*0H*/int v = prop;
   self->impl.i = v;
   return prop;
}
/*regGet*/inline DataValue::i_Prop::operator /*0I*/int () const
{
   SELF(DataValue, i);
   return self ? ((C(DataValue) *)&self->impl)->i : 0;
}

// member accessors: DataValue::ui
// (struct::uint)

/*nstSet*/inline /*0H*/uint DataValue::ui_Prop::operator= (/*0H*/uint v)
{
   SELF(DataValue, ui);
   self->impl.ui = v;
   return v;
}

/*regSet*/inline DataValue::ui_Prop & DataValue::ui_Prop::operator= (DataValue::ui_Prop & prop)
{
   SELF(DataValue, ui);
   /*0H*/uint v = prop;
   self->impl.ui = v;
   return prop;
}
/*regGet*/inline DataValue::ui_Prop::operator /*0I*/uint () const
{
   SELF(DataValue, ui);
   return self ? ((C(DataValue) *)&self->impl)->ui : 0;
}

// member accessors: DataValue::p
// (struct::void *)

/*nstSet*/inline /*0H*/void * DataValue::p_Prop::operator= (/*0H*/void * v)
{
   SELF(DataValue, p);
   self->impl.p = v;
   return v;
}

/*regSet*/inline DataValue::p_Prop & DataValue::p_Prop::operator= (DataValue::p_Prop & prop)
{
   SELF(DataValue, p);
   /*0H*/void * v = prop;
   self->impl.p = v;
   return prop;
}
/*regGet*/inline DataValue::p_Prop::operator /*0I*/void * () const
{
   SELF(DataValue, p);
   return self ? ((C(DataValue) *)&self->impl)->p : null;
}

// member accessors: DataValue::f
// (struct::float)

/*nstSet*/inline /*0H*/float DataValue::f_Prop::operator= (/*0H*/float v)
{
   SELF(DataValue, f);
   self->impl.f = v;
   return v;
}

/*regSet*/inline DataValue::f_Prop & DataValue::f_Prop::operator= (DataValue::f_Prop & prop)
{
   SELF(DataValue, f);
   /*0H*/float v = prop;
   self->impl.f = v;
   return prop;
}
/*regGet*/inline DataValue::f_Prop::operator /*0I*/float () const
{
   SELF(DataValue, f);
   return self ? ((C(DataValue) *)&self->impl)->f : 0;
}

// member accessors: DataValue::d
// (struct::double)

/*nstSet*/inline /*0H*/double DataValue::d_Prop::operator= (/*0H*/double v)
{
   SELF(DataValue, d);
   self->impl.d = v;
   return v;
}

/*regSet*/inline DataValue::d_Prop & DataValue::d_Prop::operator= (DataValue::d_Prop & prop)
{
   SELF(DataValue, d);
   /*0H*/double v = prop;
   self->impl.d = v;
   return prop;
}
/*regGet*/inline DataValue::d_Prop::operator /*0I*/double () const
{
   SELF(DataValue, d);
   return self ? ((C(DataValue) *)&self->impl)->d : 0;
}

// member accessors: DataValue::i64
// (struct::int64)

/*nstSet*/inline /*0H*/int64 DataValue::i64_Prop::operator= (/*0H*/int64 v)
{
   SELF(DataValue, i64);
   self->impl.i64 = v;
   return v;
}

/*regSet*/inline DataValue::i64_Prop & DataValue::i64_Prop::operator= (DataValue::i64_Prop & prop)
{
   SELF(DataValue, i64);
   /*0H*/int64 v = prop;
   self->impl.i64 = v;
   return prop;
}
/*regGet*/inline DataValue::i64_Prop::operator /*0I*/int64 () const
{
   SELF(DataValue, i64);
   return self ? ((C(DataValue) *)&self->impl)->i64 : 0;
}

// member accessors: DataValue::ui64
// (struct::uint64)

/*nstSet*/inline /*0H*/uint64 DataValue::ui64_Prop::operator= (/*0H*/uint64 v)
{
   SELF(DataValue, ui64);
   self->impl.ui64 = v;
   return v;
}

/*regSet*/inline DataValue::ui64_Prop & DataValue::ui64_Prop::operator= (DataValue::ui64_Prop & prop)
{
   SELF(DataValue, ui64);
   /*0H*/uint64 v = prop;
   self->impl.ui64 = v;
   return prop;
}
/*regGet*/inline DataValue::ui64_Prop::operator /*0I*/uint64 () const
{
   SELF(DataValue, ui64);
   return self ? ((C(DataValue) *)&self->impl)->ui64 : 0;
}



// member accessors: DefinedExpression::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/DefinedExpression TDefinedExpression<TC, TCO>::prev_Prop::operator= (/*0H*/DefinedExpression & v)
{
   SELF(DefinedExpression, prev);
   ((C(DefinedExpression) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDefinedExpression<TC, TCO>::prev_Prop & TDefinedExpression<TC, TCO>::prev_Prop::operator= (typename TDefinedExpression<TC, TCO>::prev_Prop & prop)
{
   SELF(DefinedExpression, prev);
   /*0H*/DefinedExpression v = prop;
   ((C(DefinedExpression) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDefinedExpression<TC, TCO>::prev_Prop::operator /*0I*/DefinedExpression () const
{
   __attribute__((unused)) TDefinedExpression TCTCO * self = CONTAINER_OF(this, TDefinedExpression TCTCO, prev);
   DefinedExpression value(((C(DefinedExpression) *)self->impl)->prev);
   return value;
}

// member accessors: DefinedExpression::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/DefinedExpression TDefinedExpression<TC, TCO>::next_Prop::operator= (/*0H*/DefinedExpression & v)
{
   SELF(DefinedExpression, next);
   ((C(DefinedExpression) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDefinedExpression<TC, TCO>::next_Prop & TDefinedExpression<TC, TCO>::next_Prop::operator= (typename TDefinedExpression<TC, TCO>::next_Prop & prop)
{
   SELF(DefinedExpression, next);
   /*0H*/DefinedExpression v = prop;
   ((C(DefinedExpression) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDefinedExpression<TC, TCO>::next_Prop::operator /*0I*/DefinedExpression () const
{
   __attribute__((unused)) TDefinedExpression TCTCO * self = CONTAINER_OF(this, TDefinedExpression TCTCO, next);
   DefinedExpression value(((C(DefinedExpression) *)self->impl)->next);
   return value;
}

// member accessors: DefinedExpression::name
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TDefinedExpression<TC, TCO>::name_Prop::operator= (/*0H*/const char * v)
{
   SELF(DefinedExpression, name);
   ((C(DefinedExpression) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDefinedExpression<TC, TCO>::name_Prop & TDefinedExpression<TC, TCO>::name_Prop::operator= (typename TDefinedExpression<TC, TCO>::name_Prop & prop)
{
   SELF(DefinedExpression, name);
   /*0H*/const char * v = prop;
   ((C(DefinedExpression) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDefinedExpression<TC, TCO>::name_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TDefinedExpression TCTCO * self = CONTAINER_OF(this, TDefinedExpression TCTCO, name);
   return self ? ((C(DefinedExpression) *)self->impl)->name : null;
}

// member accessors: DefinedExpression::value
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TDefinedExpression<TC, TCO>::value_Prop::operator= (/*0H*/const char * v)
{
   SELF(DefinedExpression, value);
   ((C(DefinedExpression) *)self->impl)->value = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TDefinedExpression<TC, TCO>::value_Prop & TDefinedExpression<TC, TCO>::value_Prop::operator= (typename TDefinedExpression<TC, TCO>::value_Prop & prop)
{
   SELF(DefinedExpression, value);
   /*0H*/const char * v = prop;
   ((C(DefinedExpression) *)self->impl)->value = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TDefinedExpression<TC, TCO>::value_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TDefinedExpression TCTCO * self = CONTAINER_OF(this, TDefinedExpression TCTCO, value);
   return self ? ((C(DefinedExpression) *)self->impl)->value : null;
}
// A (unit:unit)
inline constexpr Degrees::operator Radians() const { return Radians(impl); }
inline constexpr Degrees::Degrees(const Radians & r) : Angle(r.impl) { }
inline constexpr Degrees & Degrees::operator =(const Radians & r) { impl = r.impl; return *this; }
// B (unit:unit)



// member accessors: EnumClassData::values
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldList TEnumClassData<TC, TCO>::values_Prop::operator= (/*0H*/OldList v)
{
   SELF(EnumClassData, values);
   ((C(EnumClassData) *)self->impl)->values = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TEnumClassData<TC, TCO>::values_Prop & TEnumClassData<TC, TCO>::values_Prop::operator= (typename TEnumClassData<TC, TCO>::values_Prop & prop)
{
   SELF(EnumClassData, values);
   /*0H*/OldList v = prop;
   ((C(EnumClassData) *)self->impl)->values = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TEnumClassData<TC, TCO>::values_Prop::operator /*0I*/OldList () const
{
   __attribute__((unused)) TEnumClassData TCTCO * self = CONTAINER_OF(this, TEnumClassData TCTCO, values);
   OldList value(((C(EnumClassData) *)self->impl)->values);
   return value;
}

// member accessors: EnumClassData::largest
// (nohead::int64)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int64 TEnumClassData<TC, TCO>::largest_Prop::operator= (/*0H*/int64 v)
{
   SELF(EnumClassData, largest);
   ((C(EnumClassData) *)self->impl)->largest = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TEnumClassData<TC, TCO>::largest_Prop & TEnumClassData<TC, TCO>::largest_Prop::operator= (typename TEnumClassData<TC, TCO>::largest_Prop & prop)
{
   SELF(EnumClassData, largest);
   /*0H*/int64 v = prop;
   ((C(EnumClassData) *)self->impl)->largest = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TEnumClassData<TC, TCO>::largest_Prop::operator /*0I*/int64 () const
{
   __attribute__((unused)) TEnumClassData TCTCO * self = CONTAINER_OF(this, TEnumClassData TCTCO, largest);
   return self ? ((C(EnumClassData) *)self->impl)->largest : 0;
}



// member accessors: EscapeCStringOptions::escapeSingleQuote
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool EscapeCStringOptions::escapeSingleQuote_Prop::operator= (/*0H*/bool v)
{
   SELF(EscapeCStringOptions, escapeSingleQuote);
   ESCAPECSTRINGOPTIONS_SET_escapeSingleQuote(self->impl, v);
   return v;
}

/*regSet*/inline EscapeCStringOptions::escapeSingleQuote_Prop & EscapeCStringOptions::escapeSingleQuote_Prop::operator= (EscapeCStringOptions::escapeSingleQuote_Prop & prop)
{
   SELF(EscapeCStringOptions, escapeSingleQuote);
   /*0H*/bool v = prop;
   ESCAPECSTRINGOPTIONS_SET_escapeSingleQuote(self->impl, v);
   return prop;
}
/*regGet*/inline EscapeCStringOptions::escapeSingleQuote_Prop::operator /*0I*/bool () const
{
   SELF(EscapeCStringOptions, escapeSingleQuote);
   return (bool)ESCAPECSTRINGOPTIONS_escapeSingleQuote(self->impl);
}

// member accessors: EscapeCStringOptions::escapeDoubleQuotes
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool EscapeCStringOptions::escapeDoubleQuotes_Prop::operator= (/*0H*/bool v)
{
   SELF(EscapeCStringOptions, escapeDoubleQuotes);
   ESCAPECSTRINGOPTIONS_SET_escapeDoubleQuotes(self->impl, v);
   return v;
}

/*regSet*/inline EscapeCStringOptions::escapeDoubleQuotes_Prop & EscapeCStringOptions::escapeDoubleQuotes_Prop::operator= (EscapeCStringOptions::escapeDoubleQuotes_Prop & prop)
{
   SELF(EscapeCStringOptions, escapeDoubleQuotes);
   /*0H*/bool v = prop;
   ESCAPECSTRINGOPTIONS_SET_escapeDoubleQuotes(self->impl, v);
   return prop;
}
/*regGet*/inline EscapeCStringOptions::escapeDoubleQuotes_Prop::operator /*0I*/bool () const
{
   SELF(EscapeCStringOptions, escapeDoubleQuotes);
   return (bool)ESCAPECSTRINGOPTIONS_escapeDoubleQuotes(self->impl);
}

// member accessors: EscapeCStringOptions::writeQuotes
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool EscapeCStringOptions::writeQuotes_Prop::operator= (/*0H*/bool v)
{
   SELF(EscapeCStringOptions, writeQuotes);
   ESCAPECSTRINGOPTIONS_SET_writeQuotes(self->impl, v);
   return v;
}

/*regSet*/inline EscapeCStringOptions::writeQuotes_Prop & EscapeCStringOptions::writeQuotes_Prop::operator= (EscapeCStringOptions::writeQuotes_Prop & prop)
{
   SELF(EscapeCStringOptions, writeQuotes);
   /*0H*/bool v = prop;
   ESCAPECSTRINGOPTIONS_SET_writeQuotes(self->impl, v);
   return prop;
}
/*regGet*/inline EscapeCStringOptions::writeQuotes_Prop::operator /*0I*/bool () const
{
   SELF(EscapeCStringOptions, writeQuotes);
   return (bool)ESCAPECSTRINGOPTIONS_writeQuotes(self->impl);
}

// member accessors: EscapeCStringOptions::multiLine
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool EscapeCStringOptions::multiLine_Prop::operator= (/*0H*/bool v)
{
   SELF(EscapeCStringOptions, multiLine);
   ESCAPECSTRINGOPTIONS_SET_multiLine(self->impl, v);
   return v;
}

/*regSet*/inline EscapeCStringOptions::multiLine_Prop & EscapeCStringOptions::multiLine_Prop::operator= (EscapeCStringOptions::multiLine_Prop & prop)
{
   SELF(EscapeCStringOptions, multiLine);
   /*0H*/bool v = prop;
   ESCAPECSTRINGOPTIONS_SET_multiLine(self->impl, v);
   return prop;
}
/*regGet*/inline EscapeCStringOptions::multiLine_Prop::operator /*0I*/bool () const
{
   SELF(EscapeCStringOptions, multiLine);
   return (bool)ESCAPECSTRINGOPTIONS_multiLine(self->impl);
}

// member accessors: EscapeCStringOptions::indent
// (bits::int)

/*nstSet*/inline /*0H*/int EscapeCStringOptions::indent_Prop::operator= (/*0H*/int v)
{
   SELF(EscapeCStringOptions, indent);
   ESCAPECSTRINGOPTIONS_SET_indent(self->impl, v);
   return v;
}

/*regSet*/inline EscapeCStringOptions::indent_Prop & EscapeCStringOptions::indent_Prop::operator= (EscapeCStringOptions::indent_Prop & prop)
{
   SELF(EscapeCStringOptions, indent);
   /*0H*/int v = prop;
   ESCAPECSTRINGOPTIONS_SET_indent(self->impl, v);
   return prop;
}
/*regGet*/inline EscapeCStringOptions::indent_Prop::operator /*0I*/int () const
{
   SELF(EscapeCStringOptions, indent);
   return ESCAPECSTRINGOPTIONS_indent(self->impl);
}
// A (unit:unit)
inline constexpr Feet::operator Meters() const { return Meters(impl); }
inline constexpr Feet::Feet(const Meters & m) : Distance(m.impl) { }
inline constexpr Feet & Feet::operator =(const Meters & m) { impl = m.impl; return *this; }



// member accessors: GlobalFunction::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/GlobalFunction TGlobalFunction<TC, TCO>::prev_Prop::operator= (/*0H*/GlobalFunction & v)
{
   SELF(GlobalFunction, prev);
   ((C(GlobalFunction) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TGlobalFunction<TC, TCO>::prev_Prop & TGlobalFunction<TC, TCO>::prev_Prop::operator= (typename TGlobalFunction<TC, TCO>::prev_Prop & prop)
{
   SELF(GlobalFunction, prev);
   /*0H*/GlobalFunction v = prop;
   ((C(GlobalFunction) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TGlobalFunction<TC, TCO>::prev_Prop::operator /*0I*/GlobalFunction () const
{
   __attribute__((unused)) TGlobalFunction TCTCO * self = CONTAINER_OF(this, TGlobalFunction TCTCO, prev);
   GlobalFunction value(((C(GlobalFunction) *)self->impl)->prev);
   return value;
}

// member accessors: GlobalFunction::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/GlobalFunction TGlobalFunction<TC, TCO>::next_Prop::operator= (/*0H*/GlobalFunction & v)
{
   SELF(GlobalFunction, next);
   ((C(GlobalFunction) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TGlobalFunction<TC, TCO>::next_Prop & TGlobalFunction<TC, TCO>::next_Prop::operator= (typename TGlobalFunction<TC, TCO>::next_Prop & prop)
{
   SELF(GlobalFunction, next);
   /*0H*/GlobalFunction v = prop;
   ((C(GlobalFunction) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TGlobalFunction<TC, TCO>::next_Prop::operator /*0I*/GlobalFunction () const
{
   __attribute__((unused)) TGlobalFunction TCTCO * self = CONTAINER_OF(this, TGlobalFunction TCTCO, next);
   GlobalFunction value(((C(GlobalFunction) *)self->impl)->next);
   return value;
}

// member accessors: GlobalFunction::name
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TGlobalFunction<TC, TCO>::name_Prop::operator= (/*0H*/const char * v)
{
   SELF(GlobalFunction, name);
   ((C(GlobalFunction) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TGlobalFunction<TC, TCO>::name_Prop & TGlobalFunction<TC, TCO>::name_Prop::operator= (typename TGlobalFunction<TC, TCO>::name_Prop & prop)
{
   SELF(GlobalFunction, name);
   /*0H*/const char * v = prop;
   ((C(GlobalFunction) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TGlobalFunction<TC, TCO>::name_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TGlobalFunction TCTCO * self = CONTAINER_OF(this, TGlobalFunction TCTCO, name);
   return self ? ((C(GlobalFunction) *)self->impl)->name : null;
}

// member accessors: GlobalFunction::module
// (nohead::normal)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Module TGlobalFunction<TC, TCO>::module_Prop::operator= (/*0H*/Module v)
{
   SELF(GlobalFunction, module);
   ((C(GlobalFunction) *)self->impl)->module = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TGlobalFunction<TC, TCO>::module_Prop & TGlobalFunction<TC, TCO>::module_Prop::operator= (typename TGlobalFunction<TC, TCO>::module_Prop & prop)
{
   SELF(GlobalFunction, module);
   /*0H*/Module v = prop;
   ((C(GlobalFunction) *)self->impl)->module = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TGlobalFunction<TC, TCO>::module_Prop::operator /*0I*/Module () const
{
   __attribute__((unused)) TGlobalFunction TCTCO * self = CONTAINER_OF(this, TGlobalFunction TCTCO, module);
   Module value(((C(GlobalFunction) *)self->impl)->module);
   return value;
}

// member accessors: GlobalFunction::dataTypeString
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TGlobalFunction<TC, TCO>::dataTypeString_Prop::operator= (/*0H*/const char * v)
{
   SELF(GlobalFunction, dataTypeString);
   ((C(GlobalFunction) *)self->impl)->dataTypeString = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TGlobalFunction<TC, TCO>::dataTypeString_Prop & TGlobalFunction<TC, TCO>::dataTypeString_Prop::operator= (typename TGlobalFunction<TC, TCO>::dataTypeString_Prop & prop)
{
   SELF(GlobalFunction, dataTypeString);
   /*0H*/const char * v = prop;
   ((C(GlobalFunction) *)self->impl)->dataTypeString = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TGlobalFunction<TC, TCO>::dataTypeString_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TGlobalFunction TCTCO * self = CONTAINER_OF(this, TGlobalFunction TCTCO, dataTypeString);
   return self ? ((C(GlobalFunction) *)self->impl)->dataTypeString : null;
}

// member accessors: GlobalFunction::symbol
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TGlobalFunction<TC, TCO>::symbol_Prop::operator= (/*0H*/void * v)
{
   SELF(GlobalFunction, symbol);
   ((C(GlobalFunction) *)self->impl)->symbol = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TGlobalFunction<TC, TCO>::symbol_Prop & TGlobalFunction<TC, TCO>::symbol_Prop::operator= (typename TGlobalFunction<TC, TCO>::symbol_Prop & prop)
{
   SELF(GlobalFunction, symbol);
   /*0H*/void * v = prop;
   ((C(GlobalFunction) *)self->impl)->symbol = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TGlobalFunction<TC, TCO>::symbol_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TGlobalFunction TCTCO * self = CONTAINER_OF(this, TGlobalFunction TCTCO, symbol);
   return self ? ((C(GlobalFunction) *)self->impl)->symbol : null;
}

inline IOChannel::IOChannel_readData_Functor::FunctionType IOChannel::IOChannel_readData_Functor::operator= (FunctionType func)
{
   SELF(IOChannel, readData);
   if(self->vTbl == IOChannel::_cpp_class.vTbl)
   {
      uint size = IOChannel::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(IOChannel::IOChannel_readData_Functor::FunctionType, size);
      memcpy(self->vTbl, IOChannel::_cpp_class.vTbl, sizeof(IOChannel::IOChannel_readData_Functor::FunctionType) * size);
   }
   ((IOChannel::IOChannel_readData_Functor::FunctionType *)self->vTbl)[M_VTBLID(IOChannel, readData)] = func;
   return func;
}
inline uintsize IOChannel::IOChannel_readData_Functor::operator()( /*6Fj*/void * data, /*6Fj*/uintsize numBytes)
{
   SELF(IOChannel, readData);
   return IOChannel_readData(self ? self->impl : (C(IOChannel))null, /*7Al*/data, /*7Al*/numBytes);
}
// inline void IOChannel::register_readData(CPPClass & cl, IOChannel::IOChannel_readData_Functor::FunctionType func)
// {
//    ((IOChannel::IOChannel_readData_Functor::FunctionType *)cl.vTbl)[M_VTBLID(IOChannel, readData)] = func;
// }

inline IOChannel::IOChannel_writeData_Functor::FunctionType IOChannel::IOChannel_writeData_Functor::operator= (FunctionType func)
{
   SELF(IOChannel, writeData);
   if(self->vTbl == IOChannel::_cpp_class.vTbl)
   {
      uint size = IOChannel::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(IOChannel::IOChannel_writeData_Functor::FunctionType, size);
      memcpy(self->vTbl, IOChannel::_cpp_class.vTbl, sizeof(IOChannel::IOChannel_writeData_Functor::FunctionType) * size);
   }
   ((IOChannel::IOChannel_writeData_Functor::FunctionType *)self->vTbl)[M_VTBLID(IOChannel, writeData)] = func;
   return func;
}
inline uintsize IOChannel::IOChannel_writeData_Functor::operator()( /*6Fj*/const void * data, /*6Fj*/uintsize numBytes)
{
   SELF(IOChannel, writeData);
   return IOChannel_writeData(self ? self->impl : (C(IOChannel))null, /*7Al*/data, /*7Al*/numBytes);
}
// inline void IOChannel::register_writeData(CPPClass & cl, IOChannel::IOChannel_writeData_Functor::FunctionType func)
// {
//    ((IOChannel::IOChannel_writeData_Functor::FunctionType *)cl.vTbl)[M_VTBLID(IOChannel, writeData)] = func;
// }


inline void IOChannel::get(/*1Bb*/typed_object_class_ptr class_data, void * data)
{
   IOChannel_get(impl, /*5Fe*/class_data, data);
}
inline void IOChannel::put(/*1Bb*/typed_object_class_ptr class_data, void * data)
{
   IOChannel_put(impl, /*5Fe*/class_data, data);
}
inline void IOChannel::serialize(/*1Bb*/typed_object_class_ptr class_data, void * data)
{
   IOChannel_serialize(impl, /*5Fe*/class_data, data);
}
inline void IOChannel::unserialize(/*1Bb*/typed_object_class_ptr class_data, void * data)
{
   IOChannel_unserialize(impl, /*5Fe*/class_data, data);
}
// B (unit:unit)
inline Meters Meters::operator= (Centimeters value) { return Centimeters_to_Meters(value.impl); }
inline Meters::Meters(Centimeters value) { Centimeters_to_Meters(value.impl); }
inline Meters::operator Centimeters() const { return Centimeters_from_Meters(impl); }
// B (unit:unit)
inline Meters Meters::operator= (Feet value) { return Feet_to_Meters(value.impl); }
inline Meters::Meters(Feet value) { Feet_to_Meters(value.impl); }
inline Meters::operator Feet() const { return Feet_from_Meters(impl); }



// member accessors: Method::name
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TMethod<TC, TCO>::name_Prop::operator= (/*0H*/const char * v)
{
   SELF(Method, name);
   ((C(Method) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TMethod<TC, TCO>::name_Prop & TMethod<TC, TCO>::name_Prop::operator= (typename TMethod<TC, TCO>::name_Prop & prop)
{
   SELF(Method, name);
   /*0H*/const char * v = prop;
   ((C(Method) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TMethod<TC, TCO>::name_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TMethod TCTCO * self = CONTAINER_OF(this, TMethod TCTCO, name);
   return self ? ((C(Method) *)self->impl)->name : null;
}

// member accessors: Method::parent
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Method TMethod<TC, TCO>::parent_Prop::operator= (/*0H*/Method & v)
{
   SELF(Method, parent);
   ((C(Method) *)self->impl)->parent = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TMethod<TC, TCO>::parent_Prop & TMethod<TC, TCO>::parent_Prop::operator= (typename TMethod<TC, TCO>::parent_Prop & prop)
{
   SELF(Method, parent);
   /*0H*/Method v = prop;
   ((C(Method) *)self->impl)->parent = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TMethod<TC, TCO>::parent_Prop::operator /*0I*/Method () const
{
   __attribute__((unused)) TMethod TCTCO * self = CONTAINER_OF(this, TMethod TCTCO, parent);
   Method value(((C(Method) *)self->impl)->parent);
   return value;
}

// member accessors: Method::left
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Method TMethod<TC, TCO>::left_Prop::operator= (/*0H*/Method & v)
{
   SELF(Method, left);
   ((C(Method) *)self->impl)->left = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TMethod<TC, TCO>::left_Prop & TMethod<TC, TCO>::left_Prop::operator= (typename TMethod<TC, TCO>::left_Prop & prop)
{
   SELF(Method, left);
   /*0H*/Method v = prop;
   ((C(Method) *)self->impl)->left = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TMethod<TC, TCO>::left_Prop::operator /*0I*/Method () const
{
   __attribute__((unused)) TMethod TCTCO * self = CONTAINER_OF(this, TMethod TCTCO, left);
   Method value(((C(Method) *)self->impl)->left);
   return value;
}

// member accessors: Method::right
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Method TMethod<TC, TCO>::right_Prop::operator= (/*0H*/Method & v)
{
   SELF(Method, right);
   ((C(Method) *)self->impl)->right = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TMethod<TC, TCO>::right_Prop & TMethod<TC, TCO>::right_Prop::operator= (typename TMethod<TC, TCO>::right_Prop & prop)
{
   SELF(Method, right);
   /*0H*/Method v = prop;
   ((C(Method) *)self->impl)->right = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TMethod<TC, TCO>::right_Prop::operator /*0I*/Method () const
{
   __attribute__((unused)) TMethod TCTCO * self = CONTAINER_OF(this, TMethod TCTCO, right);
   Method value(((C(Method) *)self->impl)->right);
   return value;
}

// member accessors: Method::depth
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TMethod<TC, TCO>::depth_Prop::operator= (/*0H*/int v)
{
   SELF(Method, depth);
   ((C(Method) *)self->impl)->depth = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TMethod<TC, TCO>::depth_Prop & TMethod<TC, TCO>::depth_Prop::operator= (typename TMethod<TC, TCO>::depth_Prop & prop)
{
   SELF(Method, depth);
   /*0H*/int v = prop;
   ((C(Method) *)self->impl)->depth = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TMethod<TC, TCO>::depth_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TMethod TCTCO * self = CONTAINER_OF(this, TMethod TCTCO, depth);
   return self ? ((C(Method) *)self->impl)->depth : 0;
}

// member accessors: Method::vid
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TMethod<TC, TCO>::vid_Prop::operator= (/*0H*/int v)
{
   SELF(Method, vid);
   ((C(Method) *)self->impl)->vid = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TMethod<TC, TCO>::vid_Prop & TMethod<TC, TCO>::vid_Prop::operator= (typename TMethod<TC, TCO>::vid_Prop & prop)
{
   SELF(Method, vid);
   /*0H*/int v = prop;
   ((C(Method) *)self->impl)->vid = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TMethod<TC, TCO>::vid_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TMethod TCTCO * self = CONTAINER_OF(this, TMethod TCTCO, vid);
   return self ? ((C(Method) *)self->impl)->vid : 0;
}

// member accessors: Method::type
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/MethodType TMethod<TC, TCO>::type_Prop::operator= (/*0H*/MethodType v)
{
   SELF(Method, type);
   ((C(Method) *)self->impl)->type = (C(MethodType))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TMethod<TC, TCO>::type_Prop & TMethod<TC, TCO>::type_Prop::operator= (typename TMethod<TC, TCO>::type_Prop & prop)
{
   SELF(Method, type);
   /*0H*/MethodType v = prop;
   ((C(Method) *)self->impl)->type = (C(MethodType))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TMethod<TC, TCO>::type_Prop::operator /*0I*/MethodType () const
{
   __attribute__((unused)) TMethod TCTCO * self = CONTAINER_OF(this, TMethod TCTCO, type);
   return self ? ((C(Method) *)self->impl)->type : (MethodType)0;
}

// member accessors: Method::_class
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Class TMethod<TC, TCO>::_class_Prop::operator= (/*0H*/Class & v)
{
   SELF(Method, _class);
   ((C(Method) *)self->impl)->_class = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TMethod<TC, TCO>::_class_Prop & TMethod<TC, TCO>::_class_Prop::operator= (typename TMethod<TC, TCO>::_class_Prop & prop)
{
   SELF(Method, _class);
   /*0H*/Class v = prop;
   ((C(Method) *)self->impl)->_class = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TMethod<TC, TCO>::_class_Prop::operator /*0I*/Class () const
{
   __attribute__((unused)) TMethod TCTCO * self = CONTAINER_OF(this, TMethod TCTCO, _class);
   Class value(((C(Method) *)self->impl)->_class);
   return value;
}

// member accessors: Method::symbol
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TMethod<TC, TCO>::symbol_Prop::operator= (/*0H*/void * v)
{
   SELF(Method, symbol);
   ((C(Method) *)self->impl)->symbol = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TMethod<TC, TCO>::symbol_Prop & TMethod<TC, TCO>::symbol_Prop::operator= (typename TMethod<TC, TCO>::symbol_Prop & prop)
{
   SELF(Method, symbol);
   /*0H*/void * v = prop;
   ((C(Method) *)self->impl)->symbol = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TMethod<TC, TCO>::symbol_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TMethod TCTCO * self = CONTAINER_OF(this, TMethod TCTCO, symbol);
   return self ? ((C(Method) *)self->impl)->symbol : null;
}

// member accessors: Method::dataTypeString
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TMethod<TC, TCO>::dataTypeString_Prop::operator= (/*0H*/const char * v)
{
   SELF(Method, dataTypeString);
   ((C(Method) *)self->impl)->dataTypeString = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TMethod<TC, TCO>::dataTypeString_Prop & TMethod<TC, TCO>::dataTypeString_Prop::operator= (typename TMethod<TC, TCO>::dataTypeString_Prop & prop)
{
   SELF(Method, dataTypeString);
   /*0H*/const char * v = prop;
   ((C(Method) *)self->impl)->dataTypeString = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TMethod<TC, TCO>::dataTypeString_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TMethod TCTCO * self = CONTAINER_OF(this, TMethod TCTCO, dataTypeString);
   return self ? ((C(Method) *)self->impl)->dataTypeString : null;
}

// member accessors: Method::memberAccess
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Access_Mode TMethod<TC, TCO>::memberAccess_Prop::operator= (/*0H*/Access_Mode v)
{
   SELF(Method, memberAccess);
   ((C(Method) *)self->impl)->memberAccess = (C(AccessMode))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TMethod<TC, TCO>::memberAccess_Prop & TMethod<TC, TCO>::memberAccess_Prop::operator= (typename TMethod<TC, TCO>::memberAccess_Prop & prop)
{
   SELF(Method, memberAccess);
   /*0H*/Access_Mode v = prop;
   ((C(Method) *)self->impl)->memberAccess = (C(AccessMode))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TMethod<TC, TCO>::memberAccess_Prop::operator /*0I*/Access_Mode () const
{
   __attribute__((unused)) TMethod TCTCO * self = CONTAINER_OF(this, TMethod TCTCO, memberAccess);
   return self ? ((C(Method) *)self->impl)->memberAccess : (Access_Mode)0;
}



// member accessors: NameSpace::name
// (struct::const char *)

/*nstSet*/inline /*0H*/const char * NameSpace::name_Prop::operator= (/*0H*/const char * v)
{
   SELF(NameSpace, name);
   self->impl.name = v;
   return v;
}

/*regSet*/inline NameSpace::name_Prop & NameSpace::name_Prop::operator= (NameSpace::name_Prop & prop)
{
   SELF(NameSpace, name);
   /*0H*/const char * v = prop;
   self->impl.name = v;
   return prop;
}
/*regGet*/inline NameSpace::name_Prop::operator /*0I*/const char * () const
{
   SELF(NameSpace, name);
   return self ? ((C(NameSpace) *)&self->impl)->name : null;
}

// member accessors: NameSpace::depth
// (struct::int)

/*nstSet*/inline /*0H*/int NameSpace::depth_Prop::operator= (/*0H*/int v)
{
   SELF(NameSpace, depth);
   self->impl.depth = v;
   return v;
}

/*regSet*/inline NameSpace::depth_Prop & NameSpace::depth_Prop::operator= (NameSpace::depth_Prop & prop)
{
   SELF(NameSpace, depth);
   /*0H*/int v = prop;
   self->impl.depth = v;
   return prop;
}
/*regGet*/inline NameSpace::depth_Prop::operator /*0I*/int () const
{
   SELF(NameSpace, depth);
   return self ? ((C(NameSpace) *)&self->impl)->depth : 0;
}

// member accessors: NameSpace::nameSpaces
// (struct::struct)

/*nstSet*/inline /*0H*/BinaryTree NameSpace::nameSpaces_Prop::operator= (/*0H*/BinaryTree v)
{
   SELF(NameSpace, nameSpaces);
   self->impl.nameSpaces = v.impl;
   return v;
}

/*regSet*/inline NameSpace::nameSpaces_Prop & NameSpace::nameSpaces_Prop::operator= (NameSpace::nameSpaces_Prop & prop)
{
   SELF(NameSpace, nameSpaces);
   /*0H*/BinaryTree v = prop;
   self->impl.nameSpaces = v.impl;
   return prop;
}
/*regGet*/inline NameSpace::nameSpaces_Prop::operator /*0I*/BinaryTree () const
{
   SELF(NameSpace, nameSpaces);
   BinaryTree value(((C(NameSpace) *)&self->impl)->nameSpaces);
   return value;
}

// member accessors: NameSpace::classes
// (struct::struct)

/*nstSet*/inline /*0H*/BinaryTree NameSpace::classes_Prop::operator= (/*0H*/BinaryTree v)
{
   SELF(NameSpace, classes);
   self->impl.classes = v.impl;
   return v;
}

/*regSet*/inline NameSpace::classes_Prop & NameSpace::classes_Prop::operator= (NameSpace::classes_Prop & prop)
{
   SELF(NameSpace, classes);
   /*0H*/BinaryTree v = prop;
   self->impl.classes = v.impl;
   return prop;
}
/*regGet*/inline NameSpace::classes_Prop::operator /*0I*/BinaryTree () const
{
   SELF(NameSpace, classes);
   BinaryTree value(((C(NameSpace) *)&self->impl)->classes);
   return value;
}

// member accessors: NameSpace::defines
// (struct::struct)

/*nstSet*/inline /*0H*/BinaryTree NameSpace::defines_Prop::operator= (/*0H*/BinaryTree v)
{
   SELF(NameSpace, defines);
   self->impl.defines = v.impl;
   return v;
}

/*regSet*/inline NameSpace::defines_Prop & NameSpace::defines_Prop::operator= (NameSpace::defines_Prop & prop)
{
   SELF(NameSpace, defines);
   /*0H*/BinaryTree v = prop;
   self->impl.defines = v.impl;
   return prop;
}
/*regGet*/inline NameSpace::defines_Prop::operator /*0I*/BinaryTree () const
{
   SELF(NameSpace, defines);
   BinaryTree value(((C(NameSpace) *)&self->impl)->defines);
   return value;
}

// member accessors: NameSpace::functions
// (struct::struct)

/*nstSet*/inline /*0H*/BinaryTree NameSpace::functions_Prop::operator= (/*0H*/BinaryTree v)
{
   SELF(NameSpace, functions);
   self->impl.functions = v.impl;
   return v;
}

/*regSet*/inline NameSpace::functions_Prop & NameSpace::functions_Prop::operator= (NameSpace::functions_Prop & prop)
{
   SELF(NameSpace, functions);
   /*0H*/BinaryTree v = prop;
   self->impl.functions = v.impl;
   return prop;
}
/*regGet*/inline NameSpace::functions_Prop::operator /*0I*/BinaryTree () const
{
   SELF(NameSpace, functions);
   BinaryTree value(((C(NameSpace) *)&self->impl)->functions);
   return value;
}



// member accessors: ObjectInfo::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/ObjectInfo TObjectInfo<TC, TCO>::prev_Prop::operator= (/*0H*/ObjectInfo & v)
{
   SELF(ObjectInfo, prev);
   ((C(ObjectInfo) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TObjectInfo<TC, TCO>::prev_Prop & TObjectInfo<TC, TCO>::prev_Prop::operator= (typename TObjectInfo<TC, TCO>::prev_Prop & prop)
{
   SELF(ObjectInfo, prev);
   /*0H*/ObjectInfo v = prop;
   ((C(ObjectInfo) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TObjectInfo<TC, TCO>::prev_Prop::operator /*0I*/ObjectInfo () const
{
   __attribute__((unused)) TObjectInfo TCTCO * self = CONTAINER_OF(this, TObjectInfo TCTCO, prev);
   ObjectInfo value(((C(ObjectInfo) *)self->impl)->prev);
   return value;
}

// member accessors: ObjectInfo::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/ObjectInfo TObjectInfo<TC, TCO>::next_Prop::operator= (/*0H*/ObjectInfo & v)
{
   SELF(ObjectInfo, next);
   ((C(ObjectInfo) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TObjectInfo<TC, TCO>::next_Prop & TObjectInfo<TC, TCO>::next_Prop::operator= (typename TObjectInfo<TC, TCO>::next_Prop & prop)
{
   SELF(ObjectInfo, next);
   /*0H*/ObjectInfo v = prop;
   ((C(ObjectInfo) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TObjectInfo<TC, TCO>::next_Prop::operator /*0I*/ObjectInfo () const
{
   __attribute__((unused)) TObjectInfo TCTCO * self = CONTAINER_OF(this, TObjectInfo TCTCO, next);
   ObjectInfo value(((C(ObjectInfo) *)self->impl)->next);
   return value;
}

// member accessors: ObjectInfo::instance
// (nohead::normal)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Instance TObjectInfo<TC, TCO>::instance_Prop::operator= (/*0H*/Instance v)
{
   SELF(ObjectInfo, instance);
   ((C(ObjectInfo) *)self->impl)->instance = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TObjectInfo<TC, TCO>::instance_Prop & TObjectInfo<TC, TCO>::instance_Prop::operator= (typename TObjectInfo<TC, TCO>::instance_Prop & prop)
{
   SELF(ObjectInfo, instance);
   /*0H*/Instance v = prop;
   ((C(ObjectInfo) *)self->impl)->instance = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TObjectInfo<TC, TCO>::instance_Prop::operator /*0I*/Instance () const
{
   __attribute__((unused)) TObjectInfo TCTCO * self = CONTAINER_OF(this, TObjectInfo TCTCO, instance);
   Instance value(((C(ObjectInfo) *)self->impl)->instance);
   return value;
}

// member accessors: ObjectInfo::name
// (nohead::char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/char * TObjectInfo<TC, TCO>::name_Prop::operator= (/*0H*/char * v)
{
   SELF(ObjectInfo, name);
   ((C(ObjectInfo) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TObjectInfo<TC, TCO>::name_Prop & TObjectInfo<TC, TCO>::name_Prop::operator= (typename TObjectInfo<TC, TCO>::name_Prop & prop)
{
   SELF(ObjectInfo, name);
   /*0H*/char * v = prop;
   ((C(ObjectInfo) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TObjectInfo<TC, TCO>::name_Prop::operator /*0I*/char * () const
{
   __attribute__((unused)) TObjectInfo TCTCO * self = CONTAINER_OF(this, TObjectInfo TCTCO, name);
   return self ? ((C(ObjectInfo) *)self->impl)->name : null;
}

// member accessors: ObjectInfo::deleted
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TObjectInfo<TC, TCO>::deleted_Prop::operator= (/*0H*/bool v)
{
   SELF(ObjectInfo, deleted);
   ((C(ObjectInfo) *)self->impl)->deleted = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TObjectInfo<TC, TCO>::deleted_Prop & TObjectInfo<TC, TCO>::deleted_Prop::operator= (typename TObjectInfo<TC, TCO>::deleted_Prop & prop)
{
   SELF(ObjectInfo, deleted);
   /*0H*/bool v = prop;
   ((C(ObjectInfo) *)self->impl)->deleted = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TObjectInfo<TC, TCO>::deleted_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TObjectInfo TCTCO * self = CONTAINER_OF(this, TObjectInfo TCTCO, deleted);
   return self ? ((C(ObjectInfo) *)self->impl)->deleted : (bool)0;
}

// member accessors: ObjectInfo::oClass
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/ObjectInfo TObjectInfo<TC, TCO>::oClass_Prop::operator= (/*0H*/ObjectInfo & v)
{
   SELF(ObjectInfo, oClass);
   ((C(ObjectInfo) *)self->impl)->oClass = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TObjectInfo<TC, TCO>::oClass_Prop & TObjectInfo<TC, TCO>::oClass_Prop::operator= (typename TObjectInfo<TC, TCO>::oClass_Prop & prop)
{
   SELF(ObjectInfo, oClass);
   /*0H*/ObjectInfo v = prop;
   ((C(ObjectInfo) *)self->impl)->oClass = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TObjectInfo<TC, TCO>::oClass_Prop::operator /*0I*/ObjectInfo () const
{
   __attribute__((unused)) TObjectInfo TCTCO * self = CONTAINER_OF(this, TObjectInfo TCTCO, oClass);
   ObjectInfo value(((C(ObjectInfo) *)self->impl)->oClass);
   return value;
}

// member accessors: ObjectInfo::instances
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldList TObjectInfo<TC, TCO>::instances_Prop::operator= (/*0H*/OldList v)
{
   SELF(ObjectInfo, instances);
   ((C(ObjectInfo) *)self->impl)->instances = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TObjectInfo<TC, TCO>::instances_Prop & TObjectInfo<TC, TCO>::instances_Prop::operator= (typename TObjectInfo<TC, TCO>::instances_Prop & prop)
{
   SELF(ObjectInfo, instances);
   /*0H*/OldList v = prop;
   ((C(ObjectInfo) *)self->impl)->instances = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TObjectInfo<TC, TCO>::instances_Prop::operator /*0I*/OldList () const
{
   __attribute__((unused)) TObjectInfo TCTCO * self = CONTAINER_OF(this, TObjectInfo TCTCO, instances);
   OldList value(((C(ObjectInfo) *)self->impl)->instances);
   return value;
}

// member accessors: ObjectInfo::modified
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TObjectInfo<TC, TCO>::modified_Prop::operator= (/*0H*/bool v)
{
   SELF(ObjectInfo, modified);
   ((C(ObjectInfo) *)self->impl)->modified = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TObjectInfo<TC, TCO>::modified_Prop & TObjectInfo<TC, TCO>::modified_Prop::operator= (typename TObjectInfo<TC, TCO>::modified_Prop & prop)
{
   SELF(ObjectInfo, modified);
   /*0H*/bool v = prop;
   ((C(ObjectInfo) *)self->impl)->modified = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TObjectInfo<TC, TCO>::modified_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TObjectInfo TCTCO * self = CONTAINER_OF(this, TObjectInfo TCTCO, modified);
   return self ? ((C(ObjectInfo) *)self->impl)->modified : (bool)0;
}

// member accessors: ObjectInfo::i18nStrings
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TObjectInfo<TC, TCO>::i18nStrings_Prop::operator= (/*0H*/void * v)
{
   SELF(ObjectInfo, i18nStrings);
   ((C(ObjectInfo) *)self->impl)->i18nStrings = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TObjectInfo<TC, TCO>::i18nStrings_Prop & TObjectInfo<TC, TCO>::i18nStrings_Prop::operator= (typename TObjectInfo<TC, TCO>::i18nStrings_Prop & prop)
{
   SELF(ObjectInfo, i18nStrings);
   /*0H*/void * v = prop;
   ((C(ObjectInfo) *)self->impl)->i18nStrings = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TObjectInfo<TC, TCO>::i18nStrings_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TObjectInfo TCTCO * self = CONTAINER_OF(this, TObjectInfo TCTCO, i18nStrings);
   return self ? ((C(ObjectInfo) *)self->impl)->i18nStrings : null;
}

inline Point::Point(int x, int y = 0)
{
   impl.x = x;
   impl.y = y;
}



// member accessors: Point::x
// (struct::int)

/*nstSet*/inline /*0H*/int Point::x_Prop::operator= (/*0H*/int v)
{
   SELF(Point, x);
   self->impl.x = v;
   return v;
}

/*regSet*/inline Point::x_Prop & Point::x_Prop::operator= (Point::x_Prop & prop)
{
   SELF(Point, x);
   /*0H*/int v = prop;
   self->impl.x = v;
   return prop;
}
/*regGet*/inline Point::x_Prop::operator /*0I*/int () const
{
   SELF(Point, x);
   return self ? ((C(Point) *)&self->impl)->x : 0;
}

// member accessors: Point::y
// (struct::int)

/*nstSet*/inline /*0H*/int Point::y_Prop::operator= (/*0H*/int v)
{
   SELF(Point, y);
   self->impl.y = v;
   return v;
}

/*regSet*/inline Point::y_Prop & Point::y_Prop::operator= (Point::y_Prop & prop)
{
   SELF(Point, y);
   /*0H*/int v = prop;
   self->impl.y = v;
   return prop;
}
/*regGet*/inline Point::y_Prop::operator /*0I*/int () const
{
   SELF(Point, y);
   return self ? ((C(Point) *)&self->impl)->y : 0;
}

inline Pointd::Pointd(double x, double y = 0)
{
   impl.x = x;
   impl.y = y;
}



// member accessors: Pointd::x
// (struct::double)

/*nstSet*/inline /*0H*/double Pointd::x_Prop::operator= (/*0H*/double v)
{
   SELF(Pointd, x);
   self->impl.x = v;
   return v;
}

/*regSet*/inline Pointd::x_Prop & Pointd::x_Prop::operator= (Pointd::x_Prop & prop)
{
   SELF(Pointd, x);
   /*0H*/double v = prop;
   self->impl.x = v;
   return prop;
}
/*regGet*/inline Pointd::x_Prop::operator /*0I*/double () const
{
   SELF(Pointd, x);
   return self ? ((C(Pointd) *)&self->impl)->x : 0;
}

// member accessors: Pointd::y
// (struct::double)

/*nstSet*/inline /*0H*/double Pointd::y_Prop::operator= (/*0H*/double v)
{
   SELF(Pointd, y);
   self->impl.y = v;
   return v;
}

/*regSet*/inline Pointd::y_Prop & Pointd::y_Prop::operator= (Pointd::y_Prop & prop)
{
   SELF(Pointd, y);
   /*0H*/double v = prop;
   self->impl.y = v;
   return prop;
}
/*regGet*/inline Pointd::y_Prop::operator /*0I*/double () const
{
   SELF(Pointd, y);
   return self ? ((C(Pointd) *)&self->impl)->y : 0;
}

inline Pointf::Pointf(float x, float y = 0)
{
   impl.x = x;
   impl.y = y;
}



// member accessors: Pointf::x
// (struct::float)

/*nstSet*/inline /*0H*/float Pointf::x_Prop::operator= (/*0H*/float v)
{
   SELF(Pointf, x);
   self->impl.x = v;
   return v;
}

/*regSet*/inline Pointf::x_Prop & Pointf::x_Prop::operator= (Pointf::x_Prop & prop)
{
   SELF(Pointf, x);
   /*0H*/float v = prop;
   self->impl.x = v;
   return prop;
}
/*regGet*/inline Pointf::x_Prop::operator /*0I*/float () const
{
   SELF(Pointf, x);
   return self ? ((C(Pointf) *)&self->impl)->x : 0;
}

// member accessors: Pointf::y
// (struct::float)

/*nstSet*/inline /*0H*/float Pointf::y_Prop::operator= (/*0H*/float v)
{
   SELF(Pointf, y);
   self->impl.y = v;
   return v;
}

/*regSet*/inline Pointf::y_Prop & Pointf::y_Prop::operator= (Pointf::y_Prop & prop)
{
   SELF(Pointf, y);
   /*0H*/float v = prop;
   self->impl.y = v;
   return prop;
}
/*regGet*/inline Pointf::y_Prop::operator /*0I*/float () const
{
   SELF(Pointf, y);
   return self ? ((C(Pointf) *)&self->impl)->y : 0;
}



// member accessors: Property::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Property TProperty<TC, TCO>::prev_Prop::operator= (/*0H*/Property & v)
{
   SELF(Property, prev);
   ((C(Property) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::prev_Prop & TProperty<TC, TCO>::prev_Prop::operator= (typename TProperty<TC, TCO>::prev_Prop & prop)
{
   SELF(Property, prev);
   /*0H*/Property v = prop;
   ((C(Property) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::prev_Prop::operator /*0I*/Property () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, prev);
   Property value(((C(Property) *)self->impl)->prev);
   return value;
}

// member accessors: Property::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Property TProperty<TC, TCO>::next_Prop::operator= (/*0H*/Property & v)
{
   SELF(Property, next);
   ((C(Property) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::next_Prop & TProperty<TC, TCO>::next_Prop::operator= (typename TProperty<TC, TCO>::next_Prop & prop)
{
   SELF(Property, next);
   /*0H*/Property v = prop;
   ((C(Property) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::next_Prop::operator /*0I*/Property () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, next);
   Property value(((C(Property) *)self->impl)->next);
   return value;
}

// member accessors: Property::name
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TProperty<TC, TCO>::name_Prop::operator= (/*0H*/const char * v)
{
   SELF(Property, name);
   ((C(Property) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::name_Prop & TProperty<TC, TCO>::name_Prop::operator= (typename TProperty<TC, TCO>::name_Prop & prop)
{
   SELF(Property, name);
   /*0H*/const char * v = prop;
   ((C(Property) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::name_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, name);
   return self ? ((C(Property) *)self->impl)->name : null;
}

// member accessors: Property::isProperty
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TProperty<TC, TCO>::isProperty_Prop::operator= (/*0H*/bool v)
{
   SELF(Property, isProperty);
   ((C(Property) *)self->impl)->isProperty = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::isProperty_Prop & TProperty<TC, TCO>::isProperty_Prop::operator= (typename TProperty<TC, TCO>::isProperty_Prop & prop)
{
   SELF(Property, isProperty);
   /*0H*/bool v = prop;
   ((C(Property) *)self->impl)->isProperty = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::isProperty_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, isProperty);
   return self ? ((C(Property) *)self->impl)->isProperty : (bool)0;
}

// member accessors: Property::memberAccess
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Access_Mode TProperty<TC, TCO>::memberAccess_Prop::operator= (/*0H*/Access_Mode v)
{
   SELF(Property, memberAccess);
   ((C(Property) *)self->impl)->memberAccess = (C(AccessMode))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::memberAccess_Prop & TProperty<TC, TCO>::memberAccess_Prop::operator= (typename TProperty<TC, TCO>::memberAccess_Prop & prop)
{
   SELF(Property, memberAccess);
   /*0H*/Access_Mode v = prop;
   ((C(Property) *)self->impl)->memberAccess = (C(AccessMode))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::memberAccess_Prop::operator /*0I*/Access_Mode () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, memberAccess);
   return self ? ((C(Property) *)self->impl)->memberAccess : (Access_Mode)0;
}

// member accessors: Property::id
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TProperty<TC, TCO>::id_Prop::operator= (/*0H*/int v)
{
   SELF(Property, id);
   ((C(Property) *)self->impl)->id = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::id_Prop & TProperty<TC, TCO>::id_Prop::operator= (typename TProperty<TC, TCO>::id_Prop & prop)
{
   SELF(Property, id);
   /*0H*/int v = prop;
   ((C(Property) *)self->impl)->id = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::id_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, id);
   return self ? ((C(Property) *)self->impl)->id : 0;
}

// member accessors: Property::_class
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Class TProperty<TC, TCO>::_class_Prop::operator= (/*0H*/Class & v)
{
   SELF(Property, _class);
   ((C(Property) *)self->impl)->_class = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::_class_Prop & TProperty<TC, TCO>::_class_Prop::operator= (typename TProperty<TC, TCO>::_class_Prop & prop)
{
   SELF(Property, _class);
   /*0H*/Class v = prop;
   ((C(Property) *)self->impl)->_class = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::_class_Prop::operator /*0I*/Class () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, _class);
   Class value(((C(Property) *)self->impl)->_class);
   return value;
}

// member accessors: Property::dataTypeString
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TProperty<TC, TCO>::dataTypeString_Prop::operator= (/*0H*/const char * v)
{
   SELF(Property, dataTypeString);
   ((C(Property) *)self->impl)->dataTypeString = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::dataTypeString_Prop & TProperty<TC, TCO>::dataTypeString_Prop::operator= (typename TProperty<TC, TCO>::dataTypeString_Prop & prop)
{
   SELF(Property, dataTypeString);
   /*0H*/const char * v = prop;
   ((C(Property) *)self->impl)->dataTypeString = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::dataTypeString_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, dataTypeString);
   return self ? ((C(Property) *)self->impl)->dataTypeString : null;
}

// member accessors: Property::dataTypeClass
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Class TProperty<TC, TCO>::dataTypeClass_Prop::operator= (/*0H*/Class & v)
{
   SELF(Property, dataTypeClass);
   ((C(Property) *)self->impl)->dataTypeClass = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::dataTypeClass_Prop & TProperty<TC, TCO>::dataTypeClass_Prop::operator= (typename TProperty<TC, TCO>::dataTypeClass_Prop & prop)
{
   SELF(Property, dataTypeClass);
   /*0H*/Class v = prop;
   ((C(Property) *)self->impl)->dataTypeClass = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::dataTypeClass_Prop::operator /*0I*/Class () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, dataTypeClass);
   Class value(((C(Property) *)self->impl)->dataTypeClass);
   return value;
}

// member accessors: Property::data
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TProperty<TC, TCO>::data_Prop::operator= (/*0H*/void * v)
{
   SELF(Property, data);
   ((C(Property) *)self->impl)->data = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::data_Prop & TProperty<TC, TCO>::data_Prop::operator= (typename TProperty<TC, TCO>::data_Prop & prop)
{
   SELF(Property, data);
   /*0H*/void * v = prop;
   ((C(Property) *)self->impl)->data = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::data_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, data);
   return self ? ((C(Property) *)self->impl)->data : null;
}

// member accessors: Property::symbol
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TProperty<TC, TCO>::symbol_Prop::operator= (/*0H*/void * v)
{
   SELF(Property, symbol);
   ((C(Property) *)self->impl)->symbol = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::symbol_Prop & TProperty<TC, TCO>::symbol_Prop::operator= (typename TProperty<TC, TCO>::symbol_Prop & prop)
{
   SELF(Property, symbol);
   /*0H*/void * v = prop;
   ((C(Property) *)self->impl)->symbol = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::symbol_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, symbol);
   return self ? ((C(Property) *)self->impl)->symbol : null;
}

// member accessors: Property::vid
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TProperty<TC, TCO>::vid_Prop::operator= (/*0H*/int v)
{
   SELF(Property, vid);
   ((C(Property) *)self->impl)->vid = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::vid_Prop & TProperty<TC, TCO>::vid_Prop::operator= (typename TProperty<TC, TCO>::vid_Prop & prop)
{
   SELF(Property, vid);
   /*0H*/int v = prop;
   ((C(Property) *)self->impl)->vid = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::vid_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, vid);
   return self ? ((C(Property) *)self->impl)->vid : 0;
}

// member accessors: Property::conversion
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TProperty<TC, TCO>::conversion_Prop::operator= (/*0H*/bool v)
{
   SELF(Property, conversion);
   ((C(Property) *)self->impl)->conversion = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::conversion_Prop & TProperty<TC, TCO>::conversion_Prop::operator= (typename TProperty<TC, TCO>::conversion_Prop & prop)
{
   SELF(Property, conversion);
   /*0H*/bool v = prop;
   ((C(Property) *)self->impl)->conversion = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::conversion_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, conversion);
   return self ? ((C(Property) *)self->impl)->conversion : (bool)0;
}

// member accessors: Property::watcherOffset
// (nohead::uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/uint TProperty<TC, TCO>::watcherOffset_Prop::operator= (/*0H*/uint v)
{
   SELF(Property, watcherOffset);
   ((C(Property) *)self->impl)->watcherOffset = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::watcherOffset_Prop & TProperty<TC, TCO>::watcherOffset_Prop::operator= (typename TProperty<TC, TCO>::watcherOffset_Prop & prop)
{
   SELF(Property, watcherOffset);
   /*0H*/uint v = prop;
   ((C(Property) *)self->impl)->watcherOffset = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::watcherOffset_Prop::operator /*0I*/uint () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, watcherOffset);
   return self ? ((C(Property) *)self->impl)->watcherOffset : 0;
}

// member accessors: Property::category
// (nohead::const char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/const char * TProperty<TC, TCO>::category_Prop::operator= (/*0H*/const char * v)
{
   SELF(Property, category);
   ((C(Property) *)self->impl)->category = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::category_Prop & TProperty<TC, TCO>::category_Prop::operator= (typename TProperty<TC, TCO>::category_Prop & prop)
{
   SELF(Property, category);
   /*0H*/const char * v = prop;
   ((C(Property) *)self->impl)->category = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::category_Prop::operator /*0I*/const char * () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, category);
   return self ? ((C(Property) *)self->impl)->category : null;
}

// member accessors: Property::compiled
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TProperty<TC, TCO>::compiled_Prop::operator= (/*0H*/bool v)
{
   SELF(Property, compiled);
   ((C(Property) *)self->impl)->compiled = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::compiled_Prop & TProperty<TC, TCO>::compiled_Prop::operator= (typename TProperty<TC, TCO>::compiled_Prop & prop)
{
   SELF(Property, compiled);
   /*0H*/bool v = prop;
   ((C(Property) *)self->impl)->compiled = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::compiled_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, compiled);
   return self ? ((C(Property) *)self->impl)->compiled : (bool)0;
}

// member accessors: Property::selfWatchable
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TProperty<TC, TCO>::selfWatchable_Prop::operator= (/*0H*/bool v)
{
   SELF(Property, selfWatchable);
   ((C(Property) *)self->impl)->selfWatchable = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::selfWatchable_Prop & TProperty<TC, TCO>::selfWatchable_Prop::operator= (typename TProperty<TC, TCO>::selfWatchable_Prop & prop)
{
   SELF(Property, selfWatchable);
   /*0H*/bool v = prop;
   ((C(Property) *)self->impl)->selfWatchable = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::selfWatchable_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, selfWatchable);
   return self ? ((C(Property) *)self->impl)->selfWatchable : (bool)0;
}

// member accessors: Property::isWatchable
// (nohead::enum|uint)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/bool TProperty<TC, TCO>::isWatchable_Prop::operator= (/*0H*/bool v)
{
   SELF(Property, isWatchable);
   ((C(Property) *)self->impl)->isWatchable = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TProperty<TC, TCO>::isWatchable_Prop & TProperty<TC, TCO>::isWatchable_Prop::operator= (typename TProperty<TC, TCO>::isWatchable_Prop & prop)
{
   SELF(Property, isWatchable);
   /*0H*/bool v = prop;
   ((C(Property) *)self->impl)->isWatchable = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TProperty<TC, TCO>::isWatchable_Prop::operator /*0I*/bool () const
{
   __attribute__((unused)) TProperty TCTCO * self = CONTAINER_OF(this, TProperty TCTCO, isWatchable);
   return self ? ((C(Property) *)self->impl)->isWatchable : (bool)0;
}
// B (unit:unit)
inline Radians Radians::operator= (Degrees value) { return Degrees_to_Radians(value.impl); }
inline Radians::Radians(Degrees value) { Degrees_to_Radians(value.impl); }
inline Radians::operator Degrees() const { return Degrees_from_Radians(impl); }

inline SerialBuffer::SerialBuffer(unsigned char * _buffer, uintsize count = 0, uintsize _size = 0, uintsize pos = 0, unsigned char * buffer = null, uint size = 0) : SerialBuffer()
{
   this->_buffer = _buffer;
   this->count = count;
   this->_size = _size;
   this->pos = pos;
   this->buffer = buffer;
   this->size = size;
}


inline void SerialBuffer::free()
{
   SerialBuffer_free(impl);
}


// property callers: SerialBuffer::buffer
// (normal::byte *)

/*nstSet*/inline /*0H*/unsigned char * SerialBuffer::buffer_Prop::operator= (/*0H*/unsigned char * v)
{
   SELF(SerialBuffer, buffer);
   SerialBuffer_set_buffer(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline SerialBuffer::buffer_Prop & SerialBuffer::buffer_Prop::operator= (SerialBuffer::buffer_Prop & prop)
{
   SELF(SerialBuffer, buffer);
   /*0H*/unsigned char * v = prop;
   SerialBuffer_set_buffer(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline SerialBuffer::buffer_Prop::operator /*0I*/unsigned char * () const
{
   SELF(SerialBuffer, buffer);
   return SerialBuffer_get_buffer(self ? self->impl : null);
}

// property callers: SerialBuffer::size
// (normal::uint)

/*nstSet*/inline /*0H*/uint SerialBuffer::size_Prop::operator= (/*0H*/uint v)
{
   SELF(SerialBuffer, size);
   SerialBuffer_set_size(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline SerialBuffer::size_Prop & SerialBuffer::size_Prop::operator= (SerialBuffer::size_Prop & prop)
{
   SELF(SerialBuffer, size);
   /*0H*/uint v = prop;
   SerialBuffer_set_size(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline SerialBuffer::size_Prop::operator /*0I*/uint () const
{
   SELF(SerialBuffer, size);
   return SerialBuffer_get_size(self ? self->impl : null);
}


// member accessors: SerialBuffer::_buffer
// (normal::byte *)

/*nstSet*/inline /*0H*/unsigned char * SerialBuffer::_buffer_Prop::operator= (/*0H*/unsigned char * v)
{
   SELF(SerialBuffer, _buffer);
   IPTR(self->impl, SerialBuffer)->_buffer = v;
   return v;
}

/*regSet*/inline SerialBuffer::_buffer_Prop & SerialBuffer::_buffer_Prop::operator= (SerialBuffer::_buffer_Prop & prop)
{
   SELF(SerialBuffer, _buffer);
   /*0H*/unsigned char * v = prop;
   IPTR(self->impl, SerialBuffer)->_buffer = v;
   return prop;
}
/*regGet*/inline SerialBuffer::_buffer_Prop::operator /*0I*/unsigned char * () const
{
   SELF(SerialBuffer, _buffer);
   return self ? IPTR(self->impl, SerialBuffer)->_buffer : null;
}

// member accessors: SerialBuffer::count
// (normal::uintsize)

/*nstSet*/inline /*0H*/uintsize SerialBuffer::count_Prop::operator= (/*0H*/uintsize v)
{
   SELF(SerialBuffer, count);
   IPTR(self->impl, SerialBuffer)->count = v;
   return v;
}

/*regSet*/inline SerialBuffer::count_Prop & SerialBuffer::count_Prop::operator= (SerialBuffer::count_Prop & prop)
{
   SELF(SerialBuffer, count);
   /*0H*/uintsize v = prop;
   IPTR(self->impl, SerialBuffer)->count = v;
   return prop;
}
/*regGet*/inline SerialBuffer::count_Prop::operator /*0I*/uintsize () const
{
   SELF(SerialBuffer, count);
   return self ? IPTR(self->impl, SerialBuffer)->count : 0;
}

// member accessors: SerialBuffer::_size
// (normal::uintsize)

/*nstSet*/inline /*0H*/uintsize SerialBuffer::_size_Prop::operator= (/*0H*/uintsize v)
{
   SELF(SerialBuffer, _size);
   IPTR(self->impl, SerialBuffer)->_size = v;
   return v;
}

/*regSet*/inline SerialBuffer::_size_Prop & SerialBuffer::_size_Prop::operator= (SerialBuffer::_size_Prop & prop)
{
   SELF(SerialBuffer, _size);
   /*0H*/uintsize v = prop;
   IPTR(self->impl, SerialBuffer)->_size = v;
   return prop;
}
/*regGet*/inline SerialBuffer::_size_Prop::operator /*0I*/uintsize () const
{
   SELF(SerialBuffer, _size);
   return self ? IPTR(self->impl, SerialBuffer)->_size : 0;
}

// member accessors: SerialBuffer::pos
// (normal::uintsize)

/*nstSet*/inline /*0H*/uintsize SerialBuffer::pos_Prop::operator= (/*0H*/uintsize v)
{
   SELF(SerialBuffer, pos);
   IPTR(self->impl, SerialBuffer)->pos = v;
   return v;
}

/*regSet*/inline SerialBuffer::pos_Prop & SerialBuffer::pos_Prop::operator= (SerialBuffer::pos_Prop & prop)
{
   SELF(SerialBuffer, pos);
   /*0H*/uintsize v = prop;
   IPTR(self->impl, SerialBuffer)->pos = v;
   return prop;
}
/*regGet*/inline SerialBuffer::pos_Prop::operator /*0I*/uintsize () const
{
   SELF(SerialBuffer, pos);
   return self ? IPTR(self->impl, SerialBuffer)->pos : 0;
}

inline Size::Size(MinMaxValue w, MinMaxValue h = 0)
{
   impl.w = w.impl;
   impl.h = h.impl;
}



// member accessors: Size::w
// (struct::unit|int)

/*nstSet*/inline /*0H*/MinMaxValue Size::w_Prop::operator= (/*0H*/MinMaxValue v)
{
   SELF(Size, w);
   self->impl.w = (int)v.impl;
   return v;
}

/*regSet*/inline Size::w_Prop & Size::w_Prop::operator= (Size::w_Prop & prop)
{
   SELF(Size, w);
   /*0H*/MinMaxValue v = prop;
   self->impl.w = (int)v.impl;
   return prop;
}
/*regGet*/inline Size::w_Prop::operator /*0I*/MinMaxValue () const
{
   SELF(Size, w);
   return MinMaxValue(self->impl.w);
}
/*regGet*/inline Size::w_Prop::operator /*0J*/C(MinMaxValue) () const
{
   SELF(Size, w);
   return MinMaxValue(self->w);
}

// member accessors: Size::h
// (struct::unit|int)

/*nstSet*/inline /*0H*/MinMaxValue Size::h_Prop::operator= (/*0H*/MinMaxValue v)
{
   SELF(Size, h);
   self->impl.h = (int)v.impl;
   return v;
}

/*regSet*/inline Size::h_Prop & Size::h_Prop::operator= (Size::h_Prop & prop)
{
   SELF(Size, h);
   /*0H*/MinMaxValue v = prop;
   self->impl.h = (int)v.impl;
   return prop;
}
/*regGet*/inline Size::h_Prop::operator /*0I*/MinMaxValue () const
{
   SELF(Size, h);
   return MinMaxValue(self->impl.h);
}
/*regGet*/inline Size::h_Prop::operator /*0J*/C(MinMaxValue) () const
{
   SELF(Size, h);
   return MinMaxValue(self->h);
}




// member accessors: SubModule::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/SubModule TSubModule<TC, TCO>::prev_Prop::operator= (/*0H*/SubModule & v)
{
   SELF(SubModule, prev);
   ((C(SubModule) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TSubModule<TC, TCO>::prev_Prop & TSubModule<TC, TCO>::prev_Prop::operator= (typename TSubModule<TC, TCO>::prev_Prop & prop)
{
   SELF(SubModule, prev);
   /*0H*/SubModule v = prop;
   ((C(SubModule) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TSubModule<TC, TCO>::prev_Prop::operator /*0I*/SubModule () const
{
   __attribute__((unused)) TSubModule TCTCO * self = CONTAINER_OF(this, TSubModule TCTCO, prev);
   SubModule value(((C(SubModule) *)self->impl)->prev);
   return value;
}

// member accessors: SubModule::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/SubModule TSubModule<TC, TCO>::next_Prop::operator= (/*0H*/SubModule & v)
{
   SELF(SubModule, next);
   ((C(SubModule) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TSubModule<TC, TCO>::next_Prop & TSubModule<TC, TCO>::next_Prop::operator= (typename TSubModule<TC, TCO>::next_Prop & prop)
{
   SELF(SubModule, next);
   /*0H*/SubModule v = prop;
   ((C(SubModule) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TSubModule<TC, TCO>::next_Prop::operator /*0I*/SubModule () const
{
   __attribute__((unused)) TSubModule TCTCO * self = CONTAINER_OF(this, TSubModule TCTCO, next);
   SubModule value(((C(SubModule) *)self->impl)->next);
   return value;
}

// member accessors: SubModule::module
// (nohead::normal)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Module TSubModule<TC, TCO>::module_Prop::operator= (/*0H*/Module v)
{
   SELF(SubModule, module);
   ((C(SubModule) *)self->impl)->module = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TSubModule<TC, TCO>::module_Prop & TSubModule<TC, TCO>::module_Prop::operator= (typename TSubModule<TC, TCO>::module_Prop & prop)
{
   SELF(SubModule, module);
   /*0H*/Module v = prop;
   ((C(SubModule) *)self->impl)->module = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TSubModule<TC, TCO>::module_Prop::operator /*0I*/Module () const
{
   __attribute__((unused)) TSubModule TCTCO * self = CONTAINER_OF(this, TSubModule TCTCO, module);
   Module value(((C(SubModule) *)self->impl)->module);
   return value;
}

// member accessors: SubModule::importMode
// (nohead::enum|int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Access_Mode TSubModule<TC, TCO>::importMode_Prop::operator= (/*0H*/Access_Mode v)
{
   SELF(SubModule, importMode);
   ((C(SubModule) *)self->impl)->importMode = (C(AccessMode))v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TSubModule<TC, TCO>::importMode_Prop & TSubModule<TC, TCO>::importMode_Prop::operator= (typename TSubModule<TC, TCO>::importMode_Prop & prop)
{
   SELF(SubModule, importMode);
   /*0H*/Access_Mode v = prop;
   ((C(SubModule) *)self->impl)->importMode = (C(AccessMode))v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TSubModule<TC, TCO>::importMode_Prop::operator /*0I*/Access_Mode () const
{
   __attribute__((unused)) TSubModule TCTCO * self = CONTAINER_OF(this, TSubModule TCTCO, importMode);
   return self ? ((C(SubModule) *)self->impl)->importMode : (Access_Mode)0;
}
// A (normal:string)
inline ZString::operator constString() const { return (constString)ZString_to_String(impl); }
inline ZString::ZString(const char * s) : ZString() { impl = ZString_from_String((const C(String))s); }
inline ZString & ZString::operator =(constString s) { ZString_from_String((const C(String))s); return *this; }

inline ZString::ZString(char * _string, int len = 0, StringAllocType allocType = (StringAllocType)0, int size = 0, int minSize = 0, int maxSize = 0, const char * string = null) : ZString()
{
   this->_string = _string;
   this->len = len;
   this->allocType = allocType;
   this->size = size;
   this->minSize = minSize;
   this->maxSize = maxSize;
   this->string = string;
}


inline void ZString::concat(/*1Ab*/ZString & s)
{
   ZString_concat(impl, /*5De*/s.impl);
}
template<typename... Args> inline void ZString::concatf(/*1Ab*/const char * format, /*1Ab*/Args... args)
{
   ZString_concatf(impl, /*5Ge*/format, /*5Ae*/args...);
}
inline void ZString::concatn(/*1Ab*/ZString & s, /*1Ab*/int l)
{
   ZString_concatn(impl, /*5De*/s.impl, /*5Ge*/l);
}
template <typename ...Ts> inline void ZString::concatx(/*1Ab*/const Ts&... ts)
{
   std::apply(
      [this](/*1Ab*/auto ...args) { ZString_concatx(impl, /*5Ae*/args...); },
      std::tuple_cat(std::make_tuple(classof(ts), vapass(ts))..., std::make_tuple(null))
   );
}
inline void ZString::copy(/*1Ab*/ZString & s)
{
   ZString_copy(impl, /*5De*/s.impl);
}
inline void ZString::copyString(/*1Ab*/const char * value, /*1Ab*/int newLen)
{
   ZString_copyString(impl, /*5Ge*/value, /*5Ge*/newLen);
}


// property callers: ZString::string
// (normal::const char *)

/*nstSet*/inline /*0H*/const char * ZString::string_Prop::operator= (/*0H*/const char * v)
{
   SELF(ZString, string);
   ZString_set_string(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline ZString::string_Prop & ZString::string_Prop::operator= (ZString::string_Prop & prop)
{
   SELF(ZString, string);
   /*0H*/const char * v = prop;
   ZString_set_string(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline ZString::string_Prop::operator /*0I*/const char * () const
{
   SELF(ZString, string);
   return ZString_get_string(self ? self->impl : null);
}


// member accessors: ZString::_string
// (normal::char *)

/*nstSet*/inline /*0H*/char * ZString::_string_Prop::operator= (/*0H*/char * v)
{
   SELF(ZString, _string);
   IPTR(self->impl, ZString)->_string = v;
   return v;
}

/*regSet*/inline ZString::_string_Prop & ZString::_string_Prop::operator= (ZString::_string_Prop & prop)
{
   SELF(ZString, _string);
   /*0H*/char * v = prop;
   IPTR(self->impl, ZString)->_string = v;
   return prop;
}
/*regGet*/inline ZString::_string_Prop::operator /*0I*/char * () const
{
   SELF(ZString, _string);
   return self ? IPTR(self->impl, ZString)->_string : null;
}

// member accessors: ZString::len
// (normal::int)

/*nstSet*/inline /*0H*/int ZString::len_Prop::operator= (/*0H*/int v)
{
   SELF(ZString, len);
   IPTR(self->impl, ZString)->len = v;
   return v;
}

/*regSet*/inline ZString::len_Prop & ZString::len_Prop::operator= (ZString::len_Prop & prop)
{
   SELF(ZString, len);
   /*0H*/int v = prop;
   IPTR(self->impl, ZString)->len = v;
   return prop;
}
/*regGet*/inline ZString::len_Prop::operator /*0I*/int () const
{
   SELF(ZString, len);
   return self ? IPTR(self->impl, ZString)->len : 0;
}

// member accessors: ZString::allocType
// (normal::enum|int)

/*nstSet*/inline /*0H*/StringAllocType ZString::allocType_Prop::operator= (/*0H*/StringAllocType v)
{
   SELF(ZString, allocType);
   IPTR(self->impl, ZString)->allocType = (C(StringAllocType))v;
   return v;
}

/*regSet*/inline ZString::allocType_Prop & ZString::allocType_Prop::operator= (ZString::allocType_Prop & prop)
{
   SELF(ZString, allocType);
   /*0H*/StringAllocType v = prop;
   IPTR(self->impl, ZString)->allocType = (C(StringAllocType))v;
   return prop;
}
/*regGet*/inline ZString::allocType_Prop::operator /*0I*/StringAllocType () const
{
   SELF(ZString, allocType);
   return self ? (StringAllocType)IPTR(self->impl, ZString)->allocType : (StringAllocType)0;
}

// member accessors: ZString::size
// (normal::int)

/*nstSet*/inline /*0H*/int ZString::size_Prop::operator= (/*0H*/int v)
{
   SELF(ZString, size);
   IPTR(self->impl, ZString)->size = v;
   return v;
}

/*regSet*/inline ZString::size_Prop & ZString::size_Prop::operator= (ZString::size_Prop & prop)
{
   SELF(ZString, size);
   /*0H*/int v = prop;
   IPTR(self->impl, ZString)->size = v;
   return prop;
}
/*regGet*/inline ZString::size_Prop::operator /*0I*/int () const
{
   SELF(ZString, size);
   return self ? IPTR(self->impl, ZString)->size : 0;
}

// member accessors: ZString::minSize
// (normal::int)

/*nstSet*/inline /*0H*/int ZString::minSize_Prop::operator= (/*0H*/int v)
{
   SELF(ZString, minSize);
   IPTR(self->impl, ZString)->minSize = v;
   return v;
}

/*regSet*/inline ZString::minSize_Prop & ZString::minSize_Prop::operator= (ZString::minSize_Prop & prop)
{
   SELF(ZString, minSize);
   /*0H*/int v = prop;
   IPTR(self->impl, ZString)->minSize = v;
   return prop;
}
/*regGet*/inline ZString::minSize_Prop::operator /*0I*/int () const
{
   SELF(ZString, minSize);
   return self ? IPTR(self->impl, ZString)->minSize : 0;
}

// member accessors: ZString::maxSize
// (normal::int)

/*nstSet*/inline /*0H*/int ZString::maxSize_Prop::operator= (/*0H*/int v)
{
   SELF(ZString, maxSize);
   IPTR(self->impl, ZString)->maxSize = v;
   return v;
}

/*regSet*/inline ZString::maxSize_Prop & ZString::maxSize_Prop::operator= (ZString::maxSize_Prop & prop)
{
   SELF(ZString, maxSize);
   /*0H*/int v = prop;
   IPTR(self->impl, ZString)->maxSize = v;
   return prop;
}
/*regGet*/inline ZString::maxSize_Prop::operator /*0I*/int () const
{
   SELF(ZString, maxSize);
   return self ? IPTR(self->impl, ZString)->maxSize : 0;
}

///////////////////////////////////////////////// [ecrt]/eC::containers //////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////


template <typename TP_AT> TCPPClass<TAVLTree<TP_AT>> TAVLTree<TP_AT>::_cpp_class;

template <typename TP_AT> void TAVLTree<TP_AT>::class_registration(CPPClass & _cpp_class)
{
}

template <typename TP_T, typename TP_I, typename TP_D> inline TArray<TP_T, TP_I, TP_D>::TArray(TP(Container, T) * array, uint count, uint minAllocSize, uint size) : TArray<TP_T, TP_I, TP_D>()
{
   this->array = array;
   this->count = count;
   this->minAllocSize = minAllocSize;
   this->size = size;
}

template <typename TP_T, typename TP_I, typename TP_D> TCPPClass<TArray<TP_T, TP_I, TP_D>> TArray<TP_T, TP_I, TP_D>::_cpp_class;

template <typename TP_T, typename TP_I, typename TP_D> void TArray<TP_T, TP_I, TP_D>::class_registration(CPPClass & _cpp_class)
{
}


// property callers: Array::size
// (normal::uint)

/*nstSet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline /*0H*/uint TArray<TP_T _ARG TP_I _ARG TP_D> ::size_Prop::operator= (/*0H*/uint v)
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), size);
   Array_set_size(self ? self->impl : null, v);
   return v;
}

/*regSet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline typename TArray<TP_T _ARG TP_I _ARG TP_D>::size_Prop & TArray<TP_T _ARG TP_I _ARG TP_D>::size_Prop::operator= (TArray<TP_T _ARG TP_I _ARG TP_D>::size_Prop & prop)
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), size);
   /*0H*/uint v = prop;
   Array_set_size(self ? self->impl : null, v);
   return prop;
}
/*regGet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline TArray<TP_T _ARG TP_I _ARG TP_D> ::size_Prop::operator /*0I*/uint () const
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), size);
   return Array_get_size(self ? self->impl : null);
}

// property callers: Array::minAllocSize
// (normal::uint)

/*nstSet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline /*0H*/uint TArray<TP_T _ARG TP_I _ARG TP_D> ::minAllocSize_Prop::operator= (/*0H*/uint v)
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), minAllocSize);
   Array_set_minAllocSize(self ? self->impl : null, v);
   return v;
}

/*regSet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline typename TArray<TP_T _ARG TP_I _ARG TP_D>::minAllocSize_Prop & TArray<TP_T _ARG TP_I _ARG TP_D>::minAllocSize_Prop::operator= (TArray<TP_T _ARG TP_I _ARG TP_D>::minAllocSize_Prop & prop)
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), minAllocSize);
   /*0H*/uint v = prop;
   Array_set_minAllocSize(self ? self->impl : null, v);
   return prop;
}
/*regGet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline TArray<TP_T _ARG TP_I _ARG TP_D> ::minAllocSize_Prop::operator /*0I*/uint () const
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), minAllocSize);
   return self ? IPTR(self->impl, Array)->minAllocSize : 0;
}


// member accessors: Array::array
// (normal::T *)

/*nstSet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline /*0H*/TP(Container, T) * TArray<TP_T _ARG TP_I _ARG TP_D> ::array_Prop::operator= (/*0H*/TP(Container, T) * v)
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), array);
   IPTR(self->impl, Array)->array = v;
   return v;
}

/*regSet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline typename TArray<TP_T _ARG TP_I _ARG TP_D>::array_Prop & TArray<TP_T _ARG TP_I _ARG TP_D>::array_Prop::operator= (TArray<TP_T _ARG TP_I _ARG TP_D>::array_Prop & prop)
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), array);
   /*0H*/TP(Container, T) * v = prop;
   IPTR(self->impl, Array)->array = v;
   return prop;
}
/*regGet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline TArray<TP_T _ARG TP_I _ARG TP_D> ::array_Prop::operator /*0I*/TP(Container, T) * () const
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), array);
   return self ? IPTR(self->impl, Array)->array : null;
}

// member accessors: Array::count
// (normal::uint)

/*nstSet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline /*0H*/uint TArray<TP_T _ARG TP_I _ARG TP_D> ::count_Prop::operator= (/*0H*/uint v)
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), count);
   IPTR(self->impl, Array)->count = v;
   return v;
}

/*regSet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline typename TArray<TP_T _ARG TP_I _ARG TP_D>::count_Prop & TArray<TP_T _ARG TP_I _ARG TP_D>::count_Prop::operator= (TArray<TP_T _ARG TP_I _ARG TP_D>::count_Prop & prop)
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), count);
   /*0H*/uint v = prop;
   IPTR(self->impl, Array)->count = v;
   return prop;
}
/*regGet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline TArray<TP_T _ARG TP_I _ARG TP_D> ::count_Prop::operator /*0I*/uint () const
{
   TSELF(Array, (<TP_T _ARG TP_I _ARG TP_D>), count);
   return self ? IPTR(self->impl, Array)->count : 0;
}


template <class TC, C(Class) ** TCO> inline C(BTNode) * TBTNode<TC, TCO>::findPrefix(/*1Ab*/const char * key)
{
   return BTNode_findPrefix((C(BTNode)*)this->impl, /*5Ge*/key);
}
template <class TC, C(Class) ** TCO> inline C(BTNode) * TBTNode<TC, TCO>::findString(/*1Ab*/const char * key)
{
   return BTNode_findString((C(BTNode)*)this->impl, /*5Ge*/key);
}


// property callers: BTNode::prev   // get only
// (nohead::nohead)

/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNode<TC, TCO>::prev_Prop::operator /*0I*/BTNode () const
{
   __attribute__((unused)) TBTNode TCTCO * self = CONTAINER_OF(this, TBTNode TCTCO, prev);
   BTNode value(BTNode_get_prev(self->impl));
   return value;
}

// property callers: BTNode::next   // get only
// (nohead::nohead)

/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNode<TC, TCO>::next_Prop::operator /*0I*/BTNode () const
{
   __attribute__((unused)) TBTNode TCTCO * self = CONTAINER_OF(this, TBTNode TCTCO, next);
   BTNode value(BTNode_get_next(self->impl));
   return value;
}

// property callers: BTNode::minimum   // get only
// (nohead::nohead)

/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNode<TC, TCO>::minimum_Prop::operator /*0I*/BTNode () const
{
   __attribute__((unused)) TBTNode TCTCO * self = CONTAINER_OF(this, TBTNode TCTCO, minimum);
   BTNode value(BTNode_get_minimum(self->impl));
   return value;
}

// property callers: BTNode::maximum   // get only
// (nohead::nohead)

/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNode<TC, TCO>::maximum_Prop::operator /*0I*/BTNode () const
{
   __attribute__((unused)) TBTNode TCTCO * self = CONTAINER_OF(this, TBTNode TCTCO, maximum);
   BTNode value(BTNode_get_maximum(self->impl));
   return value;
}

// property callers: BTNode::count   // get only
// (nohead::int)

/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNode<TC, TCO>::count_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TBTNode TCTCO * self = CONTAINER_OF(this, TBTNode TCTCO, count);
   return BTNode_get_count(self ? self->impl : null);
}

// property callers: BTNode::depthProp   // get only
// (nohead::int)

/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNode<TC, TCO>::depthProp_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TBTNode TCTCO * self = CONTAINER_OF(this, TBTNode TCTCO, depthProp);
   return BTNode_get_depthProp(self ? self->impl : null);
}


// member accessors: BTNode::key
// (nohead::uintptr)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/uintptr TBTNode<TC, TCO>::key_Prop::operator= (/*0H*/uintptr v)
{
   SELF(BTNode, key);
   ((C(BTNode) *)self->impl)->key = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBTNode<TC, TCO>::key_Prop & TBTNode<TC, TCO>::key_Prop::operator= (typename TBTNode<TC, TCO>::key_Prop & prop)
{
   SELF(BTNode, key);
   /*0H*/uintptr v = prop;
   ((C(BTNode) *)self->impl)->key = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNode<TC, TCO>::key_Prop::operator /*0I*/uintptr () const
{
   __attribute__((unused)) TBTNode TCTCO * self = CONTAINER_OF(this, TBTNode TCTCO, key);
   return self ? ((C(BTNode) *)self->impl)->key : 0;
}

// member accessors: BTNode::parent
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BTNode TBTNode<TC, TCO>::parent_Prop::operator= (/*0H*/BTNode & v)
{
   SELF(BTNode, parent);
   ((C(BTNode) *)self->impl)->parent = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBTNode<TC, TCO>::parent_Prop & TBTNode<TC, TCO>::parent_Prop::operator= (typename TBTNode<TC, TCO>::parent_Prop & prop)
{
   SELF(BTNode, parent);
   /*0H*/BTNode v = prop;
   ((C(BTNode) *)self->impl)->parent = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNode<TC, TCO>::parent_Prop::operator /*0I*/BTNode () const
{
   __attribute__((unused)) TBTNode TCTCO * self = CONTAINER_OF(this, TBTNode TCTCO, parent);
   BTNode value(((C(BTNode) *)self->impl)->parent);
   return value;
}

// member accessors: BTNode::left
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BTNode TBTNode<TC, TCO>::left_Prop::operator= (/*0H*/BTNode & v)
{
   SELF(BTNode, left);
   ((C(BTNode) *)self->impl)->left = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBTNode<TC, TCO>::left_Prop & TBTNode<TC, TCO>::left_Prop::operator= (typename TBTNode<TC, TCO>::left_Prop & prop)
{
   SELF(BTNode, left);
   /*0H*/BTNode v = prop;
   ((C(BTNode) *)self->impl)->left = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNode<TC, TCO>::left_Prop::operator /*0I*/BTNode () const
{
   __attribute__((unused)) TBTNode TCTCO * self = CONTAINER_OF(this, TBTNode TCTCO, left);
   BTNode value(((C(BTNode) *)self->impl)->left);
   return value;
}

// member accessors: BTNode::right
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/BTNode TBTNode<TC, TCO>::right_Prop::operator= (/*0H*/BTNode & v)
{
   SELF(BTNode, right);
   ((C(BTNode) *)self->impl)->right = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBTNode<TC, TCO>::right_Prop & TBTNode<TC, TCO>::right_Prop::operator= (typename TBTNode<TC, TCO>::right_Prop & prop)
{
   SELF(BTNode, right);
   /*0H*/BTNode v = prop;
   ((C(BTNode) *)self->impl)->right = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNode<TC, TCO>::right_Prop::operator /*0I*/BTNode () const
{
   __attribute__((unused)) TBTNode TCTCO * self = CONTAINER_OF(this, TBTNode TCTCO, right);
   BTNode value(((C(BTNode) *)self->impl)->right);
   return value;
}

// member accessors: BTNode::depth
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TBTNode<TC, TCO>::depth_Prop::operator= (/*0H*/int v)
{
   SELF(BTNode, depth);
   ((C(BTNode) *)self->impl)->depth = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TBTNode<TC, TCO>::depth_Prop & TBTNode<TC, TCO>::depth_Prop::operator= (typename TBTNode<TC, TCO>::depth_Prop & prop)
{
   SELF(BTNode, depth);
   /*0H*/int v = prop;
   ((C(BTNode) *)self->impl)->depth = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TBTNode<TC, TCO>::depth_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TBTNode TCTCO * self = CONTAINER_OF(this, TBTNode TCTCO, depth);
   return self ? ((C(BTNode) *)self->impl)->depth : 0;
}


inline C(bool) BinaryTree::add(/*1Ab*/BTNode node)
{
   return BinaryTree_add(&impl, /*5De*/node.impl);
}
inline C(bool) BinaryTree::check()
{
   return BinaryTree_check(&impl);
}
inline int BinaryTree::compareInt(/*1Ab*/uintptr a, /*1Ab*/uintptr b)
{
   return BinaryTree_compareInt(&impl, /*5Ge*/a, /*5Ge*/b);
}
inline int BinaryTree::compareString(/*1Ab*/const char * a, /*1Ab*/const char * b)
{
   return BinaryTree_compareString(&impl, /*5Ge*/a, /*5Ge*/b);
}
inline void BinaryTree::_delete(/*1Ab*/BTNode node)
{
   BinaryTree_delete(&impl, /*5De*/node.impl);
}
inline C(BTNode) * BinaryTree::find(/*1Ab*/uintptr key)
{
   return BinaryTree_find(&impl, /*5Ge*/key);
}
inline C(BTNode) * BinaryTree::findAll(/*1Ab*/uintptr key)
{
   return BinaryTree_findAll(&impl, /*5Ge*/key);
}
inline C(BTNode) * BinaryTree::findPrefix(/*1Ab*/const char * key)
{
   return BinaryTree_findPrefix(&impl, /*5Ge*/key);
}
inline C(BTNode) * BinaryTree::findString(/*1Ab*/const char * key)
{
   return BinaryTree_findString(&impl, /*5Ge*/key);
}
inline void BinaryTree::free()
{
   BinaryTree_free(&impl);
}
inline void BinaryTree::freeString(/*1Ab*/char * string)
{
   BinaryTree_freeString(/*5Ge*/string);
}
inline char * BinaryTree::print(/*1Ab*/char * output, /*1Ab*/TreePrintStyle tps)
{
   return BinaryTree_print(&impl, /*5Ge*/output, /*5Ee*/(C(TreePrintStyle))tps);
}
inline void BinaryTree::remove(/*1Ab*/BTNode node)
{
   BinaryTree_remove(&impl, /*5De*/node.impl);
}


// property callers: BinaryTree::first   // get only
// (struct::nohead)

/*regGet*/inline BinaryTree::first_Prop::operator /*0I*/BTNode () const
{
   SELF(BinaryTree, first);
   BTNode value(BinaryTree_get_first(&self->impl));
   return value;
}

// property callers: BinaryTree::last   // get only
// (struct::nohead)

/*regGet*/inline BinaryTree::last_Prop::operator /*0I*/BTNode () const
{
   SELF(BinaryTree, last);
   BTNode value(BinaryTree_get_last(&self->impl));
   return value;
}


// member accessors: BinaryTree::root
// (struct::nohead)

/*nstSet*/inline /*0H*/BTNode BinaryTree::root_Prop::operator= (/*0H*/BTNode & v)
{
   SELF(BinaryTree, root);
   self->impl.root = v.impl;
   return v;
}

/*regSet*/inline BinaryTree::root_Prop & BinaryTree::root_Prop::operator= (BinaryTree::root_Prop & prop)
{
   SELF(BinaryTree, root);
   /*0H*/BTNode v = prop;
   self->impl.root = v.impl;
   return prop;
}
/*regGet*/inline BinaryTree::root_Prop::operator /*0I*/BTNode () const
{
   SELF(BinaryTree, root);
   BTNode value(((C(BinaryTree) *)&self->impl)->root);
   return value;
}

// member accessors: BinaryTree::count
// (struct::int)

/*nstSet*/inline /*0H*/int BinaryTree::count_Prop::operator= (/*0H*/int v)
{
   SELF(BinaryTree, count);
   self->impl.count = v;
   return v;
}

/*regSet*/inline BinaryTree::count_Prop & BinaryTree::count_Prop::operator= (BinaryTree::count_Prop & prop)
{
   SELF(BinaryTree, count);
   /*0H*/int v = prop;
   self->impl.count = v;
   return prop;
}
/*regGet*/inline BinaryTree::count_Prop::operator /*0I*/int () const
{
   SELF(BinaryTree, count);
   return self ? ((C(BinaryTree) *)&self->impl)->count : 0;
}

inline BuiltInContainer::BuiltInContainer(void ** _vTbl)
{
   impl._vTbl = _vTbl;
}



// member accessors: BuiltInContainer::_vTbl
// (struct::void * *)

/*nstSet*/inline /*0H*/void ** BuiltInContainer::_vTbl_Prop::operator= (/*0H*/void ** v)
{
   SELF(BuiltInContainer, _vTbl);
   self->impl._vTbl = v;
   return v;
}

/*regSet*/inline BuiltInContainer::_vTbl_Prop & BuiltInContainer::_vTbl_Prop::operator= (BuiltInContainer::_vTbl_Prop & prop)
{
   SELF(BuiltInContainer, _vTbl);
   /*0H*/void ** v = prop;
   self->impl._vTbl = v;
   return prop;
}
/*regGet*/inline BuiltInContainer::_vTbl_Prop::operator /*0I*/void ** () const
{
   SELF(BuiltInContainer, _vTbl);
   return self ? ((C(BuiltInContainer) *)&self->impl)->_vTbl : null;
}

// member accessors: BuiltInContainer::_class
// (struct::nohead)

/*nstSet*/inline /*0H*/Class BuiltInContainer::_class_Prop::operator= (/*0H*/Class & v)
{
   SELF(BuiltInContainer, _class);
   self->impl._class = v.impl;
   return v;
}

/*regSet*/inline BuiltInContainer::_class_Prop & BuiltInContainer::_class_Prop::operator= (BuiltInContainer::_class_Prop & prop)
{
   SELF(BuiltInContainer, _class);
   /*0H*/Class v = prop;
   self->impl._class = v.impl;
   return prop;
}
/*regGet*/inline BuiltInContainer::_class_Prop::operator /*0I*/Class () const
{
   SELF(BuiltInContainer, _class);
   Class value(((C(BuiltInContainer) *)&self->impl)->_class);
   return value;
}

// member accessors: BuiltInContainer::_refCount
// (struct::int)

/*nstSet*/inline /*0H*/int BuiltInContainer::_refCount_Prop::operator= (/*0H*/int v)
{
   SELF(BuiltInContainer, _refCount);
   self->impl._refCount = v;
   return v;
}

/*regSet*/inline BuiltInContainer::_refCount_Prop & BuiltInContainer::_refCount_Prop::operator= (BuiltInContainer::_refCount_Prop & prop)
{
   SELF(BuiltInContainer, _refCount);
   /*0H*/int v = prop;
   self->impl._refCount = v;
   return prop;
}
/*regGet*/inline BuiltInContainer::_refCount_Prop::operator /*0I*/int () const
{
   SELF(BuiltInContainer, _refCount);
   return self ? ((C(BuiltInContainer) *)&self->impl)->_refCount : 0;
}

// member accessors: BuiltInContainer::data
// (struct::void *)

/*nstSet*/inline /*0H*/void * BuiltInContainer::data_Prop::operator= (/*0H*/void * v)
{
   SELF(BuiltInContainer, data);
   self->impl.data = v;
   return v;
}

/*regSet*/inline BuiltInContainer::data_Prop & BuiltInContainer::data_Prop::operator= (BuiltInContainer::data_Prop & prop)
{
   SELF(BuiltInContainer, data);
   /*0H*/void * v = prop;
   self->impl.data = v;
   return prop;
}
/*regGet*/inline BuiltInContainer::data_Prop::operator /*0I*/void * () const
{
   SELF(BuiltInContainer, data);
   return self ? ((C(BuiltInContainer) *)&self->impl)->data : null;
}

// member accessors: BuiltInContainer::count
// (struct::int)

/*nstSet*/inline /*0H*/int BuiltInContainer::count_Prop::operator= (/*0H*/int v)
{
   SELF(BuiltInContainer, count);
   self->impl.count = v;
   return v;
}

/*regSet*/inline BuiltInContainer::count_Prop & BuiltInContainer::count_Prop::operator= (BuiltInContainer::count_Prop & prop)
{
   SELF(BuiltInContainer, count);
   /*0H*/int v = prop;
   self->impl.count = v;
   return prop;
}
/*regGet*/inline BuiltInContainer::count_Prop::operator /*0I*/int () const
{
   SELF(BuiltInContainer, count);
   return self ? ((C(BuiltInContainer) *)&self->impl)->count : 0;
}

// member accessors: BuiltInContainer::type
// (struct::nohead)

/*nstSet*/inline /*0H*/Class BuiltInContainer::type_Prop::operator= (/*0H*/Class & v)
{
   SELF(BuiltInContainer, type);
   self->impl.type = v.impl;
   return v;
}

/*regSet*/inline BuiltInContainer::type_Prop & BuiltInContainer::type_Prop::operator= (BuiltInContainer::type_Prop & prop)
{
   SELF(BuiltInContainer, type);
   /*0H*/Class v = prop;
   self->impl.type = v.impl;
   return prop;
}
/*regGet*/inline BuiltInContainer::type_Prop::operator /*0I*/Class () const
{
   SELF(BuiltInContainer, type);
   Class value(((C(BuiltInContainer) *)&self->impl)->type);
   return value;
}

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_add_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_add_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), add);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_add_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_add_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_add_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, add)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline IteratorPointer TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_add_Functor::operator()( /*6Ej*/TP_T value)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), add);
   C(IteratorPointer) * retIteratorPointer = Container_add(self ? self->impl : (C(Container))null, /*7Al*/toTA<TP_T>(value));
      return retIteratorPointer;
}
// inline void Container::register_add(CPPClass & cl, Container::Container_add_Functor::FunctionType func)
// {
//    ((Container::Container_add_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, add)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_copy_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_copy_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), copy);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_copy_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_copy_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_copy_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, copy)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline void TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_copy_Functor::operator()( /*6Fj*/TContainer & source)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), copy);
   Container_copy(self ? self->impl : (C(Container))null, /*7Al*/((Instance&)source).impl);
}
// inline void Container::register_copy(CPPClass & cl, Container::Container_copy_Functor::FunctionType func)
// {
//    ((Container::Container_copy_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, copy)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_delete_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_delete_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), delete_);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_delete_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_delete_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_delete_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, delete)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline void TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_delete_Functor::operator()( /*6Fj*/IteratorPointer it)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), delete_);
   Container_delete(self ? self->impl : (C(Container))null, /*7Al*/it.impl);
}
// inline void Container::register_delete(CPPClass & cl, Container::Container_delete_Functor::FunctionType func)
// {
//    ((Container::Container_delete_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, delete)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_find_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_find_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), find);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_find_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_find_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_find_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, find)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline IteratorPointer TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_find_Functor::operator()( /*6Ej*/TP_D value)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), find);
   C(IteratorPointer) * retIteratorPointer = Container_find(self ? self->impl : (C(Container))null, /*7Al*/toTA<TP_D>(value));
      return retIteratorPointer;
}
// inline void Container::register_find(CPPClass & cl, Container::Container_find_Functor::FunctionType func)
// {
//    ((Container::Container_find_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, find)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_free_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_free_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), free);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_free_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_free_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_free_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, free)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline void TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_free_Functor::operator()( )
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), free);
   Container_free(self ? self->impl : (C(Container))null);
}
// inline void Container::register_free(CPPClass & cl, Container::Container_free_Functor::FunctionType func)
// {
//    ((Container::Container_free_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, free)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_freeIterator_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_freeIterator_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), freeIterator);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_freeIterator_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_freeIterator_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_freeIterator_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, freeIterator)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline void TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_freeIterator_Functor::operator()( /*6Fj*/IteratorPointer it)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), freeIterator);
   Container_freeIterator(self ? self->impl : (C(Container))null, /*7Al*/it.impl);
}
// inline void Container::register_freeIterator(CPPClass & cl, Container::Container_freeIterator_Functor::FunctionType func)
// {
//    ((Container::Container_freeIterator_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, freeIterator)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getAtPosition_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getAtPosition_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getAtPosition);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getAtPosition_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getAtPosition_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getAtPosition_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, getAtPosition)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline IteratorPointer TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getAtPosition_Functor::operator()( /*6Ej*/TP_I pos, /*6Fj*/bool create, /*6Cj*/C(bool) * justAdded)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getAtPosition);
   C(IteratorPointer) * retIteratorPointer = Container_getAtPosition(self ? self->impl : (C(Container))null, /*7Al*/toTA<TP_I>(pos), /*7Al*/(C(bool))create, /*7Al*/justAdded);
      return retIteratorPointer;
}
// inline void Container::register_getAtPosition(CPPClass & cl, Container::Container_getAtPosition_Functor::FunctionType func)
// {
//    ((Container::Container_getAtPosition_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, getAtPosition)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getCount_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getCount_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getCount);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getCount_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getCount_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getCount_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, getCount)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline int TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getCount_Functor::operator()( )
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getCount);
   return Container_getCount(self ? self->impl : (C(Container))null);
}
// inline void Container::register_getCount(CPPClass & cl, Container::Container_getCount_Functor::FunctionType func)
// {
//    ((Container::Container_getCount_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, getCount)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getData_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getData_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getData);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getData_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getData_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getData_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, getData)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline TP_D TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getData_Functor::operator()( /*6Fj*/IteratorPointer pointer)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getData);
   return fromTA(Container_getData(self ? self->impl : (C(Container))null, /*7Al*/pointer.impl));
}
// inline void Container::register_getData(CPPClass & cl, Container::Container_getData_Functor::FunctionType func)
// {
//    ((Container::Container_getData_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, getData)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getFirst_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getFirst_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getFirst);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getFirst_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getFirst_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getFirst_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, getFirst)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline IteratorPointer TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getFirst_Functor::operator()( )
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getFirst);
   C(IteratorPointer) * retIteratorPointer = Container_getFirst(self ? self->impl : (C(Container))null);
      return retIteratorPointer;
}
// inline void Container::register_getFirst(CPPClass & cl, Container::Container_getFirst_Functor::FunctionType func)
// {
//    ((Container::Container_getFirst_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, getFirst)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getLast_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getLast_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getLast);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getLast_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getLast_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getLast_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, getLast)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline IteratorPointer TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getLast_Functor::operator()( )
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getLast);
   C(IteratorPointer) * retIteratorPointer = Container_getLast(self ? self->impl : (C(Container))null);
      return retIteratorPointer;
}
// inline void Container::register_getLast(CPPClass & cl, Container::Container_getLast_Functor::FunctionType func)
// {
//    ((Container::Container_getLast_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, getLast)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getNext_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getNext_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getNext);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getNext_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getNext_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getNext_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, getNext)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline IteratorPointer TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getNext_Functor::operator()( /*6Fj*/IteratorPointer pointer)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getNext);
   C(IteratorPointer) * retIteratorPointer = Container_getNext(self ? self->impl : (C(Container))null, /*7Al*/pointer.impl);
      return retIteratorPointer;
}
// inline void Container::register_getNext(CPPClass & cl, Container::Container_getNext_Functor::FunctionType func)
// {
//    ((Container::Container_getNext_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, getNext)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getPrev_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getPrev_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getPrev);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getPrev_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getPrev_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getPrev_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, getPrev)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline IteratorPointer TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_getPrev_Functor::operator()( /*6Fj*/IteratorPointer pointer)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), getPrev);
   C(IteratorPointer) * retIteratorPointer = Container_getPrev(self ? self->impl : (C(Container))null, /*7Al*/pointer.impl);
      return retIteratorPointer;
}
// inline void Container::register_getPrev(CPPClass & cl, Container::Container_getPrev_Functor::FunctionType func)
// {
//    ((Container::Container_getPrev_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, getPrev)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_insert_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_insert_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), insert);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_insert_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_insert_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_insert_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, insert)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline IteratorPointer TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_insert_Functor::operator()( /*6Fj*/IteratorPointer after, /*6Ej*/TP_T value)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), insert);
   C(IteratorPointer) * retIteratorPointer = Container_insert(self ? self->impl : (C(Container))null, /*7Al*/after.impl, /*7Al*/toTA<TP_T>(value));
      return retIteratorPointer;
}
// inline void Container::register_insert(CPPClass & cl, Container::Container_insert_Functor::FunctionType func)
// {
//    ((Container::Container_insert_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, insert)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_move_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_move_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), move);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_move_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_move_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_move_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, move)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline void TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_move_Functor::operator()( /*6Fj*/IteratorPointer it, /*6Fj*/IteratorPointer after)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), move);
   Container_move(self ? self->impl : (C(Container))null, /*7Al*/it.impl, /*7Al*/after.impl);
}
// inline void Container::register_move(CPPClass & cl, Container::Container_move_Functor::FunctionType func)
// {
//    ((Container::Container_move_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, move)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_remove_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_remove_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), remove);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_remove_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_remove_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_remove_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, remove)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline void TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_remove_Functor::operator()( /*6Fj*/IteratorPointer it)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), remove);
   Container_remove(self ? self->impl : (C(Container))null, /*7Al*/it.impl);
}
// inline void Container::register_remove(CPPClass & cl, Container::Container_remove_Functor::FunctionType func)
// {
//    ((Container::Container_remove_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, remove)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_removeAll_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_removeAll_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), removeAll);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_removeAll_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_removeAll_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_removeAll_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, removeAll)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline void TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_removeAll_Functor::operator()( )
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), removeAll);
   Container_removeAll(self ? self->impl : (C(Container))null);
}
// inline void Container::register_removeAll(CPPClass & cl, Container::Container_removeAll_Functor::FunctionType func)
// {
//    ((Container::Container_removeAll_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, removeAll)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_setData_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_setData_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), setData);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_setData_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_setData_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_setData_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, setData)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline bool TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_setData_Functor::operator()( /*6Fj*/IteratorPointer pointer, /*6Ej*/TP_D data)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), setData);
   return (bool)Container_setData(self ? self->impl : (C(Container))null, /*7Al*/pointer.impl, /*7Al*/toTA<TP_D>(data));
}
// inline void Container::register_setData(CPPClass & cl, Container::Container_setData_Functor::FunctionType func)
// {
//    ((Container::Container_setData_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, setData)] = func;
// }

template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline typename TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_sort_Functor::FunctionType TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_sort_Functor::operator= (FunctionType func)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), sort);
   if(self->vTbl == TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl)
   {
      uint size = TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())eC_new(sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_sort_Functor::FunctionType) * size);
      memcpy(self->vTbl, TContainer <TP_T _ARG TP_I _ARG TP_D>::_cpp_class.vTbl, sizeof(TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_sort_Functor::FunctionType) * size);
   }
   ((TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_sort_Functor::FunctionType *)self->vTbl)[M_VTBLID(Container, sort)] = func;
   return func;
}
template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T>
inline void TContainer <TP_T _ARG TP_I _ARG TP_D>::Container_sort_Functor::operator()( /*6Fj*/bool ascending)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), sort);
   Container_sort(self ? self->impl : (C(Container))null, /*7Al*/(C(bool))ascending);
}
// inline void Container::register_sort(CPPClass & cl, Container::Container_sort_Functor::FunctionType func)
// {
//    ((Container::Container_sort_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Container, sort)] = func;
// }

template <typename TP_T, typename TP_I, typename TP_D> TCPPClass<TContainer<TP_T, TP_I, TP_D>> TContainer<TP_T, TP_I, TP_D>::_cpp_class;

template <typename TP_T, typename TP_I, typename TP_D> void TContainer<TP_T, TP_I, TP_D>::class_registration(CPPClass & _cpp_class)
{

      addMethod(_cpp_class.impl, "Copy", (void *) +[](/*1Aa*/C(Container) o_, /*1Aa*/C(Container) source)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, copy);
         typename Container_copy_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_copy_Functor::FunctionType) i->vTbl[vid];
            /*2Bg*/TIH<TContainer> source_l(source); fn(*i, /*3Bd*/*source_l);
         }
         // 'cp2' is empty
         else
         {
            auto method = ((void (*) (/*1Aa*/C(Container) o_, /*1Aa*/C(Container) source))(CO(Container)->_vTbl)[M_VTBLID(Container, copy)]);
            if(method) return method (o_, source);
         }
         return ;
      });


      addMethod(_cpp_class.impl, "Delete", (void *) +[](/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * it)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, delete);
         typename Container_delete_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_delete_Functor::FunctionType) i->vTbl[vid];
            /*2Cg*/IteratorPointer it_l(it); fn(*i, /*3Cd*/it_l);
         }
         // 'cp2' is empty
         else
         {
            auto method = ((void (*) (/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * it))(CO(Container)->_vTbl)[M_VTBLID(Container, delete)]);
            if(method) return method (o_, it);
         }
         return ;
      });


      addMethod(_cpp_class.impl, "Free", (void *) +[](/*1Aa*/C(Container) o_)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, free);
         typename Container_free_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_free_Functor::FunctionType) i->vTbl[vid];
            fn(*i);
         }
         // 'cp2' is empty
         else
         {
            auto method = ((void (*) (/*1Aa*/C(Container) o_))(CO(Container)->_vTbl)[M_VTBLID(Container, free)]);
            if(method) return method (o_);
         }
         return ;
      });


      addMethod(_cpp_class.impl, "FreeIterator", (void *) +[](/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * it)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, freeIterator);
         typename Container_freeIterator_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_freeIterator_Functor::FunctionType) i->vTbl[vid];
            /*2Cg*/IteratorPointer it_l(it); fn(*i, /*3Cd*/it_l);
         }
         // 'cp2' is empty
         else
         {
            auto method = ((void (*) (/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * it))(CO(Container)->_vTbl)[M_VTBLID(Container, freeIterator)]);
            if(method) return method (o_, it);
         }
         return ;
      });


      addMethod(_cpp_class.impl, "GetCount", (void *) +[](/*1Aa*/C(Container) o_)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, getCount);
         typename Container_getCount_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_getCount_Functor::FunctionType) i->vTbl[vid];
            int ret = fn(*i); return ret;
         }
         // 'cp2' is empty
         else
         {
            auto method = ((int (*) (/*1Aa*/C(Container) o_))(CO(Container)->_vTbl)[M_VTBLID(Container, getCount)]);
            if(method) return method (o_);
         }
         return (int)1;
      });


      addMethod(_cpp_class.impl, "GetData", (void *) +[](/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * pointer)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, getData);
         typename Container_getData_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_getData_Functor::FunctionType) i->vTbl[vid];
            /*2Cg*/IteratorPointer pointer_l(pointer); TP_D ret = fn(*i, /*3Cd*/pointer_l); return ret;
         }
         // 'cp2' is empty
         else
         {
            auto method = ((TP_D (*) (/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * pointer))(CO(Container)->_vTbl)[M_VTBLID(Container, getData)]);
            if(method) return method (o_, pointer);
         }
         return (TP_D)1;
      });


      addMethod(_cpp_class.impl, "GetFirst", (void *) +[](/*1Aa*/C(Container) o_)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, getFirst);
         typename Container_getFirst_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_getFirst_Functor::FunctionType) i->vTbl[vid];
            C(IteratorPointer) * ret = fn(*i).impl; return ret;
         }
         // 'cp2' is empty
         else
         {
            auto method = ((C(IteratorPointer) * (*) (/*1Aa*/C(Container) o_))(CO(Container)->_vTbl)[M_VTBLID(Container, getFirst)]);
            if(method) return method (o_);
         }
         return (C(IteratorPointer) *)null;
      });


      addMethod(_cpp_class.impl, "GetLast", (void *) +[](/*1Aa*/C(Container) o_)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, getLast);
         typename Container_getLast_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_getLast_Functor::FunctionType) i->vTbl[vid];
            C(IteratorPointer) * ret = fn(*i).impl; return ret;
         }
         // 'cp2' is empty
         else
         {
            auto method = ((C(IteratorPointer) * (*) (/*1Aa*/C(Container) o_))(CO(Container)->_vTbl)[M_VTBLID(Container, getLast)]);
            if(method) return method (o_);
         }
         return (C(IteratorPointer) *)null;
      });


      addMethod(_cpp_class.impl, "GetNext", (void *) +[](/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * pointer)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, getNext);
         typename Container_getNext_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_getNext_Functor::FunctionType) i->vTbl[vid];
            /*2Cg*/IteratorPointer pointer_l(pointer); C(IteratorPointer) * ret = fn(*i, /*3Cd*/pointer_l).impl; return ret;
         }
         // 'cp2' is empty
         else
         {
            auto method = ((C(IteratorPointer) * (*) (/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * pointer))(CO(Container)->_vTbl)[M_VTBLID(Container, getNext)]);
            if(method) return method (o_, pointer);
         }
         return (C(IteratorPointer) *)null;
      });


      addMethod(_cpp_class.impl, "GetPrev", (void *) +[](/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * pointer)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, getPrev);
         typename Container_getPrev_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_getPrev_Functor::FunctionType) i->vTbl[vid];
            /*2Cg*/IteratorPointer pointer_l(pointer); C(IteratorPointer) * ret = fn(*i, /*3Cd*/pointer_l).impl; return ret;
         }
         // 'cp2' is empty
         else
         {
            auto method = ((C(IteratorPointer) * (*) (/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * pointer))(CO(Container)->_vTbl)[M_VTBLID(Container, getPrev)]);
            if(method) return method (o_, pointer);
         }
         return (C(IteratorPointer) *)null;
      });


      addMethod(_cpp_class.impl, "Move", (void *) +[](/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * it, /*1Aa*/C(IteratorPointer) * after)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, move);
         typename Container_move_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_move_Functor::FunctionType) i->vTbl[vid];
            /*2Cg*/IteratorPointer it_l(it); /*2Cg*/IteratorPointer after_l(after); fn(*i, /*3Cd*/it_l, /*3Cd*/after_l);
         }
         // 'cp2' is empty
         else
         {
            auto method = ((void (*) (/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * it, /*1Aa*/C(IteratorPointer) * after))(CO(Container)->_vTbl)[M_VTBLID(Container, move)]);
            if(method) return method (o_, it, after);
         }
         return ;
      });


      addMethod(_cpp_class.impl, "Remove", (void *) +[](/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * it)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, remove);
         typename Container_remove_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_remove_Functor::FunctionType) i->vTbl[vid];
            /*2Cg*/IteratorPointer it_l(it); fn(*i, /*3Cd*/it_l);
         }
         // 'cp2' is empty
         else
         {
            auto method = ((void (*) (/*1Aa*/C(Container) o_, /*1Aa*/C(IteratorPointer) * it))(CO(Container)->_vTbl)[M_VTBLID(Container, remove)]);
            if(method) return method (o_, it);
         }
         return ;
      });


      addMethod(_cpp_class.impl, "RemoveAll", (void *) +[](/*1Aa*/C(Container) o_)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, removeAll);
         typename Container_removeAll_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_removeAll_Functor::FunctionType) i->vTbl[vid];
            fn(*i);
         }
         // 'cp2' is empty
         else
         {
            auto method = ((void (*) (/*1Aa*/C(Container) o_))(CO(Container)->_vTbl)[M_VTBLID(Container, removeAll)]);
            if(method) return method (o_);
         }
         return ;
      });


      addMethod(_cpp_class.impl, "Sort", (void *) +[](/*1Aa*/C(Container) o_, /*1Aa*/C(bool) ascending)
      {
         XClass * cl = (o_) ? (XClass *)(o_)->_class : null;
         // 'cp1' is empty
         TContainer <TP_T _ARG TP_I _ARG TP_D> * i = (o_) ? (TContainer <TP_T _ARG TP_I _ARG TP_D> *)INSTANCEL(o_, cl) : null;
         int vid = M_VTBLID(Container, sort);
         typename Container_sort_Functor::FunctionType fn;
         if(i && i->vTbl && i->vTbl[vid])
         {
            fn = (typename Container_sort_Functor::FunctionType) i->vTbl[vid];
            fn(*i, /*3Hd*/(bool)ascending);
         }
         // 'cp2' is empty
         else
         {
            auto method = ((void (*) (/*1Aa*/C(Container) o_, /*1Aa*/C(bool) ascending))(CO(Container)->_vTbl)[M_VTBLID(Container, sort)]);
            if(method) return method (o_, ascending);
         }
         return ;
      });


}


// property callers: Container::copySrc   // set only
// (normal::normal)

/*nstSet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline /*0A*/const TContainer<TP_T, TP_I, TP_D> & TContainer<TP_T _ARG TP_I _ARG TP_D> ::copySrc_Prop::operator= (/*0A*/const TContainer<TP_T, TP_I, TP_D> & v)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), copySrc);
   Container_set_copySrc(self ? self->impl : null, ((Instance *)&v)->impl);
   return v;
}

/*nstSet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline /*0C*/const TContainer<TP_T, TP_I, TP_D> * TContainer<TP_T _ARG TP_I _ARG TP_D> ::copySrc_Prop::operator= (/*0C*/const TContainer<TP_T, TP_I, TP_D> * v)
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), copySrc);
   Container_set_copySrc(self ? self->impl : null, v ? ((Instance *)v)->impl : null);
   return v;
}


// property callers: Container::firstIterator   // get only
// (normal::struct)

/*regGet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline TContainer<TP_T _ARG TP_I _ARG TP_D> ::firstIterator_Prop::operator /*0I*/TIterator<TP_T, TP_D> () const
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), firstIterator);
   TIterator<TP_T, TP_D> value;Container_get_firstIterator(self->impl, &value.impl);
   return value;
}

// property callers: Container::lastIterator   // get only
// (normal::struct)

/*regGet*/template <typename TP_T _ARG typename TP_I = int _ARG typename TP_D = TP_T> inline TContainer<TP_T _ARG TP_I _ARG TP_D> ::lastIterator_Prop::operator /*0I*/TIterator<TP_T, TP_D> () const
{
   TSELF(Container, (<TP_T _ARG TP_I _ARG TP_D>), lastIterator);
   TIterator<TP_T, TP_D> value;Container_get_lastIterator(self->impl, &value.impl);
   return value;
}

template <typename TP_BT, typename TP_KT> TCPPClass<TCustomAVLTree<TP_BT, TP_KT>> TCustomAVLTree<TP_BT, TP_KT>::_cpp_class;

template <typename TP_BT, typename TP_KT> void TCustomAVLTree<TP_BT, TP_KT>::class_registration(CPPClass & _cpp_class)
{
}


// member accessors: CustomAVLTree::root
// (normal::BT)

/*nstSet*/template <typename TP_BT _ARG typename TP_KT = uint64> inline /*0H*/TP_BT TCustomAVLTree<TP_BT _ARG TP_KT> ::root_Prop::operator= (/*0H*/TP_BT v)
{
   TSELF(CustomAVLTree, (<TP_BT _ARG TP_KT>), root);
   IPTR(self->impl, CustomAVLTree)->root = v;
   return v;
}

/*regSet*/template <typename TP_BT _ARG typename TP_KT = uint64> inline typename TCustomAVLTree<TP_BT _ARG TP_KT>::root_Prop & TCustomAVLTree<TP_BT _ARG TP_KT>::root_Prop::operator= (TCustomAVLTree<TP_BT _ARG TP_KT>::root_Prop & prop)
{
   TSELF(CustomAVLTree, (<TP_BT _ARG TP_KT>), root);
   /*0H*/TP_BT v = prop;
   IPTR(self->impl, CustomAVLTree)->root = v;
   return prop;
}
/*regGet*/template <typename TP_BT _ARG typename TP_KT = uint64> inline TCustomAVLTree<TP_BT _ARG TP_KT> ::root_Prop::operator /*0I*/TP_BT () const
{
   TSELF(CustomAVLTree, (<TP_BT _ARG TP_KT>), root);
   return self ? IPTR(self->impl, CustomAVLTree)->root : 0;
}

// member accessors: CustomAVLTree::count
// (normal::int)

/*nstSet*/template <typename TP_BT _ARG typename TP_KT = uint64> inline /*0H*/int TCustomAVLTree<TP_BT _ARG TP_KT> ::count_Prop::operator= (/*0H*/int v)
{
   TSELF(CustomAVLTree, (<TP_BT _ARG TP_KT>), count);
   IPTR(self->impl, CustomAVLTree)->count = v;
   return v;
}

/*regSet*/template <typename TP_BT _ARG typename TP_KT = uint64> inline typename TCustomAVLTree<TP_BT _ARG TP_KT>::count_Prop & TCustomAVLTree<TP_BT _ARG TP_KT>::count_Prop::operator= (TCustomAVLTree<TP_BT _ARG TP_KT>::count_Prop & prop)
{
   TSELF(CustomAVLTree, (<TP_BT _ARG TP_KT>), count);
   /*0H*/int v = prop;
   IPTR(self->impl, CustomAVLTree)->count = v;
   return prop;
}
/*regGet*/template <typename TP_BT _ARG typename TP_KT = uint64> inline TCustomAVLTree<TP_BT _ARG TP_KT> ::count_Prop::operator /*0I*/int () const
{
   TSELF(CustomAVLTree, (<TP_BT _ARG TP_KT>), count);
   return self ? IPTR(self->impl, CustomAVLTree)->count : 0;
}

template <typename TP_KT, typename TP_VT> TCPPClass<THashMap<TP_KT, TP_VT>> THashMap<TP_KT, TP_VT>::_cpp_class;

template <typename TP_KT, typename TP_VT> void THashMap<TP_KT, TP_VT>::class_registration(CPPClass & _cpp_class)
{
}


// property callers: HashMap::count   // get only
// (normal::int)

/*regGet*/template <typename TP_KT = int64 _ARG typename TP_VT = uintptr> inline THashMap<TP_KT _ARG TP_VT> ::count_Prop::operator /*0I*/int () const
{
   TSELF(HashMap, (<TP_KT _ARG TP_VT>), count);
   return HashMap_get_count(self ? self->impl : null);
}

// property callers: HashMap::initSize   // set only
// (normal::int)

/*nstSet*/template <typename TP_KT = int64 _ARG typename TP_VT = uintptr> inline /*0G*/int THashMap<TP_KT _ARG TP_VT> ::initSize_Prop::operator= (/*0G*/int v)
{
   TSELF(HashMap, (<TP_KT _ARG TP_VT>), initSize);
   HashMap_set_initSize(self->impl, v);
   return v;
}



// member accessors: HashMap::noRemResize
// (normal::enum|uint)

/*nstSet*/template <typename TP_KT = int64 _ARG typename TP_VT = uintptr> inline /*0H*/bool THashMap<TP_KT _ARG TP_VT> ::noRemResize_Prop::operator= (/*0H*/bool v)
{
   TSELF(HashMap, (<TP_KT _ARG TP_VT>), noRemResize);
   IPTR(self->impl, HashMap)->noRemResize = (C(bool))v;
   return v;
}

/*regSet*/template <typename TP_KT = int64 _ARG typename TP_VT = uintptr> inline typename THashMap<TP_KT _ARG TP_VT>::noRemResize_Prop & THashMap<TP_KT _ARG TP_VT>::noRemResize_Prop::operator= (THashMap<TP_KT _ARG TP_VT>::noRemResize_Prop & prop)
{
   TSELF(HashMap, (<TP_KT _ARG TP_VT>), noRemResize);
   /*0H*/bool v = prop;
   IPTR(self->impl, HashMap)->noRemResize = (C(bool))v;
   return prop;
}
/*regGet*/template <typename TP_KT = int64 _ARG typename TP_VT = uintptr> inline THashMap<TP_KT _ARG TP_VT> ::noRemResize_Prop::operator /*0I*/bool () const
{
   TSELF(HashMap, (<TP_KT _ARG TP_VT>), noRemResize);
   return self ? (bool)IPTR(self->impl, HashMap)->noRemResize : (bool)0;
}



// property callers: HashMapIterator::map
// (struct::normal)

/*nstSet*/template <typename TP_KT _ARG typename TP_VT> inline /*0A*/const THashMap<TP_KT, TP_VT> & THashMapIterator<TP_KT _ARG TP_VT> ::map_Prop::operator= (/*0A*/const THashMap<TP_KT, TP_VT> & v)
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), map);
   HashMapIterator_set_map(self ? &self->impl : null, ((Instance *)&v)->impl);
   return v;
}

/*regSet*/template <typename TP_KT _ARG typename TP_VT> inline typename THashMapIterator<TP_KT _ARG TP_VT>::map_Prop & THashMapIterator<TP_KT _ARG TP_VT>::map_Prop::operator= (THashMapIterator<TP_KT _ARG TP_VT>::map_Prop & prop)
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), map);
   /*0A*/const THashMap<TP_KT, TP_VT> & v = prop;
   HashMapIterator_set_map(self ? &self->impl : null, ((Instance *)&v)->impl);
   return prop;
}
/*nstSet*/template <typename TP_KT _ARG typename TP_VT> inline /*0C*/const THashMap<TP_KT, TP_VT> * THashMapIterator<TP_KT _ARG TP_VT> ::map_Prop::operator= (/*0C*/const THashMap<TP_KT, TP_VT> * v)
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), map);
   HashMapIterator_set_map(self ? &self->impl : null, v ? ((Instance *)v)->impl : null);
   return v;
}

/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline THashMapIterator<TP_KT _ARG TP_VT> ::map_Prop::operator /*0B*/TIH<THashMap<TP_KT, TP_VT>> () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), map);
   C(Instance) i = HashMapIterator_get_map(self ? &self->impl : null);
   TIH<THashMap<TP_KT, TP_VT>> cppi(i);
   return *cppi;
}
/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline TIH<THashMap<TP_KT, TP_VT>> THashMapIterator<TP_KT _ARG TP_VT> ::map_Prop::operator /*0D*/-> () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), map);
   C(Instance) i = HashMapIterator_get_map(self ? &self->impl : null);
   TIH<THashMap<TP_KT, TP_VT>> holder(i);
   return holder;
}
/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline THashMapIterator<TP_KT _ARG TP_VT> ::map_Prop::operator /*0E*/THashMap<TP_KT, TP_VT> () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), map);
   C(Instance) i = HashMapIterator_get_map(self ? &self->impl : null);
   return THashMap<TP_KT, TP_VT>(i);
}
/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline THashMapIterator<TP_KT _ARG TP_VT> ::map_Prop::operator /*0F*/THashMap<TP_KT, TP_VT>* () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), map);
   C(Instance) i = HashMapIterator_get_map(self ? &self->impl : null);
   return BINDINGS_CLASS(i) ? (THashMap<TP_KT, TP_VT> *)INSTANCEL(i, i->_class) : (THashMap<TP_KT, TP_VT> *)0;
}

// property callers: HashMapIterator::key   // get only
// (struct::const KT)

/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline THashMapIterator<TP_KT _ARG TP_VT> ::key_Prop::operator /*0B*/TIH<TP_KT> () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), key);
   return *TIH<TP_KT>(fromTA<C(Instance)>(HashMapIterator_get_key(self ? &self->impl : null)));
}
/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline TIH<TP_KT> THashMapIterator<TP_KT _ARG TP_VT> ::key_Prop::operator /*0D*/-> () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), key);
   return TIH<TP_KT>(fromTA<C(Instance)>(HashMapIterator_get_key(self ? &self->impl : null)));
}
/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline THashMapIterator<TP_KT _ARG TP_VT> ::key_Prop::operator /*0E*/TP_KT () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), key);
   return fromTA<TP_KT>(HashMapIterator_get_key(self ? &self->impl : null));
}
/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline THashMapIterator<TP_KT _ARG TP_VT> ::key_Prop::operator /*0F*/TP_KT* () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), key);
   return fromTA<TP_KT *>(HashMapIterator_get_key(self ? &self->impl : null));
}

// property callers: HashMapIterator::value
// (struct::VT)

/*nstSet*/template <typename TP_KT _ARG typename TP_VT> inline /*0A*/const TP_VT & THashMapIterator<TP_KT _ARG TP_VT> ::value_Prop::operator= (/*0A*/const TP_VT & v)
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), value);
   HashMapIterator_set_value(self ? &self->impl : null, toTA(v));
   return v;
}

/*regSet*/template <typename TP_KT _ARG typename TP_VT> inline typename THashMapIterator<TP_KT _ARG TP_VT>::value_Prop & THashMapIterator<TP_KT _ARG TP_VT>::value_Prop::operator= (THashMapIterator<TP_KT _ARG TP_VT>::value_Prop & prop)
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), value);
   /*0A*/const TP_VT & v = prop;
   HashMapIterator_set_value(self ? &self->impl : null, toTA(v));
   return prop;
}
/*nstSet*/template <typename TP_KT _ARG typename TP_VT> inline /*0C*/const TP_VT * THashMapIterator<TP_KT _ARG TP_VT> ::value_Prop::operator= (/*0C*/const TP_VT * v)
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), value);
   HashMapIterator_set_value(self ? &self->impl : null, toTA(v));
   return v;
}

/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline THashMapIterator<TP_KT _ARG TP_VT> ::value_Prop::operator /*0B*/TIH<TP_VT> () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), value);
   return *TIH<TP_VT>(fromTA<C(Instance)>(HashMapIterator_get_value(self ? &self->impl : null)));
}
/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline TIH<TP_VT> THashMapIterator<TP_KT _ARG TP_VT> ::value_Prop::operator /*0D*/-> () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), value);
   return TIH<TP_VT>(fromTA<C(Instance)>(HashMapIterator_get_value(self ? &self->impl : null)));
}
/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline THashMapIterator<TP_KT _ARG TP_VT> ::value_Prop::operator /*0E*/TP_VT () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), value);
   return fromTA<TP_VT>(HashMapIterator_get_value(self ? &self->impl : null));
}
/*regGet*/template <typename TP_KT _ARG typename TP_VT> inline THashMapIterator<TP_KT _ARG TP_VT> ::value_Prop::operator /*0F*/TP_VT* () const
{
   TSELF(HashMapIterator, (<TP_KT _ARG TP_VT>), value);
   return fromTA<TP_VT *>(HashMapIterator_get_value(self ? &self->impl : null));
}

template <typename TP_KT> TCPPClass<THashTable<TP_KT>> THashTable<TP_KT>::_cpp_class;

template <typename TP_KT> void THashTable<TP_KT>::class_registration(CPPClass & _cpp_class)
{
}


// property callers: HashTable::initSize   // set only
// (normal::int)

/*nstSet*/template <typename TP_KT = int64> inline /*0G*/int THashTable<TP_KT> ::initSize_Prop::operator= (/*0G*/int v)
{
   TSELF(HashTable, (<TP_KT>), initSize);
   HashTable_set_initSize(self->impl, v);
   return v;
}



template <class TC, C(Class) ** TCO> inline void TItem<TC, TCO>::copy(/*1Ab*/TItem<TC, TCO> src, /*1Ab*/int size)
{
   Item_copy((C(Item)*)this->impl, /*5De*/src.impl, /*5Ge*/size);
}


// member accessors: Item::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Item TItem<TC, TCO>::prev_Prop::operator= (/*0H*/Item & v)
{
   SELF(Item, prev);
   ((C(Item) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TItem<TC, TCO>::prev_Prop & TItem<TC, TCO>::prev_Prop::operator= (typename TItem<TC, TCO>::prev_Prop & prop)
{
   SELF(Item, prev);
   /*0H*/Item v = prop;
   ((C(Item) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TItem<TC, TCO>::prev_Prop::operator /*0I*/Item () const
{
   __attribute__((unused)) TItem TCTCO * self = CONTAINER_OF(this, TItem TCTCO, prev);
   Item value(((C(Item) *)self->impl)->prev);
   return value;
}

// member accessors: Item::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/Item TItem<TC, TCO>::next_Prop::operator= (/*0H*/Item & v)
{
   SELF(Item, next);
   ((C(Item) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TItem<TC, TCO>::next_Prop & TItem<TC, TCO>::next_Prop::operator= (typename TItem<TC, TCO>::next_Prop & prop)
{
   SELF(Item, next);
   /*0H*/Item v = prop;
   ((C(Item) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TItem<TC, TCO>::next_Prop::operator /*0I*/Item () const
{
   __attribute__((unused)) TItem TCTCO * self = CONTAINER_OF(this, TItem TCTCO, next);
   Item value(((C(Item) *)self->impl)->next);
   return value;
}


template <typename TP_T, typename TP_IT> inline void TIterator<TP_T, TP_IT>::free()
{
   Iterator_free(&impl);
}
template <typename TP_T, typename TP_IT> inline TP_T TIterator<TP_T, TP_IT>::getData()
{
   return fromTA<TP_T>(Iterator_getData(&impl));
}
template <typename TP_T, typename TP_IT> inline C(bool) TIterator<TP_T, TP_IT>::next()
{
   return Iterator_next(&impl);
}
template <typename TP_T, typename TP_IT> inline C(bool) TIterator<TP_T, TP_IT>::prev()
{
   return Iterator_prev(&impl);
}
template <typename TP_T, typename TP_IT> inline void TIterator<TP_T, TP_IT>::remove()
{
   Iterator_remove(&impl);
}

template <typename TP_T, typename TP_IT> inline C(bool) TIterator<TP_T, TP_IT>::index(TP_IT index, C(bool) create)
{
   return Iterator_index(&impl, toTA(index), create);
}

// property callers: Iterator::data
// (struct::T)

/*nstSet*/template <typename TP_T _ARG typename TP_IT = int> inline /*0A*/const TP_T & TIterator<TP_T _ARG TP_IT> ::data_Prop::operator= (/*0A*/const TP_T & v)
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), data);
   Iterator_set_data(self ? &self->impl : null, toTA(v));
   return v;
}

/*regSet*/template <typename TP_T _ARG typename TP_IT = int> inline typename TIterator<TP_T _ARG TP_IT>::data_Prop & TIterator<TP_T _ARG TP_IT>::data_Prop::operator= (TIterator<TP_T _ARG TP_IT>::data_Prop & prop)
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), data);
   /*0A*/const TP_T & v = prop;
   Iterator_set_data(self ? &self->impl : null, toTA(v));
   return prop;
}
/*nstSet*/template <typename TP_T _ARG typename TP_IT = int> inline /*0C*/const TP_T * TIterator<TP_T _ARG TP_IT> ::data_Prop::operator= (/*0C*/const TP_T * v)
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), data);
   Iterator_set_data(self ? &self->impl : null, toTA(v));
   return v;
}

/*regGet*/template <typename TP_T _ARG typename TP_IT = int> inline TIterator<TP_T _ARG TP_IT> ::data_Prop::operator /*0B*/TIH<TP_T> () const
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), data);
   return *TIH<TP_T>(fromTA<C(Instance)>(Iterator_get_data(self ? &self->impl : null)));
}
/*regGet*/template <typename TP_T _ARG typename TP_IT = int> inline TIH<TP_T> TIterator<TP_T _ARG TP_IT> ::data_Prop::operator /*0D*/-> () const
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), data);
   return TIH<TP_T>(fromTA<C(Instance)>(Iterator_get_data(self ? &self->impl : null)));
}
/*regGet*/template <typename TP_T _ARG typename TP_IT = int> inline TIterator<TP_T _ARG TP_IT> ::data_Prop::operator /*0E*/TP_T () const
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), data);
   return fromTA<TP_T>(Iterator_get_data(self ? &self->impl : null));
}
/*regGet*/template <typename TP_T _ARG typename TP_IT = int> inline TIterator<TP_T _ARG TP_IT> ::data_Prop::operator /*0F*/TP_T* () const
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), data);
   return fromTA<TP_T *>(Iterator_get_data(self ? &self->impl : null));
}


// member accessors: Iterator::container
// (struct::normal)

/*nstSet*/template <typename TP_T _ARG typename TP_IT = int> inline /*0H*/TContainer<TP_T, TP_IT> TIterator<TP_T _ARG TP_IT> ::container_Prop::operator= (/*0H*/TContainer<TP_T, TP_IT> v)
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), container);
   self->impl.container = ((Instance *)&v)->impl;
   return v;
}

/*regSet*/template <typename TP_T _ARG typename TP_IT = int> inline typename TIterator<TP_T _ARG TP_IT>::container_Prop & TIterator<TP_T _ARG TP_IT>::container_Prop::operator= (TIterator<TP_T _ARG TP_IT>::container_Prop & prop)
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), container);
   /*0H*/TContainer<TP_T, TP_IT> v = prop;
   self->impl.container = ((Instance *)&v)->impl;
   return prop;
}
/*regGet*/template <typename TP_T _ARG typename TP_IT = int> inline TIterator<TP_T _ARG TP_IT> ::container_Prop::operator /*0I*/TContainer<TP_T, TP_IT> () const
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), container);
   TContainer<TP_T, TP_IT> value(((C(Iterator) *)&self->impl)->container);
   return value;
}

// member accessors: Iterator::pointer
// (struct::nohead)

/*nstSet*/template <typename TP_T _ARG typename TP_IT = int> inline /*0H*/IteratorPointer TIterator<TP_T _ARG TP_IT> ::pointer_Prop::operator= (/*0H*/IteratorPointer & v)
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), pointer);
   self->impl.pointer = v.impl;
   return v;
}

/*regSet*/template <typename TP_T _ARG typename TP_IT = int> inline typename TIterator<TP_T _ARG TP_IT>::pointer_Prop & TIterator<TP_T _ARG TP_IT>::pointer_Prop::operator= (TIterator<TP_T _ARG TP_IT>::pointer_Prop & prop)
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), pointer);
   /*0H*/IteratorPointer v = prop;
   self->impl.pointer = v.impl;
   return prop;
}
/*regGet*/template <typename TP_T _ARG typename TP_IT = int> inline TIterator<TP_T _ARG TP_IT> ::pointer_Prop::operator /*0I*/IteratorPointer () const
{
   TSELF(Iterator, (<TP_T _ARG TP_IT>), pointer);
   IteratorPointer value(((C(Iterator) *)&self->impl)->pointer);
   return value;
}




// member accessors: Link::data
// (nohead::uint64)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/uint64 TLink<TC, TCO>::data_Prop::operator= (/*0H*/uint64 v)
{
   SELF(Link, data);
   ((C(Link) *)self->impl)->data = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TLink<TC, TCO>::data_Prop & TLink<TC, TCO>::data_Prop::operator= (typename TLink<TC, TCO>::data_Prop & prop)
{
   SELF(Link, data);
   /*0H*/uint64 v = prop;
   ((C(Link) *)self->impl)->data = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TLink<TC, TCO>::data_Prop::operator /*0I*/uint64 () const
{
   __attribute__((unused)) TLink TCTCO * self = CONTAINER_OF(this, TLink TCTCO, data);
   return self ? ((C(Link) *)self->impl)->data : 0;
}



// member accessors: LinkElement::prev
// (struct::T)

/*nstSet*/template <typename TP_T> inline /*0H*/TP_T TLinkElement<TP_T> ::prev_Prop::operator= (/*0H*/TP_T v)
{
   TSELF(LinkElement, (<TP_T>), prev);
   self->impl.prev = v;
   return v;
}

/*regSet*/template <typename TP_T> inline typename TLinkElement<TP_T>::prev_Prop & TLinkElement<TP_T>::prev_Prop::operator= (TLinkElement<TP_T>::prev_Prop & prop)
{
   TSELF(LinkElement, (<TP_T>), prev);
   /*0H*/TP_T v = prop;
   self->impl.prev = v;
   return prop;
}
/*regGet*/template <typename TP_T> inline TLinkElement<TP_T> ::prev_Prop::operator /*0I*/TP_T () const
{
   TSELF(LinkElement, (<TP_T>), prev);
   return self ? ((C(LinkElement) *)&self->impl)->prev : 0;
}

// member accessors: LinkElement::next
// (struct::T)

/*nstSet*/template <typename TP_T> inline /*0H*/TP_T TLinkElement<TP_T> ::next_Prop::operator= (/*0H*/TP_T v)
{
   TSELF(LinkElement, (<TP_T>), next);
   self->impl.next = v;
   return v;
}

/*regSet*/template <typename TP_T> inline typename TLinkElement<TP_T>::next_Prop & TLinkElement<TP_T>::next_Prop::operator= (TLinkElement<TP_T>::next_Prop & prop)
{
   TSELF(LinkElement, (<TP_T>), next);
   /*0H*/TP_T v = prop;
   self->impl.next = v;
   return prop;
}
/*regGet*/template <typename TP_T> inline TLinkElement<TP_T> ::next_Prop::operator /*0I*/TP_T () const
{
   TSELF(LinkElement, (<TP_T>), next);
   return self ? ((C(LinkElement) *)&self->impl)->next : 0;
}

template <typename TP_LT> TCPPClass<TLinkList<TP_LT>> TLinkList<TP_LT>::_cpp_class;

template <typename TP_LT> void TLinkList<TP_LT>::class_registration(CPPClass & _cpp_class)
{
}


// member accessors: LinkList::first
// (normal::LT)

/*nstSet*/template <typename TP_LT = ListItem> inline /*0H*/TP_LT TLinkList<TP_LT> ::first_Prop::operator= (/*0H*/TP_LT v)
{
   TSELF(LinkList, (<TP_LT>), first);
   IPTR(self->impl, LinkList)->first = v;
   return v;
}

/*regSet*/template <typename TP_LT = ListItem> inline typename TLinkList<TP_LT>::first_Prop & TLinkList<TP_LT>::first_Prop::operator= (TLinkList<TP_LT>::first_Prop & prop)
{
   TSELF(LinkList, (<TP_LT>), first);
   /*0H*/TP_LT v = prop;
   IPTR(self->impl, LinkList)->first = v;
   return prop;
}
/*regGet*/template <typename TP_LT = ListItem> inline TLinkList<TP_LT> ::first_Prop::operator /*0I*/TP_LT () const
{
   TSELF(LinkList, (<TP_LT>), first);
   return self ? IPTR(self->impl, LinkList)->first : 0;
}

// member accessors: LinkList::last
// (normal::LT)

/*nstSet*/template <typename TP_LT = ListItem> inline /*0H*/TP_LT TLinkList<TP_LT> ::last_Prop::operator= (/*0H*/TP_LT v)
{
   TSELF(LinkList, (<TP_LT>), last);
   IPTR(self->impl, LinkList)->last = v;
   return v;
}

/*regSet*/template <typename TP_LT = ListItem> inline typename TLinkList<TP_LT>::last_Prop & TLinkList<TP_LT>::last_Prop::operator= (TLinkList<TP_LT>::last_Prop & prop)
{
   TSELF(LinkList, (<TP_LT>), last);
   /*0H*/TP_LT v = prop;
   IPTR(self->impl, LinkList)->last = v;
   return prop;
}
/*regGet*/template <typename TP_LT = ListItem> inline TLinkList<TP_LT> ::last_Prop::operator /*0I*/TP_LT () const
{
   TSELF(LinkList, (<TP_LT>), last);
   return self ? IPTR(self->impl, LinkList)->last : 0;
}

// member accessors: LinkList::count
// (normal::int)

/*nstSet*/template <typename TP_LT = ListItem> inline /*0H*/int TLinkList<TP_LT> ::count_Prop::operator= (/*0H*/int v)
{
   TSELF(LinkList, (<TP_LT>), count);
   IPTR(self->impl, LinkList)->count = v;
   return v;
}

/*regSet*/template <typename TP_LT = ListItem> inline typename TLinkList<TP_LT>::count_Prop & TLinkList<TP_LT>::count_Prop::operator= (TLinkList<TP_LT>::count_Prop & prop)
{
   TSELF(LinkList, (<TP_LT>), count);
   /*0H*/int v = prop;
   IPTR(self->impl, LinkList)->count = v;
   return prop;
}
/*regGet*/template <typename TP_LT = ListItem> inline TLinkList<TP_LT> ::count_Prop::operator /*0I*/int () const
{
   TSELF(LinkList, (<TP_LT>), count);
   return self ? IPTR(self->impl, LinkList)->count : 0;
}

template <typename TP_LLT> TCPPClass<TList<TP_LLT>> TList<TP_LLT>::_cpp_class;

template <typename TP_LLT> void TList<TP_LLT>::class_registration(CPPClass & _cpp_class)
{
}



// member accessors: ListItem::link
// (nohead::struct)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0Z*/const LinkElement & TListItem<TC, TCO>::link_Prop::operator= (/*0Z*/const LinkElement & v)
{
   SELF(ListItem, link);
   ((C(ListItem) *)self->impl)->link = ((TLinkElement<ListItem> *)&v)->impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TListItem<TC, TCO>::link_Prop & TListItem<TC, TCO>::link_Prop::operator= (typename TListItem<TC, TCO>::link_Prop & prop)
{
   SELF(ListItem, link);
   /*0H*/TLinkElement<ListItem> & v = prop;
   ((C(ListItem) *)self->impl)->link = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TListItem<TC, TCO>::link_Prop::operator /*0I*/LinkElement & () const
{
   __attribute__((unused)) TListItem TCTCO * self = CONTAINER_OF(this, TListItem TCTCO, link);
   LinkElement value(((C(ListItem) *)self->impl)->link);
   return value;
}

// member accessors: ListItem::prev
// (nohead::thisclass)

// REVIEW: These C(Class) do not look right here -- is this the base object?
/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/C(Class) * TListItem<TC, TCO>::prev_Prop::operator= (/*0H*/C(Class) * v)
{
   SELF(ListItem, prev);
   ((C(ListItem) *)self->impl)->prev = (C(ListItem) *)v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TListItem<TC, TCO>::prev_Prop & TListItem<TC, TCO>::prev_Prop::operator= (typename TListItem<TC, TCO>::prev_Prop & prop)
{
   SELF(ListItem, prev);
   /*0H*/C(Class) * v = prop;
   ((C(ListItem) *)self->impl)->prev = (C(ListItem) *)v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TListItem<TC, TCO>::prev_Prop::operator /*0I*/C(Class) * () const
{
   __attribute__((unused)) TListItem TCTCO * self = CONTAINER_OF(this, TListItem TCTCO, prev);
   return self ? ((C(ListItem) *)self->impl)->prev : 0;
}

// member accessors: ListItem::next
// (nohead::thisclass)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/C(Class) * TListItem<TC, TCO>::next_Prop::operator= (/*0H*/C(Class) * v)
{
   SELF(ListItem, next);
   ((C(ListItem) *)self->impl)->next = (C(ListItem) *)v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TListItem<TC, TCO>::next_Prop & TListItem<TC, TCO>::next_Prop::operator= (typename TListItem<TC, TCO>::next_Prop & prop)
{
   SELF(ListItem, next);
   /*0H*/C(Class) * v = prop;
   ((C(ListItem) *)self->impl)->next = (C(ListItem) *)v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TListItem<TC, TCO>::next_Prop::operator /*0I*/C(Class) * () const
{
   __attribute__((unused)) TListItem TCTCO * self = CONTAINER_OF(this, TListItem TCTCO, next);
   return self ? ((C(ListItem) *)self->impl)->next : 0;
}

template <typename TP_MT, typename TP_V> TCPPClass<TMap<TP_MT, TP_V>> TMap<TP_MT, TP_V>::_cpp_class;

template <typename TP_MT, typename TP_V> void TMap<TP_MT, TP_V>::class_registration(CPPClass & _cpp_class)
{
}


// property callers: Map::mapSrc   // set only
// (normal::normal)

/*nstSet*/template <typename TP_MT _ARG typename TP_V> inline /*0A*/const Map & TMap<TP_MT _ARG TP_V> ::mapSrc_Prop::operator= (/*0A*/const Map & v)
{
   TSELF(Map, (<TP_MT _ARG TP_V>), mapSrc);
   Map_set_mapSrc(self ? self->impl : null, ((Instance *)&v)->impl);
   return v;
}

/*nstSet*/template <typename TP_MT _ARG typename TP_V> inline /*0C*/const Map * TMap<TP_MT _ARG TP_V> ::mapSrc_Prop::operator= (/*0C*/const Map * v)
{
   TSELF(Map, (<TP_MT _ARG TP_V>), mapSrc);
   Map_set_mapSrc(self ? self->impl : null, v ? ((Instance *)v)->impl : null);
   return v;
}


template <typename TP_KT, typename TP_KV> inline C(bool) TMapIterator<TP_KT, TP_KV>::index(TP_KT index, C(bool) create)
{
   return Iterator_index((C(Iterator) *)&impl, toTA(index), create);
}


// property callers: MapIterator::map
// (struct::normal)

/*nstSet*/template <typename TP_KT _ARG typename TP_V> inline /*0A*/const TMap<TP_KT, TP_V> & TMapIterator<TP_KT _ARG TP_V> ::map_Prop::operator= (/*0A*/const TMap<TP_KT, TP_V> & v)
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), map);
   MapIterator_set_map(self ? &self->impl : null, ((Instance *)&v)->impl);
   return v;
}

/*regSet*/template <typename TP_KT _ARG typename TP_V> inline typename TMapIterator<TP_KT _ARG TP_V>::map_Prop & TMapIterator<TP_KT _ARG TP_V>::map_Prop::operator= (TMapIterator<TP_KT _ARG TP_V>::map_Prop & prop)
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), map);
   /*0A*/const TMap<TP_KT, TP_V> & v = prop;
   MapIterator_set_map(self ? &self->impl : null, ((Instance *)&v)->impl);
   return prop;
}
/*nstSet*/template <typename TP_KT _ARG typename TP_V> inline /*0C*/const TMap<TP_KT, TP_V> * TMapIterator<TP_KT _ARG TP_V> ::map_Prop::operator= (/*0C*/const TMap<TP_KT, TP_V> * v)
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), map);
   MapIterator_set_map(self ? &self->impl : null, v ? ((Instance *)v)->impl : null);
   return v;
}

/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TMapIterator<TP_KT _ARG TP_V> ::map_Prop::operator /*0B*/TIH<TMap<TP_KT, TP_V>> () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), map);
   C(Instance) i = MapIterator_get_map(self ? &self->impl : null);
   TIH<TMap<TP_KT, TP_V>> cppi(i);
   return *cppi;
}
/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TIH<TMap<TP_KT, TP_V>> TMapIterator<TP_KT _ARG TP_V> ::map_Prop::operator /*0D*/-> () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), map);
   C(Instance) i = MapIterator_get_map(self ? &self->impl : null);
   TIH<TMap<TP_KT, TP_V>> holder(i);
   return holder;
}
/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TMapIterator<TP_KT _ARG TP_V> ::map_Prop::operator /*0E*/TMap<TP_KT, TP_V> () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), map);
   C(Instance) i = MapIterator_get_map(self ? &self->impl : null);
   return TMap<TP_KT, TP_V>(i);
}
/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TMapIterator<TP_KT _ARG TP_V> ::map_Prop::operator /*0F*/TMap<TP_KT, TP_V>* () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), map);
   C(Instance) i = MapIterator_get_map(self ? &self->impl : null);
   return BINDINGS_CLASS(i) ? (TMap<TP_KT, TP_V> *)INSTANCEL(i, i->_class) : (TMap<TP_KT, TP_V> *)0;
}

// property callers: MapIterator::key   // get only
// (struct::const KT)

/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TMapIterator<TP_KT _ARG TP_V> ::key_Prop::operator /*0B*/TIH<TP_KT> () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), key);
   return *TIH<TP_KT>(fromTA<C(Instance)>(MapIterator_get_key(self ? &self->impl : null)));
}
/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TIH<TP_KT> TMapIterator<TP_KT _ARG TP_V> ::key_Prop::operator /*0D*/-> () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), key);
   return TIH<TP_KT>(fromTA<C(Instance)>(MapIterator_get_key(self ? &self->impl : null)));
}
/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TMapIterator<TP_KT _ARG TP_V> ::key_Prop::operator /*0E*/TP_KT () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), key);
   return fromTA<TP_KT>(MapIterator_get_key(self ? &self->impl : null));
}
/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TMapIterator<TP_KT _ARG TP_V> ::key_Prop::operator /*0F*/TP_KT* () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), key);
   return fromTA<TP_KT *>(MapIterator_get_key(self ? &self->impl : null));
}

// property callers: MapIterator::value
// (struct::V)

/*nstSet*/template <typename TP_KT _ARG typename TP_V> inline /*0A*/const TP_V & TMapIterator<TP_KT _ARG TP_V> ::value_Prop::operator= (/*0A*/const TP_V & v)
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), value);
   MapIterator_set_value(self ? &self->impl : null, toTA(v));
   return v;
}

/*regSet*/template <typename TP_KT _ARG typename TP_V> inline typename TMapIterator<TP_KT _ARG TP_V>::value_Prop & TMapIterator<TP_KT _ARG TP_V>::value_Prop::operator= (TMapIterator<TP_KT _ARG TP_V>::value_Prop & prop)
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), value);
   /*0A*/const TP_V & v = prop;
   MapIterator_set_value(self ? &self->impl : null, toTA(v));
   return prop;
}
/*nstSet*/template <typename TP_KT _ARG typename TP_V> inline /*0C*/const TP_V * TMapIterator<TP_KT _ARG TP_V> ::value_Prop::operator= (/*0C*/const TP_V * v)
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), value);
   MapIterator_set_value(self ? &self->impl : null, toTA(v));
   return v;
}

/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TMapIterator<TP_KT _ARG TP_V> ::value_Prop::operator /*0B*/TIH<TP_V> () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), value);
   return *TIH<TP_V>(fromTA<C(Instance)>(MapIterator_get_value(self ? &self->impl : null)));
}
/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TIH<TP_V> TMapIterator<TP_KT _ARG TP_V> ::value_Prop::operator /*0D*/-> () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), value);
   return TIH<TP_V>(fromTA<C(Instance)>(MapIterator_get_value(self ? &self->impl : null)));
}
/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TMapIterator<TP_KT _ARG TP_V> ::value_Prop::operator /*0E*/TP_V () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), value);
   return fromTA<TP_V>(MapIterator_get_value(self ? &self->impl : null));
}
/*regGet*/template <typename TP_KT _ARG typename TP_V> inline TMapIterator<TP_KT _ARG TP_V> ::value_Prop::operator /*0F*/TP_V* () const
{
   TSELF(MapIterator, (<TP_KT _ARG TP_V>), value);
   return fromTA<TP_V *>(MapIterator_get_value(self ? &self->impl : null));
}



// member accessors: NamedItem::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/NamedItem TNamedItem<TC, TCO>::prev_Prop::operator= (/*0H*/NamedItem & v)
{
   SELF(NamedItem, prev);
   ((C(NamedItem) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TNamedItem<TC, TCO>::prev_Prop & TNamedItem<TC, TCO>::prev_Prop::operator= (typename TNamedItem<TC, TCO>::prev_Prop & prop)
{
   SELF(NamedItem, prev);
   /*0H*/NamedItem v = prop;
   ((C(NamedItem) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TNamedItem<TC, TCO>::prev_Prop::operator /*0I*/NamedItem () const
{
   __attribute__((unused)) TNamedItem TCTCO * self = CONTAINER_OF(this, TNamedItem TCTCO, prev);
   NamedItem value(((C(NamedItem) *)self->impl)->prev);
   return value;
}

// member accessors: NamedItem::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/NamedItem TNamedItem<TC, TCO>::next_Prop::operator= (/*0H*/NamedItem & v)
{
   SELF(NamedItem, next);
   ((C(NamedItem) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TNamedItem<TC, TCO>::next_Prop & TNamedItem<TC, TCO>::next_Prop::operator= (typename TNamedItem<TC, TCO>::next_Prop & prop)
{
   SELF(NamedItem, next);
   /*0H*/NamedItem v = prop;
   ((C(NamedItem) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TNamedItem<TC, TCO>::next_Prop::operator /*0I*/NamedItem () const
{
   __attribute__((unused)) TNamedItem TCTCO * self = CONTAINER_OF(this, TNamedItem TCTCO, next);
   NamedItem value(((C(NamedItem) *)self->impl)->next);
   return value;
}

// member accessors: NamedItem::name
// (nohead::char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/char * TNamedItem<TC, TCO>::name_Prop::operator= (/*0H*/char * v)
{
   SELF(NamedItem, name);
   ((C(NamedItem) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TNamedItem<TC, TCO>::name_Prop & TNamedItem<TC, TCO>::name_Prop::operator= (typename TNamedItem<TC, TCO>::name_Prop & prop)
{
   SELF(NamedItem, name);
   /*0H*/char * v = prop;
   ((C(NamedItem) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TNamedItem<TC, TCO>::name_Prop::operator /*0I*/char * () const
{
   __attribute__((unused)) TNamedItem TCTCO * self = CONTAINER_OF(this, TNamedItem TCTCO, name);
   return self ? ((C(NamedItem) *)self->impl)->name : null;
}



// member accessors: NamedLink::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/NamedLink TNamedLink<TC, TCO>::prev_Prop::operator= (/*0H*/NamedLink & v)
{
   SELF(NamedLink, prev);
   ((C(NamedLink) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TNamedLink<TC, TCO>::prev_Prop & TNamedLink<TC, TCO>::prev_Prop::operator= (typename TNamedLink<TC, TCO>::prev_Prop & prop)
{
   SELF(NamedLink, prev);
   /*0H*/NamedLink v = prop;
   ((C(NamedLink) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TNamedLink<TC, TCO>::prev_Prop::operator /*0I*/NamedLink () const
{
   __attribute__((unused)) TNamedLink TCTCO * self = CONTAINER_OF(this, TNamedLink TCTCO, prev);
   NamedLink value(((C(NamedLink) *)self->impl)->prev);
   return value;
}

// member accessors: NamedLink::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/NamedLink TNamedLink<TC, TCO>::next_Prop::operator= (/*0H*/NamedLink & v)
{
   SELF(NamedLink, next);
   ((C(NamedLink) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TNamedLink<TC, TCO>::next_Prop & TNamedLink<TC, TCO>::next_Prop::operator= (typename TNamedLink<TC, TCO>::next_Prop & prop)
{
   SELF(NamedLink, next);
   /*0H*/NamedLink v = prop;
   ((C(NamedLink) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TNamedLink<TC, TCO>::next_Prop::operator /*0I*/NamedLink () const
{
   __attribute__((unused)) TNamedLink TCTCO * self = CONTAINER_OF(this, TNamedLink TCTCO, next);
   NamedLink value(((C(NamedLink) *)self->impl)->next);
   return value;
}

// member accessors: NamedLink::name
// (nohead::char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/char * TNamedLink<TC, TCO>::name_Prop::operator= (/*0H*/char * v)
{
   SELF(NamedLink, name);
   ((C(NamedLink) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TNamedLink<TC, TCO>::name_Prop & TNamedLink<TC, TCO>::name_Prop::operator= (typename TNamedLink<TC, TCO>::name_Prop & prop)
{
   SELF(NamedLink, name);
   /*0H*/char * v = prop;
   ((C(NamedLink) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TNamedLink<TC, TCO>::name_Prop::operator /*0I*/char * () const
{
   __attribute__((unused)) TNamedLink TCTCO * self = CONTAINER_OF(this, TNamedLink TCTCO, name);
   return self ? ((C(NamedLink) *)self->impl)->name : null;
}

// member accessors: NamedLink::data
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TNamedLink<TC, TCO>::data_Prop::operator= (/*0H*/void * v)
{
   SELF(NamedLink, data);
   ((C(NamedLink) *)self->impl)->data = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TNamedLink<TC, TCO>::data_Prop & TNamedLink<TC, TCO>::data_Prop::operator= (typename TNamedLink<TC, TCO>::data_Prop & prop)
{
   SELF(NamedLink, data);
   /*0H*/void * v = prop;
   ((C(NamedLink) *)self->impl)->data = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TNamedLink<TC, TCO>::data_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TNamedLink TCTCO * self = CONTAINER_OF(this, TNamedLink TCTCO, data);
   return self ? ((C(NamedLink) *)self->impl)->data : null;
}



// member accessors: NamedLink64::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/NamedLink64 TNamedLink64<TC, TCO>::prev_Prop::operator= (/*0H*/NamedLink64 & v)
{
   SELF(NamedLink64, prev);
   ((C(NamedLink64) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TNamedLink64<TC, TCO>::prev_Prop & TNamedLink64<TC, TCO>::prev_Prop::operator= (typename TNamedLink64<TC, TCO>::prev_Prop & prop)
{
   SELF(NamedLink64, prev);
   /*0H*/NamedLink64 v = prop;
   ((C(NamedLink64) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TNamedLink64<TC, TCO>::prev_Prop::operator /*0I*/NamedLink64 () const
{
   __attribute__((unused)) TNamedLink64 TCTCO * self = CONTAINER_OF(this, TNamedLink64 TCTCO, prev);
   NamedLink64 value(((C(NamedLink64) *)self->impl)->prev);
   return value;
}

// member accessors: NamedLink64::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/NamedLink64 TNamedLink64<TC, TCO>::next_Prop::operator= (/*0H*/NamedLink64 & v)
{
   SELF(NamedLink64, next);
   ((C(NamedLink64) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TNamedLink64<TC, TCO>::next_Prop & TNamedLink64<TC, TCO>::next_Prop::operator= (typename TNamedLink64<TC, TCO>::next_Prop & prop)
{
   SELF(NamedLink64, next);
   /*0H*/NamedLink64 v = prop;
   ((C(NamedLink64) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TNamedLink64<TC, TCO>::next_Prop::operator /*0I*/NamedLink64 () const
{
   __attribute__((unused)) TNamedLink64 TCTCO * self = CONTAINER_OF(this, TNamedLink64 TCTCO, next);
   NamedLink64 value(((C(NamedLink64) *)self->impl)->next);
   return value;
}

// member accessors: NamedLink64::name
// (nohead::char *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/char * TNamedLink64<TC, TCO>::name_Prop::operator= (/*0H*/char * v)
{
   SELF(NamedLink64, name);
   ((C(NamedLink64) *)self->impl)->name = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TNamedLink64<TC, TCO>::name_Prop & TNamedLink64<TC, TCO>::name_Prop::operator= (typename TNamedLink64<TC, TCO>::name_Prop & prop)
{
   SELF(NamedLink64, name);
   /*0H*/char * v = prop;
   ((C(NamedLink64) *)self->impl)->name = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TNamedLink64<TC, TCO>::name_Prop::operator /*0I*/char * () const
{
   __attribute__((unused)) TNamedLink64 TCTCO * self = CONTAINER_OF(this, TNamedLink64 TCTCO, name);
   return self ? ((C(NamedLink64) *)self->impl)->name : null;
}

// member accessors: NamedLink64::data
// (nohead::int64)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int64 TNamedLink64<TC, TCO>::data_Prop::operator= (/*0H*/int64 v)
{
   SELF(NamedLink64, data);
   ((C(NamedLink64) *)self->impl)->data = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TNamedLink64<TC, TCO>::data_Prop & TNamedLink64<TC, TCO>::data_Prop::operator= (typename TNamedLink64<TC, TCO>::data_Prop & prop)
{
   SELF(NamedLink64, data);
   /*0H*/int64 v = prop;
   ((C(NamedLink64) *)self->impl)->data = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TNamedLink64<TC, TCO>::data_Prop::operator /*0I*/int64 () const
{
   __attribute__((unused)) TNamedLink64 TCTCO * self = CONTAINER_OF(this, TNamedLink64 TCTCO, data);
   return self ? ((C(NamedLink64) *)self->impl)->data : 0;
}


template <class TC, C(Class) ** TCO> inline void TOldLink<TC, TCO>::free()
{
   OldLink_free((C(OldLink)*)this->impl);
}


// member accessors: OldLink::prev
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldLink TOldLink<TC, TCO>::prev_Prop::operator= (/*0H*/OldLink & v)
{
   SELF(OldLink, prev);
   ((C(OldLink) *)self->impl)->prev = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TOldLink<TC, TCO>::prev_Prop & TOldLink<TC, TCO>::prev_Prop::operator= (typename TOldLink<TC, TCO>::prev_Prop & prop)
{
   SELF(OldLink, prev);
   /*0H*/OldLink v = prop;
   ((C(OldLink) *)self->impl)->prev = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TOldLink<TC, TCO>::prev_Prop::operator /*0I*/OldLink () const
{
   __attribute__((unused)) TOldLink TCTCO * self = CONTAINER_OF(this, TOldLink TCTCO, prev);
   OldLink value(((C(OldLink) *)self->impl)->prev);
   return value;
}

// member accessors: OldLink::next
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/OldLink TOldLink<TC, TCO>::next_Prop::operator= (/*0H*/OldLink & v)
{
   SELF(OldLink, next);
   ((C(OldLink) *)self->impl)->next = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TOldLink<TC, TCO>::next_Prop & TOldLink<TC, TCO>::next_Prop::operator= (typename TOldLink<TC, TCO>::next_Prop & prop)
{
   SELF(OldLink, next);
   /*0H*/OldLink v = prop;
   ((C(OldLink) *)self->impl)->next = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TOldLink<TC, TCO>::next_Prop::operator /*0I*/OldLink () const
{
   __attribute__((unused)) TOldLink TCTCO * self = CONTAINER_OF(this, TOldLink TCTCO, next);
   OldLink value(((C(OldLink) *)self->impl)->next);
   return value;
}

// member accessors: OldLink::data
// (nohead::void *)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/void * TOldLink<TC, TCO>::data_Prop::operator= (/*0H*/void * v)
{
   SELF(OldLink, data);
   ((C(OldLink) *)self->impl)->data = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TOldLink<TC, TCO>::data_Prop & TOldLink<TC, TCO>::data_Prop::operator= (typename TOldLink<TC, TCO>::data_Prop & prop)
{
   SELF(OldLink, data);
   /*0H*/void * v = prop;
   ((C(OldLink) *)self->impl)->data = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TOldLink<TC, TCO>::data_Prop::operator /*0I*/void * () const
{
   __attribute__((unused)) TOldLink TCTCO * self = CONTAINER_OF(this, TOldLink TCTCO, data);
   return self ? ((C(OldLink) *)self->impl)->data : null;
}

inline OldList::OldList(void * first, void * last = null, int count = 0, uint offset = 0, bool circ = (bool)0)
{
   impl.first = first;
   impl.last = last;
   impl.count = count;
   impl.offset = offset;
   impl.circ = (C(bool))circ;
}


inline void OldList::add(/*1Ab*/void * item)
{
   OldList_add(&impl, /*5Ge*/item);
}
inline C(bool) OldList::addName(/*1Ab*/void * item)
{
   return OldList_addName(&impl, /*5Ge*/item);
}
inline void OldList::clear()
{
   OldList_clear(&impl);
}
inline void OldList::copy(/*1Ab*/OldList & src, /*1Ab*/int size, void (* copy)(void * dest, void * src))
{
   OldList_copy(&impl, /*5De*/&src.impl, /*5Ge*/size, /*5Ge*/copy);
}
inline void OldList::copy(/*1Ac*/OldList * src, /*1Ac*/int size, void (* copy)(void * dest, void * src))
{
   OldList_copy(&impl, /*5Cf*/(C(OldList) *)src, /*5Gf*/size, /*5Gf*/copy);
}
inline void OldList::_delete(/*1Ab*/void * item)
{
   OldList_delete(&impl, /*5Ge*/item);
}
inline C(OldLink) * OldList::findLink(/*1Ab*/void * data)
{
   return OldList_findLink(&impl, /*5Ge*/data);
}
inline void * OldList::findName(/*1Ab*/const char * name, /*1Ab*/bool warn)
{
   return OldList_findName(&impl, /*5Ge*/name, /*5Ee*/(C(bool))warn);
}
inline void * OldList::findNamedLink(/*1Ab*/const char * name, /*1Ab*/bool warn)
{
   return OldList_findNamedLink(&impl, /*5Ge*/name, /*5Ee*/(C(bool))warn);
}
inline void OldList::free(void (* freeFn)(void *))
{
   OldList_free(&impl, /*5Ge*/freeFn);
}
inline C(bool) OldList::insert(/*1Ab*/void * prevItem, /*1Ab*/void * item)
{
   return OldList_insert(&impl, /*5Ge*/prevItem, /*5Ge*/item);
}
inline void OldList::move(/*1Ab*/void * item, /*1Ab*/void * prevItem)
{
   OldList_move(&impl, /*5Ge*/item, /*5Ge*/prevItem);
}
inline C(bool) OldList::placeName(/*1Ab*/const char * name, /*1Ab*/void ** place)
{
   return OldList_placeName(&impl, /*5Ge*/name, /*5Ge*/place);
}
inline void OldList::remove(/*1Ab*/void * item)
{
   OldList_remove(&impl, /*5Ge*/item);
}
inline void OldList::removeAll(void (* freeFn)(void *))
{
   OldList_removeAll(&impl, /*5Ge*/freeFn);
}
inline void OldList::sort(int (* compare)(void *, void *, void *), /*1Ab*/void * data)
{
   OldList_sort(&impl, /*5Ge*/compare, /*5Ge*/data);
}
inline void OldList::swap(/*1Ab*/void * item1, /*1Ab*/void * item2)
{
   OldList_swap(&impl, /*5Ge*/item1, /*5Ge*/item2);
}


// member accessors: OldList::first
// (struct::void *)

/*nstSet*/inline /*0H*/void * OldList::first_Prop::operator= (/*0H*/void * v)
{
   SELF(OldList, first);
   self->impl.first = v;
   return v;
}

/*regSet*/inline OldList::first_Prop & OldList::first_Prop::operator= (OldList::first_Prop & prop)
{
   SELF(OldList, first);
   /*0H*/void * v = prop;
   self->impl.first = v;
   return prop;
}
/*regGet*/inline OldList::first_Prop::operator /*0I*/void * () const
{
   SELF(OldList, first);
   return self ? ((C(OldList) *)&self->impl)->first : null;
}

// member accessors: OldList::last
// (struct::void *)

/*nstSet*/inline /*0H*/void * OldList::last_Prop::operator= (/*0H*/void * v)
{
   SELF(OldList, last);
   self->impl.last = v;
   return v;
}

/*regSet*/inline OldList::last_Prop & OldList::last_Prop::operator= (OldList::last_Prop & prop)
{
   SELF(OldList, last);
   /*0H*/void * v = prop;
   self->impl.last = v;
   return prop;
}
/*regGet*/inline OldList::last_Prop::operator /*0I*/void * () const
{
   SELF(OldList, last);
   return self ? ((C(OldList) *)&self->impl)->last : null;
}

// member accessors: OldList::count
// (struct::int)

/*nstSet*/inline /*0H*/int OldList::count_Prop::operator= (/*0H*/int v)
{
   SELF(OldList, count);
   self->impl.count = v;
   return v;
}

/*regSet*/inline OldList::count_Prop & OldList::count_Prop::operator= (OldList::count_Prop & prop)
{
   SELF(OldList, count);
   /*0H*/int v = prop;
   self->impl.count = v;
   return prop;
}
/*regGet*/inline OldList::count_Prop::operator /*0I*/int () const
{
   SELF(OldList, count);
   return self ? ((C(OldList) *)&self->impl)->count : 0;
}

// member accessors: OldList::offset
// (struct::uint)

/*nstSet*/inline /*0H*/uint OldList::offset_Prop::operator= (/*0H*/uint v)
{
   SELF(OldList, offset);
   self->impl.offset = v;
   return v;
}

/*regSet*/inline OldList::offset_Prop & OldList::offset_Prop::operator= (OldList::offset_Prop & prop)
{
   SELF(OldList, offset);
   /*0H*/uint v = prop;
   self->impl.offset = v;
   return prop;
}
/*regGet*/inline OldList::offset_Prop::operator /*0I*/uint () const
{
   SELF(OldList, offset);
   return self ? ((C(OldList) *)&self->impl)->offset : 0;
}

// member accessors: OldList::circ
// (struct::enum|uint)

/*nstSet*/inline /*0H*/bool OldList::circ_Prop::operator= (/*0H*/bool v)
{
   SELF(OldList, circ);
   self->impl.circ = (C(bool))v;
   return v;
}

/*regSet*/inline OldList::circ_Prop & OldList::circ_Prop::operator= (OldList::circ_Prop & prop)
{
   SELF(OldList, circ);
   /*0H*/bool v = prop;
   self->impl.circ = (C(bool))v;
   return prop;
}
/*regGet*/inline OldList::circ_Prop::operator /*0I*/bool () const
{
   SELF(OldList, circ);
   return self ? (bool)((C(OldList) *)&self->impl)->circ : (bool)0;
}



// member accessors: StringBTNode::key
// (nohead::string)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/char * TStringBTNode<TC, TCO>::key_Prop::operator= (/*0H*/char * v)
{
   SELF(StringBTNode, key);
   ((C(StringBTNode) *)self->impl)->key = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TStringBTNode<TC, TCO>::key_Prop & TStringBTNode<TC, TCO>::key_Prop::operator= (typename TStringBTNode<TC, TCO>::key_Prop & prop)
{
   SELF(StringBTNode, key);
   /*0H*/char * v = prop;
   ((C(StringBTNode) *)self->impl)->key = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TStringBTNode<TC, TCO>::key_Prop::operator /*0I*/char * () const
{
   __attribute__((unused)) TStringBTNode TCTCO * self = CONTAINER_OF(this, TStringBTNode TCTCO, key);
   return self ? ((C(StringBTNode) *)self->impl)->key : 0;
}

// member accessors: StringBTNode::parent
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/StringBTNode TStringBTNode<TC, TCO>::parent_Prop::operator= (/*0H*/StringBTNode & v)
{
   SELF(StringBTNode, parent);
   ((C(StringBTNode) *)self->impl)->parent = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TStringBTNode<TC, TCO>::parent_Prop & TStringBTNode<TC, TCO>::parent_Prop::operator= (typename TStringBTNode<TC, TCO>::parent_Prop & prop)
{
   SELF(StringBTNode, parent);
   /*0H*/StringBTNode v = prop;
   ((C(StringBTNode) *)self->impl)->parent = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TStringBTNode<TC, TCO>::parent_Prop::operator /*0I*/StringBTNode () const
{
   __attribute__((unused)) TStringBTNode TCTCO * self = CONTAINER_OF(this, TStringBTNode TCTCO, parent);
   StringBTNode value(((C(StringBTNode) *)self->impl)->parent);
   return value;
}

// member accessors: StringBTNode::left
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/StringBTNode TStringBTNode<TC, TCO>::left_Prop::operator= (/*0H*/StringBTNode & v)
{
   SELF(StringBTNode, left);
   ((C(StringBTNode) *)self->impl)->left = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TStringBTNode<TC, TCO>::left_Prop & TStringBTNode<TC, TCO>::left_Prop::operator= (typename TStringBTNode<TC, TCO>::left_Prop & prop)
{
   SELF(StringBTNode, left);
   /*0H*/StringBTNode v = prop;
   ((C(StringBTNode) *)self->impl)->left = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TStringBTNode<TC, TCO>::left_Prop::operator /*0I*/StringBTNode () const
{
   __attribute__((unused)) TStringBTNode TCTCO * self = CONTAINER_OF(this, TStringBTNode TCTCO, left);
   StringBTNode value(((C(StringBTNode) *)self->impl)->left);
   return value;
}

// member accessors: StringBTNode::right
// (nohead::nohead)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/StringBTNode TStringBTNode<TC, TCO>::right_Prop::operator= (/*0H*/StringBTNode & v)
{
   SELF(StringBTNode, right);
   ((C(StringBTNode) *)self->impl)->right = v.impl;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TStringBTNode<TC, TCO>::right_Prop & TStringBTNode<TC, TCO>::right_Prop::operator= (typename TStringBTNode<TC, TCO>::right_Prop & prop)
{
   SELF(StringBTNode, right);
   /*0H*/StringBTNode v = prop;
   ((C(StringBTNode) *)self->impl)->right = v.impl;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TStringBTNode<TC, TCO>::right_Prop::operator /*0I*/StringBTNode () const
{
   __attribute__((unused)) TStringBTNode TCTCO * self = CONTAINER_OF(this, TStringBTNode TCTCO, right);
   StringBTNode value(((C(StringBTNode) *)self->impl)->right);
   return value;
}

// member accessors: StringBTNode::depth
// (nohead::int)

/*nstSet*/template <class TC, C(Class) ** TCO> inline /*0H*/int TStringBTNode<TC, TCO>::depth_Prop::operator= (/*0H*/int v)
{
   SELF(StringBTNode, depth);
   ((C(StringBTNode) *)self->impl)->depth = v;
   return v;
}

/*regSet*/template <class TC, C(Class) ** TCO> inline typename TStringBTNode<TC, TCO>::depth_Prop & TStringBTNode<TC, TCO>::depth_Prop::operator= (typename TStringBTNode<TC, TCO>::depth_Prop & prop)
{
   SELF(StringBTNode, depth);
   /*0H*/int v = prop;
   ((C(StringBTNode) *)self->impl)->depth = v;
   return prop;
}
/*regGet*/template <class TC, C(Class) ** TCO> inline TStringBTNode<TC, TCO>::depth_Prop::operator /*0I*/int () const
{
   __attribute__((unused)) TStringBTNode TCTCO * self = CONTAINER_OF(this, TStringBTNode TCTCO, depth);
   return self ? ((C(StringBTNode) *)self->impl)->depth : 0;
}


inline C(bool) StringBinaryTree::add(/*1Ab*/BTNode node)
{
   return BinaryTree_add((C(BinaryTree)*)&impl, /*5De*/node.impl);
}
inline C(bool) StringBinaryTree::check()
{
   return BinaryTree_check((C(BinaryTree)*)&impl);
}
inline int StringBinaryTree::compareInt(/*1Ab*/uintptr a, /*1Ab*/uintptr b)
{
   return BinaryTree_compareInt((C(BinaryTree)*)&impl, /*5Ge*/a, /*5Ge*/b);
}
inline int StringBinaryTree::compareString(/*1Ab*/const char * a, /*1Ab*/const char * b)
{
   return BinaryTree_compareString((C(BinaryTree)*)&impl, /*5Ge*/a, /*5Ge*/b);
}
inline void StringBinaryTree::_delete(/*1Ab*/BTNode node)
{
   BinaryTree_delete((C(BinaryTree)*)&impl, /*5De*/node.impl);
}
inline C(BTNode) * StringBinaryTree::find(/*1Ab*/uintptr key)
{
   return BinaryTree_find((C(BinaryTree)*)&impl, /*5Ge*/key);
}
inline C(BTNode) * StringBinaryTree::findAll(/*1Ab*/uintptr key)
{
   return BinaryTree_findAll((C(BinaryTree)*)&impl, /*5Ge*/key);
}
inline C(BTNode) * StringBinaryTree::findPrefix(/*1Ab*/const char * key)
{
   return BinaryTree_findPrefix((C(BinaryTree)*)&impl, /*5Ge*/key);
}
inline C(BTNode) * StringBinaryTree::findString(/*1Ab*/const char * key)
{
   return BinaryTree_findString((C(BinaryTree)*)&impl, /*5Ge*/key);
}
inline void StringBinaryTree::free()
{
   BinaryTree_free((C(BinaryTree)*)&impl);
}
inline void StringBinaryTree::freeString(/*1Ab*/char * string)
{
   BinaryTree_freeString(/*5Ge*/string);
}
inline char * StringBinaryTree::print(/*1Ab*/char * output, /*1Ab*/TreePrintStyle tps)
{
   return BinaryTree_print((C(BinaryTree)*)&impl, /*5Ge*/output, /*5Ee*/(C(TreePrintStyle))tps);
}
inline void StringBinaryTree::remove(/*1Ab*/BTNode node)
{
   BinaryTree_remove((C(BinaryTree)*)&impl, /*5De*/node.impl);
}


// property callers: StringBinaryTree::first   // get only
// (struct::nohead)

/*regGet*/inline StringBinaryTree::first_Prop::operator /*0I*/BTNode () const
{
   SELF(StringBinaryTree, first);
   BTNode value(BinaryTree_get_first((C(BinaryTree)*)&self->impl));
   return value;
}

// property callers: StringBinaryTree::last   // get only
// (struct::nohead)

/*regGet*/inline StringBinaryTree::last_Prop::operator /*0I*/BTNode () const
{
   SELF(StringBinaryTree, last);
   BTNode value(BinaryTree_get_last((C(BinaryTree)*)&self->impl));
   return value;
}


// member accessors: StringBinaryTree::root
// (struct::nohead)

/*nstSet*/inline /*0H*/BTNode StringBinaryTree::root_Prop::operator= (/*0H*/BTNode & v)
{
   SELF(StringBinaryTree, root);
   self->impl.root = v.impl;
   return v;
}

/*regSet*/inline StringBinaryTree::root_Prop & StringBinaryTree::root_Prop::operator= (StringBinaryTree::root_Prop & prop)
{
   SELF(StringBinaryTree, root);
   /*0H*/BTNode v = prop;
   self->impl.root = v.impl;
   return prop;
}
/*regGet*/inline StringBinaryTree::root_Prop::operator /*0I*/BTNode () const
{
   SELF(StringBinaryTree, root);
   BTNode value(((C(StringBinaryTree) *)&self->impl)->root);
   return value;
}

// member accessors: StringBinaryTree::count
// (struct::int)

/*nstSet*/inline /*0H*/int StringBinaryTree::count_Prop::operator= (/*0H*/int v)
{
   SELF(StringBinaryTree, count);
   self->impl.count = v;
   return v;
}

/*regSet*/inline StringBinaryTree::count_Prop & StringBinaryTree::count_Prop::operator= (StringBinaryTree::count_Prop & prop)
{
   SELF(StringBinaryTree, count);
   /*0H*/int v = prop;
   self->impl.count = v;
   return prop;
}
/*regGet*/inline StringBinaryTree::count_Prop::operator /*0I*/int () const
{
   SELF(StringBinaryTree, count);
   return self ? ((C(StringBinaryTree) *)&self->impl)->count : 0;
}

////////////////////////////////////////////////////// [ecrt]/eC::files //////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////


inline Archive::Archive(FileSize totalSize, uint bufferSize = 0, uint bufferRead = 0) : Archive()
{
   this->totalSize = totalSize.impl;
   this->bufferSize = bufferSize;
   this->bufferRead = bufferRead;
}

inline Archive::Archive_clear_Functor::FunctionType Archive::Archive_clear_Functor::operator= (FunctionType func)
{
   SELF(Archive, clear);
   if(self->vTbl == Archive::_cpp_class.vTbl)
   {
      uint size = Archive::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Archive::Archive_clear_Functor::FunctionType, size);
      memcpy(self->vTbl, Archive::_cpp_class.vTbl, sizeof(Archive::Archive_clear_Functor::FunctionType) * size);
   }
   ((Archive::Archive_clear_Functor::FunctionType *)self->vTbl)[M_VTBLID(Archive, clear)] = func;
   return func;
}
inline bool Archive::Archive_clear_Functor::operator()( )
{
   SELF(Archive, clear);
   return (bool)Archive_clear(self ? self->impl : (C(Archive))null);
}
// inline void Archive::register_clear(CPPClass & cl, Archive::Archive_clear_Functor::FunctionType func)
// {
//    ((Archive::Archive_clear_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Archive, clear)] = func;
// }

inline Archive::Archive_fileExists_Functor::FunctionType Archive::Archive_fileExists_Functor::operator= (FunctionType func)
{
   SELF(Archive, fileExists);
   if(self->vTbl == Archive::_cpp_class.vTbl)
   {
      uint size = Archive::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Archive::Archive_fileExists_Functor::FunctionType, size);
      memcpy(self->vTbl, Archive::_cpp_class.vTbl, sizeof(Archive::Archive_fileExists_Functor::FunctionType) * size);
   }
   ((Archive::Archive_fileExists_Functor::FunctionType *)self->vTbl)[M_VTBLID(Archive, fileExists)] = func;
   return func;
}
inline FileAttribs Archive::Archive_fileExists_Functor::operator()( /*6Fj*/const char * fileName)
{
   SELF(Archive, fileExists);
   return Archive_fileExists(self ? self->impl : (C(Archive))null, /*7Al*/fileName);
}
// inline void Archive::register_fileExists(CPPClass & cl, Archive::Archive_fileExists_Functor::FunctionType func)
// {
//    ((Archive::Archive_fileExists_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Archive, fileExists)] = func;
// }

inline Archive::Archive_fileOpen_Functor::FunctionType Archive::Archive_fileOpen_Functor::operator= (FunctionType func)
{
   SELF(Archive, fileOpen);
   if(self->vTbl == Archive::_cpp_class.vTbl)
   {
      uint size = Archive::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Archive::Archive_fileOpen_Functor::FunctionType, size);
      memcpy(self->vTbl, Archive::_cpp_class.vTbl, sizeof(Archive::Archive_fileOpen_Functor::FunctionType) * size);
   }
   ((Archive::Archive_fileOpen_Functor::FunctionType *)self->vTbl)[M_VTBLID(Archive, fileOpen)] = func;
   return func;
}
inline File * Archive::Archive_fileOpen_Functor::operator()( /*6Fj*/const char * fileName)
{
   SELF(Archive, fileOpen);
   C(File) retFile = Archive_fileOpen(self ? self->impl : (C(Archive))null, /*7Al*/fileName);
      return BINDINGS_CLASS(retFile) ? (File *)INSTANCEL(retFile, retFile->_class) : (File *)0;
}
// inline void Archive::register_fileOpen(CPPClass & cl, Archive::Archive_fileOpen_Functor::FunctionType func)
// {
//    ((Archive::Archive_fileOpen_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Archive, fileOpen)] = func;
// }

inline Archive::Archive_fileOpenAtPosition_Functor::FunctionType Archive::Archive_fileOpenAtPosition_Functor::operator= (FunctionType func)
{
   SELF(Archive, fileOpenAtPosition);
   if(self->vTbl == Archive::_cpp_class.vTbl)
   {
      uint size = Archive::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Archive::Archive_fileOpenAtPosition_Functor::FunctionType, size);
      memcpy(self->vTbl, Archive::_cpp_class.vTbl, sizeof(Archive::Archive_fileOpenAtPosition_Functor::FunctionType) * size);
   }
   ((Archive::Archive_fileOpenAtPosition_Functor::FunctionType *)self->vTbl)[M_VTBLID(Archive, fileOpenAtPosition)] = func;
   return func;
}
inline File * Archive::Archive_fileOpenAtPosition_Functor::operator()( /*6Fj*/uint position)
{
   SELF(Archive, fileOpenAtPosition);
   C(File) retFile = Archive_fileOpenAtPosition(self ? self->impl : (C(Archive))null, /*7Al*/position);
      return BINDINGS_CLASS(retFile) ? (File *)INSTANCEL(retFile, retFile->_class) : (File *)0;
}
// inline void Archive::register_fileOpenAtPosition(CPPClass & cl, Archive::Archive_fileOpenAtPosition_Functor::FunctionType func)
// {
//    ((Archive::Archive_fileOpenAtPosition_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Archive, fileOpenAtPosition)] = func;
// }

inline Archive::Archive_fileOpenCompressed_Functor::FunctionType Archive::Archive_fileOpenCompressed_Functor::operator= (FunctionType func)
{
   SELF(Archive, fileOpenCompressed);
   if(self->vTbl == Archive::_cpp_class.vTbl)
   {
      uint size = Archive::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Archive::Archive_fileOpenCompressed_Functor::FunctionType, size);
      memcpy(self->vTbl, Archive::_cpp_class.vTbl, sizeof(Archive::Archive_fileOpenCompressed_Functor::FunctionType) * size);
   }
   ((Archive::Archive_fileOpenCompressed_Functor::FunctionType *)self->vTbl)[M_VTBLID(Archive, fileOpenCompressed)] = func;
   return func;
}
inline File * Archive::Archive_fileOpenCompressed_Functor::operator()( /*6Fj*/const char * fileName, /*6Cj*/C(bool) * isCompressed, /*6Fj*/uint64 * ucSize)
{
   SELF(Archive, fileOpenCompressed);
   C(File) retFile = Archive_fileOpenCompressed(self ? self->impl : (C(Archive))null, /*7Al*/fileName, /*7Al*/isCompressed, /*7Al*/ucSize);
      return BINDINGS_CLASS(retFile) ? (File *)INSTANCEL(retFile, retFile->_class) : (File *)0;
}
// inline void Archive::register_fileOpenCompressed(CPPClass & cl, Archive::Archive_fileOpenCompressed_Functor::FunctionType func)
// {
//    ((Archive::Archive_fileOpenCompressed_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Archive, fileOpenCompressed)] = func;
// }

inline Archive::Archive_openDirectory_Functor::FunctionType Archive::Archive_openDirectory_Functor::operator= (FunctionType func)
{
   SELF(Archive, openDirectory);
   if(self->vTbl == Archive::_cpp_class.vTbl)
   {
      uint size = Archive::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Archive::Archive_openDirectory_Functor::FunctionType, size);
      memcpy(self->vTbl, Archive::_cpp_class.vTbl, sizeof(Archive::Archive_openDirectory_Functor::FunctionType) * size);
   }
   ((Archive::Archive_openDirectory_Functor::FunctionType *)self->vTbl)[M_VTBLID(Archive, openDirectory)] = func;
   return func;
}
inline ArchiveDir * Archive::Archive_openDirectory_Functor::operator()( /*6Fj*/const char * name, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode)
{
   SELF(Archive, openDirectory);
   C(ArchiveDir) retArchiveDir = Archive_openDirectory(self ? self->impl : (C(Archive))null, /*7Al*/name, /*7Al*/&stats.impl, /*7Al*/(C(ArchiveAddMode))addMode);
      return BINDINGS_CLASS(retArchiveDir) ? (ArchiveDir *)INSTANCEL(retArchiveDir, retArchiveDir->_class) : (ArchiveDir *)0;
}
// inline void Archive::register_openDirectory(CPPClass & cl, Archive::Archive_openDirectory_Functor::FunctionType func)
// {
//    ((Archive::Archive_openDirectory_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Archive, openDirectory)] = func;
// }

inline Archive::Archive_setBufferRead_Functor::FunctionType Archive::Archive_setBufferRead_Functor::operator= (FunctionType func)
{
   SELF(Archive, setBufferRead);
   if(self->vTbl == Archive::_cpp_class.vTbl)
   {
      uint size = Archive::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Archive::Archive_setBufferRead_Functor::FunctionType, size);
      memcpy(self->vTbl, Archive::_cpp_class.vTbl, sizeof(Archive::Archive_setBufferRead_Functor::FunctionType) * size);
   }
   ((Archive::Archive_setBufferRead_Functor::FunctionType *)self->vTbl)[M_VTBLID(Archive, setBufferRead)] = func;
   return func;
}
inline void Archive::Archive_setBufferRead_Functor::operator()( /*6Fj*/uint bufferRead)
{
   SELF(Archive, setBufferRead);
   Archive_setBufferRead(self ? self->impl : (C(Archive))null, /*7Al*/bufferRead);
}
// inline void Archive::register_setBufferRead(CPPClass & cl, Archive::Archive_setBufferRead_Functor::FunctionType func)
// {
//    ((Archive::Archive_setBufferRead_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Archive, setBufferRead)] = func;
// }

inline Archive::Archive_setBufferSize_Functor::FunctionType Archive::Archive_setBufferSize_Functor::operator= (FunctionType func)
{
   SELF(Archive, setBufferSize);
   if(self->vTbl == Archive::_cpp_class.vTbl)
   {
      uint size = Archive::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(Archive::Archive_setBufferSize_Functor::FunctionType, size);
      memcpy(self->vTbl, Archive::_cpp_class.vTbl, sizeof(Archive::Archive_setBufferSize_Functor::FunctionType) * size);
   }
   ((Archive::Archive_setBufferSize_Functor::FunctionType *)self->vTbl)[M_VTBLID(Archive, setBufferSize)] = func;
   return func;
}
inline void Archive::Archive_setBufferSize_Functor::operator()( /*6Fj*/uint bufferSize)
{
   SELF(Archive, setBufferSize);
   Archive_setBufferSize(self ? self->impl : (C(Archive))null, /*7Al*/bufferSize);
}
// inline void Archive::register_setBufferSize(CPPClass & cl, Archive::Archive_setBufferSize_Functor::FunctionType func)
// {
//    ((Archive::Archive_setBufferSize_Functor::FunctionType *)cl.vTbl)[M_VTBLID(Archive, setBufferSize)] = func;
// }



// property callers: Archive::totalSize
// (normal::unit|uint)

/*nstSet*/inline /*0H*/FileSize Archive::totalSize_Prop::operator= (/*0H*/FileSize v)
{
   SELF(Archive, totalSize);
   Archive_set_totalSize(self ? self->impl : null, v.impl);
   return v;
}

/*regSet*/inline Archive::totalSize_Prop & Archive::totalSize_Prop::operator= (Archive::totalSize_Prop & prop)
{
   SELF(Archive, totalSize);
   /*0H*/FileSize v = prop;
   Archive_set_totalSize(self ? self->impl : null, v.impl);
   return prop;
}
/*regGet*/inline Archive::totalSize_Prop::operator /*0I*/FileSize () const
{
   SELF(Archive, totalSize);
   FileSize value(Archive_get_totalSize(self->impl));
   return value;
}
/*regGet*/inline Archive::totalSize_Prop::operator /*0J*/C(FileSize) () const
{
   SELF(Archive, totalSize);
   return FileSize(self->totalSize);
}

// property callers: Archive::bufferSize   // set only
// (normal::uint)

/*nstSet*/inline /*0G*/uint Archive::bufferSize_Prop::operator= (/*0G*/uint v)
{
   SELF(Archive, bufferSize);
   Archive_set_bufferSize(self->impl, v);
   return v;
}


// property callers: Archive::bufferRead   // set only
// (normal::uint)

/*nstSet*/inline /*0G*/uint Archive::bufferRead_Prop::operator= (/*0G*/uint v)
{
   SELF(Archive, bufferRead);
   Archive_set_bufferRead(self->impl, v);
   return v;
}


inline ArchiveDir::ArchiveDir_addFromFile_Functor::FunctionType ArchiveDir::ArchiveDir_addFromFile_Functor::operator= (FunctionType func)
{
   SELF(ArchiveDir, addFromFile);
   if(self->vTbl == ArchiveDir::_cpp_class.vTbl)
   {
      uint size = ArchiveDir::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(ArchiveDir::ArchiveDir_addFromFile_Functor::FunctionType, size);
      memcpy(self->vTbl, ArchiveDir::_cpp_class.vTbl, sizeof(ArchiveDir::ArchiveDir_addFromFile_Functor::FunctionType) * size);
   }
   ((ArchiveDir::ArchiveDir_addFromFile_Functor::FunctionType *)self->vTbl)[M_VTBLID(ArchiveDir, addFromFile)] = func;
   return func;
}
inline bool ArchiveDir::ArchiveDir_addFromFile_Functor::operator()( /*6Fj*/const char * name, /*6Fj*/File & input, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode, /*6Fj*/int compression, /*6Fj*/int * ratio, /*6Fj*/uint * newPosition)
{
   SELF(ArchiveDir, addFromFile);
   return (bool)ArchiveDir_addFromFile(self ? self->impl : (C(ArchiveDir))null, /*7Al*/name, /*7Al*/input.impl, /*7Al*/&stats.impl, /*7Al*/(C(ArchiveAddMode))addMode, /*7Al*/compression, /*7Al*/ratio, /*7Al*/newPosition);
}
// inline void ArchiveDir::register_addFromFile(CPPClass & cl, ArchiveDir::ArchiveDir_addFromFile_Functor::FunctionType func)
// {
//    ((ArchiveDir::ArchiveDir_addFromFile_Functor::FunctionType *)cl.vTbl)[M_VTBLID(ArchiveDir, addFromFile)] = func;
// }

inline ArchiveDir::ArchiveDir_addFromFileAtPosition_Functor::FunctionType ArchiveDir::ArchiveDir_addFromFileAtPosition_Functor::operator= (FunctionType func)
{
   SELF(ArchiveDir, addFromFileAtPosition);
   if(self->vTbl == ArchiveDir::_cpp_class.vTbl)
   {
      uint size = ArchiveDir::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(ArchiveDir::ArchiveDir_addFromFileAtPosition_Functor::FunctionType, size);
      memcpy(self->vTbl, ArchiveDir::_cpp_class.vTbl, sizeof(ArchiveDir::ArchiveDir_addFromFileAtPosition_Functor::FunctionType) * size);
   }
   ((ArchiveDir::ArchiveDir_addFromFileAtPosition_Functor::FunctionType *)self->vTbl)[M_VTBLID(ArchiveDir, addFromFileAtPosition)] = func;
   return func;
}
inline bool ArchiveDir::ArchiveDir_addFromFileAtPosition_Functor::operator()( /*6Fj*/uint position, /*6Fj*/const char * name, /*6Fj*/File & input, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode, /*6Fj*/int compression, /*6Fj*/int * ratio, /*6Fj*/uint * newPosition)
{
   SELF(ArchiveDir, addFromFileAtPosition);
   return (bool)ArchiveDir_addFromFileAtPosition(self ? self->impl : (C(ArchiveDir))null, /*7Al*/position, /*7Al*/name, /*7Al*/input.impl, /*7Al*/&stats.impl, /*7Al*/(C(ArchiveAddMode))addMode, /*7Al*/compression, /*7Al*/ratio, /*7Al*/newPosition);
}
// inline void ArchiveDir::register_addFromFileAtPosition(CPPClass & cl, ArchiveDir::ArchiveDir_addFromFileAtPosition_Functor::FunctionType func)
// {
//    ((ArchiveDir::ArchiveDir_addFromFileAtPosition_Functor::FunctionType *)cl.vTbl)[M_VTBLID(ArchiveDir, addFromFileAtPosition)] = func;
// }

inline ArchiveDir::ArchiveDir_delete_Functor::FunctionType ArchiveDir::ArchiveDir_delete_Functor::operator= (FunctionType func)
{
   SELF(ArchiveDir, delete_);
   if(self->vTbl == ArchiveDir::_cpp_class.vTbl)
   {
      uint size = ArchiveDir::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(ArchiveDir::ArchiveDir_delete_Functor::FunctionType, size);
      memcpy(self->vTbl, ArchiveDir::_cpp_class.vTbl, sizeof(ArchiveDir::ArchiveDir_delete_Functor::FunctionType) * size);
   }
   ((ArchiveDir::ArchiveDir_delete_Functor::FunctionType *)self->vTbl)[M_VTBLID(ArchiveDir, delete)] = func;
   return func;
}
inline bool ArchiveDir::ArchiveDir_delete_Functor::operator()( /*6Fj*/const char * fileName)
{
   SELF(ArchiveDir, delete_);
   return (bool)ArchiveDir_delete(self ? self->impl : (C(ArchiveDir))null, /*7Al*/fileName);
}
// inline void ArchiveDir::register_delete(CPPClass & cl, ArchiveDir::ArchiveDir_delete_Functor::FunctionType func)
// {
//    ((ArchiveDir::ArchiveDir_delete_Functor::FunctionType *)cl.vTbl)[M_VTBLID(ArchiveDir, delete)] = func;
// }

inline ArchiveDir::ArchiveDir_fileExists_Functor::FunctionType ArchiveDir::ArchiveDir_fileExists_Functor::operator= (FunctionType func)
{
   SELF(ArchiveDir, fileExists);
   if(self->vTbl == ArchiveDir::_cpp_class.vTbl)
   {
      uint size = ArchiveDir::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(ArchiveDir::ArchiveDir_fileExists_Functor::FunctionType, size);
      memcpy(self->vTbl, ArchiveDir::_cpp_class.vTbl, sizeof(ArchiveDir::ArchiveDir_fileExists_Functor::FunctionType) * size);
   }
   ((ArchiveDir::ArchiveDir_fileExists_Functor::FunctionType *)self->vTbl)[M_VTBLID(ArchiveDir, fileExists)] = func;
   return func;
}
inline FileAttribs ArchiveDir::ArchiveDir_fileExists_Functor::operator()( /*6Fj*/const char * fileName)
{
   SELF(ArchiveDir, fileExists);
   return ArchiveDir_fileExists(self ? self->impl : (C(ArchiveDir))null, /*7Al*/fileName);
}
// inline void ArchiveDir::register_fileExists(CPPClass & cl, ArchiveDir::ArchiveDir_fileExists_Functor::FunctionType func)
// {
//    ((ArchiveDir::ArchiveDir_fileExists_Functor::FunctionType *)cl.vTbl)[M_VTBLID(ArchiveDir, fileExists)] = func;
// }

inline ArchiveDir::ArchiveDir_fileOpen_Functor::FunctionType ArchiveDir::ArchiveDir_fileOpen_Functor::operator= (FunctionType func)
{
   SELF(ArchiveDir, fileOpen);
   if(self->vTbl == ArchiveDir::_cpp_class.vTbl)
   {
      uint size = ArchiveDir::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(ArchiveDir::ArchiveDir_fileOpen_Functor::FunctionType, size);
      memcpy(self->vTbl, ArchiveDir::_cpp_class.vTbl, sizeof(ArchiveDir::ArchiveDir_fileOpen_Functor::FunctionType) * size);
   }
   ((ArchiveDir::ArchiveDir_fileOpen_Functor::FunctionType *)self->vTbl)[M_VTBLID(ArchiveDir, fileOpen)] = func;
   return func;
}
inline File * ArchiveDir::ArchiveDir_fileOpen_Functor::operator()( /*6Fj*/const char * fileName)
{
   SELF(ArchiveDir, fileOpen);
   C(File) retFile = ArchiveDir_fileOpen(self ? self->impl : (C(ArchiveDir))null, /*7Al*/fileName);
      return BINDINGS_CLASS(retFile) ? (File *)INSTANCEL(retFile, retFile->_class) : (File *)0;
}
// inline void ArchiveDir::register_fileOpen(CPPClass & cl, ArchiveDir::ArchiveDir_fileOpen_Functor::FunctionType func)
// {
//    ((ArchiveDir::ArchiveDir_fileOpen_Functor::FunctionType *)cl.vTbl)[M_VTBLID(ArchiveDir, fileOpen)] = func;
// }

inline ArchiveDir::ArchiveDir_move_Functor::FunctionType ArchiveDir::ArchiveDir_move_Functor::operator= (FunctionType func)
{
   SELF(ArchiveDir, move);
   if(self->vTbl == ArchiveDir::_cpp_class.vTbl)
   {
      uint size = ArchiveDir::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(ArchiveDir::ArchiveDir_move_Functor::FunctionType, size);
      memcpy(self->vTbl, ArchiveDir::_cpp_class.vTbl, sizeof(ArchiveDir::ArchiveDir_move_Functor::FunctionType) * size);
   }
   ((ArchiveDir::ArchiveDir_move_Functor::FunctionType *)self->vTbl)[M_VTBLID(ArchiveDir, move)] = func;
   return func;
}
inline bool ArchiveDir::ArchiveDir_move_Functor::operator()( /*6Fj*/const char * name, /*6Fj*/ArchiveDir & to)
{
   SELF(ArchiveDir, move);
   return (bool)ArchiveDir_move(self ? self->impl : (C(ArchiveDir))null, /*7Al*/name, /*7Al*/to.impl);
}
// inline void ArchiveDir::register_move(CPPClass & cl, ArchiveDir::ArchiveDir_move_Functor::FunctionType func)
// {
//    ((ArchiveDir::ArchiveDir_move_Functor::FunctionType *)cl.vTbl)[M_VTBLID(ArchiveDir, move)] = func;
// }

inline ArchiveDir::ArchiveDir_openDirectory_Functor::FunctionType ArchiveDir::ArchiveDir_openDirectory_Functor::operator= (FunctionType func)
{
   SELF(ArchiveDir, openDirectory);
   if(self->vTbl == ArchiveDir::_cpp_class.vTbl)
   {
      uint size = ArchiveDir::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(ArchiveDir::ArchiveDir_openDirectory_Functor::FunctionType, size);
      memcpy(self->vTbl, ArchiveDir::_cpp_class.vTbl, sizeof(ArchiveDir::ArchiveDir_openDirectory_Functor::FunctionType) * size);
   }
   ((ArchiveDir::ArchiveDir_openDirectory_Functor::FunctionType *)self->vTbl)[M_VTBLID(ArchiveDir, openDirectory)] = func;
   return func;
}
inline ArchiveDir * ArchiveDir::ArchiveDir_openDirectory_Functor::operator()( /*6Fj*/const char * name, /*6Fj*/FileStats & stats, /*6Fj*/ArchiveAddMode addMode)
{
   SELF(ArchiveDir, openDirectory);
   C(ArchiveDir) retArchiveDir = ArchiveDir_openDirectory(self ? self->impl : (C(ArchiveDir))null, /*7Al*/name, /*7Al*/&stats.impl, /*7Al*/(C(ArchiveAddMode))addMode);
      return BINDINGS_CLASS(retArchiveDir) ? (ArchiveDir *)INSTANCEL(retArchiveDir, retArchiveDir->_class) : (ArchiveDir *)0;
}
// inline void ArchiveDir::register_openDirectory(CPPClass & cl, ArchiveDir::ArchiveDir_openDirectory_Functor::FunctionType func)
// {
//    ((ArchiveDir::ArchiveDir_openDirectory_Functor::FunctionType *)cl.vTbl)[M_VTBLID(ArchiveDir, openDirectory)] = func;
// }

inline ArchiveDir::ArchiveDir_rename_Functor::FunctionType ArchiveDir::ArchiveDir_rename_Functor::operator= (FunctionType func)
{
   SELF(ArchiveDir, rename);
   if(self->vTbl == ArchiveDir::_cpp_class.vTbl)
   {
      uint size = ArchiveDir::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(ArchiveDir::ArchiveDir_rename_Functor::FunctionType, size);
      memcpy(self->vTbl, ArchiveDir::_cpp_class.vTbl, sizeof(ArchiveDir::ArchiveDir_rename_Functor::FunctionType) * size);
   }
   ((ArchiveDir::ArchiveDir_rename_Functor::FunctionType *)self->vTbl)[M_VTBLID(ArchiveDir, rename)] = func;
   return func;
}
inline bool ArchiveDir::ArchiveDir_rename_Functor::operator()( /*6Fj*/const char * name, /*6Fj*/const char * newName)
{
   SELF(ArchiveDir, rename);
   return (bool)ArchiveDir_rename(self ? self->impl : (C(ArchiveDir))null, /*7Al*/name, /*7Al*/newName);
}
// inline void ArchiveDir::register_rename(CPPClass & cl, ArchiveDir::ArchiveDir_rename_Functor::FunctionType func)
// {
//    ((ArchiveDir::ArchiveDir_rename_Functor::FunctionType *)cl.vTbl)[M_VTBLID(ArchiveDir, rename)] = func;
// }


inline C(bool) ArchiveDir::add(/*1Ab*/const char * name, /*1Ab*/const char * path, /*1Ab*/ArchiveAddMode addMode, /*1Ab*/int compression, /*1Ab*/int * ratio, /*1Ab*/uint * newPosition)
{
   return ArchiveDir_add(impl, /*5Ge*/name, /*5Ge*/path, /*5Ee*/(C(ArchiveAddMode))addMode, /*5Ge*/compression, /*5Ge*/ratio, /*5Ge*/newPosition);
}



// member accessors: ArchiveOpenFlags::writeAccess
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool ArchiveOpenFlags::writeAccess_Prop::operator= (/*0H*/bool v)
{
   SELF(ArchiveOpenFlags, writeAccess);
   ARCHIVEOPENFLAGS_SET_writeAccess(self->impl, v);
   return v;
}

/*regSet*/inline ArchiveOpenFlags::writeAccess_Prop & ArchiveOpenFlags::writeAccess_Prop::operator= (ArchiveOpenFlags::writeAccess_Prop & prop)
{
   SELF(ArchiveOpenFlags, writeAccess);
   /*0H*/bool v = prop;
   ARCHIVEOPENFLAGS_SET_writeAccess(self->impl, v);
   return prop;
}
/*regGet*/inline ArchiveOpenFlags::writeAccess_Prop::operator /*0I*/bool () const
{
   SELF(ArchiveOpenFlags, writeAccess);
   return (bool)ARCHIVEOPENFLAGS_writeAccess(self->impl);
}

// member accessors: ArchiveOpenFlags::buffered
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool ArchiveOpenFlags::buffered_Prop::operator= (/*0H*/bool v)
{
   SELF(ArchiveOpenFlags, buffered);
   ARCHIVEOPENFLAGS_SET_buffered(self->impl, v);
   return v;
}

/*regSet*/inline ArchiveOpenFlags::buffered_Prop & ArchiveOpenFlags::buffered_Prop::operator= (ArchiveOpenFlags::buffered_Prop & prop)
{
   SELF(ArchiveOpenFlags, buffered);
   /*0H*/bool v = prop;
   ARCHIVEOPENFLAGS_SET_buffered(self->impl, v);
   return prop;
}
/*regGet*/inline ArchiveOpenFlags::buffered_Prop::operator /*0I*/bool () const
{
   SELF(ArchiveOpenFlags, buffered);
   return (bool)ARCHIVEOPENFLAGS_buffered(self->impl);
}

// member accessors: ArchiveOpenFlags::exclusive
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool ArchiveOpenFlags::exclusive_Prop::operator= (/*0H*/bool v)
{
   SELF(ArchiveOpenFlags, exclusive);
   ARCHIVEOPENFLAGS_SET_exclusive(self->impl, v);
   return v;
}

/*regSet*/inline ArchiveOpenFlags::exclusive_Prop & ArchiveOpenFlags::exclusive_Prop::operator= (ArchiveOpenFlags::exclusive_Prop & prop)
{
   SELF(ArchiveOpenFlags, exclusive);
   /*0H*/bool v = prop;
   ARCHIVEOPENFLAGS_SET_exclusive(self->impl, v);
   return prop;
}
/*regGet*/inline ArchiveOpenFlags::exclusive_Prop::operator /*0I*/bool () const
{
   SELF(ArchiveOpenFlags, exclusive);
   return (bool)ARCHIVEOPENFLAGS_exclusive(self->impl);
}

// member accessors: ArchiveOpenFlags::waitLock
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool ArchiveOpenFlags::waitLock_Prop::operator= (/*0H*/bool v)
{
   SELF(ArchiveOpenFlags, waitLock);
   ARCHIVEOPENFLAGS_SET_waitLock(self->impl, v);
   return v;
}

/*regSet*/inline ArchiveOpenFlags::waitLock_Prop & ArchiveOpenFlags::waitLock_Prop::operator= (ArchiveOpenFlags::waitLock_Prop & prop)
{
   SELF(ArchiveOpenFlags, waitLock);
   /*0H*/bool v = prop;
   ARCHIVEOPENFLAGS_SET_waitLock(self->impl, v);
   return prop;
}
/*regGet*/inline ArchiveOpenFlags::waitLock_Prop::operator /*0I*/bool () const
{
   SELF(ArchiveOpenFlags, waitLock);
   return (bool)ARCHIVEOPENFLAGS_waitLock(self->impl);
}



// property callers: BufferedFile::handle
// (normal::normal)

/*nstSet*/inline /*0A*/const File & BufferedFile::handle_Prop::operator= (/*0A*/const File & v)
{
   SELF(BufferedFile, handle);
   BufferedFile_set_handle(self ? self->impl : null, v.impl);
   return v;
}

/*regSet*/inline BufferedFile::handle_Prop & BufferedFile::handle_Prop::operator= (BufferedFile::handle_Prop & prop)
{
   SELF(BufferedFile, handle);
   /*0A*/const File & v = prop;
   BufferedFile_set_handle(self ? self->impl : null, v.impl);
   return prop;
}
/*nstSet*/inline /*0C*/const File * BufferedFile::handle_Prop::operator= (/*0C*/const File * v)
{
   SELF(BufferedFile, handle);
   BufferedFile_set_handle(self ? self->impl : null, v ? v->impl : null);
   return v;
}

/*regGet*/inline BufferedFile::handle_Prop::operator /*0B*/TIH<File> () const
{
   SELF(BufferedFile, handle);
   C(Instance) i = BufferedFile_get_handle(self ? self->impl : null);
   TIH<File> cppi(i);
   return *cppi;
}
/*regGet*/inline TIH<File> BufferedFile::handle_Prop::operator /*0D*/-> () const
{
   SELF(BufferedFile, handle);
   C(Instance) i = BufferedFile_get_handle(self ? self->impl : null);
   TIH<File> holder(i);
   return holder;
}
/*regGet*/inline BufferedFile::handle_Prop::operator /*0E*/File () const
{
   SELF(BufferedFile, handle);
   C(Instance) i = BufferedFile_get_handle(self ? self->impl : null);
   return File(i);
}
/*regGet*/inline BufferedFile::handle_Prop::operator /*0F*/File* () const
{
   SELF(BufferedFile, handle);
   C(Instance) i = BufferedFile_get_handle(self ? self->impl : null);
   return BINDINGS_CLASS(i) ? (File *)INSTANCEL(i, i->_class) : (File *)0;
}

// property callers: BufferedFile::bufferSize
// (normal::uintsize)

/*nstSet*/inline /*0H*/uintsize BufferedFile::bufferSize_Prop::operator= (/*0H*/uintsize v)
{
   SELF(BufferedFile, bufferSize);
   BufferedFile_set_bufferSize(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline BufferedFile::bufferSize_Prop & BufferedFile::bufferSize_Prop::operator= (BufferedFile::bufferSize_Prop & prop)
{
   SELF(BufferedFile, bufferSize);
   /*0H*/uintsize v = prop;
   BufferedFile_set_bufferSize(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline BufferedFile::bufferSize_Prop::operator /*0I*/uintsize () const
{
   SELF(BufferedFile, bufferSize);
   return BufferedFile_get_bufferSize(self ? self->impl : null);
}

// property callers: BufferedFile::bufferRead
// (normal::uintsize)

/*nstSet*/inline /*0H*/uintsize BufferedFile::bufferRead_Prop::operator= (/*0H*/uintsize v)
{
   SELF(BufferedFile, bufferRead);
   BufferedFile_set_bufferRead(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline BufferedFile::bufferRead_Prop & BufferedFile::bufferRead_Prop::operator= (BufferedFile::bufferRead_Prop & prop)
{
   SELF(BufferedFile, bufferRead);
   /*0H*/uintsize v = prop;
   BufferedFile_set_bufferRead(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline BufferedFile::bufferRead_Prop::operator /*0I*/uintsize () const
{
   SELF(BufferedFile, bufferRead);
   return BufferedFile_get_bufferRead(self ? self->impl : null);
}



inline int DualPipe::getExitCode()
{
   return DualPipe_getExitCode(impl);
}
inline C(bool) DualPipe::getLinePeek(/*1Ab*/char * s, /*1Ab*/int max, /*1Ab*/int * charsRead)
{
   return DualPipe_getLinePeek(impl, /*5Ge*/s, /*5Ge*/max, /*5Ge*/charsRead);
}
inline int DualPipe::getProcessID()
{
   return DualPipe_getProcessID(impl);
}
inline C(bool) DualPipe::peek()
{
   return DualPipe_peek(impl);
}
inline void DualPipe::terminate()
{
   DualPipe_terminate(impl);
}
inline void DualPipe::wait()
{
   DualPipe_wait(impl);
}



// member accessors: ErrorCode::level
// (bits::enum|int)

/*nstSet*/inline /*0H*/ErrorLevel ErrorCode::level_Prop::operator= (/*0H*/ErrorLevel v)
{
   SELF(ErrorCode, level);
   ERRORCODE_SET_level(self->impl, v);
   return v;
}

/*regSet*/inline ErrorCode::level_Prop & ErrorCode::level_Prop::operator= (ErrorCode::level_Prop & prop)
{
   SELF(ErrorCode, level);
   /*0H*/ErrorLevel v = prop;
   ERRORCODE_SET_level(self->impl, v);
   return prop;
}
/*regGet*/inline ErrorCode::level_Prop::operator /*0I*/ErrorLevel () const
{
   SELF(ErrorCode, level);
   return (ErrorLevel)ERRORCODE_level(self->impl);
}

// member accessors: ErrorCode::code
// (bits::uint)

/*nstSet*/inline /*0H*/uint ErrorCode::code_Prop::operator= (/*0H*/uint v)
{
   SELF(ErrorCode, code);
   ERRORCODE_SET_code(self->impl, v);
   return v;
}

/*regSet*/inline ErrorCode::code_Prop & ErrorCode::code_Prop::operator= (ErrorCode::code_Prop & prop)
{
   SELF(ErrorCode, code);
   /*0H*/uint v = prop;
   ERRORCODE_SET_code(self->impl, v);
   return prop;
}
/*regGet*/inline ErrorCode::code_Prop::operator /*0I*/uint () const
{
   SELF(ErrorCode, code);
   return ERRORCODE_code(self->impl);
}

inline File::File(void * input, void * output = null, bool buffered = (bool)0) : File()
{
   this->input = input;
   this->output = output;
   this->buffered = buffered;
}

inline File::File_close_Functor::FunctionType File::File_close_Functor::operator= (FunctionType func)
{
   SELF(File, close);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_close_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_close_Functor::FunctionType) * size);
   }
   ((File::File_close_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, close)] = func;
   return func;
}
inline void File::File_close_Functor::operator()( )
{
   SELF(File, close);
   File_close(self ? self->impl : (C(File))null);
}
// inline void File::register_close(CPPClass & cl, File::File_close_Functor::FunctionType func)
// {
//    ((File::File_close_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, close)] = func;
// }

inline File::File_closeInput_Functor::FunctionType File::File_closeInput_Functor::operator= (FunctionType func)
{
   SELF(File, closeInput);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_closeInput_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_closeInput_Functor::FunctionType) * size);
   }
   ((File::File_closeInput_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, closeInput)] = func;
   return func;
}
inline void File::File_closeInput_Functor::operator()( )
{
   SELF(File, closeInput);
   File_closeInput(self ? self->impl : (C(File))null);
}
// inline void File::register_closeInput(CPPClass & cl, File::File_closeInput_Functor::FunctionType func)
// {
//    ((File::File_closeInput_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, closeInput)] = func;
// }

inline File::File_closeOutput_Functor::FunctionType File::File_closeOutput_Functor::operator= (FunctionType func)
{
   SELF(File, closeOutput);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_closeOutput_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_closeOutput_Functor::FunctionType) * size);
   }
   ((File::File_closeOutput_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, closeOutput)] = func;
   return func;
}
inline void File::File_closeOutput_Functor::operator()( )
{
   SELF(File, closeOutput);
   File_closeOutput(self ? self->impl : (C(File))null);
}
// inline void File::register_closeOutput(CPPClass & cl, File::File_closeOutput_Functor::FunctionType func)
// {
//    ((File::File_closeOutput_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, closeOutput)] = func;
// }

inline File::File_eof_Functor::FunctionType File::File_eof_Functor::operator= (FunctionType func)
{
   SELF(File, eof_);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_eof_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_eof_Functor::FunctionType) * size);
   }
   ((File::File_eof_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, eof)] = func;
   return func;
}
inline bool File::File_eof_Functor::operator()( )
{
   SELF(File, eof_);
   return (bool)File_eof(self ? self->impl : (C(File))null);
}
// inline void File::register_eof(CPPClass & cl, File::File_eof_Functor::FunctionType func)
// {
//    ((File::File_eof_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, eof)] = func;
// }

inline File::File_getSize_Functor::FunctionType File::File_getSize_Functor::operator= (FunctionType func)
{
   SELF(File, getSize);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_getSize_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_getSize_Functor::FunctionType) * size);
   }
   ((File::File_getSize_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, getSize)] = func;
   return func;
}
inline uint64 File::File_getSize_Functor::operator()( )
{
   SELF(File, getSize);
   return File_getSize(self ? self->impl : (C(File))null);
}
// inline void File::register_getSize(CPPClass & cl, File::File_getSize_Functor::FunctionType func)
// {
//    ((File::File_getSize_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, getSize)] = func;
// }

inline File::File_getc_Functor::FunctionType File::File_getc_Functor::operator= (FunctionType func)
{
   SELF(File, getc);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_getc_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_getc_Functor::FunctionType) * size);
   }
   ((File::File_getc_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, getc)] = func;
   return func;
}
inline bool File::File_getc_Functor::operator()( /*6Fj*/char * ch)
{
   SELF(File, getc);
   return (bool)File_getc(self ? self->impl : (C(File))null, /*7Al*/ch);
}
// inline void File::register_getc(CPPClass & cl, File::File_getc_Functor::FunctionType func)
// {
//    ((File::File_getc_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, getc)] = func;
// }

inline File::File_lock_Functor::FunctionType File::File_lock_Functor::operator= (FunctionType func)
{
   SELF(File, lock);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_lock_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_lock_Functor::FunctionType) * size);
   }
   ((File::File_lock_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, lock)] = func;
   return func;
}
inline bool File::File_lock_Functor::operator()( /*6Fj*/FileLock type, /*6Fj*/uint64 start, /*6Fj*/uint64 length, /*6Fj*/bool wait)
{
   SELF(File, lock);
   return (bool)File_lock(self ? self->impl : (C(File))null, /*7Al*/(C(FileLock))type, /*7Al*/start, /*7Al*/length, /*7Al*/(C(bool))wait);
}
// inline void File::register_lock(CPPClass & cl, File::File_lock_Functor::FunctionType func)
// {
//    ((File::File_lock_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, lock)] = func;
// }

inline File::File_putc_Functor::FunctionType File::File_putc_Functor::operator= (FunctionType func)
{
   SELF(File, putc);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_putc_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_putc_Functor::FunctionType) * size);
   }
   ((File::File_putc_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, putc)] = func;
   return func;
}
inline bool File::File_putc_Functor::operator()( /*6Fj*/char ch)
{
   SELF(File, putc);
   return (bool)File_putc(self ? self->impl : (C(File))null, /*7Al*/ch);
}
// inline void File::register_putc(CPPClass & cl, File::File_putc_Functor::FunctionType func)
// {
//    ((File::File_putc_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, putc)] = func;
// }

inline File::File_puts_Functor::FunctionType File::File_puts_Functor::operator= (FunctionType func)
{
   SELF(File, puts);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_puts_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_puts_Functor::FunctionType) * size);
   }
   ((File::File_puts_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, puts)] = func;
   return func;
}
inline bool File::File_puts_Functor::operator()( /*6Fj*/const char * string)
{
   SELF(File, puts);
   return (bool)File_puts(self ? self->impl : (C(File))null, /*7Al*/string);
}
// inline void File::register_puts(CPPClass & cl, File::File_puts_Functor::FunctionType func)
// {
//    ((File::File_puts_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, puts)] = func;
// }

inline File::File_read_Functor::FunctionType File::File_read_Functor::operator= (FunctionType func)
{
   SELF(File, read);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_read_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_read_Functor::FunctionType) * size);
   }
   ((File::File_read_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, read)] = func;
   return func;
}
inline uintsize File::File_read_Functor::operator()( /*6Fj*/void * buffer, /*6Fj*/uintsize size, /*6Fj*/uintsize count)
{
   SELF(File, read);
   return File_read(self ? self->impl : (C(File))null, /*7Al*/buffer, /*7Al*/size, /*7Al*/count);
}
// inline void File::register_read(CPPClass & cl, File::File_read_Functor::FunctionType func)
// {
//    ((File::File_read_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, read)] = func;
// }

inline File::File_seek_Functor::FunctionType File::File_seek_Functor::operator= (FunctionType func)
{
   SELF(File, seek);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_seek_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_seek_Functor::FunctionType) * size);
   }
   ((File::File_seek_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, seek)] = func;
   return func;
}
inline bool File::File_seek_Functor::operator()( /*6Fj*/int64 pos, /*6Fj*/FileSeekMode mode)
{
   SELF(File, seek);
   return (bool)File_seek(self ? self->impl : (C(File))null, /*7Al*/pos, /*7Al*/(C(FileSeekMode))mode);
}
// inline void File::register_seek(CPPClass & cl, File::File_seek_Functor::FunctionType func)
// {
//    ((File::File_seek_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, seek)] = func;
// }

inline File::File_tell_Functor::FunctionType File::File_tell_Functor::operator= (FunctionType func)
{
   SELF(File, tell);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_tell_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_tell_Functor::FunctionType) * size);
   }
   ((File::File_tell_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, tell)] = func;
   return func;
}
inline uint64 File::File_tell_Functor::operator()( )
{
   SELF(File, tell);
   return File_tell(self ? self->impl : (C(File))null);
}
// inline void File::register_tell(CPPClass & cl, File::File_tell_Functor::FunctionType func)
// {
//    ((File::File_tell_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, tell)] = func;
// }

inline File::File_truncate_Functor::FunctionType File::File_truncate_Functor::operator= (FunctionType func)
{
   SELF(File, truncate);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_truncate_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_truncate_Functor::FunctionType) * size);
   }
   ((File::File_truncate_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, truncate)] = func;
   return func;
}
inline bool File::File_truncate_Functor::operator()( /*6Fj*/uint64 size)
{
   SELF(File, truncate);
   return (bool)File_truncate(self ? self->impl : (C(File))null, /*7Al*/size);
}
// inline void File::register_truncate(CPPClass & cl, File::File_truncate_Functor::FunctionType func)
// {
//    ((File::File_truncate_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, truncate)] = func;
// }

inline File::File_unlock_Functor::FunctionType File::File_unlock_Functor::operator= (FunctionType func)
{
   SELF(File, unlock);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_unlock_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_unlock_Functor::FunctionType) * size);
   }
   ((File::File_unlock_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, unlock)] = func;
   return func;
}
inline bool File::File_unlock_Functor::operator()( /*6Fj*/uint64 start, /*6Fj*/uint64 length, /*6Fj*/bool wait)
{
   SELF(File, unlock);
   return (bool)File_unlock(self ? self->impl : (C(File))null, /*7Al*/start, /*7Al*/length, /*7Al*/(C(bool))wait);
}
// inline void File::register_unlock(CPPClass & cl, File::File_unlock_Functor::FunctionType func)
// {
//    ((File::File_unlock_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, unlock)] = func;
// }

inline File::File_write_Functor::FunctionType File::File_write_Functor::operator= (FunctionType func)
{
   SELF(File, write);
   if(self->vTbl == File::_cpp_class.vTbl)
   {
      uint size = File::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(File::File_write_Functor::FunctionType, size);
      memcpy(self->vTbl, File::_cpp_class.vTbl, sizeof(File::File_write_Functor::FunctionType) * size);
   }
   ((File::File_write_Functor::FunctionType *)self->vTbl)[M_VTBLID(File, write)] = func;
   return func;
}
inline uintsize File::File_write_Functor::operator()( /*6Fj*/const void * buffer, /*6Fj*/uintsize size, /*6Fj*/uintsize count)
{
   SELF(File, write);
   return File_write(self ? self->impl : (C(File))null, /*7Al*/buffer, /*7Al*/size, /*7Al*/count);
}
// inline void File::register_write(CPPClass & cl, File::File_write_Functor::FunctionType func)
// {
//    ((File::File_write_Functor::FunctionType *)cl.vTbl)[M_VTBLID(File, write)] = func;
// }


inline C(bool) File::copyTo(/*1Ab*/const char * outputFileName)
{
   return File_copyTo(impl, /*5Ge*/outputFileName);
}
inline C(bool) File::copyToFile(/*1Ab*/File & f)
{
   return File_copyToFile(impl, /*5De*/f.impl);
}
inline C(bool) File::flush()
{
   return File_flush(impl);
}
inline double File::getDouble()
{
   return File_getDouble(impl);
}
inline float File::getFloat()
{
   return File_getFloat(impl);
}
inline uint File::getHexValue()
{
   return File_getHexValue(impl);
}
inline C(bool) File::getLine(/*1Ab*/char * s, /*1Ab*/int max)
{
   return File_getLine(impl, /*5Ge*/s, /*5Ge*/max);
}
inline int File::getLineEx(/*1Ab*/char * s, /*1Ab*/int max, /*1Ab*/C(bool) * hasNewLineChar)
{
   return File_getLineEx(impl, /*5Ge*/s, /*5Ge*/max, /*5Ee*/(C(bool) *)hasNewLineChar);
}
inline C(bool) File::getString(/*1Ab*/char * string, /*1Ab*/int max)
{
   return File_getString(impl, /*5Ge*/string, /*5Ge*/max);
}
inline int File::getValue()
{
   return File_getValue(impl);
}
template <typename ...Ts> inline void File::print(/*1Ab*/const Ts&... ts)
{
   std::apply(
      [this](/*1Ab*/auto ...args) { File_print(impl, /*5Ae*/args...); },
      std::tuple_cat(std::make_tuple(classof(ts), vapass(ts))..., std::make_tuple(null))
   );
}
template <typename ...Ts> inline void File::printLn(/*1Ab*/const Ts&... ts)
{
   std::apply(
      [this](/*1Ab*/auto ...args) { File_printLn(impl, /*5Ae*/args...); },
      std::tuple_cat(std::make_tuple(classof(ts), vapass(ts))..., std::make_tuple(null))
   );
}
template<typename... Args> inline int File::_printf(/*1Ab*/const char * format, /*1Ab*/Args... args)
{
   return File_printf(impl, /*5Ge*/format, /*5Ae*/args...);
}


// property callers: File::input
// (normal::void *)

/*nstSet*/inline /*0H*/void * File::input_Prop::operator= (/*0H*/void * v)
{
   SELF(File, input);
   File_set_input(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline File::input_Prop & File::input_Prop::operator= (File::input_Prop & prop)
{
   SELF(File, input);
   /*0H*/void * v = prop;
   File_set_input(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline File::input_Prop::operator /*0I*/void * () const
{
   SELF(File, input);
   return File_get_input(self ? self->impl : null);
}

// property callers: File::output
// (normal::void *)

/*nstSet*/inline /*0H*/void * File::output_Prop::operator= (/*0H*/void * v)
{
   SELF(File, output);
   File_set_output(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline File::output_Prop & File::output_Prop::operator= (File::output_Prop & prop)
{
   SELF(File, output);
   /*0H*/void * v = prop;
   File_set_output(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline File::output_Prop::operator /*0I*/void * () const
{
   SELF(File, output);
   return File_get_output(self ? self->impl : null);
}

// property callers: File::buffered   // set only
// (normal::enum|uint)

/*nstSet*/inline /*0G*/bool File::buffered_Prop::operator= (/*0G*/bool v)
{
   SELF(File, buffered);
   File_set_buffered(self->impl, (C(bool))v);
   return v;
}


// property callers: File::eof   // get only
// (normal::enum|uint)

/*regGet*/inline File::eof_Prop::operator /*0I*/bool () const
{
   SELF(File, eof);
   return (bool)File_get_eof(self ? self->impl : null);
}



// member accessors: FileAttribs::isFile
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isFile_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isFile);
   FILEATTRIBS_SET_isFile(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isFile_Prop & FileAttribs::isFile_Prop::operator= (FileAttribs::isFile_Prop & prop)
{
   SELF(FileAttribs, isFile);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isFile(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isFile_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isFile);
   return (bool)FILEATTRIBS_isFile(self->impl);
}

// member accessors: FileAttribs::isArchive
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isArchive_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isArchive);
   FILEATTRIBS_SET_isArchive(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isArchive_Prop & FileAttribs::isArchive_Prop::operator= (FileAttribs::isArchive_Prop & prop)
{
   SELF(FileAttribs, isArchive);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isArchive(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isArchive_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isArchive);
   return (bool)FILEATTRIBS_isArchive(self->impl);
}

// member accessors: FileAttribs::isHidden
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isHidden_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isHidden);
   FILEATTRIBS_SET_isHidden(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isHidden_Prop & FileAttribs::isHidden_Prop::operator= (FileAttribs::isHidden_Prop & prop)
{
   SELF(FileAttribs, isHidden);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isHidden(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isHidden_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isHidden);
   return (bool)FILEATTRIBS_isHidden(self->impl);
}

// member accessors: FileAttribs::isReadOnly
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isReadOnly_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isReadOnly);
   FILEATTRIBS_SET_isReadOnly(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isReadOnly_Prop & FileAttribs::isReadOnly_Prop::operator= (FileAttribs::isReadOnly_Prop & prop)
{
   SELF(FileAttribs, isReadOnly);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isReadOnly(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isReadOnly_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isReadOnly);
   return (bool)FILEATTRIBS_isReadOnly(self->impl);
}

// member accessors: FileAttribs::isSystem
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isSystem_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isSystem);
   FILEATTRIBS_SET_isSystem(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isSystem_Prop & FileAttribs::isSystem_Prop::operator= (FileAttribs::isSystem_Prop & prop)
{
   SELF(FileAttribs, isSystem);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isSystem(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isSystem_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isSystem);
   return (bool)FILEATTRIBS_isSystem(self->impl);
}

// member accessors: FileAttribs::isTemporary
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isTemporary_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isTemporary);
   FILEATTRIBS_SET_isTemporary(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isTemporary_Prop & FileAttribs::isTemporary_Prop::operator= (FileAttribs::isTemporary_Prop & prop)
{
   SELF(FileAttribs, isTemporary);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isTemporary(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isTemporary_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isTemporary);
   return (bool)FILEATTRIBS_isTemporary(self->impl);
}

// member accessors: FileAttribs::isDirectory
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isDirectory_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isDirectory);
   FILEATTRIBS_SET_isDirectory(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isDirectory_Prop & FileAttribs::isDirectory_Prop::operator= (FileAttribs::isDirectory_Prop & prop)
{
   SELF(FileAttribs, isDirectory);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isDirectory(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isDirectory_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isDirectory);
   return (bool)FILEATTRIBS_isDirectory(self->impl);
}

// member accessors: FileAttribs::isDrive
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isDrive_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isDrive);
   FILEATTRIBS_SET_isDrive(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isDrive_Prop & FileAttribs::isDrive_Prop::operator= (FileAttribs::isDrive_Prop & prop)
{
   SELF(FileAttribs, isDrive);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isDrive(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isDrive_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isDrive);
   return (bool)FILEATTRIBS_isDrive(self->impl);
}

// member accessors: FileAttribs::isCDROM
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isCDROM_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isCDROM);
   FILEATTRIBS_SET_isCDROM(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isCDROM_Prop & FileAttribs::isCDROM_Prop::operator= (FileAttribs::isCDROM_Prop & prop)
{
   SELF(FileAttribs, isCDROM);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isCDROM(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isCDROM_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isCDROM);
   return (bool)FILEATTRIBS_isCDROM(self->impl);
}

// member accessors: FileAttribs::isRemote
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isRemote_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isRemote);
   FILEATTRIBS_SET_isRemote(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isRemote_Prop & FileAttribs::isRemote_Prop::operator= (FileAttribs::isRemote_Prop & prop)
{
   SELF(FileAttribs, isRemote);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isRemote(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isRemote_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isRemote);
   return (bool)FILEATTRIBS_isRemote(self->impl);
}

// member accessors: FileAttribs::isRemovable
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isRemovable_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isRemovable);
   FILEATTRIBS_SET_isRemovable(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isRemovable_Prop & FileAttribs::isRemovable_Prop::operator= (FileAttribs::isRemovable_Prop & prop)
{
   SELF(FileAttribs, isRemovable);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isRemovable(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isRemovable_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isRemovable);
   return (bool)FILEATTRIBS_isRemovable(self->impl);
}

// member accessors: FileAttribs::isServer
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isServer_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isServer);
   FILEATTRIBS_SET_isServer(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isServer_Prop & FileAttribs::isServer_Prop::operator= (FileAttribs::isServer_Prop & prop)
{
   SELF(FileAttribs, isServer);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isServer(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isServer_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isServer);
   return (bool)FILEATTRIBS_isServer(self->impl);
}

// member accessors: FileAttribs::isShare
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileAttribs::isShare_Prop::operator= (/*0H*/bool v)
{
   SELF(FileAttribs, isShare);
   FILEATTRIBS_SET_isShare(self->impl, v);
   return v;
}

/*regSet*/inline FileAttribs::isShare_Prop & FileAttribs::isShare_Prop::operator= (FileAttribs::isShare_Prop & prop)
{
   SELF(FileAttribs, isShare);
   /*0H*/bool v = prop;
   FILEATTRIBS_SET_isShare(self->impl, v);
   return prop;
}
/*regGet*/inline FileAttribs::isShare_Prop::operator /*0I*/bool () const
{
   SELF(FileAttribs, isShare);
   return (bool)FILEATTRIBS_isShare(self->impl);
}



// member accessors: FileChange::created
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileChange::created_Prop::operator= (/*0H*/bool v)
{
   SELF(FileChange, created);
   FILECHANGE_SET_created(self->impl, v);
   return v;
}

/*regSet*/inline FileChange::created_Prop & FileChange::created_Prop::operator= (FileChange::created_Prop & prop)
{
   SELF(FileChange, created);
   /*0H*/bool v = prop;
   FILECHANGE_SET_created(self->impl, v);
   return prop;
}
/*regGet*/inline FileChange::created_Prop::operator /*0I*/bool () const
{
   SELF(FileChange, created);
   return (bool)FILECHANGE_created(self->impl);
}

// member accessors: FileChange::renamed
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileChange::renamed_Prop::operator= (/*0H*/bool v)
{
   SELF(FileChange, renamed);
   FILECHANGE_SET_renamed(self->impl, v);
   return v;
}

/*regSet*/inline FileChange::renamed_Prop & FileChange::renamed_Prop::operator= (FileChange::renamed_Prop & prop)
{
   SELF(FileChange, renamed);
   /*0H*/bool v = prop;
   FILECHANGE_SET_renamed(self->impl, v);
   return prop;
}
/*regGet*/inline FileChange::renamed_Prop::operator /*0I*/bool () const
{
   SELF(FileChange, renamed);
   return (bool)FILECHANGE_renamed(self->impl);
}

// member accessors: FileChange::modified
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileChange::modified_Prop::operator= (/*0H*/bool v)
{
   SELF(FileChange, modified);
   FILECHANGE_SET_modified(self->impl, v);
   return v;
}

/*regSet*/inline FileChange::modified_Prop & FileChange::modified_Prop::operator= (FileChange::modified_Prop & prop)
{
   SELF(FileChange, modified);
   /*0H*/bool v = prop;
   FILECHANGE_SET_modified(self->impl, v);
   return prop;
}
/*regGet*/inline FileChange::modified_Prop::operator /*0I*/bool () const
{
   SELF(FileChange, modified);
   return (bool)FILECHANGE_modified(self->impl);
}

// member accessors: FileChange::deleted
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileChange::deleted_Prop::operator= (/*0H*/bool v)
{
   SELF(FileChange, deleted);
   FILECHANGE_SET_deleted(self->impl, v);
   return v;
}

/*regSet*/inline FileChange::deleted_Prop & FileChange::deleted_Prop::operator= (FileChange::deleted_Prop & prop)
{
   SELF(FileChange, deleted);
   /*0H*/bool v = prop;
   FILECHANGE_SET_deleted(self->impl, v);
   return prop;
}
/*regGet*/inline FileChange::deleted_Prop::operator /*0I*/bool () const
{
   SELF(FileChange, deleted);
   return (bool)FILECHANGE_deleted(self->impl);
}

// member accessors: FileChange::attribs
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool FileChange::attribs_Prop::operator= (/*0H*/bool v)
{
   SELF(FileChange, attribs);
   FILECHANGE_SET_attribs(self->impl, v);
   return v;
}

/*regSet*/inline FileChange::attribs_Prop & FileChange::attribs_Prop::operator= (FileChange::attribs_Prop & prop)
{
   SELF(FileChange, attribs);
   /*0H*/bool v = prop;
   FILECHANGE_SET_attribs(self->impl, v);
   return prop;
}
/*regGet*/inline FileChange::attribs_Prop::operator /*0I*/bool () const
{
   SELF(FileChange, attribs);
   return (bool)FILECHANGE_attribs(self->impl);
}

inline FileListing::FileListing(const char * directory, const char * extensions = null)
{
   impl.directory = directory;
   impl.extensions = extensions;
}


inline C(bool) FileListing::find()
{
   return FileListing_find(&impl);
}
inline void FileListing::stop()
{
   FileListing_stop(&impl);
}


// property callers: FileListing::name   // get only
// (struct::const char *)

/*regGet*/inline FileListing::name_Prop::operator /*0I*/const char * () const
{
   SELF(FileListing, name);
   return FileListing_get_name(self ? &self->impl : null);
}

// property callers: FileListing::path   // get only
// (struct::const char *)

/*regGet*/inline FileListing::path_Prop::operator /*0I*/const char * () const
{
   SELF(FileListing, path);
   return FileListing_get_path(self ? &self->impl : null);
}

// property callers: FileListing::stats   // get only
// (struct::struct)

/*regGet*/inline FileListing::stats_Prop::operator /*0I*/FileStats () const
{
   SELF(FileListing, stats);
   FileStats value;FileListing_get_stats(&self->impl, &value.impl);
   return value;
}


// member accessors: FileListing::directory
// (struct::const char *)

/*nstSet*/inline /*0H*/const char * FileListing::directory_Prop::operator= (/*0H*/const char * v)
{
   SELF(FileListing, directory);
   self->impl.directory = v;
   return v;
}

/*regSet*/inline FileListing::directory_Prop & FileListing::directory_Prop::operator= (FileListing::directory_Prop & prop)
{
   SELF(FileListing, directory);
   /*0H*/const char * v = prop;
   self->impl.directory = v;
   return prop;
}
/*regGet*/inline FileListing::directory_Prop::operator /*0I*/const char * () const
{
   SELF(FileListing, directory);
   return self ? ((C(FileListing) *)&self->impl)->directory : null;
}

// member accessors: FileListing::extensions
// (struct::const char *)

/*nstSet*/inline /*0H*/const char * FileListing::extensions_Prop::operator= (/*0H*/const char * v)
{
   SELF(FileListing, extensions);
   self->impl.extensions = v;
   return v;
}

/*regSet*/inline FileListing::extensions_Prop & FileListing::extensions_Prop::operator= (FileListing::extensions_Prop & prop)
{
   SELF(FileListing, extensions);
   /*0H*/const char * v = prop;
   self->impl.extensions = v;
   return prop;
}
/*regGet*/inline FileListing::extensions_Prop::operator /*0I*/const char * () const
{
   SELF(FileListing, extensions);
   return self ? ((C(FileListing) *)&self->impl)->extensions : null;
}

inline FileMonitor::FileMonitor(void * userData, FileChange fileChange = FileChange(), const char * fileName = null, const char * directoryName = null) : FileMonitor()
{
   this->userData = userData;
   this->fileChange = fileChange;
   this->fileName = fileName;
   this->directoryName = directoryName;
}

inline FileMonitor::FileMonitor_onDirNotify_Functor::FunctionType FileMonitor::FileMonitor_onDirNotify_Functor::operator= (FunctionType func)
{
   SELF(FileMonitor, onDirNotify);
   if(self->vTbl == FileMonitor::_cpp_class.vTbl)
   {
      uint size = FileMonitor::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(FileMonitor::FileMonitor_onDirNotify_Functor::FunctionType, size);
      memcpy(self->vTbl, FileMonitor::_cpp_class.vTbl, sizeof(FileMonitor::FileMonitor_onDirNotify_Functor::FunctionType) * size);
   }
   ((FileMonitor::FileMonitor_onDirNotify_Functor::FunctionType *)self->vTbl)[M_VTBLID(FileMonitor, onDirNotify)] = func;
   return func;
}
inline bool FileMonitor::FileMonitor_onDirNotify_Functor::operator()(/*6Fk*/any_object o_ , /*6Fj*/FileChange action, /*6Fj*/const char * fileName, /*6Fj*/const char * param)
{
   SELF(FileMonitor, onDirNotify);
   return (bool)FileMonitor_onDirNotify(self ? self->impl : (C(FileMonitor))null, o_, /*7Al*/(C(FileChange))action, /*7Al*/fileName, /*7Al*/param);
}
// inline void FileMonitor::register_onDirNotify(CPPClass & cl, FileMonitor::FileMonitor_onDirNotify_Functor::FunctionType func)
// {
//    ((FileMonitor::FileMonitor_onDirNotify_Functor::FunctionType *)cl.vTbl)[M_VTBLID(FileMonitor, onDirNotify)] = func;
// }

inline FileMonitor::FileMonitor_onFileNotify_Functor::FunctionType FileMonitor::FileMonitor_onFileNotify_Functor::operator= (FunctionType func)
{
   SELF(FileMonitor, onFileNotify);
   if(self->vTbl == FileMonitor::_cpp_class.vTbl)
   {
      uint size = FileMonitor::_cpp_class.impl->vTblSize;
      self->vTbl = (void (**)())newt(FileMonitor::FileMonitor_onFileNotify_Functor::FunctionType, size);
      memcpy(self->vTbl, FileMonitor::_cpp_class.vTbl, sizeof(FileMonitor::FileMonitor_onFileNotify_Functor::FunctionType) * size);
   }
   ((FileMonitor::FileMonitor_onFileNotify_Functor::FunctionType *)self->vTbl)[M_VTBLID(FileMonitor, onFileNotify)] = func;
   return func;
}
inline bool FileMonitor::FileMonitor_onFileNotify_Functor::operator()(/*6Fk*/any_object o_ , /*6Fj*/FileChange action, /*6Fj*/const char * param)
{
   SELF(FileMonitor, onFileNotify);
   return (bool)FileMonitor_onFileNotify(self ? self->impl : (C(FileMonitor))null, o_, /*7Al*/(C(FileChange))action, /*7Al*/param);
}
// inline void FileMonitor::register_onFileNotify(CPPClass & cl, FileMonitor::FileMonitor_onFileNotify_Functor::FunctionType func)
// {
//    ((FileMonitor::FileMonitor_onFileNotify_Functor::FunctionType *)cl.vTbl)[M_VTBLID(FileMonitor, onFileNotify)] = func;
// }


inline void FileMonitor::startMonitoring()
{
   FileMonitor_startMonitoring(impl);
}
inline void FileMonitor::stopMonitoring()
{
   FileMonitor_stopMonitoring(impl);
}


// property callers: FileMonitor::userData   // set only
// (normal::void *)

/*nstSet*/inline /*0G*/void * FileMonitor::userData_Prop::operator= (/*0G*/void * v)
{
   SELF(FileMonitor, userData);
   FileMonitor_set_userData(self->impl, v);
   return v;
}


// property callers: FileMonitor::fileChange   // set only
// (normal::bits|unsigned int)

/*nstSet*/inline /*0G*/FileChange FileMonitor::fileChange_Prop::operator= (/*0G*/FileChange v)
{
   SELF(FileMonitor, fileChange);
   FileMonitor_set_fileChange(self->impl, v);
   return v;
}


// property callers: FileMonitor::fileName
// (normal::const char *)

/*nstSet*/inline /*0H*/const char * FileMonitor::fileName_Prop::operator= (/*0H*/const char * v)
{
   SELF(FileMonitor, fileName);
   FileMonitor_set_fileName(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline FileMonitor::fileName_Prop & FileMonitor::fileName_Prop::operator= (FileMonitor::fileName_Prop & prop)
{
   SELF(FileMonitor, fileName);
   /*0H*/const char * v = prop;
   FileMonitor_set_fileName(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline FileMonitor::fileName_Prop::operator /*0I*/const char * () const
{
   SELF(FileMonitor, fileName);
   return FileMonitor_get_fileName(self ? self->impl : null);
}

// property callers: FileMonitor::directoryName
// (normal::const char *)

/*nstSet*/inline /*0H*/const char * FileMonitor::directoryName_Prop::operator= (/*0H*/const char * v)
{
   SELF(FileMonitor, directoryName);
   FileMonitor_set_directoryName(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline FileMonitor::directoryName_Prop & FileMonitor::directoryName_Prop::operator= (FileMonitor::directoryName_Prop & prop)
{
   SELF(FileMonitor, directoryName);
   /*0H*/const char * v = prop;
   FileMonitor_set_directoryName(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline FileMonitor::directoryName_Prop::operator /*0I*/const char * () const
{
   SELF(FileMonitor, directoryName);
   return FileMonitor_get_directoryName(self ? self->impl : null);
}

inline FileStats::FileStats(FileAttribs attribs, uint64 size = 0, SecSince1970 accessed = 0, SecSince1970 modified = 0, SecSince1970 created = 0)
{
   impl.attribs = attribs;
   impl.size = size;
   impl.accessed = accessed.impl;
   impl.modified = modified.impl;
   impl.created = created.impl;
}



// member accessors: FileStats::attribs
// (struct::bits|uint)

/*nstSet*/inline /*0H*/FileAttribs FileStats::attribs_Prop::operator= (/*0H*/FileAttribs v)
{
   SELF(FileStats, attribs);
   self->impl.attribs = v;
   return v;
}

/*regSet*/inline FileStats::attribs_Prop & FileStats::attribs_Prop::operator= (FileStats::attribs_Prop & prop)
{
   SELF(FileStats, attribs);
   /*0H*/FileAttribs v = prop;
   self->impl.attribs = v;
   return prop;
}
/*regGet*/inline FileStats::attribs_Prop::operator /*0I*/FileAttribs () const
{
   SELF(FileStats, attribs);
   return self ? FileAttribs(((C(FileStats) *)&self->impl)->attribs) : FileAttribs();
}

// member accessors: FileStats::size
// (struct::uint64)

/*nstSet*/inline /*0H*/uint64 FileStats::size_Prop::operator= (/*0H*/uint64 v)
{
   SELF(FileStats, size);
   self->impl.size = v;
   return v;
}

/*regSet*/inline FileStats::size_Prop & FileStats::size_Prop::operator= (FileStats::size_Prop & prop)
{
   SELF(FileStats, size);
   /*0H*/uint64 v = prop;
   self->impl.size = v;
   return prop;
}
/*regGet*/inline FileStats::size_Prop::operator /*0I*/uint64 () const
{
   SELF(FileStats, size);
   return self ? ((C(FileStats) *)&self->impl)->size : 0;
}

// member accessors: FileStats::accessed
// (struct::unit|int64)

/*nstSet*/inline /*0H*/SecSince1970 FileStats::accessed_Prop::operator= (/*0H*/SecSince1970 v)
{
   SELF(FileStats, accessed);
   self->impl.accessed = (int64)v.impl;
   return v;
}

/*regSet*/inline FileStats::accessed_Prop & FileStats::accessed_Prop::operator= (FileStats::accessed_Prop & prop)
{
   SELF(FileStats, accessed);
   /*0H*/SecSince1970 v = prop;
   self->impl.accessed = (int64)v.impl;
   return prop;
}
/*regGet*/inline FileStats::accessed_Prop::operator /*0I*/SecSince1970 () const
{
   SELF(FileStats, accessed);
   return SecSince1970(self->impl.accessed);
}
/*regGet*/inline FileStats::accessed_Prop::operator /*0J*/C(SecSince1970) () const
{
   SELF(FileStats, accessed);
   return SecSince1970(self->accessed);
}

// member accessors: FileStats::modified
// (struct::unit|int64)

/*nstSet*/inline /*0H*/SecSince1970 FileStats::modified_Prop::operator= (/*0H*/SecSince1970 v)
{
   SELF(FileStats, modified);
   self->impl.modified = (int64)v.impl;
   return v;
}

/*regSet*/inline FileStats::modified_Prop & FileStats::modified_Prop::operator= (FileStats::modified_Prop & prop)
{
   SELF(FileStats, modified);
   /*0H*/SecSince1970 v = prop;
   self->impl.modified = (int64)v.impl;
   return prop;
}
/*regGet*/inline FileStats::modified_Prop::operator /*0I*/SecSince1970 () const
{
   SELF(FileStats, modified);
   return SecSince1970(self->impl.modified);
}
/*regGet*/inline FileStats::modified_Prop::operator /*0J*/C(SecSince1970) () const
{
   SELF(FileStats, modified);
   return SecSince1970(self->modified);
}

// member accessors: FileStats::created
// (struct::unit|int64)

/*nstSet*/inline /*0H*/SecSince1970 FileStats::created_Prop::operator= (/*0H*/SecSince1970 v)
{
   SELF(FileStats, created);
   self->impl.created = (int64)v.impl;
   return v;
}

/*regSet*/inline FileStats::created_Prop & FileStats::created_Prop::operator= (FileStats::created_Prop & prop)
{
   SELF(FileStats, created);
   /*0H*/SecSince1970 v = prop;
   self->impl.created = (int64)v.impl;
   return prop;
}
/*regGet*/inline FileStats::created_Prop::operator /*0I*/SecSince1970 () const
{
   SELF(FileStats, created);
   return SecSince1970(self->impl.created);
}
/*regGet*/inline FileStats::created_Prop::operator /*0J*/C(SecSince1970) () const
{
   SELF(FileStats, created);
   return SecSince1970(self->created);
}



// member accessors: MoveFileOptions::overwrite
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool MoveFileOptions::overwrite_Prop::operator= (/*0H*/bool v)
{
   SELF(MoveFileOptions, overwrite);
   MOVEFILEOPTIONS_SET_overwrite(self->impl, v);
   return v;
}

/*regSet*/inline MoveFileOptions::overwrite_Prop & MoveFileOptions::overwrite_Prop::operator= (MoveFileOptions::overwrite_Prop & prop)
{
   SELF(MoveFileOptions, overwrite);
   /*0H*/bool v = prop;
   MOVEFILEOPTIONS_SET_overwrite(self->impl, v);
   return prop;
}
/*regGet*/inline MoveFileOptions::overwrite_Prop::operator /*0I*/bool () const
{
   SELF(MoveFileOptions, overwrite);
   return (bool)MOVEFILEOPTIONS_overwrite(self->impl);
}

// member accessors: MoveFileOptions::sync
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool MoveFileOptions::sync_Prop::operator= (/*0H*/bool v)
{
   SELF(MoveFileOptions, sync);
   MOVEFILEOPTIONS_SET_sync(self->impl, v);
   return v;
}

/*regSet*/inline MoveFileOptions::sync_Prop & MoveFileOptions::sync_Prop::operator= (MoveFileOptions::sync_Prop & prop)
{
   SELF(MoveFileOptions, sync);
   /*0H*/bool v = prop;
   MOVEFILEOPTIONS_SET_sync(self->impl, v);
   return prop;
}
/*regGet*/inline MoveFileOptions::sync_Prop::operator /*0I*/bool () const
{
   SELF(MoveFileOptions, sync);
   return (bool)MOVEFILEOPTIONS_sync(self->impl);
}



// member accessors: PipeOpenMode::output
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool PipeOpenMode::output_Prop::operator= (/*0H*/bool v)
{
   SELF(PipeOpenMode, output);
   PIPEOPENMODE_SET_output(self->impl, v);
   return v;
}

/*regSet*/inline PipeOpenMode::output_Prop & PipeOpenMode::output_Prop::operator= (PipeOpenMode::output_Prop & prop)
{
   SELF(PipeOpenMode, output);
   /*0H*/bool v = prop;
   PIPEOPENMODE_SET_output(self->impl, v);
   return prop;
}
/*regGet*/inline PipeOpenMode::output_Prop::operator /*0I*/bool () const
{
   SELF(PipeOpenMode, output);
   return (bool)PIPEOPENMODE_output(self->impl);
}

// member accessors: PipeOpenMode::error
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool PipeOpenMode::error_Prop::operator= (/*0H*/bool v)
{
   SELF(PipeOpenMode, error);
   PIPEOPENMODE_SET_error(self->impl, v);
   return v;
}

/*regSet*/inline PipeOpenMode::error_Prop & PipeOpenMode::error_Prop::operator= (PipeOpenMode::error_Prop & prop)
{
   SELF(PipeOpenMode, error);
   /*0H*/bool v = prop;
   PIPEOPENMODE_SET_error(self->impl, v);
   return prop;
}
/*regGet*/inline PipeOpenMode::error_Prop::operator /*0I*/bool () const
{
   SELF(PipeOpenMode, error);
   return (bool)PIPEOPENMODE_error(self->impl);
}

// member accessors: PipeOpenMode::input
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool PipeOpenMode::input_Prop::operator= (/*0H*/bool v)
{
   SELF(PipeOpenMode, input);
   PIPEOPENMODE_SET_input(self->impl, v);
   return v;
}

/*regSet*/inline PipeOpenMode::input_Prop & PipeOpenMode::input_Prop::operator= (PipeOpenMode::input_Prop & prop)
{
   SELF(PipeOpenMode, input);
   /*0H*/bool v = prop;
   PIPEOPENMODE_SET_input(self->impl, v);
   return prop;
}
/*regGet*/inline PipeOpenMode::input_Prop::operator /*0I*/bool () const
{
   SELF(PipeOpenMode, input);
   return (bool)PIPEOPENMODE_input(self->impl);
}

// member accessors: PipeOpenMode::showWindow
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool PipeOpenMode::showWindow_Prop::operator= (/*0H*/bool v)
{
   SELF(PipeOpenMode, showWindow);
   PIPEOPENMODE_SET_showWindow(self->impl, v);
   return v;
}

/*regSet*/inline PipeOpenMode::showWindow_Prop & PipeOpenMode::showWindow_Prop::operator= (PipeOpenMode::showWindow_Prop & prop)
{
   SELF(PipeOpenMode, showWindow);
   /*0H*/bool v = prop;
   PIPEOPENMODE_SET_showWindow(self->impl, v);
   return prop;
}
/*regGet*/inline PipeOpenMode::showWindow_Prop::operator /*0I*/bool () const
{
   SELF(PipeOpenMode, showWindow);
   return (bool)PIPEOPENMODE_showWindow(self->impl);
}

inline TempFile::TempFile(FileOpenMode openMode, unsigned char * buffer = null, uintsize size = 0, uintsize allocated = 0) : TempFile()
{
   this->openMode = openMode;
   this->buffer = buffer;
   this->size = size;
   this->allocated = allocated;
}


inline byte * TempFile::stealBuffer()
{
   return TempFile_stealBuffer(impl);
}


// property callers: TempFile::openMode
// (normal::enum|int)

/*nstSet*/inline /*0H*/FileOpenMode TempFile::openMode_Prop::operator= (/*0H*/FileOpenMode v)
{
   SELF(TempFile, openMode);
   TempFile_set_openMode(self ? self->impl : null, (C(FileOpenMode))v);
   return v;
}

/*regSet*/inline TempFile::openMode_Prop & TempFile::openMode_Prop::operator= (TempFile::openMode_Prop & prop)
{
   SELF(TempFile, openMode);
   /*0H*/FileOpenMode v = prop;
   TempFile_set_openMode(self ? self->impl : null, (C(FileOpenMode))v);
   return prop;
}
/*regGet*/inline TempFile::openMode_Prop::operator /*0I*/FileOpenMode () const
{
   SELF(TempFile, openMode);
   return (FileOpenMode)TempFile_get_openMode(self ? self->impl : null);
}

// property callers: TempFile::buffer
// (normal::byte *)

/*nstSet*/inline /*0H*/unsigned char * TempFile::buffer_Prop::operator= (/*0H*/unsigned char * v)
{
   SELF(TempFile, buffer);
   TempFile_set_buffer(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline TempFile::buffer_Prop & TempFile::buffer_Prop::operator= (TempFile::buffer_Prop & prop)
{
   SELF(TempFile, buffer);
   /*0H*/unsigned char * v = prop;
   TempFile_set_buffer(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline TempFile::buffer_Prop::operator /*0I*/unsigned char * () const
{
   SELF(TempFile, buffer);
   return TempFile_get_buffer(self ? self->impl : null);
}

// property callers: TempFile::size
// (normal::uintsize)

/*nstSet*/inline /*0H*/uintsize TempFile::size_Prop::operator= (/*0H*/uintsize v)
{
   SELF(TempFile, size);
   TempFile_set_size(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline TempFile::size_Prop & TempFile::size_Prop::operator= (TempFile::size_Prop & prop)
{
   SELF(TempFile, size);
   /*0H*/uintsize v = prop;
   TempFile_set_size(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline TempFile::size_Prop::operator /*0I*/uintsize () const
{
   SELF(TempFile, size);
   return TempFile_get_size(self ? self->impl : null);
}

// property callers: TempFile::allocated
// (normal::uintsize)

/*nstSet*/inline /*0H*/uintsize TempFile::allocated_Prop::operator= (/*0H*/uintsize v)
{
   SELF(TempFile, allocated);
   TempFile_set_allocated(self ? self->impl : null, v);
   return v;
}

/*regSet*/inline TempFile::allocated_Prop & TempFile::allocated_Prop::operator= (TempFile::allocated_Prop & prop)
{
   SELF(TempFile, allocated);
   /*0H*/uintsize v = prop;
   TempFile_set_allocated(self ? self->impl : null, v);
   return prop;
}
/*regGet*/inline TempFile::allocated_Prop::operator /*0I*/uintsize () const
{
   SELF(TempFile, allocated);
   return TempFile_get_allocated(self ? self->impl : null);
}

/////////////////////////////////////////////////////// [ecrt]/eC::i18n //////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////
//////////////////////////////////////////////////////////////////////////////// ////////////////




// member accessors: CharCategories::none
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::none_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, none);
   CHARCATEGORIES_SET_none(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::none_Prop & CharCategories::none_Prop::operator= (CharCategories::none_Prop & prop)
{
   SELF(CharCategories, none);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_none(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::none_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, none);
   return (bool)CHARCATEGORIES_none(self->impl);
}

// member accessors: CharCategories::markNonSpacing
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::markNonSpacing_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, markNonSpacing);
   CHARCATEGORIES_SET_markNonSpacing(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::markNonSpacing_Prop & CharCategories::markNonSpacing_Prop::operator= (CharCategories::markNonSpacing_Prop & prop)
{
   SELF(CharCategories, markNonSpacing);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_markNonSpacing(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::markNonSpacing_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, markNonSpacing);
   return (bool)CHARCATEGORIES_markNonSpacing(self->impl);
}

// member accessors: CharCategories::markSpacing
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::markSpacing_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, markSpacing);
   CHARCATEGORIES_SET_markSpacing(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::markSpacing_Prop & CharCategories::markSpacing_Prop::operator= (CharCategories::markSpacing_Prop & prop)
{
   SELF(CharCategories, markSpacing);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_markSpacing(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::markSpacing_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, markSpacing);
   return (bool)CHARCATEGORIES_markSpacing(self->impl);
}

// member accessors: CharCategories::markEnclosing
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::markEnclosing_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, markEnclosing);
   CHARCATEGORIES_SET_markEnclosing(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::markEnclosing_Prop & CharCategories::markEnclosing_Prop::operator= (CharCategories::markEnclosing_Prop & prop)
{
   SELF(CharCategories, markEnclosing);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_markEnclosing(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::markEnclosing_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, markEnclosing);
   return (bool)CHARCATEGORIES_markEnclosing(self->impl);
}

// member accessors: CharCategories::numberDecimalDigit
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::numberDecimalDigit_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, numberDecimalDigit);
   CHARCATEGORIES_SET_numberDecimalDigit(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::numberDecimalDigit_Prop & CharCategories::numberDecimalDigit_Prop::operator= (CharCategories::numberDecimalDigit_Prop & prop)
{
   SELF(CharCategories, numberDecimalDigit);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_numberDecimalDigit(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::numberDecimalDigit_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, numberDecimalDigit);
   return (bool)CHARCATEGORIES_numberDecimalDigit(self->impl);
}

// member accessors: CharCategories::numberLetter
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::numberLetter_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, numberLetter);
   CHARCATEGORIES_SET_numberLetter(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::numberLetter_Prop & CharCategories::numberLetter_Prop::operator= (CharCategories::numberLetter_Prop & prop)
{
   SELF(CharCategories, numberLetter);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_numberLetter(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::numberLetter_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, numberLetter);
   return (bool)CHARCATEGORIES_numberLetter(self->impl);
}

// member accessors: CharCategories::numberOther
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::numberOther_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, numberOther);
   CHARCATEGORIES_SET_numberOther(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::numberOther_Prop & CharCategories::numberOther_Prop::operator= (CharCategories::numberOther_Prop & prop)
{
   SELF(CharCategories, numberOther);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_numberOther(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::numberOther_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, numberOther);
   return (bool)CHARCATEGORIES_numberOther(self->impl);
}

// member accessors: CharCategories::separatorSpace
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::separatorSpace_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, separatorSpace);
   CHARCATEGORIES_SET_separatorSpace(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::separatorSpace_Prop & CharCategories::separatorSpace_Prop::operator= (CharCategories::separatorSpace_Prop & prop)
{
   SELF(CharCategories, separatorSpace);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_separatorSpace(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::separatorSpace_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, separatorSpace);
   return (bool)CHARCATEGORIES_separatorSpace(self->impl);
}

// member accessors: CharCategories::separatorLine
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::separatorLine_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, separatorLine);
   CHARCATEGORIES_SET_separatorLine(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::separatorLine_Prop & CharCategories::separatorLine_Prop::operator= (CharCategories::separatorLine_Prop & prop)
{
   SELF(CharCategories, separatorLine);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_separatorLine(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::separatorLine_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, separatorLine);
   return (bool)CHARCATEGORIES_separatorLine(self->impl);
}

// member accessors: CharCategories::separatorParagraph
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::separatorParagraph_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, separatorParagraph);
   CHARCATEGORIES_SET_separatorParagraph(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::separatorParagraph_Prop & CharCategories::separatorParagraph_Prop::operator= (CharCategories::separatorParagraph_Prop & prop)
{
   SELF(CharCategories, separatorParagraph);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_separatorParagraph(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::separatorParagraph_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, separatorParagraph);
   return (bool)CHARCATEGORIES_separatorParagraph(self->impl);
}

// member accessors: CharCategories::otherControl
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::otherControl_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, otherControl);
   CHARCATEGORIES_SET_otherControl(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::otherControl_Prop & CharCategories::otherControl_Prop::operator= (CharCategories::otherControl_Prop & prop)
{
   SELF(CharCategories, otherControl);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_otherControl(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::otherControl_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, otherControl);
   return (bool)CHARCATEGORIES_otherControl(self->impl);
}

// member accessors: CharCategories::otherFormat
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::otherFormat_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, otherFormat);
   CHARCATEGORIES_SET_otherFormat(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::otherFormat_Prop & CharCategories::otherFormat_Prop::operator= (CharCategories::otherFormat_Prop & prop)
{
   SELF(CharCategories, otherFormat);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_otherFormat(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::otherFormat_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, otherFormat);
   return (bool)CHARCATEGORIES_otherFormat(self->impl);
}

// member accessors: CharCategories::otherSurrogate
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::otherSurrogate_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, otherSurrogate);
   CHARCATEGORIES_SET_otherSurrogate(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::otherSurrogate_Prop & CharCategories::otherSurrogate_Prop::operator= (CharCategories::otherSurrogate_Prop & prop)
{
   SELF(CharCategories, otherSurrogate);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_otherSurrogate(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::otherSurrogate_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, otherSurrogate);
   return (bool)CHARCATEGORIES_otherSurrogate(self->impl);
}

// member accessors: CharCategories::otherPrivateUse
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::otherPrivateUse_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, otherPrivateUse);
   CHARCATEGORIES_SET_otherPrivateUse(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::otherPrivateUse_Prop & CharCategories::otherPrivateUse_Prop::operator= (CharCategories::otherPrivateUse_Prop & prop)
{
   SELF(CharCategories, otherPrivateUse);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_otherPrivateUse(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::otherPrivateUse_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, otherPrivateUse);
   return (bool)CHARCATEGORIES_otherPrivateUse(self->impl);
}

// member accessors: CharCategories::otherNotAssigned
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::otherNotAssigned_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, otherNotAssigned);
   CHARCATEGORIES_SET_otherNotAssigned(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::otherNotAssigned_Prop & CharCategories::otherNotAssigned_Prop::operator= (CharCategories::otherNotAssigned_Prop & prop)
{
   SELF(CharCategories, otherNotAssigned);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_otherNotAssigned(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::otherNotAssigned_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, otherNotAssigned);
   return (bool)CHARCATEGORIES_otherNotAssigned(self->impl);
}

// member accessors: CharCategories::letterUpperCase
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::letterUpperCase_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, letterUpperCase);
   CHARCATEGORIES_SET_letterUpperCase(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::letterUpperCase_Prop & CharCategories::letterUpperCase_Prop::operator= (CharCategories::letterUpperCase_Prop & prop)
{
   SELF(CharCategories, letterUpperCase);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_letterUpperCase(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::letterUpperCase_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, letterUpperCase);
   return (bool)CHARCATEGORIES_letterUpperCase(self->impl);
}

// member accessors: CharCategories::letterLowerCase
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::letterLowerCase_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, letterLowerCase);
   CHARCATEGORIES_SET_letterLowerCase(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::letterLowerCase_Prop & CharCategories::letterLowerCase_Prop::operator= (CharCategories::letterLowerCase_Prop & prop)
{
   SELF(CharCategories, letterLowerCase);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_letterLowerCase(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::letterLowerCase_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, letterLowerCase);
   return (bool)CHARCATEGORIES_letterLowerCase(self->impl);
}

// member accessors: CharCategories::letterTitleCase
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::letterTitleCase_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, letterTitleCase);
   CHARCATEGORIES_SET_letterTitleCase(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::letterTitleCase_Prop & CharCategories::letterTitleCase_Prop::operator= (CharCategories::letterTitleCase_Prop & prop)
{
   SELF(CharCategories, letterTitleCase);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_letterTitleCase(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::letterTitleCase_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, letterTitleCase);
   return (bool)CHARCATEGORIES_letterTitleCase(self->impl);
}

// member accessors: CharCategories::letterModifier
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::letterModifier_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, letterModifier);
   CHARCATEGORIES_SET_letterModifier(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::letterModifier_Prop & CharCategories::letterModifier_Prop::operator= (CharCategories::letterModifier_Prop & prop)
{
   SELF(CharCategories, letterModifier);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_letterModifier(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::letterModifier_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, letterModifier);
   return (bool)CHARCATEGORIES_letterModifier(self->impl);
}

// member accessors: CharCategories::letterOther
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::letterOther_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, letterOther);
   CHARCATEGORIES_SET_letterOther(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::letterOther_Prop & CharCategories::letterOther_Prop::operator= (CharCategories::letterOther_Prop & prop)
{
   SELF(CharCategories, letterOther);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_letterOther(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::letterOther_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, letterOther);
   return (bool)CHARCATEGORIES_letterOther(self->impl);
}

// member accessors: CharCategories::punctuationConnector
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::punctuationConnector_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, punctuationConnector);
   CHARCATEGORIES_SET_punctuationConnector(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::punctuationConnector_Prop & CharCategories::punctuationConnector_Prop::operator= (CharCategories::punctuationConnector_Prop & prop)
{
   SELF(CharCategories, punctuationConnector);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_punctuationConnector(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::punctuationConnector_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, punctuationConnector);
   return (bool)CHARCATEGORIES_punctuationConnector(self->impl);
}

// member accessors: CharCategories::punctuationDash
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::punctuationDash_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, punctuationDash);
   CHARCATEGORIES_SET_punctuationDash(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::punctuationDash_Prop & CharCategories::punctuationDash_Prop::operator= (CharCategories::punctuationDash_Prop & prop)
{
   SELF(CharCategories, punctuationDash);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_punctuationDash(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::punctuationDash_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, punctuationDash);
   return (bool)CHARCATEGORIES_punctuationDash(self->impl);
}

// member accessors: CharCategories::punctuationOpen
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::punctuationOpen_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, punctuationOpen);
   CHARCATEGORIES_SET_punctuationOpen(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::punctuationOpen_Prop & CharCategories::punctuationOpen_Prop::operator= (CharCategories::punctuationOpen_Prop & prop)
{
   SELF(CharCategories, punctuationOpen);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_punctuationOpen(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::punctuationOpen_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, punctuationOpen);
   return (bool)CHARCATEGORIES_punctuationOpen(self->impl);
}

// member accessors: CharCategories::punctuationClose
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::punctuationClose_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, punctuationClose);
   CHARCATEGORIES_SET_punctuationClose(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::punctuationClose_Prop & CharCategories::punctuationClose_Prop::operator= (CharCategories::punctuationClose_Prop & prop)
{
   SELF(CharCategories, punctuationClose);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_punctuationClose(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::punctuationClose_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, punctuationClose);
   return (bool)CHARCATEGORIES_punctuationClose(self->impl);
}

// member accessors: CharCategories::punctuationInitial
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::punctuationInitial_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, punctuationInitial);
   CHARCATEGORIES_SET_punctuationInitial(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::punctuationInitial_Prop & CharCategories::punctuationInitial_Prop::operator= (CharCategories::punctuationInitial_Prop & prop)
{
   SELF(CharCategories, punctuationInitial);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_punctuationInitial(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::punctuationInitial_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, punctuationInitial);
   return (bool)CHARCATEGORIES_punctuationInitial(self->impl);
}

// member accessors: CharCategories::punctuationFinal
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::punctuationFinal_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, punctuationFinal);
   CHARCATEGORIES_SET_punctuationFinal(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::punctuationFinal_Prop & CharCategories::punctuationFinal_Prop::operator= (CharCategories::punctuationFinal_Prop & prop)
{
   SELF(CharCategories, punctuationFinal);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_punctuationFinal(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::punctuationFinal_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, punctuationFinal);
   return (bool)CHARCATEGORIES_punctuationFinal(self->impl);
}

// member accessors: CharCategories::punctuationOther
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::punctuationOther_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, punctuationOther);
   CHARCATEGORIES_SET_punctuationOther(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::punctuationOther_Prop & CharCategories::punctuationOther_Prop::operator= (CharCategories::punctuationOther_Prop & prop)
{
   SELF(CharCategories, punctuationOther);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_punctuationOther(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::punctuationOther_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, punctuationOther);
   return (bool)CHARCATEGORIES_punctuationOther(self->impl);
}

// member accessors: CharCategories::symbolMath
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::symbolMath_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, symbolMath);
   CHARCATEGORIES_SET_symbolMath(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::symbolMath_Prop & CharCategories::symbolMath_Prop::operator= (CharCategories::symbolMath_Prop & prop)
{
   SELF(CharCategories, symbolMath);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_symbolMath(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::symbolMath_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, symbolMath);
   return (bool)CHARCATEGORIES_symbolMath(self->impl);
}

// member accessors: CharCategories::symbolCurrency
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::symbolCurrency_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, symbolCurrency);
   CHARCATEGORIES_SET_symbolCurrency(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::symbolCurrency_Prop & CharCategories::symbolCurrency_Prop::operator= (CharCategories::symbolCurrency_Prop & prop)
{
   SELF(CharCategories, symbolCurrency);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_symbolCurrency(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::symbolCurrency_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, symbolCurrency);
   return (bool)CHARCATEGORIES_symbolCurrency(self->impl);
}

// member accessors: CharCategories::symbolModifier
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::symbolModifier_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, symbolModifier);
   CHARCATEGORIES_SET_symbolModifier(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::symbolModifier_Prop & CharCategories::symbolModifier_Prop::operator= (CharCategories::symbolModifier_Prop & prop)
{
   SELF(CharCategories, symbolModifier);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_symbolModifier(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::symbolModifier_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, symbolModifier);
   return (bool)CHARCATEGORIES_symbolModifier(self->impl);
}

// member accessors: CharCategories::symbolOther
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool CharCategories::symbolOther_Prop::operator= (/*0H*/bool v)
{
   SELF(CharCategories, symbolOther);
   CHARCATEGORIES_SET_symbolOther(self->impl, v);
   return v;
}

/*regSet*/inline CharCategories::symbolOther_Prop & CharCategories::symbolOther_Prop::operator= (CharCategories::symbolOther_Prop & prop)
{
   SELF(CharCategories, symbolOther);
   /*0H*/bool v = prop;
   CHARCATEGORIES_SET_symbolOther(self->impl, v);
   return prop;
}
/*regGet*/inline CharCategories::symbolOther_Prop::operator /*0I*/bool () const
{
   SELF(CharCategories, symbolOther);
   return (bool)CHARCATEGORIES_symbolOther(self->impl);
}



// member accessors: UnicodeDecomposition::canonical
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool UnicodeDecomposition::canonical_Prop::operator= (/*0H*/bool v)
{
   SELF(UnicodeDecomposition, canonical);
   UNICODEDECOMPOSITION_SET_canonical(self->impl, v);
   return v;
}

/*regSet*/inline UnicodeDecomposition::canonical_Prop & UnicodeDecomposition::canonical_Prop::operator= (UnicodeDecomposition::canonical_Prop & prop)
{
   SELF(UnicodeDecomposition, canonical);
   /*0H*/bool v = prop;
   UNICODEDECOMPOSITION_SET_canonical(self->impl, v);
   return prop;
}
/*regGet*/inline UnicodeDecomposition::canonical_Prop::operator /*0I*/bool () const
{
   SELF(UnicodeDecomposition, canonical);
   return (bool)UNICODEDECOMPOSITION_canonical(self->impl);
}

// member accessors: UnicodeDecomposition::compat
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool UnicodeDecomposition::compat_Prop::operator= (/*0H*/bool v)
{
   SELF(UnicodeDecomposition, compat);
   UNICODEDECOMPOSITION_SET_compat(self->impl, v);
   return v;
}

/*regSet*/inline UnicodeDecomposition::compat_Prop & UnicodeDecomposition::compat_Prop::operator= (UnicodeDecomposition::compat_Prop & prop)
{
   SELF(UnicodeDecomposition, compat);
   /*0H*/bool v = prop;
   UNICODEDECOMPOSITION_SET_compat(self->impl, v);
   return prop;
}
/*regGet*/inline UnicodeDecomposition::compat_Prop::operator /*0I*/bool () const
{
   SELF(UnicodeDecomposition, compat);
   return (bool)UNICODEDECOMPOSITION_compat(self->impl);
}

// member accessors: UnicodeDecomposition::fraction
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool UnicodeDecomposition::fraction_Prop::operator= (/*0H*/bool v)
{
   SELF(UnicodeDecomposition, fraction);
   UNICODEDECOMPOSITION_SET_fraction(self->impl, v);
   return v;
}

/*regSet*/inline UnicodeDecomposition::fraction_Prop & UnicodeDecomposition::fraction_Prop::operator= (UnicodeDecomposition::fraction_Prop & prop)
{
   SELF(UnicodeDecomposition, fraction);
   /*0H*/bool v = prop;
   UNICODEDECOMPOSITION_SET_fraction(self->impl, v);
   return prop;
}
/*regGet*/inline UnicodeDecomposition::fraction_Prop::operator /*0I*/bool () const
{
   SELF(UnicodeDecomposition, fraction);
   return (bool)UNICODEDECOMPOSITION_fraction(self->impl);
}

// member accessors: UnicodeDecomposition::font
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool UnicodeDecomposition::font_Prop::operator= (/*0H*/bool v)
{
   SELF(UnicodeDecomposition, font);
   UNICODEDECOMPOSITION_SET_font(self->impl, v);
   return v;
}

/*regSet*/inline UnicodeDecomposition::font_Prop & UnicodeDecomposition::font_Prop::operator= (UnicodeDecomposition::font_Prop & prop)
{
   SELF(UnicodeDecomposition, font);
   /*0H*/bool v = prop;
   UNICODEDECOMPOSITION_SET_font(self->impl, v);
   return prop;
}
/*regGet*/inline UnicodeDecomposition::font_Prop::operator /*0I*/bool () const
{
   SELF(UnicodeDecomposition, font);
   return (bool)UNICODEDECOMPOSITION_font(self->impl);
}

// member accessors: UnicodeDecomposition::noBreak
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool UnicodeDecomposition::noBreak_Prop::operator= (/*0H*/bool v)
{
   SELF(UnicodeDecomposition, noBreak);
   UNICODEDECOMPOSITION_SET_noBreak(self->impl, v);
   return v;
}

/*regSet*/inline UnicodeDecomposition::noBreak_Prop & UnicodeDecomposition::noBreak_Prop::operator= (UnicodeDecomposition::noBreak_Prop & prop)
{
   SELF(UnicodeDecomposition, noBreak);
   /*0H*/bool v = prop;
   UNICODEDECOMPOSITION_SET_noBreak(self->impl, v);
   return prop;
}
/*regGet*/inline UnicodeDecomposition::noBreak_Prop::operator /*0I*/bool () const
{
   SELF(UnicodeDecomposition, noBreak);
   return (bool)UNICODEDECOMPOSITION_noBreak(self->impl);
}

// member accessors: UnicodeDecomposition::initial
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool UnicodeDecomposition::initial_Prop::operator= (/*0H*/bool v)
{
   SELF(UnicodeDecomposition, initial);
   UNICODEDECOMPOSITION_SET_initial(self->impl, v);
   return v;
}

/*regSet*/inline UnicodeDecomposition::initial_Prop & UnicodeDecomposition::initial_Prop::operator= (UnicodeDecomposition::initial_Prop & prop)
{
   SELF(UnicodeDecomposition, initial);
   /*0H*/bool v = prop;
   UNICODEDECOMPOSITION_SET_initial(self->impl, v);
   return prop;
}
/*regGet*/inline UnicodeDecomposition::initial_Prop::operator /*0I*/bool () const
{
   SELF(UnicodeDecomposition, initial);
   return (bool)UNICODEDECOMPOSITION_initial(self->impl);
}

// member accessors: UnicodeDecomposition::final
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool UnicodeDecomposition::final_Prop::operator= (/*0H*/bool v)
{
   SELF(UnicodeDecomposition, final);
   UNICODEDECOMPOSITION_SET_final(self->impl, v);
   return v;
}

/*regSet*/inline UnicodeDecomposition::final_Prop & UnicodeDecomposition::final_Prop::operator= (UnicodeDecomposition::final_Prop & prop)
{
   SELF(UnicodeDecomposition, final);
   /*0H*/bool v = prop;
   UNICODEDECOMPOSITION_SET_final(self->impl, v);
   return prop;
}
/*regGet*/inline UnicodeDecomposition::final_Prop::operator /*0I*/bool () const
{
   SELF(UnicodeDecomposition, final);
   return (bool)UNICODEDECOMPOSITION_final(self->impl);
}

// member accessors: UnicodeDecomposition::medial
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool UnicodeDecomposition::medial_Prop::operator= (/*0H*/bool v)
{
   SELF(UnicodeDecomposition, medial);
   UNICODEDECOMPOSITION_SET_medial(self->impl, v);
   return v;
}

/*regSet*/inline UnicodeDecomposition::medial_Prop & UnicodeDecomposition::medial_Prop::operator= (UnicodeDecomposition::medial_Prop & prop)
{
   SELF(UnicodeDecomposition, medial);
   /*0H*/bool v = prop;
   UNICODEDECOMPOSITION_SET_medial(self->impl, v);
   return prop;
}
/*regGet*/inline UnicodeDecomposition::medial_Prop::operator /*0I*/bool () const
{
   SELF(UnicodeDecomposition, medial);
   return (bool)UNICODEDECOMPOSITION_medial(self->impl);
}

// member accessors: UnicodeDecomposition::isolated
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool UnicodeDecomposition::isolated_Prop::operator= (/*0H*/bool v)
{
   SELF(UnicodeDecomposition, isolated);
   UNICODEDECOMPOSITION_SET_isolated(self->impl, v);
   return v;
}

/*regSet*/inline UnicodeDecomposition::isolated_Prop & UnicodeDecomposition::isolated_Prop::operator= (UnicodeDecomposition::isolated_Prop & prop)
{
   SELF(UnicodeDecomposition, isolated);
   /*0H*/bool v = prop;
   UNICODEDECOMPOSITION_SET_isolated(self->impl, v);
   return prop;
}
/*regGet*/inline UnicodeDecomposition::isolated_Prop::operator /*0I*/bool () const
{
   SELF(UnicodeDecomposition, isolated);
   return (bool)UNICODEDECOMPOSITION_isolated(self->impl);
}

// member accessors: UnicodeDecomposition::circle
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool UnicodeDecomposition::circle_Prop::operator= (/*0H*/bool v)
{
   SELF(UnicodeDecomposition, circle);
   UNICODEDECOMPOSITION_SET_circle(self->impl, v);
   return v;
}

/*regSet*/inline UnicodeDecomposition::circle_Prop & UnicodeDecomposition::circle_Prop::operator= (UnicodeDecomposition::circle_Prop & prop)
{
   SELF(UnicodeDecomposition, circle);
   /*0H*/bool v = prop;
   UNICODEDECOMPOSITION_SET_circle(self->impl, v);
   return prop;
}
/*regGet*/inline UnicodeDecomposition::circle_Prop::operator /*0I*/bool () const
{
   SELF(UnicodeDecomposition, circle);
   return (bool)UNICODEDECOMPOSITION_circle(self->impl);
}

// member accessors: UnicodeDecomposition::square
// (bits::enum|uint)

/*nstSet*/inline /*0H*/bool UnicodeDecomposition::square_Prop::operator= (/*0H*/bool v)
{
   SELF(UnicodeDecomposition, square);
   UNICOD