<a id="mypy-boto3-datasync"></a>

# mypy-boto3-datasync

[![PyPI - mypy-boto3-datasync](https://img.shields.io/pypi/v/mypy-boto3-datasync.svg?color=blue)](https://pypi.org/project/mypy-boto3-datasync)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-datasync.svg?color=blue)](https://pypi.org/project/mypy-boto3-datasync)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-datasync?color=blue)](https://pypistats.org/packages/mypy-boto3-datasync)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.DataSync 1.18.11](https://boto3.amazonaws.com/v1/documentation/api/1.18.11/reference/services/datasync.html#DataSync)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-datasync docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_datasync/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-datasync](#mypy-boto3-datasync)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `DataSync` service.

```bash
python -m pip install boto3-stubs[datasync]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[datasync]` in your environment:
  `python -m pip install 'boto3-stubs[datasync]'`

Both type checking and auto-complete should work for `DataSync` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[datasync]` in your environment:
  `python -m pip install 'boto3-stubs[datasync]'`

Both type checking and auto-complete should work for `DataSync` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[datasync]` in your environment:
  `python -m pip install 'boto3-stubs[datasync]'`
- Run `mypy` as usual

Type checking should work for `DataSync` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[datasync]` in your environment:
  `python -m pip install 'boto3-stubs[datasync]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `DataSync` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`DataSyncClient` provides annotations for `boto3.client("datasync")`.

```python
import boto3

from mypy_boto3_datasync import DataSyncClient

client: DataSyncClient = boto3.client("datasync")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DataSyncClient = session.client("datasync")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_datasync.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_datasync import DataSyncClient
from mypy_boto3_datasync.paginator import (
    ListAgentsPaginator,
    ListLocationsPaginator,
    ListTagsForResourcePaginator,
    ListTaskExecutionsPaginator,
    ListTasksPaginator,
)

client: DataSyncClient = boto3.client("datasync")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_agents_paginator: ListAgentsPaginator = client.get_paginator("list_agents")
list_locations_paginator: ListLocationsPaginator = client.get_paginator("list_locations")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_task_executions_paginator: ListTaskExecutionsPaginator = client.get_paginator("list_task_executions")
list_tasks_paginator: ListTasksPaginator = client.get_paginator("list_tasks")
```

<a id="literals"></a>

### Literals

`mypy_boto3_datasync.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_datasync.literals import (
    AgentStatusType,
    AtimeType,
    EndpointTypeType,
    FilterTypeType,
    GidType,
    ListAgentsPaginatorName,
    ListLocationsPaginatorName,
    ListTagsForResourcePaginatorName,
    ListTaskExecutionsPaginatorName,
    ListTasksPaginatorName,
    LocationFilterNameType,
    LogLevelType,
    MtimeType,
    NfsVersionType,
    ObjectStorageServerProtocolType,
    OperatorType,
    OverwriteModeType,
    PhaseStatusType,
    PosixPermissionsType,
    PreserveDeletedFilesType,
    PreserveDevicesType,
    S3StorageClassType,
    SmbSecurityDescriptorCopyFlagsType,
    SmbVersionType,
    TaskExecutionStatusType,
    TaskFilterNameType,
    TaskQueueingType,
    TaskStatusType,
    TransferModeType,
    UidType,
    VerifyModeType,
)

def check_value(value: AgentStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_datasync.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_datasync.type_defs import (
    AgentListEntryTypeDef,
    CancelTaskExecutionRequestRequestTypeDef,
    CreateAgentRequestRequestTypeDef,
    CreateAgentResponseTypeDef,
    CreateLocationEfsRequestRequestTypeDef,
    CreateLocationEfsResponseTypeDef,
    CreateLocationFsxWindowsRequestRequestTypeDef,
    CreateLocationFsxWindowsResponseTypeDef,
    CreateLocationNfsRequestRequestTypeDef,
    CreateLocationNfsResponseTypeDef,
    CreateLocationObjectStorageRequestRequestTypeDef,
    CreateLocationObjectStorageResponseTypeDef,
    CreateLocationS3RequestRequestTypeDef,
    CreateLocationS3ResponseTypeDef,
    CreateLocationSmbRequestRequestTypeDef,
    CreateLocationSmbResponseTypeDef,
    CreateTaskRequestRequestTypeDef,
    CreateTaskResponseTypeDef,
    DeleteAgentRequestRequestTypeDef,
    DeleteLocationRequestRequestTypeDef,
    DeleteTaskRequestRequestTypeDef,
    DescribeAgentRequestRequestTypeDef,
    DescribeAgentResponseTypeDef,
    DescribeLocationEfsRequestRequestTypeDef,
    DescribeLocationEfsResponseTypeDef,
    DescribeLocationFsxWindowsRequestRequestTypeDef,
    DescribeLocationFsxWindowsResponseTypeDef,
    DescribeLocationNfsRequestRequestTypeDef,
    DescribeLocationNfsResponseTypeDef,
    DescribeLocationObjectStorageRequestRequestTypeDef,
    DescribeLocationObjectStorageResponseTypeDef,
    DescribeLocationS3RequestRequestTypeDef,
    DescribeLocationS3ResponseTypeDef,
    DescribeLocationSmbRequestRequestTypeDef,
    DescribeLocationSmbResponseTypeDef,
    DescribeTaskExecutionRequestRequestTypeDef,
    DescribeTaskExecutionResponseTypeDef,
    DescribeTaskRequestRequestTypeDef,
    DescribeTaskResponseTypeDef,
    Ec2ConfigTypeDef,
    FilterRuleTypeDef,
    ListAgentsRequestRequestTypeDef,
    ListAgentsResponseTypeDef,
    ListLocationsRequestRequestTypeDef,
    ListLocationsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTaskExecutionsRequestRequestTypeDef,
    ListTaskExecutionsResponseTypeDef,
    ListTasksRequestRequestTypeDef,
    ListTasksResponseTypeDef,
    LocationFilterTypeDef,
    LocationListEntryTypeDef,
    NfsMountOptionsTypeDef,
    OnPremConfigTypeDef,
    OptionsTypeDef,
    PaginatorConfigTypeDef,
    PrivateLinkConfigTypeDef,
    ResponseMetadataTypeDef,
    S3ConfigTypeDef,
    SmbMountOptionsTypeDef,
    StartTaskExecutionRequestRequestTypeDef,
    StartTaskExecutionResponseTypeDef,
    TagListEntryTypeDef,
    TagResourceRequestRequestTypeDef,
    TaskExecutionListEntryTypeDef,
    TaskExecutionResultDetailTypeDef,
    TaskFilterTypeDef,
    TaskListEntryTypeDef,
    TaskScheduleTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateAgentRequestRequestTypeDef,
    UpdateLocationNfsRequestRequestTypeDef,
    UpdateLocationObjectStorageRequestRequestTypeDef,
    UpdateLocationSmbRequestRequestTypeDef,
    UpdateTaskExecutionRequestRequestTypeDef,
    UpdateTaskRequestRequestTypeDef,
)

def get_structure() -> AgentListEntryTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-datasync` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-datasync docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_datasync/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
