"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.implementsIAcmImportCertProps = exports.implementsIX509CertificateEncodePkcs12 = exports.implementsIX509CertificateGenerate = exports.implementsIX509ResourceProperties = exports.implementsINewSecretProps = exports.implementsISecretCertificate = exports.implementsTag = void 0;
const kms_1 = require("../lib/kms");
const secrets_manager_1 = require("../lib/secrets-manager");
const x509_certs_1 = require("../lib/x509-certs");
function implementsTag(value) {
    if (!value || !Array.isArray(value)) {
        return false;
    }
    for (const tag of value) {
        if (typeof (tag) !== 'object') {
            return false;
        }
        if (!tag.Key || typeof (tag.Key) !== 'string') {
            return false;
        }
        if (!tag.Value || typeof (tag.Value) !== 'string') {
            return false;
        }
    }
    return true;
}
exports.implementsTag = implementsTag;
function implementsISecretCertificate(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    for (const key of ['Cert', 'Key', 'Passphrase']) {
        if (!value[key] || typeof (value[key]) !== 'string') {
            return false;
        }
        if (!secrets_manager_1.isArn(value[key])) {
            return false;
        }
    }
    if (value.CertChain) {
        if (typeof (value.CertChain) !== 'string') {
            return false;
        }
        if (value.CertChain !== '' && !secrets_manager_1.isArn(value.CertChain)) {
            return false;
        }
    }
    return true;
}
exports.implementsISecretCertificate = implementsISecretCertificate;
function implementsINewSecretProps(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!value.NamePrefix || typeof (value.NamePrefix) !== 'string') {
        return false;
    }
    if (value.EncryptionKey) {
        if (typeof (value.EncryptionKey) !== 'string') {
            return false;
        }
        if (!kms_1.isArn(value.EncryptionKey)) {
            return false;
        }
    }
    if (!value.Description || typeof (value.Description) !== 'string') {
        return false;
    }
    if (!implementsTag(value.Tags)) {
        return false;
    }
    return true;
}
exports.implementsINewSecretProps = implementsINewSecretProps;
function implementsIX509ResourceProperties(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!value.Passphrase || typeof (value.Passphrase) !== 'string') {
        return false;
    }
    if (!secrets_manager_1.isArn(value.Passphrase)) {
        return false;
    }
    if (!implementsINewSecretProps(value.Secret)) {
        return false;
    }
    return true;
}
exports.implementsIX509ResourceProperties = implementsIX509ResourceProperties;
function implementsIX509CertificateGenerate(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!implementsIX509ResourceProperties(value)) {
        return false;
    }
    if (!x509_certs_1.implementsDistinguishedNameProps(value.DistinguishedName)) {
        return false;
    }
    if (value.SigningCertificate && !implementsISecretCertificate(value.SigningCertificate)) {
        return false;
    }
    if (value.CertificateValidFor) {
        if (typeof (value.CertificateValidFor) !== 'string') {
            return false;
        }
        if (value.CertificateValidFor === '' || isNaN(Number(value.CertificateValidFor))) {
            return false;
        }
    }
    return true;
}
exports.implementsIX509CertificateGenerate = implementsIX509CertificateGenerate;
function implementsIX509CertificateEncodePkcs12(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!implementsIX509ResourceProperties(value)) {
        return false;
    }
    if (!implementsISecretCertificate(value.Certificate)) {
        return false;
    }
    return true;
}
exports.implementsIX509CertificateEncodePkcs12 = implementsIX509CertificateEncodePkcs12;
function implementsIAcmImportCertProps(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!implementsISecretCertificate(value.X509CertificatePem)) {
        return false;
    }
    if (!implementsTag(value.Tags)) {
        return false;
    }
    return true;
}
exports.implementsIAcmImportCertProps = implementsIAcmImportCertProps;
//# sourceMappingURL=data:application/json;base64,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