/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { SecretsManager } from 'aws-sdk';
/**
 * Retrieve certificate data from the Secret with the given ARN.
 * @param arn ARN of the Secret containing the certificate
 * @param client An instance of the SecretsManager class
 */
export declare function readCertificateData(arn: string, client: SecretsManager): Promise<string>;
