"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThinkboxDockerRecipes = exports.ThinkboxManagedDeadlineDockerRecipes = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const aws_s3_assets_1 = require("@aws-cdk/aws-s3-assets");
const core_1 = require("@aws-cdk/core");
const _1 = require(".");
/**
 * An enum that is associated with AWS Thinkbox managed recipes that are available in the stage manifest.
 *
 * @stability stable
 */
var ThinkboxManagedDeadlineDockerRecipes;
(function (ThinkboxManagedDeadlineDockerRecipes) {
    ThinkboxManagedDeadlineDockerRecipes["REMOTE_CONNECTION_SERVER"] = "rcs";
    ThinkboxManagedDeadlineDockerRecipes["LICENSE_FORWARDER"] = "license-forwarder";
})(ThinkboxManagedDeadlineDockerRecipes = exports.ThinkboxManagedDeadlineDockerRecipes || (exports.ThinkboxManagedDeadlineDockerRecipes = {}));
/**
 * An API for interacting with staged Deadline Docker recipes provided by AWS Thinkbox.
 *
 * This provides container images as required by RFDK's Deadline constructs such as
 *
 * * {@link @aws-rfdk/deadline#RenderQueue}
 * * {@link @aws-rfdk/deadline#UsageBasedLicensing}
 *
 * @stability stable
 * @example
 *
 * Construct a RenderQueue
 *
 * import { App, Stack, Vpc } from '@aws-rfdk/core';
 * import { RenderQueue, Repository, ThinkboxDockerRecipes } from '@aws-rfdk/deadline';
 * const app = new App();
 * const stack = new Stack(app, 'Stack');
 * const vpc = new Vpc(app, stack);
 * const recipes = new ThinkboxDockerRecipes(stack, 'Recipes', {
 * path: '/path/to/staged/recipes'
 * });
 * const repository = new Repository(stack, 'Repository', {
 * vpc,
 * version: recipes.version
 * });
 *
 * const renderQueue = new RenderQueue(stack, 'RenderQueue', {
 * images: recipes.renderQueueImages,
 * // ...
 * });
 */
class ThinkboxDockerRecipes extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.stage = props.stage;
        for (const recipe of [ThinkboxManagedDeadlineDockerRecipes.REMOTE_CONNECTION_SERVER, ThinkboxManagedDeadlineDockerRecipes.LICENSE_FORWARDER]) {
            if (!props.stage.manifest.recipes[recipe]) {
                throw new Error(`Could not find ${recipe} recipe`);
            }
        }
        this.remoteConnectionServer = props.stage.imageFromRecipe(this, 'RemoteConnectionServer', ThinkboxManagedDeadlineDockerRecipes.REMOTE_CONNECTION_SERVER.toString());
        this.licenseForwarder = props.stage.imageFromRecipe(this, 'LicenseForwarder', ThinkboxManagedDeadlineDockerRecipes.LICENSE_FORWARDER.toString());
        this.renderQueueImages = {
            remoteConnectionServer: aws_ecs_1.ContainerImage.fromDockerImageAsset(this.remoteConnectionServer),
        };
        this.ublImages = {
            licenseForwarder: aws_ecs_1.ContainerImage.fromDockerImageAsset(this.licenseForwarder),
        };
    }
    /**
     * @stability stable
     */
    get version() {
        if (!this.versionInstance) {
            const version = _1.Version.parse(this.stage.manifest.version);
            const self = this;
            this.versionInstance = {
                isLessThan: (other) => version.isLessThan(other),
                linuxFullVersionString: () => this.stage.manifest.version,
                linuxInstallers: {
                    get client() {
                        let assetNode = self.node.tryFindChild('ClientInstallerAsset');
                        let asset;
                        /* istanbul ignore else */
                        if (!assetNode) {
                            asset = new aws_s3_assets_1.Asset(self, 'ClientInstallerAsset', {
                                path: self.stage.clientInstallerPath,
                            });
                        }
                        else if (assetNode instanceof aws_s3_assets_1.Asset) {
                            asset = assetNode;
                        }
                        else {
                            throw new Error(`Node "${assetNode === null || assetNode === void 0 ? void 0 : assetNode.node.path}" is not an S3 Asset`);
                        }
                        return {
                            objectKey: asset.s3ObjectKey,
                            s3Bucket: asset.bucket,
                        };
                    },
                    repository: this.stage.getVersion(this, 'VersionQuery').linuxInstallers.repository,
                    patchVersion: version.patchVersion,
                },
                majorVersion: version.majorVersion,
                minorVersion: version.minorVersion,
                releaseVersion: version.releaseVersion,
                versionString: version.versionString,
            };
        }
        return this.versionInstance;
    }
}
exports.ThinkboxDockerRecipes = ThinkboxDockerRecipes;
_a = JSII_RTTI_SYMBOL_1;
ThinkboxDockerRecipes[_a] = { fqn: "aws-rfdk.deadline.ThinkboxDockerRecipes", version: "0.38.0" };
//# sourceMappingURL=data:application/json;base64,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