# coding: utf-8

"""
    Hydrogen Integration API

    The Hydrogen Integration API  # noqa: E501

    OpenAPI spec version: 1.2.1
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from integration_api.api_client import ApiClient


class AccountingApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_or_update_customer(self, nucleus_client_id, **kwargs):  # noqa: E501
        """Update/Create all customers in Nucleus for a given nucleus_client_id  # noqa: E501

        Update/Create all customers in Nucleus for a given nucleus_client_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_customer(nucleus_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_client_id: nucleus_client_id (required)
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_or_update_customer_with_http_info(nucleus_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_or_update_customer_with_http_info(nucleus_client_id, **kwargs)  # noqa: E501
            return data

    def create_or_update_customer_with_http_info(self, nucleus_client_id, **kwargs):  # noqa: E501
        """Update/Create all customers in Nucleus for a given nucleus_client_id  # noqa: E501

        Update/Create all customers in Nucleus for a given nucleus_client_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_customer_with_http_info(nucleus_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_client_id: nucleus_client_id (required)
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_client_id' is set
        if ('nucleus_client_id' not in params or
                params['nucleus_client_id'] is None):
            raise ValueError("Missing the required parameter `nucleus_client_id` when calling `create_or_update_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'nucleus_client_id' in params:
            query_params.append(('nucleus_client_id', params['nucleus_client_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/customer', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountingFinalResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_or_update_customer_revenue(self, nucleus_customer_id, start_date, **kwargs):  # noqa: E501
        """Update/Create all customers revenue in Nucleus for a given nucleus_customer_id  # noqa: E501

        Update/Create all customers revenue in Nucleus for a given nucleus_customer_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_customer_revenue(nucleus_customer_id, start_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_customer_id: nucleus_customer_id (required)
        :param datetime start_date: start_date (required)
        :param str accounting_method: accounting_method
        :param datetime end_date: end_date
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_or_update_customer_revenue_with_http_info(nucleus_customer_id, start_date, **kwargs)  # noqa: E501
        else:
            (data) = self.create_or_update_customer_revenue_with_http_info(nucleus_customer_id, start_date, **kwargs)  # noqa: E501
            return data

    def create_or_update_customer_revenue_with_http_info(self, nucleus_customer_id, start_date, **kwargs):  # noqa: E501
        """Update/Create all customers revenue in Nucleus for a given nucleus_customer_id  # noqa: E501

        Update/Create all customers revenue in Nucleus for a given nucleus_customer_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_customer_revenue_with_http_info(nucleus_customer_id, start_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_customer_id: nucleus_customer_id (required)
        :param datetime start_date: start_date (required)
        :param str accounting_method: accounting_method
        :param datetime end_date: end_date
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_customer_id', 'start_date', 'accounting_method', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_customer_revenue" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_customer_id' is set
        if ('nucleus_customer_id' not in params or
                params['nucleus_customer_id'] is None):
            raise ValueError("Missing the required parameter `nucleus_customer_id` when calling `create_or_update_customer_revenue`")  # noqa: E501
        # verify the required parameter 'start_date' is set
        if ('start_date' not in params or
                params['start_date'] is None):
            raise ValueError("Missing the required parameter `start_date` when calling `create_or_update_customer_revenue`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_customer_id' in params:
            path_params['nucleus_customer_id'] = params['nucleus_customer_id']  # noqa: E501

        query_params = []
        if 'accounting_method' in params:
            query_params.append(('accounting_method', params['accounting_method']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/customer_revenue/{nucleus_customer_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountingFinalResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_or_update_invoice_payment(self, nucleus_invoice_id, **kwargs):  # noqa: E501
        """Create/Update invoice payment in Nucleus for a given nucleus_invoice_id  # noqa: E501

        Create/Update invoice payment in Nucleus for a given nucleus_invoice_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_invoice_payment(nucleus_invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_invoice_id: nucleus_invoice_id (required)
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_or_update_invoice_payment_with_http_info(nucleus_invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_or_update_invoice_payment_with_http_info(nucleus_invoice_id, **kwargs)  # noqa: E501
            return data

    def create_or_update_invoice_payment_with_http_info(self, nucleus_invoice_id, **kwargs):  # noqa: E501
        """Create/Update invoice payment in Nucleus for a given nucleus_invoice_id  # noqa: E501

        Create/Update invoice payment in Nucleus for a given nucleus_invoice_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_invoice_payment_with_http_info(nucleus_invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_invoice_id: nucleus_invoice_id (required)
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_invoice_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_invoice_id' is set
        if ('nucleus_invoice_id' not in params or
                params['nucleus_invoice_id'] is None):
            raise ValueError("Missing the required parameter `nucleus_invoice_id` when calling `create_or_update_invoice_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_invoice_id' in params:
            path_params['nucleus_invoice_id'] = params['nucleus_invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/invoice_payment/{nucleus_invoice_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountingFinalResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_or_update_invoices(self, nucleus_customer_id, start_date, **kwargs):  # noqa: E501
        """Update/Create all invoices in Nucleus for a given nucleus_client_id  # noqa: E501

        Update/Create all invoices in Nucleus for a given nucleus_client_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_invoices(nucleus_customer_id, start_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_customer_id: nucleus_customer_id (required)
        :param datetime start_date: start_date (required)
        :param datetime end_date: end_date
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_or_update_invoices_with_http_info(nucleus_customer_id, start_date, **kwargs)  # noqa: E501
        else:
            (data) = self.create_or_update_invoices_with_http_info(nucleus_customer_id, start_date, **kwargs)  # noqa: E501
            return data

    def create_or_update_invoices_with_http_info(self, nucleus_customer_id, start_date, **kwargs):  # noqa: E501
        """Update/Create all invoices in Nucleus for a given nucleus_client_id  # noqa: E501

        Update/Create all invoices in Nucleus for a given nucleus_client_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_invoices_with_http_info(nucleus_customer_id, start_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_customer_id: nucleus_customer_id (required)
        :param datetime start_date: start_date (required)
        :param datetime end_date: end_date
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_customer_id', 'start_date', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_invoices" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_customer_id' is set
        if ('nucleus_customer_id' not in params or
                params['nucleus_customer_id'] is None):
            raise ValueError("Missing the required parameter `nucleus_customer_id` when calling `create_or_update_invoices`")  # noqa: E501
        # verify the required parameter 'start_date' is set
        if ('start_date' not in params or
                params['start_date'] is None):
            raise ValueError("Missing the required parameter `start_date` when calling `create_or_update_invoices`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'nucleus_customer_id' in params:
            query_params.append(('nucleus_customer_id', params['nucleus_customer_id']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/invoice', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountingFinalResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_accounting_vendor_access_config_is_active_by_id(self, id, **kwargs):  # noqa: E501
        """Permanently delete relation with particular accounting vendor.  # noqa: E501

        Permanently delete relation with particular accounting vendor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_accounting_vendor_access_config_is_active_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_accounting_vendor_access_config_is_active_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_accounting_vendor_access_config_is_active_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_accounting_vendor_access_config_is_active_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Permanently delete relation with particular accounting vendor.  # noqa: E501

        Permanently delete relation with particular accounting vendor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_accounting_vendor_access_config_is_active_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_accounting_vendor_access_config_is_active_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_accounting_vendor_access_config_is_active_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/vendor/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_accounting_stats(self, **kwargs):  # noqa: E501
        """Get accounting stats from financial statements at the vendor for the business provided  # noqa: E501

        Get accounting stats from financial statements at the vendor for the business provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accounting_stats(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str accounting_method: accounting_method
        :param str nucleus_client_id: nucleus_client_id
        :param str period_length: period_length
        :param int period_month: period_month
        :param int period_quarter: period_quarter
        :param str period_type: period_type
        :param int period_year: period_year
        :param str report: report
        :param datetime statement_date: statement_date
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_accounting_stats_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_accounting_stats_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_accounting_stats_with_http_info(self, **kwargs):  # noqa: E501
        """Get accounting stats from financial statements at the vendor for the business provided  # noqa: E501

        Get accounting stats from financial statements at the vendor for the business provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accounting_stats_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str accounting_method: accounting_method
        :param str nucleus_client_id: nucleus_client_id
        :param str period_length: period_length
        :param int period_month: period_month
        :param int period_quarter: period_quarter
        :param str period_type: period_type
        :param int period_year: period_year
        :param str report: report
        :param datetime statement_date: statement_date
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['accounting_method', 'nucleus_client_id', 'period_length', 'period_month', 'period_quarter', 'period_type', 'period_year', 'report', 'statement_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_accounting_stats" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'accounting_method' in params:
            query_params.append(('accounting_method', params['accounting_method']))  # noqa: E501
        if 'nucleus_client_id' in params:
            query_params.append(('nucleus_client_id', params['nucleus_client_id']))  # noqa: E501
        if 'period_length' in params:
            query_params.append(('period_length', params['period_length']))  # noqa: E501
        if 'period_month' in params:
            query_params.append(('period_month', params['period_month']))  # noqa: E501
        if 'period_quarter' in params:
            query_params.append(('period_quarter', params['period_quarter']))  # noqa: E501
        if 'period_type' in params:
            query_params.append(('period_type', params['period_type']))  # noqa: E501
        if 'period_year' in params:
            query_params.append(('period_year', params['period_year']))  # noqa: E501
        if 'report' in params:
            query_params.append(('report', params['report']))  # noqa: E501
        if 'statement_date' in params:
            query_params.append(('statement_date', params['statement_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/report', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountingFinalResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_accounting_vendor_info_using_client_id(self, nucleus_client_id, **kwargs):  # noqa: E501
        """Get Accounting Vendor Config  # noqa: E501

        Get Accounting vendor config information with its status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accounting_vendor_info_using_client_id(nucleus_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_client_id: nucleus_client_id (required)
        :return: VendorAccessConfigVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_accounting_vendor_info_using_client_id_with_http_info(nucleus_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_accounting_vendor_info_using_client_id_with_http_info(nucleus_client_id, **kwargs)  # noqa: E501
            return data

    def get_accounting_vendor_info_using_client_id_with_http_info(self, nucleus_client_id, **kwargs):  # noqa: E501
        """Get Accounting Vendor Config  # noqa: E501

        Get Accounting vendor config information with its status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accounting_vendor_info_using_client_id_with_http_info(nucleus_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_client_id: nucleus_client_id (required)
        :return: VendorAccessConfigVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_accounting_vendor_info_using_client_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_client_id' is set
        if ('nucleus_client_id' not in params or
                params['nucleus_client_id'] is None):
            raise ValueError("Missing the required parameter `nucleus_client_id` when calling `get_accounting_vendor_info_using_client_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_client_id' in params:
            path_params['nucleus_client_id'] = params['nucleus_client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/vendor/{nucleus_client_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VendorAccessConfigVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_accounting_vendor_access_config_is_active_by_id(self, id, is_active, **kwargs):  # noqa: E501
        """Enable/Disable relation with particular accounting vendor.  # noqa: E501

        Enable/Disable link with particular accounting vendor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_accounting_vendor_access_config_is_active_by_id(id, is_active, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: id (required)
        :param bool is_active: is_active (required)
        :return: VendorAccessConfigVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_accounting_vendor_access_config_is_active_by_id_with_http_info(id, is_active, **kwargs)  # noqa: E501
        else:
            (data) = self.update_accounting_vendor_access_config_is_active_by_id_with_http_info(id, is_active, **kwargs)  # noqa: E501
            return data

    def update_accounting_vendor_access_config_is_active_by_id_with_http_info(self, id, is_active, **kwargs):  # noqa: E501
        """Enable/Disable relation with particular accounting vendor.  # noqa: E501

        Enable/Disable link with particular accounting vendor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_accounting_vendor_access_config_is_active_by_id_with_http_info(id, is_active, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: id (required)
        :param bool is_active: is_active (required)
        :return: VendorAccessConfigVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'is_active']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_accounting_vendor_access_config_is_active_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_accounting_vendor_access_config_is_active_by_id`")  # noqa: E501
        # verify the required parameter 'is_active' is set
        if ('is_active' not in params or
                params['is_active'] is None):
            raise ValueError("Missing the required parameter `is_active` when calling `update_accounting_vendor_access_config_is_active_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'is_active' in params:
            query_params.append(('is_active', params['is_active']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/vendor/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VendorAccessConfigVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer(self, nucleus_customer_id, **kwargs):  # noqa: E501
        """Update customer in Nucleus for a given nucleus_customer_id  # noqa: E501

        Update customer in Nucleus for a given nucleus_customer_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer(nucleus_customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_customer_id: nucleus_customer_id (required)
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_with_http_info(nucleus_customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_with_http_info(nucleus_customer_id, **kwargs)  # noqa: E501
            return data

    def update_customer_with_http_info(self, nucleus_customer_id, **kwargs):  # noqa: E501
        """Update customer in Nucleus for a given nucleus_customer_id  # noqa: E501

        Update customer in Nucleus for a given nucleus_customer_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_with_http_info(nucleus_customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_customer_id: nucleus_customer_id (required)
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_customer_id' is set
        if ('nucleus_customer_id' not in params or
                params['nucleus_customer_id'] is None):
            raise ValueError("Missing the required parameter `nucleus_customer_id` when calling `update_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_customer_id' in params:
            path_params['nucleus_customer_id'] = params['nucleus_customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/customer/{nucleus_customer_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountingFinalResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_invoice(self, nucleus_invoice_id, **kwargs):  # noqa: E501
        """Update invoice in Nucleus for a given nucleus_invoice_id  # noqa: E501

        Update invoice in Nucleus for a given nucleus_invoice_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_invoice(nucleus_invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_invoice_id: nucleus_invoice_id (required)
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_invoice_with_http_info(nucleus_invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_invoice_with_http_info(nucleus_invoice_id, **kwargs)  # noqa: E501
            return data

    def update_invoice_with_http_info(self, nucleus_invoice_id, **kwargs):  # noqa: E501
        """Update invoice in Nucleus for a given nucleus_invoice_id  # noqa: E501

        Update invoice in Nucleus for a given nucleus_invoice_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_invoice_with_http_info(nucleus_invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_invoice_id: nucleus_invoice_id (required)
        :return: AccountingFinalResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_invoice" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_invoice_id' is set
        if ('nucleus_invoice_id' not in params or
                params['nucleus_invoice_id'] is None):
            raise ValueError("Missing the required parameter `nucleus_invoice_id` when calling `update_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_invoice_id' in params:
            path_params['nucleus_invoice_id'] = params['nucleus_invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/invoice/{nucleus_invoice_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountingFinalResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
