# swagger-client
The Hydrogen Integration API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.2.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.hydrogenplatform.com/contact](https://www.hydrogenplatform.com/contact)

## Requirements.

Python 2.7 and 3.4+

### Update Base Path
Follow steps to verify the base URL path:
1. Go to configuration.py file located under integration_api folder.
2. Search for self.host and change/verify the URL according to the environment.
**Sandbox Base URL**
https://sandbox.hydrogenplatform.com/integration/v1
**Production Base URL**
https://api.hydrogenplatform.com/integration/v1


## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com//.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com//.git`)

Then import the package:
```python
import integration_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import integration_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import integration_api
from integration_api.rest import ApiException
from pprint import pprint


# Configure OAuth2 access token for authorization: oauth2
configuration = integration_api.Configuration()

# create an instance of the API class
api_instance = integration_api.AuthApi(integration_api.ApiClient(configuration))

#api_token_response = api_instance.create_using_post_client_credentials("client_id", "password")

# OR

#api_token_response = api_instance.create_using_post_password_credentials("client_id","password", "username", "secret" )

# OR

# api_token_response = api_instance.create_client_token_credentials("client_id", "password", "client_token");


configuration.access_token = api_token_response.access_token

# create an instance of the API class
api_instance = integration_api.ACHApi(integration_api.ApiClient(configuration))
nucleus_funding_id = 'nucleus_funding_id_example' # str | nucleus_funding_id

try:
    # Cancel the ACH transfer
    api_response = api_instance.cancel_ach_transfer_using_delete(nucleus_funding_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ACHApi->cancel_ach_transfer_using_delete: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://sandbox.hydrogenplatform.com/integration/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ACHApi* | [**cancel_ach_transfer_using_delete**](docs/ACHApi.md#cancel_ach_transfer_using_delete) | **DELETE** /ach/{nucleus_funding_id} | Cancel the ACH transfer
*ACHApi* | [**create_ach_card_link_using_post**](docs/ACHApi.md#create_ach_card_link_using_post) | **POST** /ach/card_link | Create an ACH card link
*ACHApi* | [**create_bank_link_using_post**](docs/ACHApi.md#create_bank_link_using_post) | **POST** /ach/bank_link | Create bank link
*ACHApi* | [**create_business_using_post**](docs/ACHApi.md#create_business_using_post) | **POST** /ach/business | Create a business
*ACHApi* | [**create_client_using_post**](docs/ACHApi.md#create_client_using_post) | **POST** /ach/client | Create a client
*ACHApi* | [**delete_bank_link_using_delete**](docs/ACHApi.md#delete_bank_link_using_delete) | **DELETE** /ach/bank_link/{nucleus_bank_link_id} | Delete bank link
*ACHApi* | [**get_ach_transfer_using_get**](docs/ACHApi.md#get_ach_transfer_using_get) | **GET** /ach/{nucleus_funding_id} | Get the ACH transfer
*ACHApi* | [**get_balance_using_get**](docs/ACHApi.md#get_balance_using_get) | **GET** /ach/balance/{portfolio_id} | Get balance
*ACHApi* | [**get_bank_link_using_get**](docs/ACHApi.md#get_bank_link_using_get) | **GET** /ach/bank_link/{nucleus_bank_link_id} | Get bank link
*ACHApi* | [**get_bank_links_for_reserve_account_using_get**](docs/ACHApi.md#get_bank_links_for_reserve_account_using_get) | **GET** /ach/bank_link/reserve | Get bank links for a reserve account
*ACHApi* | [**get_client_bank_links_using_get**](docs/ACHApi.md#get_client_bank_links_using_get) | **GET** /ach/bank_link/client/{nucleus_client_id} | Get client bank links
*ACHApi* | [**get_list_of_client_ach_transfers_using_get**](docs/ACHApi.md#get_list_of_client_ach_transfers_using_get) | **GET** /ach/client/{nucleus_client_id} | Get a list of client&#39;s ACH transfers
*ACHApi* | [**get_list_of_tenant_ach_transfers_using_get**](docs/ACHApi.md#get_list_of_tenant_ach_transfers_using_get) | **GET** /ach | Get a list of tenant&#39;s ACH transfers
*ACHApi* | [**submit_ach_transfer_using_post**](docs/ACHApi.md#submit_ach_transfer_using_post) | **POST** /ach | Submit an ACH transfer
*ACHApi* | [**update_bank_link_using_put**](docs/ACHApi.md#update_bank_link_using_put) | **PUT** /ach/bank_link/{nucleus_bank_link_id} | Update bank link
*AccountingApi* | [**create_or_update_customer**](docs/AccountingApi.md#create_or_update_customer) | **GET** /accounting/customer | Update/Create all customers in Nucleus for a given nucleus_client_id
*AccountingApi* | [**create_or_update_customer_revenue**](docs/AccountingApi.md#create_or_update_customer_revenue) | **GET** /accounting/customer_revenue/{nucleus_customer_id} | Update/Create all customers revenue in Nucleus for a given nucleus_customer_id
*AccountingApi* | [**create_or_update_invoice_payment**](docs/AccountingApi.md#create_or_update_invoice_payment) | **GET** /accounting/invoice_payment/{nucleus_invoice_id} | Create/Update invoice payment in Nucleus for a given nucleus_invoice_id
*AccountingApi* | [**create_or_update_invoices**](docs/AccountingApi.md#create_or_update_invoices) | **GET** /accounting/invoice | Update/Create all invoices in Nucleus for a given nucleus_client_id
*AccountingApi* | [**delete_accounting_vendor_access_config_is_active_by_id**](docs/AccountingApi.md#delete_accounting_vendor_access_config_is_active_by_id) | **DELETE** /accounting/vendor/{id} | Permanently delete relation with particular accounting vendor.
*AccountingApi* | [**get_accounting_stats**](docs/AccountingApi.md#get_accounting_stats) | **GET** /accounting/report | Get accounting stats from financial statements at the vendor for the business provided
*AccountingApi* | [**get_accounting_vendor_info_using_client_id**](docs/AccountingApi.md#get_accounting_vendor_info_using_client_id) | **GET** /accounting/vendor/{nucleus_client_id} | Get Accounting Vendor Config
*AccountingApi* | [**update_accounting_vendor_access_config_is_active_by_id**](docs/AccountingApi.md#update_accounting_vendor_access_config_is_active_by_id) | **PUT** /accounting/vendor/{id} | Enable/Disable relation with particular accounting vendor.
*AccountingApi* | [**update_customer**](docs/AccountingApi.md#update_customer) | **GET** /accounting/customer/{nucleus_customer_id} | Update customer in Nucleus for a given nucleus_customer_id
*AccountingApi* | [**update_invoice**](docs/AccountingApi.md#update_invoice) | **GET** /accounting/invoice/{nucleus_invoice_id} | Update invoice in Nucleus for a given nucleus_invoice_id
*AggregationApi* | [**create_aggregation_account_using_post**](docs/AggregationApi.md#create_aggregation_account_using_post) | **POST** /aggregation/account | Create mapping between client,vendor,tenant
*AggregationApi* | [**create_property_value_using_post**](docs/AggregationApi.md#create_property_value_using_post) | **POST** /property_value | Create mapping between client,vendor,tenant for the property
*AggregationApi* | [**delete_aggregation_account_using_delete**](docs/AggregationApi.md#delete_aggregation_account_using_delete) | **DELETE** /aggregation/account/{nucleus_aggregation_account_id} | De-Link mapping between client,vendor,tenant
*AggregationApi* | [**get_aggregation_account_all_using_get**](docs/AggregationApi.md#get_aggregation_account_all_using_get) | **GET** /aggregation/account | Fetch all aggregation account(s) details with the mapping created in POST endpoint for a client
*AggregationApi* | [**get_aggregation_account_balance_all_using_get**](docs/AggregationApi.md#get_aggregation_account_balance_all_using_get) | **GET** /aggregation/balance | Fetch all aggregation account balance details with for the given aggregation accounts 
*AggregationApi* | [**get_aggregation_account_balance_using_get**](docs/AggregationApi.md#get_aggregation_account_balance_using_get) | **GET** /aggregation/balance/{nucleus_aggregation_account_id} | Fetch aggregation account balance details with the mapping created in POST endpoint
*AggregationApi* | [**get_aggregation_account_holding_all_using_get**](docs/AggregationApi.md#get_aggregation_account_holding_all_using_get) | **GET** /aggregation/holding | Fetch all aggregation account(s) holding details with the mapping created in POST endpoint
*AggregationApi* | [**get_aggregation_account_holding_using_get**](docs/AggregationApi.md#get_aggregation_account_holding_using_get) | **GET** /aggregation/holding/{nucleus_aggregation_account_id} | Fetch aggregation account holding details with the mapping created in POST endpoint
*AggregationApi* | [**get_aggregation_account_transaction_all_using_get**](docs/AggregationApi.md#get_aggregation_account_transaction_all_using_get) | **GET** /aggregation/transaction | Fetch all aggregation account balance details with for the given aggregation accounts 
*AggregationApi* | [**get_aggregation_account_transaction_using_get**](docs/AggregationApi.md#get_aggregation_account_transaction_using_get) | **GET** /aggregation/transaction/{nucleus_aggregation_account_id} | Fetch aggregation account transaction details with the mapping created in POST endpoint
*AggregationApi* | [**get_aggregation_account_using_get**](docs/AggregationApi.md#get_aggregation_account_using_get) | **GET** /aggregation/account/{nucleus_aggregation_account_id} | Fetch aggregation account details with the mapping created in POST endpoint
*AggregationApi* | [**get_property_value**](docs/AggregationApi.md#get_property_value) | **GET** /property_value | Get Value of the given property
*AsyncApi* | [**get_async_data**](docs/AsyncApi.md#get_async_data) | **GET** /async/{integration_type}/{service} | Create async transaction for GET endpoints for bulk data
*AsyncApi* | [**get_async_data1**](docs/AsyncApi.md#get_async_data1) | **GET** /async/{integration_type}/{service}/{id} | Create async transaction for GET endpoints for bulk data
*AsyncApi* | [**get_async_data2**](docs/AsyncApi.md#get_async_data2) | **POST** /async/{integration_type}/{service} | Create async transaction for POST endpoints for bulk data
*AsyncApi* | [**get_async_status**](docs/AsyncApi.md#get_async_status) | **GET** /async/status/{id} | Get Status of async transaction created through GET/POST endpoints
*BaasApi* | [**create_baas_account_using_post**](docs/BaasApi.md#create_baas_account_using_post) | **POST** /baas/account | create a Baas account
*BaasApi* | [**create_baas_business_using_post**](docs/BaasApi.md#create_baas_business_using_post) | **POST** /baas/business | Create a Baas Business
*BaasApi* | [**create_baas_client_using_post**](docs/BaasApi.md#create_baas_client_using_post) | **POST** /baas/client | Create a Baas Client
*BaasApi* | [**create_baas_sub_account_using_post**](docs/BaasApi.md#create_baas_sub_account_using_post) | **POST** /baas/subaccount | create a Baas subaccount
*BaasApi* | [**get_baas_account_statement_using_get**](docs/BaasApi.md#get_baas_account_statement_using_get) | **GET** /baas/statement/{nucleus_account_id} | Get a Baas account statement
*BaasApi* | [**get_baas_portfolio_balance_using_get**](docs/BaasApi.md#get_baas_portfolio_balance_using_get) | **GET** /baas/balance/{nucleus_portfolio_id} | Get a Baas portfolio balance
*BaasApi* | [**get_baas_portfolio_transaction_using_get**](docs/BaasApi.md#get_baas_portfolio_transaction_using_get) | **GET** /baas/transaction/{nucleus_portfolio_id} | Get a Baas portfolio transaction
*BaasApi* | [**update_baas_business_using_put**](docs/BaasApi.md#update_baas_business_using_put) | **PUT** /baas/business/{nucleus_business_id} | Update a Baas business
*BaasApi* | [**update_baas_client_using_put**](docs/BaasApi.md#update_baas_client_using_put) | **PUT** /baas/client/{nucleus_client_id} | Update a Baas client
*BrokerageApi* | [**cancel_order_using_put**](docs/BrokerageApi.md#cancel_order_using_put) | **PUT** /brokerage/order/{nucleus_order_id} | Cancel an Order
*BrokerageApi* | [**create_bank_link_using_post1**](docs/BrokerageApi.md#create_bank_link_using_post1) | **POST** /brokerage/bank_link | create a Bank Link
*BrokerageApi* | [**create_brokerage_account_using_post**](docs/BrokerageApi.md#create_brokerage_account_using_post) | **POST** /brokerage/account | create a Brokerage account
*BrokerageApi* | [**create_brokerage_client_using_post**](docs/BrokerageApi.md#create_brokerage_client_using_post) | **POST** /brokerage/client | Create a Brokerage Client
*BrokerageApi* | [**create_deposit_using_post**](docs/BrokerageApi.md#create_deposit_using_post) | **POST** /brokerage/deposit | Create a deposit
*BrokerageApi* | [**create_document_using_post**](docs/BrokerageApi.md#create_document_using_post) | **POST** /brokerage/document | Create a Brokerage document
*BrokerageApi* | [**create_order_using_post**](docs/BrokerageApi.md#create_order_using_post) | **POST** /brokerage/order | Create an Order
*BrokerageApi* | [**create_withdrawal_using_post**](docs/BrokerageApi.md#create_withdrawal_using_post) | **POST** /brokerage/withdrawal | Create a withdrawal
*BrokerageApi* | [**delete_bank_link_using_delete1**](docs/BrokerageApi.md#delete_bank_link_using_delete1) | **DELETE** /brokerage/bank_link/{nucleus_bank_link_id} | Delete a Bank Link
*BrokerageApi* | [**get_balance_using_get1**](docs/BrokerageApi.md#get_balance_using_get1) | **GET** /brokerage/balance/{nucleus_portfolio_id} | Get account balance
*BrokerageApi* | [**get_bank_link_using_get1**](docs/BrokerageApi.md#get_bank_link_using_get1) | **GET** /brokerage/bank_link/{nucleus_bank_link_id} | Get a Bank Link
*BrokerageApi* | [**get_brokerage_account_statement_using_get**](docs/BrokerageApi.md#get_brokerage_account_statement_using_get) | **GET** /brokerage/statement/{nucleus_account_id} | Get a Brokerage account statement
*BrokerageApi* | [**get_document_using_get**](docs/BrokerageApi.md#get_document_using_get) | **GET** /brokerage/document/{nucleus_document_id} | Get a Brokerage document
*BrokerageApi* | [**get_holding_performance_using_get**](docs/BrokerageApi.md#get_holding_performance_using_get) | **GET** /brokerage/holding/performance/{nucleus_portfolio_id} | Get portfolio holding performance
*BrokerageApi* | [**get_holding_using_get**](docs/BrokerageApi.md#get_holding_using_get) | **GET** /brokerage/holding/{nucleus_portfolio_id} | Get portfolio holdings
*BrokerageApi* | [**get_order_using_get**](docs/BrokerageApi.md#get_order_using_get) | **GET** /brokerage/order/{nucleus_order_id} | Get an Order
*BrokerageApi* | [**get_securities_using_get**](docs/BrokerageApi.md#get_securities_using_get) | **GET** /brokerage/securities | Get securities information
*BrokerageApi* | [**get_transactions_using_get**](docs/BrokerageApi.md#get_transactions_using_get) | **GET** /brokerage/transaction/{nucleus_portfolio_id} | Get account transactions
*BrokerageApi* | [**update_bank_link_using_put1**](docs/BrokerageApi.md#update_bank_link_using_put1) | **PUT** /brokerage/bank_link/{nucleus_bank_link_id} | Update a Bank Link
*BrokerageApi* | [**update_brokerage_client_using_put**](docs/BrokerageApi.md#update_brokerage_client_using_put) | **PUT** /brokerage/client | Update a Brokerage client
*CardApi* | [**create_auto_reload_using_post**](docs/CardApi.md#create_auto_reload_using_post) | **POST** /card/auto_reload | Card auto reload
*CardApi* | [**create_card_activate_using_post**](docs/CardApi.md#create_card_activate_using_post) | **POST** /card/activate | Activate card
*CardApi* | [**create_card_business_using_post**](docs/CardApi.md#create_card_business_using_post) | **POST** /card/business | Create a card business
*CardApi* | [**create_card_close_using_post**](docs/CardApi.md#create_card_close_using_post) | **POST** /card/close | close a card
*CardApi* | [**create_card_issue_using_post**](docs/CardApi.md#create_card_issue_using_post) | **POST** /card/issue | issue a card
*CardApi* | [**create_card_load_using_post**](docs/CardApi.md#create_card_load_using_post) | **POST** /card/load | Create a card load
*CardApi* | [**create_card_pin_using_post**](docs/CardApi.md#create_card_pin_using_post) | **POST** /card/pin | pin card
*CardApi* | [**create_card_reactivate_using_post**](docs/CardApi.md#create_card_reactivate_using_post) | **POST** /card/reactivate | reactivate card
*CardApi* | [**create_card_reissue_using_post**](docs/CardApi.md#create_card_reissue_using_post) | **POST** /card/reissue | Reissue a card
*CardApi* | [**create_card_replace_using_post**](docs/CardApi.md#create_card_replace_using_post) | **POST** /card/replace | Create card replace
*CardApi* | [**create_card_spending_control_using_post**](docs/CardApi.md#create_card_spending_control_using_post) | **POST** /card/spending_control | Create card spending control
*CardApi* | [**create_card_suspend_using_post**](docs/CardApi.md#create_card_suspend_using_post) | **POST** /card/suspend | suspend card
*CardApi* | [**create_card_token_using_post**](docs/CardApi.md#create_card_token_using_post) | **POST** /card/token | token card
*CardApi* | [**create_card_unload_using_post**](docs/CardApi.md#create_card_unload_using_post) | **POST** /card/unload | Create a card upload
*CardApi* | [**create_client_card_using_post**](docs/CardApi.md#create_client_card_using_post) | **POST** /card/client | Create a card client
*CardApi* | [**get_card_balance_using_get**](docs/CardApi.md#get_card_balance_using_get) | **GET** /card/balance/{id} | Get a Card Balance
*CardApi* | [**get_card_image**](docs/CardApi.md#get_card_image) | **GET** /card/image/{card_id} | Get card image
*CardApi* | [**get_card_pci_details**](docs/CardApi.md#get_card_pci_details) | **GET** /card/pci_details/{card_id} | Get card pci details
*CardApi* | [**get_card_reserve_account_details_using_get**](docs/CardApi.md#get_card_reserve_account_details_using_get) | **GET** /card/reserve | Card reserve account
*CardApi* | [**get_card_statement_using_get**](docs/CardApi.md#get_card_statement_using_get) | **GET** /card/statement/{card_id} | Get card statement
*CardApi* | [**get_card_token_using_token**](docs/CardApi.md#get_card_token_using_token) | **GET** /card/token/{id} | Get a card token
*CardApi* | [**get_card_transaction_using_get**](docs/CardApi.md#get_card_transaction_using_get) | **GET** /card/transaction/{id} | Get a card transaction
*CardApi* | [**get_card_using_get**](docs/CardApi.md#get_card_using_get) | **GET** /card/{id} | Get a card information
*CardApi* | [**update_card_business_using_put**](docs/CardApi.md#update_card_business_using_put) | **PUT** /card/business/{nucleus_business_id} | Update a card business
*CardApi* | [**update_card_pin_using_post**](docs/CardApi.md#update_card_pin_using_post) | **PUT** /card/pin/{id} | update a pin card
*CardApi* | [**update_card_spending_control_using_put**](docs/CardApi.md#update_card_spending_control_using_put) | **PUT** /card/spending_control/{nucleus_spending_control_id} | Update a card spending control
*CardApi* | [**update_card_using_put**](docs/CardApi.md#update_card_using_put) | **PUT** /card/{id} | Update a card information
*CardApi* | [**update_client_card_using_put**](docs/CardApi.md#update_client_card_using_put) | **PUT** /card/client/{id} | Update a card client
*CardApi* | [**verify_card_pin_using_post**](docs/CardApi.md#verify_card_pin_using_post) | **POST** /card/pin/verify | verify card pin
*IAVApi* | [**create_iav_using_post**](docs/IAVApi.md#create_iav_using_post) | **POST** /iav | Instant Account Verification of an account.
*IAVApi* | [**get_iav_using_get**](docs/IAVApi.md#get_iav_using_get) | **GET** /iav/{nucleus_bank_link_id} | Get verified account based on id.
*KMSApi* | [**create_kms_using_post**](docs/KMSApi.md#create_kms_using_post) | **POST** /kms | Create an secret key
*KMSApi* | [**delete_kms_using_delete**](docs/KMSApi.md#delete_kms_using_delete) | **DELETE** /kms/{kms_id} | Delete an secret key value
*KMSApi* | [**get_kms_all_using_get**](docs/KMSApi.md#get_kms_all_using_get) | **GET** /kms | List all KMS Clients
*KMSApi* | [**get_kms_using_get**](docs/KMSApi.md#get_kms_using_get) | **GET** /kms/{kms_id} | Retrieve an secret key value
*KMSApi* | [**update_kms_using_put**](docs/KMSApi.md#update_kms_using_put) | **PUT** /kms/{kms_id} | Update an Key Value
*KYCApi* | [**create_kyc_using_post**](docs/KYCApi.md#create_kyc_using_post) | **POST** /kyc | Do kyc for the client.
*KYCApi* | [**get_kyc_status_using_get**](docs/KYCApi.md#get_kyc_status_using_get) | **GET** /kyc_status | Fetch kyc_status for the given nucleus_client_id
*MarketDataApi* | [**create_market_data_historical_using_post**](docs/MarketDataApi.md#create_market_data_historical_using_post) | **POST** /market_data/historical | Create historical market data
*MarketDataApi* | [**create_market_data_quote_using_post**](docs/MarketDataApi.md#create_market_data_quote_using_post) | **POST** /market_data/quote | Create quote market data
*RTPApi* | [**cancel_rtp_transfer_using_delete**](docs/RTPApi.md#cancel_rtp_transfer_using_delete) | **DELETE** /rtp/{nucleus_funding_id} | Cancel the RTP transfer
*RTPApi* | [**create_bank_link_using_post2**](docs/RTPApi.md#create_bank_link_using_post2) | **POST** /rtp/bank_link | Create bank link
*RTPApi* | [**delete_bank_link_using_delete2**](docs/RTPApi.md#delete_bank_link_using_delete2) | **DELETE** /rtp/bank_link/{nucleus_bank_link_id} | Delete bank link
*RTPApi* | [**get_bank_link_using_get2**](docs/RTPApi.md#get_bank_link_using_get2) | **GET** /rtp/bank_link/{nucleus_bank_link_id} | Get bank link
*RTPApi* | [**get_client_bank_links_using_get1**](docs/RTPApi.md#get_client_bank_links_using_get1) | **GET** /rtp/bank_link/client/{nucleus_client_id} | Get client bank links
*RTPApi* | [**get_list_of_rtp_transfers_using_get**](docs/RTPApi.md#get_list_of_rtp_transfers_using_get) | **GET** /rtp/client/{nucleus_client_id} | Get a list of Rtp transfers
*RTPApi* | [**get_rtp_transfer_using_get**](docs/RTPApi.md#get_rtp_transfer_using_get) | **GET** /rtp/{nucleus_funding_id} | Get the RTP transfer
*RTPApi* | [**submit_rtp_transfer_using_post**](docs/RTPApi.md#submit_rtp_transfer_using_post) | **POST** /rtp | Submit a RTP transfer
*RTPApi* | [**update_bank_link_using_put2**](docs/RTPApi.md#update_bank_link_using_put2) | **PUT** /rtp/bank_link/{nucleus_bank_link_id} | Update bank link
*SMSApi* | [**get_vendor_call_limit**](docs/SMSApi.md#get_vendor_call_limit) | **GET** /sms/status/{sms_id} | Fetch details for corresponding sms_id
*SMSApi* | [**send_mail**](docs/SMSApi.md#send_mail) | **POST** /sms | Send SMS to recipient
*SMTPApi* | [**get_email_details**](docs/SMTPApi.md#get_email_details) | **GET** /smtp/status/{email_id} | Fetch details for corresponding email_id
*SMTPApi* | [**send_mail1**](docs/SMTPApi.md#send_mail1) | **POST** /smtp | Send Mail to recipient
*UtilsApi* | [**create_token_exchange_using_post**](docs/UtilsApi.md#create_token_exchange_using_post) | **POST** /token_exchange | Retrieve token based on certain vendor specific value
*UtilsApi* | [**create_user_using_post**](docs/UtilsApi.md#create_user_using_post) | **POST** /user | Create user in vendor
*UtilsApi* | [**get_audit_log_all_using_get**](docs/UtilsApi.md#get_audit_log_all_using_get) | **GET** /audit_log | Gel all audit log
*UtilsApi* | [**get_widget_link_using_get**](docs/UtilsApi.md#get_widget_link_using_get) | **GET** /widget_link/{nucleus_client_id} | Retrieve widget link
*WebhookApi* | [**create_webhook_using_post**](docs/WebhookApi.md#create_webhook_using_post) | **POST** /webhook | Create a webhook
*WebhookApi* | [**delete_webhook_using_delete**](docs/WebhookApi.md#delete_webhook_using_delete) | **DELETE** /webhook/{webhook_id} | Delete a webhook
*WebhookApi* | [**get_webhook_all_using_get**](docs/WebhookApi.md#get_webhook_all_using_get) | **GET** /webhook | List all webhooks
*WebhookApi* | [**get_webhook_using_get**](docs/WebhookApi.md#get_webhook_using_get) | **GET** /webhook/{webhook_id} | Retrieve a webhook
*WebhookApi* | [**update_webhook_using_put**](docs/WebhookApi.md#update_webhook_using_put) | **PUT** /webhook/{webhook_id} | Update a webhook
*WireApi* | [**cancel_wire_transfer_using_delete**](docs/WireApi.md#cancel_wire_transfer_using_delete) | **DELETE** /wire/{nucleus_funding_id} | Cancel the Wire transfer
*WireApi* | [**create_bank_link_using_post3**](docs/WireApi.md#create_bank_link_using_post3) | **POST** /wire/bank_link | Create bank link
*WireApi* | [**delete_bank_link_using_delete3**](docs/WireApi.md#delete_bank_link_using_delete3) | **DELETE** /wire/bank_link/{nucleus_bank_link_id} | Delete bank link
*WireApi* | [**get_bank_link_using_get3**](docs/WireApi.md#get_bank_link_using_get3) | **GET** /wire/bank_link/{nucleus_bank_link_id} | Get bank link
*WireApi* | [**get_client_bank_links_using_get2**](docs/WireApi.md#get_client_bank_links_using_get2) | **GET** /wire/bank_link/client/{nucleus_client_id} | Get client bank links
*WireApi* | [**get_list_of_wire_transfers_using_get**](docs/WireApi.md#get_list_of_wire_transfers_using_get) | **GET** /wire/client/{nucleus_client_id} | Get a list of Wire transfers
*WireApi* | [**get_wire_transfer_using_get**](docs/WireApi.md#get_wire_transfer_using_get) | **GET** /wire/{nucleus_funding_id} | Get the Wire transfer
*WireApi* | [**submit_wire_transfer_using_post**](docs/WireApi.md#submit_wire_transfer_using_post) | **POST** /wire | Submit a Wire transfer
*WireApi* | [**update_bank_link_using_put3**](docs/WireApi.md#update_bank_link_using_put3) | **PUT** /wire/bank_link/{nucleus_bank_link_id} | Update bank link


## Documentation For Models

 - [AccountingCustomerResponseVO](docs/AccountingCustomerResponseVO.md)
 - [AccountingCustomerRevenueResponseVO](docs/AccountingCustomerRevenueResponseVO.md)
 - [AccountingFinalResponseVO](docs/AccountingFinalResponseVO.md)
 - [AccountingInvoicePaymentResponseVO](docs/AccountingInvoicePaymentResponseVO.md)
 - [AccountingInvoiceResponseVO](docs/AccountingInvoiceResponseVO.md)
 - [AccountingStatsResponseVO](docs/AccountingStatsResponseVO.md)
 - [AchBalanceResponseVO](docs/AchBalanceResponseVO.md)
 - [AchBankLinkRequestCO](docs/AchBankLinkRequestCO.md)
 - [AchBankLinkResponseVO](docs/AchBankLinkResponseVO.md)
 - [AchBusinessRequestCO](docs/AchBusinessRequestCO.md)
 - [AchBusinessResponseVO](docs/AchBusinessResponseVO.md)
 - [AchCardLinkRequestCO](docs/AchCardLinkRequestCO.md)
 - [AchCardLinkResponseVO](docs/AchCardLinkResponseVO.md)
 - [AchClientRequestCO](docs/AchClientRequestCO.md)
 - [AchClientResponseVO](docs/AchClientResponseVO.md)
 - [AchTransferRequestCO](docs/AchTransferRequestCO.md)
 - [AchTransferResponseVO](docs/AchTransferResponseVO.md)
 - [Acquiree](docs/Acquiree.md)
 - [Acquirer](docs/Acquirer.md)
 - [Address](docs/Address.md)
 - [AggregationAccount](docs/AggregationAccount.md)
 - [AggregationAccountBalance](docs/AggregationAccountBalance.md)
 - [AggregationAccountBalanceResponseVO](docs/AggregationAccountBalanceResponseVO.md)
 - [AggregationAccountHolding](docs/AggregationAccountHolding.md)
 - [AggregationAccountHoldingResponseInternalObjectVO](docs/AggregationAccountHoldingResponseInternalObjectVO.md)
 - [AggregationAccountHoldingResponseVO](docs/AggregationAccountHoldingResponseVO.md)
 - [AggregationAccountResponseInternalObjectVO](docs/AggregationAccountResponseInternalObjectVO.md)
 - [AggregationAccountResponseVO](docs/AggregationAccountResponseVO.md)
 - [AggregationAccountTransaction](docs/AggregationAccountTransaction.md)
 - [AggregationAccountTransactionResponseInternalObjectVO](docs/AggregationAccountTransactionResponseInternalObjectVO.md)
 - [AggregationAccountTransactionResponseVO](docs/AggregationAccountTransactionResponseVO.md)
 - [AggregationAccountsResponseVO](docs/AggregationAccountsResponseVO.md)
 - [AggregationRequestObject](docs/AggregationRequestObject.md)
 - [AggregationVendorRequestCO](docs/AggregationVendorRequestCO.md)
 - [ApplePayload](docs/ApplePayload.md)
 - [AsyncTransaction](docs/AsyncTransaction.md)
 - [AsyncTransactionVO](docs/AsyncTransactionVO.md)
 - [BaasAccountCO](docs/BaasAccountCO.md)
 - [BaasAccountVO](docs/BaasAccountVO.md)
 - [BaasBalanceVO](docs/BaasBalanceVO.md)
 - [BaasBusinessVO](docs/BaasBusinessVO.md)
 - [BaasClientVO](docs/BaasClientVO.md)
 - [BaasStatementVO](docs/BaasStatementVO.md)
 - [BaasStatementsVO](docs/BaasStatementsVO.md)
 - [BaasSubAccountCO](docs/BaasSubAccountCO.md)
 - [BaasSubAccountVO](docs/BaasSubAccountVO.md)
 - [BaasTransactionsVO](docs/BaasTransactionsVO.md)
 - [BankCredit](docs/BankCredit.md)
 - [BankLink](docs/BankLink.md)
 - [BankLinkResponseInternalObjectVO](docs/BankLinkResponseInternalObjectVO.md)
 - [BankLinkVendorDataVO](docs/BankLinkVendorDataVO.md)
 - [BaseResponseVO](docs/BaseResponseVO.md)
 - [BrokerageAccountCO](docs/BrokerageAccountCO.md)
 - [BrokerageAccountVO](docs/BrokerageAccountVO.md)
 - [BrokerageBalanceVO](docs/BrokerageBalanceVO.md)
 - [BrokerageBankLinkCO](docs/BrokerageBankLinkCO.md)
 - [BrokerageBankLinkVO](docs/BrokerageBankLinkVO.md)
 - [BrokerageClientCO](docs/BrokerageClientCO.md)
 - [BrokerageCreateClientVO](docs/BrokerageCreateClientVO.md)
 - [BrokerageDepositCO](docs/BrokerageDepositCO.md)
 - [BrokerageDepositVO](docs/BrokerageDepositVO.md)
 - [BrokerageDocumentCO](docs/BrokerageDocumentCO.md)
 - [BrokerageDocumentVO](docs/BrokerageDocumentVO.md)
 - [BrokerageHoldingVO](docs/BrokerageHoldingVO.md)
 - [BrokerageOrderCO](docs/BrokerageOrderCO.md)
 - [BrokerageOrderVO](docs/BrokerageOrderVO.md)
 - [BrokeragePerformanceVO](docs/BrokeragePerformanceVO.md)
 - [BrokerageSecuritiesVO](docs/BrokerageSecuritiesVO.md)
 - [BrokerageStatementVO](docs/BrokerageStatementVO.md)
 - [BrokerageTransactionVO](docs/BrokerageTransactionVO.md)
 - [BrokerageUpdateClientVO](docs/BrokerageUpdateClientVO.md)
 - [BrokerageWithdrawalCO](docs/BrokerageWithdrawalCO.md)
 - [BrokerageWithdrawalVO](docs/BrokerageWithdrawalVO.md)
 - [BusinessAddress](docs/BusinessAddress.md)
 - [BusinessVendorRequestDataVO](docs/BusinessVendorRequestDataVO.md)
 - [CardAutoReloadRequestCO](docs/CardAutoReloadRequestCO.md)
 - [CardAutoReloadResponseVO](docs/CardAutoReloadResponseVO.md)
 - [CardBalanceResponseVO](docs/CardBalanceResponseVO.md)
 - [CardBaseRequestCO](docs/CardBaseRequestCO.md)
 - [CardBusinessRequestCO](docs/CardBusinessRequestCO.md)
 - [CardClientRequestCO](docs/CardClientRequestCO.md)
 - [CardLoadRequestCO](docs/CardLoadRequestCO.md)
 - [CardLoadUnloadResponseVO](docs/CardLoadUnloadResponseVO.md)
 - [CardPinRequestCO](docs/CardPinRequestCO.md)
 - [CardReplaceResponseVO](docs/CardReplaceResponseVO.md)
 - [CardReserveAccountResponseVO](docs/CardReserveAccountResponseVO.md)
 - [CardSpendingControlRequestCO](docs/CardSpendingControlRequestCO.md)
 - [CardSpendingControlResponseVO](docs/CardSpendingControlResponseVO.md)
 - [CardTokenRequestCO](docs/CardTokenRequestCO.md)
 - [CardTokenResponseVO](docs/CardTokenResponseVO.md)
 - [CardTransactionResponseVO](docs/CardTransactionResponseVO.md)
 - [CardUnloadRequestCO](docs/CardUnloadRequestCO.md)
 - [CardUpdatePinRequestCO](docs/CardUpdatePinRequestCO.md)
 - [Cash](docs/Cash.md)
 - [ClientAddress](docs/ClientAddress.md)
 - [ClientVendorRequestDataVO](docs/ClientVendorRequestDataVO.md)
 - [CreateBaasBusinessCO](docs/CreateBaasBusinessCO.md)
 - [CreateBaasClientCO](docs/CreateBaasClientCO.md)
 - [CreateBusinessResponseVO](docs/CreateBusinessResponseVO.md)
 - [CreateCardClientResponseVO](docs/CreateCardClientResponseVO.md)
 - [CreateUserRequest](docs/CreateUserRequest.md)
 - [Customer](docs/Customer.md)
 - [CustomerAddress](docs/CustomerAddress.md)
 - [CustomerRevenue](docs/CustomerRevenue.md)
 - [Dividend](docs/Dividend.md)
 - [DividendTax](docs/DividendTax.md)
 - [Email](docs/Email.md)
 - [EmailClick](docs/EmailClick.md)
 - [EmailOpen](docs/EmailOpen.md)
 - [ExchangePublicTokenVO](docs/ExchangePublicTokenVO.md)
 - [ExchangeTokenCO](docs/ExchangeTokenCO.md)
 - [FinancialStatement](docs/FinancialStatement.md)
 - [GetCardImageResponseVO](docs/GetCardImageResponseVO.md)
 - [GetCardPciDetailsResponseVO](docs/GetCardPciDetailsResponseVO.md)
 - [GetCardStatementResponseVO](docs/GetCardStatementResponseVO.md)
 - [GetCardTokenResponseVO](docs/GetCardTokenResponseVO.md)
 - [GetTransactionsResponse](docs/GetTransactionsResponse.md)
 - [GooglePayload](docs/GooglePayload.md)
 - [IavAggregationResponseVo](docs/IavAggregationResponseVo.md)
 - [IavBankLinkResponseVo](docs/IavBankLinkResponseVo.md)
 - [IavRequestCO](docs/IavRequestCO.md)
 - [IavResponseVo](docs/IavResponseVo.md)
 - [IavTokenExchangeVendorResponseVO](docs/IavTokenExchangeVendorResponseVO.md)
 - [IavVendorRequestCO](docs/IavVendorRequestCO.md)
 - [Identification](docs/Identification.md)
 - [Instrument](docs/Instrument.md)
 - [Investment](docs/Investment.md)
 - [Invoice](docs/Invoice.md)
 - [InvoicePayment](docs/InvoicePayment.md)
 - [JsonNode](docs/JsonNode.md)
 - [KmsConfig](docs/KmsConfig.md)
 - [KycRequestCO](docs/KycRequestCO.md)
 - [KycResponseVo](docs/KycResponseVo.md)
 - [KycVendorRequestDataVO](docs/KycVendorRequestDataVO.md)
 - [LineItems](docs/LineItems.md)
 - [Location](docs/Location.md)
 - [Mapstringobject](docs/Mapstringobject.md)
 - [MdHistoryItemVO](docs/MdHistoryItemVO.md)
 - [MdHistoryRequestCO](docs/MdHistoryRequestCO.md)
 - [MdHistoryResponseVO](docs/MdHistoryResponseVO.md)
 - [MdQuoteItemVO](docs/MdQuoteItemVO.md)
 - [MdQuoteRequestCO](docs/MdQuoteRequestCO.md)
 - [MdQuoteResponseVO](docs/MdQuoteResponseVO.md)
 - [MergerAcquisition](docs/MergerAcquisition.md)
 - [NucleusTransferFieldsCO](docs/NucleusTransferFieldsCO.md)
 - [Ownership](docs/Ownership.md)
 - [PageAchTransferResponseVO](docs/PageAchTransferResponseVO.md)
 - [PageKmsConfig](docs/PageKmsConfig.md)
 - [PageWebhook](docs/PageWebhook.md)
 - [Pageobject](docs/Pageobject.md)
 - [PoliticallyExposedPersonDTO](docs/PoliticallyExposedPersonDTO.md)
 - [PortfolioAssetSizeLog](docs/PortfolioAssetSizeLog.md)
 - [PropertyValueResponseVO](docs/PropertyValueResponseVO.md)
 - [ResponseEntity](docs/ResponseEntity.md)
 - [RtpBankLinkRequestCO](docs/RtpBankLinkRequestCO.md)
 - [RtpBankLinkResponseVO](docs/RtpBankLinkResponseVO.md)
 - [RtpTransferRequestCO](docs/RtpTransferRequestCO.md)
 - [RtpTransferResponseVO](docs/RtpTransferResponseVO.md)
 - [SMS](docs/SMS.md)
 - [SMSResponseVO](docs/SMSResponseVO.md)
 - [SMSVO](docs/SMSVO.md)
 - [SamsungPayload](docs/SamsungPayload.md)
 - [SmtpResponseVO](docs/SmtpResponseVO.md)
 - [SmtpVO](docs/SmtpVO.md)
 - [Sort](docs/Sort.md)
 - [SpendingControlVendorRequestDataVO](docs/SpendingControlVendorRequestDataVO.md)
 - [Stat](docs/Stat.md)
 - [Transaction](docs/Transaction.md)
 - [UpdateBaasBusinessCO](docs/UpdateBaasBusinessCO.md)
 - [UpdateBaasClientCO](docs/UpdateBaasClientCO.md)
 - [UpdateBusinessResponseVO](docs/UpdateBusinessResponseVO.md)
 - [UpdateCardClientResponseVO](docs/UpdateCardClientResponseVO.md)
 - [UserResponseInterface](docs/UserResponseInterface.md)
 - [UserResponseVO](docs/UserResponseVO.md)
 - [VendorAccessConfigVO](docs/VendorAccessConfigVO.md)
 - [Webhook](docs/Webhook.md)
 - [WidgetUrlVO](docs/WidgetUrlVO.md)
 - [WireBankLinkRequestCO](docs/WireBankLinkRequestCO.md)
 - [WireBankLinkResponseVO](docs/WireBankLinkResponseVO.md)
 - [WireTransferRequestCO](docs/WireTransferRequestCO.md)
 - [WireTransferResponseVO](docs/WireTransferResponseVO.md)
 - [ZillowPropertyVendorResponseVO](docs/ZillowPropertyVendorResponseVO.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A


## Author

info@hydrogenplatform.com

