import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .Material import Material


@register
class ShaderMaterial(Material):
    """ShaderMaterial

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/materials/ShaderMaterial
    """

    _model_name = Unicode('ShaderMaterialModel').tag(sync=True)

    uniforms = Dict(default_value={}, allow_none=False).tag(sync=True)

    clipping = Bool(False, allow_none=False).tag(sync=True)

    extensions = Dict(default_value={}, allow_none=False).tag(sync=True)

    fog = Bool(False, allow_none=False).tag(sync=True)

    fragmentShader = Unicode('', allow_none=False).tag(sync=True)

    lights = Bool(False, allow_none=False).tag(sync=True)

    linewidth = CFloat(1, allow_none=False).tag(sync=True)

    morphNormals = Bool(False, allow_none=False).tag(sync=True)

    morphTargets = Bool(False, allow_none=False).tag(sync=True)

    flatShading = Bool(False, allow_none=False).tag(sync=True)

    skinning = Bool(False, allow_none=False).tag(sync=True)

    vertexShader = Unicode('', allow_none=False).tag(sync=True)

    wireframe = Bool(False, allow_none=False).tag(sync=True)

    wireframeLinewidth = CFloat(1, allow_none=False).tag(sync=True)

    type = Unicode("ShaderMaterial", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    ShaderMaterial.__signature__ = inspect.signature(ShaderMaterial.__init__)
