import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .Light_autogen import Light


@register
class RectAreaLight(Light):
    """RectAreaLight

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/lights/RectAreaLight
    """

    def __init__(self, **kwargs):
        super(RectAreaLight, self).__init__(**kwargs)

    _model_name = Unicode('RectAreaLightModel').tag(sync=True)

    type = Unicode("RectAreaLight", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    RectAreaLight.__signature__ = inspect.signature(RectAreaLight.__init__)
