import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry

from ..core.BaseGeometry_autogen import BaseGeometry
from ..core.BaseBufferGeometry_autogen import BaseBufferGeometry

@register
class WireframeGeometry(BaseGeometry):
    """WireframeGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/WireframeGeometry
    """

    def __init__(self, geometry=None, **kwargs):
        kwargs['geometry'] = geometry
        super(WireframeGeometry, self).__init__(**kwargs)

    _model_name = Unicode('WireframeGeometryModel').tag(sync=True)

    geometry = Union([
        Instance(BaseGeometry, allow_none=True),
        Instance(BaseBufferGeometry, allow_none=True)
    ]).tag(sync=True, **widget_serialization)

    type = Unicode("WireframeGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    WireframeGeometry.__signature__ = inspect.signature(WireframeGeometry.__init__)
