import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class PolyhedronGeometry(BaseGeometry):
    """PolyhedronGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/PolyhedronGeometry
    """

    def __init__(self, vertices=[], faces=[], radius=1, detail=0, **kwargs):
        kwargs['vertices'] = vertices
        kwargs['faces'] = faces
        kwargs['radius'] = radius
        kwargs['detail'] = detail
        super(PolyhedronGeometry, self).__init__(**kwargs)

    _model_name = Unicode('PolyhedronGeometryModel').tag(sync=True)

    vertices = List().tag(sync=True)

    indices = List().tag(sync=True)

    radius = CFloat(1, allow_none=False).tag(sync=True)

    detail = CFloat(0, allow_none=False).tag(sync=True)

    faces = List().tag(sync=True)

    type = Unicode("PolyhedronGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    PolyhedronGeometry.__signature__ = inspect.signature(PolyhedronGeometry.__init__)
