import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D


@register
class CubeCamera(Object3D):
    """CubeCamera

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/cameras/CubeCamera
    """

    def __init__(self, **kwargs):
        super(CubeCamera, self).__init__(**kwargs)

    _model_name = Unicode('CubeCameraModel').tag(sync=True)

    type = Unicode("CubeCamera", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    CubeCamera.__signature__ = inspect.signature(CubeCamera.__init__)
