# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class OrderItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'accounting_code': 'str',
        'activation_codes': 'list[str]',
        'arbitrary_unit_cost': 'Currency',
        'auto_order_last_rebill_dts': 'str',
        'auto_order_schedule': 'str',
        'barcode': 'str',
        'channel_partner_item_id': 'str',
        'cogs': 'float',
        'component_unit_value': 'float',
        'cost': 'Currency',
        'country_code_of_origin': 'str',
        'customs_description': 'str',
        'description': 'str',
        'discount': 'Currency',
        'discount_quantity': 'float',
        'discount_shipping_weight': 'Weight',
        'distribution_center_code': 'str',
        'edi': 'OrderItemEdi',
        'exclude_coupon': 'bool',
        'free_shipping': 'bool',
        'hazmat': 'bool',
        'height': 'Distance',
        'item_reference_oid': 'int',
        'kit': 'bool',
        'kit_component': 'bool',
        'length': 'Distance',
        'manufacturer_sku': 'str',
        'max_days_time_in_transit': 'int',
        'merchant_item_id': 'str',
        'mix_and_match_group_name': 'str',
        'mix_and_match_group_oid': 'int',
        'no_shipping_discount': 'bool',
        'options': 'list[OrderItemOption]',
        'packed_by_user': 'str',
        'perishable_class': 'str',
        'pricing_tier_name': 'str',
        'properties': 'list[OrderItemProperty]',
        'quantity': 'float',
        'quantity_refunded': 'float',
        'quickbooks_class': 'str',
        'ship_separately': 'bool',
        'shipped_by_user': 'str',
        'shipped_dts': 'str',
        'shipping_status': 'str',
        'special_product_type': 'str',
        'tags': 'list[OrderItemTag]',
        'tax_free': 'bool',
        'tax_product_type': 'str',
        'taxable_cost': 'Currency',
        'total_cost_with_discount': 'Currency',
        'total_refunded': 'Currency',
        'transmitted_to_distribution_center_dts': 'str',
        'unit_cost_with_discount': 'Currency',
        'upsell': 'bool',
        'weight': 'Weight',
        'width': 'Distance'
    }

    attribute_map = {
        'accounting_code': 'accounting_code',
        'activation_codes': 'activation_codes',
        'arbitrary_unit_cost': 'arbitrary_unit_cost',
        'auto_order_last_rebill_dts': 'auto_order_last_rebill_dts',
        'auto_order_schedule': 'auto_order_schedule',
        'barcode': 'barcode',
        'channel_partner_item_id': 'channel_partner_item_id',
        'cogs': 'cogs',
        'component_unit_value': 'component_unit_value',
        'cost': 'cost',
        'country_code_of_origin': 'country_code_of_origin',
        'customs_description': 'customs_description',
        'description': 'description',
        'discount': 'discount',
        'discount_quantity': 'discount_quantity',
        'discount_shipping_weight': 'discount_shipping_weight',
        'distribution_center_code': 'distribution_center_code',
        'edi': 'edi',
        'exclude_coupon': 'exclude_coupon',
        'free_shipping': 'free_shipping',
        'hazmat': 'hazmat',
        'height': 'height',
        'item_reference_oid': 'item_reference_oid',
        'kit': 'kit',
        'kit_component': 'kit_component',
        'length': 'length',
        'manufacturer_sku': 'manufacturer_sku',
        'max_days_time_in_transit': 'max_days_time_in_transit',
        'merchant_item_id': 'merchant_item_id',
        'mix_and_match_group_name': 'mix_and_match_group_name',
        'mix_and_match_group_oid': 'mix_and_match_group_oid',
        'no_shipping_discount': 'no_shipping_discount',
        'options': 'options',
        'packed_by_user': 'packed_by_user',
        'perishable_class': 'perishable_class',
        'pricing_tier_name': 'pricing_tier_name',
        'properties': 'properties',
        'quantity': 'quantity',
        'quantity_refunded': 'quantity_refunded',
        'quickbooks_class': 'quickbooks_class',
        'ship_separately': 'ship_separately',
        'shipped_by_user': 'shipped_by_user',
        'shipped_dts': 'shipped_dts',
        'shipping_status': 'shipping_status',
        'special_product_type': 'special_product_type',
        'tags': 'tags',
        'tax_free': 'tax_free',
        'tax_product_type': 'tax_product_type',
        'taxable_cost': 'taxable_cost',
        'total_cost_with_discount': 'total_cost_with_discount',
        'total_refunded': 'total_refunded',
        'transmitted_to_distribution_center_dts': 'transmitted_to_distribution_center_dts',
        'unit_cost_with_discount': 'unit_cost_with_discount',
        'upsell': 'upsell',
        'weight': 'weight',
        'width': 'width'
    }

    def __init__(self, accounting_code=None, activation_codes=None, arbitrary_unit_cost=None, auto_order_last_rebill_dts=None, auto_order_schedule=None, barcode=None, channel_partner_item_id=None, cogs=None, component_unit_value=None, cost=None, country_code_of_origin=None, customs_description=None, description=None, discount=None, discount_quantity=None, discount_shipping_weight=None, distribution_center_code=None, edi=None, exclude_coupon=None, free_shipping=None, hazmat=None, height=None, item_reference_oid=None, kit=None, kit_component=None, length=None, manufacturer_sku=None, max_days_time_in_transit=None, merchant_item_id=None, mix_and_match_group_name=None, mix_and_match_group_oid=None, no_shipping_discount=None, options=None, packed_by_user=None, perishable_class=None, pricing_tier_name=None, properties=None, quantity=None, quantity_refunded=None, quickbooks_class=None, ship_separately=None, shipped_by_user=None, shipped_dts=None, shipping_status=None, special_product_type=None, tags=None, tax_free=None, tax_product_type=None, taxable_cost=None, total_cost_with_discount=None, total_refunded=None, transmitted_to_distribution_center_dts=None, unit_cost_with_discount=None, upsell=None, weight=None, width=None):  # noqa: E501
        """OrderItem - a model defined in Swagger"""  # noqa: E501

        self._accounting_code = None
        self._activation_codes = None
        self._arbitrary_unit_cost = None
        self._auto_order_last_rebill_dts = None
        self._auto_order_schedule = None
        self._barcode = None
        self._channel_partner_item_id = None
        self._cogs = None
        self._component_unit_value = None
        self._cost = None
        self._country_code_of_origin = None
        self._customs_description = None
        self._description = None
        self._discount = None
        self._discount_quantity = None
        self._discount_shipping_weight = None
        self._distribution_center_code = None
        self._edi = None
        self._exclude_coupon = None
        self._free_shipping = None
        self._hazmat = None
        self._height = None
        self._item_reference_oid = None
        self._kit = None
        self._kit_component = None
        self._length = None
        self._manufacturer_sku = None
        self._max_days_time_in_transit = None
        self._merchant_item_id = None
        self._mix_and_match_group_name = None
        self._mix_and_match_group_oid = None
        self._no_shipping_discount = None
        self._options = None
        self._packed_by_user = None
        self._perishable_class = None
        self._pricing_tier_name = None
        self._properties = None
        self._quantity = None
        self._quantity_refunded = None
        self._quickbooks_class = None
        self._ship_separately = None
        self._shipped_by_user = None
        self._shipped_dts = None
        self._shipping_status = None
        self._special_product_type = None
        self._tags = None
        self._tax_free = None
        self._tax_product_type = None
        self._taxable_cost = None
        self._total_cost_with_discount = None
        self._total_refunded = None
        self._transmitted_to_distribution_center_dts = None
        self._unit_cost_with_discount = None
        self._upsell = None
        self._weight = None
        self._width = None
        self.discriminator = None

        if accounting_code is not None:
            self.accounting_code = accounting_code
        if activation_codes is not None:
            self.activation_codes = activation_codes
        if arbitrary_unit_cost is not None:
            self.arbitrary_unit_cost = arbitrary_unit_cost
        if auto_order_last_rebill_dts is not None:
            self.auto_order_last_rebill_dts = auto_order_last_rebill_dts
        if auto_order_schedule is not None:
            self.auto_order_schedule = auto_order_schedule
        if barcode is not None:
            self.barcode = barcode
        if channel_partner_item_id is not None:
            self.channel_partner_item_id = channel_partner_item_id
        if cogs is not None:
            self.cogs = cogs
        if component_unit_value is not None:
            self.component_unit_value = component_unit_value
        if cost is not None:
            self.cost = cost
        if country_code_of_origin is not None:
            self.country_code_of_origin = country_code_of_origin
        if customs_description is not None:
            self.customs_description = customs_description
        if description is not None:
            self.description = description
        if discount is not None:
            self.discount = discount
        if discount_quantity is not None:
            self.discount_quantity = discount_quantity
        if discount_shipping_weight is not None:
            self.discount_shipping_weight = discount_shipping_weight
        if distribution_center_code is not None:
            self.distribution_center_code = distribution_center_code
        if edi is not None:
            self.edi = edi
        if exclude_coupon is not None:
            self.exclude_coupon = exclude_coupon
        if free_shipping is not None:
            self.free_shipping = free_shipping
        if hazmat is not None:
            self.hazmat = hazmat
        if height is not None:
            self.height = height
        if item_reference_oid is not None:
            self.item_reference_oid = item_reference_oid
        if kit is not None:
            self.kit = kit
        if kit_component is not None:
            self.kit_component = kit_component
        if length is not None:
            self.length = length
        if manufacturer_sku is not None:
            self.manufacturer_sku = manufacturer_sku
        if max_days_time_in_transit is not None:
            self.max_days_time_in_transit = max_days_time_in_transit
        if merchant_item_id is not None:
            self.merchant_item_id = merchant_item_id
        if mix_and_match_group_name is not None:
            self.mix_and_match_group_name = mix_and_match_group_name
        if mix_and_match_group_oid is not None:
            self.mix_and_match_group_oid = mix_and_match_group_oid
        if no_shipping_discount is not None:
            self.no_shipping_discount = no_shipping_discount
        if options is not None:
            self.options = options
        if packed_by_user is not None:
            self.packed_by_user = packed_by_user
        if perishable_class is not None:
            self.perishable_class = perishable_class
        if pricing_tier_name is not None:
            self.pricing_tier_name = pricing_tier_name
        if properties is not None:
            self.properties = properties
        if quantity is not None:
            self.quantity = quantity
        if quantity_refunded is not None:
            self.quantity_refunded = quantity_refunded
        if quickbooks_class is not None:
            self.quickbooks_class = quickbooks_class
        if ship_separately is not None:
            self.ship_separately = ship_separately
        if shipped_by_user is not None:
            self.shipped_by_user = shipped_by_user
        if shipped_dts is not None:
            self.shipped_dts = shipped_dts
        if shipping_status is not None:
            self.shipping_status = shipping_status
        if special_product_type is not None:
            self.special_product_type = special_product_type
        if tags is not None:
            self.tags = tags
        if tax_free is not None:
            self.tax_free = tax_free
        if tax_product_type is not None:
            self.tax_product_type = tax_product_type
        if taxable_cost is not None:
            self.taxable_cost = taxable_cost
        if total_cost_with_discount is not None:
            self.total_cost_with_discount = total_cost_with_discount
        if total_refunded is not None:
            self.total_refunded = total_refunded
        if transmitted_to_distribution_center_dts is not None:
            self.transmitted_to_distribution_center_dts = transmitted_to_distribution_center_dts
        if unit_cost_with_discount is not None:
            self.unit_cost_with_discount = unit_cost_with_discount
        if upsell is not None:
            self.upsell = upsell
        if weight is not None:
            self.weight = weight
        if width is not None:
            self.width = width

    @property
    def accounting_code(self):
        """Gets the accounting_code of this OrderItem.  # noqa: E501

        QuickBooks code  # noqa: E501

        :return: The accounting_code of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._accounting_code

    @accounting_code.setter
    def accounting_code(self, accounting_code):
        """Sets the accounting_code of this OrderItem.

        QuickBooks code  # noqa: E501

        :param accounting_code: The accounting_code of this OrderItem.  # noqa: E501
        :type: str
        """

        self._accounting_code = accounting_code

    @property
    def activation_codes(self):
        """Gets the activation_codes of this OrderItem.  # noqa: E501

        Activation codes assigned to this item  # noqa: E501

        :return: The activation_codes of this OrderItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._activation_codes

    @activation_codes.setter
    def activation_codes(self, activation_codes):
        """Sets the activation_codes of this OrderItem.

        Activation codes assigned to this item  # noqa: E501

        :param activation_codes: The activation_codes of this OrderItem.  # noqa: E501
        :type: list[str]
        """

        self._activation_codes = activation_codes

    @property
    def arbitrary_unit_cost(self):
        """Gets the arbitrary_unit_cost of this OrderItem.  # noqa: E501


        :return: The arbitrary_unit_cost of this OrderItem.  # noqa: E501
        :rtype: Currency
        """
        return self._arbitrary_unit_cost

    @arbitrary_unit_cost.setter
    def arbitrary_unit_cost(self, arbitrary_unit_cost):
        """Sets the arbitrary_unit_cost of this OrderItem.


        :param arbitrary_unit_cost: The arbitrary_unit_cost of this OrderItem.  # noqa: E501
        :type: Currency
        """

        self._arbitrary_unit_cost = arbitrary_unit_cost

    @property
    def auto_order_last_rebill_dts(self):
        """Gets the auto_order_last_rebill_dts of this OrderItem.  # noqa: E501

        Date/time of the last rebill, used only during order insert to help project future rebills  # noqa: E501

        :return: The auto_order_last_rebill_dts of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._auto_order_last_rebill_dts

    @auto_order_last_rebill_dts.setter
    def auto_order_last_rebill_dts(self, auto_order_last_rebill_dts):
        """Sets the auto_order_last_rebill_dts of this OrderItem.

        Date/time of the last rebill, used only during order insert to help project future rebills  # noqa: E501

        :param auto_order_last_rebill_dts: The auto_order_last_rebill_dts of this OrderItem.  # noqa: E501
        :type: str
        """

        self._auto_order_last_rebill_dts = auto_order_last_rebill_dts

    @property
    def auto_order_schedule(self):
        """Gets the auto_order_schedule of this OrderItem.  # noqa: E501

        Auto order schedule, used only during inserts supplying the recurring schedule  # noqa: E501

        :return: The auto_order_schedule of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._auto_order_schedule

    @auto_order_schedule.setter
    def auto_order_schedule(self, auto_order_schedule):
        """Sets the auto_order_schedule of this OrderItem.

        Auto order schedule, used only during inserts supplying the recurring schedule  # noqa: E501

        :param auto_order_schedule: The auto_order_schedule of this OrderItem.  # noqa: E501
        :type: str
        """

        self._auto_order_schedule = auto_order_schedule

    @property
    def barcode(self):
        """Gets the barcode of this OrderItem.  # noqa: E501

        Barcode  # noqa: E501

        :return: The barcode of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._barcode

    @barcode.setter
    def barcode(self, barcode):
        """Sets the barcode of this OrderItem.

        Barcode  # noqa: E501

        :param barcode: The barcode of this OrderItem.  # noqa: E501
        :type: str
        """

        self._barcode = barcode

    @property
    def channel_partner_item_id(self):
        """Gets the channel_partner_item_id of this OrderItem.  # noqa: E501

        Channel partner item id if this order came through a channel partner and the channel partner item id was mapped to an internal item id  # noqa: E501

        :return: The channel_partner_item_id of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._channel_partner_item_id

    @channel_partner_item_id.setter
    def channel_partner_item_id(self, channel_partner_item_id):
        """Sets the channel_partner_item_id of this OrderItem.

        Channel partner item id if this order came through a channel partner and the channel partner item id was mapped to an internal item id  # noqa: E501

        :param channel_partner_item_id: The channel_partner_item_id of this OrderItem.  # noqa: E501
        :type: str
        """
        if channel_partner_item_id is not None and len(channel_partner_item_id) > 30:
            raise ValueError("Invalid value for `channel_partner_item_id`, length must be less than or equal to `30`")  # noqa: E501

        self._channel_partner_item_id = channel_partner_item_id

    @property
    def cogs(self):
        """Gets the cogs of this OrderItem.  # noqa: E501

        Cost of goods sold  # noqa: E501

        :return: The cogs of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._cogs

    @cogs.setter
    def cogs(self, cogs):
        """Sets the cogs of this OrderItem.

        Cost of goods sold  # noqa: E501

        :param cogs: The cogs of this OrderItem.  # noqa: E501
        :type: float
        """

        self._cogs = cogs

    @property
    def component_unit_value(self):
        """Gets the component_unit_value of this OrderItem.  # noqa: E501

        Value of the kit component item  # noqa: E501

        :return: The component_unit_value of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._component_unit_value

    @component_unit_value.setter
    def component_unit_value(self, component_unit_value):
        """Sets the component_unit_value of this OrderItem.

        Value of the kit component item  # noqa: E501

        :param component_unit_value: The component_unit_value of this OrderItem.  # noqa: E501
        :type: float
        """

        self._component_unit_value = component_unit_value

    @property
    def cost(self):
        """Gets the cost of this OrderItem.  # noqa: E501


        :return: The cost of this OrderItem.  # noqa: E501
        :rtype: Currency
        """
        return self._cost

    @cost.setter
    def cost(self, cost):
        """Sets the cost of this OrderItem.


        :param cost: The cost of this OrderItem.  # noqa: E501
        :type: Currency
        """

        self._cost = cost

    @property
    def country_code_of_origin(self):
        """Gets the country_code_of_origin of this OrderItem.  # noqa: E501

        Country of origin (ISO-3166 two letter code)  # noqa: E501

        :return: The country_code_of_origin of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._country_code_of_origin

    @country_code_of_origin.setter
    def country_code_of_origin(self, country_code_of_origin):
        """Sets the country_code_of_origin of this OrderItem.

        Country of origin (ISO-3166 two letter code)  # noqa: E501

        :param country_code_of_origin: The country_code_of_origin of this OrderItem.  # noqa: E501
        :type: str
        """
        if country_code_of_origin is not None and len(country_code_of_origin) > 2:
            raise ValueError("Invalid value for `country_code_of_origin`, length must be less than or equal to `2`")  # noqa: E501

        self._country_code_of_origin = country_code_of_origin

    @property
    def customs_description(self):
        """Gets the customs_description of this OrderItem.  # noqa: E501

        Customs description  # noqa: E501

        :return: The customs_description of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._customs_description

    @customs_description.setter
    def customs_description(self, customs_description):
        """Sets the customs_description of this OrderItem.

        Customs description  # noqa: E501

        :param customs_description: The customs_description of this OrderItem.  # noqa: E501
        :type: str
        """

        self._customs_description = customs_description

    @property
    def description(self):
        """Gets the description of this OrderItem.  # noqa: E501

        Description  # noqa: E501

        :return: The description of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this OrderItem.

        Description  # noqa: E501

        :param description: The description of this OrderItem.  # noqa: E501
        :type: str
        """
        if description is not None and len(description) > 2000:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `2000`")  # noqa: E501

        self._description = description

    @property
    def discount(self):
        """Gets the discount of this OrderItem.  # noqa: E501


        :return: The discount of this OrderItem.  # noqa: E501
        :rtype: Currency
        """
        return self._discount

    @discount.setter
    def discount(self, discount):
        """Sets the discount of this OrderItem.


        :param discount: The discount of this OrderItem.  # noqa: E501
        :type: Currency
        """

        self._discount = discount

    @property
    def discount_quantity(self):
        """Gets the discount_quantity of this OrderItem.  # noqa: E501

        Discount quantity  # noqa: E501

        :return: The discount_quantity of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._discount_quantity

    @discount_quantity.setter
    def discount_quantity(self, discount_quantity):
        """Sets the discount_quantity of this OrderItem.

        Discount quantity  # noqa: E501

        :param discount_quantity: The discount_quantity of this OrderItem.  # noqa: E501
        :type: float
        """

        self._discount_quantity = discount_quantity

    @property
    def discount_shipping_weight(self):
        """Gets the discount_shipping_weight of this OrderItem.  # noqa: E501


        :return: The discount_shipping_weight of this OrderItem.  # noqa: E501
        :rtype: Weight
        """
        return self._discount_shipping_weight

    @discount_shipping_weight.setter
    def discount_shipping_weight(self, discount_shipping_weight):
        """Sets the discount_shipping_weight of this OrderItem.


        :param discount_shipping_weight: The discount_shipping_weight of this OrderItem.  # noqa: E501
        :type: Weight
        """

        self._discount_shipping_weight = discount_shipping_weight

    @property
    def distribution_center_code(self):
        """Gets the distribution_center_code of this OrderItem.  # noqa: E501

        Distribution center code responsible for shipping this item  # noqa: E501

        :return: The distribution_center_code of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._distribution_center_code

    @distribution_center_code.setter
    def distribution_center_code(self, distribution_center_code):
        """Sets the distribution_center_code of this OrderItem.

        Distribution center code responsible for shipping this item  # noqa: E501

        :param distribution_center_code: The distribution_center_code of this OrderItem.  # noqa: E501
        :type: str
        """

        self._distribution_center_code = distribution_center_code

    @property
    def edi(self):
        """Gets the edi of this OrderItem.  # noqa: E501


        :return: The edi of this OrderItem.  # noqa: E501
        :rtype: OrderItemEdi
        """
        return self._edi

    @edi.setter
    def edi(self, edi):
        """Sets the edi of this OrderItem.


        :param edi: The edi of this OrderItem.  # noqa: E501
        :type: OrderItemEdi
        """

        self._edi = edi

    @property
    def exclude_coupon(self):
        """Gets the exclude_coupon of this OrderItem.  # noqa: E501

        True if this item is excluded from coupons  # noqa: E501

        :return: The exclude_coupon of this OrderItem.  # noqa: E501
        :rtype: bool
        """
        return self._exclude_coupon

    @exclude_coupon.setter
    def exclude_coupon(self, exclude_coupon):
        """Sets the exclude_coupon of this OrderItem.

        True if this item is excluded from coupons  # noqa: E501

        :param exclude_coupon: The exclude_coupon of this OrderItem.  # noqa: E501
        :type: bool
        """

        self._exclude_coupon = exclude_coupon

    @property
    def free_shipping(self):
        """Gets the free_shipping of this OrderItem.  # noqa: E501

        True if the item receives free shipping  # noqa: E501

        :return: The free_shipping of this OrderItem.  # noqa: E501
        :rtype: bool
        """
        return self._free_shipping

    @free_shipping.setter
    def free_shipping(self, free_shipping):
        """Sets the free_shipping of this OrderItem.

        True if the item receives free shipping  # noqa: E501

        :param free_shipping: The free_shipping of this OrderItem.  # noqa: E501
        :type: bool
        """

        self._free_shipping = free_shipping

    @property
    def hazmat(self):
        """Gets the hazmat of this OrderItem.  # noqa: E501

        Hazardous materials indicator  # noqa: E501

        :return: The hazmat of this OrderItem.  # noqa: E501
        :rtype: bool
        """
        return self._hazmat

    @hazmat.setter
    def hazmat(self, hazmat):
        """Sets the hazmat of this OrderItem.

        Hazardous materials indicator  # noqa: E501

        :param hazmat: The hazmat of this OrderItem.  # noqa: E501
        :type: bool
        """

        self._hazmat = hazmat

    @property
    def height(self):
        """Gets the height of this OrderItem.  # noqa: E501


        :return: The height of this OrderItem.  # noqa: E501
        :rtype: Distance
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this OrderItem.


        :param height: The height of this OrderItem.  # noqa: E501
        :type: Distance
        """

        self._height = height

    @property
    def item_reference_oid(self):
        """Gets the item_reference_oid of this OrderItem.  # noqa: E501

        Item reference object identifier used to linked to auto order item record  # noqa: E501

        :return: The item_reference_oid of this OrderItem.  # noqa: E501
        :rtype: int
        """
        return self._item_reference_oid

    @item_reference_oid.setter
    def item_reference_oid(self, item_reference_oid):
        """Sets the item_reference_oid of this OrderItem.

        Item reference object identifier used to linked to auto order item record  # noqa: E501

        :param item_reference_oid: The item_reference_oid of this OrderItem.  # noqa: E501
        :type: int
        """

        self._item_reference_oid = item_reference_oid

    @property
    def kit(self):
        """Gets the kit of this OrderItem.  # noqa: E501

        True if this item is a kit  # noqa: E501

        :return: The kit of this OrderItem.  # noqa: E501
        :rtype: bool
        """
        return self._kit

    @kit.setter
    def kit(self, kit):
        """Sets the kit of this OrderItem.

        True if this item is a kit  # noqa: E501

        :param kit: The kit of this OrderItem.  # noqa: E501
        :type: bool
        """

        self._kit = kit

    @property
    def kit_component(self):
        """Gets the kit_component of this OrderItem.  # noqa: E501

        True if this item is a kit component  # noqa: E501

        :return: The kit_component of this OrderItem.  # noqa: E501
        :rtype: bool
        """
        return self._kit_component

    @kit_component.setter
    def kit_component(self, kit_component):
        """Sets the kit_component of this OrderItem.

        True if this item is a kit component  # noqa: E501

        :param kit_component: The kit_component of this OrderItem.  # noqa: E501
        :type: bool
        """

        self._kit_component = kit_component

    @property
    def length(self):
        """Gets the length of this OrderItem.  # noqa: E501


        :return: The length of this OrderItem.  # noqa: E501
        :rtype: Distance
        """
        return self._length

    @length.setter
    def length(self, length):
        """Sets the length of this OrderItem.


        :param length: The length of this OrderItem.  # noqa: E501
        :type: Distance
        """

        self._length = length

    @property
    def manufacturer_sku(self):
        """Gets the manufacturer_sku of this OrderItem.  # noqa: E501

        Manufacturer SKU  # noqa: E501

        :return: The manufacturer_sku of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._manufacturer_sku

    @manufacturer_sku.setter
    def manufacturer_sku(self, manufacturer_sku):
        """Sets the manufacturer_sku of this OrderItem.

        Manufacturer SKU  # noqa: E501

        :param manufacturer_sku: The manufacturer_sku of this OrderItem.  # noqa: E501
        :type: str
        """

        self._manufacturer_sku = manufacturer_sku

    @property
    def max_days_time_in_transit(self):
        """Gets the max_days_time_in_transit of this OrderItem.  # noqa: E501

        Maximum days that the item can be in transit before spoilage (perishable products)  # noqa: E501

        :return: The max_days_time_in_transit of this OrderItem.  # noqa: E501
        :rtype: int
        """
        return self._max_days_time_in_transit

    @max_days_time_in_transit.setter
    def max_days_time_in_transit(self, max_days_time_in_transit):
        """Sets the max_days_time_in_transit of this OrderItem.

        Maximum days that the item can be in transit before spoilage (perishable products)  # noqa: E501

        :param max_days_time_in_transit: The max_days_time_in_transit of this OrderItem.  # noqa: E501
        :type: int
        """

        self._max_days_time_in_transit = max_days_time_in_transit

    @property
    def merchant_item_id(self):
        """Gets the merchant_item_id of this OrderItem.  # noqa: E501

        Item ID  # noqa: E501

        :return: The merchant_item_id of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._merchant_item_id

    @merchant_item_id.setter
    def merchant_item_id(self, merchant_item_id):
        """Sets the merchant_item_id of this OrderItem.

        Item ID  # noqa: E501

        :param merchant_item_id: The merchant_item_id of this OrderItem.  # noqa: E501
        :type: str
        """
        if merchant_item_id is not None and len(merchant_item_id) > 20:
            raise ValueError("Invalid value for `merchant_item_id`, length must be less than or equal to `20`")  # noqa: E501

        self._merchant_item_id = merchant_item_id

    @property
    def mix_and_match_group_name(self):
        """Gets the mix_and_match_group_name of this OrderItem.  # noqa: E501

        Mix and match group name  # noqa: E501

        :return: The mix_and_match_group_name of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._mix_and_match_group_name

    @mix_and_match_group_name.setter
    def mix_and_match_group_name(self, mix_and_match_group_name):
        """Sets the mix_and_match_group_name of this OrderItem.

        Mix and match group name  # noqa: E501

        :param mix_and_match_group_name: The mix_and_match_group_name of this OrderItem.  # noqa: E501
        :type: str
        """

        self._mix_and_match_group_name = mix_and_match_group_name

    @property
    def mix_and_match_group_oid(self):
        """Gets the mix_and_match_group_oid of this OrderItem.  # noqa: E501

        Mix and match group object identifier  # noqa: E501

        :return: The mix_and_match_group_oid of this OrderItem.  # noqa: E501
        :rtype: int
        """
        return self._mix_and_match_group_oid

    @mix_and_match_group_oid.setter
    def mix_and_match_group_oid(self, mix_and_match_group_oid):
        """Sets the mix_and_match_group_oid of this OrderItem.

        Mix and match group object identifier  # noqa: E501

        :param mix_and_match_group_oid: The mix_and_match_group_oid of this OrderItem.  # noqa: E501
        :type: int
        """

        self._mix_and_match_group_oid = mix_and_match_group_oid

    @property
    def no_shipping_discount(self):
        """Gets the no_shipping_discount of this OrderItem.  # noqa: E501

        True if this item is excluded from shipping discounts  # noqa: E501

        :return: The no_shipping_discount of this OrderItem.  # noqa: E501
        :rtype: bool
        """
        return self._no_shipping_discount

    @no_shipping_discount.setter
    def no_shipping_discount(self, no_shipping_discount):
        """Sets the no_shipping_discount of this OrderItem.

        True if this item is excluded from shipping discounts  # noqa: E501

        :param no_shipping_discount: The no_shipping_discount of this OrderItem.  # noqa: E501
        :type: bool
        """

        self._no_shipping_discount = no_shipping_discount

    @property
    def options(self):
        """Gets the options of this OrderItem.  # noqa: E501

        Options  # noqa: E501

        :return: The options of this OrderItem.  # noqa: E501
        :rtype: list[OrderItemOption]
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this OrderItem.

        Options  # noqa: E501

        :param options: The options of this OrderItem.  # noqa: E501
        :type: list[OrderItemOption]
        """

        self._options = options

    @property
    def packed_by_user(self):
        """Gets the packed_by_user of this OrderItem.  # noqa: E501

        Packed by user  # noqa: E501

        :return: The packed_by_user of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._packed_by_user

    @packed_by_user.setter
    def packed_by_user(self, packed_by_user):
        """Sets the packed_by_user of this OrderItem.

        Packed by user  # noqa: E501

        :param packed_by_user: The packed_by_user of this OrderItem.  # noqa: E501
        :type: str
        """

        self._packed_by_user = packed_by_user

    @property
    def perishable_class(self):
        """Gets the perishable_class of this OrderItem.  # noqa: E501

        Perishable class of the item  # noqa: E501

        :return: The perishable_class of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._perishable_class

    @perishable_class.setter
    def perishable_class(self, perishable_class):
        """Sets the perishable_class of this OrderItem.

        Perishable class of the item  # noqa: E501

        :param perishable_class: The perishable_class of this OrderItem.  # noqa: E501
        :type: str
        """
        if perishable_class is not None and len(perishable_class) > 50:
            raise ValueError("Invalid value for `perishable_class`, length must be less than or equal to `50`")  # noqa: E501

        self._perishable_class = perishable_class

    @property
    def pricing_tier_name(self):
        """Gets the pricing_tier_name of this OrderItem.  # noqa: E501

        Pricing tier that granted the particular price for this item if the customer profile had pricing tiers assigned  # noqa: E501

        :return: The pricing_tier_name of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._pricing_tier_name

    @pricing_tier_name.setter
    def pricing_tier_name(self, pricing_tier_name):
        """Sets the pricing_tier_name of this OrderItem.

        Pricing tier that granted the particular price for this item if the customer profile had pricing tiers assigned  # noqa: E501

        :param pricing_tier_name: The pricing_tier_name of this OrderItem.  # noqa: E501
        :type: str
        """

        self._pricing_tier_name = pricing_tier_name

    @property
    def properties(self):
        """Gets the properties of this OrderItem.  # noqa: E501

        Properties  # noqa: E501

        :return: The properties of this OrderItem.  # noqa: E501
        :rtype: list[OrderItemProperty]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this OrderItem.

        Properties  # noqa: E501

        :param properties: The properties of this OrderItem.  # noqa: E501
        :type: list[OrderItemProperty]
        """

        self._properties = properties

    @property
    def quantity(self):
        """Gets the quantity of this OrderItem.  # noqa: E501

        Quantity  # noqa: E501

        :return: The quantity of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this OrderItem.

        Quantity  # noqa: E501

        :param quantity: The quantity of this OrderItem.  # noqa: E501
        :type: float
        """

        self._quantity = quantity

    @property
    def quantity_refunded(self):
        """Gets the quantity_refunded of this OrderItem.  # noqa: E501

        Quantity refunded on this item (read only except refund operation)  # noqa: E501

        :return: The quantity_refunded of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._quantity_refunded

    @quantity_refunded.setter
    def quantity_refunded(self, quantity_refunded):
        """Sets the quantity_refunded of this OrderItem.

        Quantity refunded on this item (read only except refund operation)  # noqa: E501

        :param quantity_refunded: The quantity_refunded of this OrderItem.  # noqa: E501
        :type: float
        """

        self._quantity_refunded = quantity_refunded

    @property
    def quickbooks_class(self):
        """Gets the quickbooks_class of this OrderItem.  # noqa: E501

        QuickBooks class  # noqa: E501

        :return: The quickbooks_class of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._quickbooks_class

    @quickbooks_class.setter
    def quickbooks_class(self, quickbooks_class):
        """Sets the quickbooks_class of this OrderItem.

        QuickBooks class  # noqa: E501

        :param quickbooks_class: The quickbooks_class of this OrderItem.  # noqa: E501
        :type: str
        """
        if quickbooks_class is not None and len(quickbooks_class) > 31:
            raise ValueError("Invalid value for `quickbooks_class`, length must be less than or equal to `31`")  # noqa: E501

        self._quickbooks_class = quickbooks_class

    @property
    def ship_separately(self):
        """Gets the ship_separately of this OrderItem.  # noqa: E501

        True if this item ships in a separate box  # noqa: E501

        :return: The ship_separately of this OrderItem.  # noqa: E501
        :rtype: bool
        """
        return self._ship_separately

    @ship_separately.setter
    def ship_separately(self, ship_separately):
        """Sets the ship_separately of this OrderItem.

        True if this item ships in a separate box  # noqa: E501

        :param ship_separately: The ship_separately of this OrderItem.  # noqa: E501
        :type: bool
        """

        self._ship_separately = ship_separately

    @property
    def shipped_by_user(self):
        """Gets the shipped_by_user of this OrderItem.  # noqa: E501

        Shipped by user  # noqa: E501

        :return: The shipped_by_user of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._shipped_by_user

    @shipped_by_user.setter
    def shipped_by_user(self, shipped_by_user):
        """Sets the shipped_by_user of this OrderItem.

        Shipped by user  # noqa: E501

        :param shipped_by_user: The shipped_by_user of this OrderItem.  # noqa: E501
        :type: str
        """

        self._shipped_by_user = shipped_by_user

    @property
    def shipped_dts(self):
        """Gets the shipped_dts of this OrderItem.  # noqa: E501

        Date/time that this item was marked shipped  # noqa: E501

        :return: The shipped_dts of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._shipped_dts

    @shipped_dts.setter
    def shipped_dts(self, shipped_dts):
        """Sets the shipped_dts of this OrderItem.

        Date/time that this item was marked shipped  # noqa: E501

        :param shipped_dts: The shipped_dts of this OrderItem.  # noqa: E501
        :type: str
        """

        self._shipped_dts = shipped_dts

    @property
    def shipping_status(self):
        """Gets the shipping_status of this OrderItem.  # noqa: E501

        Shipping status for this item.  This is the replacement for the old order level shipping status.  # noqa: E501

        :return: The shipping_status of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._shipping_status

    @shipping_status.setter
    def shipping_status(self, shipping_status):
        """Sets the shipping_status of this OrderItem.

        Shipping status for this item.  This is the replacement for the old order level shipping status.  # noqa: E501

        :param shipping_status: The shipping_status of this OrderItem.  # noqa: E501
        :type: str
        """

        self._shipping_status = shipping_status

    @property
    def special_product_type(self):
        """Gets the special_product_type of this OrderItem.  # noqa: E501

        Special product type (USPS Media Mail)  # noqa: E501

        :return: The special_product_type of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._special_product_type

    @special_product_type.setter
    def special_product_type(self, special_product_type):
        """Sets the special_product_type of this OrderItem.

        Special product type (USPS Media Mail)  # noqa: E501

        :param special_product_type: The special_product_type of this OrderItem.  # noqa: E501
        :type: str
        """

        self._special_product_type = special_product_type

    @property
    def tags(self):
        """Gets the tags of this OrderItem.  # noqa: E501

        Tags  # noqa: E501

        :return: The tags of this OrderItem.  # noqa: E501
        :rtype: list[OrderItemTag]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this OrderItem.

        Tags  # noqa: E501

        :param tags: The tags of this OrderItem.  # noqa: E501
        :type: list[OrderItemTag]
        """

        self._tags = tags

    @property
    def tax_free(self):
        """Gets the tax_free of this OrderItem.  # noqa: E501

        True if the item is tax free  # noqa: E501

        :return: The tax_free of this OrderItem.  # noqa: E501
        :rtype: bool
        """
        return self._tax_free

    @tax_free.setter
    def tax_free(self, tax_free):
        """Sets the tax_free of this OrderItem.

        True if the item is tax free  # noqa: E501

        :param tax_free: The tax_free of this OrderItem.  # noqa: E501
        :type: bool
        """

        self._tax_free = tax_free

    @property
    def tax_product_type(self):
        """Gets the tax_product_type of this OrderItem.  # noqa: E501

        Type of product for tax purposes (self or UltraCart Managed taxes)  # noqa: E501

        :return: The tax_product_type of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._tax_product_type

    @tax_product_type.setter
    def tax_product_type(self, tax_product_type):
        """Sets the tax_product_type of this OrderItem.

        Type of product for tax purposes (self or UltraCart Managed taxes)  # noqa: E501

        :param tax_product_type: The tax_product_type of this OrderItem.  # noqa: E501
        :type: str
        """
        allowed_values = ["", "digital", "physical", "service"]  # noqa: E501
        if tax_product_type not in allowed_values:
            raise ValueError(
                "Invalid value for `tax_product_type` ({0}), must be one of {1}"  # noqa: E501
                .format(tax_product_type, allowed_values)
            )

        self._tax_product_type = tax_product_type

    @property
    def taxable_cost(self):
        """Gets the taxable_cost of this OrderItem.  # noqa: E501


        :return: The taxable_cost of this OrderItem.  # noqa: E501
        :rtype: Currency
        """
        return self._taxable_cost

    @taxable_cost.setter
    def taxable_cost(self, taxable_cost):
        """Sets the taxable_cost of this OrderItem.


        :param taxable_cost: The taxable_cost of this OrderItem.  # noqa: E501
        :type: Currency
        """

        self._taxable_cost = taxable_cost

    @property
    def total_cost_with_discount(self):
        """Gets the total_cost_with_discount of this OrderItem.  # noqa: E501


        :return: The total_cost_with_discount of this OrderItem.  # noqa: E501
        :rtype: Currency
        """
        return self._total_cost_with_discount

    @total_cost_with_discount.setter
    def total_cost_with_discount(self, total_cost_with_discount):
        """Sets the total_cost_with_discount of this OrderItem.


        :param total_cost_with_discount: The total_cost_with_discount of this OrderItem.  # noqa: E501
        :type: Currency
        """

        self._total_cost_with_discount = total_cost_with_discount

    @property
    def total_refunded(self):
        """Gets the total_refunded of this OrderItem.  # noqa: E501


        :return: The total_refunded of this OrderItem.  # noqa: E501
        :rtype: Currency
        """
        return self._total_refunded

    @total_refunded.setter
    def total_refunded(self, total_refunded):
        """Sets the total_refunded of this OrderItem.


        :param total_refunded: The total_refunded of this OrderItem.  # noqa: E501
        :type: Currency
        """

        self._total_refunded = total_refunded

    @property
    def transmitted_to_distribution_center_dts(self):
        """Gets the transmitted_to_distribution_center_dts of this OrderItem.  # noqa: E501

        Date/time that this item was transmitted to the distribution center  # noqa: E501

        :return: The transmitted_to_distribution_center_dts of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._transmitted_to_distribution_center_dts

    @transmitted_to_distribution_center_dts.setter
    def transmitted_to_distribution_center_dts(self, transmitted_to_distribution_center_dts):
        """Sets the transmitted_to_distribution_center_dts of this OrderItem.

        Date/time that this item was transmitted to the distribution center  # noqa: E501

        :param transmitted_to_distribution_center_dts: The transmitted_to_distribution_center_dts of this OrderItem.  # noqa: E501
        :type: str
        """

        self._transmitted_to_distribution_center_dts = transmitted_to_distribution_center_dts

    @property
    def unit_cost_with_discount(self):
        """Gets the unit_cost_with_discount of this OrderItem.  # noqa: E501


        :return: The unit_cost_with_discount of this OrderItem.  # noqa: E501
        :rtype: Currency
        """
        return self._unit_cost_with_discount

    @unit_cost_with_discount.setter
    def unit_cost_with_discount(self, unit_cost_with_discount):
        """Sets the unit_cost_with_discount of this OrderItem.


        :param unit_cost_with_discount: The unit_cost_with_discount of this OrderItem.  # noqa: E501
        :type: Currency
        """

        self._unit_cost_with_discount = unit_cost_with_discount

    @property
    def upsell(self):
        """Gets the upsell of this OrderItem.  # noqa: E501

        True if this item was added to the order as part of an upsell  # noqa: E501

        :return: The upsell of this OrderItem.  # noqa: E501
        :rtype: bool
        """
        return self._upsell

    @upsell.setter
    def upsell(self, upsell):
        """Sets the upsell of this OrderItem.

        True if this item was added to the order as part of an upsell  # noqa: E501

        :param upsell: The upsell of this OrderItem.  # noqa: E501
        :type: bool
        """

        self._upsell = upsell

    @property
    def weight(self):
        """Gets the weight of this OrderItem.  # noqa: E501


        :return: The weight of this OrderItem.  # noqa: E501
        :rtype: Weight
        """
        return self._weight

    @weight.setter
    def weight(self, weight):
        """Sets the weight of this OrderItem.


        :param weight: The weight of this OrderItem.  # noqa: E501
        :type: Weight
        """

        self._weight = weight

    @property
    def width(self):
        """Gets the width of this OrderItem.  # noqa: E501


        :return: The width of this OrderItem.  # noqa: E501
        :rtype: Distance
        """
        return self._width

    @width.setter
    def width(self, width):
        """Sets the width of this OrderItem.


        :param width: The width of this OrderItem.  # noqa: E501
        :type: Distance
        """

        self._width = width

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrderItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
