# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Customer(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'activity': 'CustomerActivity',
        'affiliate_oid': 'int',
        'allow_3rd_party_billing': 'bool',
        'allow_cod': 'bool',
        'allow_drop_shipping': 'bool',
        'allow_purchase_order': 'bool',
        'allow_quote_request': 'bool',
        'allow_selection_of_address_type': 'bool',
        'attachments': 'list[CustomerAttachment]',
        'auto_approve_cod': 'bool',
        'auto_approve_purchase_order': 'bool',
        'automatic_merchant_notes': 'str',
        'billing': 'list[CustomerBilling]',
        'business_notes': 'str',
        'cards': 'list[CustomerCard]',
        'cc_emails': 'list[CustomerEmail]',
        'customer_profile_oid': 'int',
        'dhl_account_number': 'str',
        'dhl_duty_account_number': 'str',
        'email': 'str',
        'exempt_shipping_handling_charge': 'bool',
        'fedex_account_number': 'str',
        'free_shipping': 'bool',
        'free_shipping_minimum': 'float',
        'last_modified_by': 'str',
        'last_modified_dts': 'str',
        'loyalty': 'CustomerLoyalty',
        'maximum_item_count': 'int',
        'minimum_item_count': 'int',
        'minimum_subtotal': 'float',
        'no_coupons': 'bool',
        'no_free_shipping': 'bool',
        'no_realtime_charge': 'bool',
        'orders': 'list[Order]',
        'orders_summary': 'CustomerOrdersSummary',
        'password': 'str',
        'pricing_tiers': 'list[CustomerPricingTier]',
        'privacy': 'CustomerPrivacy',
        'qb_class': 'str',
        'qb_code': 'str',
        'quotes': 'list[Order]',
        'quotes_summary': 'CustomerQuotesSummary',
        'referral_source': 'str',
        'reviewer': 'CustomerReviewer',
        'sales_rep_code': 'str',
        'send_signup_notification': 'bool',
        'shipping': 'list[CustomerShipping]',
        'signup_dts': 'str',
        'software_entitlements': 'list[CustomerSoftwareEntitlement]',
        'suppress_buysafe': 'bool',
        'tags': 'list[CustomerTag]',
        'tax_codes': 'CustomerTaxCodes',
        'tax_exempt': 'bool',
        'tax_id': 'str',
        'terms': 'str',
        'track_separately': 'bool',
        'unapproved': 'bool',
        'ups_account_number': 'str',
        'website_url': 'str'
    }

    attribute_map = {
        'activity': 'activity',
        'affiliate_oid': 'affiliate_oid',
        'allow_3rd_party_billing': 'allow_3rd_party_billing',
        'allow_cod': 'allow_cod',
        'allow_drop_shipping': 'allow_drop_shipping',
        'allow_purchase_order': 'allow_purchase_order',
        'allow_quote_request': 'allow_quote_request',
        'allow_selection_of_address_type': 'allow_selection_of_address_type',
        'attachments': 'attachments',
        'auto_approve_cod': 'auto_approve_cod',
        'auto_approve_purchase_order': 'auto_approve_purchase_order',
        'automatic_merchant_notes': 'automatic_merchant_notes',
        'billing': 'billing',
        'business_notes': 'business_notes',
        'cards': 'cards',
        'cc_emails': 'cc_emails',
        'customer_profile_oid': 'customer_profile_oid',
        'dhl_account_number': 'dhl_account_number',
        'dhl_duty_account_number': 'dhl_duty_account_number',
        'email': 'email',
        'exempt_shipping_handling_charge': 'exempt_shipping_handling_charge',
        'fedex_account_number': 'fedex_account_number',
        'free_shipping': 'free_shipping',
        'free_shipping_minimum': 'free_shipping_minimum',
        'last_modified_by': 'last_modified_by',
        'last_modified_dts': 'last_modified_dts',
        'loyalty': 'loyalty',
        'maximum_item_count': 'maximum_item_count',
        'minimum_item_count': 'minimum_item_count',
        'minimum_subtotal': 'minimum_subtotal',
        'no_coupons': 'no_coupons',
        'no_free_shipping': 'no_free_shipping',
        'no_realtime_charge': 'no_realtime_charge',
        'orders': 'orders',
        'orders_summary': 'orders_summary',
        'password': 'password',
        'pricing_tiers': 'pricing_tiers',
        'privacy': 'privacy',
        'qb_class': 'qb_class',
        'qb_code': 'qb_code',
        'quotes': 'quotes',
        'quotes_summary': 'quotes_summary',
        'referral_source': 'referral_source',
        'reviewer': 'reviewer',
        'sales_rep_code': 'sales_rep_code',
        'send_signup_notification': 'send_signup_notification',
        'shipping': 'shipping',
        'signup_dts': 'signup_dts',
        'software_entitlements': 'software_entitlements',
        'suppress_buysafe': 'suppress_buysafe',
        'tags': 'tags',
        'tax_codes': 'tax_codes',
        'tax_exempt': 'tax_exempt',
        'tax_id': 'tax_id',
        'terms': 'terms',
        'track_separately': 'track_separately',
        'unapproved': 'unapproved',
        'ups_account_number': 'ups_account_number',
        'website_url': 'website_url'
    }

    def __init__(self, activity=None, affiliate_oid=None, allow_3rd_party_billing=None, allow_cod=None, allow_drop_shipping=None, allow_purchase_order=None, allow_quote_request=None, allow_selection_of_address_type=None, attachments=None, auto_approve_cod=None, auto_approve_purchase_order=None, automatic_merchant_notes=None, billing=None, business_notes=None, cards=None, cc_emails=None, customer_profile_oid=None, dhl_account_number=None, dhl_duty_account_number=None, email=None, exempt_shipping_handling_charge=None, fedex_account_number=None, free_shipping=None, free_shipping_minimum=None, last_modified_by=None, last_modified_dts=None, loyalty=None, maximum_item_count=None, minimum_item_count=None, minimum_subtotal=None, no_coupons=None, no_free_shipping=None, no_realtime_charge=None, orders=None, orders_summary=None, password=None, pricing_tiers=None, privacy=None, qb_class=None, qb_code=None, quotes=None, quotes_summary=None, referral_source=None, reviewer=None, sales_rep_code=None, send_signup_notification=None, shipping=None, signup_dts=None, software_entitlements=None, suppress_buysafe=None, tags=None, tax_codes=None, tax_exempt=None, tax_id=None, terms=None, track_separately=None, unapproved=None, ups_account_number=None, website_url=None):  # noqa: E501
        """Customer - a model defined in Swagger"""  # noqa: E501

        self._activity = None
        self._affiliate_oid = None
        self._allow_3rd_party_billing = None
        self._allow_cod = None
        self._allow_drop_shipping = None
        self._allow_purchase_order = None
        self._allow_quote_request = None
        self._allow_selection_of_address_type = None
        self._attachments = None
        self._auto_approve_cod = None
        self._auto_approve_purchase_order = None
        self._automatic_merchant_notes = None
        self._billing = None
        self._business_notes = None
        self._cards = None
        self._cc_emails = None
        self._customer_profile_oid = None
        self._dhl_account_number = None
        self._dhl_duty_account_number = None
        self._email = None
        self._exempt_shipping_handling_charge = None
        self._fedex_account_number = None
        self._free_shipping = None
        self._free_shipping_minimum = None
        self._last_modified_by = None
        self._last_modified_dts = None
        self._loyalty = None
        self._maximum_item_count = None
        self._minimum_item_count = None
        self._minimum_subtotal = None
        self._no_coupons = None
        self._no_free_shipping = None
        self._no_realtime_charge = None
        self._orders = None
        self._orders_summary = None
        self._password = None
        self._pricing_tiers = None
        self._privacy = None
        self._qb_class = None
        self._qb_code = None
        self._quotes = None
        self._quotes_summary = None
        self._referral_source = None
        self._reviewer = None
        self._sales_rep_code = None
        self._send_signup_notification = None
        self._shipping = None
        self._signup_dts = None
        self._software_entitlements = None
        self._suppress_buysafe = None
        self._tags = None
        self._tax_codes = None
        self._tax_exempt = None
        self._tax_id = None
        self._terms = None
        self._track_separately = None
        self._unapproved = None
        self._ups_account_number = None
        self._website_url = None
        self.discriminator = None

        if activity is not None:
            self.activity = activity
        if affiliate_oid is not None:
            self.affiliate_oid = affiliate_oid
        if allow_3rd_party_billing is not None:
            self.allow_3rd_party_billing = allow_3rd_party_billing
        if allow_cod is not None:
            self.allow_cod = allow_cod
        if allow_drop_shipping is not None:
            self.allow_drop_shipping = allow_drop_shipping
        if allow_purchase_order is not None:
            self.allow_purchase_order = allow_purchase_order
        if allow_quote_request is not None:
            self.allow_quote_request = allow_quote_request
        if allow_selection_of_address_type is not None:
            self.allow_selection_of_address_type = allow_selection_of_address_type
        if attachments is not None:
            self.attachments = attachments
        if auto_approve_cod is not None:
            self.auto_approve_cod = auto_approve_cod
        if auto_approve_purchase_order is not None:
            self.auto_approve_purchase_order = auto_approve_purchase_order
        if automatic_merchant_notes is not None:
            self.automatic_merchant_notes = automatic_merchant_notes
        if billing is not None:
            self.billing = billing
        if business_notes is not None:
            self.business_notes = business_notes
        if cards is not None:
            self.cards = cards
        if cc_emails is not None:
            self.cc_emails = cc_emails
        if customer_profile_oid is not None:
            self.customer_profile_oid = customer_profile_oid
        if dhl_account_number is not None:
            self.dhl_account_number = dhl_account_number
        if dhl_duty_account_number is not None:
            self.dhl_duty_account_number = dhl_duty_account_number
        if email is not None:
            self.email = email
        if exempt_shipping_handling_charge is not None:
            self.exempt_shipping_handling_charge = exempt_shipping_handling_charge
        if fedex_account_number is not None:
            self.fedex_account_number = fedex_account_number
        if free_shipping is not None:
            self.free_shipping = free_shipping
        if free_shipping_minimum is not None:
            self.free_shipping_minimum = free_shipping_minimum
        if last_modified_by is not None:
            self.last_modified_by = last_modified_by
        if last_modified_dts is not None:
            self.last_modified_dts = last_modified_dts
        if loyalty is not None:
            self.loyalty = loyalty
        if maximum_item_count is not None:
            self.maximum_item_count = maximum_item_count
        if minimum_item_count is not None:
            self.minimum_item_count = minimum_item_count
        if minimum_subtotal is not None:
            self.minimum_subtotal = minimum_subtotal
        if no_coupons is not None:
            self.no_coupons = no_coupons
        if no_free_shipping is not None:
            self.no_free_shipping = no_free_shipping
        if no_realtime_charge is not None:
            self.no_realtime_charge = no_realtime_charge
        if orders is not None:
            self.orders = orders
        if orders_summary is not None:
            self.orders_summary = orders_summary
        if password is not None:
            self.password = password
        if pricing_tiers is not None:
            self.pricing_tiers = pricing_tiers
        if privacy is not None:
            self.privacy = privacy
        if qb_class is not None:
            self.qb_class = qb_class
        if qb_code is not None:
            self.qb_code = qb_code
        if quotes is not None:
            self.quotes = quotes
        if quotes_summary is not None:
            self.quotes_summary = quotes_summary
        if referral_source is not None:
            self.referral_source = referral_source
        if reviewer is not None:
            self.reviewer = reviewer
        if sales_rep_code is not None:
            self.sales_rep_code = sales_rep_code
        if send_signup_notification is not None:
            self.send_signup_notification = send_signup_notification
        if shipping is not None:
            self.shipping = shipping
        if signup_dts is not None:
            self.signup_dts = signup_dts
        if software_entitlements is not None:
            self.software_entitlements = software_entitlements
        if suppress_buysafe is not None:
            self.suppress_buysafe = suppress_buysafe
        if tags is not None:
            self.tags = tags
        if tax_codes is not None:
            self.tax_codes = tax_codes
        if tax_exempt is not None:
            self.tax_exempt = tax_exempt
        if tax_id is not None:
            self.tax_id = tax_id
        if terms is not None:
            self.terms = terms
        if track_separately is not None:
            self.track_separately = track_separately
        if unapproved is not None:
            self.unapproved = unapproved
        if ups_account_number is not None:
            self.ups_account_number = ups_account_number
        if website_url is not None:
            self.website_url = website_url

    @property
    def activity(self):
        """Gets the activity of this Customer.  # noqa: E501


        :return: The activity of this Customer.  # noqa: E501
        :rtype: CustomerActivity
        """
        return self._activity

    @activity.setter
    def activity(self, activity):
        """Sets the activity of this Customer.


        :param activity: The activity of this Customer.  # noqa: E501
        :type: CustomerActivity
        """

        self._activity = activity

    @property
    def affiliate_oid(self):
        """Gets the affiliate_oid of this Customer.  # noqa: E501

        Affiliate oid  # noqa: E501

        :return: The affiliate_oid of this Customer.  # noqa: E501
        :rtype: int
        """
        return self._affiliate_oid

    @affiliate_oid.setter
    def affiliate_oid(self, affiliate_oid):
        """Sets the affiliate_oid of this Customer.

        Affiliate oid  # noqa: E501

        :param affiliate_oid: The affiliate_oid of this Customer.  # noqa: E501
        :type: int
        """

        self._affiliate_oid = affiliate_oid

    @property
    def allow_3rd_party_billing(self):
        """Gets the allow_3rd_party_billing of this Customer.  # noqa: E501

        Allow 3rd party billing  # noqa: E501

        :return: The allow_3rd_party_billing of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._allow_3rd_party_billing

    @allow_3rd_party_billing.setter
    def allow_3rd_party_billing(self, allow_3rd_party_billing):
        """Sets the allow_3rd_party_billing of this Customer.

        Allow 3rd party billing  # noqa: E501

        :param allow_3rd_party_billing: The allow_3rd_party_billing of this Customer.  # noqa: E501
        :type: bool
        """

        self._allow_3rd_party_billing = allow_3rd_party_billing

    @property
    def allow_cod(self):
        """Gets the allow_cod of this Customer.  # noqa: E501

        Allow COD  # noqa: E501

        :return: The allow_cod of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._allow_cod

    @allow_cod.setter
    def allow_cod(self, allow_cod):
        """Sets the allow_cod of this Customer.

        Allow COD  # noqa: E501

        :param allow_cod: The allow_cod of this Customer.  # noqa: E501
        :type: bool
        """

        self._allow_cod = allow_cod

    @property
    def allow_drop_shipping(self):
        """Gets the allow_drop_shipping of this Customer.  # noqa: E501

        Allow Drop Shipping  # noqa: E501

        :return: The allow_drop_shipping of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._allow_drop_shipping

    @allow_drop_shipping.setter
    def allow_drop_shipping(self, allow_drop_shipping):
        """Sets the allow_drop_shipping of this Customer.

        Allow Drop Shipping  # noqa: E501

        :param allow_drop_shipping: The allow_drop_shipping of this Customer.  # noqa: E501
        :type: bool
        """

        self._allow_drop_shipping = allow_drop_shipping

    @property
    def allow_purchase_order(self):
        """Gets the allow_purchase_order of this Customer.  # noqa: E501

        Allow purchase orders by this customer  # noqa: E501

        :return: The allow_purchase_order of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._allow_purchase_order

    @allow_purchase_order.setter
    def allow_purchase_order(self, allow_purchase_order):
        """Sets the allow_purchase_order of this Customer.

        Allow purchase orders by this customer  # noqa: E501

        :param allow_purchase_order: The allow_purchase_order of this Customer.  # noqa: E501
        :type: bool
        """

        self._allow_purchase_order = allow_purchase_order

    @property
    def allow_quote_request(self):
        """Gets the allow_quote_request of this Customer.  # noqa: E501

        Allow quote request  # noqa: E501

        :return: The allow_quote_request of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._allow_quote_request

    @allow_quote_request.setter
    def allow_quote_request(self, allow_quote_request):
        """Sets the allow_quote_request of this Customer.

        Allow quote request  # noqa: E501

        :param allow_quote_request: The allow_quote_request of this Customer.  # noqa: E501
        :type: bool
        """

        self._allow_quote_request = allow_quote_request

    @property
    def allow_selection_of_address_type(self):
        """Gets the allow_selection_of_address_type of this Customer.  # noqa: E501

        Allow selection of residential or business address type  # noqa: E501

        :return: The allow_selection_of_address_type of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._allow_selection_of_address_type

    @allow_selection_of_address_type.setter
    def allow_selection_of_address_type(self, allow_selection_of_address_type):
        """Sets the allow_selection_of_address_type of this Customer.

        Allow selection of residential or business address type  # noqa: E501

        :param allow_selection_of_address_type: The allow_selection_of_address_type of this Customer.  # noqa: E501
        :type: bool
        """

        self._allow_selection_of_address_type = allow_selection_of_address_type

    @property
    def attachments(self):
        """Gets the attachments of this Customer.  # noqa: E501

        Attachments  # noqa: E501

        :return: The attachments of this Customer.  # noqa: E501
        :rtype: list[CustomerAttachment]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this Customer.

        Attachments  # noqa: E501

        :param attachments: The attachments of this Customer.  # noqa: E501
        :type: list[CustomerAttachment]
        """

        self._attachments = attachments

    @property
    def auto_approve_cod(self):
        """Gets the auto_approve_cod of this Customer.  # noqa: E501

        Auto approve COD  # noqa: E501

        :return: The auto_approve_cod of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._auto_approve_cod

    @auto_approve_cod.setter
    def auto_approve_cod(self, auto_approve_cod):
        """Sets the auto_approve_cod of this Customer.

        Auto approve COD  # noqa: E501

        :param auto_approve_cod: The auto_approve_cod of this Customer.  # noqa: E501
        :type: bool
        """

        self._auto_approve_cod = auto_approve_cod

    @property
    def auto_approve_purchase_order(self):
        """Gets the auto_approve_purchase_order of this Customer.  # noqa: E501

        Auto approve purchase orders by this customer  # noqa: E501

        :return: The auto_approve_purchase_order of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._auto_approve_purchase_order

    @auto_approve_purchase_order.setter
    def auto_approve_purchase_order(self, auto_approve_purchase_order):
        """Sets the auto_approve_purchase_order of this Customer.

        Auto approve purchase orders by this customer  # noqa: E501

        :param auto_approve_purchase_order: The auto_approve_purchase_order of this Customer.  # noqa: E501
        :type: bool
        """

        self._auto_approve_purchase_order = auto_approve_purchase_order

    @property
    def automatic_merchant_notes(self):
        """Gets the automatic_merchant_notes of this Customer.  # noqa: E501

        Automatic merchant notes are added to every order placed  # noqa: E501

        :return: The automatic_merchant_notes of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._automatic_merchant_notes

    @automatic_merchant_notes.setter
    def automatic_merchant_notes(self, automatic_merchant_notes):
        """Sets the automatic_merchant_notes of this Customer.

        Automatic merchant notes are added to every order placed  # noqa: E501

        :param automatic_merchant_notes: The automatic_merchant_notes of this Customer.  # noqa: E501
        :type: str
        """

        self._automatic_merchant_notes = automatic_merchant_notes

    @property
    def billing(self):
        """Gets the billing of this Customer.  # noqa: E501

        Billing addresses for this customer  # noqa: E501

        :return: The billing of this Customer.  # noqa: E501
        :rtype: list[CustomerBilling]
        """
        return self._billing

    @billing.setter
    def billing(self, billing):
        """Sets the billing of this Customer.

        Billing addresses for this customer  # noqa: E501

        :param billing: The billing of this Customer.  # noqa: E501
        :type: list[CustomerBilling]
        """

        self._billing = billing

    @property
    def business_notes(self):
        """Gets the business_notes of this Customer.  # noqa: E501

        Business notes (internally visible only)  # noqa: E501

        :return: The business_notes of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._business_notes

    @business_notes.setter
    def business_notes(self, business_notes):
        """Sets the business_notes of this Customer.

        Business notes (internally visible only)  # noqa: E501

        :param business_notes: The business_notes of this Customer.  # noqa: E501
        :type: str
        """
        if business_notes is not None and len(business_notes) > 2000:
            raise ValueError("Invalid value for `business_notes`, length must be less than or equal to `2000`")  # noqa: E501

        self._business_notes = business_notes

    @property
    def cards(self):
        """Gets the cards of this Customer.  # noqa: E501

        Credit Cards for this customer  # noqa: E501

        :return: The cards of this Customer.  # noqa: E501
        :rtype: list[CustomerCard]
        """
        return self._cards

    @cards.setter
    def cards(self, cards):
        """Sets the cards of this Customer.

        Credit Cards for this customer  # noqa: E501

        :param cards: The cards of this Customer.  # noqa: E501
        :type: list[CustomerCard]
        """

        self._cards = cards

    @property
    def cc_emails(self):
        """Gets the cc_emails of this Customer.  # noqa: E501

        Additional emails to CC notification  # noqa: E501

        :return: The cc_emails of this Customer.  # noqa: E501
        :rtype: list[CustomerEmail]
        """
        return self._cc_emails

    @cc_emails.setter
    def cc_emails(self, cc_emails):
        """Sets the cc_emails of this Customer.

        Additional emails to CC notification  # noqa: E501

        :param cc_emails: The cc_emails of this Customer.  # noqa: E501
        :type: list[CustomerEmail]
        """

        self._cc_emails = cc_emails

    @property
    def customer_profile_oid(self):
        """Gets the customer_profile_oid of this Customer.  # noqa: E501

        Customer profile object identifier  # noqa: E501

        :return: The customer_profile_oid of this Customer.  # noqa: E501
        :rtype: int
        """
        return self._customer_profile_oid

    @customer_profile_oid.setter
    def customer_profile_oid(self, customer_profile_oid):
        """Sets the customer_profile_oid of this Customer.

        Customer profile object identifier  # noqa: E501

        :param customer_profile_oid: The customer_profile_oid of this Customer.  # noqa: E501
        :type: int
        """

        self._customer_profile_oid = customer_profile_oid

    @property
    def dhl_account_number(self):
        """Gets the dhl_account_number of this Customer.  # noqa: E501

        DHL account number  # noqa: E501

        :return: The dhl_account_number of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._dhl_account_number

    @dhl_account_number.setter
    def dhl_account_number(self, dhl_account_number):
        """Sets the dhl_account_number of this Customer.

        DHL account number  # noqa: E501

        :param dhl_account_number: The dhl_account_number of this Customer.  # noqa: E501
        :type: str
        """
        if dhl_account_number is not None and len(dhl_account_number) > 20:
            raise ValueError("Invalid value for `dhl_account_number`, length must be less than or equal to `20`")  # noqa: E501

        self._dhl_account_number = dhl_account_number

    @property
    def dhl_duty_account_number(self):
        """Gets the dhl_duty_account_number of this Customer.  # noqa: E501

        DHL duty account number  # noqa: E501

        :return: The dhl_duty_account_number of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._dhl_duty_account_number

    @dhl_duty_account_number.setter
    def dhl_duty_account_number(self, dhl_duty_account_number):
        """Sets the dhl_duty_account_number of this Customer.

        DHL duty account number  # noqa: E501

        :param dhl_duty_account_number: The dhl_duty_account_number of this Customer.  # noqa: E501
        :type: str
        """
        if dhl_duty_account_number is not None and len(dhl_duty_account_number) > 20:
            raise ValueError("Invalid value for `dhl_duty_account_number`, length must be less than or equal to `20`")  # noqa: E501

        self._dhl_duty_account_number = dhl_duty_account_number

    @property
    def email(self):
        """Gets the email of this Customer.  # noqa: E501

        Email address of this customer profile  # noqa: E501

        :return: The email of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Customer.

        Email address of this customer profile  # noqa: E501

        :param email: The email of this Customer.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def exempt_shipping_handling_charge(self):
        """Gets the exempt_shipping_handling_charge of this Customer.  # noqa: E501

        Exempt shipping handling charge  # noqa: E501

        :return: The exempt_shipping_handling_charge of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._exempt_shipping_handling_charge

    @exempt_shipping_handling_charge.setter
    def exempt_shipping_handling_charge(self, exempt_shipping_handling_charge):
        """Sets the exempt_shipping_handling_charge of this Customer.

        Exempt shipping handling charge  # noqa: E501

        :param exempt_shipping_handling_charge: The exempt_shipping_handling_charge of this Customer.  # noqa: E501
        :type: bool
        """

        self._exempt_shipping_handling_charge = exempt_shipping_handling_charge

    @property
    def fedex_account_number(self):
        """Gets the fedex_account_number of this Customer.  # noqa: E501

        FedEx account number  # noqa: E501

        :return: The fedex_account_number of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._fedex_account_number

    @fedex_account_number.setter
    def fedex_account_number(self, fedex_account_number):
        """Sets the fedex_account_number of this Customer.

        FedEx account number  # noqa: E501

        :param fedex_account_number: The fedex_account_number of this Customer.  # noqa: E501
        :type: str
        """
        if fedex_account_number is not None and len(fedex_account_number) > 20:
            raise ValueError("Invalid value for `fedex_account_number`, length must be less than or equal to `20`")  # noqa: E501

        self._fedex_account_number = fedex_account_number

    @property
    def free_shipping(self):
        """Gets the free_shipping of this Customer.  # noqa: E501

        This customer always receives free shipping  # noqa: E501

        :return: The free_shipping of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._free_shipping

    @free_shipping.setter
    def free_shipping(self, free_shipping):
        """Sets the free_shipping of this Customer.

        This customer always receives free shipping  # noqa: E501

        :param free_shipping: The free_shipping of this Customer.  # noqa: E501
        :type: bool
        """

        self._free_shipping = free_shipping

    @property
    def free_shipping_minimum(self):
        """Gets the free_shipping_minimum of this Customer.  # noqa: E501

        If free_shipping is true, this is the minimum subtotal required for free shipping  # noqa: E501

        :return: The free_shipping_minimum of this Customer.  # noqa: E501
        :rtype: float
        """
        return self._free_shipping_minimum

    @free_shipping_minimum.setter
    def free_shipping_minimum(self, free_shipping_minimum):
        """Sets the free_shipping_minimum of this Customer.

        If free_shipping is true, this is the minimum subtotal required for free shipping  # noqa: E501

        :param free_shipping_minimum: The free_shipping_minimum of this Customer.  # noqa: E501
        :type: float
        """

        self._free_shipping_minimum = free_shipping_minimum

    @property
    def last_modified_by(self):
        """Gets the last_modified_by of this Customer.  # noqa: E501

        Last modified by  # noqa: E501

        :return: The last_modified_by of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by):
        """Sets the last_modified_by of this Customer.

        Last modified by  # noqa: E501

        :param last_modified_by: The last_modified_by of this Customer.  # noqa: E501
        :type: str
        """
        if last_modified_by is not None and len(last_modified_by) > 100:
            raise ValueError("Invalid value for `last_modified_by`, length must be less than or equal to `100`")  # noqa: E501

        self._last_modified_by = last_modified_by

    @property
    def last_modified_dts(self):
        """Gets the last_modified_dts of this Customer.  # noqa: E501

        Last modified date  # noqa: E501

        :return: The last_modified_dts of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_dts

    @last_modified_dts.setter
    def last_modified_dts(self, last_modified_dts):
        """Sets the last_modified_dts of this Customer.

        Last modified date  # noqa: E501

        :param last_modified_dts: The last_modified_dts of this Customer.  # noqa: E501
        :type: str
        """

        self._last_modified_dts = last_modified_dts

    @property
    def loyalty(self):
        """Gets the loyalty of this Customer.  # noqa: E501


        :return: The loyalty of this Customer.  # noqa: E501
        :rtype: CustomerLoyalty
        """
        return self._loyalty

    @loyalty.setter
    def loyalty(self, loyalty):
        """Sets the loyalty of this Customer.


        :param loyalty: The loyalty of this Customer.  # noqa: E501
        :type: CustomerLoyalty
        """

        self._loyalty = loyalty

    @property
    def maximum_item_count(self):
        """Gets the maximum_item_count of this Customer.  # noqa: E501

        Maximum item count  # noqa: E501

        :return: The maximum_item_count of this Customer.  # noqa: E501
        :rtype: int
        """
        return self._maximum_item_count

    @maximum_item_count.setter
    def maximum_item_count(self, maximum_item_count):
        """Sets the maximum_item_count of this Customer.

        Maximum item count  # noqa: E501

        :param maximum_item_count: The maximum_item_count of this Customer.  # noqa: E501
        :type: int
        """

        self._maximum_item_count = maximum_item_count

    @property
    def minimum_item_count(self):
        """Gets the minimum_item_count of this Customer.  # noqa: E501

        Minimum item count  # noqa: E501

        :return: The minimum_item_count of this Customer.  # noqa: E501
        :rtype: int
        """
        return self._minimum_item_count

    @minimum_item_count.setter
    def minimum_item_count(self, minimum_item_count):
        """Sets the minimum_item_count of this Customer.

        Minimum item count  # noqa: E501

        :param minimum_item_count: The minimum_item_count of this Customer.  # noqa: E501
        :type: int
        """

        self._minimum_item_count = minimum_item_count

    @property
    def minimum_subtotal(self):
        """Gets the minimum_subtotal of this Customer.  # noqa: E501

        Minimum subtotal  # noqa: E501

        :return: The minimum_subtotal of this Customer.  # noqa: E501
        :rtype: float
        """
        return self._minimum_subtotal

    @minimum_subtotal.setter
    def minimum_subtotal(self, minimum_subtotal):
        """Sets the minimum_subtotal of this Customer.

        Minimum subtotal  # noqa: E501

        :param minimum_subtotal: The minimum_subtotal of this Customer.  # noqa: E501
        :type: float
        """

        self._minimum_subtotal = minimum_subtotal

    @property
    def no_coupons(self):
        """Gets the no_coupons of this Customer.  # noqa: E501

        No coupons  # noqa: E501

        :return: The no_coupons of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._no_coupons

    @no_coupons.setter
    def no_coupons(self, no_coupons):
        """Sets the no_coupons of this Customer.

        No coupons  # noqa: E501

        :param no_coupons: The no_coupons of this Customer.  # noqa: E501
        :type: bool
        """

        self._no_coupons = no_coupons

    @property
    def no_free_shipping(self):
        """Gets the no_free_shipping of this Customer.  # noqa: E501

        No free shipping regardless of coupons or item level settings  # noqa: E501

        :return: The no_free_shipping of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._no_free_shipping

    @no_free_shipping.setter
    def no_free_shipping(self, no_free_shipping):
        """Sets the no_free_shipping of this Customer.

        No free shipping regardless of coupons or item level settings  # noqa: E501

        :param no_free_shipping: The no_free_shipping of this Customer.  # noqa: E501
        :type: bool
        """

        self._no_free_shipping = no_free_shipping

    @property
    def no_realtime_charge(self):
        """Gets the no_realtime_charge of this Customer.  # noqa: E501

        No realtime charge  # noqa: E501

        :return: The no_realtime_charge of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._no_realtime_charge

    @no_realtime_charge.setter
    def no_realtime_charge(self, no_realtime_charge):
        """Sets the no_realtime_charge of this Customer.

        No realtime charge  # noqa: E501

        :param no_realtime_charge: The no_realtime_charge of this Customer.  # noqa: E501
        :type: bool
        """

        self._no_realtime_charge = no_realtime_charge

    @property
    def orders(self):
        """Gets the orders of this Customer.  # noqa: E501

        Orders associated with this customer profile  # noqa: E501

        :return: The orders of this Customer.  # noqa: E501
        :rtype: list[Order]
        """
        return self._orders

    @orders.setter
    def orders(self, orders):
        """Sets the orders of this Customer.

        Orders associated with this customer profile  # noqa: E501

        :param orders: The orders of this Customer.  # noqa: E501
        :type: list[Order]
        """

        self._orders = orders

    @property
    def orders_summary(self):
        """Gets the orders_summary of this Customer.  # noqa: E501


        :return: The orders_summary of this Customer.  # noqa: E501
        :rtype: CustomerOrdersSummary
        """
        return self._orders_summary

    @orders_summary.setter
    def orders_summary(self, orders_summary):
        """Sets the orders_summary of this Customer.


        :param orders_summary: The orders_summary of this Customer.  # noqa: E501
        :type: CustomerOrdersSummary
        """

        self._orders_summary = orders_summary

    @property
    def password(self):
        """Gets the password of this Customer.  # noqa: E501

        Password (may only be set, never read)  # noqa: E501

        :return: The password of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this Customer.

        Password (may only be set, never read)  # noqa: E501

        :param password: The password of this Customer.  # noqa: E501
        :type: str
        """
        if password is not None and len(password) > 30:
            raise ValueError("Invalid value for `password`, length must be less than or equal to `30`")  # noqa: E501

        self._password = password

    @property
    def pricing_tiers(self):
        """Gets the pricing_tiers of this Customer.  # noqa: E501

        Pricing tiers for this customer  # noqa: E501

        :return: The pricing_tiers of this Customer.  # noqa: E501
        :rtype: list[CustomerPricingTier]
        """
        return self._pricing_tiers

    @pricing_tiers.setter
    def pricing_tiers(self, pricing_tiers):
        """Sets the pricing_tiers of this Customer.

        Pricing tiers for this customer  # noqa: E501

        :param pricing_tiers: The pricing_tiers of this Customer.  # noqa: E501
        :type: list[CustomerPricingTier]
        """

        self._pricing_tiers = pricing_tiers

    @property
    def privacy(self):
        """Gets the privacy of this Customer.  # noqa: E501


        :return: The privacy of this Customer.  # noqa: E501
        :rtype: CustomerPrivacy
        """
        return self._privacy

    @privacy.setter
    def privacy(self, privacy):
        """Sets the privacy of this Customer.


        :param privacy: The privacy of this Customer.  # noqa: E501
        :type: CustomerPrivacy
        """

        self._privacy = privacy

    @property
    def qb_class(self):
        """Gets the qb_class of this Customer.  # noqa: E501

        QuickBooks class to import this customer as  # noqa: E501

        :return: The qb_class of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._qb_class

    @qb_class.setter
    def qb_class(self, qb_class):
        """Sets the qb_class of this Customer.

        QuickBooks class to import this customer as  # noqa: E501

        :param qb_class: The qb_class of this Customer.  # noqa: E501
        :type: str
        """

        self._qb_class = qb_class

    @property
    def qb_code(self):
        """Gets the qb_code of this Customer.  # noqa: E501

        QuickBooks name to import this customer as  # noqa: E501

        :return: The qb_code of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._qb_code

    @qb_code.setter
    def qb_code(self, qb_code):
        """Sets the qb_code of this Customer.

        QuickBooks name to import this customer as  # noqa: E501

        :param qb_code: The qb_code of this Customer.  # noqa: E501
        :type: str
        """

        self._qb_code = qb_code

    @property
    def quotes(self):
        """Gets the quotes of this Customer.  # noqa: E501

        Quotes associated with this customer profile  # noqa: E501

        :return: The quotes of this Customer.  # noqa: E501
        :rtype: list[Order]
        """
        return self._quotes

    @quotes.setter
    def quotes(self, quotes):
        """Sets the quotes of this Customer.

        Quotes associated with this customer profile  # noqa: E501

        :param quotes: The quotes of this Customer.  # noqa: E501
        :type: list[Order]
        """

        self._quotes = quotes

    @property
    def quotes_summary(self):
        """Gets the quotes_summary of this Customer.  # noqa: E501


        :return: The quotes_summary of this Customer.  # noqa: E501
        :rtype: CustomerQuotesSummary
        """
        return self._quotes_summary

    @quotes_summary.setter
    def quotes_summary(self, quotes_summary):
        """Sets the quotes_summary of this Customer.


        :param quotes_summary: The quotes_summary of this Customer.  # noqa: E501
        :type: CustomerQuotesSummary
        """

        self._quotes_summary = quotes_summary

    @property
    def referral_source(self):
        """Gets the referral_source of this Customer.  # noqa: E501

        Referral Source  # noqa: E501

        :return: The referral_source of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._referral_source

    @referral_source.setter
    def referral_source(self, referral_source):
        """Sets the referral_source of this Customer.

        Referral Source  # noqa: E501

        :param referral_source: The referral_source of this Customer.  # noqa: E501
        :type: str
        """
        if referral_source is not None and len(referral_source) > 50:
            raise ValueError("Invalid value for `referral_source`, length must be less than or equal to `50`")  # noqa: E501

        self._referral_source = referral_source

    @property
    def reviewer(self):
        """Gets the reviewer of this Customer.  # noqa: E501


        :return: The reviewer of this Customer.  # noqa: E501
        :rtype: CustomerReviewer
        """
        return self._reviewer

    @reviewer.setter
    def reviewer(self, reviewer):
        """Sets the reviewer of this Customer.


        :param reviewer: The reviewer of this Customer.  # noqa: E501
        :type: CustomerReviewer
        """

        self._reviewer = reviewer

    @property
    def sales_rep_code(self):
        """Gets the sales_rep_code of this Customer.  # noqa: E501

        Sales rep code  # noqa: E501

        :return: The sales_rep_code of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._sales_rep_code

    @sales_rep_code.setter
    def sales_rep_code(self, sales_rep_code):
        """Sets the sales_rep_code of this Customer.

        Sales rep code  # noqa: E501

        :param sales_rep_code: The sales_rep_code of this Customer.  # noqa: E501
        :type: str
        """
        if sales_rep_code is not None and len(sales_rep_code) > 10:
            raise ValueError("Invalid value for `sales_rep_code`, length must be less than or equal to `10`")  # noqa: E501

        self._sales_rep_code = sales_rep_code

    @property
    def send_signup_notification(self):
        """Gets the send_signup_notification of this Customer.  # noqa: E501

        Send signup notification, if true during customer creation, will send a notification.  # noqa: E501

        :return: The send_signup_notification of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._send_signup_notification

    @send_signup_notification.setter
    def send_signup_notification(self, send_signup_notification):
        """Sets the send_signup_notification of this Customer.

        Send signup notification, if true during customer creation, will send a notification.  # noqa: E501

        :param send_signup_notification: The send_signup_notification of this Customer.  # noqa: E501
        :type: bool
        """

        self._send_signup_notification = send_signup_notification

    @property
    def shipping(self):
        """Gets the shipping of this Customer.  # noqa: E501

        Shipping addresses for this customer  # noqa: E501

        :return: The shipping of this Customer.  # noqa: E501
        :rtype: list[CustomerShipping]
        """
        return self._shipping

    @shipping.setter
    def shipping(self, shipping):
        """Sets the shipping of this Customer.

        Shipping addresses for this customer  # noqa: E501

        :param shipping: The shipping of this Customer.  # noqa: E501
        :type: list[CustomerShipping]
        """

        self._shipping = shipping

    @property
    def signup_dts(self):
        """Gets the signup_dts of this Customer.  # noqa: E501

        Signup date  # noqa: E501

        :return: The signup_dts of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._signup_dts

    @signup_dts.setter
    def signup_dts(self, signup_dts):
        """Sets the signup_dts of this Customer.

        Signup date  # noqa: E501

        :param signup_dts: The signup_dts of this Customer.  # noqa: E501
        :type: str
        """

        self._signup_dts = signup_dts

    @property
    def software_entitlements(self):
        """Gets the software_entitlements of this Customer.  # noqa: E501

        Software entitlements owned by this customer  # noqa: E501

        :return: The software_entitlements of this Customer.  # noqa: E501
        :rtype: list[CustomerSoftwareEntitlement]
        """
        return self._software_entitlements

    @software_entitlements.setter
    def software_entitlements(self, software_entitlements):
        """Sets the software_entitlements of this Customer.

        Software entitlements owned by this customer  # noqa: E501

        :param software_entitlements: The software_entitlements of this Customer.  # noqa: E501
        :type: list[CustomerSoftwareEntitlement]
        """

        self._software_entitlements = software_entitlements

    @property
    def suppress_buysafe(self):
        """Gets the suppress_buysafe of this Customer.  # noqa: E501

        Suppress buySAFE (deprecated)  # noqa: E501

        :return: The suppress_buysafe of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._suppress_buysafe

    @suppress_buysafe.setter
    def suppress_buysafe(self, suppress_buysafe):
        """Sets the suppress_buysafe of this Customer.

        Suppress buySAFE (deprecated)  # noqa: E501

        :param suppress_buysafe: The suppress_buysafe of this Customer.  # noqa: E501
        :type: bool
        """

        self._suppress_buysafe = suppress_buysafe

    @property
    def tags(self):
        """Gets the tags of this Customer.  # noqa: E501

        Tags for this customer  # noqa: E501

        :return: The tags of this Customer.  # noqa: E501
        :rtype: list[CustomerTag]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this Customer.

        Tags for this customer  # noqa: E501

        :param tags: The tags of this Customer.  # noqa: E501
        :type: list[CustomerTag]
        """

        self._tags = tags

    @property
    def tax_codes(self):
        """Gets the tax_codes of this Customer.  # noqa: E501


        :return: The tax_codes of this Customer.  # noqa: E501
        :rtype: CustomerTaxCodes
        """
        return self._tax_codes

    @tax_codes.setter
    def tax_codes(self, tax_codes):
        """Sets the tax_codes of this Customer.


        :param tax_codes: The tax_codes of this Customer.  # noqa: E501
        :type: CustomerTaxCodes
        """

        self._tax_codes = tax_codes

    @property
    def tax_exempt(self):
        """Gets the tax_exempt of this Customer.  # noqa: E501

        True if the customer is tax exempt  # noqa: E501

        :return: The tax_exempt of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._tax_exempt

    @tax_exempt.setter
    def tax_exempt(self, tax_exempt):
        """Sets the tax_exempt of this Customer.

        True if the customer is tax exempt  # noqa: E501

        :param tax_exempt: The tax_exempt of this Customer.  # noqa: E501
        :type: bool
        """

        self._tax_exempt = tax_exempt

    @property
    def tax_id(self):
        """Gets the tax_id of this Customer.  # noqa: E501

        Tax ID  # noqa: E501

        :return: The tax_id of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._tax_id

    @tax_id.setter
    def tax_id(self, tax_id):
        """Sets the tax_id of this Customer.

        Tax ID  # noqa: E501

        :param tax_id: The tax_id of this Customer.  # noqa: E501
        :type: str
        """
        if tax_id is not None and len(tax_id) > 15:
            raise ValueError("Invalid value for `tax_id`, length must be less than or equal to `15`")  # noqa: E501

        self._tax_id = tax_id

    @property
    def terms(self):
        """Gets the terms of this Customer.  # noqa: E501

        Terms for this customer  # noqa: E501

        :return: The terms of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._terms

    @terms.setter
    def terms(self, terms):
        """Sets the terms of this Customer.

        Terms for this customer  # noqa: E501

        :param terms: The terms of this Customer.  # noqa: E501
        :type: str
        """

        self._terms = terms

    @property
    def track_separately(self):
        """Gets the track_separately of this Customer.  # noqa: E501

        True if the customer should be tracked separately in QuickBooks  # noqa: E501

        :return: The track_separately of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._track_separately

    @track_separately.setter
    def track_separately(self, track_separately):
        """Sets the track_separately of this Customer.

        True if the customer should be tracked separately in QuickBooks  # noqa: E501

        :param track_separately: The track_separately of this Customer.  # noqa: E501
        :type: bool
        """

        self._track_separately = track_separately

    @property
    def unapproved(self):
        """Gets the unapproved of this Customer.  # noqa: E501

        Unapproved  # noqa: E501

        :return: The unapproved of this Customer.  # noqa: E501
        :rtype: bool
        """
        return self._unapproved

    @unapproved.setter
    def unapproved(self, unapproved):
        """Sets the unapproved of this Customer.

        Unapproved  # noqa: E501

        :param unapproved: The unapproved of this Customer.  # noqa: E501
        :type: bool
        """

        self._unapproved = unapproved

    @property
    def ups_account_number(self):
        """Gets the ups_account_number of this Customer.  # noqa: E501

        UPS account number  # noqa: E501

        :return: The ups_account_number of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._ups_account_number

    @ups_account_number.setter
    def ups_account_number(self, ups_account_number):
        """Sets the ups_account_number of this Customer.

        UPS account number  # noqa: E501

        :param ups_account_number: The ups_account_number of this Customer.  # noqa: E501
        :type: str
        """
        if ups_account_number is not None and len(ups_account_number) > 20:
            raise ValueError("Invalid value for `ups_account_number`, length must be less than or equal to `20`")  # noqa: E501

        self._ups_account_number = ups_account_number

    @property
    def website_url(self):
        """Gets the website_url of this Customer.  # noqa: E501

        Website url  # noqa: E501

        :return: The website_url of this Customer.  # noqa: E501
        :rtype: str
        """
        return self._website_url

    @website_url.setter
    def website_url(self, website_url):
        """Sets the website_url of this Customer.

        Website url  # noqa: E501

        :param website_url: The website_url of this Customer.  # noqa: E501
        :type: str
        """
        if website_url is not None and len(website_url) > 100:
            raise ValueError("Invalid value for `website_url`, length must be less than or equal to `100`")  # noqa: E501

        self._website_url = website_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Customer, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Customer):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
