# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class WebhookApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return WebhookApi(api_client)




    def delete_webhook(self, webhook_oid, **kwargs):  # noqa: E501
        """Delete a webhook  # noqa: E501

        Delete a webhook on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webhook(webhook_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_oid: The webhook oid to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_webhook_with_http_info(webhook_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_webhook_with_http_info(webhook_oid, **kwargs)  # noqa: E501
            return data

    def delete_webhook_with_http_info(self, webhook_oid, **kwargs):  # noqa: E501
        """Delete a webhook  # noqa: E501

        Delete a webhook on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webhook_with_http_info(webhook_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_oid: The webhook oid to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webhook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_oid' is set
        if ('webhook_oid' not in params or
                params['webhook_oid'] is None):
            raise ValueError("Missing the required parameter `webhook_oid` when calling `delete_webhook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'webhook_oid' in params:
            path_params['webhookOid'] = params['webhook_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/webhook/webhooks/{webhookOid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_webhook_by_url(self, webhook, **kwargs):  # noqa: E501
        """Delete a webhook by URL  # noqa: E501

        Delete a webhook based upon the URL on the webhook_url matching an existing webhook.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webhook_by_url(webhook, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Webhook webhook: Webhook to delete (required)
        :return: WebhookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_webhook_by_url_with_http_info(webhook, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_webhook_by_url_with_http_info(webhook, **kwargs)  # noqa: E501
            return data

    def delete_webhook_by_url_with_http_info(self, webhook, **kwargs):  # noqa: E501
        """Delete a webhook by URL  # noqa: E501

        Delete a webhook based upon the URL on the webhook_url matching an existing webhook.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webhook_by_url_with_http_info(webhook, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Webhook webhook: Webhook to delete (required)
        :return: WebhookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webhook_by_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook' is set
        if ('webhook' not in params or
                params['webhook'] is None):
            raise ValueError("Missing the required parameter `webhook` when calling `delete_webhook_by_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'webhook' in params:
            body_params = params['webhook']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/webhook/webhooks', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhookResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webhook_log(self, webhook_oid, request_id, **kwargs):  # noqa: E501
        """Retrieve an individual log  # noqa: E501

        Retrieves an individual log for a webhook given the webhook oid the request id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook_log(webhook_oid, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_oid: The webhook oid that owns the log. (required)
        :param str request_id: The request id associated with the log to view. (required)
        :return: WebhookLogResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_webhook_log_with_http_info(webhook_oid, request_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_webhook_log_with_http_info(webhook_oid, request_id, **kwargs)  # noqa: E501
            return data

    def get_webhook_log_with_http_info(self, webhook_oid, request_id, **kwargs):  # noqa: E501
        """Retrieve an individual log  # noqa: E501

        Retrieves an individual log for a webhook given the webhook oid the request id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook_log_with_http_info(webhook_oid, request_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_oid: The webhook oid that owns the log. (required)
        :param str request_id: The request id associated with the log to view. (required)
        :return: WebhookLogResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_oid', 'request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhook_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_oid' is set
        if ('webhook_oid' not in params or
                params['webhook_oid'] is None):
            raise ValueError("Missing the required parameter `webhook_oid` when calling `get_webhook_log`")  # noqa: E501
        # verify the required parameter 'request_id' is set
        if ('request_id' not in params or
                params['request_id'] is None):
            raise ValueError("Missing the required parameter `request_id` when calling `get_webhook_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'webhook_oid' in params:
            path_params['webhookOid'] = params['webhook_oid']  # noqa: E501
        if 'request_id' in params:
            path_params['requestId'] = params['request_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/webhook/webhooks/{webhookOid}/logs/{requestId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhookLogResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webhook_log_summaries(self, webhook_oid, **kwargs):  # noqa: E501
        """Retrieve the log summaries  # noqa: E501

        Retrieves the log summary information for a given webhook.  This is useful for displaying all the various logs that can be viewed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook_log_summaries(webhook_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_oid: The webhook oid to retrieve log summaries for. (required)
        :param int limit: The maximum number of records to return on this one API call.
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str since: Fetch log summaries that have been delivered since this date/time.
        :return: WebhookLogSummariesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_webhook_log_summaries_with_http_info(webhook_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_webhook_log_summaries_with_http_info(webhook_oid, **kwargs)  # noqa: E501
            return data

    def get_webhook_log_summaries_with_http_info(self, webhook_oid, **kwargs):  # noqa: E501
        """Retrieve the log summaries  # noqa: E501

        Retrieves the log summary information for a given webhook.  This is useful for displaying all the various logs that can be viewed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook_log_summaries_with_http_info(webhook_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_oid: The webhook oid to retrieve log summaries for. (required)
        :param int limit: The maximum number of records to return on this one API call.
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str since: Fetch log summaries that have been delivered since this date/time.
        :return: WebhookLogSummariesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_oid', 'limit', 'offset', 'since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhook_log_summaries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_oid' is set
        if ('webhook_oid' not in params or
                params['webhook_oid'] is None):
            raise ValueError("Missing the required parameter `webhook_oid` when calling `get_webhook_log_summaries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'webhook_oid' in params:
            path_params['webhookOid'] = params['webhook_oid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'since' in params:
            query_params.append(('_since', params['since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/webhook/webhooks/{webhookOid}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhookLogSummariesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webhooks(self, **kwargs):  # noqa: E501
        """Retrieve webhooks  # noqa: E501

        Retrieves the webhooks associated with this application.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhooks(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The maximum number of records to return on this one API call.
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the webhooks.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: WebhooksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_webhooks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_webhooks_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_webhooks_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve webhooks  # noqa: E501

        Retrieves the webhooks associated with this application.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhooks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The maximum number of records to return on this one API call.
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the webhooks.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: WebhooksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset', 'sort', 'placeholders']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhooks" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501
        if 'placeholders' in params:
            query_params.append(('_placeholders', params['placeholders']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/webhook/webhooks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhooksResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_webhook(self, webhook, **kwargs):  # noqa: E501
        """Add a webhook  # noqa: E501

        Adds a new webhook on the account.  If you add a new webhook with the authentication_type set to basic, but do not specify the basic_username and basic_password, UltraCart will automatically generate random ones and return them.  This allows your application to have simpler logic on the setup of a secure webhook.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_webhook(webhook, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Webhook webhook: Webhook to create (required)
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: WebhookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_webhook_with_http_info(webhook, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_webhook_with_http_info(webhook, **kwargs)  # noqa: E501
            return data

    def insert_webhook_with_http_info(self, webhook, **kwargs):  # noqa: E501
        """Add a webhook  # noqa: E501

        Adds a new webhook on the account.  If you add a new webhook with the authentication_type set to basic, but do not specify the basic_username and basic_password, UltraCart will automatically generate random ones and return them.  This allows your application to have simpler logic on the setup of a secure webhook.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_webhook_with_http_info(webhook, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Webhook webhook: Webhook to create (required)
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: WebhookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook', 'placeholders']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_webhook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook' is set
        if ('webhook' not in params or
                params['webhook'] is None):
            raise ValueError("Missing the required parameter `webhook` when calling `insert_webhook`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'placeholders' in params:
            query_params.append(('_placeholders', params['placeholders']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'webhook' in params:
            body_params = params['webhook']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/webhook/webhooks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhookResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resend_event(self, webhook_oid, event_name, **kwargs):  # noqa: E501
        """Resend events to the webhook endpoint.  # noqa: E501

        This method will resend events to the webhook endpoint.  This method can be used for example to send all the existing items on an account to a webhook.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resend_event(webhook_oid, event_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_oid: The webhook oid that is receiving the reflowed events. (required)
        :param str event_name: The event to reflow. (required)
        :return: WebhookSampleRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resend_event_with_http_info(webhook_oid, event_name, **kwargs)  # noqa: E501
        else:
            (data) = self.resend_event_with_http_info(webhook_oid, event_name, **kwargs)  # noqa: E501
            return data

    def resend_event_with_http_info(self, webhook_oid, event_name, **kwargs):  # noqa: E501
        """Resend events to the webhook endpoint.  # noqa: E501

        This method will resend events to the webhook endpoint.  This method can be used for example to send all the existing items on an account to a webhook.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resend_event_with_http_info(webhook_oid, event_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_oid: The webhook oid that is receiving the reflowed events. (required)
        :param str event_name: The event to reflow. (required)
        :return: WebhookSampleRequestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_oid', 'event_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resend_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_oid' is set
        if ('webhook_oid' not in params or
                params['webhook_oid'] is None):
            raise ValueError("Missing the required parameter `webhook_oid` when calling `resend_event`")  # noqa: E501
        # verify the required parameter 'event_name' is set
        if ('event_name' not in params or
                params['event_name'] is None):
            raise ValueError("Missing the required parameter `event_name` when calling `resend_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'webhook_oid' in params:
            path_params['webhookOid'] = params['webhook_oid']  # noqa: E501
        if 'event_name' in params:
            path_params['eventName'] = params['event_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/webhook/webhooks/{webhookOid}/reflow/{eventName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhookSampleRequestResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_webhook(self, webhook, webhook_oid, **kwargs):  # noqa: E501
        """Update a webhook  # noqa: E501

        Update a webhook on the account   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_webhook(webhook, webhook_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Webhook webhook: Webhook to update (required)
        :param int webhook_oid: The webhook oid to update. (required)
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: WebhookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_webhook_with_http_info(webhook, webhook_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_webhook_with_http_info(webhook, webhook_oid, **kwargs)  # noqa: E501
            return data

    def update_webhook_with_http_info(self, webhook, webhook_oid, **kwargs):  # noqa: E501
        """Update a webhook  # noqa: E501

        Update a webhook on the account   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_webhook_with_http_info(webhook, webhook_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Webhook webhook: Webhook to update (required)
        :param int webhook_oid: The webhook oid to update. (required)
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: WebhookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook', 'webhook_oid', 'placeholders']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_webhook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook' is set
        if ('webhook' not in params or
                params['webhook'] is None):
            raise ValueError("Missing the required parameter `webhook` when calling `update_webhook`")  # noqa: E501
        # verify the required parameter 'webhook_oid' is set
        if ('webhook_oid' not in params or
                params['webhook_oid'] is None):
            raise ValueError("Missing the required parameter `webhook_oid` when calling `update_webhook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'webhook_oid' in params:
            path_params['webhookOid'] = params['webhook_oid']  # noqa: E501

        query_params = []
        if 'placeholders' in params:
            query_params.append(('_placeholders', params['placeholders']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'webhook' in params:
            body_params = params['webhook']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/webhook/webhooks/{webhookOid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WebhookResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
