# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class TaxApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return TaxApi(api_client)




    def delete_tax_provider_self_city(self, city, tax_city, **kwargs):  # noqa: E501
        """Deletes a Self tax provider city  # noqa: E501

        Deletes a Self tax provider city.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_provider_self_city(city, tax_city, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str city: The city being deleted. (required)
        :param TaxCity tax_city: tax city to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tax_provider_self_city_with_http_info(city, tax_city, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tax_provider_self_city_with_http_info(city, tax_city, **kwargs)  # noqa: E501
            return data

    def delete_tax_provider_self_city_with_http_info(self, city, tax_city, **kwargs):  # noqa: E501
        """Deletes a Self tax provider city  # noqa: E501

        Deletes a Self tax provider city.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_provider_self_city_with_http_info(city, tax_city, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str city: The city being deleted. (required)
        :param TaxCity tax_city: tax city to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['city', 'tax_city']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tax_provider_self_city" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'city' is set
        if ('city' not in params or
                params['city'] is None):
            raise ValueError("Missing the required parameter `city` when calling `delete_tax_provider_self_city`")  # noqa: E501
        # verify the required parameter 'tax_city' is set
        if ('tax_city' not in params or
                params['tax_city'] is None):
            raise ValueError("Missing the required parameter `tax_city` when calling `delete_tax_provider_self_city`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'city' in params:
            path_params['city'] = params['city']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_city' in params:
            body_params = params['tax_city']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/city/{city}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tax_provider_self_country(self, country_code, tax_country, **kwargs):  # noqa: E501
        """Deletes a Self tax provider country  # noqa: E501

        Deletes a Self tax provider country.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_provider_self_country(country_code, tax_country, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str country_code: The country code being deleted. (required)
        :param TaxCountry tax_country: tax country to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tax_provider_self_country_with_http_info(country_code, tax_country, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tax_provider_self_country_with_http_info(country_code, tax_country, **kwargs)  # noqa: E501
            return data

    def delete_tax_provider_self_country_with_http_info(self, country_code, tax_country, **kwargs):  # noqa: E501
        """Deletes a Self tax provider country  # noqa: E501

        Deletes a Self tax provider country.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_provider_self_country_with_http_info(country_code, tax_country, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str country_code: The country code being deleted. (required)
        :param TaxCountry tax_country: tax country to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['country_code', 'tax_country']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tax_provider_self_country" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'country_code' is set
        if ('country_code' not in params or
                params['country_code'] is None):
            raise ValueError("Missing the required parameter `country_code` when calling `delete_tax_provider_self_country`")  # noqa: E501
        # verify the required parameter 'tax_country' is set
        if ('tax_country' not in params or
                params['tax_country'] is None):
            raise ValueError("Missing the required parameter `tax_country` when calling `delete_tax_provider_self_country`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'country_code' in params:
            path_params['countryCode'] = params['country_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_country' in params:
            body_params = params['tax_country']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/country/{countryCode}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tax_provider_self_county(self, county, tax_county, **kwargs):  # noqa: E501
        """Deletes a Self tax provider county  # noqa: E501

        Deletes a Self tax provider county.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_provider_self_county(county, tax_county, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str county: The county being deleted. (required)
        :param TaxCounty tax_county: tax county to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tax_provider_self_county_with_http_info(county, tax_county, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tax_provider_self_county_with_http_info(county, tax_county, **kwargs)  # noqa: E501
            return data

    def delete_tax_provider_self_county_with_http_info(self, county, tax_county, **kwargs):  # noqa: E501
        """Deletes a Self tax provider county  # noqa: E501

        Deletes a Self tax provider county.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_provider_self_county_with_http_info(county, tax_county, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str county: The county being deleted. (required)
        :param TaxCounty tax_county: tax county to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['county', 'tax_county']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tax_provider_self_county" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'county' is set
        if ('county' not in params or
                params['county'] is None):
            raise ValueError("Missing the required parameter `county` when calling `delete_tax_provider_self_county`")  # noqa: E501
        # verify the required parameter 'tax_county' is set
        if ('tax_county' not in params or
                params['tax_county'] is None):
            raise ValueError("Missing the required parameter `tax_county` when calling `delete_tax_provider_self_county`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'county' in params:
            path_params['county'] = params['county']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_county' in params:
            body_params = params['tax_county']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/county/{county}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tax_provider_self_postal_code(self, postal_code, tax_postal_code, **kwargs):  # noqa: E501
        """Deletes a Self tax provider postalCode  # noqa: E501

        Deletes a Self tax provider postalCode.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_provider_self_postal_code(postal_code, tax_postal_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str postal_code: The postal code being deleted. (required)
        :param TaxPostalCode tax_postal_code: tax postal code to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tax_provider_self_postal_code_with_http_info(postal_code, tax_postal_code, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tax_provider_self_postal_code_with_http_info(postal_code, tax_postal_code, **kwargs)  # noqa: E501
            return data

    def delete_tax_provider_self_postal_code_with_http_info(self, postal_code, tax_postal_code, **kwargs):  # noqa: E501
        """Deletes a Self tax provider postalCode  # noqa: E501

        Deletes a Self tax provider postalCode.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_provider_self_postal_code_with_http_info(postal_code, tax_postal_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str postal_code: The postal code being deleted. (required)
        :param TaxPostalCode tax_postal_code: tax postal code to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['postal_code', 'tax_postal_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tax_provider_self_postal_code" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'postal_code' is set
        if ('postal_code' not in params or
                params['postal_code'] is None):
            raise ValueError("Missing the required parameter `postal_code` when calling `delete_tax_provider_self_postal_code`")  # noqa: E501
        # verify the required parameter 'tax_postal_code' is set
        if ('tax_postal_code' not in params or
                params['tax_postal_code'] is None):
            raise ValueError("Missing the required parameter `tax_postal_code` when calling `delete_tax_provider_self_postal_code`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'postal_code' in params:
            path_params['postal_code'] = params['postal_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_postal_code' in params:
            body_params = params['tax_postal_code']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/postalCode/{postal_code}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tax_provider_self_state(self, state_code, tax_state, **kwargs):  # noqa: E501
        """Deletes a Self tax provider state  # noqa: E501

        Deletes a Self tax provider state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_provider_self_state(state_code, tax_state, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str state_code: The state code being deleted. (required)
        :param TaxState tax_state: tax state to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tax_provider_self_state_with_http_info(state_code, tax_state, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tax_provider_self_state_with_http_info(state_code, tax_state, **kwargs)  # noqa: E501
            return data

    def delete_tax_provider_self_state_with_http_info(self, state_code, tax_state, **kwargs):  # noqa: E501
        """Deletes a Self tax provider state  # noqa: E501

        Deletes a Self tax provider state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_provider_self_state_with_http_info(state_code, tax_state, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str state_code: The state code being deleted. (required)
        :param TaxState tax_state: tax state to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['state_code', 'tax_state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tax_provider_self_state" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'state_code' is set
        if ('state_code' not in params or
                params['state_code'] is None):
            raise ValueError("Missing the required parameter `state_code` when calling `delete_tax_provider_self_state`")  # noqa: E501
        # verify the required parameter 'tax_state' is set
        if ('tax_state' not in params or
                params['tax_state'] is None):
            raise ValueError("Missing the required parameter `tax_state` when calling `delete_tax_provider_self_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'state_code' in params:
            path_params['stateCode'] = params['state_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_state' in params:
            body_params = params['tax_state']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/state/{stateCode}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_provider_avalara(self, **kwargs):  # noqa: E501
        """Retrieve the Avalara tax provider  # noqa: E501

        Retrieves the Avalara tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_avalara(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderAvalara
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_provider_avalara_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_provider_avalara_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tax_provider_avalara_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve the Avalara tax provider  # noqa: E501

        Retrieves the Avalara tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_avalara_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderAvalara
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_provider_avalara" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/avalara', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderAvalara',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_provider_avalara_companies(self, tax_provider_avalara, **kwargs):  # noqa: E501
        """Returns Avalara Tax companies configured by the merchant  # noqa: E501

        Returns Avalara Tax companies configured by the merchant   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_avalara_companies(tax_provider_avalara, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderAvalara tax_provider_avalara: TaxProviderAvalara object (required)
        :return: TaxProviderAvalaraCompaniesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_provider_avalara_companies_with_http_info(tax_provider_avalara, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_provider_avalara_companies_with_http_info(tax_provider_avalara, **kwargs)  # noqa: E501
            return data

    def get_tax_provider_avalara_companies_with_http_info(self, tax_provider_avalara, **kwargs):  # noqa: E501
        """Returns Avalara Tax companies configured by the merchant  # noqa: E501

        Returns Avalara Tax companies configured by the merchant   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_avalara_companies_with_http_info(tax_provider_avalara, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderAvalara tax_provider_avalara: TaxProviderAvalara object (required)
        :return: TaxProviderAvalaraCompaniesResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tax_provider_avalara']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_provider_avalara_companies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tax_provider_avalara' is set
        if ('tax_provider_avalara' not in params or
                params['tax_provider_avalara'] is None):
            raise ValueError("Missing the required parameter `tax_provider_avalara` when calling `get_tax_provider_avalara_companies`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_provider_avalara' in params:
            body_params = params['tax_provider_avalara']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/avalara/companies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderAvalaraCompaniesResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_provider_avalara_test(self, **kwargs):  # noqa: E501
        """Attempts to connect to Avalara and returns back the response  # noqa: E501

        Attempts to connect to Avalara and returns back the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_avalara_test(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderTestResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_provider_avalara_test_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_provider_avalara_test_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tax_provider_avalara_test_with_http_info(self, **kwargs):  # noqa: E501
        """Attempts to connect to Avalara and returns back the response  # noqa: E501

        Attempts to connect to Avalara and returns back the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_avalara_test_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderTestResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_provider_avalara_test" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/avalara/test', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderTestResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_provider_self(self, **kwargs):  # noqa: E501
        """Retrieve the Self tax provider  # noqa: E501

        Retrieves the Self tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_self(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderSelf
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_provider_self_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_provider_self_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tax_provider_self_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve the Self tax provider  # noqa: E501

        Retrieves the Self tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_self_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderSelf
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_provider_self" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderSelf',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_provider_self_countries(self, **kwargs):  # noqa: E501
        """Retrieve the Self tax provider countries  # noqa: E501

        Retrieves the Self tax provider countries.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_self_countries(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderSelfCountriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_provider_self_countries_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_provider_self_countries_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tax_provider_self_countries_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve the Self tax provider countries  # noqa: E501

        Retrieves the Self tax provider countries.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_self_countries_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderSelfCountriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_provider_self_countries" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/countries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderSelfCountriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_provider_self_regions_by_country_code(self, country_code, **kwargs):  # noqa: E501
        """Retrieve the Self tax provider regions for a given country code  # noqa: E501

        Retrieves the Self tax provider regions for a given country code.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_self_regions_by_country_code(country_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str country_code: The country code regions desired. (required)
        :return: TaxProviderSelfRegionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_provider_self_regions_by_country_code_with_http_info(country_code, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_provider_self_regions_by_country_code_with_http_info(country_code, **kwargs)  # noqa: E501
            return data

    def get_tax_provider_self_regions_by_country_code_with_http_info(self, country_code, **kwargs):  # noqa: E501
        """Retrieve the Self tax provider regions for a given country code  # noqa: E501

        Retrieves the Self tax provider regions for a given country code.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_self_regions_by_country_code_with_http_info(country_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str country_code: The country code regions desired. (required)
        :return: TaxProviderSelfRegionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['country_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_provider_self_regions_by_country_code" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'country_code' is set
        if ('country_code' not in params or
                params['country_code'] is None):
            raise ValueError("Missing the required parameter `country_code` when calling `get_tax_provider_self_regions_by_country_code`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'country_code' in params:
            path_params['countryCode'] = params['country_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/regions/{countryCode}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderSelfRegionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_provider_sovos(self, **kwargs):  # noqa: E501
        """Retrieve the Sovos tax provider  # noqa: E501

        Retrieves the Sovos tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_sovos(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderSovos
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_provider_sovos_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_provider_sovos_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tax_provider_sovos_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve the Sovos tax provider  # noqa: E501

        Retrieves the Sovos tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_sovos_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderSovos
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_provider_sovos" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/sovos', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderSovos',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_provider_sovos_test(self, **kwargs):  # noqa: E501
        """Attempts to connect to Sovos and returns back the response  # noqa: E501

        Attempts to connect to Sovos and returns back the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_sovos_test(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderTestResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_provider_sovos_test_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_provider_sovos_test_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tax_provider_sovos_test_with_http_info(self, **kwargs):  # noqa: E501
        """Attempts to connect to Sovos and returns back the response  # noqa: E501

        Attempts to connect to Sovos and returns back the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_sovos_test_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderTestResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_provider_sovos_test" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/sovos/test', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderTestResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_provider_tax_jar(self, **kwargs):  # noqa: E501
        """Retrieve the TaxJar tax provider  # noqa: E501

        Retrieves the TaxJar tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_tax_jar(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderTaxJar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_provider_tax_jar_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_provider_tax_jar_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tax_provider_tax_jar_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve the TaxJar tax provider  # noqa: E501

        Retrieves the TaxJar tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_tax_jar_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderTaxJar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_provider_tax_jar" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/taxjar', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderTaxJar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_provider_tax_jar_test(self, **kwargs):  # noqa: E501
        """Attempts to connect to TaxJar and returns back the response  # noqa: E501

        Attempts to connect to TaxJar and returns back the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_tax_jar_test(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderTestResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_provider_tax_jar_test_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_provider_tax_jar_test_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tax_provider_tax_jar_test_with_http_info(self, **kwargs):  # noqa: E501
        """Attempts to connect to TaxJar and returns back the response  # noqa: E501

        Attempts to connect to TaxJar and returns back the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_tax_jar_test_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderTestResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_provider_tax_jar_test" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/taxjar/test', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderTestResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_provider_ultra_cart(self, **kwargs):  # noqa: E501
        """Retrieve the UltraCart tax provider  # noqa: E501

        Retrieves the UltraCart tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_ultra_cart(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderUltraCart
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_provider_ultra_cart_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_provider_ultra_cart_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tax_provider_ultra_cart_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve the UltraCart tax provider  # noqa: E501

        Retrieves the UltraCart tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_provider_ultra_cart_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TaxProviderUltraCart
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_provider_ultra_cart" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/ultracart', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderUltraCart',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_providers(self, **kwargs):  # noqa: E501
        """Retrieve tax methods  # noqa: E501

        Retrieves tax methods for this account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_providers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The maximum number of records to return on this one API call. (Max 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: TaxProvidersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_providers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_providers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tax_providers_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve tax methods  # noqa: E501

        Retrieves tax methods for this account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_providers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: The maximum number of records to return on this one API call. (Max 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: TaxProvidersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_providers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProvidersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_active_tax_provider(self, provider_name, **kwargs):  # noqa: E501
        """Toggle a tax provider to active  # noqa: E501

        Toggle a tax provider to active.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_active_tax_provider(provider_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str provider_name: The tax provider to set active. (required)
        :return: TaxProviderActivateResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_active_tax_provider_with_http_info(provider_name, **kwargs)  # noqa: E501
        else:
            (data) = self.set_active_tax_provider_with_http_info(provider_name, **kwargs)  # noqa: E501
            return data

    def set_active_tax_provider_with_http_info(self, provider_name, **kwargs):  # noqa: E501
        """Toggle a tax provider to active  # noqa: E501

        Toggle a tax provider to active.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_active_tax_provider_with_http_info(provider_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str provider_name: The tax provider to set active. (required)
        :return: TaxProviderActivateResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['provider_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_active_tax_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'provider_name' is set
        if ('provider_name' not in params or
                params['provider_name'] is None):
            raise ValueError("Missing the required parameter `provider_name` when calling `set_active_tax_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'provider_name' in params:
            path_params['providerName'] = params['provider_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/setActive/{providerName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderActivateResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tax_provider_avalara(self, tax_provider_avalara, **kwargs):  # noqa: E501
        """Update the Avalara tax provider  # noqa: E501

        Update the Avalara tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_avalara(tax_provider_avalara, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderAvalara tax_provider_avalara: TaxProviderAvalara object (required)
        :return: TaxProviderAvalara
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tax_provider_avalara_with_http_info(tax_provider_avalara, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tax_provider_avalara_with_http_info(tax_provider_avalara, **kwargs)  # noqa: E501
            return data

    def update_tax_provider_avalara_with_http_info(self, tax_provider_avalara, **kwargs):  # noqa: E501
        """Update the Avalara tax provider  # noqa: E501

        Update the Avalara tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_avalara_with_http_info(tax_provider_avalara, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderAvalara tax_provider_avalara: TaxProviderAvalara object (required)
        :return: TaxProviderAvalara
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tax_provider_avalara']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tax_provider_avalara" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tax_provider_avalara' is set
        if ('tax_provider_avalara' not in params or
                params['tax_provider_avalara'] is None):
            raise ValueError("Missing the required parameter `tax_provider_avalara` when calling `update_tax_provider_avalara`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_provider_avalara' in params:
            body_params = params['tax_provider_avalara']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/avalara', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderAvalara',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tax_provider_self(self, tax_provider_self, **kwargs):  # noqa: E501
        """Update the Self tax provider  # noqa: E501

        Update the Self tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self(tax_provider_self, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderSelf tax_provider_self: TaxProviderSelf object (required)
        :return: TaxProviderSelf
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tax_provider_self_with_http_info(tax_provider_self, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tax_provider_self_with_http_info(tax_provider_self, **kwargs)  # noqa: E501
            return data

    def update_tax_provider_self_with_http_info(self, tax_provider_self, **kwargs):  # noqa: E501
        """Update the Self tax provider  # noqa: E501

        Update the Self tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self_with_http_info(tax_provider_self, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderSelf tax_provider_self: TaxProviderSelf object (required)
        :return: TaxProviderSelf
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tax_provider_self']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tax_provider_self" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tax_provider_self' is set
        if ('tax_provider_self' not in params or
                params['tax_provider_self'] is None):
            raise ValueError("Missing the required parameter `tax_provider_self` when calling `update_tax_provider_self`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_provider_self' in params:
            body_params = params['tax_provider_self']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderSelf',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tax_provider_self_city(self, city, tax_city, **kwargs):  # noqa: E501
        """Updates a Self tax provider city  # noqa: E501

        Updates a Self tax provider city.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self_city(city, tax_city, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str city: The city being updated. (required)
        :param TaxCity tax_city: tax city to be updated (required)
        :return: TaxCity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tax_provider_self_city_with_http_info(city, tax_city, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tax_provider_self_city_with_http_info(city, tax_city, **kwargs)  # noqa: E501
            return data

    def update_tax_provider_self_city_with_http_info(self, city, tax_city, **kwargs):  # noqa: E501
        """Updates a Self tax provider city  # noqa: E501

        Updates a Self tax provider city.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self_city_with_http_info(city, tax_city, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str city: The city being updated. (required)
        :param TaxCity tax_city: tax city to be updated (required)
        :return: TaxCity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['city', 'tax_city']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tax_provider_self_city" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'city' is set
        if ('city' not in params or
                params['city'] is None):
            raise ValueError("Missing the required parameter `city` when calling `update_tax_provider_self_city`")  # noqa: E501
        # verify the required parameter 'tax_city' is set
        if ('tax_city' not in params or
                params['tax_city'] is None):
            raise ValueError("Missing the required parameter `tax_city` when calling `update_tax_provider_self_city`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'city' in params:
            path_params['city'] = params['city']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_city' in params:
            body_params = params['tax_city']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/city/{city}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxCity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tax_provider_self_country(self, country_code, tax_country, **kwargs):  # noqa: E501
        """Updates a Self tax provider country  # noqa: E501

        Updates a Self tax provider country.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self_country(country_code, tax_country, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str country_code: The country code being updated. (required)
        :param TaxCountry tax_country: tax country to be updated (required)
        :return: TaxCountry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tax_provider_self_country_with_http_info(country_code, tax_country, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tax_provider_self_country_with_http_info(country_code, tax_country, **kwargs)  # noqa: E501
            return data

    def update_tax_provider_self_country_with_http_info(self, country_code, tax_country, **kwargs):  # noqa: E501
        """Updates a Self tax provider country  # noqa: E501

        Updates a Self tax provider country.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self_country_with_http_info(country_code, tax_country, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str country_code: The country code being updated. (required)
        :param TaxCountry tax_country: tax country to be updated (required)
        :return: TaxCountry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['country_code', 'tax_country']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tax_provider_self_country" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'country_code' is set
        if ('country_code' not in params or
                params['country_code'] is None):
            raise ValueError("Missing the required parameter `country_code` when calling `update_tax_provider_self_country`")  # noqa: E501
        # verify the required parameter 'tax_country' is set
        if ('tax_country' not in params or
                params['tax_country'] is None):
            raise ValueError("Missing the required parameter `tax_country` when calling `update_tax_provider_self_country`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'country_code' in params:
            path_params['countryCode'] = params['country_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_country' in params:
            body_params = params['tax_country']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/country/{countryCode}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxCountry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tax_provider_self_county(self, county, tax_county, **kwargs):  # noqa: E501
        """Updates a Self tax provider county  # noqa: E501

        Updates a Self tax provider county.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self_county(county, tax_county, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str county: The county being updated. (required)
        :param TaxCounty tax_county: tax county to be updated (required)
        :return: TaxCounty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tax_provider_self_county_with_http_info(county, tax_county, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tax_provider_self_county_with_http_info(county, tax_county, **kwargs)  # noqa: E501
            return data

    def update_tax_provider_self_county_with_http_info(self, county, tax_county, **kwargs):  # noqa: E501
        """Updates a Self tax provider county  # noqa: E501

        Updates a Self tax provider county.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self_county_with_http_info(county, tax_county, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str county: The county being updated. (required)
        :param TaxCounty tax_county: tax county to be updated (required)
        :return: TaxCounty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['county', 'tax_county']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tax_provider_self_county" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'county' is set
        if ('county' not in params or
                params['county'] is None):
            raise ValueError("Missing the required parameter `county` when calling `update_tax_provider_self_county`")  # noqa: E501
        # verify the required parameter 'tax_county' is set
        if ('tax_county' not in params or
                params['tax_county'] is None):
            raise ValueError("Missing the required parameter `tax_county` when calling `update_tax_provider_self_county`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'county' in params:
            path_params['county'] = params['county']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_county' in params:
            body_params = params['tax_county']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/county/{county}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxCounty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tax_provider_self_postal_code(self, postal_code, tax_postal_code, **kwargs):  # noqa: E501
        """Updates a Self tax provider postalCode  # noqa: E501

        Updates a Self tax provider postalCode.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self_postal_code(postal_code, tax_postal_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str postal_code: The postal code being updated. (required)
        :param TaxPostalCode tax_postal_code: tax postal code to be updated (required)
        :return: TaxPostalCode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tax_provider_self_postal_code_with_http_info(postal_code, tax_postal_code, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tax_provider_self_postal_code_with_http_info(postal_code, tax_postal_code, **kwargs)  # noqa: E501
            return data

    def update_tax_provider_self_postal_code_with_http_info(self, postal_code, tax_postal_code, **kwargs):  # noqa: E501
        """Updates a Self tax provider postalCode  # noqa: E501

        Updates a Self tax provider postalCode.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self_postal_code_with_http_info(postal_code, tax_postal_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str postal_code: The postal code being updated. (required)
        :param TaxPostalCode tax_postal_code: tax postal code to be updated (required)
        :return: TaxPostalCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['postal_code', 'tax_postal_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tax_provider_self_postal_code" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'postal_code' is set
        if ('postal_code' not in params or
                params['postal_code'] is None):
            raise ValueError("Missing the required parameter `postal_code` when calling `update_tax_provider_self_postal_code`")  # noqa: E501
        # verify the required parameter 'tax_postal_code' is set
        if ('tax_postal_code' not in params or
                params['tax_postal_code'] is None):
            raise ValueError("Missing the required parameter `tax_postal_code` when calling `update_tax_provider_self_postal_code`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'postal_code' in params:
            path_params['postal_code'] = params['postal_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_postal_code' in params:
            body_params = params['tax_postal_code']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/postalCode/{postal_code}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxPostalCode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tax_provider_self_state(self, state_code, tax_state, **kwargs):  # noqa: E501
        """Updates a Self tax provider state  # noqa: E501

        Updates a Self tax provider state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self_state(state_code, tax_state, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str state_code: The state code being updated. (required)
        :param TaxState tax_state: tax state to be updated (required)
        :return: TaxState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tax_provider_self_state_with_http_info(state_code, tax_state, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tax_provider_self_state_with_http_info(state_code, tax_state, **kwargs)  # noqa: E501
            return data

    def update_tax_provider_self_state_with_http_info(self, state_code, tax_state, **kwargs):  # noqa: E501
        """Updates a Self tax provider state  # noqa: E501

        Updates a Self tax provider state.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_self_state_with_http_info(state_code, tax_state, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str state_code: The state code being updated. (required)
        :param TaxState tax_state: tax state to be updated (required)
        :return: TaxState
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['state_code', 'tax_state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tax_provider_self_state" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'state_code' is set
        if ('state_code' not in params or
                params['state_code'] is None):
            raise ValueError("Missing the required parameter `state_code` when calling `update_tax_provider_self_state`")  # noqa: E501
        # verify the required parameter 'tax_state' is set
        if ('tax_state' not in params or
                params['tax_state'] is None):
            raise ValueError("Missing the required parameter `tax_state` when calling `update_tax_provider_self_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'state_code' in params:
            path_params['stateCode'] = params['state_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_state' in params:
            body_params = params['tax_state']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/self/state/{stateCode}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxState',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tax_provider_sovos(self, tax_provider_sovos, **kwargs):  # noqa: E501
        """Update the Sovos tax provider  # noqa: E501

        Update the Sovos tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_sovos(tax_provider_sovos, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderSovos tax_provider_sovos: TaxProviderSovos object (required)
        :return: TaxProviderSovos
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tax_provider_sovos_with_http_info(tax_provider_sovos, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tax_provider_sovos_with_http_info(tax_provider_sovos, **kwargs)  # noqa: E501
            return data

    def update_tax_provider_sovos_with_http_info(self, tax_provider_sovos, **kwargs):  # noqa: E501
        """Update the Sovos tax provider  # noqa: E501

        Update the Sovos tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_sovos_with_http_info(tax_provider_sovos, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderSovos tax_provider_sovos: TaxProviderSovos object (required)
        :return: TaxProviderSovos
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tax_provider_sovos']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tax_provider_sovos" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tax_provider_sovos' is set
        if ('tax_provider_sovos' not in params or
                params['tax_provider_sovos'] is None):
            raise ValueError("Missing the required parameter `tax_provider_sovos` when calling `update_tax_provider_sovos`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_provider_sovos' in params:
            body_params = params['tax_provider_sovos']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/sovos', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderSovos',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tax_provider_tax_jar(self, tax_provider_tax_jar, **kwargs):  # noqa: E501
        """Update the TaxJar tax provider  # noqa: E501

        Update the TaxJar tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_tax_jar(tax_provider_tax_jar, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderTaxJar tax_provider_tax_jar: TaxProviderTaxJar object (required)
        :return: TaxProviderTaxJar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tax_provider_tax_jar_with_http_info(tax_provider_tax_jar, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tax_provider_tax_jar_with_http_info(tax_provider_tax_jar, **kwargs)  # noqa: E501
            return data

    def update_tax_provider_tax_jar_with_http_info(self, tax_provider_tax_jar, **kwargs):  # noqa: E501
        """Update the TaxJar tax provider  # noqa: E501

        Update the TaxJar tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_tax_jar_with_http_info(tax_provider_tax_jar, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderTaxJar tax_provider_tax_jar: TaxProviderTaxJar object (required)
        :return: TaxProviderTaxJar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tax_provider_tax_jar']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tax_provider_tax_jar" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tax_provider_tax_jar' is set
        if ('tax_provider_tax_jar' not in params or
                params['tax_provider_tax_jar'] is None):
            raise ValueError("Missing the required parameter `tax_provider_tax_jar` when calling `update_tax_provider_tax_jar`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_provider_tax_jar' in params:
            body_params = params['tax_provider_tax_jar']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/taxjar', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderTaxJar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tax_provider_ultra_cart(self, tax_provider_ultracart, **kwargs):  # noqa: E501
        """Update the UltraCart tax provider  # noqa: E501

        Update the UltraCart tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_ultra_cart(tax_provider_ultracart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderUltraCart tax_provider_ultracart: TaxProviderUltraCart object (required)
        :return: TaxProviderUltraCart
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tax_provider_ultra_cart_with_http_info(tax_provider_ultracart, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tax_provider_ultra_cart_with_http_info(tax_provider_ultracart, **kwargs)  # noqa: E501
            return data

    def update_tax_provider_ultra_cart_with_http_info(self, tax_provider_ultracart, **kwargs):  # noqa: E501
        """Update the UltraCart tax provider  # noqa: E501

        Update the UltraCart tax provider.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tax_provider_ultra_cart_with_http_info(tax_provider_ultracart, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TaxProviderUltraCart tax_provider_ultracart: TaxProviderUltraCart object (required)
        :return: TaxProviderUltraCart
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tax_provider_ultracart']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tax_provider_ultra_cart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tax_provider_ultracart' is set
        if ('tax_provider_ultracart' not in params or
                params['tax_provider_ultracart'] is None):
            raise ValueError("Missing the required parameter `tax_provider_ultracart` when calling `update_tax_provider_ultra_cart`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tax_provider_ultracart' in params:
            body_params = params['tax_provider_ultracart']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tax/providers/ultracart', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxProviderUltraCart',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
