# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class StorefrontApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return StorefrontApi(api_client)




    def add_to_library(self, add_library_request, **kwargs):  # noqa: E501
        """Add to library  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_to_library(add_library_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddLibraryItemRequest add_library_request: New library item request (required)
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_to_library_with_http_info(add_library_request, **kwargs)  # noqa: E501
        else:
            (data) = self.add_to_library_with_http_info(add_library_request, **kwargs)  # noqa: E501
            return data

    def add_to_library_with_http_info(self, add_library_request, **kwargs):  # noqa: E501
        """Add to library  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_to_library_with_http_info(add_library_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddLibraryItemRequest add_library_request: New library item request (required)
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['add_library_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_to_library" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'add_library_request' is set
        if ('add_library_request' not in params or
                params['add_library_request'] is None):
            raise ValueError("Missing the required parameter `add_library_request` when calling `add_to_library`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_library_request' in params:
            body_params = params['add_library_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def apply_to_store_front(self, apply_library_request, **kwargs):  # noqa: E501
        """Apply library item to storefront.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.apply_to_store_front(apply_library_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplyLibraryItemRequest apply_library_request: New library item (required)
        :return: ApplyLibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.apply_to_store_front_with_http_info(apply_library_request, **kwargs)  # noqa: E501
        else:
            (data) = self.apply_to_store_front_with_http_info(apply_library_request, **kwargs)  # noqa: E501
            return data

    def apply_to_store_front_with_http_info(self, apply_library_request, **kwargs):  # noqa: E501
        """Apply library item to storefront.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.apply_to_store_front_with_http_info(apply_library_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ApplyLibraryItemRequest apply_library_request: New library item (required)
        :return: ApplyLibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['apply_library_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method apply_to_store_front" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'apply_library_request' is set
        if ('apply_library_request' not in params or
                params['apply_library_request'] is None):
            raise ValueError("Missing the required parameter `apply_library_request` when calling `apply_to_store_front`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'apply_library_request' in params:
            body_params = params['apply_library_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/apply', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplyLibraryItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def archive_email_list(self, storefront_oid, email_list_uuid, **kwargs):  # noqa: E501
        """Archive email list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_email_list(storefront_oid, email_list_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :return: EmailListArchiveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.archive_email_list_with_http_info(storefront_oid, email_list_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.archive_email_list_with_http_info(storefront_oid, email_list_uuid, **kwargs)  # noqa: E501
            return data

    def archive_email_list_with_http_info(self, storefront_oid, email_list_uuid, **kwargs):  # noqa: E501
        """Archive email list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_email_list_with_http_info(storefront_oid, email_list_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :return: EmailListArchiveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_email_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `archive_email_list`")  # noqa: E501
        # verify the required parameter 'email_list_uuid' is set
        if ('email_list_uuid' not in params or
                params['email_list_uuid'] is None):
            raise ValueError("Missing the required parameter `email_list_uuid` when calling `archive_email_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_list_uuid' in params:
            path_params['email_list_uuid'] = params['email_list_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/lists/{email_list_uuid}/archive', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListArchiveResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def archive_email_segment(self, storefront_oid, email_segment_uuid, **kwargs):  # noqa: E501
        """Archive email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_email_segment(storefront_oid, email_segment_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :return: EmailSegmentArchiveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.archive_email_segment_with_http_info(storefront_oid, email_segment_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.archive_email_segment_with_http_info(storefront_oid, email_segment_uuid, **kwargs)  # noqa: E501
            return data

    def archive_email_segment_with_http_info(self, storefront_oid, email_segment_uuid, **kwargs):  # noqa: E501
        """Archive email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_email_segment_with_http_info(storefront_oid, email_segment_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :return: EmailSegmentArchiveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_segment_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_email_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `archive_email_segment`")  # noqa: E501
        # verify the required parameter 'email_segment_uuid' is set
        if ('email_segment_uuid' not in params or
                params['email_segment_uuid'] is None):
            raise ValueError("Missing the required parameter `email_segment_uuid` when calling `archive_email_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_segment_uuid' in params:
            path_params['email_segment_uuid'] = params['email_segment_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/segments/{email_segment_uuid}/archive', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSegmentArchiveResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def back_populate_email_flow(self, storefront_oid, email_flow_uuid, back_populate_request, **kwargs):  # noqa: E501
        """Back populate email flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.back_populate_email_flow(storefront_oid, email_flow_uuid, back_populate_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_uuid: (required)
        :param EmailFlowBackPopulateRequest back_populate_request: The request to back populate (required)
        :return: EmailFlowBackPopulateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.back_populate_email_flow_with_http_info(storefront_oid, email_flow_uuid, back_populate_request, **kwargs)  # noqa: E501
        else:
            (data) = self.back_populate_email_flow_with_http_info(storefront_oid, email_flow_uuid, back_populate_request, **kwargs)  # noqa: E501
            return data

    def back_populate_email_flow_with_http_info(self, storefront_oid, email_flow_uuid, back_populate_request, **kwargs):  # noqa: E501
        """Back populate email flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.back_populate_email_flow_with_http_info(storefront_oid, email_flow_uuid, back_populate_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_uuid: (required)
        :param EmailFlowBackPopulateRequest back_populate_request: The request to back populate (required)
        :return: EmailFlowBackPopulateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_flow_uuid', 'back_populate_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method back_populate_email_flow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `back_populate_email_flow`")  # noqa: E501
        # verify the required parameter 'email_flow_uuid' is set
        if ('email_flow_uuid' not in params or
                params['email_flow_uuid'] is None):
            raise ValueError("Missing the required parameter `email_flow_uuid` when calling `back_populate_email_flow`")  # noqa: E501
        # verify the required parameter 'back_populate_request' is set
        if ('back_populate_request' not in params or
                params['back_populate_request'] is None):
            raise ValueError("Missing the required parameter `back_populate_request` when calling `back_populate_email_flow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_flow_uuid' in params:
            path_params['email_flow_uuid'] = params['email_flow_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'back_populate_request' in params:
            body_params = params['back_populate_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flows/{email_flow_uuid}/backfill', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailFlowBackPopulateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def check_download_email_segment(self, storefront_oid, email_segment_uuid, email_segment_rebuild_uuid, **kwargs):  # noqa: E501
        """Check download of email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_download_email_segment(storefront_oid, email_segment_uuid, email_segment_rebuild_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :param str email_segment_rebuild_uuid: (required)
        :return: EmailSegmentDownloadPrepareResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.check_download_email_segment_with_http_info(storefront_oid, email_segment_uuid, email_segment_rebuild_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.check_download_email_segment_with_http_info(storefront_oid, email_segment_uuid, email_segment_rebuild_uuid, **kwargs)  # noqa: E501
            return data

    def check_download_email_segment_with_http_info(self, storefront_oid, email_segment_uuid, email_segment_rebuild_uuid, **kwargs):  # noqa: E501
        """Check download of email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_download_email_segment_with_http_info(storefront_oid, email_segment_uuid, email_segment_rebuild_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :param str email_segment_rebuild_uuid: (required)
        :return: EmailSegmentDownloadPrepareResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_segment_uuid', 'email_segment_rebuild_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method check_download_email_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `check_download_email_segment`")  # noqa: E501
        # verify the required parameter 'email_segment_uuid' is set
        if ('email_segment_uuid' not in params or
                params['email_segment_uuid'] is None):
            raise ValueError("Missing the required parameter `email_segment_uuid` when calling `check_download_email_segment`")  # noqa: E501
        # verify the required parameter 'email_segment_rebuild_uuid' is set
        if ('email_segment_rebuild_uuid' not in params or
                params['email_segment_rebuild_uuid'] is None):
            raise ValueError("Missing the required parameter `email_segment_rebuild_uuid` when calling `check_download_email_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_segment_uuid' in params:
            path_params['email_segment_uuid'] = params['email_segment_uuid']  # noqa: E501
        if 'email_segment_rebuild_uuid' in params:
            path_params['email_segment_rebuild_uuid'] = params['email_segment_rebuild_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/segments/{email_segment_uuid}/downloadPrepare/{email_segment_rebuild_uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSegmentDownloadPrepareResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clone_email_campaign(self, storefront_oid, email_campaign_uuid, **kwargs):  # noqa: E501
        """Clone email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_email_campaign(storefront_oid, email_campaign_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_uuid: (required)
        :param int target_storefront_oid:
        :return: EmailCampaignResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.clone_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.clone_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, **kwargs)  # noqa: E501
            return data

    def clone_email_campaign_with_http_info(self, storefront_oid, email_campaign_uuid, **kwargs):  # noqa: E501
        """Clone email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_uuid: (required)
        :param int target_storefront_oid:
        :return: EmailCampaignResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_campaign_uuid', 'target_storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_email_campaign" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `clone_email_campaign`")  # noqa: E501
        # verify the required parameter 'email_campaign_uuid' is set
        if ('email_campaign_uuid' not in params or
                params['email_campaign_uuid'] is None):
            raise ValueError("Missing the required parameter `email_campaign_uuid` when calling `clone_email_campaign`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_campaign_uuid' in params:
            path_params['email_campaign_uuid'] = params['email_campaign_uuid']  # noqa: E501

        query_params = []
        if 'target_storefront_oid' in params:
            query_params.append(('target_storefront_oid', params['target_storefront_oid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaigns/{email_campaign_uuid}/clone', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCampaignResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clone_email_flow(self, storefront_oid, email_flow_uuid, **kwargs):  # noqa: E501
        """Clone email flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_email_flow(storefront_oid, email_flow_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_uuid: (required)
        :param int target_storefront_oid:
        :return: EmailFlowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.clone_email_flow_with_http_info(storefront_oid, email_flow_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.clone_email_flow_with_http_info(storefront_oid, email_flow_uuid, **kwargs)  # noqa: E501
            return data

    def clone_email_flow_with_http_info(self, storefront_oid, email_flow_uuid, **kwargs):  # noqa: E501
        """Clone email flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_email_flow_with_http_info(storefront_oid, email_flow_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_uuid: (required)
        :param int target_storefront_oid:
        :return: EmailFlowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_flow_uuid', 'target_storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_email_flow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `clone_email_flow`")  # noqa: E501
        # verify the required parameter 'email_flow_uuid' is set
        if ('email_flow_uuid' not in params or
                params['email_flow_uuid'] is None):
            raise ValueError("Missing the required parameter `email_flow_uuid` when calling `clone_email_flow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_flow_uuid' in params:
            path_params['email_flow_uuid'] = params['email_flow_uuid']  # noqa: E501

        query_params = []
        if 'target_storefront_oid' in params:
            query_params.append(('target_storefront_oid', params['target_storefront_oid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flows/{email_flow_uuid}/clone', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailFlowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_email_sending_domain(self, domain, **kwargs):  # noqa: E501
        """Create email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_email_sending_domain(domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: (required)
        :return: EmailSendingDomainResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_email_sending_domain_with_http_info(domain, **kwargs)  # noqa: E501
        else:
            (data) = self.create_email_sending_domain_with_http_info(domain, **kwargs)  # noqa: E501
            return data

    def create_email_sending_domain_with_http_info(self, domain, **kwargs):  # noqa: E501
        """Create email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_email_sending_domain_with_http_info(domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: (required)
        :return: EmailSendingDomainResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_email_sending_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `create_email_sending_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/email/sending_domains/{domain}/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSendingDomainResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_email_sending_domain2(self, email_domain, **kwargs):  # noqa: E501
        """Create email sending domain for various providers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_email_sending_domain2(email_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailDomain email_domain: EmailDomain (required)
        :return: EmailSendingDomainResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_email_sending_domain2_with_http_info(email_domain, **kwargs)  # noqa: E501
        else:
            (data) = self.create_email_sending_domain2_with_http_info(email_domain, **kwargs)  # noqa: E501
            return data

    def create_email_sending_domain2_with_http_info(self, email_domain, **kwargs):  # noqa: E501
        """Create email sending domain for various providers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_email_sending_domain2_with_http_info(email_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailDomain email_domain: EmailDomain (required)
        :return: EmailSendingDomainResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_email_sending_domain2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'email_domain' is set
        if ('email_domain' not in params or
                params['email_domain'] is None):
            raise ValueError("Missing the required parameter `email_domain` when calling `create_email_sending_domain2`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_domain' in params:
            body_params = params['email_domain']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/email/sending_domains', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSendingDomainResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_twilio_account(self, twilio, **kwargs):  # noqa: E501
        """Create Twilio account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_twilio_account(twilio, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Twilio twilio: Twilio (required)
        :return: TwilioResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_twilio_account_with_http_info(twilio, **kwargs)  # noqa: E501
        else:
            (data) = self.create_twilio_account_with_http_info(twilio, **kwargs)  # noqa: E501
            return data

    def create_twilio_account_with_http_info(self, twilio, **kwargs):  # noqa: E501
        """Create Twilio account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_twilio_account_with_http_info(twilio, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Twilio twilio: Twilio (required)
        :return: TwilioResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['twilio']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_twilio_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'twilio' is set
        if ('twilio' not in params or
                params['twilio'] is None):
            raise ValueError("Missing the required parameter `twilio` when calling `create_twilio_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'twilio' in params:
            body_params = params['twilio']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/twilio/accounts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TwilioResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_email_campaign_folder(self, storefront_oid, email_campaign_folder_uuid, **kwargs):  # noqa: E501
        """Delete email campaignFolder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_campaign_folder(storefront_oid, email_campaign_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_folder_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder_uuid, **kwargs)  # noqa: E501
            return data

    def delete_email_campaign_folder_with_http_info(self, storefront_oid, email_campaign_folder_uuid, **kwargs):  # noqa: E501
        """Delete email campaignFolder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_folder_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_campaign_folder_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_email_campaign_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `delete_email_campaign_folder`")  # noqa: E501
        # verify the required parameter 'email_campaign_folder_uuid' is set
        if ('email_campaign_folder_uuid' not in params or
                params['email_campaign_folder_uuid'] is None):
            raise ValueError("Missing the required parameter `email_campaign_folder_uuid` when calling `delete_email_campaign_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_campaign_folder_uuid' in params:
            path_params['email_campaign_folder_uuid'] = params['email_campaign_folder_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaign_folders/{email_campaign_folder_uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_email_commseq_stat(self, storefront_oid, commseq_uuid, **kwargs):  # noqa: E501
        """Delete communication sequence stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_commseq_stat(storefront_oid, commseq_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_email_commseq_stat_with_http_info(storefront_oid, commseq_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_email_commseq_stat_with_http_info(storefront_oid, commseq_uuid, **kwargs)  # noqa: E501
            return data

    def delete_email_commseq_stat_with_http_info(self, storefront_oid, commseq_uuid, **kwargs):  # noqa: E501
        """Delete communication sequence stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_commseq_stat_with_http_info(storefront_oid, commseq_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_email_commseq_stat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `delete_email_commseq_stat`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `delete_email_commseq_stat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/stat', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_email_email(self, storefront_oid, commseq_email_uuid, **kwargs):  # noqa: E501
        """Delete email email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_email(storefront_oid, commseq_email_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_email_email_with_http_info(storefront_oid, commseq_email_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_email_email_with_http_info(storefront_oid, commseq_email_uuid, **kwargs)  # noqa: E501
            return data

    def delete_email_email_with_http_info(self, storefront_oid, commseq_email_uuid, **kwargs):  # noqa: E501
        """Delete email email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_email_with_http_info(storefront_oid, commseq_email_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_email_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_email_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `delete_email_email`")  # noqa: E501
        # verify the required parameter 'commseq_email_uuid' is set
        if ('commseq_email_uuid' not in params or
                params['commseq_email_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_email_uuid` when calling `delete_email_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_email_uuid' in params:
            path_params['commseq_email_uuid'] = params['commseq_email_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/emails/{commseq_email_uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_email_flow_folder(self, storefront_oid, email_flow_folder_uuid, **kwargs):  # noqa: E501
        """Delete email flowFolder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_flow_folder(storefront_oid, email_flow_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_folder_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_email_flow_folder_with_http_info(storefront_oid, email_flow_folder_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_email_flow_folder_with_http_info(storefront_oid, email_flow_folder_uuid, **kwargs)  # noqa: E501
            return data

    def delete_email_flow_folder_with_http_info(self, storefront_oid, email_flow_folder_uuid, **kwargs):  # noqa: E501
        """Delete email flowFolder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_flow_folder_with_http_info(storefront_oid, email_flow_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_folder_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_flow_folder_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_email_flow_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `delete_email_flow_folder`")  # noqa: E501
        # verify the required parameter 'email_flow_folder_uuid' is set
        if ('email_flow_folder_uuid' not in params or
                params['email_flow_folder_uuid'] is None):
            raise ValueError("Missing the required parameter `email_flow_folder_uuid` when calling `delete_email_flow_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_flow_folder_uuid' in params:
            path_params['email_flow_folder_uuid'] = params['email_flow_folder_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flow_folders/{email_flow_folder_uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_email_list_customer(self, storefront_oid, email_list_uuid, email_customer_uuid, **kwargs):  # noqa: E501
        """Delete email list customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_list_customer(storefront_oid, email_list_uuid, email_customer_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param str email_customer_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_email_list_customer_with_http_info(storefront_oid, email_list_uuid, email_customer_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_email_list_customer_with_http_info(storefront_oid, email_list_uuid, email_customer_uuid, **kwargs)  # noqa: E501
            return data

    def delete_email_list_customer_with_http_info(self, storefront_oid, email_list_uuid, email_customer_uuid, **kwargs):  # noqa: E501
        """Delete email list customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_list_customer_with_http_info(storefront_oid, email_list_uuid, email_customer_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param str email_customer_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_uuid', 'email_customer_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_email_list_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `delete_email_list_customer`")  # noqa: E501
        # verify the required parameter 'email_list_uuid' is set
        if ('email_list_uuid' not in params or
                params['email_list_uuid'] is None):
            raise ValueError("Missing the required parameter `email_list_uuid` when calling `delete_email_list_customer`")  # noqa: E501
        # verify the required parameter 'email_customer_uuid' is set
        if ('email_customer_uuid' not in params or
                params['email_customer_uuid'] is None):
            raise ValueError("Missing the required parameter `email_customer_uuid` when calling `delete_email_list_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_list_uuid' in params:
            path_params['email_list_uuid'] = params['email_list_uuid']  # noqa: E501
        if 'email_customer_uuid' in params:
            path_params['email_customer_uuid'] = params['email_customer_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/lists/{email_list_uuid}/customers/{email_customer_uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_email_list_segment_folder(self, storefront_oid, email_list_segment_folder_uuid, **kwargs):  # noqa: E501
        """Delete email ListSegmentFolder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_list_segment_folder(storefront_oid, email_list_segment_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_segment_folder_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder_uuid, **kwargs)  # noqa: E501
            return data

    def delete_email_list_segment_folder_with_http_info(self, storefront_oid, email_list_segment_folder_uuid, **kwargs):  # noqa: E501
        """Delete email ListSegmentFolder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_segment_folder_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_segment_folder_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_email_list_segment_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `delete_email_list_segment_folder`")  # noqa: E501
        # verify the required parameter 'email_list_segment_folder_uuid' is set
        if ('email_list_segment_folder_uuid' not in params or
                params['email_list_segment_folder_uuid'] is None):
            raise ValueError("Missing the required parameter `email_list_segment_folder_uuid` when calling `delete_email_list_segment_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_list_segment_folder_uuid' in params:
            path_params['email_list_segment_folder_uuid'] = params['email_list_segment_folder_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/list_segment_folders/{email_list_segment_folder_uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_email_postcard(self, storefront_oid, commseq_postcard_uuid, **kwargs):  # noqa: E501
        """Delete email postcard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_postcard(storefront_oid, commseq_postcard_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_postcard_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_email_postcard_with_http_info(storefront_oid, commseq_postcard_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_email_postcard_with_http_info(storefront_oid, commseq_postcard_uuid, **kwargs)  # noqa: E501
            return data

    def delete_email_postcard_with_http_info(self, storefront_oid, commseq_postcard_uuid, **kwargs):  # noqa: E501
        """Delete email postcard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_postcard_with_http_info(storefront_oid, commseq_postcard_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_postcard_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_postcard_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_email_postcard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `delete_email_postcard`")  # noqa: E501
        # verify the required parameter 'commseq_postcard_uuid' is set
        if ('commseq_postcard_uuid' not in params or
                params['commseq_postcard_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_postcard_uuid` when calling `delete_email_postcard`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_postcard_uuid' in params:
            path_params['commseq_postcard_uuid'] = params['commseq_postcard_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/postcards/{commseq_postcard_uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_email_sending_domain(self, domain, **kwargs):  # noqa: E501
        """delete email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_sending_domain(domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_email_sending_domain_with_http_info(domain, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_email_sending_domain_with_http_info(domain, **kwargs)  # noqa: E501
            return data

    def delete_email_sending_domain_with_http_info(self, domain, **kwargs):  # noqa: E501
        """delete email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_email_sending_domain_with_http_info(domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_email_sending_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `delete_email_sending_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/email/sending_domains/{domain}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_experiment(self, storefront_oid, storefront_experiment_oid, **kwargs):  # noqa: E501
        """Delete experiment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_experiment(storefront_oid, storefront_experiment_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int storefront_experiment_oid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_experiment_with_http_info(storefront_oid, storefront_experiment_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_experiment_with_http_info(storefront_oid, storefront_experiment_oid, **kwargs)  # noqa: E501
            return data

    def delete_experiment_with_http_info(self, storefront_oid, storefront_experiment_oid, **kwargs):  # noqa: E501
        """Delete experiment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_experiment_with_http_info(storefront_oid, storefront_experiment_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int storefront_experiment_oid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'storefront_experiment_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_experiment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `delete_experiment`")  # noqa: E501
        # verify the required parameter 'storefront_experiment_oid' is set
        if ('storefront_experiment_oid' not in params or
                params['storefront_experiment_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_experiment_oid` when calling `delete_experiment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'storefront_experiment_oid' in params:
            path_params['storefront_experiment_oid'] = params['storefront_experiment_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/experiments/{storefront_experiment_oid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_heatmap(self, storefront_oid, query, **kwargs):  # noqa: E501
        """Delete screen recording heatmap  # noqa: E501

        Delete screen recording heatmap   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_heatmap(storefront_oid, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingHeatmapReset query: Query (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_heatmap_with_http_info(storefront_oid, query, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_heatmap_with_http_info(storefront_oid, query, **kwargs)  # noqa: E501
            return data

    def delete_heatmap_with_http_info(self, storefront_oid, query, **kwargs):  # noqa: E501
        """Delete screen recording heatmap  # noqa: E501

        Delete screen recording heatmap   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_heatmap_with_http_info(storefront_oid, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingHeatmapReset query: Query (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_heatmap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `delete_heatmap`")  # noqa: E501
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `delete_heatmap`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'query' in params:
            body_params = params['query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/heatmap', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_library_item(self, library_item_oid, **kwargs):  # noqa: E501
        """Delete library item  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_library_item(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_library_item_with_http_info(library_item_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_library_item_with_http_info(library_item_oid, **kwargs)  # noqa: E501
            return data

    def delete_library_item_with_http_info(self, library_item_oid, **kwargs):  # noqa: E501
        """Delete library item  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_library_item_with_http_info(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['library_item_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_library_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'library_item_oid' is set
        if ('library_item_oid' not in params or
                params['library_item_oid'] is None):
            raise ValueError("Missing the required parameter `library_item_oid` when calling `delete_library_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_item_oid' in params:
            path_params['library_item_oid'] = params['library_item_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/{library_item_oid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_library_item_published_versions(self, library_item_oid, **kwargs):  # noqa: E501
        """Delete all published versions for a library item, including anything in review.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_library_item_published_versions(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_library_item_published_versions_with_http_info(library_item_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_library_item_published_versions_with_http_info(library_item_oid, **kwargs)  # noqa: E501
            return data

    def delete_library_item_published_versions_with_http_info(self, library_item_oid, **kwargs):  # noqa: E501
        """Delete all published versions for a library item, including anything in review.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_library_item_published_versions_with_http_info(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['library_item_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_library_item_published_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'library_item_oid' is set
        if ('library_item_oid' not in params or
                params['library_item_oid'] is None):
            raise ValueError("Missing the required parameter `library_item_oid` when calling `delete_library_item_published_versions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_item_oid' in params:
            path_params['library_item_oid'] = params['library_item_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/{library_item_oid}/published_versions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_screen_recording_segment(self, storefront_oid, screen_recording_segment_oid, **kwargs):  # noqa: E501
        """Delete screen recording segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_screen_recording_segment(storefront_oid, screen_recording_segment_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int screen_recording_segment_oid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_screen_recording_segment_with_http_info(storefront_oid, screen_recording_segment_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_screen_recording_segment_with_http_info(storefront_oid, screen_recording_segment_oid, **kwargs)  # noqa: E501
            return data

    def delete_screen_recording_segment_with_http_info(self, storefront_oid, screen_recording_segment_oid, **kwargs):  # noqa: E501
        """Delete screen recording segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_screen_recording_segment_with_http_info(storefront_oid, screen_recording_segment_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int screen_recording_segment_oid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'screen_recording_segment_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_screen_recording_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `delete_screen_recording_segment`")  # noqa: E501
        # verify the required parameter 'screen_recording_segment_oid' is set
        if ('screen_recording_segment_oid' not in params or
                params['screen_recording_segment_oid'] is None):
            raise ValueError("Missing the required parameter `screen_recording_segment_oid` when calling `delete_screen_recording_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'screen_recording_segment_oid' in params:
            path_params['screen_recording_segment_oid'] = params['screen_recording_segment_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/segments/{screen_recording_segment_oid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_twilio_account(self, esp_twilio_uuid, **kwargs):  # noqa: E501
        """delete Twilio account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_twilio_account(esp_twilio_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str esp_twilio_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_twilio_account_with_http_info(esp_twilio_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_twilio_account_with_http_info(esp_twilio_uuid, **kwargs)  # noqa: E501
            return data

    def delete_twilio_account_with_http_info(self, esp_twilio_uuid, **kwargs):  # noqa: E501
        """delete Twilio account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_twilio_account_with_http_info(esp_twilio_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str esp_twilio_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['esp_twilio_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_twilio_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'esp_twilio_uuid' is set
        if ('esp_twilio_uuid' not in params or
                params['esp_twilio_uuid'] is None):
            raise ValueError("Missing the required parameter `esp_twilio_uuid` when calling `delete_twilio_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'esp_twilio_uuid' in params:
            path_params['esp_twilio_uuid'] = params['esp_twilio_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/twilio/accounts/{esp_twilio_uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def duplicate_library_item(self, library_item_oid, **kwargs):  # noqa: E501
        """Duplicate library item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duplicate_library_item(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.duplicate_library_item_with_http_info(library_item_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.duplicate_library_item_with_http_info(library_item_oid, **kwargs)  # noqa: E501
            return data

    def duplicate_library_item_with_http_info(self, library_item_oid, **kwargs):  # noqa: E501
        """Duplicate library item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duplicate_library_item_with_http_info(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['library_item_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method duplicate_library_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'library_item_oid' is set
        if ('library_item_oid' not in params or
                params['library_item_oid'] is None):
            raise ValueError("Missing the required parameter `library_item_oid` when calling `duplicate_library_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_item_oid' in params:
            path_params['library_item_oid'] = params['library_item_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/{library_item_oid}/duplicate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def favorite_screen_recording(self, storefront_oid, screen_recording_uuid, **kwargs):  # noqa: E501
        """Update favorite flag on screen recording  # noqa: E501

        Update favorite flag on screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.favorite_screen_recording(storefront_oid, screen_recording_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.favorite_screen_recording_with_http_info(storefront_oid, screen_recording_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.favorite_screen_recording_with_http_info(storefront_oid, screen_recording_uuid, **kwargs)  # noqa: E501
            return data

    def favorite_screen_recording_with_http_info(self, storefront_oid, screen_recording_uuid, **kwargs):  # noqa: E501
        """Update favorite flag on screen recording  # noqa: E501

        Update favorite flag on screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.favorite_screen_recording_with_http_info(storefront_oid, screen_recording_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'screen_recording_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method favorite_screen_recording" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `favorite_screen_recording`")  # noqa: E501
        # verify the required parameter 'screen_recording_uuid' is set
        if ('screen_recording_uuid' not in params or
                params['screen_recording_uuid'] is None):
            raise ValueError("Missing the required parameter `screen_recording_uuid` when calling `favorite_screen_recording`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'screen_recording_uuid' in params:
            path_params['screen_recording_uuid'] = params['screen_recording_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid}/favorite', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def geocode_address(self, storefront_oid, geocode_request, **kwargs):  # noqa: E501
        """Obtain lat/long for an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.geocode_address(storefront_oid, geocode_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param GeocodeRequest geocode_request: geocode request (required)
        :return: GeocodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.geocode_address_with_http_info(storefront_oid, geocode_request, **kwargs)  # noqa: E501
        else:
            (data) = self.geocode_address_with_http_info(storefront_oid, geocode_request, **kwargs)  # noqa: E501
            return data

    def geocode_address_with_http_info(self, storefront_oid, geocode_request, **kwargs):  # noqa: E501
        """Obtain lat/long for an address  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.geocode_address_with_http_info(storefront_oid, geocode_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param GeocodeRequest geocode_request: geocode request (required)
        :return: GeocodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'geocode_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method geocode_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `geocode_address`")  # noqa: E501
        # verify the required parameter 'geocode_request' is set
        if ('geocode_request' not in params or
                params['geocode_request'] is None):
            raise ValueError("Missing the required parameter `geocode_request` when calling `geocode_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'geocode_request' in params:
            body_params = params['geocode_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/geocode', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeocodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_countries(self, storefront_oid, **kwargs):  # noqa: E501
        """Get countries  # noqa: E501

        Obtain a list of all the countries   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_countries(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: CountriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_countries_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_countries_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_countries_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get countries  # noqa: E501

        Obtain a list of all the countries   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_countries_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: CountriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_countries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_countries`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/countries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_editor_token(self, storefront_oid, **kwargs):  # noqa: E501
        """Gets editor token  # noqa: E501

        Fetches a temporary authentication token for the editor   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editor_token(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailEditorTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_editor_token_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_editor_token_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_editor_token_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Gets editor token  # noqa: E501

        Fetches a temporary authentication token for the editor   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_editor_token_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailEditorTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_editor_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_editor_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/editor_token', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailEditorTokenResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_base_templates(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email communication base templates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_base_templates(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailBaseTemplateListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_base_templates_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_base_templates_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_base_templates_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email communication base templates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_base_templates_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailBaseTemplateListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_base_templates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_base_templates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/baseTemplates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailBaseTemplateListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_campaign(self, storefront_oid, email_campaign_uuid, **kwargs):  # noqa: E501
        """Get email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaign(storefront_oid, email_campaign_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_uuid: (required)
        :return: EmailCampaignResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_campaign_with_http_info(self, storefront_oid, email_campaign_uuid, **kwargs):  # noqa: E501
        """Get email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_uuid: (required)
        :return: EmailCampaignResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_campaign_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_campaign" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_campaign`")  # noqa: E501
        # verify the required parameter 'email_campaign_uuid' is set
        if ('email_campaign_uuid' not in params or
                params['email_campaign_uuid'] is None):
            raise ValueError("Missing the required parameter `email_campaign_uuid` when calling `get_email_campaign`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_campaign_uuid' in params:
            path_params['email_campaign_uuid'] = params['email_campaign_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaigns/{email_campaign_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCampaignResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_campaign_folder(self, storefront_oid, email_campaign_folder_uuid, **kwargs):  # noqa: E501
        """Get email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaign_folder(storefront_oid, email_campaign_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_folder_uuid: (required)
        :return: EmailCampaignFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_campaign_folder_with_http_info(self, storefront_oid, email_campaign_folder_uuid, **kwargs):  # noqa: E501
        """Get email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_folder_uuid: (required)
        :return: EmailCampaignFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_campaign_folder_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_campaign_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_campaign_folder`")  # noqa: E501
        # verify the required parameter 'email_campaign_folder_uuid' is set
        if ('email_campaign_folder_uuid' not in params or
                params['email_campaign_folder_uuid'] is None):
            raise ValueError("Missing the required parameter `email_campaign_folder_uuid` when calling `get_email_campaign_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_campaign_folder_uuid' in params:
            path_params['email_campaign_folder_uuid'] = params['email_campaign_folder_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaign_folders/{email_campaign_folder_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCampaignFolderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_campaign_folders(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email campaign folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaign_folders(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailCampaignFoldersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_campaign_folders_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_campaign_folders_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_campaign_folders_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email campaign folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaign_folders_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailCampaignFoldersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_campaign_folders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_campaign_folders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaign_folders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCampaignFoldersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_campaign_screenshots(self, storefront_oid, email_campaign_uuid, **kwargs):  # noqa: E501
        """Get email campaign screenshots  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaign_screenshots(storefront_oid, email_campaign_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_uuid: (required)
        :return: ScreenshotsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_campaign_screenshots_with_http_info(storefront_oid, email_campaign_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_campaign_screenshots_with_http_info(storefront_oid, email_campaign_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_campaign_screenshots_with_http_info(self, storefront_oid, email_campaign_uuid, **kwargs):  # noqa: E501
        """Get email campaign screenshots  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaign_screenshots_with_http_info(storefront_oid, email_campaign_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_uuid: (required)
        :return: ScreenshotsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_campaign_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_campaign_screenshots" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_campaign_screenshots`")  # noqa: E501
        # verify the required parameter 'email_campaign_uuid' is set
        if ('email_campaign_uuid' not in params or
                params['email_campaign_uuid'] is None):
            raise ValueError("Missing the required parameter `email_campaign_uuid` when calling `get_email_campaign_screenshots`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_campaign_uuid' in params:
            path_params['email_campaign_uuid'] = params['email_campaign_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaigns/{email_campaign_uuid}/screenshots', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenshotsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_campaigns(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email campaigns  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaigns(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailCampaignsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_campaigns_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_campaigns_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_campaigns_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email campaigns  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaigns_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailCampaignsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_campaigns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_campaigns`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaigns', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCampaignsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_campaigns_with_stats(self, storefront_oid, stat_days, **kwargs):  # noqa: E501
        """Get email campaigns with stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaigns_with_stats(storefront_oid, stat_days, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str stat_days: (required)
        :return: EmailCampaignsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_campaigns_with_stats_with_http_info(storefront_oid, stat_days, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_campaigns_with_stats_with_http_info(storefront_oid, stat_days, **kwargs)  # noqa: E501
            return data

    def get_email_campaigns_with_stats_with_http_info(self, storefront_oid, stat_days, **kwargs):  # noqa: E501
        """Get email campaigns with stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_campaigns_with_stats_with_http_info(storefront_oid, stat_days, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str stat_days: (required)
        :return: EmailCampaignsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'stat_days']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_campaigns_with_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_campaigns_with_stats`")  # noqa: E501
        # verify the required parameter 'stat_days' is set
        if ('stat_days' not in params or
                params['stat_days'] is None):
            raise ValueError("Missing the required parameter `stat_days` when calling `get_email_campaigns_with_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'stat_days' in params:
            path_params['stat_days'] = params['stat_days']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaignsWithStats/{stat_days}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCampaignsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_commseq(self, storefront_oid, commseq_uuid, **kwargs):  # noqa: E501
        """Get email commseq  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq(storefront_oid, commseq_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :return: EmailCommseqResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_commseq_with_http_info(storefront_oid, commseq_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_commseq_with_http_info(storefront_oid, commseq_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_commseq_with_http_info(self, storefront_oid, commseq_uuid, **kwargs):  # noqa: E501
        """Get email commseq  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_with_http_info(storefront_oid, commseq_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :return: EmailCommseqResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_commseq" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_commseq`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `get_email_commseq`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_commseq_email_stats(self, storefront_oid, commseq_uuid, stats_request, **kwargs):  # noqa: E501
        """Get email communication sequence emails stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_email_stats(storefront_oid, commseq_uuid, stats_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param EmailStatSummaryRequest stats_request: StatsRequest (required)
        :return: EmailStatSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_commseq_email_stats_with_http_info(storefront_oid, commseq_uuid, stats_request, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_commseq_email_stats_with_http_info(storefront_oid, commseq_uuid, stats_request, **kwargs)  # noqa: E501
            return data

    def get_email_commseq_email_stats_with_http_info(self, storefront_oid, commseq_uuid, stats_request, **kwargs):  # noqa: E501
        """Get email communication sequence emails stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_email_stats_with_http_info(storefront_oid, commseq_uuid, stats_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param EmailStatSummaryRequest stats_request: StatsRequest (required)
        :return: EmailStatSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid', 'stats_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_commseq_email_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_commseq_email_stats`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `get_email_commseq_email_stats`")  # noqa: E501
        # verify the required parameter 'stats_request' is set
        if ('stats_request' not in params or
                params['stats_request'] is None):
            raise ValueError("Missing the required parameter `stats_request` when calling `get_email_commseq_email_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stats_request' in params:
            body_params = params['stats_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/emailStats', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailStatSummaryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_commseq_postcard_stats(self, storefront_oid, commseq_uuid, stats_request, **kwargs):  # noqa: E501
        """Get email communication sequence postcard stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_postcard_stats(storefront_oid, commseq_uuid, stats_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param EmailStatPostcardSummaryRequest stats_request: StatsRequest (required)
        :return: EmailStatPostcardSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_commseq_postcard_stats_with_http_info(storefront_oid, commseq_uuid, stats_request, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_commseq_postcard_stats_with_http_info(storefront_oid, commseq_uuid, stats_request, **kwargs)  # noqa: E501
            return data

    def get_email_commseq_postcard_stats_with_http_info(self, storefront_oid, commseq_uuid, stats_request, **kwargs):  # noqa: E501
        """Get email communication sequence postcard stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_postcard_stats_with_http_info(storefront_oid, commseq_uuid, stats_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param EmailStatPostcardSummaryRequest stats_request: StatsRequest (required)
        :return: EmailStatPostcardSummaryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid', 'stats_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_commseq_postcard_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_commseq_postcard_stats`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `get_email_commseq_postcard_stats`")  # noqa: E501
        # verify the required parameter 'stats_request' is set
        if ('stats_request' not in params or
                params['stats_request'] is None):
            raise ValueError("Missing the required parameter `stats_request` when calling `get_email_commseq_postcard_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stats_request' in params:
            body_params = params['stats_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/postcardStats', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailStatPostcardSummaryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_commseq_stat_overall(self, storefront_oid, commseq_uuid, **kwargs):  # noqa: E501
        """Get communication sequence stats overall  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_stat_overall(storefront_oid, commseq_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :return: EmailCommseqStatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_commseq_stat_overall_with_http_info(storefront_oid, commseq_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_commseq_stat_overall_with_http_info(storefront_oid, commseq_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_commseq_stat_overall_with_http_info(self, storefront_oid, commseq_uuid, **kwargs):  # noqa: E501
        """Get communication sequence stats overall  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_stat_overall_with_http_info(storefront_oid, commseq_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :return: EmailCommseqStatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_commseq_stat_overall" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_commseq_stat_overall`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `get_email_commseq_stat_overall`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/stat', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqStatResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_commseq_step_stats(self, storefront_oid, commseq_uuid, stats_request, **kwargs):  # noqa: E501
        """Get email communication sequence step stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_step_stats(storefront_oid, commseq_uuid, stats_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param EmailStepStatRequest stats_request: StatsRequest (required)
        :return: EmailStepStatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_commseq_step_stats_with_http_info(storefront_oid, commseq_uuid, stats_request, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_commseq_step_stats_with_http_info(storefront_oid, commseq_uuid, stats_request, **kwargs)  # noqa: E501
            return data

    def get_email_commseq_step_stats_with_http_info(self, storefront_oid, commseq_uuid, stats_request, **kwargs):  # noqa: E501
        """Get email communication sequence step stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_step_stats_with_http_info(storefront_oid, commseq_uuid, stats_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param EmailStepStatRequest stats_request: StatsRequest (required)
        :return: EmailStepStatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid', 'stats_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_commseq_step_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_commseq_step_stats`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `get_email_commseq_step_stats`")  # noqa: E501
        # verify the required parameter 'stats_request' is set
        if ('stats_request' not in params or
                params['stats_request'] is None):
            raise ValueError("Missing the required parameter `stats_request` when calling `get_email_commseq_step_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stats_request' in params:
            body_params = params['stats_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/stepStats', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailStepStatResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_commseq_step_waiting(self, storefront_oid, commseq_uuid, waiting_request, **kwargs):  # noqa: E501
        """Get email communication sequence customers waiting at each requested step  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_step_waiting(storefront_oid, commseq_uuid, waiting_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param EmailStepWaitingRequest waiting_request: WaitingRequest (required)
        :return: EmailStepWaitingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_commseq_step_waiting_with_http_info(storefront_oid, commseq_uuid, waiting_request, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_commseq_step_waiting_with_http_info(storefront_oid, commseq_uuid, waiting_request, **kwargs)  # noqa: E501
            return data

    def get_email_commseq_step_waiting_with_http_info(self, storefront_oid, commseq_uuid, waiting_request, **kwargs):  # noqa: E501
        """Get email communication sequence customers waiting at each requested step  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_step_waiting_with_http_info(storefront_oid, commseq_uuid, waiting_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param EmailStepWaitingRequest waiting_request: WaitingRequest (required)
        :return: EmailStepWaitingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid', 'waiting_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_commseq_step_waiting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_commseq_step_waiting`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `get_email_commseq_step_waiting`")  # noqa: E501
        # verify the required parameter 'waiting_request' is set
        if ('waiting_request' not in params or
                params['waiting_request'] is None):
            raise ValueError("Missing the required parameter `waiting_request` when calling `get_email_commseq_step_waiting`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'waiting_request' in params:
            body_params = params['waiting_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/waiting', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailStepWaitingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_commseq_webhook_editor_values(self, storefront_oid, commseq_uuid, **kwargs):  # noqa: E501
        """Get email webhook editor values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_webhook_editor_values(storefront_oid, commseq_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :return: EmailWebhookEditorValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_commseq_webhook_editor_values_with_http_info(storefront_oid, commseq_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_commseq_webhook_editor_values_with_http_info(storefront_oid, commseq_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_commseq_webhook_editor_values_with_http_info(self, storefront_oid, commseq_uuid, **kwargs):  # noqa: E501
        """Get email webhook editor values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseq_webhook_editor_values_with_http_info(storefront_oid, commseq_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :return: EmailWebhookEditorValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_commseq_webhook_editor_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_commseq_webhook_editor_values`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `get_email_commseq_webhook_editor_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/webhookEditorValues', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailWebhookEditorValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_commseqs(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email commseqs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseqs(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailCommseqsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_commseqs_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_commseqs_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_commseqs_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email commseqs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_commseqs_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailCommseqsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_commseqs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_commseqs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_customer_editor_url(self, storefront_oid, email_customer_uuid, **kwargs):  # noqa: E501
        """Get customers editor URL  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_customer_editor_url(storefront_oid, email_customer_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_customer_uuid: (required)
        :return: EmailCustomerEditorUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_customer_editor_url_with_http_info(storefront_oid, email_customer_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_customer_editor_url_with_http_info(storefront_oid, email_customer_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_customer_editor_url_with_http_info(self, storefront_oid, email_customer_uuid, **kwargs):  # noqa: E501
        """Get customers editor URL  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_customer_editor_url_with_http_info(storefront_oid, email_customer_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_customer_uuid: (required)
        :return: EmailCustomerEditorUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_customer_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_customer_editor_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_customer_editor_url`")  # noqa: E501
        # verify the required parameter 'email_customer_uuid' is set
        if ('email_customer_uuid' not in params or
                params['email_customer_uuid'] is None):
            raise ValueError("Missing the required parameter `email_customer_uuid` when calling `get_email_customer_editor_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_customer_uuid' in params:
            path_params['email_customer_uuid'] = params['email_customer_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/customers/{email_customer_uuid}/editor_url', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCustomerEditorUrlResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_customers(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_customers(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int page_number:
        :param int page_size:
        :param str search_email_prefix:
        :return: EmailCustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_customers_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_customers_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_customers_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_customers_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int page_number:
        :param int page_size:
        :param str search_email_prefix:
        :return: EmailCustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'page_number', 'page_size', 'search_email_prefix']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_customers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_customers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'search_email_prefix' in params:
            query_params.append(('searchEmailPrefix', params['search_email_prefix']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCustomersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_dashboard_activity(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email dashboard activity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_dashboard_activity(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int last_records:
        :return: EmailDashboardActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_dashboard_activity_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_dashboard_activity_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_dashboard_activity_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email dashboard activity  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_dashboard_activity_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int last_records:
        :return: EmailDashboardActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'last_records']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_dashboard_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_dashboard_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []
        if 'last_records' in params:
            query_params.append(('last_records', params['last_records']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/dashboard_activity', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailDashboardActivityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_dashboard_stats(self, storefront_oid, **kwargs):  # noqa: E501
        """Get dashboard stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_dashboard_stats(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int days:
        :return: EmailDashboardStatsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_dashboard_stats_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_dashboard_stats_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_dashboard_stats_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get dashboard stats  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_dashboard_stats_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int days:
        :return: EmailDashboardStatsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'days']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_dashboard_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_dashboard_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/dashboard_stats', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailDashboardStatsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_dispatch_logs(self, storefront_oid, commseq_uuid, commseq_step_uuid, **kwargs):  # noqa: E501
        """Get email dispatch logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_dispatch_logs(storefront_oid, commseq_uuid, commseq_step_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param str commseq_step_uuid: (required)
        :return: EmailCommseqStepLogsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_dispatch_logs_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_dispatch_logs_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_dispatch_logs_with_http_info(self, storefront_oid, commseq_uuid, commseq_step_uuid, **kwargs):  # noqa: E501
        """Get email dispatch logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_dispatch_logs_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param str commseq_step_uuid: (required)
        :return: EmailCommseqStepLogsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid', 'commseq_step_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_dispatch_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_dispatch_logs`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `get_email_dispatch_logs`")  # noqa: E501
        # verify the required parameter 'commseq_step_uuid' is set
        if ('commseq_step_uuid' not in params or
                params['commseq_step_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_step_uuid` when calling `get_email_dispatch_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501
        if 'commseq_step_uuid' in params:
            path_params['commseq_step_uuid'] = params['commseq_step_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/steps/{commseq_step_uuid}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqStepLogsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_email(self, storefront_oid, commseq_email_uuid, **kwargs):  # noqa: E501
        """Get email email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_email(storefront_oid, commseq_email_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :return: EmailCommseqEmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_email_with_http_info(storefront_oid, commseq_email_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_email_with_http_info(storefront_oid, commseq_email_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_email_with_http_info(self, storefront_oid, commseq_email_uuid, **kwargs):  # noqa: E501
        """Get email email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_email_with_http_info(storefront_oid, commseq_email_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :return: EmailCommseqEmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_email_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_email`")  # noqa: E501
        # verify the required parameter 'commseq_email_uuid' is set
        if ('commseq_email_uuid' not in params or
                params['commseq_email_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_email_uuid` when calling `get_email_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_email_uuid' in params:
            path_params['commseq_email_uuid'] = params['commseq_email_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/emails/{commseq_email_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqEmailResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_email_clicks(self, storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, **kwargs):  # noqa: E501
        """Get email email clicks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_email_clicks(storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param str commseq_step_uuid: (required)
        :param str commseq_email_uuid: (required)
        :param int days:
        :return: EmailClicksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_email_clicks_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_email_clicks_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_email_clicks_with_http_info(self, storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, **kwargs):  # noqa: E501
        """Get email email clicks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_email_clicks_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param str commseq_step_uuid: (required)
        :param str commseq_email_uuid: (required)
        :param int days:
        :return: EmailClicksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid', 'commseq_step_uuid', 'commseq_email_uuid', 'days']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_email_clicks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_email_clicks`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `get_email_email_clicks`")  # noqa: E501
        # verify the required parameter 'commseq_step_uuid' is set
        if ('commseq_step_uuid' not in params or
                params['commseq_step_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_step_uuid` when calling `get_email_email_clicks`")  # noqa: E501
        # verify the required parameter 'commseq_email_uuid' is set
        if ('commseq_email_uuid' not in params or
                params['commseq_email_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_email_uuid` when calling `get_email_email_clicks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501
        if 'commseq_step_uuid' in params:
            path_params['commseq_step_uuid'] = params['commseq_step_uuid']  # noqa: E501
        if 'commseq_email_uuid' in params:
            path_params['commseq_email_uuid'] = params['commseq_email_uuid']  # noqa: E501

        query_params = []
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/steps/{commseq_step_uuid}/emails/{commseq_email_uuid}/clicks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailClicksResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_email_customer_editor_url(self, storefront_oid, commseq_email_uuid, order_id, **kwargs):  # noqa: E501
        """Get email order customer editor url  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_email_customer_editor_url(storefront_oid, commseq_email_uuid, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :param str order_id: (required)
        :return: EmailCustomerEditorUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_email_customer_editor_url_with_http_info(storefront_oid, commseq_email_uuid, order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_email_customer_editor_url_with_http_info(storefront_oid, commseq_email_uuid, order_id, **kwargs)  # noqa: E501
            return data

    def get_email_email_customer_editor_url_with_http_info(self, storefront_oid, commseq_email_uuid, order_id, **kwargs):  # noqa: E501
        """Get email order customer editor url  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_email_customer_editor_url_with_http_info(storefront_oid, commseq_email_uuid, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :param str order_id: (required)
        :return: EmailCustomerEditorUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_email_uuid', 'order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_email_customer_editor_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_email_customer_editor_url`")  # noqa: E501
        # verify the required parameter 'commseq_email_uuid' is set
        if ('commseq_email_uuid' not in params or
                params['commseq_email_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_email_uuid` when calling `get_email_email_customer_editor_url`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `get_email_email_customer_editor_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_email_uuid' in params:
            path_params['commseq_email_uuid'] = params['commseq_email_uuid']  # noqa: E501
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/emails/{commseq_email_uuid}/orders/{order_id}/editor_url', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCustomerEditorUrlResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_email_orders(self, storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, **kwargs):  # noqa: E501
        """Get email email orders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_email_orders(storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param str commseq_step_uuid: (required)
        :param str commseq_email_uuid: (required)
        :param int days:
        :return: EmailOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_email_orders_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_email_orders_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_email_orders_with_http_info(self, storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, **kwargs):  # noqa: E501
        """Get email email orders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_email_orders_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, commseq_email_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param str commseq_step_uuid: (required)
        :param str commseq_email_uuid: (required)
        :param int days:
        :return: EmailOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid', 'commseq_step_uuid', 'commseq_email_uuid', 'days']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_email_orders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_email_orders`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `get_email_email_orders`")  # noqa: E501
        # verify the required parameter 'commseq_step_uuid' is set
        if ('commseq_step_uuid' not in params or
                params['commseq_step_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_step_uuid` when calling `get_email_email_orders`")  # noqa: E501
        # verify the required parameter 'commseq_email_uuid' is set
        if ('commseq_email_uuid' not in params or
                params['commseq_email_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_email_uuid` when calling `get_email_email_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501
        if 'commseq_step_uuid' in params:
            path_params['commseq_step_uuid'] = params['commseq_step_uuid']  # noqa: E501
        if 'commseq_email_uuid' in params:
            path_params['commseq_email_uuid'] = params['commseq_email_uuid']  # noqa: E501

        query_params = []
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/steps/{commseq_step_uuid}/emails/{commseq_email_uuid}/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailOrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_emails(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email emails  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_emails(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailCommseqEmailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_emails_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_emails_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_emails_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email emails  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_emails_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailCommseqEmailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_emails" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_emails`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/emails', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqEmailsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_emails_multiple(self, storefront_oid, email_commseq_emails_request, **kwargs):  # noqa: E501
        """Get email emails multiple  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_emails_multiple(storefront_oid, email_commseq_emails_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseqEmailsRequest email_commseq_emails_request: Request of email uuids (required)
        :return: EmailCommseqEmailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_emails_multiple_with_http_info(storefront_oid, email_commseq_emails_request, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_emails_multiple_with_http_info(storefront_oid, email_commseq_emails_request, **kwargs)  # noqa: E501
            return data

    def get_email_emails_multiple_with_http_info(self, storefront_oid, email_commseq_emails_request, **kwargs):  # noqa: E501
        """Get email emails multiple  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_emails_multiple_with_http_info(storefront_oid, email_commseq_emails_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseqEmailsRequest email_commseq_emails_request: Request of email uuids (required)
        :return: EmailCommseqEmailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_commseq_emails_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_emails_multiple" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_emails_multiple`")  # noqa: E501
        # verify the required parameter 'email_commseq_emails_request' is set
        if ('email_commseq_emails_request' not in params or
                params['email_commseq_emails_request'] is None):
            raise ValueError("Missing the required parameter `email_commseq_emails_request` when calling `get_email_emails_multiple`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq_emails_request' in params:
            body_params = params['email_commseq_emails_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/emails/multiple', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqEmailsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_flow(self, storefront_oid, email_flow_uuid, **kwargs):  # noqa: E501
        """Get email flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_flow(storefront_oid, email_flow_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_uuid: (required)
        :return: EmailFlowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_flow_with_http_info(storefront_oid, email_flow_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_flow_with_http_info(storefront_oid, email_flow_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_flow_with_http_info(self, storefront_oid, email_flow_uuid, **kwargs):  # noqa: E501
        """Get email flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_flow_with_http_info(storefront_oid, email_flow_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_uuid: (required)
        :return: EmailFlowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_flow_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_flow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_flow`")  # noqa: E501
        # verify the required parameter 'email_flow_uuid' is set
        if ('email_flow_uuid' not in params or
                params['email_flow_uuid'] is None):
            raise ValueError("Missing the required parameter `email_flow_uuid` when calling `get_email_flow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_flow_uuid' in params:
            path_params['email_flow_uuid'] = params['email_flow_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flows/{email_flow_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailFlowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_flow_folder(self, storefront_oid, email_flow_folder_uuid, **kwargs):  # noqa: E501
        """Get email flow folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_flow_folder(storefront_oid, email_flow_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_folder_uuid: (required)
        :return: EmailFlowFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_flow_folder_with_http_info(storefront_oid, email_flow_folder_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_flow_folder_with_http_info(storefront_oid, email_flow_folder_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_flow_folder_with_http_info(self, storefront_oid, email_flow_folder_uuid, **kwargs):  # noqa: E501
        """Get email flow folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_flow_folder_with_http_info(storefront_oid, email_flow_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_folder_uuid: (required)
        :return: EmailFlowFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_flow_folder_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_flow_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_flow_folder`")  # noqa: E501
        # verify the required parameter 'email_flow_folder_uuid' is set
        if ('email_flow_folder_uuid' not in params or
                params['email_flow_folder_uuid'] is None):
            raise ValueError("Missing the required parameter `email_flow_folder_uuid` when calling `get_email_flow_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_flow_folder_uuid' in params:
            path_params['email_flow_folder_uuid'] = params['email_flow_folder_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flow_folders/{email_flow_folder_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailFlowFolderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_flow_folders(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email flow folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_flow_folders(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailFlowFoldersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_flow_folders_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_flow_folders_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_flow_folders_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email flow folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_flow_folders_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailFlowFoldersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_flow_folders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_flow_folders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flow_folders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailFlowFoldersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_flow_screenshots(self, storefront_oid, email_flow_uuid, **kwargs):  # noqa: E501
        """Get email flow screenshots  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_flow_screenshots(storefront_oid, email_flow_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_uuid: (required)
        :return: ScreenshotsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_flow_screenshots_with_http_info(storefront_oid, email_flow_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_flow_screenshots_with_http_info(storefront_oid, email_flow_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_flow_screenshots_with_http_info(self, storefront_oid, email_flow_uuid, **kwargs):  # noqa: E501
        """Get email flow screenshots  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_flow_screenshots_with_http_info(storefront_oid, email_flow_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_uuid: (required)
        :return: ScreenshotsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_flow_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_flow_screenshots" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_flow_screenshots`")  # noqa: E501
        # verify the required parameter 'email_flow_uuid' is set
        if ('email_flow_uuid' not in params or
                params['email_flow_uuid'] is None):
            raise ValueError("Missing the required parameter `email_flow_uuid` when calling `get_email_flow_screenshots`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_flow_uuid' in params:
            path_params['email_flow_uuid'] = params['email_flow_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flows/{email_flow_uuid}/screenshots', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenshotsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_flows(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email flows  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_flows(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailFlowsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_flows_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_flows_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_flows_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email flows  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_flows_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailFlowsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_flows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_flows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flows', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailFlowsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_global_settings(self, **kwargs):  # noqa: E501
        """Get email globalsettings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_global_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EmailGlobalSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_global_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_email_global_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_email_global_settings_with_http_info(self, **kwargs):  # noqa: E501
        """Get email globalsettings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_global_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EmailGlobalSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_global_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/email/global_settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailGlobalSettingsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_list(self, storefront_oid, email_list_uuid, **kwargs):  # noqa: E501
        """Get email list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_list(storefront_oid, email_list_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :return: EmailListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_list_with_http_info(storefront_oid, email_list_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_list_with_http_info(storefront_oid, email_list_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_list_with_http_info(self, storefront_oid, email_list_uuid, **kwargs):  # noqa: E501
        """Get email list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_list_with_http_info(storefront_oid, email_list_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :return: EmailListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_list`")  # noqa: E501
        # verify the required parameter 'email_list_uuid' is set
        if ('email_list_uuid' not in params or
                params['email_list_uuid'] is None):
            raise ValueError("Missing the required parameter `email_list_uuid` when calling `get_email_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_list_uuid' in params:
            path_params['email_list_uuid'] = params['email_list_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/lists/{email_list_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_list_customer_editor_url(self, storefront_oid, email_list_uuid, email_customer_uuid, **kwargs):  # noqa: E501
        """Get email list customer editor url  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_list_customer_editor_url(storefront_oid, email_list_uuid, email_customer_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param str email_customer_uuid: (required)
        :return: EmailCustomerEditorUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_list_customer_editor_url_with_http_info(storefront_oid, email_list_uuid, email_customer_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_list_customer_editor_url_with_http_info(storefront_oid, email_list_uuid, email_customer_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_list_customer_editor_url_with_http_info(self, storefront_oid, email_list_uuid, email_customer_uuid, **kwargs):  # noqa: E501
        """Get email list customer editor url  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_list_customer_editor_url_with_http_info(storefront_oid, email_list_uuid, email_customer_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param str email_customer_uuid: (required)
        :return: EmailCustomerEditorUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_uuid', 'email_customer_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_list_customer_editor_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_list_customer_editor_url`")  # noqa: E501
        # verify the required parameter 'email_list_uuid' is set
        if ('email_list_uuid' not in params or
                params['email_list_uuid'] is None):
            raise ValueError("Missing the required parameter `email_list_uuid` when calling `get_email_list_customer_editor_url`")  # noqa: E501
        # verify the required parameter 'email_customer_uuid' is set
        if ('email_customer_uuid' not in params or
                params['email_customer_uuid'] is None):
            raise ValueError("Missing the required parameter `email_customer_uuid` when calling `get_email_list_customer_editor_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_list_uuid' in params:
            path_params['email_list_uuid'] = params['email_list_uuid']  # noqa: E501
        if 'email_customer_uuid' in params:
            path_params['email_customer_uuid'] = params['email_customer_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/lists/{email_list_uuid}/customers/{email_customer_uuid}/editor_url', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCustomerEditorUrlResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_list_customers(self, storefront_oid, email_list_uuid, **kwargs):  # noqa: E501
        """Get email list customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_list_customers(storefront_oid, email_list_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param int page_number:
        :param int page_size:
        :return: EmailListCustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_list_customers_with_http_info(storefront_oid, email_list_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_list_customers_with_http_info(storefront_oid, email_list_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_list_customers_with_http_info(self, storefront_oid, email_list_uuid, **kwargs):  # noqa: E501
        """Get email list customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_list_customers_with_http_info(storefront_oid, email_list_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param int page_number:
        :param int page_size:
        :return: EmailListCustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_uuid', 'page_number', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_list_customers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_list_customers`")  # noqa: E501
        # verify the required parameter 'email_list_uuid' is set
        if ('email_list_uuid' not in params or
                params['email_list_uuid'] is None):
            raise ValueError("Missing the required parameter `email_list_uuid` when calling `get_email_list_customers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_list_uuid' in params:
            path_params['email_list_uuid'] = params['email_list_uuid']  # noqa: E501

        query_params = []
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/lists/{email_list_uuid}/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListCustomersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_list_segment_folder(self, storefront_oid, email_list_segment_folder_uuid, **kwargs):  # noqa: E501
        """Get email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_list_segment_folder(storefront_oid, email_list_segment_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_segment_folder_uuid: (required)
        :return: EmailListSegmentFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_list_segment_folder_with_http_info(self, storefront_oid, email_list_segment_folder_uuid, **kwargs):  # noqa: E501
        """Get email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_segment_folder_uuid: (required)
        :return: EmailListSegmentFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_segment_folder_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_list_segment_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_list_segment_folder`")  # noqa: E501
        # verify the required parameter 'email_list_segment_folder_uuid' is set
        if ('email_list_segment_folder_uuid' not in params or
                params['email_list_segment_folder_uuid'] is None):
            raise ValueError("Missing the required parameter `email_list_segment_folder_uuid` when calling `get_email_list_segment_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_list_segment_folder_uuid' in params:
            path_params['email_list_segment_folder_uuid'] = params['email_list_segment_folder_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/list_segment_folders/{email_list_segment_folder_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListSegmentFolderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_list_segment_folders(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email campaign folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_list_segment_folders(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailListSegmentFoldersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_list_segment_folders_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_list_segment_folders_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_list_segment_folders_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email campaign folders  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_list_segment_folders_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailListSegmentFoldersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_list_segment_folders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_list_segment_folders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/list_segment_folders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListSegmentFoldersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_lists(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email lists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_lists(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailListsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_lists_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_lists_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_lists_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email lists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_lists_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailListsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_lists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_lists`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/lists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_performance(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email performance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_performance(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailPerformanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_performance_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_performance_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_performance_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email performance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_performance_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailPerformanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_performance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_performance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/performance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailPerformanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_plan(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email plan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_plan(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailPlanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_plan_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_plan_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_plan_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email plan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_plan_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailPlanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/plan', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailPlanResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_postcard(self, storefront_oid, commseq_postcard_uuid, **kwargs):  # noqa: E501
        """Get email postcard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_postcard(storefront_oid, commseq_postcard_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_postcard_uuid: (required)
        :return: EmailCommseqPostcardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_postcard_with_http_info(storefront_oid, commseq_postcard_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_postcard_with_http_info(storefront_oid, commseq_postcard_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_postcard_with_http_info(self, storefront_oid, commseq_postcard_uuid, **kwargs):  # noqa: E501
        """Get email postcard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_postcard_with_http_info(storefront_oid, commseq_postcard_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_postcard_uuid: (required)
        :return: EmailCommseqPostcardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_postcard_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_postcard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_postcard`")  # noqa: E501
        # verify the required parameter 'commseq_postcard_uuid' is set
        if ('commseq_postcard_uuid' not in params or
                params['commseq_postcard_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_postcard_uuid` when calling `get_email_postcard`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_postcard_uuid' in params:
            path_params['commseq_postcard_uuid'] = params['commseq_postcard_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/postcards/{commseq_postcard_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqPostcardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_postcards(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email postcards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_postcards(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailCommseqPostcardsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_postcards_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_postcards_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_postcards_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email postcards  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_postcards_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailCommseqPostcardsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_postcards" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_postcards`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/postcards', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqPostcardsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_postcards_multiple(self, storefront_oid, email_commseq_postcards_request, **kwargs):  # noqa: E501
        """Get email postcards multiple  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_postcards_multiple(storefront_oid, email_commseq_postcards_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseqPostcardsRequest email_commseq_postcards_request: Request of postcard uuids (required)
        :return: EmailCommseqPostcardsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_postcards_multiple_with_http_info(storefront_oid, email_commseq_postcards_request, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_postcards_multiple_with_http_info(storefront_oid, email_commseq_postcards_request, **kwargs)  # noqa: E501
            return data

    def get_email_postcards_multiple_with_http_info(self, storefront_oid, email_commseq_postcards_request, **kwargs):  # noqa: E501
        """Get email postcards multiple  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_postcards_multiple_with_http_info(storefront_oid, email_commseq_postcards_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseqPostcardsRequest email_commseq_postcards_request: Request of postcard uuids (required)
        :return: EmailCommseqPostcardsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_commseq_postcards_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_postcards_multiple" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_postcards_multiple`")  # noqa: E501
        # verify the required parameter 'email_commseq_postcards_request' is set
        if ('email_commseq_postcards_request' not in params or
                params['email_commseq_postcards_request'] is None):
            raise ValueError("Missing the required parameter `email_commseq_postcards_request` when calling `get_email_postcards_multiple`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq_postcards_request' in params:
            body_params = params['email_commseq_postcards_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/postcards/multiple', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqPostcardsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_segment(self, storefront_oid, email_segment_uuid, **kwargs):  # noqa: E501
        """Get email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_segment(storefront_oid, email_segment_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :return: EmailSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_segment_with_http_info(storefront_oid, email_segment_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_segment_with_http_info(storefront_oid, email_segment_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_segment_with_http_info(self, storefront_oid, email_segment_uuid, **kwargs):  # noqa: E501
        """Get email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_segment_with_http_info(storefront_oid, email_segment_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :return: EmailSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_segment_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_segment`")  # noqa: E501
        # verify the required parameter 'email_segment_uuid' is set
        if ('email_segment_uuid' not in params or
                params['email_segment_uuid'] is None):
            raise ValueError("Missing the required parameter `email_segment_uuid` when calling `get_email_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_segment_uuid' in params:
            path_params['email_segment_uuid'] = params['email_segment_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/segments/{email_segment_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSegmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_segment_customer_editor_url(self, storefront_oid, email_segment_uuid, email_customer_uuid, **kwargs):  # noqa: E501
        """Get email segment customers editor URL  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_segment_customer_editor_url(storefront_oid, email_segment_uuid, email_customer_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :param str email_customer_uuid: (required)
        :return: EmailCustomerEditorUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_segment_customer_editor_url_with_http_info(storefront_oid, email_segment_uuid, email_customer_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_segment_customer_editor_url_with_http_info(storefront_oid, email_segment_uuid, email_customer_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_segment_customer_editor_url_with_http_info(self, storefront_oid, email_segment_uuid, email_customer_uuid, **kwargs):  # noqa: E501
        """Get email segment customers editor URL  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_segment_customer_editor_url_with_http_info(storefront_oid, email_segment_uuid, email_customer_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :param str email_customer_uuid: (required)
        :return: EmailCustomerEditorUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_segment_uuid', 'email_customer_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_segment_customer_editor_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_segment_customer_editor_url`")  # noqa: E501
        # verify the required parameter 'email_segment_uuid' is set
        if ('email_segment_uuid' not in params or
                params['email_segment_uuid'] is None):
            raise ValueError("Missing the required parameter `email_segment_uuid` when calling `get_email_segment_customer_editor_url`")  # noqa: E501
        # verify the required parameter 'email_customer_uuid' is set
        if ('email_customer_uuid' not in params or
                params['email_customer_uuid'] is None):
            raise ValueError("Missing the required parameter `email_customer_uuid` when calling `get_email_segment_customer_editor_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_segment_uuid' in params:
            path_params['email_segment_uuid'] = params['email_segment_uuid']  # noqa: E501
        if 'email_customer_uuid' in params:
            path_params['email_customer_uuid'] = params['email_customer_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/segments/{email_segment_uuid}/customers/{email_customer_uuid}/editor_url', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCustomerEditorUrlResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_segment_customers(self, storefront_oid, email_segment_uuid, **kwargs):  # noqa: E501
        """Get email segment customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_segment_customers(storefront_oid, email_segment_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :param int page_number:
        :param int page_size:
        :return: EmailSegmentCustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_segment_customers_with_http_info(storefront_oid, email_segment_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_segment_customers_with_http_info(storefront_oid, email_segment_uuid, **kwargs)  # noqa: E501
            return data

    def get_email_segment_customers_with_http_info(self, storefront_oid, email_segment_uuid, **kwargs):  # noqa: E501
        """Get email segment customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_segment_customers_with_http_info(storefront_oid, email_segment_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :param int page_number:
        :param int page_size:
        :return: EmailSegmentCustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_segment_uuid', 'page_number', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_segment_customers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_segment_customers`")  # noqa: E501
        # verify the required parameter 'email_segment_uuid' is set
        if ('email_segment_uuid' not in params or
                params['email_segment_uuid'] is None):
            raise ValueError("Missing the required parameter `email_segment_uuid` when calling `get_email_segment_customers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_segment_uuid' in params:
            path_params['email_segment_uuid'] = params['email_segment_uuid']  # noqa: E501

        query_params = []
        if 'page_number' in params:
            query_params.append(('pageNumber', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/segments/{email_segment_uuid}/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSegmentCustomersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_segments(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email segments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_segments(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailSegmentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_segments_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_segments_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_segments_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email segments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_segments_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailSegmentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_segments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_segments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/segments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSegmentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_sending_domain(self, domain, **kwargs):  # noqa: E501
        """Get email sending domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_sending_domain(domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: (required)
        :return: EmailSendingDomainResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_sending_domain_with_http_info(domain, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_sending_domain_with_http_info(domain, **kwargs)  # noqa: E501
            return data

    def get_email_sending_domain_with_http_info(self, domain, **kwargs):  # noqa: E501
        """Get email sending domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_sending_domain_with_http_info(domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: (required)
        :return: EmailSendingDomainResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_sending_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `get_email_sending_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/email/sending_domain/{domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSendingDomainResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_sending_domain_status(self, domain, **kwargs):  # noqa: E501
        """Get email sending domain status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_sending_domain_status(domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: (required)
        :return: EmailSendingDomainResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_sending_domain_status_with_http_info(domain, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_sending_domain_status_with_http_info(domain, **kwargs)  # noqa: E501
            return data

    def get_email_sending_domain_status_with_http_info(self, domain, **kwargs):  # noqa: E501
        """Get email sending domain status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_sending_domain_status_with_http_info(domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: (required)
        :return: EmailSendingDomainResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_sending_domain_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `get_email_sending_domain_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/email/sending_domains/{domain}/status', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSendingDomainResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_sending_domains(self, **kwargs):  # noqa: E501
        """Get email sending domains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_sending_domains(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EmailSendingDomainsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_sending_domains_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_email_sending_domains_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_email_sending_domains_with_http_info(self, **kwargs):  # noqa: E501
        """Get email sending domains  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_sending_domains_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EmailSendingDomainsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_sending_domains" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/email/sending_domains', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSendingDomainsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_settings(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_settings(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_settings_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_settings_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_settings_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_settings_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSettingsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_template(self, storefront_oid, email_template_oid, **kwargs):  # noqa: E501
        """Get email template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_template(storefront_oid, email_template_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int email_template_oid: (required)
        :return: EmailTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_template_with_http_info(storefront_oid, email_template_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_template_with_http_info(storefront_oid, email_template_oid, **kwargs)  # noqa: E501
            return data

    def get_email_template_with_http_info(self, storefront_oid, email_template_oid, **kwargs):  # noqa: E501
        """Get email template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_template_with_http_info(storefront_oid, email_template_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int email_template_oid: (required)
        :return: EmailTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_template_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_template`")  # noqa: E501
        # verify the required parameter 'email_template_oid' is set
        if ('email_template_oid' not in params or
                params['email_template_oid'] is None):
            raise ValueError("Missing the required parameter `email_template_oid` when calling `get_email_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_template_oid' in params:
            path_params['email_template_oid'] = params['email_template_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/templates/{email_template_oid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailTemplate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_templates(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email templates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_templates(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str trigger_type:
        :return: EmailTemplatesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_templates_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_templates_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_templates_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get email templates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_templates_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str trigger_type:
        :return: EmailTemplatesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'trigger_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_templates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_templates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []
        if 'trigger_type' in params:
            query_params.append(('trigger_type', params['trigger_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailTemplatesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_email_third_party_providers(self, storefront_oid, **kwargs):  # noqa: E501
        """Get a list of third party email providers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_third_party_providers(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailThirdPartyProvidersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_email_third_party_providers_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_email_third_party_providers_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_email_third_party_providers_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get a list of third party email providers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_email_third_party_providers_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: EmailThirdPartyProvidersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_email_third_party_providers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_email_third_party_providers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/third_party_providers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailThirdPartyProvidersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_experiments(self, storefront_oid, **kwargs):  # noqa: E501
        """Get experiments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_experiments(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: ExperimentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_experiments_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_experiments_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_experiments_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get experiments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_experiments_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: ExperimentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_experiments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_experiments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/experiments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExperimentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_heatmap(self, storefront_oid, query, **kwargs):  # noqa: E501
        """Get screen recording heatmap  # noqa: E501

        Get screen recording heatmap   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heatmap(storefront_oid, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingHeatmapRequest query: Query (required)
        :return: ScreenRecordingHeatmapResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_heatmap_with_http_info(storefront_oid, query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_heatmap_with_http_info(storefront_oid, query, **kwargs)  # noqa: E501
            return data

    def get_heatmap_with_http_info(self, storefront_oid, query, **kwargs):  # noqa: E501
        """Get screen recording heatmap  # noqa: E501

        Get screen recording heatmap   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heatmap_with_http_info(storefront_oid, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingHeatmapRequest query: Query (required)
        :return: ScreenRecordingHeatmapResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_heatmap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_heatmap`")  # noqa: E501
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `get_heatmap`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'query' in params:
            body_params = params['query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/heatmap', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingHeatmapResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_heatmap_index(self, storefront_oid, query, **kwargs):  # noqa: E501
        """Get screen recording heatmap index  # noqa: E501

        Get screen recording heatmap index   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heatmap_index(storefront_oid, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingHeatmapIndexRequest query: Query (required)
        :param int limit: The maximum number of records to return on this one API call. (Default 100, Max 500)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: ScreenRecordingHeatmapIndexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_heatmap_index_with_http_info(storefront_oid, query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_heatmap_index_with_http_info(storefront_oid, query, **kwargs)  # noqa: E501
            return data

    def get_heatmap_index_with_http_info(self, storefront_oid, query, **kwargs):  # noqa: E501
        """Get screen recording heatmap index  # noqa: E501

        Get screen recording heatmap index   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_heatmap_index_with_http_info(storefront_oid, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingHeatmapIndexRequest query: Query (required)
        :param int limit: The maximum number of records to return on this one API call. (Default 100, Max 500)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: ScreenRecordingHeatmapIndexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'query', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_heatmap_index" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_heatmap_index`")  # noqa: E501
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `get_heatmap_index`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'query' in params:
            body_params = params['query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/heatmap/index', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingHeatmapIndexResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_histogram_property_names(self, storefront_oid, **kwargs):  # noqa: E501
        """Get histogram property names  # noqa: E501

        Obtain a list of property names for a given property type   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_histogram_property_names(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str property_type:
        :return: EmailHistogramPropertyNamesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_histogram_property_names_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_histogram_property_names_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_histogram_property_names_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get histogram property names  # noqa: E501

        Obtain a list of property names for a given property type   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_histogram_property_names_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str property_type:
        :return: EmailHistogramPropertyNamesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'property_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_histogram_property_names" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_histogram_property_names`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []
        if 'property_type' in params:
            query_params.append(('property_type', params['property_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/histogram/property_names', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailHistogramPropertyNamesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_histogram_property_values(self, storefront_oid, **kwargs):  # noqa: E501
        """Get histogram property values  # noqa: E501

        Obtain a list of property values for a given property name and type   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_histogram_property_values(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str property_name:
        :param str property_type:
        :param int limit:
        :return: EmailHistogramPropertyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_histogram_property_values_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_histogram_property_values_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_histogram_property_values_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get histogram property values  # noqa: E501

        Obtain a list of property values for a given property name and type   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_histogram_property_values_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str property_name:
        :param str property_type:
        :param int limit:
        :return: EmailHistogramPropertyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'property_name', 'property_type', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_histogram_property_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_histogram_property_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []
        if 'property_name' in params:
            query_params.append(('property_name', params['property_name']))  # noqa: E501
        if 'property_type' in params:
            query_params.append(('property_type', params['property_type']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/histogram/property_values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailHistogramPropertyValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_library_filter_values(self, **kwargs):  # noqa: E501
        """Get library values used to populate drop down boxes for filtering.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_library_filter_values(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: LibraryFilterValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_library_filter_values_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_library_filter_values_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_library_filter_values_with_http_info(self, **kwargs):  # noqa: E501
        """Get library values used to populate drop down boxes for filtering.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_library_filter_values_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: LibraryFilterValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_library_filter_values" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/filter_values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryFilterValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_library_item(self, library_item_oid, **kwargs):  # noqa: E501
        """Get library item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_library_item(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_library_item_with_http_info(library_item_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_library_item_with_http_info(library_item_oid, **kwargs)  # noqa: E501
            return data

    def get_library_item_with_http_info(self, library_item_oid, **kwargs):  # noqa: E501
        """Get library item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_library_item_with_http_info(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['library_item_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_library_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'library_item_oid' is set
        if ('library_item_oid' not in params or
                params['library_item_oid'] is None):
            raise ValueError("Missing the required parameter `library_item_oid` when calling `get_library_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_item_oid' in params:
            path_params['library_item_oid'] = params['library_item_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/{library_item_oid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_library_item_published_versions(self, library_item_oid, **kwargs):  # noqa: E501
        """Get all published versions for a library item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_library_item_published_versions(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :return: LibraryItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_library_item_published_versions_with_http_info(library_item_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_library_item_published_versions_with_http_info(library_item_oid, **kwargs)  # noqa: E501
            return data

    def get_library_item_published_versions_with_http_info(self, library_item_oid, **kwargs):  # noqa: E501
        """Get all published versions for a library item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_library_item_published_versions_with_http_info(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :return: LibraryItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['library_item_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_library_item_published_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'library_item_oid' is set
        if ('library_item_oid' not in params or
                params['library_item_oid'] is None):
            raise ValueError("Missing the required parameter `library_item_oid` when calling `get_library_item_published_versions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_item_oid' in params:
            path_params['library_item_oid'] = params['library_item_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/{library_item_oid}/published_versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryItemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_screen_recording(self, storefront_oid, screen_recording_uuid, **kwargs):  # noqa: E501
        """Get screen recording  # noqa: E501

        Get screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording(storefront_oid, screen_recording_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :return: ScreenRecordingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_screen_recording_with_http_info(storefront_oid, screen_recording_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_screen_recording_with_http_info(storefront_oid, screen_recording_uuid, **kwargs)  # noqa: E501
            return data

    def get_screen_recording_with_http_info(self, storefront_oid, screen_recording_uuid, **kwargs):  # noqa: E501
        """Get screen recording  # noqa: E501

        Get screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording_with_http_info(storefront_oid, screen_recording_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :return: ScreenRecordingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'screen_recording_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_screen_recording" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_screen_recording`")  # noqa: E501
        # verify the required parameter 'screen_recording_uuid' is set
        if ('screen_recording_uuid' not in params or
                params['screen_recording_uuid'] is None):
            raise ValueError("Missing the required parameter `screen_recording_uuid` when calling `get_screen_recording`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'screen_recording_uuid' in params:
            path_params['screen_recording_uuid'] = params['screen_recording_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_screen_recording_page_view_data(self, storefront_oid, screen_recording_uuid, screen_recording_page_view_uuid, **kwargs):  # noqa: E501
        """Get screen recording page view data  # noqa: E501

        Get screen recording page view data   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording_page_view_data(storefront_oid, screen_recording_uuid, screen_recording_page_view_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :param str screen_recording_page_view_uuid: (required)
        :return: ScreenRecordingPageViewDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_screen_recording_page_view_data_with_http_info(storefront_oid, screen_recording_uuid, screen_recording_page_view_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_screen_recording_page_view_data_with_http_info(storefront_oid, screen_recording_uuid, screen_recording_page_view_uuid, **kwargs)  # noqa: E501
            return data

    def get_screen_recording_page_view_data_with_http_info(self, storefront_oid, screen_recording_uuid, screen_recording_page_view_uuid, **kwargs):  # noqa: E501
        """Get screen recording page view data  # noqa: E501

        Get screen recording page view data   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording_page_view_data_with_http_info(storefront_oid, screen_recording_uuid, screen_recording_page_view_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :param str screen_recording_page_view_uuid: (required)
        :return: ScreenRecordingPageViewDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'screen_recording_uuid', 'screen_recording_page_view_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_screen_recording_page_view_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_screen_recording_page_view_data`")  # noqa: E501
        # verify the required parameter 'screen_recording_uuid' is set
        if ('screen_recording_uuid' not in params or
                params['screen_recording_uuid'] is None):
            raise ValueError("Missing the required parameter `screen_recording_uuid` when calling `get_screen_recording_page_view_data`")  # noqa: E501
        # verify the required parameter 'screen_recording_page_view_uuid' is set
        if ('screen_recording_page_view_uuid' not in params or
                params['screen_recording_page_view_uuid'] is None):
            raise ValueError("Missing the required parameter `screen_recording_page_view_uuid` when calling `get_screen_recording_page_view_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'screen_recording_uuid' in params:
            path_params['screen_recording_uuid'] = params['screen_recording_uuid']  # noqa: E501
        if 'screen_recording_page_view_uuid' in params:
            path_params['screen_recording_page_view_uuid'] = params['screen_recording_page_view_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid}/page_view_data/{screen_recording_page_view_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingPageViewDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_screen_recording_segment(self, storefront_oid, screen_recording_segment_oid, **kwargs):  # noqa: E501
        """Get screen recording segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording_segment(storefront_oid, screen_recording_segment_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int screen_recording_segment_oid: (required)
        :return: ScreenRecordingSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_screen_recording_segment_with_http_info(storefront_oid, screen_recording_segment_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_screen_recording_segment_with_http_info(storefront_oid, screen_recording_segment_oid, **kwargs)  # noqa: E501
            return data

    def get_screen_recording_segment_with_http_info(self, storefront_oid, screen_recording_segment_oid, **kwargs):  # noqa: E501
        """Get screen recording segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording_segment_with_http_info(storefront_oid, screen_recording_segment_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int screen_recording_segment_oid: (required)
        :return: ScreenRecordingSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'screen_recording_segment_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_screen_recording_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_screen_recording_segment`")  # noqa: E501
        # verify the required parameter 'screen_recording_segment_oid' is set
        if ('screen_recording_segment_oid' not in params or
                params['screen_recording_segment_oid'] is None):
            raise ValueError("Missing the required parameter `screen_recording_segment_oid` when calling `get_screen_recording_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'screen_recording_segment_oid' in params:
            path_params['screen_recording_segment_oid'] = params['screen_recording_segment_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/segments/{screen_recording_segment_oid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingSegmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_screen_recording_segments(self, storefront_oid, **kwargs):  # noqa: E501
        """Get screen recording segments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording_segments(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: ScreenRecordingSegmentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_screen_recording_segments_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_screen_recording_segments_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_screen_recording_segments_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get screen recording segments  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording_segments_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: ScreenRecordingSegmentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_screen_recording_segments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_screen_recording_segments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/segments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingSegmentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_screen_recording_settings(self, storefront_oid, **kwargs):  # noqa: E501
        """Get screen recording settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording_settings(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: ScreenRecordingSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_screen_recording_settings_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_screen_recording_settings_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_screen_recording_settings_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get screen recording settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording_settings_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: ScreenRecordingSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_screen_recording_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_screen_recording_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingSettingsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_screen_recording_tags(self, storefront_oid, **kwargs):  # noqa: E501
        """Get tags used by screen recording  # noqa: E501

        Get tags used by screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording_tags(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: ScreenRecordingTagsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_screen_recording_tags_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_screen_recording_tags_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_screen_recording_tags_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Get tags used by screen recording  # noqa: E501

        Get tags used by screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recording_tags_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: ScreenRecordingTagsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_screen_recording_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_screen_recording_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingTagsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_screen_recordings_by_query(self, storefront_oid, query, **kwargs):  # noqa: E501
        """Query screen recordings  # noqa: E501

        Query screen recordings   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recordings_by_query(storefront_oid, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingQueryRequest query: Query (required)
        :param int limit: The maximum number of records to return on this one API call. (Default 100, Max 500)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: ScreenRecordingQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_screen_recordings_by_query_with_http_info(storefront_oid, query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_screen_recordings_by_query_with_http_info(storefront_oid, query, **kwargs)  # noqa: E501
            return data

    def get_screen_recordings_by_query_with_http_info(self, storefront_oid, query, **kwargs):  # noqa: E501
        """Query screen recordings  # noqa: E501

        Query screen recordings   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recordings_by_query_with_http_info(storefront_oid, query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingQueryRequest query: Query (required)
        :param int limit: The maximum number of records to return on this one API call. (Default 100, Max 500)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: ScreenRecordingQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'query', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_screen_recordings_by_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_screen_recordings_by_query`")  # noqa: E501
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `get_screen_recordings_by_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'query' in params:
            body_params = params['query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingQueryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_screen_recordings_by_segment(self, storefront_oid, screen_recording_segment_oid, **kwargs):  # noqa: E501
        """Get screen recordings by segment  # noqa: E501

        Get screen recordings by segment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recordings_by_segment(storefront_oid, screen_recording_segment_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int screen_recording_segment_oid: (required)
        :param int limit: The maximum number of records to return on this one API call. (Default 100, Max 500)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: ScreenRecordingQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_screen_recordings_by_segment_with_http_info(storefront_oid, screen_recording_segment_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_screen_recordings_by_segment_with_http_info(storefront_oid, screen_recording_segment_oid, **kwargs)  # noqa: E501
            return data

    def get_screen_recordings_by_segment_with_http_info(self, storefront_oid, screen_recording_segment_oid, **kwargs):  # noqa: E501
        """Get screen recordings by segment  # noqa: E501

        Get screen recordings by segment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_screen_recordings_by_segment_with_http_info(storefront_oid, screen_recording_segment_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int screen_recording_segment_oid: (required)
        :param int limit: The maximum number of records to return on this one API call. (Default 100, Max 500)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: ScreenRecordingQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'screen_recording_segment_oid', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_screen_recordings_by_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_screen_recordings_by_segment`")  # noqa: E501
        # verify the required parameter 'screen_recording_segment_oid' is set
        if ('screen_recording_segment_oid' not in params or
                params['screen_recording_segment_oid'] is None):
            raise ValueError("Missing the required parameter `screen_recording_segment_oid` when calling `get_screen_recordings_by_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'screen_recording_segment_oid' in params:
            path_params['screen_recording_segment_oid'] = params['screen_recording_segment_oid']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/segments/{screen_recording_segment_oid}/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingQueryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_store_front_pricing_tiers(self, **kwargs):  # noqa: E501
        """Retrieve pricing tiers  # noqa: E501

        Retrieves the pricing tiers   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_store_front_pricing_tiers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: PricingTiersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_store_front_pricing_tiers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_store_front_pricing_tiers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_store_front_pricing_tiers_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve pricing tiers  # noqa: E501

        Retrieves the pricing tiers   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_store_front_pricing_tiers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: PricingTiersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_store_front_pricing_tiers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/pricing_tiers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PricingTiersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_thumbnail_parameters(self, thumbnail_parameters, **kwargs):  # noqa: E501
        """Get thumbnail parameters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thumbnail_parameters(thumbnail_parameters, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThumbnailParametersRequest thumbnail_parameters: Thumbnail Parameters (required)
        :return: ThumbnailParametersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_thumbnail_parameters_with_http_info(thumbnail_parameters, **kwargs)  # noqa: E501
        else:
            (data) = self.get_thumbnail_parameters_with_http_info(thumbnail_parameters, **kwargs)  # noqa: E501
            return data

    def get_thumbnail_parameters_with_http_info(self, thumbnail_parameters, **kwargs):  # noqa: E501
        """Get thumbnail parameters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_thumbnail_parameters_with_http_info(thumbnail_parameters, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThumbnailParametersRequest thumbnail_parameters: Thumbnail Parameters (required)
        :return: ThumbnailParametersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['thumbnail_parameters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_thumbnail_parameters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'thumbnail_parameters' is set
        if ('thumbnail_parameters' not in params or
                params['thumbnail_parameters'] is None):
            raise ValueError("Missing the required parameter `thumbnail_parameters` when calling `get_thumbnail_parameters`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'thumbnail_parameters' in params:
            body_params = params['thumbnail_parameters']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/thumbnailParameters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThumbnailParametersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transaction_email(self, storefront_oid, email_id, **kwargs):  # noqa: E501
        """Gets a transaction email object  # noqa: E501

        Fetch a transactional email   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_email(storefront_oid, email_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_id: (required)
        :return: TransactionEmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transaction_email_with_http_info(storefront_oid, email_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_transaction_email_with_http_info(storefront_oid, email_id, **kwargs)  # noqa: E501
            return data

    def get_transaction_email_with_http_info(self, storefront_oid, email_id, **kwargs):  # noqa: E501
        """Gets a transaction email object  # noqa: E501

        Fetch a transactional email   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_email_with_http_info(storefront_oid, email_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_id: (required)
        :return: TransactionEmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_transaction_email`")  # noqa: E501
        # verify the required parameter 'email_id' is set
        if ('email_id' not in params or
                params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `get_transaction_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_id' in params:
            path_params['email_id'] = params['email_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/transaction_email/list/{email_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionEmailResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transaction_email_list(self, storefront_oid, **kwargs):  # noqa: E501
        """Gets a list of transaction email names  # noqa: E501

        Obtain a list of all transactional emails and return back just their names   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_email_list(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: TransactionEmailListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transaction_email_list_with_http_info(storefront_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_transaction_email_list_with_http_info(storefront_oid, **kwargs)  # noqa: E501
            return data

    def get_transaction_email_list_with_http_info(self, storefront_oid, **kwargs):  # noqa: E501
        """Gets a list of transaction email names  # noqa: E501

        Obtain a list of all transactional emails and return back just their names   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_email_list_with_http_info(storefront_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :return: TransactionEmailListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_email_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_transaction_email_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/transaction_email/list', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionEmailListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transaction_email_screenshots(self, storefront_oid, email_id, **kwargs):  # noqa: E501
        """Get transactional email screenshots  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_email_screenshots(storefront_oid, email_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_id: (required)
        :return: ScreenshotsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transaction_email_screenshots_with_http_info(storefront_oid, email_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_transaction_email_screenshots_with_http_info(storefront_oid, email_id, **kwargs)  # noqa: E501
            return data

    def get_transaction_email_screenshots_with_http_info(self, storefront_oid, email_id, **kwargs):  # noqa: E501
        """Get transactional email screenshots  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_email_screenshots_with_http_info(storefront_oid, email_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_id: (required)
        :return: ScreenshotsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_email_screenshots" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `get_transaction_email_screenshots`")  # noqa: E501
        # verify the required parameter 'email_id' is set
        if ('email_id' not in params or
                params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `get_transaction_email_screenshots`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_id' in params:
            path_params['email_id'] = params['email_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/transaction_email/list/{email_id}/screenshots', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenshotsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_twilio_account(self, esp_twilio_uuid, **kwargs):  # noqa: E501
        """Get Twilio account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_twilio_account(esp_twilio_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str esp_twilio_uuid: (required)
        :return: TwilioResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_twilio_account_with_http_info(esp_twilio_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_twilio_account_with_http_info(esp_twilio_uuid, **kwargs)  # noqa: E501
            return data

    def get_twilio_account_with_http_info(self, esp_twilio_uuid, **kwargs):  # noqa: E501
        """Get Twilio account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_twilio_account_with_http_info(esp_twilio_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str esp_twilio_uuid: (required)
        :return: TwilioResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['esp_twilio_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_twilio_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'esp_twilio_uuid' is set
        if ('esp_twilio_uuid' not in params or
                params['esp_twilio_uuid'] is None):
            raise ValueError("Missing the required parameter `esp_twilio_uuid` when calling `get_twilio_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'esp_twilio_uuid' in params:
            path_params['esp_twilio_uuid'] = params['esp_twilio_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/twilio/accounts/{esp_twilio_uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TwilioResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_twilio_accounts(self, **kwargs):  # noqa: E501
        """Get all Twilio accounts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_twilio_accounts(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TwiliosResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_twilio_accounts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_twilio_accounts_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_twilio_accounts_with_http_info(self, **kwargs):  # noqa: E501
        """Get all Twilio accounts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_twilio_accounts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TwiliosResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_twilio_accounts" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/twilio/accounts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TwiliosResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def global_unsubscribe(self, storefront_oid, unsubscribe, **kwargs):  # noqa: E501
        """Globally unsubscribe a customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.global_unsubscribe(storefront_oid, unsubscribe, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailGlobalUnsubscribeRequest unsubscribe: Unsubscribe (required)
        :return: EmailGlobalUnsubscribeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.global_unsubscribe_with_http_info(storefront_oid, unsubscribe, **kwargs)  # noqa: E501
        else:
            (data) = self.global_unsubscribe_with_http_info(storefront_oid, unsubscribe, **kwargs)  # noqa: E501
            return data

    def global_unsubscribe_with_http_info(self, storefront_oid, unsubscribe, **kwargs):  # noqa: E501
        """Globally unsubscribe a customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.global_unsubscribe_with_http_info(storefront_oid, unsubscribe, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailGlobalUnsubscribeRequest unsubscribe: Unsubscribe (required)
        :return: EmailGlobalUnsubscribeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'unsubscribe']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method global_unsubscribe" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `global_unsubscribe`")  # noqa: E501
        # verify the required parameter 'unsubscribe' is set
        if ('unsubscribe' not in params or
                params['unsubscribe'] is None):
            raise ValueError("Missing the required parameter `unsubscribe` when calling `global_unsubscribe`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unsubscribe' in params:
            body_params = params['unsubscribe']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/globalUnsubscribe', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailGlobalUnsubscribeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_email_third_party_provider_list(self, storefront_oid, import_request, **kwargs):  # noqa: E501
        """Import a third party provider list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_email_third_party_provider_list(storefront_oid, import_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailThirdPartyListImportRequest import_request: lists to import (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_email_third_party_provider_list_with_http_info(storefront_oid, import_request, **kwargs)  # noqa: E501
        else:
            (data) = self.import_email_third_party_provider_list_with_http_info(storefront_oid, import_request, **kwargs)  # noqa: E501
            return data

    def import_email_third_party_provider_list_with_http_info(self, storefront_oid, import_request, **kwargs):  # noqa: E501
        """Import a third party provider list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_email_third_party_provider_list_with_http_info(storefront_oid, import_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailThirdPartyListImportRequest import_request: lists to import (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'import_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_email_third_party_provider_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `import_email_third_party_provider_list`")  # noqa: E501
        # verify the required parameter 'import_request' is set
        if ('import_request' not in params or
                params['import_request'] is None):
            raise ValueError("Missing the required parameter `import_request` when calling `import_email_third_party_provider_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'import_request' in params:
            body_params = params['import_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/third_party_providers/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_email_campaign(self, storefront_oid, email_campaign, **kwargs):  # noqa: E501
        """Insert email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_campaign(storefront_oid, email_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCampaign email_campaign: Email campaign (required)
        :return: EmailCampaignResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_email_campaign_with_http_info(storefront_oid, email_campaign, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_email_campaign_with_http_info(storefront_oid, email_campaign, **kwargs)  # noqa: E501
            return data

    def insert_email_campaign_with_http_info(self, storefront_oid, email_campaign, **kwargs):  # noqa: E501
        """Insert email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_campaign_with_http_info(storefront_oid, email_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCampaign email_campaign: Email campaign (required)
        :return: EmailCampaignResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_campaign']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_email_campaign" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `insert_email_campaign`")  # noqa: E501
        # verify the required parameter 'email_campaign' is set
        if ('email_campaign' not in params or
                params['email_campaign'] is None):
            raise ValueError("Missing the required parameter `email_campaign` when calling `insert_email_campaign`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_campaign' in params:
            body_params = params['email_campaign']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaigns', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCampaignResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_email_campaign_folder(self, storefront_oid, email_campaign_folder, **kwargs):  # noqa: E501
        """Insert email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_campaign_folder(storefront_oid, email_campaign_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCampaignFolder email_campaign_folder: Email campaign folder (required)
        :return: EmailCampaignFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder, **kwargs)  # noqa: E501
            return data

    def insert_email_campaign_folder_with_http_info(self, storefront_oid, email_campaign_folder, **kwargs):  # noqa: E501
        """Insert email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCampaignFolder email_campaign_folder: Email campaign folder (required)
        :return: EmailCampaignFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_campaign_folder']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_email_campaign_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `insert_email_campaign_folder`")  # noqa: E501
        # verify the required parameter 'email_campaign_folder' is set
        if ('email_campaign_folder' not in params or
                params['email_campaign_folder'] is None):
            raise ValueError("Missing the required parameter `email_campaign_folder` when calling `insert_email_campaign_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_campaign_folder' in params:
            body_params = params['email_campaign_folder']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaign_folders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCampaignFolderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_email_commseq(self, storefront_oid, email_commseq, **kwargs):  # noqa: E501
        """Insert email commseq  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_commseq(storefront_oid, email_commseq, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseq email_commseq: Email commseq (required)
        :return: EmailCommseqResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_email_commseq_with_http_info(storefront_oid, email_commseq, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_email_commseq_with_http_info(storefront_oid, email_commseq, **kwargs)  # noqa: E501
            return data

    def insert_email_commseq_with_http_info(self, storefront_oid, email_commseq, **kwargs):  # noqa: E501
        """Insert email commseq  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_commseq_with_http_info(storefront_oid, email_commseq, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseq email_commseq: Email commseq (required)
        :return: EmailCommseqResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_commseq']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_email_commseq" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `insert_email_commseq`")  # noqa: E501
        # verify the required parameter 'email_commseq' is set
        if ('email_commseq' not in params or
                params['email_commseq'] is None):
            raise ValueError("Missing the required parameter `email_commseq` when calling `insert_email_commseq`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq' in params:
            body_params = params['email_commseq']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_email_email(self, storefront_oid, email_commseq_email, **kwargs):  # noqa: E501
        """Insert email email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_email(storefront_oid, email_commseq_email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseqEmail email_commseq_email: Email email (required)
        :return: EmailCommseqEmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_email_email_with_http_info(storefront_oid, email_commseq_email, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_email_email_with_http_info(storefront_oid, email_commseq_email, **kwargs)  # noqa: E501
            return data

    def insert_email_email_with_http_info(self, storefront_oid, email_commseq_email, **kwargs):  # noqa: E501
        """Insert email email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_email_with_http_info(storefront_oid, email_commseq_email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseqEmail email_commseq_email: Email email (required)
        :return: EmailCommseqEmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_commseq_email']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_email_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `insert_email_email`")  # noqa: E501
        # verify the required parameter 'email_commseq_email' is set
        if ('email_commseq_email' not in params or
                params['email_commseq_email'] is None):
            raise ValueError("Missing the required parameter `email_commseq_email` when calling `insert_email_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq_email' in params:
            body_params = params['email_commseq_email']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/emails', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqEmailResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_email_flow(self, storefront_oid, email_flow, **kwargs):  # noqa: E501
        """Insert email flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_flow(storefront_oid, email_flow, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailFlow email_flow: Email flow (required)
        :return: EmailFlowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_email_flow_with_http_info(storefront_oid, email_flow, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_email_flow_with_http_info(storefront_oid, email_flow, **kwargs)  # noqa: E501
            return data

    def insert_email_flow_with_http_info(self, storefront_oid, email_flow, **kwargs):  # noqa: E501
        """Insert email flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_flow_with_http_info(storefront_oid, email_flow, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailFlow email_flow: Email flow (required)
        :return: EmailFlowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_flow']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_email_flow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `insert_email_flow`")  # noqa: E501
        # verify the required parameter 'email_flow' is set
        if ('email_flow' not in params or
                params['email_flow'] is None):
            raise ValueError("Missing the required parameter `email_flow` when calling `insert_email_flow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_flow' in params:
            body_params = params['email_flow']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flows', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailFlowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_email_flow_folder(self, storefront_oid, email_flow_folder, **kwargs):  # noqa: E501
        """Insert email flow folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_flow_folder(storefront_oid, email_flow_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailFlowFolder email_flow_folder: Email flow folder (required)
        :return: EmailFlowFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_email_flow_folder_with_http_info(storefront_oid, email_flow_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_email_flow_folder_with_http_info(storefront_oid, email_flow_folder, **kwargs)  # noqa: E501
            return data

    def insert_email_flow_folder_with_http_info(self, storefront_oid, email_flow_folder, **kwargs):  # noqa: E501
        """Insert email flow folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_flow_folder_with_http_info(storefront_oid, email_flow_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailFlowFolder email_flow_folder: Email flow folder (required)
        :return: EmailFlowFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_flow_folder']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_email_flow_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `insert_email_flow_folder`")  # noqa: E501
        # verify the required parameter 'email_flow_folder' is set
        if ('email_flow_folder' not in params or
                params['email_flow_folder'] is None):
            raise ValueError("Missing the required parameter `email_flow_folder` when calling `insert_email_flow_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_flow_folder' in params:
            body_params = params['email_flow_folder']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flow_folders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailFlowFolderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_email_list(self, storefront_oid, email_list, **kwargs):  # noqa: E501
        """Insert email list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_list(storefront_oid, email_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailList email_list: Email list (required)
        :return: EmailListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_email_list_with_http_info(storefront_oid, email_list, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_email_list_with_http_info(storefront_oid, email_list, **kwargs)  # noqa: E501
            return data

    def insert_email_list_with_http_info(self, storefront_oid, email_list, **kwargs):  # noqa: E501
        """Insert email list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_list_with_http_info(storefront_oid, email_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailList email_list: Email list (required)
        :return: EmailListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_email_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `insert_email_list`")  # noqa: E501
        # verify the required parameter 'email_list' is set
        if ('email_list' not in params or
                params['email_list'] is None):
            raise ValueError("Missing the required parameter `email_list` when calling `insert_email_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_list' in params:
            body_params = params['email_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/lists', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_email_list_segment_folder(self, storefront_oid, email_list_segment_folder, **kwargs):  # noqa: E501
        """Insert email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_list_segment_folder(storefront_oid, email_list_segment_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailListSegmentFolder email_list_segment_folder: Email campaign folder (required)
        :return: EmailListSegmentFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder, **kwargs)  # noqa: E501
            return data

    def insert_email_list_segment_folder_with_http_info(self, storefront_oid, email_list_segment_folder, **kwargs):  # noqa: E501
        """Insert email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailListSegmentFolder email_list_segment_folder: Email campaign folder (required)
        :return: EmailListSegmentFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_segment_folder']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_email_list_segment_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `insert_email_list_segment_folder`")  # noqa: E501
        # verify the required parameter 'email_list_segment_folder' is set
        if ('email_list_segment_folder' not in params or
                params['email_list_segment_folder'] is None):
            raise ValueError("Missing the required parameter `email_list_segment_folder` when calling `insert_email_list_segment_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_list_segment_folder' in params:
            body_params = params['email_list_segment_folder']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/list_segment_folders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListSegmentFolderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_email_postcard(self, storefront_oid, email_commseq_postcard, **kwargs):  # noqa: E501
        """Insert email postcard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_postcard(storefront_oid, email_commseq_postcard, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseqPostcard email_commseq_postcard: Email postcard (required)
        :return: EmailCommseqPostcardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_email_postcard_with_http_info(storefront_oid, email_commseq_postcard, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_email_postcard_with_http_info(storefront_oid, email_commseq_postcard, **kwargs)  # noqa: E501
            return data

    def insert_email_postcard_with_http_info(self, storefront_oid, email_commseq_postcard, **kwargs):  # noqa: E501
        """Insert email postcard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_postcard_with_http_info(storefront_oid, email_commseq_postcard, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseqPostcard email_commseq_postcard: Email postcard (required)
        :return: EmailCommseqPostcardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_commseq_postcard']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_email_postcard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `insert_email_postcard`")  # noqa: E501
        # verify the required parameter 'email_commseq_postcard' is set
        if ('email_commseq_postcard' not in params or
                params['email_commseq_postcard'] is None):
            raise ValueError("Missing the required parameter `email_commseq_postcard` when calling `insert_email_postcard`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq_postcard' in params:
            body_params = params['email_commseq_postcard']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/postcards', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqPostcardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_email_segment(self, storefront_oid, email_segment, **kwargs):  # noqa: E501
        """Insert email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_segment(storefront_oid, email_segment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailSegment email_segment: Email segment (required)
        :return: EmailSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_email_segment_with_http_info(storefront_oid, email_segment, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_email_segment_with_http_info(storefront_oid, email_segment, **kwargs)  # noqa: E501
            return data

    def insert_email_segment_with_http_info(self, storefront_oid, email_segment, **kwargs):  # noqa: E501
        """Insert email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_email_segment_with_http_info(storefront_oid, email_segment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailSegment email_segment: Email segment (required)
        :return: EmailSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_segment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_email_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `insert_email_segment`")  # noqa: E501
        # verify the required parameter 'email_segment' is set
        if ('email_segment' not in params or
                params['email_segment'] is None):
            raise ValueError("Missing the required parameter `email_segment` when calling `insert_email_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_segment' in params:
            body_params = params['email_segment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/segments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSegmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_screen_recording_segment(self, storefront_oid, segment, **kwargs):  # noqa: E501
        """Insert screen recording segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_screen_recording_segment(storefront_oid, segment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingSegment segment: Segment (required)
        :return: ScreenRecordingSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_screen_recording_segment_with_http_info(storefront_oid, segment, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_screen_recording_segment_with_http_info(storefront_oid, segment, **kwargs)  # noqa: E501
            return data

    def insert_screen_recording_segment_with_http_info(self, storefront_oid, segment, **kwargs):  # noqa: E501
        """Insert screen recording segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_screen_recording_segment_with_http_info(storefront_oid, segment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingSegment segment: Segment (required)
        :return: ScreenRecordingSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'segment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_screen_recording_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `insert_screen_recording_segment`")  # noqa: E501
        # verify the required parameter 'segment' is set
        if ('segment' not in params or
                params['segment'] is None):
            raise ValueError("Missing the required parameter `segment` when calling `insert_screen_recording_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'segment' in params:
            body_params = params['segment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/segments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingSegmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def prepare_download_email_segment(self, storefront_oid, email_segment_uuid, **kwargs):  # noqa: E501
        """Prepare download of email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.prepare_download_email_segment(storefront_oid, email_segment_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :return: EmailSegmentDownloadPrepareResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.prepare_download_email_segment_with_http_info(storefront_oid, email_segment_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.prepare_download_email_segment_with_http_info(storefront_oid, email_segment_uuid, **kwargs)  # noqa: E501
            return data

    def prepare_download_email_segment_with_http_info(self, storefront_oid, email_segment_uuid, **kwargs):  # noqa: E501
        """Prepare download of email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.prepare_download_email_segment_with_http_info(storefront_oid, email_segment_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :return: EmailSegmentDownloadPrepareResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_segment_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method prepare_download_email_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `prepare_download_email_segment`")  # noqa: E501
        # verify the required parameter 'email_segment_uuid' is set
        if ('email_segment_uuid' not in params or
                params['email_segment_uuid'] is None):
            raise ValueError("Missing the required parameter `email_segment_uuid` when calling `prepare_download_email_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_segment_uuid' in params:
            path_params['email_segment_uuid'] = params['email_segment_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/segments/{email_segment_uuid}/downloadPrepare', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSegmentDownloadPrepareResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def publish_library_item(self, library_item_oid, publish_library_request, **kwargs):  # noqa: E501
        """Publish library item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_library_item(library_item_oid, publish_library_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :param PublishLibraryItemRequest publish_library_request: Publish library item request (required)
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.publish_library_item_with_http_info(library_item_oid, publish_library_request, **kwargs)  # noqa: E501
        else:
            (data) = self.publish_library_item_with_http_info(library_item_oid, publish_library_request, **kwargs)  # noqa: E501
            return data

    def publish_library_item_with_http_info(self, library_item_oid, publish_library_request, **kwargs):  # noqa: E501
        """Publish library item.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_library_item_with_http_info(library_item_oid, publish_library_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :param PublishLibraryItemRequest publish_library_request: Publish library item request (required)
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['library_item_oid', 'publish_library_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method publish_library_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'library_item_oid' is set
        if ('library_item_oid' not in params or
                params['library_item_oid'] is None):
            raise ValueError("Missing the required parameter `library_item_oid` when calling `publish_library_item`")  # noqa: E501
        # verify the required parameter 'publish_library_request' is set
        if ('publish_library_request' not in params or
                params['publish_library_request'] is None):
            raise ValueError("Missing the required parameter `publish_library_request` when calling `publish_library_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_item_oid' in params:
            path_params['library_item_oid'] = params['library_item_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'publish_library_request' in params:
            body_params = params['publish_library_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/{library_item_oid}/publish', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def purchase_library_item(self, library_item_oid, **kwargs):  # noqa: E501
        """Purchase public library item, which creates a copy of the item in your personal code library  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.purchase_library_item(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :param int storefront_oid:
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.purchase_library_item_with_http_info(library_item_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.purchase_library_item_with_http_info(library_item_oid, **kwargs)  # noqa: E501
            return data

    def purchase_library_item_with_http_info(self, library_item_oid, **kwargs):  # noqa: E501
        """Purchase public library item, which creates a copy of the item in your personal code library  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.purchase_library_item_with_http_info(library_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :param int storefront_oid:
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['library_item_oid', 'storefront_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method purchase_library_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'library_item_oid' is set
        if ('library_item_oid' not in params or
                params['library_item_oid'] is None):
            raise ValueError("Missing the required parameter `library_item_oid` when calling `purchase_library_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_item_oid' in params:
            path_params['library_item_oid'] = params['library_item_oid']  # noqa: E501

        query_params = []
        if 'storefront_oid' in params:
            query_params.append(('storefront_oid', params['storefront_oid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/{library_item_oid}/purchase', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def release_email_commseq_step_waiting(self, storefront_oid, commseq_uuid, commseq_step_uuid, **kwargs):  # noqa: E501
        """Release email communication sequence customers waiting at the specified step  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.release_email_commseq_step_waiting(storefront_oid, commseq_uuid, commseq_step_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param str commseq_step_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.release_email_commseq_step_waiting_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.release_email_commseq_step_waiting_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, **kwargs)  # noqa: E501
            return data

    def release_email_commseq_step_waiting_with_http_info(self, storefront_oid, commseq_uuid, commseq_step_uuid, **kwargs):  # noqa: E501
        """Release email communication sequence customers waiting at the specified step  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.release_email_commseq_step_waiting_with_http_info(storefront_oid, commseq_uuid, commseq_step_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param str commseq_step_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid', 'commseq_step_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method release_email_commseq_step_waiting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `release_email_commseq_step_waiting`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `release_email_commseq_step_waiting`")  # noqa: E501
        # verify the required parameter 'commseq_step_uuid' is set
        if ('commseq_step_uuid' not in params or
                params['commseq_step_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_step_uuid` when calling `release_email_commseq_step_waiting`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501
        if 'commseq_step_uuid' in params:
            path_params['commseq_step_uuid'] = params['commseq_step_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}/waiting/{commseq_step_uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def review(self, storefront_oid, commseq_email_uuid, email_commseq_email_review_request, **kwargs):  # noqa: E501
        """Request a review of an email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.review(storefront_oid, commseq_email_uuid, email_commseq_email_review_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :param EmailCommseqEmailSendTestRequest email_commseq_email_review_request: Email commseq email review request (required)
        :return: EmailCommseqEmailSendTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.review_with_http_info(storefront_oid, commseq_email_uuid, email_commseq_email_review_request, **kwargs)  # noqa: E501
        else:
            (data) = self.review_with_http_info(storefront_oid, commseq_email_uuid, email_commseq_email_review_request, **kwargs)  # noqa: E501
            return data

    def review_with_http_info(self, storefront_oid, commseq_email_uuid, email_commseq_email_review_request, **kwargs):  # noqa: E501
        """Request a review of an email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.review_with_http_info(storefront_oid, commseq_email_uuid, email_commseq_email_review_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :param EmailCommseqEmailSendTestRequest email_commseq_email_review_request: Email commseq email review request (required)
        :return: EmailCommseqEmailSendTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_email_uuid', 'email_commseq_email_review_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method review" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `review`")  # noqa: E501
        # verify the required parameter 'commseq_email_uuid' is set
        if ('commseq_email_uuid' not in params or
                params['commseq_email_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_email_uuid` when calling `review`")  # noqa: E501
        # verify the required parameter 'email_commseq_email_review_request' is set
        if ('email_commseq_email_review_request' not in params or
                params['email_commseq_email_review_request'] is None):
            raise ValueError("Missing the required parameter `email_commseq_email_review_request` when calling `review`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_email_uuid' in params:
            path_params['commseq_email_uuid'] = params['commseq_email_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq_email_review_request' in params:
            body_params = params['email_commseq_email_review_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/emails/{commseq_email_uuid}/review', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqEmailSendTestResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search(self, **kwargs):  # noqa: E501
        """Searches for all matching values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str category:
        :param str matches:
        :param str storefront_oid:
        :param int max_hits:
        :param str subcategory:
        :return: LookupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_with_http_info(self, **kwargs):  # noqa: E501
        """Searches for all matching values  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str category:
        :param str matches:
        :param str storefront_oid:
        :param int max_hits:
        :param str subcategory:
        :return: LookupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category', 'matches', 'storefront_oid', 'max_hits', 'subcategory']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'category' in params:
            query_params.append(('category', params['category']))  # noqa: E501
        if 'matches' in params:
            query_params.append(('matches', params['matches']))  # noqa: E501
        if 'storefront_oid' in params:
            query_params.append(('storefront_oid', params['storefront_oid']))  # noqa: E501
        if 'max_hits' in params:
            query_params.append(('max_hits', params['max_hits']))  # noqa: E501
        if 'subcategory' in params:
            query_params.append(('subcategory', params['subcategory']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LookupResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search2(self, lookup_request, **kwargs):  # noqa: E501
        """Searches for all matching values (using POST)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search2(lookup_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LookupRequest lookup_request: LookupRequest (required)
        :return: LookupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search2_with_http_info(lookup_request, **kwargs)  # noqa: E501
        else:
            (data) = self.search2_with_http_info(lookup_request, **kwargs)  # noqa: E501
            return data

    def search2_with_http_info(self, lookup_request, **kwargs):  # noqa: E501
        """Searches for all matching values (using POST)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search2_with_http_info(lookup_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LookupRequest lookup_request: LookupRequest (required)
        :return: LookupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lookup_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lookup_request' is set
        if ('lookup_request' not in params or
                params['lookup_request'] is None):
            raise ValueError("Missing the required parameter `lookup_request` when calling `search2`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lookup_request' in params:
            body_params = params['lookup_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LookupResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_email_list_customers(self, storefront_oid, email_list_uuid, **kwargs):  # noqa: E501
        """Search email list customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_email_list_customers(storefront_oid, email_list_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param str starts_with:
        :return: EmailListCustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_email_list_customers_with_http_info(storefront_oid, email_list_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.search_email_list_customers_with_http_info(storefront_oid, email_list_uuid, **kwargs)  # noqa: E501
            return data

    def search_email_list_customers_with_http_info(self, storefront_oid, email_list_uuid, **kwargs):  # noqa: E501
        """Search email list customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_email_list_customers_with_http_info(storefront_oid, email_list_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param str starts_with:
        :return: EmailListCustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_uuid', 'starts_with']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_email_list_customers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `search_email_list_customers`")  # noqa: E501
        # verify the required parameter 'email_list_uuid' is set
        if ('email_list_uuid' not in params or
                params['email_list_uuid'] is None):
            raise ValueError("Missing the required parameter `email_list_uuid` when calling `search_email_list_customers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_list_uuid' in params:
            path_params['email_list_uuid'] = params['email_list_uuid']  # noqa: E501

        query_params = []
        if 'starts_with' in params:
            query_params.append(('startsWith', params['starts_with']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/lists/{email_list_uuid}/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListCustomersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_email_segment_customers(self, storefront_oid, email_segment_uuid, **kwargs):  # noqa: E501
        """Search email segment customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_email_segment_customers(storefront_oid, email_segment_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :param str starts_with:
        :return: EmailSegmentCustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_email_segment_customers_with_http_info(storefront_oid, email_segment_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.search_email_segment_customers_with_http_info(storefront_oid, email_segment_uuid, **kwargs)  # noqa: E501
            return data

    def search_email_segment_customers_with_http_info(self, storefront_oid, email_segment_uuid, **kwargs):  # noqa: E501
        """Search email segment customers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_email_segment_customers_with_http_info(storefront_oid, email_segment_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :param str starts_with:
        :return: EmailSegmentCustomersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_segment_uuid', 'starts_with']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_email_segment_customers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `search_email_segment_customers`")  # noqa: E501
        # verify the required parameter 'email_segment_uuid' is set
        if ('email_segment_uuid' not in params or
                params['email_segment_uuid'] is None):
            raise ValueError("Missing the required parameter `email_segment_uuid` when calling `search_email_segment_customers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_segment_uuid' in params:
            path_params['email_segment_uuid'] = params['email_segment_uuid']  # noqa: E501

        query_params = []
        if 'starts_with' in params:
            query_params.append(('startsWith', params['starts_with']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/segments/{email_segment_uuid}/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSegmentCustomersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_library_items(self, item_query, **kwargs):  # noqa: E501
        """Retrieve library items  # noqa: E501

        Retrieves a library items based on a query object.  If no parameters are specified, the API call will default to the merchant id only.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_library_items(item_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LibraryItemQuery item_query: Item query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 10000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the library items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: LibraryItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_library_items_with_http_info(item_query, **kwargs)  # noqa: E501
        else:
            (data) = self.search_library_items_with_http_info(item_query, **kwargs)  # noqa: E501
            return data

    def search_library_items_with_http_info(self, item_query, **kwargs):  # noqa: E501
        """Retrieve library items  # noqa: E501

        Retrieves a library items based on a query object.  If no parameters are specified, the API call will default to the merchant id only.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_library_items_with_http_info(item_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LibraryItemQuery item_query: Item query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 10000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the library items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: LibraryItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_query', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_library_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_query' is set
        if ('item_query' not in params or
                params['item_query'] is None):
            raise ValueError("Missing the required parameter `item_query` when calling `search_library_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_query' in params:
            body_params = params['item_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryItemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_published_items(self, item_query, **kwargs):  # noqa: E501
        """Retrieve library items  # noqa: E501

        Retrieves a library items based on a query object.  If no parameters are specified, the API call will default to the merchant id only.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_published_items(item_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LibraryItemQuery item_query: Item query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 10000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the library items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: LibraryItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_published_items_with_http_info(item_query, **kwargs)  # noqa: E501
        else:
            (data) = self.search_published_items_with_http_info(item_query, **kwargs)  # noqa: E501
            return data

    def search_published_items_with_http_info(self, item_query, **kwargs):  # noqa: E501
        """Retrieve library items  # noqa: E501

        Retrieves a library items based on a query object.  If no parameters are specified, the API call will default to the merchant id only.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_published_items_with_http_info(item_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LibraryItemQuery item_query: Item query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 10000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the library items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: LibraryItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_query', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_published_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_query' is set
        if ('item_query' not in params or
                params['item_query'] is None):
            raise ValueError("Missing the required parameter `item_query` when calling `search_published_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_query' in params:
            body_params = params['item_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/search_published', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryItemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_review_items(self, item_query, **kwargs):  # noqa: E501
        """Retrieve library items needing review or rejected  # noqa: E501

        Retrieves a library items based on a query object.  If no parameters are specified, the API call will default to the merchant id only.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_review_items(item_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LibraryItemQuery item_query: Item query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 10000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the library items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: LibraryItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_review_items_with_http_info(item_query, **kwargs)  # noqa: E501
        else:
            (data) = self.search_review_items_with_http_info(item_query, **kwargs)  # noqa: E501
            return data

    def search_review_items_with_http_info(self, item_query, **kwargs):  # noqa: E501
        """Retrieve library items needing review or rejected  # noqa: E501

        Retrieves a library items based on a query object.  If no parameters are specified, the API call will default to the merchant id only.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_review_items_with_http_info(item_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LibraryItemQuery item_query: Item query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 10000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the library items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: LibraryItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_query', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_review_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_query' is set
        if ('item_query' not in params or
                params['item_query'] is None):
            raise ValueError("Missing the required parameter `item_query` when calling `search_review_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_query' in params:
            body_params = params['item_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/search_review', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryItemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_shared_items(self, item_query, **kwargs):  # noqa: E501
        """Retrieve library items  # noqa: E501

        Retrieves a library items based on a query object.  If no parameters are specified, the API call will default to the merchant id only.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_shared_items(item_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LibraryItemQuery item_query: Item query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 10000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the library items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: LibraryItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_shared_items_with_http_info(item_query, **kwargs)  # noqa: E501
        else:
            (data) = self.search_shared_items_with_http_info(item_query, **kwargs)  # noqa: E501
            return data

    def search_shared_items_with_http_info(self, item_query, **kwargs):  # noqa: E501
        """Retrieve library items  # noqa: E501

        Retrieves a library items based on a query object.  If no parameters are specified, the API call will default to the merchant id only.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_shared_items_with_http_info(item_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LibraryItemQuery item_query: Item query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 10000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the library items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :return: LibraryItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_query', 'limit', 'offset', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_shared_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_query' is set
        if ('item_query' not in params or
                params['item_query'] is None):
            raise ValueError("Missing the required parameter `item_query` when calling `search_shared_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item_query' in params:
            body_params = params['item_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/search_shared', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryItemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_email_test(self, storefront_oid, commseq_email_uuid, email_commseq_email_test_request, **kwargs):  # noqa: E501
        """Send email test  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_email_test(storefront_oid, commseq_email_uuid, email_commseq_email_test_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :param EmailCommseqEmailSendTestRequest email_commseq_email_test_request: Email commseq email test request (required)
        :return: EmailCommseqEmailSendTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_email_test_with_http_info(storefront_oid, commseq_email_uuid, email_commseq_email_test_request, **kwargs)  # noqa: E501
        else:
            (data) = self.send_email_test_with_http_info(storefront_oid, commseq_email_uuid, email_commseq_email_test_request, **kwargs)  # noqa: E501
            return data

    def send_email_test_with_http_info(self, storefront_oid, commseq_email_uuid, email_commseq_email_test_request, **kwargs):  # noqa: E501
        """Send email test  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_email_test_with_http_info(storefront_oid, commseq_email_uuid, email_commseq_email_test_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :param EmailCommseqEmailSendTestRequest email_commseq_email_test_request: Email commseq email test request (required)
        :return: EmailCommseqEmailSendTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_email_uuid', 'email_commseq_email_test_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_email_test" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `send_email_test`")  # noqa: E501
        # verify the required parameter 'commseq_email_uuid' is set
        if ('commseq_email_uuid' not in params or
                params['commseq_email_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_email_uuid` when calling `send_email_test`")  # noqa: E501
        # verify the required parameter 'email_commseq_email_test_request' is set
        if ('email_commseq_email_test_request' not in params or
                params['email_commseq_email_test_request'] is None):
            raise ValueError("Missing the required parameter `email_commseq_email_test_request` when calling `send_email_test`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_email_uuid' in params:
            path_params['commseq_email_uuid'] = params['commseq_email_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq_email_test_request' in params:
            body_params = params['email_commseq_email_test_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/emails/{commseq_email_uuid}/test', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqEmailSendTestResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_postcard_test(self, storefront_oid, commseq_postcard_uuid, email_commseq_postcard_test_request, **kwargs):  # noqa: E501
        """Send postcard test  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_postcard_test(storefront_oid, commseq_postcard_uuid, email_commseq_postcard_test_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_postcard_uuid: (required)
        :param EmailCommseqPostcardSendTestRequest email_commseq_postcard_test_request: Email commseq email test request (required)
        :return: EmailCommseqPostcardSendTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_postcard_test_with_http_info(storefront_oid, commseq_postcard_uuid, email_commseq_postcard_test_request, **kwargs)  # noqa: E501
        else:
            (data) = self.send_postcard_test_with_http_info(storefront_oid, commseq_postcard_uuid, email_commseq_postcard_test_request, **kwargs)  # noqa: E501
            return data

    def send_postcard_test_with_http_info(self, storefront_oid, commseq_postcard_uuid, email_commseq_postcard_test_request, **kwargs):  # noqa: E501
        """Send postcard test  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_postcard_test_with_http_info(storefront_oid, commseq_postcard_uuid, email_commseq_postcard_test_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_postcard_uuid: (required)
        :param EmailCommseqPostcardSendTestRequest email_commseq_postcard_test_request: Email commseq email test request (required)
        :return: EmailCommseqPostcardSendTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_postcard_uuid', 'email_commseq_postcard_test_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_postcard_test" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `send_postcard_test`")  # noqa: E501
        # verify the required parameter 'commseq_postcard_uuid' is set
        if ('commseq_postcard_uuid' not in params or
                params['commseq_postcard_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_postcard_uuid` when calling `send_postcard_test`")  # noqa: E501
        # verify the required parameter 'email_commseq_postcard_test_request' is set
        if ('email_commseq_postcard_test_request' not in params or
                params['email_commseq_postcard_test_request'] is None):
            raise ValueError("Missing the required parameter `email_commseq_postcard_test_request` when calling `send_postcard_test`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_postcard_uuid' in params:
            path_params['commseq_postcard_uuid'] = params['commseq_postcard_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq_postcard_test_request' in params:
            body_params = params['email_commseq_postcard_test_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/postcards/{commseq_postcard_uuid}/test', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqPostcardSendTestResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_webhook_test(self, storefront_oid, email_commseq_webhook_test_request, **kwargs):  # noqa: E501
        """Send webhook test  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_webhook_test(storefront_oid, email_commseq_webhook_test_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseqWebhookSendTestRequest email_commseq_webhook_test_request: Email commseq webhook test request (required)
        :return: EmailCommseqWebhookSendTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_webhook_test_with_http_info(storefront_oid, email_commseq_webhook_test_request, **kwargs)  # noqa: E501
        else:
            (data) = self.send_webhook_test_with_http_info(storefront_oid, email_commseq_webhook_test_request, **kwargs)  # noqa: E501
            return data

    def send_webhook_test_with_http_info(self, storefront_oid, email_commseq_webhook_test_request, **kwargs):  # noqa: E501
        """Send webhook test  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_webhook_test_with_http_info(storefront_oid, email_commseq_webhook_test_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailCommseqWebhookSendTestRequest email_commseq_webhook_test_request: Email commseq webhook test request (required)
        :return: EmailCommseqWebhookSendTestResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_commseq_webhook_test_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_webhook_test" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `send_webhook_test`")  # noqa: E501
        # verify the required parameter 'email_commseq_webhook_test_request' is set
        if ('email_commseq_webhook_test_request' not in params or
                params['email_commseq_webhook_test_request'] is None):
            raise ValueError("Missing the required parameter `email_commseq_webhook_test_request` when calling `send_webhook_test`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq_webhook_test_request' in params:
            body_params = params['email_commseq_webhook_test_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/webhooks/test', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqWebhookSendTestResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def start_email_campaign(self, storefront_oid, email_campaign_uuid, **kwargs):  # noqa: E501
        """Start email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_email_campaign(storefront_oid, email_campaign_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.start_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.start_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, **kwargs)  # noqa: E501
            return data

    def start_email_campaign_with_http_info(self, storefront_oid, email_campaign_uuid, **kwargs):  # noqa: E501
        """Start email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.start_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_uuid: (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_campaign_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_email_campaign" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `start_email_campaign`")  # noqa: E501
        # verify the required parameter 'email_campaign_uuid' is set
        if ('email_campaign_uuid' not in params or
                params['email_campaign_uuid'] is None):
            raise ValueError("Missing the required parameter `email_campaign_uuid` when calling `start_email_campaign`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_campaign_uuid' in params:
            path_params['email_campaign_uuid'] = params['email_campaign_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaigns/{email_campaign_uuid}/start', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscribe_to_email_list(self, storefront_oid, email_list_uuid, customers, **kwargs):  # noqa: E501
        """Subscribe customers to email list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_to_email_list(storefront_oid, email_list_uuid, customers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param list[EmailCustomer] customers: Customers (required)
        :return: EmailListSubscribeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscribe_to_email_list_with_http_info(storefront_oid, email_list_uuid, customers, **kwargs)  # noqa: E501
        else:
            (data) = self.subscribe_to_email_list_with_http_info(storefront_oid, email_list_uuid, customers, **kwargs)  # noqa: E501
            return data

    def subscribe_to_email_list_with_http_info(self, storefront_oid, email_list_uuid, customers, **kwargs):  # noqa: E501
        """Subscribe customers to email list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_to_email_list_with_http_info(storefront_oid, email_list_uuid, customers, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param list[EmailCustomer] customers: Customers (required)
        :return: EmailListSubscribeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_uuid', 'customers']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscribe_to_email_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `subscribe_to_email_list`")  # noqa: E501
        # verify the required parameter 'email_list_uuid' is set
        if ('email_list_uuid' not in params or
                params['email_list_uuid'] is None):
            raise ValueError("Missing the required parameter `email_list_uuid` when calling `subscribe_to_email_list`")  # noqa: E501
        # verify the required parameter 'customers' is set
        if ('customers' not in params or
                params['customers'] is None):
            raise ValueError("Missing the required parameter `customers` when calling `subscribe_to_email_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_list_uuid' in params:
            path_params['email_list_uuid'] = params['email_list_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'customers' in params:
            body_params = params['customers']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/lists/{email_list_uuid}/subscribe', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListSubscribeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unfavorite_screen_recording(self, storefront_oid, screen_recording_uuid, **kwargs):  # noqa: E501
        """Remove favorite flag on screen recording  # noqa: E501

        Remove favorite flag on screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unfavorite_screen_recording(storefront_oid, screen_recording_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unfavorite_screen_recording_with_http_info(storefront_oid, screen_recording_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.unfavorite_screen_recording_with_http_info(storefront_oid, screen_recording_uuid, **kwargs)  # noqa: E501
            return data

    def unfavorite_screen_recording_with_http_info(self, storefront_oid, screen_recording_uuid, **kwargs):  # noqa: E501
        """Remove favorite flag on screen recording  # noqa: E501

        Remove favorite flag on screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unfavorite_screen_recording_with_http_info(storefront_oid, screen_recording_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'screen_recording_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unfavorite_screen_recording" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `unfavorite_screen_recording`")  # noqa: E501
        # verify the required parameter 'screen_recording_uuid' is set
        if ('screen_recording_uuid' not in params or
                params['screen_recording_uuid'] is None):
            raise ValueError("Missing the required parameter `screen_recording_uuid` when calling `unfavorite_screen_recording`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'screen_recording_uuid' in params:
            path_params['screen_recording_uuid'] = params['screen_recording_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid}/favorite', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_campaign(self, storefront_oid, email_campaign_uuid, email_campaign, **kwargs):  # noqa: E501
        """Update email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_campaign(storefront_oid, email_campaign_uuid, email_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_uuid: (required)
        :param EmailCampaign email_campaign: Email campaign (required)
        :return: EmailCampaignResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, email_campaign, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, email_campaign, **kwargs)  # noqa: E501
            return data

    def update_email_campaign_with_http_info(self, storefront_oid, email_campaign_uuid, email_campaign, **kwargs):  # noqa: E501
        """Update email campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_campaign_with_http_info(storefront_oid, email_campaign_uuid, email_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_uuid: (required)
        :param EmailCampaign email_campaign: Email campaign (required)
        :return: EmailCampaignResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_campaign_uuid', 'email_campaign']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_campaign" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_campaign`")  # noqa: E501
        # verify the required parameter 'email_campaign_uuid' is set
        if ('email_campaign_uuid' not in params or
                params['email_campaign_uuid'] is None):
            raise ValueError("Missing the required parameter `email_campaign_uuid` when calling `update_email_campaign`")  # noqa: E501
        # verify the required parameter 'email_campaign' is set
        if ('email_campaign' not in params or
                params['email_campaign'] is None):
            raise ValueError("Missing the required parameter `email_campaign` when calling `update_email_campaign`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_campaign_uuid' in params:
            path_params['email_campaign_uuid'] = params['email_campaign_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_campaign' in params:
            body_params = params['email_campaign']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaigns/{email_campaign_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCampaignResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_campaign_folder(self, storefront_oid, email_campaign_folder_uuid, email_campaign_folder, **kwargs):  # noqa: E501
        """Update email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_campaign_folder(storefront_oid, email_campaign_folder_uuid, email_campaign_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_folder_uuid: (required)
        :param EmailCampaignFolder email_campaign_folder: Email campaign folder (required)
        :return: EmailCampaignFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder_uuid, email_campaign_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder_uuid, email_campaign_folder, **kwargs)  # noqa: E501
            return data

    def update_email_campaign_folder_with_http_info(self, storefront_oid, email_campaign_folder_uuid, email_campaign_folder, **kwargs):  # noqa: E501
        """Update email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_campaign_folder_with_http_info(storefront_oid, email_campaign_folder_uuid, email_campaign_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_campaign_folder_uuid: (required)
        :param EmailCampaignFolder email_campaign_folder: Email campaign folder (required)
        :return: EmailCampaignFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_campaign_folder_uuid', 'email_campaign_folder']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_campaign_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_campaign_folder`")  # noqa: E501
        # verify the required parameter 'email_campaign_folder_uuid' is set
        if ('email_campaign_folder_uuid' not in params or
                params['email_campaign_folder_uuid'] is None):
            raise ValueError("Missing the required parameter `email_campaign_folder_uuid` when calling `update_email_campaign_folder`")  # noqa: E501
        # verify the required parameter 'email_campaign_folder' is set
        if ('email_campaign_folder' not in params or
                params['email_campaign_folder'] is None):
            raise ValueError("Missing the required parameter `email_campaign_folder` when calling `update_email_campaign_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_campaign_folder_uuid' in params:
            path_params['email_campaign_folder_uuid'] = params['email_campaign_folder_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_campaign_folder' in params:
            body_params = params['email_campaign_folder']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/campaign_folders/{email_campaign_folder_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCampaignFolderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_commseq(self, storefront_oid, commseq_uuid, email_commseq, **kwargs):  # noqa: E501
        """Update email commseq  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_commseq(storefront_oid, commseq_uuid, email_commseq, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param EmailCommseq email_commseq: Email commseq (required)
        :return: EmailCommseqResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_commseq_with_http_info(storefront_oid, commseq_uuid, email_commseq, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_commseq_with_http_info(storefront_oid, commseq_uuid, email_commseq, **kwargs)  # noqa: E501
            return data

    def update_email_commseq_with_http_info(self, storefront_oid, commseq_uuid, email_commseq, **kwargs):  # noqa: E501
        """Update email commseq  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_commseq_with_http_info(storefront_oid, commseq_uuid, email_commseq, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_uuid: (required)
        :param EmailCommseq email_commseq: Email commseq (required)
        :return: EmailCommseqResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_uuid', 'email_commseq']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_commseq" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_commseq`")  # noqa: E501
        # verify the required parameter 'commseq_uuid' is set
        if ('commseq_uuid' not in params or
                params['commseq_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_uuid` when calling `update_email_commseq`")  # noqa: E501
        # verify the required parameter 'email_commseq' is set
        if ('email_commseq' not in params or
                params['email_commseq'] is None):
            raise ValueError("Missing the required parameter `email_commseq` when calling `update_email_commseq`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_uuid' in params:
            path_params['commseq_uuid'] = params['commseq_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq' in params:
            body_params = params['email_commseq']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/commseqs/{commseq_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_customer(self, storefront_oid, email_customer_uuid, email_customer, **kwargs):  # noqa: E501
        """Update email customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_customer(storefront_oid, email_customer_uuid, email_customer, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_customer_uuid: (required)
        :param EmailCustomer email_customer: Email customer (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_customer_with_http_info(storefront_oid, email_customer_uuid, email_customer, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_customer_with_http_info(storefront_oid, email_customer_uuid, email_customer, **kwargs)  # noqa: E501
            return data

    def update_email_customer_with_http_info(self, storefront_oid, email_customer_uuid, email_customer, **kwargs):  # noqa: E501
        """Update email customer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_customer_with_http_info(storefront_oid, email_customer_uuid, email_customer, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_customer_uuid: (required)
        :param EmailCustomer email_customer: Email customer (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_customer_uuid', 'email_customer']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_customer`")  # noqa: E501
        # verify the required parameter 'email_customer_uuid' is set
        if ('email_customer_uuid' not in params or
                params['email_customer_uuid'] is None):
            raise ValueError("Missing the required parameter `email_customer_uuid` when calling `update_email_customer`")  # noqa: E501
        # verify the required parameter 'email_customer' is set
        if ('email_customer' not in params or
                params['email_customer'] is None):
            raise ValueError("Missing the required parameter `email_customer` when calling `update_email_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_customer_uuid' in params:
            path_params['email_customer_uuid'] = params['email_customer_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_customer' in params:
            body_params = params['email_customer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/customers/{email_customer_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_email(self, storefront_oid, commseq_email_uuid, email_commseq_email, **kwargs):  # noqa: E501
        """Update email email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_email(storefront_oid, commseq_email_uuid, email_commseq_email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :param EmailCommseqEmail email_commseq_email: Email commseq email (required)
        :return: EmailCommseqEmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_email_with_http_info(storefront_oid, commseq_email_uuid, email_commseq_email, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_email_with_http_info(storefront_oid, commseq_email_uuid, email_commseq_email, **kwargs)  # noqa: E501
            return data

    def update_email_email_with_http_info(self, storefront_oid, commseq_email_uuid, email_commseq_email, **kwargs):  # noqa: E501
        """Update email email  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_email_with_http_info(storefront_oid, commseq_email_uuid, email_commseq_email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_email_uuid: (required)
        :param EmailCommseqEmail email_commseq_email: Email commseq email (required)
        :return: EmailCommseqEmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_email_uuid', 'email_commseq_email']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_email`")  # noqa: E501
        # verify the required parameter 'commseq_email_uuid' is set
        if ('commseq_email_uuid' not in params or
                params['commseq_email_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_email_uuid` when calling `update_email_email`")  # noqa: E501
        # verify the required parameter 'email_commseq_email' is set
        if ('email_commseq_email' not in params or
                params['email_commseq_email'] is None):
            raise ValueError("Missing the required parameter `email_commseq_email` when calling `update_email_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_email_uuid' in params:
            path_params['commseq_email_uuid'] = params['commseq_email_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq_email' in params:
            body_params = params['email_commseq_email']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/emails/{commseq_email_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqEmailResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_flow(self, storefront_oid, email_flow_uuid, email_flow, **kwargs):  # noqa: E501
        """Update email flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_flow(storefront_oid, email_flow_uuid, email_flow, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_uuid: (required)
        :param EmailFlow email_flow: Email flow (required)
        :return: EmailFlowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_flow_with_http_info(storefront_oid, email_flow_uuid, email_flow, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_flow_with_http_info(storefront_oid, email_flow_uuid, email_flow, **kwargs)  # noqa: E501
            return data

    def update_email_flow_with_http_info(self, storefront_oid, email_flow_uuid, email_flow, **kwargs):  # noqa: E501
        """Update email flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_flow_with_http_info(storefront_oid, email_flow_uuid, email_flow, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_uuid: (required)
        :param EmailFlow email_flow: Email flow (required)
        :return: EmailFlowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_flow_uuid', 'email_flow']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_flow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_flow`")  # noqa: E501
        # verify the required parameter 'email_flow_uuid' is set
        if ('email_flow_uuid' not in params or
                params['email_flow_uuid'] is None):
            raise ValueError("Missing the required parameter `email_flow_uuid` when calling `update_email_flow`")  # noqa: E501
        # verify the required parameter 'email_flow' is set
        if ('email_flow' not in params or
                params['email_flow'] is None):
            raise ValueError("Missing the required parameter `email_flow` when calling `update_email_flow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_flow_uuid' in params:
            path_params['email_flow_uuid'] = params['email_flow_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_flow' in params:
            body_params = params['email_flow']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flows/{email_flow_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailFlowResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_flow_folder(self, storefront_oid, email_flow_folder_uuid, email_flow_folder, **kwargs):  # noqa: E501
        """Update email flow folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_flow_folder(storefront_oid, email_flow_folder_uuid, email_flow_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_folder_uuid: (required)
        :param EmailFlowFolder email_flow_folder: Email flow folder (required)
        :return: EmailFlowFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_flow_folder_with_http_info(storefront_oid, email_flow_folder_uuid, email_flow_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_flow_folder_with_http_info(storefront_oid, email_flow_folder_uuid, email_flow_folder, **kwargs)  # noqa: E501
            return data

    def update_email_flow_folder_with_http_info(self, storefront_oid, email_flow_folder_uuid, email_flow_folder, **kwargs):  # noqa: E501
        """Update email flow folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_flow_folder_with_http_info(storefront_oid, email_flow_folder_uuid, email_flow_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_flow_folder_uuid: (required)
        :param EmailFlowFolder email_flow_folder: Email flow folder (required)
        :return: EmailFlowFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_flow_folder_uuid', 'email_flow_folder']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_flow_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_flow_folder`")  # noqa: E501
        # verify the required parameter 'email_flow_folder_uuid' is set
        if ('email_flow_folder_uuid' not in params or
                params['email_flow_folder_uuid'] is None):
            raise ValueError("Missing the required parameter `email_flow_folder_uuid` when calling `update_email_flow_folder`")  # noqa: E501
        # verify the required parameter 'email_flow_folder' is set
        if ('email_flow_folder' not in params or
                params['email_flow_folder'] is None):
            raise ValueError("Missing the required parameter `email_flow_folder` when calling `update_email_flow_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_flow_folder_uuid' in params:
            path_params['email_flow_folder_uuid'] = params['email_flow_folder_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_flow_folder' in params:
            body_params = params['email_flow_folder']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/flow_folders/{email_flow_folder_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailFlowFolderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_global_settings(self, global_settings, **kwargs):  # noqa: E501
        """Update email global settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_global_settings(global_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailGlobalSettings global_settings: global settings request (required)
        :return: EmailGlobalSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_global_settings_with_http_info(global_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_global_settings_with_http_info(global_settings, **kwargs)  # noqa: E501
            return data

    def update_email_global_settings_with_http_info(self, global_settings, **kwargs):  # noqa: E501
        """Update email global settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_global_settings_with_http_info(global_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmailGlobalSettings global_settings: global settings request (required)
        :return: EmailGlobalSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['global_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_global_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'global_settings' is set
        if ('global_settings' not in params or
                params['global_settings'] is None):
            raise ValueError("Missing the required parameter `global_settings` when calling `update_email_global_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'global_settings' in params:
            body_params = params['global_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/email/global_settings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailGlobalSettingsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_list(self, storefront_oid, email_list_uuid, email_list, **kwargs):  # noqa: E501
        """Update email list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_list(storefront_oid, email_list_uuid, email_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param EmailList email_list: Email list (required)
        :return: EmailListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_list_with_http_info(storefront_oid, email_list_uuid, email_list, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_list_with_http_info(storefront_oid, email_list_uuid, email_list, **kwargs)  # noqa: E501
            return data

    def update_email_list_with_http_info(self, storefront_oid, email_list_uuid, email_list, **kwargs):  # noqa: E501
        """Update email list  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_list_with_http_info(storefront_oid, email_list_uuid, email_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_uuid: (required)
        :param EmailList email_list: Email list (required)
        :return: EmailListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_uuid', 'email_list']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_list`")  # noqa: E501
        # verify the required parameter 'email_list_uuid' is set
        if ('email_list_uuid' not in params or
                params['email_list_uuid'] is None):
            raise ValueError("Missing the required parameter `email_list_uuid` when calling `update_email_list`")  # noqa: E501
        # verify the required parameter 'email_list' is set
        if ('email_list' not in params or
                params['email_list'] is None):
            raise ValueError("Missing the required parameter `email_list` when calling `update_email_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_list_uuid' in params:
            path_params['email_list_uuid'] = params['email_list_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_list' in params:
            body_params = params['email_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/lists/{email_list_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_list_segment_folder(self, storefront_oid, email_list_segment_folder_uuid, email_list_segment_folder, **kwargs):  # noqa: E501
        """Update email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_list_segment_folder(storefront_oid, email_list_segment_folder_uuid, email_list_segment_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_segment_folder_uuid: (required)
        :param EmailListSegmentFolder email_list_segment_folder: Email campaign folder (required)
        :return: EmailListSegmentFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder_uuid, email_list_segment_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder_uuid, email_list_segment_folder, **kwargs)  # noqa: E501
            return data

    def update_email_list_segment_folder_with_http_info(self, storefront_oid, email_list_segment_folder_uuid, email_list_segment_folder, **kwargs):  # noqa: E501
        """Update email campaign folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_list_segment_folder_with_http_info(storefront_oid, email_list_segment_folder_uuid, email_list_segment_folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_list_segment_folder_uuid: (required)
        :param EmailListSegmentFolder email_list_segment_folder: Email campaign folder (required)
        :return: EmailListSegmentFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_list_segment_folder_uuid', 'email_list_segment_folder']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_list_segment_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_list_segment_folder`")  # noqa: E501
        # verify the required parameter 'email_list_segment_folder_uuid' is set
        if ('email_list_segment_folder_uuid' not in params or
                params['email_list_segment_folder_uuid'] is None):
            raise ValueError("Missing the required parameter `email_list_segment_folder_uuid` when calling `update_email_list_segment_folder`")  # noqa: E501
        # verify the required parameter 'email_list_segment_folder' is set
        if ('email_list_segment_folder' not in params or
                params['email_list_segment_folder'] is None):
            raise ValueError("Missing the required parameter `email_list_segment_folder` when calling `update_email_list_segment_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_list_segment_folder_uuid' in params:
            path_params['email_list_segment_folder_uuid'] = params['email_list_segment_folder_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_list_segment_folder' in params:
            body_params = params['email_list_segment_folder']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/list_segment_folders/{email_list_segment_folder_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailListSegmentFolderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_plan(self, storefront_oid, settings, **kwargs):  # noqa: E501
        """Update email plan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_plan(storefront_oid, settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailPlan settings: plan request (required)
        :return: EmailPlanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_plan_with_http_info(storefront_oid, settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_plan_with_http_info(storefront_oid, settings, **kwargs)  # noqa: E501
            return data

    def update_email_plan_with_http_info(self, storefront_oid, settings, **kwargs):  # noqa: E501
        """Update email plan  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_plan_with_http_info(storefront_oid, settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailPlan settings: plan request (required)
        :return: EmailPlanResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_plan`")  # noqa: E501
        # verify the required parameter 'settings' is set
        if ('settings' not in params or
                params['settings'] is None):
            raise ValueError("Missing the required parameter `settings` when calling `update_email_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings' in params:
            body_params = params['settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/plan', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailPlanResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_postcard(self, storefront_oid, commseq_postcard_uuid, email_commseq_postcard, **kwargs):  # noqa: E501
        """Update email postcard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_postcard(storefront_oid, commseq_postcard_uuid, email_commseq_postcard, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_postcard_uuid: (required)
        :param EmailCommseqPostcard email_commseq_postcard: Email commseq postcard (required)
        :return: EmailCommseqPostcardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_postcard_with_http_info(storefront_oid, commseq_postcard_uuid, email_commseq_postcard, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_postcard_with_http_info(storefront_oid, commseq_postcard_uuid, email_commseq_postcard, **kwargs)  # noqa: E501
            return data

    def update_email_postcard_with_http_info(self, storefront_oid, commseq_postcard_uuid, email_commseq_postcard, **kwargs):  # noqa: E501
        """Update email postcard  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_postcard_with_http_info(storefront_oid, commseq_postcard_uuid, email_commseq_postcard, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str commseq_postcard_uuid: (required)
        :param EmailCommseqPostcard email_commseq_postcard: Email commseq postcard (required)
        :return: EmailCommseqPostcardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'commseq_postcard_uuid', 'email_commseq_postcard']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_postcard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_postcard`")  # noqa: E501
        # verify the required parameter 'commseq_postcard_uuid' is set
        if ('commseq_postcard_uuid' not in params or
                params['commseq_postcard_uuid'] is None):
            raise ValueError("Missing the required parameter `commseq_postcard_uuid` when calling `update_email_postcard`")  # noqa: E501
        # verify the required parameter 'email_commseq_postcard' is set
        if ('email_commseq_postcard' not in params or
                params['email_commseq_postcard'] is None):
            raise ValueError("Missing the required parameter `email_commseq_postcard` when calling `update_email_postcard`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'commseq_postcard_uuid' in params:
            path_params['commseq_postcard_uuid'] = params['commseq_postcard_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_commseq_postcard' in params:
            body_params = params['email_commseq_postcard']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/postcards/{commseq_postcard_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailCommseqPostcardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_segment(self, storefront_oid, email_segment_uuid, email_segment, **kwargs):  # noqa: E501
        """Update email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_segment(storefront_oid, email_segment_uuid, email_segment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :param EmailSegment email_segment: Email segment (required)
        :return: EmailSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_segment_with_http_info(storefront_oid, email_segment_uuid, email_segment, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_segment_with_http_info(storefront_oid, email_segment_uuid, email_segment, **kwargs)  # noqa: E501
            return data

    def update_email_segment_with_http_info(self, storefront_oid, email_segment_uuid, email_segment, **kwargs):  # noqa: E501
        """Update email segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_segment_with_http_info(storefront_oid, email_segment_uuid, email_segment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_segment_uuid: (required)
        :param EmailSegment email_segment: Email segment (required)
        :return: EmailSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_segment_uuid', 'email_segment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_segment`")  # noqa: E501
        # verify the required parameter 'email_segment_uuid' is set
        if ('email_segment_uuid' not in params or
                params['email_segment_uuid'] is None):
            raise ValueError("Missing the required parameter `email_segment_uuid` when calling `update_email_segment`")  # noqa: E501
        # verify the required parameter 'email_segment' is set
        if ('email_segment' not in params or
                params['email_segment'] is None):
            raise ValueError("Missing the required parameter `email_segment` when calling `update_email_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_segment_uuid' in params:
            path_params['email_segment_uuid'] = params['email_segment_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_segment' in params:
            body_params = params['email_segment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/segments/{email_segment_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSegmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_sending_domain(self, domain, email_domain, **kwargs):  # noqa: E501
        """Update email sending domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_sending_domain(domain, email_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: (required)
        :param EmailDomain email_domain: EmailDomain (required)
        :return: EmailSendingDomainResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_sending_domain_with_http_info(domain, email_domain, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_sending_domain_with_http_info(domain, email_domain, **kwargs)  # noqa: E501
            return data

    def update_email_sending_domain_with_http_info(self, domain, email_domain, **kwargs):  # noqa: E501
        """Update email sending domain  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_sending_domain_with_http_info(domain, email_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str domain: (required)
        :param EmailDomain email_domain: EmailDomain (required)
        :return: EmailSendingDomainResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['domain', 'email_domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_sending_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `update_email_sending_domain`")  # noqa: E501
        # verify the required parameter 'email_domain' is set
        if ('email_domain' not in params or
                params['email_domain'] is None):
            raise ValueError("Missing the required parameter `email_domain` when calling `update_email_sending_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'email_domain' in params:
            body_params = params['email_domain']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/email/sending_domains/{domain}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSendingDomainResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_email_settings(self, storefront_oid, settings, **kwargs):  # noqa: E501
        """Update email settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_settings(storefront_oid, settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailSettings settings: settings request (required)
        :return: EmailSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_email_settings_with_http_info(storefront_oid, settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_email_settings_with_http_info(storefront_oid, settings, **kwargs)  # noqa: E501
            return data

    def update_email_settings_with_http_info(self, storefront_oid, settings, **kwargs):  # noqa: E501
        """Update email settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_email_settings_with_http_info(storefront_oid, settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param EmailSettings settings: settings request (required)
        :return: EmailSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_email_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_email_settings`")  # noqa: E501
        # verify the required parameter 'settings' is set
        if ('settings' not in params or
                params['settings'] is None):
            raise ValueError("Missing the required parameter `settings` when calling `update_email_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings' in params:
            body_params = params['settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/email/settings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmailSettingsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_experiment(self, storefront_oid, storefront_experiment_oid, experiment, **kwargs):  # noqa: E501
        """Update experiment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_experiment(storefront_oid, storefront_experiment_oid, experiment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int storefront_experiment_oid: (required)
        :param Experiment experiment: Experiment (required)
        :return: ExperimentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_experiment_with_http_info(storefront_oid, storefront_experiment_oid, experiment, **kwargs)  # noqa: E501
        else:
            (data) = self.update_experiment_with_http_info(storefront_oid, storefront_experiment_oid, experiment, **kwargs)  # noqa: E501
            return data

    def update_experiment_with_http_info(self, storefront_oid, storefront_experiment_oid, experiment, **kwargs):  # noqa: E501
        """Update experiment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_experiment_with_http_info(storefront_oid, storefront_experiment_oid, experiment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int storefront_experiment_oid: (required)
        :param Experiment experiment: Experiment (required)
        :return: ExperimentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'storefront_experiment_oid', 'experiment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_experiment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_experiment`")  # noqa: E501
        # verify the required parameter 'storefront_experiment_oid' is set
        if ('storefront_experiment_oid' not in params or
                params['storefront_experiment_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_experiment_oid` when calling `update_experiment`")  # noqa: E501
        # verify the required parameter 'experiment' is set
        if ('experiment' not in params or
                params['experiment'] is None):
            raise ValueError("Missing the required parameter `experiment` when calling `update_experiment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'storefront_experiment_oid' in params:
            path_params['storefront_experiment_oid'] = params['storefront_experiment_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'experiment' in params:
            body_params = params['experiment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/experiments/{storefront_experiment_oid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExperimentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_library_item(self, library_item_oid, library_item, **kwargs):  # noqa: E501
        """Update library item. Note that only certain fields may be updated via this method.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_library_item(library_item_oid, library_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :param LibraryItem library_item: Library item (required)
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_library_item_with_http_info(library_item_oid, library_item, **kwargs)  # noqa: E501
        else:
            (data) = self.update_library_item_with_http_info(library_item_oid, library_item, **kwargs)  # noqa: E501
            return data

    def update_library_item_with_http_info(self, library_item_oid, library_item, **kwargs):  # noqa: E501
        """Update library item. Note that only certain fields may be updated via this method.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_library_item_with_http_info(library_item_oid, library_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int library_item_oid: (required)
        :param LibraryItem library_item: Library item (required)
        :return: LibraryItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['library_item_oid', 'library_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_library_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'library_item_oid' is set
        if ('library_item_oid' not in params or
                params['library_item_oid'] is None):
            raise ValueError("Missing the required parameter `library_item_oid` when calling `update_library_item`")  # noqa: E501
        # verify the required parameter 'library_item' is set
        if ('library_item' not in params or
                params['library_item'] is None):
            raise ValueError("Missing the required parameter `library_item` when calling `update_library_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'library_item_oid' in params:
            path_params['library_item_oid'] = params['library_item_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'library_item' in params:
            body_params = params['library_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/code_library/{library_item_oid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LibraryItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_screen_recording_merchant_notes(self, storefront_oid, screen_recording_uuid, merchant_notes_request, **kwargs):  # noqa: E501
        """Update merchant notes on a screen recording  # noqa: E501

        Update merchant notes on a screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_screen_recording_merchant_notes(storefront_oid, screen_recording_uuid, merchant_notes_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :param ScreenRecordingMerchantNotesRequest merchant_notes_request: Merchant Notes (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_screen_recording_merchant_notes_with_http_info(storefront_oid, screen_recording_uuid, merchant_notes_request, **kwargs)  # noqa: E501
        else:
            (data) = self.update_screen_recording_merchant_notes_with_http_info(storefront_oid, screen_recording_uuid, merchant_notes_request, **kwargs)  # noqa: E501
            return data

    def update_screen_recording_merchant_notes_with_http_info(self, storefront_oid, screen_recording_uuid, merchant_notes_request, **kwargs):  # noqa: E501
        """Update merchant notes on a screen recording  # noqa: E501

        Update merchant notes on a screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_screen_recording_merchant_notes_with_http_info(storefront_oid, screen_recording_uuid, merchant_notes_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :param ScreenRecordingMerchantNotesRequest merchant_notes_request: Merchant Notes (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'screen_recording_uuid', 'merchant_notes_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_screen_recording_merchant_notes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_screen_recording_merchant_notes`")  # noqa: E501
        # verify the required parameter 'screen_recording_uuid' is set
        if ('screen_recording_uuid' not in params or
                params['screen_recording_uuid'] is None):
            raise ValueError("Missing the required parameter `screen_recording_uuid` when calling `update_screen_recording_merchant_notes`")  # noqa: E501
        # verify the required parameter 'merchant_notes_request' is set
        if ('merchant_notes_request' not in params or
                params['merchant_notes_request'] is None):
            raise ValueError("Missing the required parameter `merchant_notes_request` when calling `update_screen_recording_merchant_notes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'screen_recording_uuid' in params:
            path_params['screen_recording_uuid'] = params['screen_recording_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'merchant_notes_request' in params:
            body_params = params['merchant_notes_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid}/merchant_notes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_screen_recording_segment(self, storefront_oid, screen_recording_segment_oid, segment, **kwargs):  # noqa: E501
        """Update screen recording segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_screen_recording_segment(storefront_oid, screen_recording_segment_oid, segment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int screen_recording_segment_oid: (required)
        :param ScreenRecordingSegment segment: Segment (required)
        :return: ScreenRecordingSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_screen_recording_segment_with_http_info(storefront_oid, screen_recording_segment_oid, segment, **kwargs)  # noqa: E501
        else:
            (data) = self.update_screen_recording_segment_with_http_info(storefront_oid, screen_recording_segment_oid, segment, **kwargs)  # noqa: E501
            return data

    def update_screen_recording_segment_with_http_info(self, storefront_oid, screen_recording_segment_oid, segment, **kwargs):  # noqa: E501
        """Update screen recording segment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_screen_recording_segment_with_http_info(storefront_oid, screen_recording_segment_oid, segment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param int screen_recording_segment_oid: (required)
        :param ScreenRecordingSegment segment: Segment (required)
        :return: ScreenRecordingSegmentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'screen_recording_segment_oid', 'segment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_screen_recording_segment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_screen_recording_segment`")  # noqa: E501
        # verify the required parameter 'screen_recording_segment_oid' is set
        if ('screen_recording_segment_oid' not in params or
                params['screen_recording_segment_oid'] is None):
            raise ValueError("Missing the required parameter `screen_recording_segment_oid` when calling `update_screen_recording_segment`")  # noqa: E501
        # verify the required parameter 'segment' is set
        if ('segment' not in params or
                params['segment'] is None):
            raise ValueError("Missing the required parameter `segment` when calling `update_screen_recording_segment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'screen_recording_segment_oid' in params:
            path_params['screen_recording_segment_oid'] = params['screen_recording_segment_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'segment' in params:
            body_params = params['segment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/segments/{screen_recording_segment_oid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingSegmentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_screen_recording_settings(self, storefront_oid, settings, **kwargs):  # noqa: E501
        """Update screen recording settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_screen_recording_settings(storefront_oid, settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingSettings settings: Settings (required)
        :return: ScreenRecordingSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_screen_recording_settings_with_http_info(storefront_oid, settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_screen_recording_settings_with_http_info(storefront_oid, settings, **kwargs)  # noqa: E501
            return data

    def update_screen_recording_settings_with_http_info(self, storefront_oid, settings, **kwargs):  # noqa: E501
        """Update screen recording settings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_screen_recording_settings_with_http_info(storefront_oid, settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param ScreenRecordingSettings settings: Settings (required)
        :return: ScreenRecordingSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_screen_recording_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_screen_recording_settings`")  # noqa: E501
        # verify the required parameter 'settings' is set
        if ('settings' not in params or
                params['settings'] is None):
            raise ValueError("Missing the required parameter `settings` when calling `update_screen_recording_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings' in params:
            body_params = params['settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/settings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScreenRecordingSettingsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_screen_recording_tags(self, storefront_oid, screen_recording_uuid, tags, **kwargs):  # noqa: E501
        """Update tags on a screen recording  # noqa: E501

        Update tags on a screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_screen_recording_tags(storefront_oid, screen_recording_uuid, tags, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :param ScreenRecordingTagsRequest tags: Tags (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_screen_recording_tags_with_http_info(storefront_oid, screen_recording_uuid, tags, **kwargs)  # noqa: E501
        else:
            (data) = self.update_screen_recording_tags_with_http_info(storefront_oid, screen_recording_uuid, tags, **kwargs)  # noqa: E501
            return data

    def update_screen_recording_tags_with_http_info(self, storefront_oid, screen_recording_uuid, tags, **kwargs):  # noqa: E501
        """Update tags on a screen recording  # noqa: E501

        Update tags on a screen recording   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_screen_recording_tags_with_http_info(storefront_oid, screen_recording_uuid, tags, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str screen_recording_uuid: (required)
        :param ScreenRecordingTagsRequest tags: Tags (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'screen_recording_uuid', 'tags']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_screen_recording_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_screen_recording_tags`")  # noqa: E501
        # verify the required parameter 'screen_recording_uuid' is set
        if ('screen_recording_uuid' not in params or
                params['screen_recording_uuid'] is None):
            raise ValueError("Missing the required parameter `screen_recording_uuid` when calling `update_screen_recording_tags`")  # noqa: E501
        # verify the required parameter 'tags' is set
        if ('tags' not in params or
                params['tags'] is None):
            raise ValueError("Missing the required parameter `tags` when calling `update_screen_recording_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'screen_recording_uuid' in params:
            path_params['screen_recording_uuid'] = params['screen_recording_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tags' in params:
            body_params = params['tags']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/screen_recordings/{screen_recording_uuid}/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_transaction_email(self, storefront_oid, email_id, transaction_email, **kwargs):  # noqa: E501
        """Updates a transaction email object  # noqa: E501

        Updates a transactional email   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transaction_email(storefront_oid, email_id, transaction_email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_id: (required)
        :param TransactionEmail transaction_email: TransactionEmail (required)
        :return: TransactionEmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_transaction_email_with_http_info(storefront_oid, email_id, transaction_email, **kwargs)  # noqa: E501
        else:
            (data) = self.update_transaction_email_with_http_info(storefront_oid, email_id, transaction_email, **kwargs)  # noqa: E501
            return data

    def update_transaction_email_with_http_info(self, storefront_oid, email_id, transaction_email, **kwargs):  # noqa: E501
        """Updates a transaction email object  # noqa: E501

        Updates a transactional email   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transaction_email_with_http_info(storefront_oid, email_id, transaction_email, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int storefront_oid: (required)
        :param str email_id: (required)
        :param TransactionEmail transaction_email: TransactionEmail (required)
        :return: TransactionEmailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storefront_oid', 'email_id', 'transaction_email']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_transaction_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storefront_oid' is set
        if ('storefront_oid' not in params or
                params['storefront_oid'] is None):
            raise ValueError("Missing the required parameter `storefront_oid` when calling `update_transaction_email`")  # noqa: E501
        # verify the required parameter 'email_id' is set
        if ('email_id' not in params or
                params['email_id'] is None):
            raise ValueError("Missing the required parameter `email_id` when calling `update_transaction_email`")  # noqa: E501
        # verify the required parameter 'transaction_email' is set
        if ('transaction_email' not in params or
                params['transaction_email'] is None):
            raise ValueError("Missing the required parameter `transaction_email` when calling `update_transaction_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storefront_oid' in params:
            path_params['storefront_oid'] = params['storefront_oid']  # noqa: E501
        if 'email_id' in params:
            path_params['email_id'] = params['email_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transaction_email' in params:
            body_params = params['transaction_email']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/{storefront_oid}/transaction_email/list/{email_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionEmailResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_twilio_account(self, esp_twilio_uuid, twilio, **kwargs):  # noqa: E501
        """Update Twilio account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_twilio_account(esp_twilio_uuid, twilio, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str esp_twilio_uuid: (required)
        :param Twilio twilio: Twilio (required)
        :return: TwilioResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_twilio_account_with_http_info(esp_twilio_uuid, twilio, **kwargs)  # noqa: E501
        else:
            (data) = self.update_twilio_account_with_http_info(esp_twilio_uuid, twilio, **kwargs)  # noqa: E501
            return data

    def update_twilio_account_with_http_info(self, esp_twilio_uuid, twilio, **kwargs):  # noqa: E501
        """Update Twilio account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_twilio_account_with_http_info(esp_twilio_uuid, twilio, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str esp_twilio_uuid: (required)
        :param Twilio twilio: Twilio (required)
        :return: TwilioResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['esp_twilio_uuid', 'twilio']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_twilio_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'esp_twilio_uuid' is set
        if ('esp_twilio_uuid' not in params or
                params['esp_twilio_uuid'] is None):
            raise ValueError("Missing the required parameter `esp_twilio_uuid` when calling `update_twilio_account`")  # noqa: E501
        # verify the required parameter 'twilio' is set
        if ('twilio' not in params or
                params['twilio'] is None):
            raise ValueError("Missing the required parameter `twilio` when calling `update_twilio_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'esp_twilio_uuid' in params:
            path_params['esp_twilio_uuid'] = params['esp_twilio_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'twilio' in params:
            body_params = params['twilio']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartBrowserApiKey', 'ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/storefront/twilio/accounts/{esp_twilio_uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TwilioResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
