# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class OrderApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return OrderApi(api_client)




    def adjust_order_total(self, order_id, desired_total, **kwargs):  # noqa: E501
        """Adjusts an order total  # noqa: E501

        Adjusts an order total.  Adjusts individual items appropriately and considers taxes.  Desired total should be provided in the same currency as the order and must be less than the current total and greater than zero.  This call will change the order total.  It returns true if the desired total is achieved.  If the goal seeking algorithm falls short (usually by pennies), this method returns back false.  View the merchant notes for the order for further details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.adjust_order_total(order_id, desired_total, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to cancel. (required)
        :param str desired_total: The desired total with no formatting. example 123.45 (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.adjust_order_total_with_http_info(order_id, desired_total, **kwargs)  # noqa: E501
        else:
            (data) = self.adjust_order_total_with_http_info(order_id, desired_total, **kwargs)  # noqa: E501
            return data

    def adjust_order_total_with_http_info(self, order_id, desired_total, **kwargs):  # noqa: E501
        """Adjusts an order total  # noqa: E501

        Adjusts an order total.  Adjusts individual items appropriately and considers taxes.  Desired total should be provided in the same currency as the order and must be less than the current total and greater than zero.  This call will change the order total.  It returns true if the desired total is achieved.  If the goal seeking algorithm falls short (usually by pennies), this method returns back false.  View the merchant notes for the order for further details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.adjust_order_total_with_http_info(order_id, desired_total, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to cancel. (required)
        :param str desired_total: The desired total with no formatting. example 123.45 (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'desired_total']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method adjust_order_total" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `adjust_order_total`")  # noqa: E501
        # verify the required parameter 'desired_total' is set
        if ('desired_total' not in params or
                params['desired_total'] is None):
            raise ValueError("Missing the required parameter `desired_total` when calling `adjust_order_total`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501
        if 'desired_total' in params:
            path_params['desired_total'] = params['desired_total']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}/adjust_order_total/{desired_total}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_order(self, order_id, **kwargs):  # noqa: E501
        """Cancel an order  # noqa: E501

        Cancel an order on the UltraCart account.  If the success flag is false, then consult the error message for why it failed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_order(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to cancel. (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_order_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_order_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def cancel_order_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Cancel an order  # noqa: E501

        Cancel an order on the UltraCart account.  If the success flag is false, then consult the error message for why it failed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_order_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to cancel. (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `cancel_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_order(self, order_id, **kwargs):  # noqa: E501
        """Delete an order  # noqa: E501

        Delete an order on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_order(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_order_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_order_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def delete_order_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Delete an order  # noqa: E501

        Delete an order on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_order_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `delete_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def duplicate_order(self, order_id, **kwargs):  # noqa: E501
        """Duplicate an order  # noqa: E501

        Perform a duplicate of the specified order_id and return a new order located in Accounts Receivable.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duplicate_order(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to duplicate. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.duplicate_order_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.duplicate_order_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def duplicate_order_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Duplicate an order  # noqa: E501

        Perform a duplicate of the specified order_id and return a new order located in Accounts Receivable.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duplicate_order_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to duplicate. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method duplicate_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `duplicate_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}/duplicate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def format(self, order_id, format_options, **kwargs):  # noqa: E501
        """Format order  # noqa: E501

        Format the order for display at text or html   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.format(order_id, format_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to format (required)
        :param OrderFormat format_options: Format options (required)
        :return: OrderFormatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.format_with_http_info(order_id, format_options, **kwargs)  # noqa: E501
        else:
            (data) = self.format_with_http_info(order_id, format_options, **kwargs)  # noqa: E501
            return data

    def format_with_http_info(self, order_id, format_options, **kwargs):  # noqa: E501
        """Format order  # noqa: E501

        Format the order for display at text or html   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.format_with_http_info(order_id, format_options, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to format (required)
        :param OrderFormat format_options: Format options (required)
        :return: OrderFormatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'format_options']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method format" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `format`")  # noqa: E501
        # verify the required parameter 'format_options' is set
        if ('format_options' not in params or
                params['format_options'] is None):
            raise ValueError("Missing the required parameter `format_options` when calling `format`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'format_options' in params:
            body_params = params['format_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}/format', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderFormatResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_order_token(self, order_id, **kwargs):  # noqa: E501
        """Generate an order token for a given order id  # noqa: E501

        Retrieves a single order token for a given order id.  The token can be used with the getOrderByToken API.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_order_token(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to generate a token for. (required)
        :return: OrderTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_order_token_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_order_token_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def generate_order_token_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Generate an order token for a given order id  # noqa: E501

        Retrieves a single order token for a given order id.  The token can be used with the getOrderByToken API.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_order_token_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to generate a token for. (required)
        :return: OrderTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_order_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `generate_order_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/token/{order_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderTokenResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_packing_slip_all_dc(self, order_id, **kwargs):  # noqa: E501
        """Generate a packing slip for this order across all distribution centers.  # noqa: E501

        The packing slip PDF that is returned is base 64 encoded   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_packing_slip_all_dc(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: Order ID (required)
        :return: OrderPackingSlipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_packing_slip_all_dc_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_packing_slip_all_dc_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def generate_packing_slip_all_dc_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Generate a packing slip for this order across all distribution centers.  # noqa: E501

        The packing slip PDF that is returned is base 64 encoded   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_packing_slip_all_dc_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: Order ID (required)
        :return: OrderPackingSlipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_packing_slip_all_dc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `generate_packing_slip_all_dc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}/packing_slip', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderPackingSlipResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_packing_slip_specific_dc(self, distribution_center_code, order_id, **kwargs):  # noqa: E501
        """Generate a packing slip for this order for the given distribution center.  # noqa: E501

        The packing slip PDF that is returned is base 64 encoded   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_packing_slip_specific_dc(distribution_center_code, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :param str order_id: Order ID (required)
        :return: OrderPackingSlipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_packing_slip_specific_dc_with_http_info(distribution_center_code, order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_packing_slip_specific_dc_with_http_info(distribution_center_code, order_id, **kwargs)  # noqa: E501
            return data

    def generate_packing_slip_specific_dc_with_http_info(self, distribution_center_code, order_id, **kwargs):  # noqa: E501
        """Generate a packing slip for this order for the given distribution center.  # noqa: E501

        The packing slip PDF that is returned is base 64 encoded   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_packing_slip_specific_dc_with_http_info(distribution_center_code, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :param str order_id: Order ID (required)
        :return: OrderPackingSlipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['distribution_center_code', 'order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_packing_slip_specific_dc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'distribution_center_code' is set
        if ('distribution_center_code' not in params or
                params['distribution_center_code'] is None):
            raise ValueError("Missing the required parameter `distribution_center_code` when calling `generate_packing_slip_specific_dc`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `generate_packing_slip_specific_dc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'distribution_center_code' in params:
            path_params['distribution_center_code'] = params['distribution_center_code']  # noqa: E501
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}/packing_slip/{distribution_center_code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderPackingSlipResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_accounts_receivable_retry_config(self, **kwargs):  # noqa: E501
        """Retrieve A/R Retry Configuration  # noqa: E501

        Retrieve A/R Retry Configuration. This is primarily an internal API call.  It is doubtful you would ever need to use it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accounts_receivable_retry_config(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AccountsReceivableRetryConfigResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_accounts_receivable_retry_config_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_accounts_receivable_retry_config_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_accounts_receivable_retry_config_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve A/R Retry Configuration  # noqa: E501

        Retrieve A/R Retry Configuration. This is primarily an internal API call.  It is doubtful you would ever need to use it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accounts_receivable_retry_config_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AccountsReceivableRetryConfigResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_accounts_receivable_retry_config" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/accountsReceivableRetryConfig', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountsReceivableRetryConfigResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_accounts_receivable_retry_stats(self, **kwargs):  # noqa: E501
        """Retrieve A/R Retry Statistics  # noqa: E501

        Retrieve A/R Retry Statistics. This is primarily an internal API call.  It is doubtful you would ever need to use it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accounts_receivable_retry_stats(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _from:
        :param str to:
        :return: AccountsReceivableRetryStatsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_accounts_receivable_retry_stats_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_accounts_receivable_retry_stats_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_accounts_receivable_retry_stats_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve A/R Retry Statistics  # noqa: E501

        Retrieve A/R Retry Statistics. This is primarily an internal API call.  It is doubtful you would ever need to use it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accounts_receivable_retry_stats_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _from:
        :param str to:
        :return: AccountsReceivableRetryStatsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_from', 'to']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_accounts_receivable_retry_stats" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/accountsReceivableRetryConfig/stats', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountsReceivableRetryStatsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order(self, order_id, **kwargs):  # noqa: E501
        """Retrieve an order  # noqa: E501

        Retrieves a single order using the specified order id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_order_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def get_order_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Retrieve an order  # noqa: E501

        Retrieves a single order using the specified order id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `get_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order_by_token(self, order_by_token_query, **kwargs):  # noqa: E501
        """Retrieve an order using a token  # noqa: E501

        Retrieves a single order using the specified order token.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_by_token(order_by_token_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderByTokenQuery order_by_token_query: Order by token query (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_by_token_with_http_info(order_by_token_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_order_by_token_with_http_info(order_by_token_query, **kwargs)  # noqa: E501
            return data

    def get_order_by_token_with_http_info(self, order_by_token_query, **kwargs):  # noqa: E501
        """Retrieve an order using a token  # noqa: E501

        Retrieves a single order using the specified order token.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_by_token_with_http_info(order_by_token_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderByTokenQuery order_by_token_query: Order by token query (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_by_token_query', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_by_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_by_token_query' is set
        if ('order_by_token_query' not in params or
                params['order_by_token_query'] is None):
            raise ValueError("Missing the required parameter `order_by_token_query` when calling `get_order_by_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order_by_token_query' in params:
            body_params = params['order_by_token_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/token', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_orders(self, **kwargs):  # noqa: E501
        """Retrieve orders  # noqa: E501

        Retrieves a group of orders from the account.  If no parameters are specified, the API call will fail with a bad request error.  Always specify some parameters to limit the scope of the orders returned to ones you are truly interested in.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orders(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: Order Id
        :param str payment_method: Payment Method
        :param str company: Company
        :param str first_name: First Name
        :param str last_name: Last Name
        :param str city: City
        :param str state_region: State/Region
        :param str postal_code: Postal Code
        :param str country_code: Country Code (ISO-3166 two letter)
        :param str phone: Phone
        :param str email: Email
        :param str cc_email: CC Email
        :param float total: Total
        :param str screen_branding_theme_code: Screen Branding Theme Code
        :param str storefront_host_name: StoreFront Host Name
        :param str creation_date_begin: Creation Date Begin
        :param str creation_date_end: Creation Date End
        :param str payment_date_begin: Payment Date Begin
        :param str payment_date_end: Payment Date End
        :param str shipment_date_begin: Shipment Date Begin
        :param str shipment_date_end: Shipment Date End
        :param str rma: RMA
        :param str purchase_order_number: Purchase Order Number
        :param str item_id: Item Id
        :param str current_stage: Current Stage
        :param str channel_partner_code: Channel Partner Code
        :param str channel_partner_order_id: Channel Partner Order ID
        :param int limit: The maximum number of records to return on this one API call. (Maximum 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the orders.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_orders_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_orders_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_orders_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve orders  # noqa: E501

        Retrieves a group of orders from the account.  If no parameters are specified, the API call will fail with a bad request error.  Always specify some parameters to limit the scope of the orders returned to ones you are truly interested in.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orders_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: Order Id
        :param str payment_method: Payment Method
        :param str company: Company
        :param str first_name: First Name
        :param str last_name: Last Name
        :param str city: City
        :param str state_region: State/Region
        :param str postal_code: Postal Code
        :param str country_code: Country Code (ISO-3166 two letter)
        :param str phone: Phone
        :param str email: Email
        :param str cc_email: CC Email
        :param float total: Total
        :param str screen_branding_theme_code: Screen Branding Theme Code
        :param str storefront_host_name: StoreFront Host Name
        :param str creation_date_begin: Creation Date Begin
        :param str creation_date_end: Creation Date End
        :param str payment_date_begin: Payment Date Begin
        :param str payment_date_end: Payment Date End
        :param str shipment_date_begin: Shipment Date Begin
        :param str shipment_date_end: Shipment Date End
        :param str rma: RMA
        :param str purchase_order_number: Purchase Order Number
        :param str item_id: Item Id
        :param str current_stage: Current Stage
        :param str channel_partner_code: Channel Partner Code
        :param str channel_partner_order_id: Channel Partner Order ID
        :param int limit: The maximum number of records to return on this one API call. (Maximum 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the orders.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'payment_method', 'company', 'first_name', 'last_name', 'city', 'state_region', 'postal_code', 'country_code', 'phone', 'email', 'cc_email', 'total', 'screen_branding_theme_code', 'storefront_host_name', 'creation_date_begin', 'creation_date_end', 'payment_date_begin', 'payment_date_end', 'shipment_date_begin', 'shipment_date_end', 'rma', 'purchase_order_number', 'item_id', 'current_stage', 'channel_partner_code', 'channel_partner_order_id', 'limit', 'offset', 'sort', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orders" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'order_id' in params:
            query_params.append(('order_id', params['order_id']))  # noqa: E501
        if 'payment_method' in params:
            query_params.append(('payment_method', params['payment_method']))  # noqa: E501
        if 'company' in params:
            query_params.append(('company', params['company']))  # noqa: E501
        if 'first_name' in params:
            query_params.append(('first_name', params['first_name']))  # noqa: E501
        if 'last_name' in params:
            query_params.append(('last_name', params['last_name']))  # noqa: E501
        if 'city' in params:
            query_params.append(('city', params['city']))  # noqa: E501
        if 'state_region' in params:
            query_params.append(('state_region', params['state_region']))  # noqa: E501
        if 'postal_code' in params:
            query_params.append(('postal_code', params['postal_code']))  # noqa: E501
        if 'country_code' in params:
            query_params.append(('country_code', params['country_code']))  # noqa: E501
        if 'phone' in params:
            query_params.append(('phone', params['phone']))  # noqa: E501
        if 'email' in params:
            query_params.append(('email', params['email']))  # noqa: E501
        if 'cc_email' in params:
            query_params.append(('cc_email', params['cc_email']))  # noqa: E501
        if 'total' in params:
            query_params.append(('total', params['total']))  # noqa: E501
        if 'screen_branding_theme_code' in params:
            query_params.append(('screen_branding_theme_code', params['screen_branding_theme_code']))  # noqa: E501
        if 'storefront_host_name' in params:
            query_params.append(('storefront_host_name', params['storefront_host_name']))  # noqa: E501
        if 'creation_date_begin' in params:
            query_params.append(('creation_date_begin', params['creation_date_begin']))  # noqa: E501
        if 'creation_date_end' in params:
            query_params.append(('creation_date_end', params['creation_date_end']))  # noqa: E501
        if 'payment_date_begin' in params:
            query_params.append(('payment_date_begin', params['payment_date_begin']))  # noqa: E501
        if 'payment_date_end' in params:
            query_params.append(('payment_date_end', params['payment_date_end']))  # noqa: E501
        if 'shipment_date_begin' in params:
            query_params.append(('shipment_date_begin', params['shipment_date_begin']))  # noqa: E501
        if 'shipment_date_end' in params:
            query_params.append(('shipment_date_end', params['shipment_date_end']))  # noqa: E501
        if 'rma' in params:
            query_params.append(('rma', params['rma']))  # noqa: E501
        if 'purchase_order_number' in params:
            query_params.append(('purchase_order_number', params['purchase_order_number']))  # noqa: E501
        if 'item_id' in params:
            query_params.append(('item_id', params['item_id']))  # noqa: E501
        if 'current_stage' in params:
            query_params.append(('current_stage', params['current_stage']))  # noqa: E501
        if 'channel_partner_code' in params:
            query_params.append(('channel_partner_code', params['channel_partner_code']))  # noqa: E501
        if 'channel_partner_order_id' in params:
            query_params.append(('channel_partner_order_id', params['channel_partner_order_id']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_orders_batch(self, order_batch, **kwargs):  # noqa: E501
        """Retrieve order batch  # noqa: E501

        Retrieves a group of orders from the account based on an array of order ids.  If more than 500 order ids are specified, the API call will fail with a bad request error.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orders_batch(order_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderQueryBatch order_batch: Order batch (required)
        :param str expand: The object expansion to perform on the result.
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_orders_batch_with_http_info(order_batch, **kwargs)  # noqa: E501
        else:
            (data) = self.get_orders_batch_with_http_info(order_batch, **kwargs)  # noqa: E501
            return data

    def get_orders_batch_with_http_info(self, order_batch, **kwargs):  # noqa: E501
        """Retrieve order batch  # noqa: E501

        Retrieves a group of orders from the account based on an array of order ids.  If more than 500 order ids are specified, the API call will fail with a bad request error.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orders_batch_with_http_info(order_batch, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderQueryBatch order_batch: Order batch (required)
        :param str expand: The object expansion to perform on the result.
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_batch', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orders_batch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_batch' is set
        if ('order_batch' not in params or
                params['order_batch'] is None):
            raise ValueError("Missing the required parameter `order_batch` when calling `get_orders_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order_batch' in params:
            body_params = params['order_batch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_orders_by_query(self, order_query, **kwargs):  # noqa: E501
        """Retrieve orders by query  # noqa: E501

        Retrieves a group of orders from the account based on a query object.  If no parameters are specified, the API call will fail with a bad request error.  Always specify some parameters to limit the scope of the orders returned to ones you are truly interested in.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orders_by_query(order_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderQuery order_query: Order query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the orders.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_orders_by_query_with_http_info(order_query, **kwargs)  # noqa: E501
        else:
            (data) = self.get_orders_by_query_with_http_info(order_query, **kwargs)  # noqa: E501
            return data

    def get_orders_by_query_with_http_info(self, order_query, **kwargs):  # noqa: E501
        """Retrieve orders by query  # noqa: E501

        Retrieves a group of orders from the account based on a query object.  If no parameters are specified, the API call will fail with a bad request error.  Always specify some parameters to limit the scope of the orders returned to ones you are truly interested in.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orders_by_query_with_http_info(order_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderQuery order_query: Order query (required)
        :param int limit: The maximum number of records to return on this one API call. (Maximum 200)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str sort: The sort order of the orders.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_query', 'limit', 'offset', 'sort', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orders_by_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_query' is set
        if ('order_query' not in params or
                params['order_query'] is None):
            raise ValueError("Missing the required parameter `order_query` when calling `get_orders_by_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order_query' in params:
            body_params = params['order_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_order(self, order, **kwargs):  # noqa: E501
        """Insert an order  # noqa: E501

        Inserts a new order on the UltraCart account.  This is probably NOT the method you want.  This is for channel orders.  For regular orders the customer is entering, use the CheckoutApi.  It has many, many more features, checks, and validations.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_order(order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Order order: Order to insert (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_order_with_http_info(order, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_order_with_http_info(order, **kwargs)  # noqa: E501
            return data

    def insert_order_with_http_info(self, order, **kwargs):  # noqa: E501
        """Insert an order  # noqa: E501

        Inserts a new order on the UltraCart account.  This is probably NOT the method you want.  This is for channel orders.  For regular orders the customer is entering, use the CheckoutApi.  It has many, many more features, checks, and validations.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_order_with_http_info(order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Order order: Order to insert (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order' is set
        if ('order' not in params or
                params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `insert_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in params:
            body_params = params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def process_payment(self, order_id, process_payment_request, **kwargs):  # noqa: E501
        """Process payment  # noqa: E501

        Process payment on order   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_payment(order_id, process_payment_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to process payment on (required)
        :param OrderProcessPaymentRequest process_payment_request: Process payment parameters (required)
        :return: OrderProcessPaymentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.process_payment_with_http_info(order_id, process_payment_request, **kwargs)  # noqa: E501
        else:
            (data) = self.process_payment_with_http_info(order_id, process_payment_request, **kwargs)  # noqa: E501
            return data

    def process_payment_with_http_info(self, order_id, process_payment_request, **kwargs):  # noqa: E501
        """Process payment  # noqa: E501

        Process payment on order   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.process_payment_with_http_info(order_id, process_payment_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to process payment on (required)
        :param OrderProcessPaymentRequest process_payment_request: Process payment parameters (required)
        :return: OrderProcessPaymentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'process_payment_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method process_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `process_payment`")  # noqa: E501
        # verify the required parameter 'process_payment_request' is set
        if ('process_payment_request' not in params or
                params['process_payment_request'] is None):
            raise ValueError("Missing the required parameter `process_payment_request` when calling `process_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'process_payment_request' in params:
            body_params = params['process_payment_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}/process_payment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderProcessPaymentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def refund_order(self, order, order_id, **kwargs):  # noqa: E501
        """Refund an order  # noqa: E501

        Perform a refund operation on an order and then update the order if successful   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refund_order(order, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Order order: Order to refund (required)
        :param str order_id: The order id to refund. (required)
        :param bool reject_after_refund: Reject order after refund
        :param bool skip_customer_notification: Skip customer email notification
        :param bool auto_order_cancel: Cancel associated auto orders
        :param bool manual_refund: Consider a manual refund done externally
        :param bool reverse_affiliate_transactions: Reverse affiliate transactions
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.refund_order_with_http_info(order, order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.refund_order_with_http_info(order, order_id, **kwargs)  # noqa: E501
            return data

    def refund_order_with_http_info(self, order, order_id, **kwargs):  # noqa: E501
        """Refund an order  # noqa: E501

        Perform a refund operation on an order and then update the order if successful   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refund_order_with_http_info(order, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Order order: Order to refund (required)
        :param str order_id: The order id to refund. (required)
        :param bool reject_after_refund: Reject order after refund
        :param bool skip_customer_notification: Skip customer email notification
        :param bool auto_order_cancel: Cancel associated auto orders
        :param bool manual_refund: Consider a manual refund done externally
        :param bool reverse_affiliate_transactions: Reverse affiliate transactions
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order', 'order_id', 'reject_after_refund', 'skip_customer_notification', 'auto_order_cancel', 'manual_refund', 'reverse_affiliate_transactions', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refund_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order' is set
        if ('order' not in params or
                params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `refund_order`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `refund_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []
        if 'reject_after_refund' in params:
            query_params.append(('reject_after_refund', params['reject_after_refund']))  # noqa: E501
        if 'skip_customer_notification' in params:
            query_params.append(('skip_customer_notification', params['skip_customer_notification']))  # noqa: E501
        if 'auto_order_cancel' in params:
            query_params.append(('auto_order_cancel', params['auto_order_cancel']))  # noqa: E501
        if 'manual_refund' in params:
            query_params.append(('manual_refund', params['manual_refund']))  # noqa: E501
        if 'reverse_affiliate_transactions' in params:
            query_params.append(('reverse_affiliate_transactions', params['reverse_affiliate_transactions']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in params:
            body_params = params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}/refund', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replacement(self, order_id, replacement, **kwargs):  # noqa: E501
        """Replacement order  # noqa: E501

        Create a replacement order based upon a previous order   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replacement(order_id, replacement, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to generate a replacement for. (required)
        :param OrderReplacement replacement: Replacement order details (required)
        :return: OrderReplacementResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replacement_with_http_info(order_id, replacement, **kwargs)  # noqa: E501
        else:
            (data) = self.replacement_with_http_info(order_id, replacement, **kwargs)  # noqa: E501
            return data

    def replacement_with_http_info(self, order_id, replacement, **kwargs):  # noqa: E501
        """Replacement order  # noqa: E501

        Create a replacement order based upon a previous order   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replacement_with_http_info(order_id, replacement, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to generate a replacement for. (required)
        :param OrderReplacement replacement: Replacement order details (required)
        :return: OrderReplacementResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id', 'replacement']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replacement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `replacement`")  # noqa: E501
        # verify the required parameter 'replacement' is set
        if ('replacement' not in params or
                params['replacement'] is None):
            raise ValueError("Missing the required parameter `replacement` when calling `replacement`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'replacement' in params:
            body_params = params['replacement']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}/replacement', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderReplacementResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resend_receipt(self, order_id, **kwargs):  # noqa: E501
        """Resend receipt  # noqa: E501

        Resend the receipt for an order on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resend_receipt(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to resend the receipt for. (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resend_receipt_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.resend_receipt_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def resend_receipt_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Resend receipt  # noqa: E501

        Resend the receipt for an order on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resend_receipt_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to resend the receipt for. (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resend_receipt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `resend_receipt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}/resend_receipt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resend_shipment_confirmation(self, order_id, **kwargs):  # noqa: E501
        """Resend shipment confirmation  # noqa: E501

        Resend shipment confirmation for an order on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resend_shipment_confirmation(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to resend the shipment notification for. (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resend_shipment_confirmation_with_http_info(order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.resend_shipment_confirmation_with_http_info(order_id, **kwargs)  # noqa: E501
            return data

    def resend_shipment_confirmation_with_http_info(self, order_id, **kwargs):  # noqa: E501
        """Resend shipment confirmation  # noqa: E501

        Resend shipment confirmation for an order on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resend_shipment_confirmation_with_http_info(order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str order_id: The order id to resend the shipment notification for. (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resend_shipment_confirmation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `resend_shipment_confirmation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}/resend_shipment_confirmation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_accounts_receivable_retry_config(self, retry_config, **kwargs):  # noqa: E501
        """Update A/R Retry Configuration  # noqa: E501

        Update A/R Retry Configuration.  This is primarily an internal API call.  It is doubtful you would ever need to use it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_accounts_receivable_retry_config(retry_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountsReceivableRetryConfig retry_config: AccountsReceivableRetryConfig object (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_accounts_receivable_retry_config_with_http_info(retry_config, **kwargs)  # noqa: E501
        else:
            (data) = self.update_accounts_receivable_retry_config_with_http_info(retry_config, **kwargs)  # noqa: E501
            return data

    def update_accounts_receivable_retry_config_with_http_info(self, retry_config, **kwargs):  # noqa: E501
        """Update A/R Retry Configuration  # noqa: E501

        Update A/R Retry Configuration.  This is primarily an internal API call.  It is doubtful you would ever need to use it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_accounts_receivable_retry_config_with_http_info(retry_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountsReceivableRetryConfig retry_config: AccountsReceivableRetryConfig object (required)
        :return: BaseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['retry_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_accounts_receivable_retry_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'retry_config' is set
        if ('retry_config' not in params or
                params['retry_config'] is None):
            raise ValueError("Missing the required parameter `retry_config` when calling `update_accounts_receivable_retry_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'retry_config' in params:
            body_params = params['retry_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/accountsReceivableRetryConfig', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BaseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_order(self, order, order_id, **kwargs):  # noqa: E501
        """Update an order  # noqa: E501

        Update a new order on the UltraCart account.  This is probably NOT the method you want.  It is rare to update a completed order.  This will not trigger charges, emails, or any other automation.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order(order, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Order order: Order to update (required)
        :param str order_id: The order id to update. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_order_with_http_info(order, order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_order_with_http_info(order, order_id, **kwargs)  # noqa: E501
            return data

    def update_order_with_http_info(self, order, order_id, **kwargs):  # noqa: E501
        """Update an order  # noqa: E501

        Update a new order on the UltraCart account.  This is probably NOT the method you want.  It is rare to update a completed order.  This will not trigger charges, emails, or any other automation.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_order_with_http_info(order, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Order order: Order to update (required)
        :param str order_id: The order id to update. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['order', 'order_id', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'order' is set
        if ('order' not in params or
                params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `update_order`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `update_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order' in params:
            body_params = params['order']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/order/orders/{order_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
