# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class ItemApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return ItemApi(api_client)




    def delete_item(self, merchant_item_oid, **kwargs):  # noqa: E501
        """Delete an item  # noqa: E501

        Delete an item on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item(merchant_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int merchant_item_oid: The item oid to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_item_with_http_info(merchant_item_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_item_with_http_info(merchant_item_oid, **kwargs)  # noqa: E501
            return data

    def delete_item_with_http_info(self, merchant_item_oid, **kwargs):  # noqa: E501
        """Delete an item  # noqa: E501

        Delete an item on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_item_with_http_info(merchant_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int merchant_item_oid: The item oid to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['merchant_item_oid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'merchant_item_oid' is set
        if ('merchant_item_oid' not in params or
                params['merchant_item_oid'] is None):
            raise ValueError("Missing the required parameter `merchant_item_oid` when calling `delete_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'merchant_item_oid' in params:
            path_params['merchant_item_oid'] = params['merchant_item_oid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/item/items/{merchant_item_oid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item(self, merchant_item_oid, **kwargs):  # noqa: E501
        """Retrieve an item  # noqa: E501

        Retrieves a single item using the specified item oid.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item(merchant_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int merchant_item_oid: The item oid to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: ItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_item_with_http_info(merchant_item_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_item_with_http_info(merchant_item_oid, **kwargs)  # noqa: E501
            return data

    def get_item_with_http_info(self, merchant_item_oid, **kwargs):  # noqa: E501
        """Retrieve an item  # noqa: E501

        Retrieves a single item using the specified item oid.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_with_http_info(merchant_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int merchant_item_oid: The item oid to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: ItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['merchant_item_oid', 'expand', 'placeholders']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'merchant_item_oid' is set
        if ('merchant_item_oid' not in params or
                params['merchant_item_oid'] is None):
            raise ValueError("Missing the required parameter `merchant_item_oid` when calling `get_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'merchant_item_oid' in params:
            path_params['merchant_item_oid'] = params['merchant_item_oid']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501
        if 'placeholders' in params:
            query_params.append(('_placeholders', params['placeholders']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/item/items/{merchant_item_oid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_item_by_merchant_item_id(self, merchant_item_id, **kwargs):  # noqa: E501
        """Retrieve an item by item id  # noqa: E501

        Retrieves a single item using the specified item id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_by_merchant_item_id(merchant_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str merchant_item_id: The item id to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: ItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_item_by_merchant_item_id_with_http_info(merchant_item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_item_by_merchant_item_id_with_http_info(merchant_item_id, **kwargs)  # noqa: E501
            return data

    def get_item_by_merchant_item_id_with_http_info(self, merchant_item_id, **kwargs):  # noqa: E501
        """Retrieve an item by item id  # noqa: E501

        Retrieves a single item using the specified item id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_item_by_merchant_item_id_with_http_info(merchant_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str merchant_item_id: The item id to retrieve. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: ItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['merchant_item_id', 'expand', 'placeholders']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item_by_merchant_item_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'merchant_item_id' is set
        if ('merchant_item_id' not in params or
                params['merchant_item_id'] is None):
            raise ValueError("Missing the required parameter `merchant_item_id` when calling `get_item_by_merchant_item_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'merchant_item_id' in params:
            path_params['merchant_item_id'] = params['merchant_item_id']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501
        if 'placeholders' in params:
            query_params.append(('_placeholders', params['placeholders']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/item/items/merchant_item_id/{merchant_item_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_items(self, **kwargs):  # noqa: E501
        """Retrieve items  # noqa: E501

        Retrieves a group of items from the account.  If no parameters are specified, all items will be returned.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_items(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int parent_category_id: The parent category object id to retrieve items for.  Unspecified means all items on the account.  0 = root
        :param str parent_category_path: The parent category path to retrieve items for.  Unspecified means all items on the account.  / = root
        :param int limit: The maximum number of records to return on this one API call. (Default 100, Max 2000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str since: Fetch items that have been created/modified since this date/time.
        :param str sort: The sort order of the items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: ItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_items_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_items_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_items_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve items  # noqa: E501

        Retrieves a group of items from the account.  If no parameters are specified, all items will be returned.  You will need to make multiple API calls in order to retrieve the entire result set since this API performs result set pagination.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_items_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int parent_category_id: The parent category object id to retrieve items for.  Unspecified means all items on the account.  0 = root
        :param str parent_category_path: The parent category path to retrieve items for.  Unspecified means all items on the account.  / = root
        :param int limit: The maximum number of records to return on this one API call. (Default 100, Max 2000)
        :param int offset: Pagination of the record set.  Offset is a zero based index.
        :param str since: Fetch items that have been created/modified since this date/time.
        :param str sort: The sort order of the items.  See Sorting documentation for examples of using multiple values and sorting by ascending and descending.
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: ItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['parent_category_id', 'parent_category_path', 'limit', 'offset', 'since', 'sort', 'expand', 'placeholders']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_items" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'parent_category_id' in params:
            query_params.append(('parent_category_id', params['parent_category_id']))  # noqa: E501
        if 'parent_category_path' in params:
            query_params.append(('parent_category_path', params['parent_category_path']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('_limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('_offset', params['offset']))  # noqa: E501
        if 'since' in params:
            query_params.append(('_since', params['since']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('_sort', params['sort']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501
        if 'placeholders' in params:
            query_params.append(('_placeholders', params['placeholders']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/item/items', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pricing_tiers(self, **kwargs):  # noqa: E501
        """Retrieve pricing tiers  # noqa: E501

        Retrieves the pricing tiers   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pricing_tiers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: PricingTiersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pricing_tiers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_pricing_tiers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_pricing_tiers_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve pricing tiers  # noqa: E501

        Retrieves the pricing tiers   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pricing_tiers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :return: PricingTiersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pricing_tiers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/item/pricing_tiers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PricingTiersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_item(self, item, **kwargs):  # noqa: E501
        """Create an item  # noqa: E501

        Create a new item on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_item(item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Item item: Item to create (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: ItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_item_with_http_info(item, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_item_with_http_info(item, **kwargs)  # noqa: E501
            return data

    def insert_item_with_http_info(self, item, **kwargs):  # noqa: E501
        """Create an item  # noqa: E501

        Create a new item on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_item_with_http_info(item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Item item: Item to create (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: ItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item', 'expand', 'placeholders']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item' is set
        if ('item' not in params or
                params['item'] is None):
            raise ValueError("Missing the required parameter `item` when calling `insert_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501
        if 'placeholders' in params:
            query_params.append(('_placeholders', params['placeholders']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item' in params:
            body_params = params['item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/item/items', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_item(self, item, merchant_item_oid, **kwargs):  # noqa: E501
        """Update an item  # noqa: E501

        Update a new item on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_item(item, merchant_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Item item: Item to update (required)
        :param int merchant_item_oid: The item oid to update. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: ItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_item_with_http_info(item, merchant_item_oid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_item_with_http_info(item, merchant_item_oid, **kwargs)  # noqa: E501
            return data

    def update_item_with_http_info(self, item, merchant_item_oid, **kwargs):  # noqa: E501
        """Update an item  # noqa: E501

        Update a new item on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_item_with_http_info(item, merchant_item_oid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Item item: Item to update (required)
        :param int merchant_item_oid: The item oid to update. (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :return: ItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item', 'merchant_item_oid', 'expand', 'placeholders']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item' is set
        if ('item' not in params or
                params['item'] is None):
            raise ValueError("Missing the required parameter `item` when calling `update_item`")  # noqa: E501
        # verify the required parameter 'merchant_item_oid' is set
        if ('merchant_item_oid' not in params or
                params['merchant_item_oid'] is None):
            raise ValueError("Missing the required parameter `merchant_item_oid` when calling `update_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'merchant_item_oid' in params:
            path_params['merchant_item_oid'] = params['merchant_item_oid']  # noqa: E501

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501
        if 'placeholders' in params:
            query_params.append(('_placeholders', params['placeholders']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'item' in params:
            body_params = params['item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/item/items/{merchant_item_oid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_items(self, items_request, **kwargs):  # noqa: E501
        """Update multiple items  # noqa: E501

        Update multiple item on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_items(items_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ItemsRequest items_request: Items to update (synchronous maximum 20 / asynchronous maximum 100) (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :param bool _async: True if the operation should be run async.  No result returned
        :return: ItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_items_with_http_info(items_request, **kwargs)  # noqa: E501
        else:
            (data) = self.update_items_with_http_info(items_request, **kwargs)  # noqa: E501
            return data

    def update_items_with_http_info(self, items_request, **kwargs):  # noqa: E501
        """Update multiple items  # noqa: E501

        Update multiple item on the UltraCart account.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_items_with_http_info(items_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ItemsRequest items_request: Items to update (synchronous maximum 20 / asynchronous maximum 100) (required)
        :param str expand: The object expansion to perform on the result.  See documentation for examples
        :param bool placeholders: Whether or not placeholder values should be returned in the result.  Useful for UIs that consume this REST API.
        :param bool _async: True if the operation should be run async.  No result returned
        :return: ItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['items_request', 'expand', 'placeholders', '_async']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'items_request' is set
        if ('items_request' not in params or
                params['items_request'] is None):
            raise ValueError("Missing the required parameter `items_request` when calling `update_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'expand' in params:
            query_params.append(('_expand', params['expand']))  # noqa: E501
        if 'placeholders' in params:
            query_params.append(('_placeholders', params['placeholders']))  # noqa: E501
        if '_async' in params:
            query_params.append(('_async', params['_async']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'items_request' in params:
            body_params = params['items_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/item/items/batch', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ItemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_temporary_multimedia(self, file, **kwargs):  # noqa: E501
        """Upload an image to the temporary multimedia.  # noqa: E501

        Uploads an image and returns back meta information about the image as well as the identifier needed for the item update.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_temporary_multimedia(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: File to upload (required)
        :return: TempMultimediaResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_temporary_multimedia_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_temporary_multimedia_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def upload_temporary_multimedia_with_http_info(self, file, **kwargs):  # noqa: E501
        """Upload an image to the temporary multimedia.  # noqa: E501

        Uploads an image and returns back meta information about the image as well as the identifier needed for the item update.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_temporary_multimedia_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: File to upload (required)
        :return: TempMultimediaResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_temporary_multimedia" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `upload_temporary_multimedia`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/item/temp_multimedia', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TempMultimediaResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
