# coding: utf-8

"""
    UltraCart Rest API V2

    UltraCart REST API Version 2  # noqa: E501

    OpenAPI spec version: 2.0.0
    Contact: support@ultracart.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ultracart.api_client import ApiClient
from ultracart.configuration import Configuration

class FulfillmentApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    @classmethod
    def fromApiKey(cls, apiKey, verify_ssl = True, debug = False):
        config = Configuration()
        config.api_key['x-ultracart-simple-key'] = apiKey
        config.debug = debug
        config.verify_ssl = verify_ssl

        api_client = ApiClient(configuration=config, header_name='X-UltraCart-Api-Version', header_value='2017-03-01')
        return FulfillmentApi(api_client)




    def acknowledge_orders(self, distribution_center_code, order_ids, **kwargs):  # noqa: E501
        """Acknowledge receipt of orders.  # noqa: E501

        Acknowledge receipt of orders so that they are removed from the fulfillment queue.  This method must be called after receiving and order (via webhook) or retrieving (via retrieve orders method).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.acknowledge_orders(distribution_center_code, order_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :param list[str] order_ids: Orders to acknowledge receipt of (limit 100) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.acknowledge_orders_with_http_info(distribution_center_code, order_ids, **kwargs)  # noqa: E501
        else:
            (data) = self.acknowledge_orders_with_http_info(distribution_center_code, order_ids, **kwargs)  # noqa: E501
            return data

    def acknowledge_orders_with_http_info(self, distribution_center_code, order_ids, **kwargs):  # noqa: E501
        """Acknowledge receipt of orders.  # noqa: E501

        Acknowledge receipt of orders so that they are removed from the fulfillment queue.  This method must be called after receiving and order (via webhook) or retrieving (via retrieve orders method).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.acknowledge_orders_with_http_info(distribution_center_code, order_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :param list[str] order_ids: Orders to acknowledge receipt of (limit 100) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['distribution_center_code', 'order_ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method acknowledge_orders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'distribution_center_code' is set
        if ('distribution_center_code' not in params or
                params['distribution_center_code'] is None):
            raise ValueError("Missing the required parameter `distribution_center_code` when calling `acknowledge_orders`")  # noqa: E501
        # verify the required parameter 'order_ids' is set
        if ('order_ids' not in params or
                params['order_ids'] is None):
            raise ValueError("Missing the required parameter `order_ids` when calling `acknowledge_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'distribution_center_code' in params:
            path_params['distribution_center_code'] = params['distribution_center_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'order_ids' in params:
            body_params = params['order_ids']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/fulfillment/distribution_centers/{distribution_center_code}/acknowledgements', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_packing_slip(self, distribution_center_code, order_id, **kwargs):  # noqa: E501
        """Generate a packing slip for this order for the given distribution center.  # noqa: E501

        The packing slip PDF that is returned is base 64 encoded   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_packing_slip(distribution_center_code, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :param str order_id: Order ID (required)
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_packing_slip_with_http_info(distribution_center_code, order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_packing_slip_with_http_info(distribution_center_code, order_id, **kwargs)  # noqa: E501
            return data

    def generate_packing_slip_with_http_info(self, distribution_center_code, order_id, **kwargs):  # noqa: E501
        """Generate a packing slip for this order for the given distribution center.  # noqa: E501

        The packing slip PDF that is returned is base 64 encoded   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_packing_slip_with_http_info(distribution_center_code, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :param str order_id: Order ID (required)
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['distribution_center_code', 'order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_packing_slip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'distribution_center_code' is set
        if ('distribution_center_code' not in params or
                params['distribution_center_code'] is None):
            raise ValueError("Missing the required parameter `distribution_center_code` when calling `generate_packing_slip`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if ('order_id' not in params or
                params['order_id'] is None):
            raise ValueError("Missing the required parameter `order_id` when calling `generate_packing_slip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'distribution_center_code' in params:
            path_params['distribution_center_code'] = params['distribution_center_code']  # noqa: E501
        if 'order_id' in params:
            path_params['order_id'] = params['order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/fulfillment/distribution_centers/{distribution_center_code}/orders/{order_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_distribution_center_orders(self, distribution_center_code, **kwargs):  # noqa: E501
        """Retrieve orders queued up for this distribution center.  # noqa: E501

        Retrieves up to 100 orders that are queued up in this distribution center.  You must acknowledge them before additional new orders will be returned.  There is NO record chunking.  You'll get the same 100 records again and again until you acknowledge orders.  The orders that are returned contain only items for this distribution center and are by default completely expanded with billing, buysafe, channel_partner, checkout, coupons, customer_profile, edi, gift, gift_certificate, internal, items, payment, shipping, summary, taxes.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_distribution_center_orders(distribution_center_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_distribution_center_orders_with_http_info(distribution_center_code, **kwargs)  # noqa: E501
        else:
            (data) = self.get_distribution_center_orders_with_http_info(distribution_center_code, **kwargs)  # noqa: E501
            return data

    def get_distribution_center_orders_with_http_info(self, distribution_center_code, **kwargs):  # noqa: E501
        """Retrieve orders queued up for this distribution center.  # noqa: E501

        Retrieves up to 100 orders that are queued up in this distribution center.  You must acknowledge them before additional new orders will be returned.  There is NO record chunking.  You'll get the same 100 records again and again until you acknowledge orders.  The orders that are returned contain only items for this distribution center and are by default completely expanded with billing, buysafe, channel_partner, checkout, coupons, customer_profile, edi, gift, gift_certificate, internal, items, payment, shipping, summary, taxes.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_distribution_center_orders_with_http_info(distribution_center_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['distribution_center_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_distribution_center_orders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'distribution_center_code' is set
        if ('distribution_center_code' not in params or
                params['distribution_center_code'] is None):
            raise ValueError("Missing the required parameter `distribution_center_code` when calling `get_distribution_center_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'distribution_center_code' in params:
            path_params['distribution_center_code'] = params['distribution_center_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/fulfillment/distribution_centers/{distribution_center_code}/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_distribution_centers(self, **kwargs):  # noqa: E501
        """Retrieve distribution centers  # noqa: E501

        Retrieves the distribution centers that this user has access to.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_distribution_centers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: DistributionCentersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_distribution_centers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_distribution_centers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_distribution_centers_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve distribution centers  # noqa: E501

        Retrieves the distribution centers that this user has access to.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_distribution_centers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: DistributionCentersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_distribution_centers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/fulfillment/distribution_centers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DistributionCentersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ship_orders(self, distribution_center_code, shipments, **kwargs):  # noqa: E501
        """Mark orders as shipped  # noqa: E501

        Store the tracking information and mark the order shipped for this distribution center.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ship_orders(distribution_center_code, shipments, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :param list[FulfillmentShipment] shipments: Orders to mark shipped (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ship_orders_with_http_info(distribution_center_code, shipments, **kwargs)  # noqa: E501
        else:
            (data) = self.ship_orders_with_http_info(distribution_center_code, shipments, **kwargs)  # noqa: E501
            return data

    def ship_orders_with_http_info(self, distribution_center_code, shipments, **kwargs):  # noqa: E501
        """Mark orders as shipped  # noqa: E501

        Store the tracking information and mark the order shipped for this distribution center.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ship_orders_with_http_info(distribution_center_code, shipments, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :param list[FulfillmentShipment] shipments: Orders to mark shipped (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['distribution_center_code', 'shipments']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ship_orders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'distribution_center_code' is set
        if ('distribution_center_code' not in params or
                params['distribution_center_code'] is None):
            raise ValueError("Missing the required parameter `distribution_center_code` when calling `ship_orders`")  # noqa: E501
        # verify the required parameter 'shipments' is set
        if ('shipments' not in params or
                params['shipments'] is None):
            raise ValueError("Missing the required parameter `shipments` when calling `ship_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'distribution_center_code' in params:
            path_params['distribution_center_code'] = params['distribution_center_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'shipments' in params:
            body_params = params['shipments']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/fulfillment/distribution_centers/{distribution_center_code}/shipments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_inventory(self, distribution_center_code, inventories, **kwargs):  # noqa: E501
        """Update inventory  # noqa: E501

        Update the inventory for items associated with this distribution center   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_inventory(distribution_center_code, inventories, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :param list[FulfillmentInventory] inventories: Inventory updates (limit 500) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_inventory_with_http_info(distribution_center_code, inventories, **kwargs)  # noqa: E501
        else:
            (data) = self.update_inventory_with_http_info(distribution_center_code, inventories, **kwargs)  # noqa: E501
            return data

    def update_inventory_with_http_info(self, distribution_center_code, inventories, **kwargs):  # noqa: E501
        """Update inventory  # noqa: E501

        Update the inventory for items associated with this distribution center   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_inventory_with_http_info(distribution_center_code, inventories, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str distribution_center_code: Distribution center code (required)
        :param list[FulfillmentInventory] inventories: Inventory updates (limit 500) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['distribution_center_code', 'inventories']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_inventory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'distribution_center_code' is set
        if ('distribution_center_code' not in params or
                params['distribution_center_code'] is None):
            raise ValueError("Missing the required parameter `distribution_center_code` when calling `update_inventory`")  # noqa: E501
        # verify the required parameter 'inventories' is set
        if ('inventories' not in params or
                params['inventories'] is None):
            raise ValueError("Missing the required parameter `inventories` when calling `update_inventory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'distribution_center_code' in params:
            path_params['distribution_center_code'] = params['distribution_center_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inventories' in params:
            body_params = params['inventories']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ultraCartOauth', 'ultraCartSimpleApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/fulfillment/distribution_centers/{distribution_center_code}/inventory', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
